DROP TABLE IF EXISTS `cbs_bookings`;
CREATE TABLE IF NOT EXISTS `cbs_bookings` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uuid` varchar(255) default NULL,
  `event_id` int(10) unsigned DEFAULT NULL,
  `date_time` datetime default NULL,
  `sub_total` decimal(9,2) unsigned default NULL,
  `tax` decimal(9,2) unsigned default NULL,
  `total` decimal(9,2) unsigned default NULL,
  `deposit` decimal(9,2) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') default NULL,
  `status` enum('confirmed','cancelled','pending') default 'pending',
  `txn_id` varchar(255) default NULL,
  `processed_on` datetime default NULL,
  `created` datetime default NULL,
  `is_sent` enum('T','F') default 'F',
  `ip` varchar(255) default NULL,
  `c_title` varchar(255) default NULL,
  `c_name` varchar(255) default NULL,
  `c_phone` varchar(255) default NULL,
  `c_email` varchar(255) default NULL,
  `c_company` varchar(255) default NULL,
  `c_notes` text default NULL,
  `c_address` varchar(255) default NULL,
  `c_city` varchar(255) default NULL,
  `c_state` varchar(255) default NULL,
  `c_zip` varchar(255) default NULL,
  `c_country` int(10) unsigned default NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_bookings_shows`;
CREATE TABLE IF NOT EXISTS `cbs_bookings_shows` (
  `booking_id` int(10) unsigned NOT NULL,	
  `show_id` int(10) unsigned NOT NULL,
  `seat_id` int(10) unsigned NOT NULL,
  `price_id` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `cnt` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`show_id`,`seat_id`,`booking_id`),
  KEY `show_id` (`show_id`),
  KEY `seat_id` (`seat_id`),
  KEY `booking_id` (`booking_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_bookings_tickets`;
CREATE TABLE IF NOT EXISTS `cbs_bookings_tickets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) DEFAULT NULL,
  `ticket_id` varchar(50) DEFAULT NULL,
  `price_id` int(10) DEFAULT NULL,
  `seat_id` int(10) DEFAULT NULL,
  `unit_price` decimal(9,2) unsigned DEFAULT NULL,
  `is_used` enum('T','F') NOT NULL DEFAULT 'F',
  PRIMARY KEY (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `price_id` (`price_id`),
  KEY `seat_id` (`seat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_bookings_payments`;
CREATE TABLE IF NOT EXISTS `cbs_bookings_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `booking_id` int(10) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_events`;
CREATE TABLE IF NOT EXISTS `cbs_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `duration` varchar(10) DEFAULT NULL,
  `released_date` date DEFAULT NULL,
  `event_img` varchar(255) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_shows`;
CREATE TABLE IF NOT EXISTS `cbs_shows` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned NOT NULL,
  `venue_id` int(10) unsigned NOT NULL,
  `price_id` int(10) unsigned NOT NULL,
  `price` decimal(9,2) DEFAULT NULL,
  `date_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `event_id` (`event_id`),
  KEY `venue_id` (`venue_id`),
  KEY `price_id` (`price_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_shows_seats`;
CREATE TABLE IF NOT EXISTS `cbs_shows_seats` (
  `show_id` int(10) unsigned NOT NULL,
  `seat_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`show_id`, `seat_id`),
  KEY `show_id` (`show_id`),
  KEY `seat_id` (`seat_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_prices`;
CREATE TABLE IF NOT EXISTS `cbs_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned DEFAULT NULL,  
  PRIMARY KEY (`id`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_venues`;
CREATE TABLE IF NOT EXISTS `cbs_venues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `map_path` varchar(255) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `map_name` varchar(255) DEFAULT NULL,
  `seats_count` int(10) unsigned DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_seats`;
CREATE TABLE IF NOT EXISTS `cbs_seats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `venue_id` int(10) unsigned DEFAULT NULL,
  `width` smallint(5) unsigned DEFAULT NULL,
  `height` smallint(5) unsigned DEFAULT NULL,
  `top` smallint(5) unsigned DEFAULT NULL,
  `left` smallint(5) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `seats` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `venue_id` (`venue_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_password`;
CREATE TABLE IF NOT EXISTS `cbs_password` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_fields`;
CREATE TABLE IF NOT EXISTS `cbs_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_multi_lang`;
CREATE TABLE IF NOT EXISTS `cbs_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_options`;
CREATE TABLE IF NOT EXISTS `cbs_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_roles`;
CREATE TABLE IF NOT EXISTS `cbs_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_users`;
CREATE TABLE IF NOT EXISTS `cbs_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `cbs_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnAddBooking', 'backend', 'Button / + Add booking', 'script', '2016-07-28 03:52:42'),
(7, 'btnAddHall', 'backend', 'Button / + Add hall', 'script', '2016-07-28 03:44:28'),
(8, 'btnAddMovie', 'backend', 'Button / + Add movie', 'script', '2016-07-28 03:49:12'),
(9, 'btnAddUser', 'backend', 'Button / + Add user', 'script', '2016-07-28 03:36:30'),
(10, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(11, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(12, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(13, 'btnCheck', 'backend', 'Button / Check', 'script', NULL),
(14, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(15, 'btnCreateInvoice', 'backend', 'Button / Create Invoice', 'script', '2015-12-09 03:23:26'),
(16, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(17, 'btnDeleteMap', 'backend', 'Buttons / Delete map', 'script', NULL),
(18, 'btnExport', 'backend', 'Button / Export', 'script', NULL),
(19, 'btnGetFeedURL', 'backend', 'Button / Get Feed URL', 'script', NULL),
(20, 'btnLogin', 'backend', 'Login', 'script', NULL),
(21, 'btnNextDay', 'backend', 'Button / Next day', 'script', NULL),
(22, 'btnNextHour', 'backend', 'Button / Next hour', 'script', NULL),
(23, 'btnNextWeek', 'backend', 'Button / Next week', 'script', NULL),
(24, 'btnPrint', 'backend', 'Button / Print', 'script', NULL),
(25, 'btnRemove', 'backend', 'Button / Remove', 'script', NULL),
(26, 'btnReset', 'backend', 'Reset', 'script', NULL),
(27, 'btnSave', 'backend', 'Save', 'script', NULL),
(28, 'btnSearch', 'backend', 'Search', 'script', NULL),
(29, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(30, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(31, 'btnUseThisTheme', 'backend', 'Label / Use this theme', 'script', '2016-07-28 02:12:41'),
(32, 'created', 'backend', 'Created', 'script', NULL),
(33, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(34, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(35, 'email', 'backend', 'E-Mail', 'script', NULL),
(36, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(37, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(38, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(39, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(40, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(41, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(42, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(43, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(44, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(45, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(46, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(47, 'gridEmptyBody', 'backend', 'Grid / No records selected', 'script', NULL),
(48, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(49, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(50, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(51, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(52, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(53, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(54, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(55, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(56, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(57, 'infoAddBookingDesc', 'backend', 'Infobox / Add New Booking', 'script', NULL),
(58, 'infoAddBookingTitle', 'backend', 'Infobox / Add New Booking', 'script', NULL),
(59, 'infoAddEventDesc', 'backend', 'Infobox / Add new event', 'script', NULL),
(60, 'infoAddEventTitle', 'backend', 'Infobox / Add new event', 'script', NULL),
(61, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', '2016-07-28 03:40:51'),
(62, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', '2016-07-28 03:40:31'),
(63, 'infoAddVenueDesc', 'backend', 'Label / Add new venue', 'script', NULL),
(64, 'infoAddVenueTitle', 'backend', 'Label / Add new venue', 'script', NULL),
(65, 'infoBarcodeReaderDesc', 'backend', 'Infobox / Barcode reader', 'script', NULL),
(66, 'infoBarcodeReaderTitle', 'backend', 'Infobox / Barcode reader', 'script', NULL),
(67, 'infoBookingFormDesc', 'backend', 'Infobox / Booking form', 'script', NULL),
(68, 'infoBookingFormTitle', 'backend', 'Infobox / Booking form', 'script', NULL),
(69, 'infoBookingsDesc', 'backend', 'Infobox / Booking options', 'script', NULL),
(70, 'infoBookingsListDesc', 'backend', 'Infobox / List of bookings', 'script', NULL),
(71, 'infoBookingsListTitle', 'backend', 'Infobox / List of bookings', 'script', NULL),
(72, 'infoBookingsTitle', 'backend', 'Infobox / Booking options', 'script', NULL),
(73, 'infoEventBookingsDesc', 'backend', 'Infobox / List of bookings', 'script', NULL),
(74, 'infoEventBookingsTitle', 'backend', 'Infobox / List of bookings', 'script', NULL),
(75, 'infoEventPriceDesc', 'backend', 'Infobox / Prices', 'script', NULL),
(76, 'infoEventPriceTitle', 'backend', 'Infobox / Tickets', 'script', NULL),
(77, 'infoEventsDesc', 'backend', 'Infobox / List of events', 'script', NULL),
(78, 'infoEventsTitle', 'backend', 'Infobox / List of events', 'script', NULL),
(79, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(80, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(81, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(82, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(83, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(84, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(85, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(86, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(87, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(88, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(89, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(90, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(91, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(92, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(93, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(94, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(95, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(96, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(97, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(98, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(99, 'infoMoviesFeedDesc', 'backend', 'Infobox / Movies Feed URL', 'script', NULL),
(100, 'infoMoviesFeedTitle', 'backend', 'Infobox / Movies Feed URL', 'script', NULL),
(101, 'infoPreviewDesc', 'backend', 'Infobox / Preview front end', 'script', '2016-07-28 02:08:29'),
(102, 'infoPreviewTitle', 'backend', 'Infobox / Preview front end', 'script', '2016-07-28 02:08:08'),
(103, 'infoResendDesc', 'backend', 'Infobox / Resend tickets', 'script', NULL),
(104, 'infoResendTitle', 'backend', 'Infobox / Resend tickets', 'script', NULL),
(105, 'infoScheduleDesc', 'backend', 'Infobox / Schedule', 'script', NULL),
(106, 'infoScheduleTitle', 'backend', 'Infobox / Schedule', 'script', NULL),
(107, 'infoSectorDesc', 'backend', 'Infobox / Sectors', 'script', NULL),
(108, 'infoSectorTitle', 'backend', 'Infobox / Sectors', 'script', NULL),
(109, 'infoTermsDesc', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(110, 'infoTermsTitle', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(111, 'infoTicketDesc', 'backend', 'Infobox / Ticket setting', 'script', NULL),
(112, 'infoTicketTitle', 'backend', 'Infobox / Ticket setting', 'script', NULL),
(113, 'infoToAdministratorsDesc', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(114, 'infoToAdministratorsTitle', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(115, 'infoToCustomersDesc', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(116, 'infoToCustomersTitle', 'backend', 'Infobox / ', 'script', NULL),
(117, 'infoUpdateBookingDesc', 'backend', 'Infobox / Update booking', 'script', NULL),
(118, 'infoUpdateBookingTitle', 'backend', 'Infobox / Update booking', 'script', NULL),
(119, 'infoUpdateEventDesc', 'backend', 'Infobox / Details', 'script', NULL),
(120, 'infoUpdateEventTitle', 'backend', 'Infobox / Details', 'script', NULL),
(121, 'infoUpdateShowDesc', 'backend', 'Infobox / Shows', 'script', NULL),
(122, 'infoUpdateShowTitle', 'backend', 'Infobox / Shows', 'script', NULL),
(123, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', '2016-07-28 03:43:06'),
(124, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', '2016-07-28 03:42:47'),
(125, 'infoUpdateVenueDesc', 'backend', 'Infobox / Update venue', 'script', NULL),
(126, 'infoUpdateVenueTitle', 'backend', 'Infobox / Update venue', 'script', NULL),
(127, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', '2016-07-28 03:37:40'),
(128, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', '2016-07-28 03:37:06'),
(129, 'infoVenuesDesc', 'backend', 'Infobox / List of venues', 'script', NULL),
(130, 'infoVenuesTitle', 'backend', 'Infobox / List of venues', 'script', NULL),
(131, 'lblActive', 'backend', 'Label / Active', 'script', NULL),
(132, 'lblAddBooking', 'backend', 'Label / Add booking', 'script', NULL),
(133, 'lblAddEvent', 'backend', 'Label / Add event', 'script', NULL),
(134, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(135, 'lblAddVenue', 'backend', 'Label / Add venue', 'script', NULL),
(136, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(137, 'lblAvailableSeats', 'backend', 'Label / Available seats', 'script', NULL),
(138, 'lblAvailableTokens', 'backend', 'Label / Available tokens', 'script', '2016-07-28 03:09:27'),
(139, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(140, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(141, 'lblBarcodeDetails', 'backend', 'Label / Barcode Details', 'script', NULL),
(142, 'lblBookedSeats', 'backend', 'Label / Booked seats', 'script', NULL),
(143, 'lblBooking', 'backend', 'Label / booking', 'script', NULL),
(144, 'lblBookingAddress', 'backend', 'Label / Address', 'script', NULL),
(145, 'lblBookingCity', 'backend', 'Label / City', 'script', NULL),
(146, 'lblBookingCompany', 'backend', 'Label / Company', 'script', NULL),
(147, 'lblBookingCountry', 'backend', 'Label / Country', 'script', NULL),
(148, 'lblBookingDetails', 'backend', 'Label / Booking details', 'script', NULL),
(149, 'lblBookingEmail', 'backend', 'Label / Email', 'script', NULL),
(150, 'lblBookingIDExists', 'backend', 'Label / Booking with such ID already exists.', 'script', NULL),
(151, 'lblBookingMadeToday', 'backend', 'Label / booking made today', 'script', NULL),
(152, 'lblBookingName', 'backend', 'Label / Name', 'script', NULL),
(153, 'lblBookingNotes', 'backend', 'Label / Notes', 'script', NULL),
(154, 'lblBookingPhone', 'backend', 'Label / Phone', 'script', NULL),
(155, 'lblBookings', 'backend', 'Button / Bookings', 'script', NULL),
(156, 'lblBookingsMadeToday', 'backend', 'Label / bookings made today', 'script', NULL),
(157, 'lblBookingsNotFound', 'backend', 'Label / Bookings not found', 'script', NULL),
(158, 'lblBookingState', 'backend', 'Label / State', 'script', NULL),
(159, 'lblBookingTitle', 'backend', 'Label / Title', 'script', NULL),
(160, 'lblBookingZip', 'backend', 'Label / Zip', 'script', NULL),
(161, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(162, 'lblCCExp', 'backend', 'Label / CC expiration', 'script', NULL),
(163, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(164, 'lblCCType', 'backend', 'Label / CC type', 'script', NULL),
(165, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(166, 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', '2016-07-28 02:09:21'),
(167, 'lblClientDetails', 'backend', 'Label / Client details', 'script', NULL),
(168, 'lblConfirmationEmail', 'backend', 'Label / Confirmation email', 'script', NULL),
(169, 'lblCreatedOn', 'backend', 'Label / Created on', 'script', NULL),
(170, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', '2016-06-23 09:55:08'),
(171, 'lblDashboardHall', 'backend', 'Label / hall', 'script', NULL),
(172, 'lblDashboardHalls', 'backend', 'Label / halls', 'script', NULL),
(173, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(174, 'lblDate', 'backend', 'Label / Date', 'script', NULL),
(175, 'lblDateTime', 'backend', 'Label / Date & time', 'script', NULL),
(176, 'lblDays', 'backend', 'Days', 'script', NULL),
(177, 'lblDefineSeats', 'backend', 'Label / Define seats', 'script', NULL),
(178, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(179, 'lblDeleteConfirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(180, 'lblDeleteImage', 'backend', 'Label / Delete image', 'script', NULL),
(181, 'lblDeleteImageConfirm', 'backend', 'Label / Delete image confirmation', 'script', NULL),
(182, 'lblDeleteMapConfirm', 'backend', 'Buttons / Delete map', 'script', NULL),
(183, 'lblDeleteShowConfirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(184, 'lblDeleteTicket', 'backend', 'Label / Delete ticket', 'script', NULL),
(185, 'lblDeleteTicketConfirm', 'backend', 'Label / Delete ticket confirmation', 'script', NULL),
(186, 'lblDeposit', 'backend', 'Label / Deposit', 'script', NULL),
(187, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(188, 'lblDetails', 'backend', 'Labl / Details', 'script', NULL),
(189, 'lblDuplicatedShowtimesDesc', 'backend', 'Label / Duplicated showtimes', 'script', NULL),
(190, 'lblDuplicatedShowtimesTitle', 'backend', 'Label / Duplicated showtimes', 'script', NULL),
(191, 'lblDuration', 'backend', 'Label / Duration', 'script', NULL),
(192, 'lblDurationGreaterThanZero', 'backend', 'Label / Duration must be greater than 0.', 'script', NULL),
(193, 'lblEditBooking', 'backend', 'Label / Edit booking', 'script', NULL),
(194, 'lblEmail', 'backend', 'Label / Email', 'script', NULL),
(195, 'lblEnterPassword', 'backend', 'Label / Enter password', 'script', NULL),
(196, 'lblError', 'backend', 'Error', 'script', NULL),
(197, 'lblEvent', 'backend', 'Label / Event', 'script', NULL),
(198, 'lblExport', 'backend', 'Export', 'script', NULL),
(199, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(200, 'lblFormat', 'backend', 'Label / Format', 'script', NULL),
(201, 'lblFrom', 'backend', 'Label / from', 'script', NULL),
(202, 'lblHeight', 'backend', 'Label / Height', 'script', '2016-05-31 10:39:33'),
(203, 'lblHour', 'backend', 'Label / Hour', 'script', NULL),
(204, 'lblID', 'backend', 'Label / ID', 'script', NULL),
(205, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(206, 'lblInactive', 'backend', 'Label / Inactive', 'script', NULL),
(207, 'lblInstallConfig', 'backend', 'Label / Language options', 'script', NULL),
(208, 'lblInstallConfigHide', 'backend', 'Label / Hide language selector ', 'script', NULL),
(209, 'lblInstallConfigLocale', 'backend', 'Label / Language', 'script', NULL),
(210, 'lblInstallJs1_body', 'backend', 'Label / Install code', 'script', NULL),
(211, 'lblInstallJs1_title', 'backend', 'Label / Install code', 'script', NULL),
(212, 'lblInvalidDate', 'backend', 'Label / Invalid date! No movies found.', 'script', NULL),
(213, 'lblIp', 'backend', 'IP address', 'script', NULL),
(214, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(215, 'lblLatestBookings', 'backend', 'Label / Latest bookings', 'script', NULL),
(216, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(217, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(218, 'lblMap', 'backend', 'Label / Map', 'script', NULL),
(219, 'lblMaxAttendants', 'backend', 'Label / Max attendants', 'script', NULL),
(220, 'lblMessage', 'backend', 'Label / Message', 'script', NULL),
(221, 'lblMinutes', 'backend', 'Label / minutes', 'script', NULL),
(222, 'lblMovie', 'backend', 'Label / Movie', 'script', NULL),
(223, 'lblMovies', 'backend', 'Label / Movies', 'script', NULL),
(224, 'lblMoviesFeedURL', 'backend', 'Label / Movies Feed URL', 'script', NULL),
(225, 'lblMovieShowingToday', 'backend', 'Label / movie showing today', 'script', NULL),
(226, 'lblMoviesNotFound', 'backend', 'Label / No movies found', 'script', NULL),
(227, 'lblMoviesShowingToday', 'backend', 'Label / movies showing today', 'script', NULL),
(228, 'lblName', 'backend', 'Name', 'script', NULL),
(229, 'lblNextMovies', 'backend', 'Label / Next movies', 'script', NULL),
(230, 'lblNextTicketType', 'backend', 'Label / Next ticket type', 'script', NULL),
(231, 'lblNo', 'backend', 'No', 'script', NULL),
(232, 'lblNoAccessToFeed', 'backend', 'Label / No access to feed', 'script', NULL),
(233, 'lblNoEventFound', 'backend', 'Label / No events found', 'script', NULL),
(234, 'lblNowShowing', 'backend', 'Label / Now showing', 'script', NULL),
(235, 'lblOption', 'backend', 'Option', 'script', NULL),
(236, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(237, 'lblPaymentEmail', 'backend', 'Label / Payment email', 'script', NULL),
(238, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(239, 'lblPeopleWatching', 'backend', 'Label / people watching', 'script', NULL),
(240, 'lblPersonWatching', 'backend', 'Label / person watching', 'script', NULL),
(241, 'lblPhone', 'backend', 'Label / Phone', 'script', '2016-07-28 03:39:03'),
(242, 'lblPluralBooking', 'backend', 'Label / bookings', 'script', NULL),
(243, 'lblPluralTickets', 'backend', 'Label / tickets', 'script', '2016-07-29 02:36:00'),
(244, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(245, 'lblPrint', 'backend', 'Label / Print', 'script', NULL),
(246, 'lblPrintTickets', 'backend', 'Label / Print tickets', 'script', NULL),
(247, 'lblRemoveSeats', 'backend', 'Label / click on a seat above to remove it', 'script', NULL),
(248, 'lblResendTickets', 'backend', 'Label / Resend tickets', 'script', NULL),
(249, 'lblRole', 'backend', 'Role', 'script', NULL),
(250, 'lblSeatCountGreaterThanZero', 'backend', 'Label / Number of seats must be greater than zero.', 'script', NULL),
(251, 'lblSeatNumbers', 'backend', 'Label / Seat numbers', 'script', NULL),
(252, 'lblSeatNumbersRequired', 'backend', 'Label / You need to enter all numbers/IDs.', 'script', NULL),
(253, 'lblSeatNumbersText1', 'backend', 'Label / Seat numbers', 'script', NULL),
(254, 'lblSeatNumbersText2', 'backend', 'Label / Seat numbers', 'script', NULL),
(255, 'lblSeats', 'backend', 'Label / Seat(s)', 'script', NULL),
(256, 'lblSeatsCount', 'backend', 'Label / Number of seats', 'script', NULL),
(257, 'lblSeatsMap', 'backend', 'Label / Seats map', 'script', NULL),
(258, 'lblSectors', 'backend', 'Labl / Sectors', 'script', NULL),
(259, 'lblSelectAvailableSeats', 'backend', 'Label / Select available seats', 'script', NULL),
(260, 'lblSelectedSeats', 'backend', 'Label / Selected seats', 'script', NULL),
(261, 'lblSelectMoreSeats', 'backend', 'Label / Please select more seats.', 'script', NULL),
(262, 'lblSelectSeats', 'backend', 'Label / Select seats', 'script', NULL),
(263, 'lblSelectSeatsHint', 'backend', 'Label / Select seats hint', 'script', NULL),
(264, 'lblSetHotspotSize', 'backend', 'Label / set hotspot size', 'script', '2016-05-31 10:31:26'),
(265, 'lblShow', 'backend', 'Label / Show', 'script', NULL),
(266, 'lblShowNotFound', 'backend', 'Label / No shows found', 'script', NULL),
(267, 'lblShows', 'backend', 'Button / Shows', 'script', NULL),
(268, 'lblShowtime', 'backend', 'Label / Showtime', 'script', NULL),
(269, 'lblSigularTicket', 'backend', 'Label / ticket', 'script', '2016-07-29 02:36:29'),
(270, 'lblSingularTicket', 'backend', 'Label / ticket', 'script', NULL),
(271, 'lblStatus', 'backend', 'Status', 'script', NULL),
(272, 'lblStatusDuplicated', 'backend', 'Label / Duplicated showtimes', 'script', '2015-11-02 06:53:38'),
(273, 'lblStatusEnd', 'backend', 'Label / Showtimes have been saved.', 'script', '2015-11-02 10:51:07'),
(274, 'lblStatusFail', 'backend', 'Label / Showtimes could not be saved.', 'script', '2015-11-02 06:54:00'),
(275, 'lblStatusStart', 'backend', 'Label / Please wait while showtimes are saving...', 'script', '2015-11-02 06:54:24'),
(276, 'lblStatusTitle', 'backend', 'Label / Status', 'script', '2015-11-02 06:51:41'),
(277, 'lblSubject', 'backend', 'Label / Subject', 'script', NULL),
(278, 'lblSubTotal', 'backend', 'Label / Sub-total', 'script', NULL),
(279, 'lblTabInvoices', 'backend', 'Tab / Invoices', 'script', '2015-12-09 02:55:05'),
(280, 'lblTax', 'backend', 'Label / Tax', 'script', NULL),
(281, 'lblTicket', 'backend', 'Label / Ticket', 'script', NULL),
(282, 'lblTicketConfirmationDesc', 'backend', 'Label / Ticket confirmation', 'script', NULL),
(283, 'lblTicketConfirmationTitle', 'backend', 'Label / Ticket confirmation', 'script', NULL),
(284, 'lblTickets', 'backend', 'Label / Tickets', 'script', NULL),
(285, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(286, 'lblTo', 'backend', 'Label / to', 'script', NULL),
(287, 'lblToAdministrators', 'backend', 'Label / To administrators', 'script', NULL),
(288, 'lblToCustomers', 'backend', 'Label / To customers', 'script', NULL),
(289, 'lblToday', 'backend', 'Label / Today', 'script', NULL),
(290, 'lblTomorrow', 'backend', 'Label / Tomorrow', 'script', NULL),
(291, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(292, 'lblTotalBookings', 'backend', 'Label / Total bookings', 'script', NULL),
(293, 'lblTotalPrice', 'backend', 'Label / Total price', 'script', NULL),
(294, 'lblTotalSeats', 'backend', 'Label / Total seats', 'script', NULL),
(295, 'lblType', 'backend', 'Type', 'script', NULL),
(296, 'lblUpdateBooking', 'backend', 'Label / Update booking', 'script', NULL),
(297, 'lblUpdateEvent', 'backend', 'Button / Update event', 'script', NULL),
(298, 'lblUpdateMapDesc', 'backend', 'Label/ Update map', 'script', NULL),
(299, 'lblUpdateMapTitle', 'backend', 'Label/ Update map', 'script', NULL),
(300, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(301, 'lblUpdateVenue', 'backend', 'Label / Update venue', 'script', NULL),
(302, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(303, 'lblUserSeatsMap', 'backend', 'Label / Use seats map', 'script', NULL),
(304, 'lblUseTicket', 'backend', 'Label / Use ticket', 'script', NULL),
(305, 'lblValue', 'backend', 'Value', 'script', NULL),
(306, 'lblVenue', 'backend', 'Label / Venue', 'script', NULL),
(307, 'lblWidth', 'backend', 'Label / Width', 'script', '2016-05-31 10:39:15'),
(308, 'lblYes', 'backend', 'Yes', 'script', NULL),
(309, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(310, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(311, 'locales', 'backend', 'Languages', 'script', NULL),
(312, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(313, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(314, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(315, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(316, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(317, 'menuBookingForm', 'backend', 'Menu / Booking form', 'script', NULL),
(318, 'menuBookings', 'backend', 'Menu / Bookings', 'script', NULL),
(319, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(320, 'menuEvents', 'backend', 'Menu / Events', 'script', NULL),
(321, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(322, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(323, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(324, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(325, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(326, 'menuNotifications', 'backend', 'Menu / Notifications', 'script', NULL),
(327, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(328, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(329, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(330, 'menuPreviewInstall', 'backend', 'Menu / Preview & Install', 'script', '2016-07-28 02:03:23'),
(331, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(332, 'menuSchedule', 'backend', 'Menu / Schedule', 'script', NULL),
(333, 'menuTerms', 'backend', 'Menu / Terms', 'script', NULL),
(334, 'menuTicket', 'backend', 'Menu / Ticket', 'script', NULL),
(335, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(336, 'menuVenues', 'backend', 'Menu / Venues', 'script', NULL),
(337, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(338, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / New booking SMS', 'script', NULL),
(339, 'opt_o_admin_sms_confirmation_message_text', 'backend', 'Options / New booking SMS', 'script', NULL),
(340, 'opt_o_admin_sms_payment_message', 'backend', 'Options / Payment confirmation SMS', 'script', NULL),
(341, 'opt_o_admin_sms_payment_message_text', 'backend', 'Options / Payment confirmation SMS', 'script', NULL),
(342, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net ', 'script', NULL),
(343, 'opt_o_allow_bank', 'backend', 'Options / Provide Bank account details for wire transfers', 'script', NULL),
(344, 'opt_o_allow_cash', 'backend', 'Options / Allow payment with cash', 'script', NULL),
(345, 'opt_o_allow_creditcard', 'backend', 'Options / Collect Credit Card details for offline processing', 'script', NULL),
(346, 'opt_o_allow_paypal', 'backend', 'Options / Allow payments with PayPal', 'script', NULL),
(347, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL),
(348, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(349, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL),
(350, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(351, 'opt_o_bank_account', 'backend', 'Options / Bank Account', 'script', NULL),
(352, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(353, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(354, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(355, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(356, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(357, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(358, 'opt_o_bf_include_name', 'backend', 'Options / Name', 'script', NULL),
(359, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(360, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(361, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(362, 'opt_o_bf_include_title', 'backend', 'Options / Title', 'script', NULL),
(363, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(364, 'opt_o_booking_earlier', 'backend', 'Options / Book X minutes before the movie', 'script', NULL),
(365, 'opt_o_booking_earlier_text', 'backend', 'Options / Book X hours before the event', 'script', NULL),
(366, 'opt_o_booking_status', 'backend', 'Options / Default booking status', 'script', NULL),
(367, 'opt_o_booking_status_text', 'backend', 'Options / Default booking status', 'script', NULL),
(368, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(369, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(370, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(371, 'opt_o_deposit_payment_text', 'backend', 'Options / Deposit payment', 'script', NULL),
(372, 'opt_o_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(373, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(374, 'opt_o_email_cancel_message_text', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(375, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(376, 'opt_o_email_confirmation', 'backend', 'Options / New booking received email', 'script', NULL),
(377, 'opt_o_email_confirmation_message', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(378, 'opt_o_email_confirmation_message_text', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(379, 'opt_o_email_confirmation_subject', 'backend', 'Options / New booking confirmation subject', 'script', NULL),
(380, 'opt_o_email_confirmation_text', 'backend', 'Options / New booking received email', 'script', NULL),
(381, 'opt_o_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(382, 'opt_o_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(383, 'opt_o_email_payment_message_text', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(384, 'opt_o_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(385, 'opt_o_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(386, 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
(387, 'opt_o_payment_disable', 'backend', 'Options / Payment disable', 'script', NULL),
(388, 'opt_o_payment_status', 'backend', 'Options / Default payment status', 'script', NULL),
(389, 'opt_o_paypal_address', 'backend', 'Options / PayPal business email address', 'script', NULL),
(390, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(391, 'opt_o_send_pdf_ticket', 'backend', 'Options / Send PDF ticket', 'script', NULL),
(392, 'opt_o_sms_confirmation_message', 'backend', 'Options / Booking reminder SMS', 'script', NULL),
(393, 'opt_o_sms_confirmation_message_text', 'backend', 'Options / Booking reminder SMS', 'script', NULL),
(394, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(395, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(396, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(397, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(398, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(399, 'opt_o_tax_payment_text', 'backend', 'Options / Tax payment', 'script', NULL),
(400, 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL),
(401, 'opt_o_thank_you_page', 'backend', 'Options / Thank you page', 'script', NULL),
(402, 'opt_o_ticket_data', 'backend', 'Options / Ticket data', 'script', NULL),
(403, 'opt_o_ticket_data_text', 'backend', 'Options / Ticket data', 'script', NULL),
(404, 'opt_o_ticket_image', 'backend', 'Options / Ticket', 'script', NULL),
(405, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(406, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(407, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(408, 'pass', 'backend', 'Password', 'script', NULL),
(409, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(410, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(411, 'tabBarcodeReader', 'backend', 'Tab / Barcode reader', 'script', NULL),
(412, 'tb_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(413, 'tb_seats_required', 'backend', 'Label / You have to set up at least one seat on the map.', 'script', NULL),
(414, 'url', 'backend', 'URL', 'script', NULL),
(415, 'user', 'backend', 'Username', 'script', NULL),
(416, 'front_available', 'frontend', 'Label / Available', 'script', NULL),
(417, 'front_back', 'frontend', 'Label / Back', 'script', NULL),
(418, 'front_bank_account', 'frontend', 'Label / Bank account', 'script', NULL),
(419, 'front_blocked', 'frontend', 'Label / Blocked', 'script', NULL),
(420, 'front_booking_created', 'frontend', 'Label / Booking created', 'script', NULL),
(421, 'front_button_cancel', 'frontend', 'Button / Cancel', 'script', NULL),
(422, 'front_button_confirm', 'frontend', 'Button / Cancel', 'script', NULL),
(423, 'front_button_confirm_booking', 'frontend', 'Button / Confirm Booking', 'script', NULL),
(424, 'front_button_continue', 'frontend', 'Button / Continue', 'script', NULL),
(425, 'front_button_purchase_tickets', 'frontend', 'Button / Purchase tickets', 'script', NULL),
(426, 'front_button_start_over', 'frontend', 'Button / Start over', 'script', NULL),
(427, 'front_cancel_booking_id', 'frontend', 'Label / Booking ID', 'script', NULL),
(428, 'front_cancel_booking_seats', 'frontend', 'Label / Booking seats', 'script', NULL),
(429, 'front_cancel_date_time', 'frontend', 'Label / Event date & time', 'script', NULL),
(430, 'front_cancel_event', 'frontend', 'Label / Event', 'script', NULL),
(431, 'front_cancel_heading', 'frontend', 'Button / Your booking details', 'script', NULL),
(432, 'front_cancel_tickets', 'frontend', 'Label / Tickets & prices', 'script', NULL),
(433, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(434, 'front_cc_exp', 'frontend', 'Label / CC expiration', 'script', NULL),
(435, 'front_cc_num', 'frontend', 'Label / CC number', 'script', NULL),
(436, 'front_cc_sec', 'frontend', 'Label / CC code', 'script', NULL),
(437, 'front_cc_type', 'frontend', 'Label / CC type', 'script', NULL),
(438, 'front_current_month', 'frontend', 'Label / Current month', 'script', '2016-06-01 07:43:15'),
(439, 'front_customer_address', 'frontend', 'Label / Address', 'script', NULL),
(440, 'front_customer_city', 'frontend', 'Label / City', 'script', NULL),
(441, 'front_customer_company', 'frontend', 'Label / Company', 'script', NULL),
(442, 'front_customer_country', 'frontend', 'Label / Country', 'script', NULL),
(443, 'front_customer_email', 'frontend', 'Label / Email', 'script', NULL),
(444, 'front_customer_name', 'frontend', 'Label / Name', 'script', NULL),
(445, 'front_customer_notes', 'frontend', 'Label / Notes', 'script', NULL),
(446, 'front_customer_phone', 'frontend', 'Label / Phone', 'script', NULL),
(447, 'front_customer_state', 'frontend', 'Label / State', 'script', NULL),
(448, 'front_customer_title', 'frontend', 'Label / Title', 'script', NULL),
(449, 'front_customer_zip', 'frontend', 'Label / Zip', 'script', NULL),
(450, 'front_date', 'frontend', 'Label / Date', 'script', NULL),
(451, 'front_deposit', 'frontend', 'Label / Deposit', 'script', NULL),
(452, 'front_dropdown_choose', 'frontend', 'Label / Choose', 'script', NULL),
(453, 'front_fill_details', 'frontend', 'Label / Fill in your details', 'script', NULL),
(454, 'front_hall', 'frontend', 'Label / Hall', 'script', '2016-02-15 03:20:34'),
(455, 'front_how_to_remove_seats', 'frontend', 'Label / click on selected seats below to remove it', 'script', NULL),
(456, 'front_label_payment_medthod', 'frontend', 'Label / Payment method', 'script', NULL),
(457, 'front_label_processed_on', 'frontend', 'Label / Processed on', 'script', NULL),
(458, 'front_label_txn_id', 'frontend', 'Label / Paypal Transaction ID', 'script', NULL),
(459, 'front_minutes', 'frontend', 'Label / Minutes', 'script', NULL),
(460, 'front_movie', 'frontend', 'Label / Movie', 'script', NULL),
(461, 'front_na', 'frontend', 'Label / N/A', 'script', NULL),
(462, 'front_no_events_found', 'frontend', 'Label / No movies found', 'script', NULL),
(463, 'front_no_seats_available', 'frontend', 'Label / No available seats', 'script', NULL),
(464, 'front_no_shows_on_selected_date', 'frontend', 'Label / No shows on selected date.', 'script', NULL),
(465, 'front_payment_information', 'frontend', 'Label / Payment information', 'script', NULL),
(466, 'front_payment_method', 'frontend', 'Label / Payment method', 'script', NULL),
(467, 'front_personal_details', 'frontend', 'Button / Personal details', 'script', NULL),
(468, 'front_placeholder_address', 'frontend', 'Label / Your address', 'script', NULL),
(469, 'front_placeholder_city', 'frontend', 'Label / City', 'script', NULL),
(470, 'front_placeholder_company', 'frontend', 'Label / Company name', 'script', NULL),
(471, 'front_placeholder_email', 'frontend', 'Label / Your email', 'script', NULL),
(472, 'front_placeholder_name', 'frontend', 'Label / Your name', 'script', NULL),
(473, 'front_placeholder_notes', 'frontend', 'Label / Notes', 'script', NULL),
(474, 'front_placeholder_phone', 'frontend', 'Label / Phone number', 'script', NULL),
(475, 'front_placeholder_state', 'frontend', 'Label / State', 'script', NULL),
(476, 'front_placeholder_zip', 'frontend', 'Label / Postal code', 'script', NULL),
(477, 'front_running_time', 'frontend', 'Label / Running time', 'script', NULL),
(478, 'front_selected', 'frontend', 'Label / Selected', 'script', NULL),
(479, 'front_selected_date', 'frontend', 'Label / Selected date', 'script', NULL),
(480, 'front_selected_seats', 'frontend', 'Label / Selected seat(s)', 'script', NULL),
(481, 'front_select_available_seats', 'frontend', 'Label / click on available seats to select it', 'script', NULL),
(482, 'front_select_date', 'frontend', 'Label / Select date', 'script', NULL),
(483, 'front_select_ticket_types_above', 'frontend', 'Label / Select ticket types above', 'script', NULL),
(484, 'front_select_time', 'frontend', 'Label / Select time', 'script', '2016-07-27 10:00:49'),
(485, 'front_start_over_message', 'frontend', 'Label / Start over', 'script', NULL),
(486, 'front_sub_total', 'frontend', 'Label / Sub-total', 'script', NULL),
(487, 'front_tax', 'frontend', 'Label / Tax', 'script', NULL),
(488, 'front_terms', 'frontend', 'Label / Accept terms of booking', 'script', NULL),
(489, 'front_terms_title', 'frontend', 'Label / Terms and conditions', 'script', NULL),
(490, 'front_time', 'frontend', 'Label / Time', 'script', NULL),
(491, 'front_today', 'frontend', 'Label / Today', 'script', NULL),
(492, 'front_tomorrow', 'frontend', 'Label / Tomorrow', 'script', NULL),
(493, 'front_total', 'frontend', 'Label / Total', 'script', NULL),
(494, 'front_total_price', 'frontend', 'Label / Total price', 'script', NULL),
(495, 'front_your_details', 'frontend', 'Label / Your details', 'script', NULL),
(496, 'system_109', 'frontend', 'Label / Missing parameters', 'script', NULL),
(497, 'system_110', 'frontend', 'Label / Missing or wrong captcha.', 'script', NULL),
(498, 'system_118', 'frontend', 'Label / System message', 'script', '2016-05-13 06:51:47'),
(499, 'system_119', 'frontend', 'Label / System message', 'script', NULL),
(500, 'system_211', 'frontend', 'Label / Checkout submitted', 'script', NULL),
(501, 'admin_sms_arr_ARRAY_confirmation', 'arrays', 'admin_sms_arr_ARRAY_confirmation', 'script', '2016-07-28 02:55:56'),
(502, 'admin_sms_arr_ARRAY_payment', 'arrays', 'admin_sms_arr_ARRAY_payment', 'script', '2016-07-28 02:56:20'),
(503, 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(504, 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(505, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(506, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(507, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(508, 'buttons_ARRAY_no', 'arrays', 'buttons_ARRAY_no', 'script', NULL),
(509, 'buttons_ARRAY_ok', 'arrays', 'buttons_ARRAY_ok', 'script', NULL),
(510, 'buttons_ARRAY_save', 'arrays', 'buttons_ARRAY_save', 'script', NULL),
(511, 'buttons_ARRAY_set', 'arrays', 'buttons_ARRAY_set', 'script', '2016-05-31 10:35:29'),
(512, 'buttons_ARRAY_yes', 'arrays', 'buttons_ARRAY_yes', 'script', NULL),
(513, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(514, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(515, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(516, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(517, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(518, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(519, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(520, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(521, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(522, 'client_notify_arr_ARRAY_cancel', 'arrays', 'client_notify_arr_ARRAY_cancel', 'script', '2016-07-28 02:44:43'),
(523, 'client_notify_arr_ARRAY_confirmation', 'arrays', 'client_notify_arr_ARRAY_confirmation', 'script', '2016-07-28 02:43:45'),
(524, 'client_notify_arr_ARRAY_payment', 'arrays', 'client_notify_arr_ARRAY_payment', 'script', '2016-07-28 02:44:13'),
(525, 'coming_arr_ARRAY_1', 'arrays', 'coming_arr_ARRAY_1', 'script', NULL),
(526, 'coming_arr_ARRAY_2', 'arrays', 'coming_arr_ARRAY_2', 'script', NULL),
(527, 'coming_arr_ARRAY_3', 'arrays', 'coming_arr_ARRAY_3', 'script', NULL),
(528, 'coming_arr_ARRAY_4', 'arrays', 'coming_arr_ARRAY_4', 'script', NULL),
(529, 'coming_arr_ARRAY_5', 'arrays', 'coming_arr_ARRAY_5', 'script', NULL),
(530, 'coming_arr_ARRAY_6', 'arrays', 'coming_arr_ARRAY_6', 'script', NULL),
(531, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(532, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(533, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(534, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(535, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(536, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(537, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(538, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(539, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(540, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(541, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(542, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(543, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(544, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(545, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(546, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(547, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(548, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(549, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(550, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(551, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(552, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(553, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(554, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(555, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(556, 'error_bodies_ARRAY_AE05', 'arrays', 'error_bodies_ARRAY_AE05', 'script', NULL),
(557, 'error_bodies_ARRAY_AE06', 'arrays', 'error_bodies_ARRAY_AE06', 'script', NULL),
(558, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(559, 'error_bodies_ARRAY_AE09', 'arrays', 'error_bodies_ARRAY_AE09', 'script', NULL),
(560, 'error_bodies_ARRAY_AE10', 'arrays', 'error_bodies_ARRAY_AE10', 'script', NULL),
(561, 'error_bodies_ARRAY_AE11', 'arrays', 'error_bodies_ARRAY_AE11', 'script', NULL),
(562, 'error_bodies_ARRAY_AE12', 'arrays', 'error_bodies_ARRAY_AE12', 'script', NULL),
(563, 'error_bodies_ARRAY_AE13', 'arrays', 'error_bodies_ARRAY_AE13', 'script', NULL),
(564, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(565, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(566, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(567, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(568, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(569, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(570, 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', NULL),
(571, 'error_bodies_ARRAY_AO07', 'arrays', 'error_bodies_ARRAY_AO07', 'script', NULL),
(572, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(573, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(574, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(575, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(576, 'error_bodies_ARRAY_AR10', 'arrays', 'error_bodies_ARRAY_AR10', 'script', NULL),
(577, 'error_bodies_ARRAY_AR21', 'arrays', 'error_bodies_ARRAY_AR21', 'script', NULL),
(578, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(579, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(580, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(581, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(582, 'error_bodies_ARRAY_AV01', 'arrays', 'error_bodies_ARRAY_AV01', 'script', NULL),
(583, 'error_bodies_ARRAY_AV03', 'arrays', 'error_bodies_ARRAY_AV03', 'script', NULL),
(584, 'error_bodies_ARRAY_AV04', 'arrays', 'error_bodies_ARRAY_AV04', 'script', NULL),
(585, 'error_bodies_ARRAY_AV05', 'arrays', 'error_bodies_ARRAY_AV05', 'script', NULL),
(586, 'error_bodies_ARRAY_AV06', 'arrays', 'error_bodies_ARRAY_AV06', 'script', NULL),
(587, 'error_bodies_ARRAY_AV08', 'arrays', 'error_bodies_ARRAY_AV08', 'script', NULL),
(588, 'error_bodies_ARRAY_AV09', 'arrays', 'error_bodies_ARRAY_AV09', 'script', NULL),
(589, 'error_bodies_ARRAY_AV10', 'arrays', 'error_bodies_ARRAY_AV10', 'script', NULL),
(590, 'error_bodies_ARRAY_AV11', 'arrays', 'error_bodies_ARRAY_AV11', 'script', NULL),
(591, 'error_bodies_ARRAY_AV12', 'arrays', 'error_bodies_ARRAY_AV12', 'script', NULL),
(592, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(593, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(594, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(595, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(596, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(597, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(598, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(599, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(600, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(601, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(602, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(603, 'error_titles_ARRAY_AE05', 'arrays', 'error_titles_ARRAY_AE05', 'script', NULL),
(604, 'error_titles_ARRAY_AE06', 'arrays', 'error_titles_ARRAY_AE06', 'script', NULL),
(605, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
(606, 'error_titles_ARRAY_AE09', 'arrays', 'error_titles_ARRAY_AE09', 'script', NULL),
(607, 'error_titles_ARRAY_AE10', 'arrays', 'error_titles_ARRAY_AE10', 'script', NULL),
(608, 'error_titles_ARRAY_AE11', 'arrays', 'error_titles_ARRAY_AE11', 'script', NULL),
(609, 'error_titles_ARRAY_AE12', 'arrays', 'error_titles_ARRAY_AE12', 'script', NULL),
(610, 'error_titles_ARRAY_AE13', 'arrays', 'error_titles_ARRAY_AE13', 'script', NULL),
(611, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(612, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(613, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(614, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(615, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(616, 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', NULL),
(617, 'error_titles_ARRAY_AO07', 'arrays', 'error_titles_ARRAY_AO07', 'script', NULL),
(618, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(619, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(620, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(621, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(622, 'error_titles_ARRAY_AR10', 'arrays', 'error_titles_ARRAY_AR10', 'script', NULL),
(623, 'error_titles_ARRAY_AR21', 'arrays', 'error_titles_ARRAY_AR21', 'script', NULL),
(624, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(625, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(626, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(627, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(628, 'error_titles_ARRAY_AV01', 'arrays', 'error_titles_ARRAY_AV01', 'script', NULL),
(629, 'error_titles_ARRAY_AV03', 'arrays', 'error_titles_ARRAY_AV03', 'script', NULL),
(630, 'error_titles_ARRAY_AV04', 'arrays', 'error_titles_ARRAY_AV04', 'script', NULL),
(631, 'error_titles_ARRAY_AV05', 'arrays', 'error_titles_ARRAY_AV05', 'script', NULL),
(632, 'error_titles_ARRAY_AV06', 'arrays', 'error_titles_ARRAY_AV06', 'script', NULL),
(633, 'error_titles_ARRAY_AV08', 'arrays', 'error_titles_ARRAY_AV08', 'script', NULL),
(634, 'error_titles_ARRAY_AV09', 'arrays', 'error_titles_ARRAY_AV09', 'script', NULL),
(635, 'error_titles_ARRAY_AV10', 'arrays', 'error_titles_ARRAY_AV10', 'script', NULL),
(636, 'error_titles_ARRAY_AV11', 'arrays', 'error_titles_ARRAY_AV11', 'script', NULL),
(637, 'error_titles_ARRAY_AV12', 'arrays', 'error_titles_ARRAY_AV12', 'script', NULL),
(638, 'export_formats_ARRAY_csv', 'arrays', 'export_formats_ARRAY_csv', 'script', NULL),
(639, 'export_formats_ARRAY_ical', 'arrays', 'export_formats_ARRAY_ical', 'script', NULL),
(640, 'export_formats_ARRAY_xml', 'arrays', 'export_formats_ARRAY_xml', 'script', NULL),
(641, 'export_periods_ARRAY_last', 'arrays', 'export_periods_ARRAY_last', 'script', NULL),
(642, 'export_periods_ARRAY_next', 'arrays', 'export_periods_ARRAY_next', 'script', NULL),
(643, 'export_types_ARRAY_feed', 'arrays', 'export_types_ARRAY_feed', 'script', NULL),
(644, 'export_types_ARRAY_file', 'arrays', 'export_types_ARRAY_file', 'script', NULL),
(645, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(646, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(647, 'front_booking_statuses_ARRAY_1', 'arrays', 'front_booking_statuses_ARRAY_1', 'script', NULL),
(648, 'front_booking_statuses_ARRAY_11', 'arrays', 'front_booking_statuses_ARRAY_11', 'script', NULL),
(649, 'front_err_ARRAY_empty', 'arrays', 'front_err_ARRAY_empty', 'script', NULL),
(650, 'front_err_ARRAY_enough', 'arrays', 'front_err_ARRAY_enough', 'script', NULL),
(651, 'front_err_ARRAY_not_enough', 'arrays', 'front_err_ARRAY_not_enough', 'script', NULL),
(652, 'front_err_ARRAY_no_tickets', 'arrays', 'front_err_ARRAY_no_tickets', 'script', NULL),
(653, 'front_guide_ARRAY_continue', 'arrays', 'front_guide_ARRAY_continue', 'script', NULL),
(654, 'front_guide_ARRAY_select_seats_for', 'arrays', 'front_guide_ARRAY_select_seats_for', 'script', NULL),
(655, 'front_guide_ARRAY_select_seat_for', 'arrays', 'front_guide_ARRAY_select_seat_for', 'script', NULL),
(656, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(657, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(658, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(659, 'made_arr_ARRAY_1', 'arrays', 'made_arr_ARRAY_1', 'script', NULL),
(660, 'made_arr_ARRAY_2', 'arrays', 'made_arr_ARRAY_2', 'script', NULL),
(661, 'made_arr_ARRAY_3', 'arrays', 'made_arr_ARRAY_3', 'script', NULL),
(662, 'made_arr_ARRAY_4', 'arrays', 'made_arr_ARRAY_4', 'script', NULL),
(663, 'made_arr_ARRAY_5', 'arrays', 'made_arr_ARRAY_5', 'script', NULL),
(664, 'made_arr_ARRAY_6', 'arrays', 'made_arr_ARRAY_6', 'script', NULL),
(665, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(666, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(667, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(668, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(669, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(670, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(671, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(672, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(673, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(674, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(675, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(676, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(677, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(678, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(679, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(680, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(681, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(682, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(683, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(684, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(685, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(686, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(687, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(688, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(689, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(690, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(691, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(692, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(693, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(694, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(695, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(696, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(697, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(698, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(699, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(700, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(701, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(702, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(703, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(704, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(705, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(706, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(707, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(708, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(709, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(710, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(711, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(712, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(713, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(714, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(715, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(716, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(717, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(718, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(719, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(720, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(721, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(722, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(723, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(724, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(725, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(726, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(727, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(728, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(729, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(730, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(731, 'ticket_statuses_ARRAY_1', 'arrays', 'ticket_statuses_ARRAY_1', 'script', NULL),
(732, 'ticket_statuses_ARRAY_2', 'arrays', 'ticket_statuses_ARRAY_2', 'script', NULL),
(733, 'ticket_statuses_ARRAY_3', 'arrays', 'ticket_statuses_ARRAY_3', 'script', NULL),
(734, 'ticket_statuses_ARRAY_4', 'arrays', 'ticket_statuses_ARRAY_4', 'script', NULL),
(735, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(736, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(737, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(738, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(739, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(740, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(741, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(742, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(743, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(744, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(745, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(746, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(747, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(748, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(749, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(750, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(751, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(752, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(753, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(754, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(755, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(756, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(757, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(758, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(759, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(760, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(761, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(762, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(763, 'validate_ARRAY_address', 'arrays', 'validate_ARRAY_address', 'script', NULL),
(764, 'validate_ARRAY_captcha', 'arrays', 'validate_ARRAY_captcha', 'script', NULL),
(765, 'validate_ARRAY_captcha_wrong', 'arrays', 'validate_ARRAY_captcha_wrong', 'script', NULL),
(766, 'validate_ARRAY_cc_code', 'arrays', 'validate_ARRAY_cc_code', 'script', '2015-12-24 06:28:40'),
(767, 'validate_ARRAY_cc_number', 'arrays', 'validate_ARRAY_cc_number', 'script', '2015-12-24 06:29:14'),
(768, 'validate_ARRAY_cc_type', 'arrays', 'validate_ARRAY_cc_type', 'script', '2015-12-24 06:29:47'),
(769, 'validate_ARRAY_city', 'arrays', 'validate_ARRAY_city', 'script', NULL),
(770, 'validate_ARRAY_company', 'arrays', 'validate_ARRAY_company', 'script', NULL),
(771, 'validate_ARRAY_country', 'arrays', 'validate_ARRAY_country', 'script', NULL),
(772, 'validate_ARRAY_email', 'arrays', 'validate_ARRAY_email', 'script', NULL),
(773, 'validate_ARRAY_email_invalid', 'arrays', 'validate_ARRAY_email_invalid', 'script', NULL),
(774, 'validate_ARRAY_name', 'arrays', 'validate_ARRAY_name', 'script', NULL),
(775, 'validate_ARRAY_notes', 'arrays', 'validate_ARRAY_notes', 'script', NULL),
(776, 'validate_ARRAY_payment_method', 'arrays', 'validate_ARRAY_payment_method', 'script', '2015-12-24 06:31:12'),
(777, 'validate_ARRAY_phone', 'arrays', 'validate_ARRAY_phone', 'script', NULL),
(778, 'validate_ARRAY_state', 'arrays', 'validate_ARRAY_state', 'script', NULL),
(779, 'validate_ARRAY_terms', 'arrays', 'validate_ARRAY_terms', 'script', NULL),
(780, 'validate_ARRAY_title', 'arrays', 'validate_ARRAY_title', 'script', NULL),
(781, 'validate_ARRAY_zip', 'arrays', 'validate_ARRAY_zip', 'script', NULL),
(782, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(783, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL);

INSERT INTO `cbs_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '+ Add booking', 'script'),
(NULL, 7, 'pjField', 1, 'title', '+ Add hall', 'script'),
(NULL, 8, 'pjField', 1, 'title', '+ Add movie', 'script'),
(NULL, 9, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 10, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Check', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Create Invoice', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Delete map', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Get Feed URL', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Next day', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Next hour', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Next week', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 54, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Use the form below to manually add new booking. You need to fill in the required data in both tabs, Booking Details and Client Details. The system will calculate the total amount automatically.', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Add New Booking', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Enter movie title, description, duration and image. You can also upload ticket image which will be used to generate ticket(s) for each booking.', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Add new movie', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Fill in the form below and "save" to add a new user.', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Use the form below to add a new hall. You can upload and manage a seat map for the hall. This will allow your customers to select specific seats on the map during the booking process. To upload a seat map use the browse button below and click on "Save" button. Only images in JPG file format are accepted. Once you upload the seat map you can define hot spots for the exact seats. If you don''t want to use a seats map then just define the number of seats available for this hall. In this case the system will automatically assign available seats to each booking and ticket.', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Add new hall', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Use your bar code scanner to read the barcodes and fill in the ticket ID into the text below. Then click on Check button to read ticket details and confirm it.', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Barcode reader', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the booking form, otherwise select ''No''.', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Here you can choose your payment methods and set payment gateway accounts and payment preferences. Note that for cash payments the system will not be able to collect deposit amount online.', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Here you can see the list of bookings. To see more details of each booking, click on the Pencil icon on the corresponding row.', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Booking options', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Below you can see the list of bookings made for this movie. You can also print that list.', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'You can add different tickets (e.g. Adult, Children, ...) for the event. Just click on ADD button and enter new ticket.', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Here you can see the list of movies. To add a new movie, click on the ''Add movie'' tab. In order to see more details or edit movie information, click on the ''Pencil'' icon on the corresponding row.', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'List of movies', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Here you can set the General options for the Cinema Booking System.', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Use the URL below to have access to all movices. Please, note that if you change the password the URL will change too as password is used in the URL itself so no one else can open it.', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Movies Feed URL', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use.', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Preview front end', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'You are about to re-send the confirmation email and tickets to client who made the booking. Please click on the button Send of which email you refer to.', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Resend tickets', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Below is the schedule of all events that will happen in a certain date. You can change the selected date via the date picker. You also print the schedule as desired.', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Now Showing', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Here you can put custom name for each of the seats on your map. You can also set number of bookings that each seat can take. This is useful if you want to add a sector with multiple tickets - for example football stadium where instead of tickets for exact seats, tickets are sold for sectors.', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Sectors', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Please write down the Terms and Conditions for making booking and click SAVE button.', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Here you can set the template for printing PDF ticket. There are several available tokens.', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Ticket setting', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Set the automated email notifications sent to the script admins. You can use the available tokens to personalize the messages. Please note that if you wish to use the SMS notification you need to set SMS valid API Key at SMS tab. ', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Notifications sent to script administrators', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Below you can create different types of auto-responders triggered by different events, such as new booking notification, payment received and more. You can use the available tokens to personalize your message. Please note that if you wish to use the SMS notification you need to set SMS valid API Key at SMS tab.', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Notifications sent to customers', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Use the from below to update the selected booking. Note that booking details and client details are separated into two tabs. ', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Update booking', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Here you can update details information of the event.', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Using the form below you can manage showtimes for the movie. You can select date & time, hall where movie will be showing, ticket type and exact seats that can be booked for selected ticket type.', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Showtimes', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update the user information.', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Use the form below to edit the hall. If you have uploaded a seat map you can either delete it (then you will have to set the "Number of seats" value) or manage it. To make the map active for users you need to set the available seats on the map. Just click on the map and a blue rectangle titled "1" will show. You can place the rectangle where appropriate via drag & drop. You can also change its size: point the cursor at rectangle''s border, click and drag to the resize it. The rectangle added represents one seat on the map. Customers will be able to select seats by clicking on these rectangles during the booking process. You can add as many rectangles as your hall has. The system will automatically count the number of seats this hall has after saving the changes. You can also click on each of these hotspots and define extra options for each - seat ID and number of bookings it may take. This is useful if you want to define sectors in your hall, instead of exact seats. In that case you can set halls which can take 10,20... or as many seats as you need.', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Update hall', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'You can see below the list of users. If you want to add new user, click on the button "+ Add user".', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Below is a list of all halls in the cinema. For each you can define the number of seats and/or a seat map. Customers will be able to select exact seats that they want to book.', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'List of halls', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Add booking', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Add movie', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Add hall', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Available seats', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Use the tokens below to personalize your email messages. <br/><br/><div class="float_left w200">{Name}<br/>{Email}<br/>{Phone}<br/>{Country}<br/>{Address}<br/>{Notes}<br/>{Movie}<br/>{MovieID}</div><div class="float_left w250">{Showtime}<br/>{BookingID}<br/>{CinemaHall<br/>{BookingSeats}<br/>{Tickets}<br/>{Deposit}<br/>{Total}<br/>{Tax}<br/></div><div class="float_left w200">{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>{TicketPrice}<br/>{PDFticket}</div>', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Barcode Details', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Booked seats', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'booking', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Booking details', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Booking with such ID already exists.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'booking made today', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'bookings made today', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Bookings not found', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Choose theme', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Confirmation email', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Created on', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'hall', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'halls', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Showtime', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Once you upload the image you will be able to define seats.', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Are you sure that you want to delete the image?', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'If the map is deleted, all of seats you defined for this map will be removed as well. Are you sure that you want to delete the map?', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Are you sure that you want to delete the selected show?', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Delete ticket', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Are you sure that you want to delete the ticket image?', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Please check again for duplicated showtimes.', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Duplicated showtimes', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Duration time is invalid.', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Edit booking', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Enter password', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Movie', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Format', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'from', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Height', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Hour', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Language options', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Hide language selector ', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Language', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Copy the code below and put it on your web page. It will show the front end booking engine. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Invalid date! No movies found.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Latest bookings', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Map', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Max attendants', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'minutes', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Movie', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Movies', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Movies Feed URL', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'movie showing today', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'No movies found', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'movies showing today', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Next movies', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Next ticket type', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'No access to feed', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'No movies found', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Now showing', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'Payment email', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'people watching', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'person watching', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'bookings', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'tickets', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Print tickets', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'click on a seat above to remove it', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Resend tickets', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Number of seats must be greater than zero.', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Seat numbers', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'You need to enter all numbers/IDs.', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Enter amount of seats to set actual seat numbers.', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Enter actual numbers/IDs for all the seats that you have.', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Seat(s)', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Number of seats', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Seats map', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Sectors', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'click on available seat on the map to reserve it', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Selected seats', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Please select more seats.', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Select seats', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Please click on seat(s) you want to book. If you change your mind, let click on the selected seats again. Finally, please click on OK button to complete. ', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'set hotspot size', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Show', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'No shows found', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Showtimes', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Showtime', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'ticket', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'ticket', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Please check again for duplicated showtimes.', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'Showtimes have been saved.', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'Showtimes could not be saved.', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Please wait while showtimes are saving...', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Invoices', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Ticket', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Are you sure that you want to set this ticket as used.', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Ticket confirmation', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'to', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'To administrators', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'To customers', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Tomorrow', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Total bookings', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Total price', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Total seats', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Update booking', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Update movie', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Add a custom name for this spot on the map (VIP sector, Sector A, etc..). Also set how many available seats can be reserved in this sector.', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Update map', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Update hall', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Use seats map', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Use ticket', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Hall', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Width', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Movies', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Now Showing', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Ticket', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Cinema Halls', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'New booking SMS', 'script'),
(NULL, 339, 'pjField', 1, 'title', '<u>Available tokens</u>{Name}<br/>{Email}<br/>{Movie}<br/>{Showtime}<br/>{CinemaHall}<br/>{BookingSeats}<br/>{Tickets}<br/>{Deposit}<br/>{Total}<br/>{Tax}', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 341, 'pjField', 1, 'title', '<u>Available tokens</u>{Name}<br/>{Email}<br/>{Movie}<br/>{Showtime}<br/>{CinemaHall}<br/>{BookingSeats}<br/>{Tickets}<br/>{Deposit}<br/>{Total}<br/>{Tax}', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Allow payments with Authorize.net ', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Allow payment with cash', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Authorize.net time zone', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Book X minutes before the movie', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'set how many hours before the event start time a booking can be made', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'All bookings which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'set the default status for each booking after it is made', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'set % of the booking amount to be paid as a deposit. For full payment enter 100', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Cancel confirmation message', 'script'),
(NULL, 374, 'pjField', 1, 'title', '<u>Available Tokens:</u>{Name}<br/>{Email}<br/>{Phone}<br/>{Country}<br/>{City}<br/>{Address}<br/>{Notes}<br/>{Movie}<br/>{MovieID}<br/>{Showtime}<br/>{BookingID}<br/>{CinemaHall}<br/>{BookingSeats}<br/>{Tickets}<br/>{Deposit}<br/>{Total}<br/>{Tax}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>{TicketPrice}<br/>{PDFticket}', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'New booking received email', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'New booking confirmation message', 'script'),
(NULL, 378, 'pjField', 1, 'title', '<u>Available Tokens:</u>{Name}<br/>{Email}<br/>{Phone}<br/>{Country}<br/>{City}<br/>{Address}<br/>{Notes}<br/>{Movie}<br/>{MovieID}<br/>{Showtime}<br/>{BookingID}<br/>{CinemaHall}<br/>{BookingSeats}<br/>{Tickets}<br/>{Deposit}<br/>{Total}<br/>{Tax}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>{TicketPrice}<br/>{PDFticket}', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'New booking confirmation subject', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to let your customers know that you received their bookings. ', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Payment confirmation message', 'script'),
(NULL, 383, 'pjField', 1, 'title', '<u>Available Tokens:</u>{Name}<br/>{Email}<br/>{Phone}<br/>{Country}<br/>{City}<br/>{Address}<br/>{Notes}<br/>{Movie}<br/>{MovieID}<br/>{Showtime}<br/>{BookingID}<br/>{CinemaHall}<br/>{BookingSeats}<br/>{Tickets}<br/>{Deposit}<br/>{Total}<br/>{Tax}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>{TicketPrice}<br/>{PDFticket}', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Payment confirmation subject', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for receiving their payment.', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Theme', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Select ''Yes'' if you want to disable payments and only collect booking details ', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'PayPal business email address', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Send PDF ticket', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Booking reminder SMS', 'script'),
(NULL, 393, 'pjField', 1, 'title', '<u>Available tokens</u>{Name}<br/>{Email}<br/>{Movie}<br/>{Showtime}<br/>{CinemaHall}<br/>{BookingSeats}<br/>{Tickets}<br/>{Deposit}<br/>{Total}<br/>{Tax}', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'set % for tax that clients pay', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment ', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Ticket data', 'script'),
(NULL, 403, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/>{Name}<br/>{Email}<br/>{Phone}<br/>{Movie}<br/>{Showtime}<br/>{CinemaHall}<br/>{BookingSeats}<br/>{TicketPrice}', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Ticket', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Barcode reader', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'You have to set up at least one seat on the map.', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Available', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Blocked', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Booking created', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Confirm Booking', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Purchase tickets', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Start over', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Booking seats', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Movie showtime', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Movie', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Your booking details', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Tickets & prices', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Current month', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Fill in your details', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Hall', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'click on a seat above to remove it', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Paypal Transaction ID', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Minutes', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Movie', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'N/A', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'No movies found', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'No available seats.', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'No showtimes on selected date.', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Payment information', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Personal details', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Your address', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Company name', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Your email', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Your name', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Phone number', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Postal code', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Running time', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Selected', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Selected date', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Selected seat(s)', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'click on available seat on the map to reserve it', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Select date', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Select ticket types below', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Select time', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Missing parameters. Please click on the "Start over" button to make new booking.', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Accept terms of booking', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Terms and conditions', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Tomorrow', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Total price', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Your details', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Missing or wrong captcha.', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'We are sorry, but your booking failed. The available seat(s) for the selected movie have finished while you were placing your order. You can [STAG]start over[ETAG] searching for other seats.', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'The booking could not be saved successfully.', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Checkout submitted', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'New booking SMS', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Set', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Booking has been cancelled successfully.', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'New booking received email', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Tomorrow', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'This week', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'Next week', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'This month', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Next month', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'All changes made to the movie have been saved.', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'New movie has been added.', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'New movie could not be added successfully.', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'New movie could not be added because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'The event could not be updated because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'No such movie.', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Movie has been added. Image file is too big and was not uploaded.', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Movie has been added. Image file is too big and was not uploaded.', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Directory app/web/upload/events or app/web/upload/tickets  has no permissions to upload seat maps. Please set permissions to 777.', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'The movie image could not be uploaded because it is not image file. Please upload another image.', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'All changes made to the showtimes have been saved.', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'All changes made to the booking options have been saved successfully.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'All changes made to booking form have been saved successfully.', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'All changes made to ticket setting have been saved successfully.', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'All changes made to Terms and Conditions have been saved successfully.', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'The ticket information could not be updated because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'All changes to the booking have been saved.', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'A new booking has been added into the list.', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'We are sorry that new booking could not be added successfully.', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'We are sorry that booking you are looking is missing.', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'The confirmation email has been sent to the client.', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'You can export movies in different formats. You can either download a file with movie details or use a link for a feed which load all the movies.', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'All changes made to the hall have been saved.', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Hall has been added.', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Hall was not added.', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'New hall could not be added because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'The hall could not be updated because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Hall not found.', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'New hall has been added, but uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Directory app/web/upload/maps has no permissions to upload seat maps. Please set permissions to 777.', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'The map file could not be uploaded because actually it is not image file. Please upload another image.', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Movie updated', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Movie added', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Movie was not added.', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Movie not found.', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'No permissions', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Wrong file type', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Showtimes updated', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Booking options updated', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Notifications updated', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'Booking form updated', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Ticket setting update', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Terms and conditions updated', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Booking updated', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Booking added', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Booking failed to add', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Booking not found', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Confirmation email sent', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Export movies', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Hall updated.', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Hall added', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Hall was not added.', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Hall not found.', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'No permissions', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'Wrong file type', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'CSV', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'iCal', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'XML', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Past', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Coming', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Feed', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'File', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'Thank you! Your booking has been made. Please click on the "Start over" button to make new booking.', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'You need to select seat(s).', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'You already selected enough numbers of [TICKET] tickets.', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'The selected seats are not equal to the number of selected tickets. Please select more seats.', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'You need to select [TICKET] ticket.', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Tickets and seats selected. {STAG}Continue{ETAG}', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Select seats for {tickets} tickets.', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Select seat for {tickets} ticket.', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Yesterday', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'This week', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Last week', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'This month', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Last month', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'Authorize.net', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'The ticket is valid.', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'Booking is not confirmed yet.', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'The ticket was already used.', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'The ticket could not be found in the system.', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Address is required.', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'Captcha is required.', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'CC code is required.', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'CC number is required.', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'CC type is required.', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'City is required.', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'Company is required.', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'Country is required.', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'Name is required.', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'Notes is required.', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'Payment method is required.', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'Phone is required.', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'State is required.', 'script'),
(NULL, 779, 'pjField', 1, 'title', 'You need to accept terms of booking.', 'script'),
(NULL, 780, 'pjField', 1, 'title', 'Title is required.', 'script'),
(NULL, 781, 'pjField', 1, 'title', 'Zip is required.', 'script'),
(NULL, 782, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 783, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1, 'pjOption', 1, 'o_ticket_data', '{Movie}\r\n{Showtime}\r\nPrice: {TicketPrice}\r\nSeats: {BookingSeats}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla.\r\n\r\nSuspendisse porttitor, odio eget eleifend aliquet, nibh urna placerat lacus, a rhoncus metus metus et lectus. Fusce convallis nunc dignissim magna condimentum sed lobortis nibh faucibus. Vivamus gravida libero et elit sagittis vel dignissim erat euismod.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', 'Your booking has been received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', 'Your booking has been received.<br/><br/>Personal details:<br/>Name: {Name}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Country: {Country}<br/>City: {City}<br/>Address: {Address}<br/>Notes: {Notes}<br/><br/>Booking details:<br/>Movie: {Movie}<br/>Movie ID: {MovieID}<br/>Showtime: {Showtime}<br/>Booking ID: {BookingID}<br/>Booking Seats: {BookingSeats}<br/>Tickets & Prices: {TicketPrice}<br/><br/>Payment information:<br/>Payment method: {PaymentMethod}<br/>Deposit: {Deposit}<br/>Total: {Total}<br/>Tax: {Tax}<br/><br/>If you want to cancel your booking follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', 'We received your payment', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', 'Your payment has been received. You''ve just made a payment for booking with the following details.<br/><br/>Personal details:<br/>Name: {Name}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Country: {Country}<br/>City: {City}<br/>Address: {Address}<br/>Notes: {Notes}<br/><br/>Booking details:<br/>Movie: {Movie}<br/>Movie ID: {MovieID}<br/>Showtime: {Showtime}<br/>Booking ID: {BookingID}<br/>Booking Seats: {BookingSeats}<br/>Deposit: {Deposit}<br/>Total: {Total}<br/>Tax: {Tax}<br/><br/>If you want to cancel your booking follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', 'You''ve just cancelled your booking.<br/><br/>Personal details:<br/>Name: {Name}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Country: {Country}<br/>City: {City}<br/>Address: {Address}<br/>Notes: {Notes}<br/><br/>Booking details:<br/>Movie: {Movie}<br/>Movie ID: {MovieID}<br/>Showtime: {Showtime}<br/>Booking ID: {BookingID}<br/>Booking Seats: {BookingSeats}<br/>Deposit: {Deposit}<br/>Total: {Total}<br/>Tax: {Tax}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', 'New booking received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', 'You''ve just received a booking. <br/><br/>Personal details:<br/>Name: {Name}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Country: {Country}<br/>City: {City}<br/>Address: {Address}<br/>Notes: {Notes}<br/><br/>Booking details:<br/>Movie: {Movie}<br/>Movie ID: {MovieID}<br/>Showtime: {Showtime}<br/>Booking ID: {BookingID}<br/>Booking Seats: {BookingSeats}<br/>Tickets & Prices: {TicketPrice}<br/><br/>Payment information:<br/>Payment method: {PaymentMethod}<br/>Deposit: {Deposit}<br/>Total: {Total}<br/>Tax: {Tax}<br/><br/>Thank you!', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', 'New payment received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', 'You''ve just received payment for the booking.<br/><br/>Personal details:<br/>Name: {Name}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Country: {Country}<br/>City: {City}<br/>Address: {Address}<br/>Notes: {Notes}<br/><br/>Booking details:<br/>Movie: {Movie}<br/>Movie ID: {MovieID}<br/>Showtime: {Showtime}<br/>Booking ID: {BookingID}<br/>Booking Seats: {BookingSeats}<br/>Deposit: {Deposit}<br/>Total: {Total}<br/>Tax: {Tax}<br/><br/>Thank you!', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', 'Booking cancelled', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', 'A booking has been cancelled.<br/><br/>Personal details:<br/>Name: {Name}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Country: {Country}<br/>City: {City}<br/>Address: {Address}<br/>Notes: {Notes}<br/><br/>Booking details:<br/>Movie: {Movie}<br/>Movie ID: {MovieID}<br/>Showtime: {Showtime}<br/>Booking ID: {BookingID}<br/>Booking Seats: {BookingSeats}<br/>Deposit: {Deposit}<br/>Total: {Total}<br/>Tax: {Tax}<br/><br/>Thank you!', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_payment_message', NULL, 'data');

INSERT INTO `cbs_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 4, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 5, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 7, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 8, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 10, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 11, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_deposit_payment', 2, '10', NULL, 'int', 2, 1, NULL),
(1, 'o_tax_payment', 2, '0.00', NULL, 'int', 3, 1, NULL),
(1, 'o_booking_earlier', 2, '120', NULL, 'int', 4, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_thank_you_page', 2, 'https://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 9, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 20, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 7, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 9, 1, NULL),

(1, 'o_admin_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 3, '', NULL, 'string', 8, 1, NULL),
(1, 'o_admin_email_confirmation_message', 3, '', NULL, 'text', 9, 1, NULL),
(1, 'o_admin_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 10, 1, NULL),
(1, 'o_admin_email_payment_subject', 3, '', NULL, 'string', 11, 1, NULL),
(1, 'o_admin_email_payment_message', 3, '', NULL, 'text', 12, 1, NULL),
(1, 'o_admin_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 13, 1, NULL),
(1, 'o_admin_email_cancel_subject', 3, '', NULL, 'string', 14, 1, NULL),
(1, 'o_admin_email_cancel_message', 3, '', NULL, 'text', 15, 1, NULL),

(1, 'o_sms_confirmation_message', 3, '', NULL, 'text', 2, 1, NULL),
(1, 'o_admin_sms_confirmation_message', 3, '', NULL, 'text', 2, 1, NULL),
(1, 'o_admin_sms_payment_message', 3, '', NULL, 'text', 4, 1, NULL),

(1, 'o_bf_include_title', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_name', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_email', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_company', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_address', 5, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_country', 5, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_state', 5, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_city', 5, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
(1, 'o_bf_include_zip', 5, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_notes', 5, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_captcha', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 12, 1, NULL),

(1, 'o_ticket_image', 6, '', NULL, 'text', 1, 1, NULL),
(1, 'o_ticket_data', 6, '', NULL, 'text', 2, 1, NULL),

(1, 'o_terms', 7, '', NULL, 'text', 1, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 1, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `cbs_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');