DROP TABLE IF EXISTS `cbs_enquiries`;
CREATE TABLE IF NOT EXISTS `cbs_enquiries` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uuid` varchar(255) DEFAULT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `how_often` enum('once','weekly','many') DEFAULT NULL,
  `date` date DEFAULT NULL,
  `when` enum('morning','lunch','night') DEFAULT NULL,
  `home` enum('someone','hidekey') DEFAULT NULL,
  `c_notes` text DEFAULT NULL,
  `price_per_hour` decimal(9,2) unsigned DEFAULT NULL,
  `cleaning_materials` enum('T','F') DEFAULT NULL,
  `cleaning_materials_price` decimal(9,2) unsigned DEFAULT NULL,
  `bedrooms` int(10) unsigned DEFAULT NULL,
  `time_per_bedroom` int(10) unsigned DEFAULT NULL,
  `bathrooms` int(10) unsigned DEFAULT NULL,
  `time_per_bathroom` int(10) unsigned DEFAULT NULL,
  `subtotal` decimal(9,2) unsigned DEFAULT NULL,
  `tax` decimal(9,2) unsigned DEFAULT NULL,
  `total` decimal(9,2) unsigned DEFAULT NULL,
  `deposit` decimal(9,2) unsigned DEFAULT NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') DEFAULT NULL,
  `status` enum('confirmed','cancelled','pending') DEFAULT 'pending',
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `c_address` varchar(255) DEFAULT NULL,
  `c_city` varchar(255) DEFAULT NULL,
  `c_state` varchar(255) DEFAULT NULL,
  `c_zip` varchar(255) DEFAULT NULL,
  `c_country` int(10) unsigned DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_clients`;
CREATE TABLE IF NOT EXISTS `cbs_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `c_title` varchar(255) DEFAULT NULL,
  `c_name` varchar(255) DEFAULT NULL,
  `c_phone` varchar(255) DEFAULT NULL,
  `c_email` varchar(255) DEFAULT NULL,
  `c_password` blob,
  `status` enum('T','F') DEFAULT 'T',
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_enquiries_extras`;
CREATE TABLE IF NOT EXISTS `cbs_enquiries_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enquiry_id` int(10) unsigned DEFAULT NULL,
  `extra_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `enquiry_id` (`enquiry_id`),
  KEY `extra_id` (`extra_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_enquiries_payments`;
CREATE TABLE IF NOT EXISTS `cbs_enquiries_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `enquiry_id` int(10) unsigned DEFAULT NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `enquiry_id` (`enquiry_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_services`;
CREATE TABLE IF NOT EXISTS `cbs_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `price_per_hour` decimal(9,2) DEFAULT NULL,
  `allow_using_materials` enum('T','F') NOT NULL DEFAULT 'T',
  `cleaning_materials_price` decimal(9,2) DEFAULT NULL,
  `max_bedrooms` int(10) unsigned DEFAULT NULL,
  `time_per_bedroom` int(10) unsigned DEFAULT NULL,
  `max_bathrooms` int(10) unsigned DEFAULT NULL,
  `time_per_bathroom` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_extras`;
CREATE TABLE IF NOT EXISTS `cbs_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `service_id` int(10) unsigned NOT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `time_needed` int(10) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `service_id` (`service_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_fields`;
CREATE TABLE IF NOT EXISTS `cbs_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_multi_lang`;
CREATE TABLE IF NOT EXISTS `cbs_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_options`;
CREATE TABLE IF NOT EXISTS `cbs_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_roles`;
CREATE TABLE IF NOT EXISTS `cbs_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cbs_users`;
CREATE TABLE IF NOT EXISTS `cbs_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `cbs_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'backend', 'backend', 'Backend titles', 'script', NULL),
(4, 'booking_confirmation_title', 'backend', 'Label / Send Confirmation Email', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnAddClient', 'backend', 'Button / + Add client', 'script', NULL),
(7, 'btnAddEnquiry', 'backend', 'Button / + Add enquiry', 'script', NULL),
(8, 'btnAddExtra', 'backend', 'Button / + Add extra', 'script', NULL),
(9, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(10, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(11, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(12, 'btnCalculateTotal', 'backend', 'Button / Calculate Total', 'script', NULL),
(13, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(14, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(15, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(16, 'btnLogin', 'backend', 'Login', 'script', NULL),
(17, 'btnReset', 'backend', 'Reset', 'script', NULL),
(18, 'btnSave', 'backend', 'Save', 'script', NULL),
(19, 'btnSearch', 'backend', 'Search', 'script', NULL),
(20, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(21, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(22, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(23, 'created', 'backend', 'Created', 'script', NULL),
(24, 'dash_add_client', 'backend', 'Label / + Add client', 'script', NULL),
(25, 'dash_add_enquiry', 'backend', 'Label / + Add enquiry', 'script', NULL),
(26, 'dash_cleaning_services_today', 'backend', 'Dash / Cleaning services today', 'script', NULL),
(27, 'dash_cleaning_service_today', 'backend', 'Dash / Cleaning service today', 'script', NULL),
(28, 'dash_enquiries_last_month', 'backend', 'Label / enquiries last month', 'script', NULL),
(29, 'dash_enquiries_last_week', 'backend', 'Label / enquiries last week', 'script', NULL),
(30, 'dash_enquiries_received_today', 'backend', 'Dash / Enquiries received today', 'script', NULL),
(31, 'dash_enquiries_this_month', 'backend', 'Label / enquiries this month', 'script', NULL),
(32, 'dash_enquiries_this_week', 'backend', 'Label / enquiries this week', 'script', NULL),
(33, 'dash_enquiry_last_month', 'backend', 'Label / enquiry last month', 'script', NULL),
(34, 'dash_enquiry_last_week', 'backend', 'Label / enquiry last week', 'script', NULL),
(35, 'dash_enquiry_received_today', 'backend', 'Dash / Enquiry received today', 'script', NULL),
(36, 'dash_enquiry_this_month', 'backend', 'Label / enquiry this month', 'script', NULL),
(37, 'dash_enquiry_this_week', 'backend', 'Label / enquiry this week', 'script', NULL),
(38, 'dash_latest_enquiries', 'backend', 'Label / Latest enquiries', 'script', NULL),
(39, 'dash_no_enquiries', 'backend', 'Label / No enquiries found.', 'script', NULL),
(40, 'dash_quick_links', 'backend', 'Label / Quick links & Stats', 'script', NULL),
(41, 'dash_today_services', 'backend', 'Label / Today services', 'script', NULL),
(42, 'dash_total_enquiries', 'backend', 'Dash / Total enquiries', 'script', NULL),
(43, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(44, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(45, 'email', 'backend', 'E-Mail', 'script', NULL),
(46, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(47, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(48, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(49, 'enquiry_message', 'backend', 'Label / Email message', 'script', NULL),
(50, 'enquiry_subject', 'backend', 'Label / Email subject', 'script', NULL),
(51, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(52, 'front_btn_cancel', 'backend', 'Button / Cancel', 'script', NULL),
(53, 'front_btn_continue', 'backend', 'Button / Continue', 'script', NULL),
(54, 'front_choose', 'backend', 'Button / Choose', 'script', NULL),
(55, 'front_email', 'backend', 'Button / Email', 'script', NULL),
(56, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(57, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(58, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(59, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(60, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(61, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(62, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(63, 'gridEmptyBody', 'backend', 'Grid / No records selected', 'script', NULL),
(64, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(65, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(66, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(67, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(68, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(69, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(70, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(71, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(72, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(73, 'infoAddClientDesc', 'backend', 'Infobox / Add client', 'script', NULL),
(74, 'infoAddClientTitle', 'backend', 'Infobox / Add client', 'script', NULL),
(75, 'infoAddExtraDesc', 'backend', 'Infobox / Add Extra', 'script', NULL),
(76, 'infoAddExtraTitle', 'backend', 'Infobox / Add Extra', 'script', NULL),
(77, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(78, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(79, 'infoClientDetailsDesc', 'backend', 'Infobox / Client details', 'script', NULL),
(80, 'infoClientDetailsTitle', 'backend', 'Infobox / Client details', 'script', NULL),
(81, 'infoClientsDesc', 'backend', 'Infobox / List of clients', 'script', NULL),
(82, 'infoClientsTitle', 'backend', 'Infobox / List of clients', 'script', NULL),
(83, 'infoEnquiriesDesc', 'backend', 'Infobox / Enquiry options', 'script', NULL),
(84, 'infoEnquiriesListDesc', 'backend', 'Infobox / List of enquiries', 'script', NULL),
(85, 'infoEnquiriesListTitle', 'backend', 'Infobox / List of enquiries', 'script', NULL),
(86, 'infoEnquiriesTitle', 'backend', 'Infobox / Enquiry options', 'script', NULL),
(87, 'infoEnquiryDetailsDesc', 'backend', 'Infobox / Enquiry details', 'script', NULL),
(88, 'infoEnquiryDetailsTitle', 'backend', 'Infobox / Enquiry details', 'script', NULL),
(89, 'infoEnquiryFormDesc', 'backend', 'Infobox / Enquiry form', 'script', NULL),
(90, 'infoEnquiryFormTitle', 'backend', 'Infobox / Enquiry form', 'script', NULL),
(91, 'infoExtrasDesc', 'backend', 'Infobox / Extras', 'script', NULL),
(92, 'infoExtrasTitle', 'backend', 'Menu / Extras', 'script', NULL),
(93, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(94, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(95, 'infoInstallCodeDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(96, 'infoInstallCodeTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(97, 'infoPreviewDesc', 'backend', 'Infobox / Preview front end', 'script', NULL),
(98, 'infoPreviewInstallDesc', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(99, 'infoPreviewInstallTitle', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(100, 'infoPreviewTitle', 'backend', 'Infobox / Preview front end', 'script', NULL),
(101, 'infoPrintTemplateDesc', 'backend', 'Tab / Print template', 'script', NULL),
(102, 'infoPrintTemplateTitle', 'backend', 'Tab / Print template', 'script', NULL),
(103, 'infoServicesDesc', 'backend', 'Infobox / Services & Price', 'script', NULL),
(104, 'infoServicesTitle', 'backend', 'Infobox / Services & Price', 'script', NULL),
(105, 'infoTermsDesc', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(106, 'infoTermsTitle', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(107, 'infoToAdministratorsDesc', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(108, 'infoToAdministratorsTitle', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(109, 'infoToCustomersDesc', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(110, 'infoToCustomersTitle', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(111, 'infoUpdateClientDesc', 'backend', 'Infobox / Update client', 'script', NULL),
(112, 'infoUpdateClientTitle', 'backend', 'Infobox / Update client', 'script', NULL),
(113, 'infoUpdateExtraDesc', 'backend', 'Infobox / Update Extra', 'script', NULL),
(114, 'infoUpdateExtraTitle', 'backend', 'Infobox / Update Extra', 'script', NULL),
(115, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(116, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(117, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', NULL),
(118, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', NULL),
(119, 'infoWhatIncludedDesc', 'backend', 'Infobox / What includes description', 'script', NULL),
(120, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(121, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(122, 'lblAllowUsingMaterials', 'backend', 'Label / Allow using customer''s cleaning materials', 'script', NULL),
(123, 'lblAvailableTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(124, 'lblBathrooms', 'backend', 'Label / Bathrooms', 'script', NULL),
(125, 'lblBedrooms', 'backend', 'Label / Bedrooms', 'script', NULL),
(126, 'lblCategory', 'backend', 'Label / Category', 'script', NULL),
(127, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(128, 'lblCCExp', 'backend', 'Label / CC expiration date', 'script', NULL),
(129, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(130, 'lblCCType', 'backend', 'Label / CC type', 'script', NULL),
(131, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(132, 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(133, 'lblCleaningMaterialsPrice', 'backend', 'Label / Cleaning materials price', 'script', NULL),
(134, 'lblClient', 'backend', 'Label / Client', 'script', NULL),
(135, 'lblCopy', 'backend', 'Label / Copy', 'script', NULL),
(136, 'lblCreatedOn', 'backend', 'Label / Created on', 'script', NULL),
(137, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(138, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(139, 'lblDate', 'backend', 'Label / Date', 'script', NULL),
(140, 'lblDateTime', 'backend', 'Label / Date & time', 'script', NULL),
(141, 'lblDays', 'backend', 'Days', 'script', NULL),
(142, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(143, 'lblDeleteImage', 'backend', 'Label / Delete image', 'script', NULL),
(144, 'lblDeleteImageConfirm', 'backend', 'Label / Delete image', 'script', NULL),
(145, 'lblDeposit', 'backend', 'Label / Deposit', 'script', NULL),
(146, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(147, 'lblDoYouHaveMaterials', 'backend', 'Label / Do you have cleaning materials?', 'script', NULL),
(148, 'lblDuplicate', 'backend', 'Label / Duplicate', 'script', NULL),
(149, 'lblEmailUsed', 'backend', 'Label / Email is already used.', 'script', NULL),
(150, 'lblEnquiries', 'backend', 'Label / Enquiries', 'script', NULL),
(151, 'lblEnquiriesReceived', 'backend', 'Label / enquiries received', 'script', NULL),
(152, 'lblEnquiryID', 'backend', 'Label / Enquiry ID', 'script', NULL),
(153, 'lblEnquiryReceived', 'backend', 'Label / enquiry received', 'script', NULL),
(154, 'lblError', 'backend', 'Error', 'script', NULL),
(155, 'lblExport', 'backend', 'Export', 'script', NULL),
(156, 'lblExtra', 'backend', 'Label / Extra', 'script', NULL),
(157, 'lblExtraName', 'backend', 'Label / Extra name', 'script', NULL),
(158, 'lblExtras', 'backend', 'Label / Extras', 'script', NULL),
(159, 'lblFirstEnquiry', 'backend', 'Label / First enquiry', 'script', NULL),
(160, 'lblFirstOn', 'backend', 'Label / first on', 'script', NULL),
(161, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(162, 'lblHowOften', 'backend', 'Label / How often do you want a cleaning?', 'script', NULL),
(163, 'lblIcon', 'backend', 'Label / Icon', 'script', NULL),
(164, 'lblInstallCode', 'backend', 'Label / Install code', 'script', NULL),
(165, 'lblIp', 'backend', 'IP address', 'script', NULL),
(166, 'lblIpAddress', 'backend', 'Label / IP address', 'script', NULL),
(167, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(168, 'lblIWillHideTheKey', 'backend', 'Label / I''ll hide the key', 'script', NULL),
(169, 'lblLastEnquiry', 'backend', 'Label / Last enquiry', 'script', NULL),
(170, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(171, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(172, 'lblMaximumBathrooms', 'backend', 'Menu / Maximum bathrooms', 'script', NULL),
(173, 'lblMaximumBedrooms', 'backend', 'Menu / Maximum bedrooms', 'script', NULL),
(174, 'lblMinutes', 'backend', 'Label / minutes', 'script', NULL),
(175, 'lblName', 'backend', 'Name', 'script', NULL),
(176, 'lblNewClient', 'backend', 'Label / New client', 'script', NULL),
(177, 'lblNo', 'backend', 'No', 'script', NULL),
(178, 'lblNoCategoriesMessage', 'backend', 'Label / No categories added.', 'script', NULL),
(179, 'lblNoSuchEnquiryID', 'backend', 'Label / Enquiry with such ID does not exist.', 'script', NULL),
(180, 'lblNotifications', 'backend', 'Label / Notifications', 'script', NULL),
(181, 'lblOn', 'backend', 'Label / on', 'script', NULL),
(182, 'lblOption', 'backend', 'Option', 'script', NULL),
(183, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(184, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(185, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(186, 'lblPricePerHour', 'backend', 'Menu / Price per hour', 'script', NULL),
(187, 'lblPrint', 'backend', 'Label / Print enquiry', 'script', NULL),
(188, 'lblPrintEnquiry', 'backend', 'Label / Print enquiry', 'script', NULL),
(189, 'lblResvAddress', 'backend', 'Label / Address', 'script', NULL),
(190, 'lblResvCity', 'backend', 'Label / City', 'script', NULL),
(191, 'lblResvCompany', 'backend', 'Label / Company', 'script', NULL),
(192, 'lblResvCountry', 'backend', 'Label / Country', 'script', NULL),
(193, 'lblResvEmail', 'backend', 'Label / Email', 'script', NULL),
(194, 'lblResvName', 'backend', 'Label / Name', 'script', NULL),
(195, 'lblResvNotes', 'backend', 'Label / Notes', 'script', NULL),
(196, 'lblResvPhone', 'backend', 'Label / Phone', 'script', NULL),
(197, 'lblResvState', 'backend', 'Label / State', 'script', NULL),
(198, 'lblResvTitle', 'backend', 'Label / Title', 'script', NULL),
(199, 'lblResvZip', 'backend', 'Label / Zip', 'script', NULL),
(200, 'lblRole', 'backend', 'Role', 'script', NULL),
(201, 'lblSendEmail', 'backend', 'Label / Send Email', 'script', NULL),
(202, 'lblSendEmailConfirmation', 'backend', 'Label / Send Confirmation Email', 'script', NULL),
(203, 'lblSomeoneInHome', 'backend', 'Label / Someone is home', 'script', NULL),
(204, 'lblStatus', 'backend', 'Status', 'script', NULL),
(205, 'lblSubTotal', 'backend', 'Label / Sub-total', 'script', NULL),
(206, 'lblTax', 'backend', 'Label / Tax', 'script', NULL),
(207, 'lblTimeNeeded', 'backend', 'Label / Time needed', 'script', NULL),
(208, 'lblTimePerBathroom', 'backend', 'Menu / Time per bathroom', 'script', NULL),
(209, 'lblTimePerBedroom', 'backend', 'Menu / Time per bedroom', 'script', NULL),
(210, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(211, 'lblType', 'backend', 'Type', 'script', NULL),
(212, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(213, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(214, 'lblValue', 'backend', 'Value', 'script', NULL),
(215, 'lblWhen', 'backend', 'Label / When', 'script', NULL),
(216, 'lblYes', 'backend', 'Yes', 'script', NULL),
(217, 'legendDateTime', 'backend', 'Label / Date & time', 'script', NULL),
(218, 'legendDetails', 'backend', 'Legend / Details', 'script', NULL),
(219, 'legendExtras', 'backend', 'Label / Extras', 'script', NULL),
(220, 'legendHowBigIsYourHome', 'backend', 'Label / How big is Your Home', 'script', NULL),
(221, 'legendPayment', 'backend', 'Legend / Payment', 'script', NULL),
(222, 'lengendInstructions', 'backend', 'Label / Special instructions', 'script', NULL),
(223, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(224, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(225, 'locales', 'backend', 'Languages', 'script', NULL),
(226, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(227, 'locale_is_DEFAULT', 'backend', 'Locale / Is DEFAULT', 'script', NULL),
(228, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(229, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(230, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(231, 'menuClients', 'backend', 'Menu / Clients', 'script', NULL),
(232, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(233, 'menuEnquiries', 'backend', 'Menu / Enquiries', 'script', NULL),
(234, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(235, 'menuInstallPreview', 'backend', 'Menu / Install & Preview', 'script', NULL),
(236, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(237, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(238, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(239, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(240, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(241, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(242, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(243, 'menuServicesPrice', 'backend', 'Menu / Services & Price', 'script', NULL),
(244, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(245, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(246, 'opt_o_admin_email_cancel_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(247, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / New enquiry confirmation message', 'script', NULL),
(248, 'opt_o_admin_email_payment_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(249, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / Enquiry confirmation SMS', 'script', NULL),
(250, 'opt_o_admin_sms_payment_message', 'backend', 'Options / Payment confirmation SMS', 'script', NULL),
(251, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net ', 'script', NULL),
(252, 'opt_o_allow_bank', 'backend', 'Options / Provide Bank account details for wire transfers', 'script', NULL),
(253, 'opt_o_allow_cash', 'backend', 'Options / Allow cash payments', 'script', NULL),
(254, 'opt_o_allow_creditcard', 'backend', 'Options / Collect Credit Card details for offline processing', 'script', NULL),
(255, 'opt_o_allow_paypal', 'backend', 'Options / Allow payments with PayPal', 'script', NULL),
(256, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL),
(257, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(258, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL),
(259, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(260, 'opt_o_bank_account', 'backend', 'Options / Bank Account', 'script', NULL),
(261, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(262, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(263, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(264, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(265, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(266, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(267, 'opt_o_bf_include_name', 'backend', 'Options / Name', 'script', NULL),
(268, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(269, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(270, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(271, 'opt_o_bf_include_title', 'backend', 'Options / Title', 'script', NULL),
(272, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(273, 'opt_o_booking_status', 'backend', 'Options / All enquiries which are only made but NOT paid will be set with the following status', 'script', NULL),
(274, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(275, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(276, 'opt_o_days_before', 'backend', 'Options / Request cleaning service', 'script', NULL),
(277, 'opt_o_days_before_text', 'backend', 'Options / Request cleaning service', 'script', NULL),
(278, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(279, 'opt_o_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(280, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(281, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(282, 'opt_o_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(283, 'opt_o_email_confirmation', 'backend', 'Options / New enquiry received email', 'script', NULL),
(284, 'opt_o_email_confirmation_message', 'backend', 'Options / New enquiry confirmation message', 'script', NULL),
(285, 'opt_o_email_confirmation_subject', 'backend', 'Options / New enquiry confirmation subject', 'script', NULL),
(286, 'opt_o_email_confirmation_text', 'backend', 'Options / New enquiry received email', 'script', NULL),
(287, 'opt_o_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(288, 'opt_o_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(289, 'opt_o_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(290, 'opt_o_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(291, 'opt_o_payment_disable', 'backend', 'Options / Select "Yes" if you want to disable payments and only collect enquiry details ', 'script', NULL),
(292, 'opt_o_payment_status', 'backend', 'Options / All enquiries which are made and paid will be set with the following status', 'script', NULL),
(293, 'opt_o_paypal_address', 'backend', 'Options / PayPal business email address', 'script', NULL),
(294, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(295, 'opt_o_sms_confirmation_message', 'backend', 'Options / Enquiry Confirmation SMS', 'script', NULL),
(296, 'opt_o_sms_payment_message', 'backend', 'Options / Payment confirmation SMS', 'script', NULL),
(297, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(298, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(299, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(300, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(301, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(302, 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL),
(303, 'opt_o_thankyou_page', 'backend', 'Options / URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script', NULL),
(304, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(305, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(306, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(307, 'pass', 'backend', 'Password', 'script', NULL),
(308, 'pj_digits_validation', 'backend', 'Label / Please enter only digits.', 'script', NULL),
(309, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(310, 'pj_email_validation', 'backend', 'Label / Please enter a valid email address.', 'script', NULL),
(311, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(312, 'pj_number_validation', 'backend', 'Label / Please enter a valid number.', 'script', NULL),
(313, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(314, 'tabClientDetails', 'backend', 'Tab / Client Details', 'script', NULL),
(315, 'tabDaysOff', 'backend', 'Tab / Days off', 'script', NULL),
(316, 'tabEnquiries', 'backend', 'Tab / Enquiries', 'script', NULL),
(317, 'tabEnquiryDetails', 'backend', 'Tab / Enquiry Details', 'script', NULL),
(318, 'tabEnquiryForm', 'backend', 'Tab / Enquiry form', 'script', NULL),
(319, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(320, 'tabNotifications', 'backend', 'Tab / Notifications', 'script', NULL),
(321, 'tabPrintTemplate', 'backend', 'Tab / Print template', 'script', NULL),
(322, 'tabServicesPrice', 'backend', 'Tab / Services & Price', 'script', NULL),
(323, 'tabTerms', 'backend', 'Tab / Terms', 'script', NULL),
(324, 'tabToAdministrators', 'backend', 'Tab / To administrators', 'script', NULL),
(325, 'tabToCustomers', 'backend', 'Tab / To customers', 'script', NULL),
(326, 'tabWhatIncluded', 'backend', 'Tab / What''s included', 'script', NULL),
(327, 'url', 'backend', 'URL', 'script', NULL),
(328, 'user', 'backend', 'Username', 'script', NULL),
(329, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(330, 'front_add_extra_tasks', 'frontend', 'Label / Add extra tasks', 'script', NULL),
(331, 'front_agree_with_terms', 'frontend', 'Label / I agrees with terms and conditions', 'script', NULL),
(332, 'front_bank_account', 'frontend', 'Label / Bank account', 'script', NULL),
(333, 'front_bathrooms', 'frontend', 'Label / Bathrooms', 'script', NULL),
(334, 'front_bedrooms', 'frontend', 'Label / Bedrooms', 'script', NULL),
(335, 'front_booking_details', 'frontend', 'Label / Enquiry Details', 'script', NULL),
(336, 'front_booking_id', 'frontend', 'Label / Enquiry ID', 'script', NULL),
(337, 'front_btn_back', 'frontend', 'Button / Back', 'script', NULL),
(338, 'front_btn_close', 'frontend', 'Button / Close', 'script', NULL),
(339, 'front_btn_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(340, 'front_btn_select_date_address', 'frontend', 'Button / Select Date and Address', 'script', NULL),
(341, 'front_btn_start_over', 'frontend', 'Label / Start over', 'script', NULL),
(342, 'front_cancel_booking_id', 'frontend', 'label / Enquiry ID', 'script', NULL),
(343, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(344, 'front_cc_code', 'frontend', 'Label / CC code', 'script', NULL),
(345, 'front_cc_exp', 'frontend', 'Label / CC expiration', 'script', NULL),
(346, 'front_cc_num', 'frontend', 'Label / CC number', 'script', NULL),
(347, 'front_cc_type', 'frontend', 'Label / CC type', 'script', NULL),
(348, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(349, 'front_cleaning_materials', 'frontend', 'Label / Cleaning materials', 'script', NULL),
(350, 'front_comments_or_instructions', 'frontend', 'Label / Comments or Instructions', 'script', NULL),
(351, 'front_company', 'frontend', 'Label / Company', 'script', NULL),
(352, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(353, 'front_date_time', 'frontend', 'Label / Date & time', 'script', NULL),
(354, 'front_deposit', 'frontend', 'Label / Deposit', 'script', NULL),
(355, 'front_do_you_have_cleaning', 'frontend', 'Label / Do you have cleaning materials?', 'script', NULL),
(356, 'front_enquiry_completed', 'frontend', 'Label / Enquiry completed', 'script', NULL),
(357, 'front_extras', 'frontend', 'Label / Extras', 'script', NULL),
(358, 'front_hours_booking', 'frontend', 'Label / hours Booking', 'script', NULL),
(359, 'front_how_big_is_your_home', 'frontend', 'Label / How big is Your Home', 'script', NULL),
(360, 'front_how_often_error_message', 'frontend', 'Label / Please let us know your choose.', 'script', NULL),
(361, 'front_how_often_question', 'frontend', 'Label / How often do you want a cleaning?', 'script', NULL),
(362, 'front_incorrect_captcha', 'frontend', 'Label / Captcha is not correct.', 'script', NULL),
(363, 'front_i_hide_the_key', 'frontend', 'Label / I''ll hide the key', 'script', NULL),
(364, 'front_label_txn_id', 'frontend', 'label / Transaction ID', 'script', NULL),
(365, 'front_let_us_know_message', 'frontend', 'Label / Please let us know how big is your home.', 'script', NULL),
(366, 'front_materials_price_info', 'frontend', 'Label / Material price information', 'script', NULL),
(367, 'front_menu_step_1', 'frontend', 'Label / Service Details', 'script', NULL),
(368, 'front_menu_step_2', 'frontend', 'Label / Pick Date & Time', 'script', NULL),
(369, 'front_menu_step_3', 'frontend', 'Label / Checkout', 'script', NULL),
(370, 'front_menu_step_4', 'frontend', 'Label / Confirmation', 'script', NULL),
(371, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(372, 'front_notes', 'frontend', 'Label / Notes', 'script', NULL),
(373, 'front_payment_method', 'frontend', 'Label / Payment method', 'script', NULL),
(374, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(375, 'front_pick_date_time', 'frontend', 'Label / Pick Date & Time', 'script', NULL),
(376, 'front_please_select_date', 'frontend', 'Label / Please select a date.', 'script', NULL),
(377, 'front_price', 'frontend', 'Label / Price', 'script', NULL),
(378, 'front_price_per_hour', 'frontend', 'Label / Price per hour', 'script', NULL),
(379, 'front_processed_on', 'frontend', 'label / Processed on', 'script', NULL),
(380, 'front_prolong_cleaning_time', 'frontend', 'Label / prolong the cleaning time', 'script', NULL),
(381, 'front_see_what', 'frontend', 'Label / See what is always included', 'script', NULL),
(382, 'front_select_date', 'frontend', 'Label / Select date', 'script', NULL),
(383, 'front_select_date_first_cleaning', 'frontend', 'Label / Select date for first cleaning', 'script', NULL),
(384, 'front_someone_is_home', 'frontend', 'Label / Someone is home', 'script', NULL),
(385, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(386, 'front_subtotal', 'frontend', 'Label / Sub-total', 'script', NULL),
(387, 'front_tax', 'frontend', 'Label / Tax', 'script', NULL),
(388, 'front_terms_title', 'frontend', 'Label / Terms and conditions', 'script', NULL),
(389, 'front_title', 'frontend', 'Label / Title', 'script', NULL),
(390, 'front_total', 'frontend', 'Label / Total', 'script', NULL),
(391, 'front_when', 'frontend', 'Label / When', 'script', NULL),
(392, 'front_your_address', 'frontend', 'Label / Your Address', 'script', NULL),
(393, 'front_your_booking', 'frontend', 'Label / Your Booking', 'script', NULL),
(394, 'front_your_details', 'frontend', 'Label / Your Details', 'script', NULL),
(395, 'front_zip', 'frontend', 'Label / Zip', 'script', NULL),
(396, 'admin_sms_ARRAY_confirmation', 'arrays', 'admin_sms_arr_ARRAY_confirmation', 'script', NULL),
(397, 'admin_sms_ARRAY_payment', 'arrays', 'admin_sms_arr_ARRAY_payment', 'script', NULL),
(398, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(399, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(400, 'buttons_ARRAY_send', 'arrays', 'buttons_ARRAY_send', 'script', NULL),
(401, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(402, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(403, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(404, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(405, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(406, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(407, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(408, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(409, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(410, 'client_email_ARRAY_cancel', 'arrays', 'client_email_arr_ARRAY_cancel', 'script', NULL),
(411, 'client_email_ARRAY_confirmation', 'arrays', 'client_email_arr_ARRAY_confirmation', 'script', NULL),
(412, 'client_email_ARRAY_payment', 'arrays', 'client_email_arr_ARRAY_payment', 'script', NULL),
(413, 'client_sms_ARRAY_confirmation', 'arrays', 'client_sms_arr_ARRAY_confirmation', 'script', NULL),
(414, 'client_sms_ARRAY_payment', 'arrays', 'client_sms_arr_ARRAY_payment', 'script', NULL),
(415, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(416, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(417, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(418, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(419, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(420, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(421, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(422, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(423, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(424, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(425, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(426, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(427, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(428, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(429, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(430, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(431, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(432, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(433, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(434, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(435, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(436, 'enquiry_statuses_ARRAY_cancelled', 'arrays', 'enquiry_statuses_ARRAY_cancelled', 'script', NULL),
(437, 'enquiry_statuses_ARRAY_confirmed', 'arrays', 'enquiry_statuses_ARRAY_confirmed', 'script', NULL),
(438, 'enquiry_statuses_ARRAY_pending', 'arrays', 'enquiry_statuses_ARRAY_pending', 'script', NULL),
(439, 'enum_arr_ARRAY_0', 'arrays', 'enum_arr_ARRAY_0', 'script', NULL),
(440, 'enum_arr_ARRAY_1', 'arrays', 'enum_arr_ARRAY_1', 'script', NULL),
(441, 'enum_arr_ARRAY_2', 'arrays', 'enum_arr_ARRAY_2', 'script', NULL),
(442, 'enum_arr_ARRAY_24Hour', 'arrays', 'enum_arr_ARRAY_24Hour', 'script', NULL),
(443, 'enum_arr_ARRAY_cancelled', 'arrays', 'enum_arr_ARRAY_cancelled', 'script', NULL),
(444, 'enum_arr_ARRAY_confirmed', 'arrays', 'enum_arr_ARRAY_confirmed', 'script', NULL),
(445, 'enum_arr_ARRAY_Day', 'arrays', 'enum_arr_ARRAY_Day', 'script', NULL),
(446, 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', NULL),
(447, 'enum_arr_ARRAY_Night', 'arrays', 'enum_arr_ARRAY_Night', 'script', NULL),
(448, 'enum_arr_ARRAY_No', 'arrays', 'enum_arr_ARRAY_No', 'script', NULL),
(449, 'enum_arr_ARRAY_pending', 'arrays', 'enum_arr_ARRAY_pending', 'script', NULL),
(450, 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', NULL),
(451, 'enum_arr_ARRAY_Yes', 'arrays', 'enum_arr_ARRAY_Yes', 'script', NULL),
(452, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(453, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(454, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(455, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(456, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(457, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(458, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(459, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(460, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(461, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(462, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(463, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(464, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(465, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(466, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(467, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(468, 'error_bodies_ARRAY_AE09', 'arrays', 'error_bodies_ARRAY_AE09', 'script', NULL),
(469, 'error_bodies_ARRAY_AE10', 'arrays', 'error_bodies_ARRAY_AE10', 'script', NULL),
(470, 'error_bodies_ARRAY_AEQ01', 'arrays', 'error_bodies_ARRAY_AEQ01', 'script', NULL),
(471, 'error_bodies_ARRAY_AEQ03', 'arrays', 'error_bodies_ARRAY_AEQ03', 'script', NULL),
(472, 'error_bodies_ARRAY_AEQ04', 'arrays', 'error_bodies_ARRAY_AEQ04', 'script', NULL),
(473, 'error_bodies_ARRAY_AEQ08', 'arrays', 'error_bodies_ARRAY_AEQ08', 'script', NULL),
(474, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(475, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(476, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(477, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(478, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(479, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(480, 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', NULL),
(481, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(482, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(483, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(484, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(485, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(486, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(487, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(488, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(489, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(490, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(491, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(492, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(493, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(494, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(495, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(496, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(497, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(498, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(499, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(500, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(501, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(502, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(503, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(504, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
(505, 'error_titles_ARRAY_AE09', 'arrays', 'error_titles_ARRAY_AE09', 'script', NULL),
(506, 'error_titles_ARRAY_AE10', 'arrays', 'error_titles_ARRAY_AE10', 'script', NULL),
(507, 'error_titles_ARRAY_AEQ01', 'arrays', 'error_titles_ARRAY_AEQ01', 'script', NULL),
(508, 'error_titles_ARRAY_AEQ03', 'arrays', 'error_titles_ARRAY_AEQ03', 'script', NULL),
(509, 'error_titles_ARRAY_AEQ04', 'arrays', 'error_titles_ARRAY_AEQ04', 'script', NULL),
(510, 'error_titles_ARRAY_AEQ08', 'arrays', 'error_titles_ARRAY_AEQ08', 'script', NULL),
(511, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(512, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(513, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(514, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(515, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(516, 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', NULL),
(517, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(518, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(519, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(520, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(521, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(522, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(523, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(524, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(525, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(526, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(527, 'front_booking_statuses_ARRAY_0', 'arrays', 'front_booking_statuses_ARRAY_0', 'script', NULL),
(528, 'front_booking_statuses_ARRAY_1', 'arrays', 'front_booking_statuses_ARRAY_1', 'script', NULL),
(529, 'how_often_ARRAY_many', 'arrays', 'how_often_ARRAY_many', 'script', NULL),
(530, 'how_often_ARRAY_once', 'arrays', 'how_often_ARRAY_once', 'script', NULL),
(531, 'how_often_ARRAY_weekly', 'arrays', 'how_often_ARRAY_weekly', 'script', NULL),
(532, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(533, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(534, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(535, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(536, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(537, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(538, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(539, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(540, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(541, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(542, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(543, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(544, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(545, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(546, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(547, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(548, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(549, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(550, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(551, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(552, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(553, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(554, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(555, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(556, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(557, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(558, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(559, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(560, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(561, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(562, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(563, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(564, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(565, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(566, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(567, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(568, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(569, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(570, 'role_arr_ARRAY_1', 'arrays', 'role_arr_ARRAY_1', 'script', NULL),
(571, 'role_arr_ARRAY_2', 'arrays', 'role_arr_ARRAY_2', 'script', NULL),
(572, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(573, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(574, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(575, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(576, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(577, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(578, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(579, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(580, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(581, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(582, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(583, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(584, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(585, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(586, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(587, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(588, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(589, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(590, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(591, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(592, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(593, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(594, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(595, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(596, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(597, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(598, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(599, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(600, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(601, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(602, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(603, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(604, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(605, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(606, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(607, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(608, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(609, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(610, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(611, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(612, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(613, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(614, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(615, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(616, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(617, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(618, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(619, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(620, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(621, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(622, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(623, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(624, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(625, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(626, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(627, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(628, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(629, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(630, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(631, 'when_options_ARRAY_lunch', 'arrays', 'when_options_ARRAY_lunch', 'script', NULL),
(632, 'when_options_ARRAY_morning', 'arrays', 'when_options_ARRAY_morning', 'script', NULL),
(633, 'when_options_ARRAY_night', 'arrays', 'when_options_ARRAY_night', 'script', NULL),
(634, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(635, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL);

INSERT INTO `cbs_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Send Confirmation Email', 'script'),
(NULL, 5, 'pjField', 1, 'title', '+ Add days off', 'script'),
(NULL, 6, 'pjField', 1, 'title', '+ Add client', 'script'),
(NULL, 7, 'pjField', 1, 'title', '+ Add enquiry', 'script'),
(NULL, 8, 'pjField', 1, 'title', '+ Add extra', 'script'),
(NULL, 9, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 10, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Calculate Total', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 24, 'pjField', 1, 'title', '+ Add client', 'script'),
(NULL, 25, 'pjField', 1, 'title', '+ Add enquiry', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Cleaning <br/>services today', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Cleaning <br/>service today', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'enquiries last month', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'enquiries last week', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Enquiries <br/>received today', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'enquiries this month', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'enquiries this week', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'enquiry last month', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'enquiry last week', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Enquiry <br/>received today', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'enquiry this month', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'enquiry this week', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Latest enquiries', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'No enquiries found.', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Quick links & Stats', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Today services', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Total <br/>enquiries', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 70, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Fill in the form below and click the "Save" button to add a new client.', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Add Client', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Create the additional service and add the estimated time that will be necessary to provide it. If the client selects it, the time needed will be automatically added to the enquiry summary.', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Extra service details', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Fill in the form below and "save" to add a new user.', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Please, fill in the client information before saving the enquiry.', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Below is a list of clients who have submitted enquiries for your cleaning services.', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Here you can choose your payment methods, set payment gateway accounts and preferences.', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Review all enquiries submitted online and added from the admin system. Using the quick buttons below, you can manually add a new enquiry, change its status, edit enquiry details, browse and delete enquiries. ', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Enquiries list', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Enquiry options', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'View enquiry and change its details if necessary. You can also print it or resend email confirmation message to your client.', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Enquiry details', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the enquiry form, otherwise select ''No''.', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Enquiry form', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Add all additional services that you offer. Your clients will be able to select as many extra services as they need.', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Extra services', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Configure the general settings for your Cleaning Business Software.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Please copy the install code below and put it on your web page.', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use.', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'There are multiple color schemes available for the front-end. Click on each of the thumbnails below to preview themes. Press "Use this theme" button to enable it. Then scroll down and copy/paste the Install code on your web page.', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Preview front end', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Please define the template that will be used to print the enquiries.', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Print template', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Add an hourly rate for your cleaning services, as well as a separate price for cleaning materials. Specify cleaning duration time for each bed- and bathroom. The final price will be calculated on the base of the property size specified by clients.', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Services & Prices', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Please, enter your Terms & Conditions and click "Save".', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Terms & Conditions', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Set the automated email notifications sent to script admins. Please, note that if you wish to activate the SMS notification feature, you need to request a valid API Key and enter it in the designated SMS menu (see above).', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Notifications sent to script administrators', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Below you can create different types of auto-responders triggered by different events, such as new enquiry, new payment received, and cancellation. Please, note that if you wish to activate the SMS notification feature, you need to request a valid API Key and enter it in the designated SMS menu (see above).', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Notifications sent to customers', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Use the form below to change profile details for this client.', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Update Client', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Update the extra service using the form below.', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Update extra service', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update the user information.', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Below is a list of all users. You can add new users, edit user details and change user status. ', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Tell your clients what is included in your standard cleaning service. They will be able to see this information on the enquiry form.', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Allow the use of customer''s cleaning materials.', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Use the tokens below to personalize your email messages. <br/><br/><label>{DateTime}</label><label>{PricePerHour}</label><label>{Bedrooms}</label><label>{Bathrooms}</label><label>{Extras}</label><label>{Instructions}</label><label>{UniqueID}</label><label>{SubTotal}</label><label>{Deposit}</label><label>{Total}</label><label>{Tax}</label><label>{PaymentMethod}</label><label>{CCType}</label><label>{CCNum}</label><label>{CCExp}</label><label>{CCSec}</label><label>{Title}</label><label>{Name}</label><label>{Email}</label><label>{Phone}</label><label>{Country}</label><label>{City}</label><label>{State}</label><label>{Zip}</label><label>{Address}</label><label>{CancelURL}</label>', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Bathrooms', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Bedrooms', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Choose color theme', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Cleaning materials price', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Copy', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Created on', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Date & time', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Delete icon', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Are you sure that you want to delete this icon?', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Do you have all necessary cleaning chemicals and tools?', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Duplicate', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Email is already used.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'enquiries received', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Enquiry ID', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'enquiry received', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Extra', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'First enquiry', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'first on', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'How often do you need our cleaning services?', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Icon', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'I''ll hide the key', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Last enquiry', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Maximum bathrooms', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Maximum bedrooms', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'minutes', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'New client', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'No categories added. Click {STAG}here{ETAG} to add.', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Enquiry with such ID does not exist.', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'on', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Price per hour', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Print enquiry', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Send Email', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Send Confirmation Email', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Someone is at home', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Time needed', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Time per bathroom', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Time per bedroom', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'When', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Date & time', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Property details', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Special instructions', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Is DEFAULT', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Services & Prices', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a enquiry cancelled. ', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new enquiry made. ', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new payment made. ', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Enquiry confirmation SMS', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Allow payments with Authorize.Net', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Allow cash payments', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Authorize.Net MD5 hash', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Authorize.Net merchant ID', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Authorize.Net time zone', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Authorize.Net transaction key', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'All enquiries which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Request cleaning service', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'day(s) in advance', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Cancel confirmation message', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for cancelling their enquiries.', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'New enquiry received email', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'New enquiry confirmation message', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'New enquiry confirmation subject', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to let your customers know that you received their enquiries. ', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Payment confirmation message', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Payment confirmation subject', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for receiving their payment.', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Select "Yes" if you want to disable payments and only collect enquiry details ', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'All enquiries which are made and paid will be set with the following status', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'PayPal business email address', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Enquiry Confirmation SMS', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Terms & Conditions', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.Net payment', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Please enter only digits', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Please enter a valid number.', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Client Details', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Days off', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Enquiry Details', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Enquiry form', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Print template', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Services & Prices', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'To administrators', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'To customers', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'What''s included', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Request extra services', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'I agree with the {STAG}Terms & Conditions{ETAG}.', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Bathrooms', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Bedrooms', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Enquiry Details', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Enquiry ID', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Start over', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Enquiry ID', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Cleaning materials', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Comments or Instructions', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Date & time', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Do you have all necessary cleaning chemicals and tools?', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Enquiry completed', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'hours requested', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'How big is your home?', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Please let us know your choose.', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'How often do you need our cleaning services?', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'I''ll hide the key', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Transaction ID', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Please, let us know how big your home is.', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'We will provide all necessary cleaning materials for {PRICE} extra.', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Service Details', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Set Date & Time', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Checkout', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Confirmation', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Notes and comments', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Set Date & Time', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Please select a date.', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Price per hour', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Note that this will extend the cleaning time.', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Services included by default', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Select date:', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Select date for the first cleaning', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Someone is at home', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Terms & Conditions', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'When', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Your Address', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Enquiry summary', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Your Details', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Enquiry confirmation SMS', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Enquiry with such ID does not exist.', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'The enquiry has been cancelled successfully.', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Enquiry is already cancelled.', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'New enquiry received email', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Enquiry confirmation SMS', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Yes (required)', 'script'),
(NULL, 442, 'pjField', 1, 'title', '24 Hour', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'PHP mail()', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Afternoon', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'SMTP', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'We are sorry, but the client has not been added.', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Client your looking for is missing.', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'All changes made to the extra have been saved.', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'New extra has been added into the system.', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'The extra could not bee added successfully. Please try again.', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'The extra you are looking for is missing.', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'New extra has been added, but icon could not be uploaded successfully.', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'The extra has been updated, but icon could not be uploaded successfully.', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'All changes made to the enquiry have been saved.', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'New enquiry has been added into the system.', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'The enquiry could not bee added successfully. Please try again.', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'The enquiry you are looking for is missing.', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'All the changes made to General Options have been saved.', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'All changes made to the Enquiry options have been saved successfully.', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'All changes made to enquiry form have been saved successfully.', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'All changes made to Terms & Conditions have been saved!', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'All changes made to Print template have been saved successfully.', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'All changes made to the enquiry have been updated.', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'New enquiry has been added into the system.', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'We are sorry that new enquiry could not be added successfully. Please try again.', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'We are sorry that enquiry you are looking for is missing.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Client updated!', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Client added!', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Client failed to add.', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Client not found.', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'Extra updated!', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Extra added!', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Extra failed to add!', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Extra not found', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Upload error!', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Enquiry updated!', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Enquiry added!', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Enquiry failed to add!', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Enquiry not found', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Enquiry options updated!', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Enquiry form updated!', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Terms & Conditions updated!', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Print template updated!', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'Enquiry updated!', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Enquiry added!', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Enquiry not added!', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Enquiry not found!', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Please, wait while you are redirected to the secure payment processor webpage!', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'Thank you! You have successfully requested our cleaning services! To make another enquiry, please, click on "Start over".', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Multiple times a week', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Once only', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Once a week', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Authorize.Net', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Wire transfer', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Editor', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'No property for the enquiry found', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'No enquiry found', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'No permisions to edit the enquiry', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Noon', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Morning', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Afternoon', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1, 'pjOption', 1, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed non convallis sapien, non pulvinar sem. Aenean interdum aliquam vehicula. In aliquet sollicitudin orci vitae commodo. Cras gravida, tellus eget tempus faucibus, tellus enim commodo risus, sed pulvinar dolor lorem ac est. Integer quis pellentesque nulla, vitae placerat eros. Quisque id sem non ante pulvinar consectetur. Vivamus et venenatis ex. Nam tellus ipsum, fermentum non sapien quis, efficitur euismod mauris. Morbi et felis sapien. Fusce est felis, semper non ante id, feugiat accumsan leo. Nulla laoreet tincidunt tellus eu dignissim. Nam a leo ut augue dignissim ultrices quis vel libero. Duis tempor turpis quam, vel scelerisque sem feugiat ut. Pellentesque velit ex, commodo a facilisis tincidunt, porttitor nec elit. Proin elit arcu, iaculis eget aliquet eu, fringilla sed sem. Suspendisse malesuada aliquam est, a blandit tellus eleifend at.\r\n\r\nDonec mi sem, ultrices quis sagittis quis, venenatis at nibh. Pellentesque porta sem eget nibh sodales, eget dictum metus tempor. Vivamus ullamcorper sit amet arcu ut finibus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Quisque ac pulvinar urna. Etiam mattis, est id egestas bibendum, libero dui bibendum orci, vitae pharetra eros augue a nunc. Nam in diam id nunc tristique faucibus elementum nec magna. Mauris a ipsum vel quam tristique blandit suscipit placerat risus. Vestibulum dictum massa dui, vel ullamcorper nunc varius quis. Nullam vitae nisl ultricies, tempor massa at, viverra erat.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', 'Enquiry Received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', '<p>Dear&nbsp;{Name},</p>\r\n<p>&nbsp;</p>\r\n<p>your enquiry has been received.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Service Details</strong></p>\r\n<p>Bedrooms:&nbsp;{Bedrooms}</p>\r\n<p>Bathrooms:&nbsp;{Bathrooms}</p>\r\n<p>Extras:&nbsp;{Extras}</p>\r\n<p>Date/time:&nbsp;{DateTime}</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Address</strong></p>\r\n<p>Address:&nbsp;{Address}</p>\r\n<p>City: {City}</p>\r\n<p>&nbsp;</p>\r\n<p>Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', '<p>Dear&nbsp;{Name},</p>\r\n<p>&nbsp;</p>\r\n<p>payment for your enquiry has been received.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Service Details</strong></p>\r\n<p>Bedrooms:&nbsp;{Bedrooms}</p>\r\n<p>Bathrooms:&nbsp;{Bathrooms}</p>\r\n<p>Extras:&nbsp;{Extras}</p>\r\n<p>Date/time:&nbsp;{DateTime}</p>\r\n<p>&nbsp;</p>\r\n<p>Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', 'Enquiry Cancelled', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', '<p>Dear&nbsp;{Name},</p>\r\n<p>&nbsp;</p>\r\n<p>your enquiry has been cancelled.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Service Details</strong></p>\r\n<p>Bedrooms:&nbsp;{Bedrooms}</p>\r\n<p>Bathrooms:&nbsp;{Bathrooms}</p>\r\n<p>Extras:&nbsp;{Extras}</p>\r\n<p>Date/time:&nbsp;{DateTime}</p>\r\n<p>&nbsp;</p>\r\n<p>Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', 'New enquiry ID: {UniqueID}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_payment_message', 'Payment reminder for enquiry ID: {UniqueID}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', 'New Enquiry received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', '<p>New enquiry has been received.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Service Details</strong></p>\r\n<p>Bedrooms:&nbsp;{Bedrooms}</p>\r\n<p>Bathrooms:&nbsp;{Bathrooms}</p>\r\n<p>Extras:&nbsp;{Extras}</p>\r\n<p>Date/time:&nbsp;{DateTime}</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Address</strong></p>\r\n<p>Address:&nbsp;{Address}</p>\r\n<p>City: {City}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', 'New payment received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', '<p>New payment has been received.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Service Details</strong></p>\r\n<p>Bedrooms:&nbsp;{Bedrooms}</p>\r\n<p>Bathrooms:&nbsp;{Bathrooms}</p>\r\n<p>Extras:&nbsp;{Extras}</p>\r\n<p>Date/time:&nbsp;{DateTime}</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Address</strong></p>\r\n<p>Address:&nbsp;{Address}</p>\r\n<p>City: {City}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', 'Enquiry cancelled', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', '<p>Enquiry has been cancelled.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Service Details</strong></p>\r\n<p>Bedrooms:&nbsp;{Bedrooms}</p>\r\n<p>Bathrooms:&nbsp;{Bathrooms}</p>\r\n<p>Extras:&nbsp;{Extras}</p>\r\n<p>Date/time:&nbsp;{DateTime}</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Address</strong></p>\r\n<p>Address:&nbsp;{Address}</p>\r\n<p>City: {City}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_print_template', '<table border="1" width="600" cellpadding="2">\r\n<tbody>\r\n<tr>\r\n<td colspan="2" align="center" bgcolor="#CCCCCC">\r\n<h2>Enquiry {UniqueID}</h2>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign="top" width="471">\r\n<p><strong>CLIENT DETAILS</strong></p>\r\n<p>{Name}</p>\r\n<p>{Phone}</p>\r\n<p>{Email}</p>\r\n</td>\r\n<td valign="top" width="297">\r\n<p><strong>SERVICE DETAILS</strong></p>\r\n<p>Bedrooms: {Bedrooms}</p>\r\n<p>Bathrooms: {Bathrooms}</p>\r\n<p>Extras: {Extras}</p>\r\n<p>&nbsp;</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign="top">\r\n<p><strong>ADDRESS</strong></p>\r\n<p>City: {City}</p>\r\n<p>Address: {Address}</p>\r\n<p>{Instructions}</p>\r\n</td>\r\n<td valign="top">\r\n<p><strong>PAYMENT</strong></p>\r\n<p>Subtotal: {SubTotal}</p>\r\n<p>Deposit: {Deposit}</p>\r\n<p>Total: {Total}</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', 'data');

INSERT INTO `cbs_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 13, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_deposit_payment', 2, '10', NULL, 'int', 2, 1, NULL),
(1, 'o_tax_payment', 2, '10.00', NULL, 'int', 4, 1, NULL),
(1, 'o_days_before', 2, '1', NULL, 'int', 5, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 7, 1, NULL),
(1, 'o_thankyou_page', 2, 'https://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 9, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 20, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 7, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 9, 1, NULL),

(1, 'o_admin_email_confirmation', 4, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 4, '', NULL, 'string', 8, 1, NULL),
(1, 'o_admin_email_confirmation_message', 4, '', NULL, 'text', 9, 1, NULL),
(1, 'o_admin_email_payment', 4, '0|1::1', 'No|Yes', 'enum', 10, 1, NULL),
(1, 'o_admin_email_payment_subject', 4, '', NULL, 'string', 11, 1, NULL),
(1, 'o_admin_email_payment_message', 4, '', NULL, 'text', 12, 1, NULL),
(1, 'o_admin_email_cancel', 4, '0|1::1', 'No|Yes',  'enum', 13, 1, NULL),
(1, 'o_admin_email_cancel_subject', 4, '', NULL, 'string', 14, 1, NULL),
(1, 'o_admin_email_cancel_message', 4, '', NULL, 'text', 15, 1, NULL),

(1, 'o_sms_confirmation_message', 5, '', NULL, 'text', 2, 1, NULL),
(1, 'o_sms_payment_message', 5, '', NULL, 'text', 3, 1, NULL),

(1, 'o_admin_sms_confirmation_message', 6, '', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_sms_payment_message', 6, '', NULL, 'text', 5, 1, NULL),

(1, 'o_bf_include_title', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_name', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_email', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_address', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_country', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_state', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_city', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
(1, 'o_bf_include_zip', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_notes', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_captcha', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 15, 1, NULL),

(1, 'o_terms', 8, '', NULL, 'text', 1, 1, NULL),

(1, 'o_print_template', 9, '', NULL, 'text', 1, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `cbs_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

INSERT INTO `cbs_services` (`id`, `price_per_hour`, `allow_using_materials`, `cleaning_materials_price`, `max_bedrooms`, `time_per_bedroom`, `max_bathrooms`, `time_per_bathroom`) VALUES
(1, NULL, 'T', NULL, 4, 30, 4, 30);