<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	
	$_yesno = __('_yesno', true);
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEnquiries&amp;action=pjActionUpdate" method="post" class="form pj-form" id="frmUpdateEnquiry">
		<input type="hidden" name="enquiry_update" value="1"/>
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>"/>
		
		<input type="hidden" id="price_per_hour" name="price_per_hour" value="<?php echo $tpl['arr']['price_per_hour'];?>"/>
		<input type="hidden" id="cleaning_materials_price" name="cleaning_materials_price" value="<?php echo $tpl['arr']['cleaning_materials_price'];?>"/>
		<input type="hidden" id="time_per_bathroom" name="time_per_bathroom" value="<?php echo $tpl['arr']['time_per_bathroom'];?>"/>
		<input type="hidden" id="time_per_bedroom" name="time_per_bedroom" value="<?php echo $tpl['arr']['time_per_bedroom'];?>"/>
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('tabEnquiryDetails');?></a></li>
				<li><a href="#tabs-2"><?php __('tabClientDetails');?></a></li>
			</ul>
			<div id="tabs-1">
				<?php pjUtil::printNotice(__('infoEnquiryDetailsTitle', true, false), __('infoEnquiryDetailsDesc', true, false)); ?>
				<div class="pj-loader-outer">
					<div class="pj-loader"></div>
					
					<div class="float_left w50p overflow">
						<fieldset class="fieldset white">
							<legend><?php __('legendDateTime'); ?></legend>
							<?php
							$how_often = pjUtil::sortArrayByArray( __('how_often', true), array('once', 'weekly', 'many'));
							$when_options = pjUtil::sortArrayByArray( __('when_options', true), array('morning', 'lunch', 'night'));
							?>
							<p>
								<label class="title"><?php __('lblHowOften'); ?></label>
								<span class="inline_block">
									<select name="how_often" id="how_often" class="pj-form-field w180 required" data-msg-required="<?php __('pj_field_required');?>">
										<option value="">-- <?php __('lblChoose'); ?> --</option>
										<?php
										foreach($how_often as $k => $v)
										{
											?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['how_often'] ? ' selected="selected"' : NULL;?>><?php echo stripslashes($v); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblDate'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-after">
									<input type="text" name="date" id="date" class="pj-form-field pointer w100 datepicker required" value="<?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['date']));?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
									<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblWhen'); ?></label>
								<span class="inline_block">
									<select name="when" id="when" class="pj-form-field w100 required" data-msg-required="<?php __('pj_field_required');?>">
										<option value="">-- <?php __('lblChoose'); ?> --</option>
										<?php
										foreach($when_options as $k => $v)
										{
											?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['when'] ? ' selected="selected"' : NULL;?>><?php echo stripslashes($v); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							
							<p>
								<label class="title">&nbsp;</label>
								<span class="inline_block">
									<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
									<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEnquiries&action=pjActionIndex';" />
								</span>
							</p>
						</fieldset>
						<fieldset class="fieldset white">
							<legend><?php __('legendHowBigIsYourHome'); ?></legend>
							<p>
								<label class="title"><?php __('lblBedrooms'); ?></label>
								<span class="inline_block">
									<select name="bedrooms" id="bedrooms" class="pj-form-field w150 required" data-msg-required="<?php __('pj_field_required');?>">
										<option value="">-- <?php __('lblChoose'); ?> --</option>
										<?php
										for($i = 0; $i <= (int) $tpl['service_arr']['max_bedrooms']; $i++ )
										{
											?><option value="<?php echo $i; ?>"<?php echo $i == $tpl['arr']['bedrooms'] ? ' selected="selected"' : NULL;?>><?php echo stripslashes($i); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblBathrooms'); ?></label>
								<span class="inline_block">
									<select name="bathrooms" id="bathrooms" class="pj-form-field w150 required" data-msg-required="<?php __('pj_field_required');?>">
										<option value="">-- <?php __('lblChoose'); ?> --</option>
										<?php
										for($i = 0; $i <= (int) $tpl['service_arr']['max_bathrooms']; $i++ )
										{
											?><option value="<?php echo $i; ?>"<?php echo $i == $tpl['arr']['bathrooms'] ? ' selected="selected"' : NULL;?>><?php echo stripslashes($i); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<?php
							if($tpl['service_arr']['allow_using_materials'] == 'T')
							{ 
								?>
								<p>
									<label class="title"><?php __('lblDoYouHaveMaterials');?></label>
									<span class="inline_block t5">
										<span class="block float_left r20">
											<input type="radio" id="cleaning_materials_yes" name="cleaning_materials"<?php echo $tpl['arr']['cleaning_materials'] == 'F' ? ' checked="checked"' : NULL; ?> value="T" class="block float_left r3 pjCbsCleaningMaterials"/>
											<label for="cleaning_materials_yes" class="block float_left"><?php echo $_yesno['T'];?></label>
										</span>
										<span class="block float_left r20">
											<input type="radio" id="cleaning_materials_no" name="cleaning_materials"<?php echo $tpl['arr']['cleaning_materials'] == 'F' ? ' checked="checked"' : NULL; ?> value="F" class="block float_left r3 pjCbsCleaningMaterials"/>
											<label for="cleaning_materials_no" class="block float_left"><?php echo $_yesno['F'];?></label>
										</span>
									</span>
								</p>
								<?php
							} 
							?>
							
							<p>
								<label class="title">&nbsp;</label>
								<span class="inline_block">
									<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
									<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEnquiries&action=pjActionIndex';" />
								</span>
							</p>
						</fieldset>
						<?php
						if(!empty($tpl['extra_arr']))
						{
							?>
							<fieldset class="fieldset white">
								<legend><?php __('legendExtras'); ?></legend>
								<table class="pj-table" style="width: 100%; margin-bottom: 10px;">
									<thead>
										<tr>
											<th width="20">&nbsp;</th>
											<th><?php __('lblName');?></th>
											<th><?php __('lblTimeNeeded');?></th>
										</tr>
									</thead>
									<tbody>
										<?php
										foreach($tpl['extra_arr'] as $k => $v)
										{
											?>
											<tr>
												<td>
													<input type="checkbox" id="pjCcCustomCheckboxExtra<?php echo $v['id'];?>" name="extra_id[<?php echo $v['id'];?>]"<?php echo in_array($v['id'], $tpl['enquiry_extra_id']) ? ' checked="checked"' : NULL;?> class="pjCbsExtrasCheckbox" data-time="<?php echo $v['time_needed'];?>" autocomplete="off" />
												</td>
												<td><?php echo pjSanitize::html($v['name']);?></td>
												<td>+<?php echo pjUtil::convertToHoursMins($v['time_needed']);?></td>
											</tr>
											<?php
										} 
										?>
									</tbody>
								</table>
								
								<div class="overflow">
									<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
								</div>
							</fieldset>
							<?php
						}
						
						?>
					</div>
					<div class="float_right w49p overflow">
						<fieldset class="fieldset white">
							<legend><?php __('legendDetails'); ?></legend>
							<p>
								<label class="title"><?php __('lblEnquiryID');?></label>
								<span class="inline_block t5">
									<?php echo pjSanitize::html($tpl['arr']['uuid']);?>	
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblIpAddress');?></label>
								<span class="inline_block t5">
									<?php echo pjSanitize::html($tpl['arr']['ip']);?>	
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblCreatedOn');?></label>
								<span class="inline_block t5">
									<?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created']));?>	
								</span>
							</p>
							<p>
								<span class="block overflow">
									<span class="inline_block t5 float_left"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEnquiries&amp;action=pjActionPrint&amp;id=<?php echo $tpl['arr']['id']; ?>" target="_blank"><?php __('lblPrint'); ?></a></span>	
									<span class="inline_block t5" style="margin-left: 102px;"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEnquiries&amp;action=pjActionCreate&amp;id=<?php echo $tpl['arr']['id']; ?>" ><?php __('lblDuplicate'); ?></a></span>	
									<span class="inline_block t5 float_right"><a href="#" class="pjCbsSendConfirm" data-id="<?php echo $tpl['arr']['id']?>"><?php __('lblSendEmail'); ?></a></span>
								</span>
							</p>
						</fieldset>
						<fieldset class="fieldset white">
							<legend><?php __('legendPayment'); ?></legend>
							
							<p>
								<label class="title"><?php __('lblStatus'); ?></label>
								<span class="inline_block">
									<select name="status" id="status" class="pj-form-field w150 required" data-msg-required="<?php __('pj_field_required');?>">
										<option value="">-- <?php __('lblChoose'); ?> --</option>
										<?php
										foreach (__('enquiry_statuses', true) as $k => $v)
										{
											?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL;?>><?php echo stripslashes($v); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblPaymentMethod');?></label>
								<span class="inline-block">
									<select name="payment_method" id="payment_method" class="pj-form-field w150 required" data-msg-required="<?php __('pj_field_required');?>">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach (__('payment_methods', true, false) as $k => $v)
										{
											?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['payment_method'] ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<?php $isCC = $tpl['arr']['payment_method'] == 'creditcard'; ?>
							<p class="boxCC" style="display: <?php echo !$isCC ? 'none' : NULL; ?>;">
								<label class="title"><?php __('lblCCType'); ?></label>
								<span class="inline-block">
									<select name="cc_type" class="pj-form-field w150" data-msg-required="<?php __('pj_field_required');?>">
										<option value="">---</option>
										<?php
										foreach (__('cc_types', true, false) as $k => $v)
										{
											?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['cc_type'] ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<p class="boxCC" style="display: <?php echo !$isCC ? 'none' : NULL; ?>;">
								<label class="title"><?php __('lblCCNum'); ?></label>
								<span class="inline-block">
									<input type="text" name="cc_num" id="cc_num" value="<?php echo pjSanitize::html($tpl['arr']['cc_num']);?>" class="pj-form-field w136" data-msg-required="<?php __('pj_field_required');?>"/>
								</span>
							</p>
							<p class="boxCC" style="display: <?php echo !$isCC ? 'none' : NULL; ?>;">
								<label class="title"><?php __('lblCCExp'); ?></label>
								<span class="inline-block">
									<select name="cc_exp_month" class="pj-form-field w100" data-msg-required="<?php __('pj_field_required');?>">
										<?php
										$month_arr = __('months', true, false);
										ksort($month_arr);
										foreach ($month_arr as $key => $val)
										{
											?><option value="<?php echo $key;?>"<?php echo $key == $tpl['arr']['cc_exp_month'] ? ' selected="selected"' : NULL;?>><?php echo $val;?></option><?php
										}
										?>
									</select>
									<select name="cc_exp_year" class="pj-form-field" data-msg-required="<?php __('pj_field_required');?>">
										<?php
										$y = (int) date('Y');
										for ($i = $y; $i <= $y + 10; $i++)
										{
											?><option value="<?php echo $i; ?>"<?php echo $i == $tpl['arr']['cc_exp_year'] ? ' selected="selected"' : NULL;?>><?php echo $i; ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<p class="boxCC" style="display: <?php echo !$isCC ? 'none' : NULL; ?>">
								<label class="title"><?php __('lblCCCode'); ?></label>
								<span class="inline-block">
									<input type="text" name="cc_code" id="cc_code" value="<?php echo pjSanitize::html($tpl['arr']['cc_code']);?>" class="pj-form-field w100" data-msg-required="<?php __('pj_field_required');?>"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblSubTotal'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="subtotal" name="subtotal" value="<?php echo $tpl['arr']['subtotal']; ?>" class="pj-form-field number w80" readonly="readonly"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblTax'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="tax" name="tax" value="<?php echo $tpl['arr']['tax']; ?>" class="pj-form-field number w80" data-tax="<?php echo $tpl['option_arr']['o_tax_payment'];?>" readonly="readonly"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblTotal'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="total" name="total" value="<?php echo $tpl['arr']['total']; ?>" class="pj-form-field number w80" readonly="readonly"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblDeposit'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="deposit" name="deposit" value="<?php echo $tpl['arr']['deposit']; ?>" class="pj-form-field number w80" data-deposit="<?php echo $tpl['option_arr']['o_deposit_payment'];?>" readonly="readonly"/>
								</span>
							</p>
							<p>
								<label class="title">&nbsp;</label>
								<span class="inline_block">
									<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
									<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEnquiries&action=pjActionIndex';" />
								</span>
							</p>
						</fieldset>
						
						<fieldset class="fieldset white">
							<legend><?php __('lengendInstructions'); ?></legend>
							<p>
								<span class="block overflow t5">
									<span class="block overflow b5">
										<input type="radio" id="home_someone" name="home" value="someone"<?php echo $tpl['arr']['home'] == 'someone' ? ' checked="checked"' : NULL; ?> checked="checked" class="block float_left r3"/>
										<label for="home_someone" class="block float_left"><?php __('lblSomeoneInHome');?></label>
									</span>
									<span class="block">
										<input type="radio" id="home_hidekey" name="home"<?php echo $tpl['arr']['home'] == 'hidekey' ? ' checked="checked"' : NULL; ?> value="hidekey" class="block float_left r3"/>
										<label for="home_hidekey" class="block float_left"><?php __('lblIWillHideTheKey');?></label>
									</span>
								</span>
							</p>
							<p>
								<span class="inline-block">
									<textarea name="c_notes" id="c_notes" class="pj-form-field h120<?php echo $tpl['option_arr']['o_bf_include_notes'] == 3 ? ' required' : NULL; ?>" style="width: 316px;" data-msg-required="<?php __('pj_field_required');?>"><?php echo htmlspecialchars(stripslashes($tpl['arr']['c_notes'])); ?></textarea>
								</span>
							</p>
						</fieldset>
							
					</div>
					
				</div>
			</div><!-- #tabs-1 -->
			<div id="tabs-2">
				<?php pjUtil::printNotice(__('infoClientDetailsTitle', true, false), __('infoClientDetailsDesc', true, false)); ?>
				
				<p>
					<label class="title"><?php __('lblClient');?></label>
					<span class="inline-block">
						<select name="client_id" id="client_id" class="pj-form-field w200">
							<option value="">-- <?php __('lblNewClient'); ?>--</option>
							<?php
							$selected_info = NULL;
							foreach ($tpl['client_arr'] as $k => $v)
							{
								$info = NULL;
								if((int) $v['cnt_enquiries'] != 1)
								{
									$info_arr = array();
									$info_arr[] = $v['cnt_enquiries'] . ' ' . __('lblEnquiriesReceived', true);
									$info_arr[] = __('lblFirstOn', true) . ' ' . date($tpl['option_arr']['o_date_format'], strtotime($v['first']));
									$info = join(", ", $info_arr);
								}else{
									$info_arr = array();
									$info_arr[] = $v['cnt_enquiries'] . ' ' . __('lblEnquiryReceived', true);
									$info_arr[] = __('lblOn', true) . ' ' . date($tpl['option_arr']['o_date_format'], strtotime($v['first']));
									$info = join(" ", $info_arr);
								}
								if($v['id'] == $tpl['arr']['client_id'])
								{
									$selected_info = $info;
								}
								?><option value="<?php echo $v['id']; ?>"<?php echo $v['id'] == $tpl['arr']['client_id'] ? ' selected="selected"' : NULL;?> data-info="<?php echo $info;?>"><?php echo pjSanitize::html($v['c_name'], array('remove' => true) ); ?></option><?php
							}
							?>
						</select>
						<a id="pjCbsEditURL" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate&amp;id=<?php echo $tpl['arr']['client_id'];?>" class="pj-edit" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate&amp;id={ID}"></a>
					</span>
				</p>
				<p style="display: <?php echo $selected_info != NULL ? 'block' : 'none';?>;">
					<label class="title">&nbsp;</label>
					<span id="clientInfo" class="inline-block"><?php echo $selected_info;?></span>
				</p>
				<?php
				if (in_array((int) $tpl['option_arr']['o_bf_include_title'], array(2,3)))
				{
					?>
					<p class="clientBox" style="display: none;">
						<label class="title"><?php __('lblResvTitle'); ?></label>
						<span class="inline-block">
							<select name="c_title" id="c_title" class="pj-form-field w150">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ( __('personal_titles', true, false) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_name'], array(2,3)))
				{ 
					?>
					<p class="clientBox" style="display: none;">
						<label class="title"><?php __('lblResvName'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_name" id="c_name" class="pj-form-field w400" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_email'], array(2,3)))
				{
					?>
					<p class="clientBox" style="display: none;">
						<label class="title"><?php __('lblResvEmail'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_email" id="c_email" class="pj-form-field email w400" data-msg-required="<?php __('pj_field_required');?>" data-msg-email="<?php __('pj_email_validation');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_phone'], array(2,3)))
				{ 
					?>
					<p class="clientBox" style="display: none;">
						<label class="title"><?php __('lblResvPhone'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_phone" id="c_phone" class="pj-form-field w400" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_address'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvAddress'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_address" id="c_address" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_address'])); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_address'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_city'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvCity'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_city" id="c_city" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_city'])); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_city'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_state'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvState'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_state" id="c_state" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_state'])); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_state'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_zip'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvZip'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_zip" id="c_zip" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_zip'])); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_zip'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_country'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvCountry'); ?></label>
						<span class="inline-block">
							<select name="c_country" id="c_country" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_country'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ($tpl['country_arr'] as $v)
								{
									?><option value="<?php echo $v['id']; ?>"<?php echo $v['id'] == $tpl['arr']['c_country'] ? ' selected="selected"' : NULL;?>><?php echo stripslashes($v['country_title']); ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<?php
				}
				?>
				
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEnquiries&action=pjActionIndex';" />
				</p>
			</div><!-- #tabs-2 -->
		</div>
		
	</form>
	
	<div id="dialogConfirmation" title="<?php __('booking_confirmation_title'); ?>" style="display: none"></div>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.currency = "<?php echo $tpl['option_arr']['o_currency'];?>";
	myLabel.choose = "-- <?php __('lblChoose'); ?> --";
	</script>
	<?php
}
?>