<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminServices&amp;action=pjActionIndex" method="post" id="frmUpdateService" class="form pj-form b10">
		<input type="hidden" name="service_update" value="1" />
		<input type="hidden" name="id" value="<?php echo (int) $tpl['arr']['id']; ?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('tabServicesPrice');?></a></li>
				<li><a href="#tabs-2"><?php __('tabWhatIncluded');?></a></li>
			</ul>
		
			<div id="tabs-1">
				<?php pjUtil::printNotice(__('infoServicesTitle', true), __('infoServicesDesc', true));?>
				<p>
					<label class="title"><?php __('lblPricePerHour'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" id="price_per_hour" name="price_per_hour" value="<?php echo pjSanitize::html($tpl['arr']['price_per_hour'])?>" class="pj-form-field number w100 required" data-msg-number="<?php __('pj_number_validation');?>"/>
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<input type="checkbox" id="allow_using_materials" name="allow_using_materials" class="block float_left r5"<?php echo $tpl['arr']['allow_using_materials'] == 'T' ? ' checked="checked"' : NULL; ?>/>
						<label for="allow_using_materials" class="block float_left"><?php __('lblAllowUsingMaterials');?></label>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblCleaningMaterialsPrice'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" id="cleaning_materials_price" name="cleaning_materials_price" value="<?php echo pjSanitize::html($tpl['arr']['cleaning_materials_price'])?>" class="pj-form-field number w100 required" data-msg-number="<?php __('pj_number_validation');?>"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblMaximumBedrooms'); ?></label>
					<span class="inline_block">
						<span class="block float_left r20">
							<input type="text" id="max_bedrooms" name="max_bedrooms" value="<?php echo pjSanitize::html($tpl['arr']['max_bedrooms'])?>" class="pj-form-field field-int w80 digits required" data-msg-digits="<?php __('pj_digits_validation');?>"/>
						</span>
						<span class="block float_left r20">
							<label class="block float_left t5 r5"><?php __('lblTimePerBedroom');?></label>
							<input type="text" id="time_per_bedroom" name="time_per_bedroom" value="<?php echo pjSanitize::html($tpl['arr']['time_per_bedroom'])?>" class="pj-form-field field-int w80 digits required" data-msg-digits="<?php __('pj_digits_validation');?>"/>
						</span>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblMaximumBathrooms'); ?></label>
					<span class="inline_block">
						<span class="block float_left r20">
							<input type="text" id="max_bathrooms" name="max_bathrooms" value="<?php echo pjSanitize::html($tpl['arr']['max_bathrooms'])?>" class="pj-form-field field-int w80 digits required" data-msg-digits="<?php __('pj_digits_validation');?>"/>
						</span>
						<span class="block float_left r20">
							<label class="block float_left t5 r5"><?php __('lblTimePerBathroom');?></label>
							<input type="text" id="time_per_bathroom" name="time_per_bathroom" value="<?php echo pjSanitize::html($tpl['arr']['time_per_bathroom'])?>" class="pj-form-field field-int w80 digits required" data-msg-digits="<?php __('pj_digits_validation');?>"/>
						</span>
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminUsers&action=pjActionIndex';" />
				</p>
			</div>
			<div id="tabs-2">
				<?php pjUtil::printNotice(NULL, __('infoWhatIncludedDesc', true));?>
				
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang"></div>
				<?php endif; ?>
				
				<div class="clear_both">
					
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<span class="inline_block">
								<textarea id="i18n_included_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][included]" class="pj-form-field mceEditor" style="width: 400px; height: 200px;"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['included'])); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					} 
					?>
					<p>
						<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminUsers&action=pjActionIndex';" />
					</p>
				</div>
			</div>
		</div>	
	</form>
	
	<div id="gridWrapper">
		<?php pjUtil::printNotice(__('infoExtrasTitle', true, false), __('infoExtrasDesc', true, false));?>
		<div class="b10">
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
				<input type="hidden" name="controller" value="pjAdminExtras" />
				<input type="hidden" name="action" value="pjActionCreate" />
				<input type="submit" class="pj-button" value="<?php __('btnAddExtra'); ?>" />
			</form>
			<form action="" method="get" class="float_left pj-form frm-filter">
				<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			</form>
			<br class="clear_both" />
		</div>
		
		<div id="grid"></div>
	</div>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.choose = "-- <?php __('lblChoose'); ?> --";
	myLabel.icon = "<?php __('lblIcon'); ?>";
	myLabel.extra = "<?php __('lblExtra'); ?>";
	myLabel.time_needed = "<?php __('lblTimeNeeded'); ?>";
	myLabel.status = "<?php __('lblStatus'); ?>";
	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
	</script>
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
		$tab_id = explode("-", $_GET['tab_id']);
		$tab_id = (int) $tab_id[1] - 1;
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "active", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>