<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFrontEnd extends pjFront
{
	public function __construct()
	{
		parent::__construct();
		$this->setAjax(true);
		$this->setLayout('pjActionEmpty');
	}

	public function pjActionLoad()
	{
		$this->setAjax(false);
		$this->setLayout('pjActionFront');
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
	}

	public function pjActionLoadCss()
	{
		$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
	
		$theme = isset($_GET['theme']) ? $_GET['theme'] : $this->option_arr['o_theme'];
		if((int) $theme > 0)
		{
			$theme = 'theme' . $theme;
		}
		$arr = array(
				array('file' => 'font-awesome.min.css', 'path' => $dm->getPath('font_awesome') . 'css/'),
				array('file' => 'tooltipster.css', 'path' => $dm->getPath('pj_tooltipster')),
				array('file' => 'pj-calendar.css', 'path' => PJ_FRAMEWORK_LIBS_PATH . 'pj/css/'),
				array('file' => 'style.css', 'path' => PJ_CSS_PATH),
				array('file' => "$theme.css", 'path' => PJ_CSS_PATH . 'themes/')
		);
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			ob_start();
			@readfile($item['path'] . $item['file']);
			$string = ob_get_contents();
			ob_end_clean();
	
			if ($string !== FALSE)
			{
				echo str_replace(
						array('../img/', '../fonts/glyphicons', '../fonts/fontawesome', '[URL]', "pjWrapper"),
						array(
								PJ_INSTALL_URL . PJ_IMG_PATH,
								PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/fonts/glyphicons',
								PJ_INSTALL_URL . $dm->getPath('font_awesome') . 'fonts/fontawesome',
								PJ_INSTALL_URL,
								"pjWrapperEBCalendar_" . $theme
						),
						$string
				) . "\n";
			}
		}
		exit;
	}
		
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		$this->setLayout('pjActionEmpty');
	
		header("Cache-Control: max-age=3600, private");
	
		$Captcha = new pjCaptcha(PJ_WEB_PATH . 'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH . 'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}
	
	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
	
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	
	public function pjActionBookingSave()
	{
		$this->setAjax(true);

		$pjEventModel = pjEventModel::factory();
		$pjBookingModel = pjBookingModel::factory();
		$pjBookingDetailModel = pjBookingDetailModel::factory();
		$pjBookingTicketModel = pjBookingTicketModel::factory();
	
		$event_id = $_POST['event_id'];
	
		$available = true;
		$price_arr = pjPriceModel::factory()
			->select("t1.*, (SELECT SUM(cnt) FROM `" .pjBookingDetailModel::factory()->getTable(). "` as `TBD` WHERE `TBD`.price_id = t1.id AND `TBD`.booking_id IN(SELECT `TB`.id FROM `".pjBookingModel::factory()->getTable()."` as `TB` WHERE `TB`.booking_status='confirmed' OR `TB`.booking_status='pending' )) as cnt_booked")
			->where('event_id', $event_id)
			->findAll()
			->getData();
		foreach($price_arr as $k => $v)
		{
			$price_id = $v['id'];
			if(isset($_POST['price_' . $price_id]))
			{
				if($_POST['price_' . $price_id] > 0)
				{
					if((intval($v['available']) - (intval($v['cnt_booked']) + intval($_POST['price_' . $price_id]))) < 0 )
					{
						$available = false;
						break;
					}
				}
			}
		}
		if($available == false)
		{
			pjAppController::jsonResponse(array('code' => 101, 'text' => __('front_unavailable_ticket_msg', true)));
		}
	
		$amount_arr = $this->calcPrice($_POST['total_price'], $this->option_arr);
	
		$data = array();
		$data['unique_id'] = pjUtil::getUniqueID();
		$data['booking_status'] = $this->option_arr['o_default_status_if_not_paid'];
		$data['booking_total'] = $amount_arr['total'];
		$data['booking_tax'] = $amount_arr['tax'];
		$data['booking_deposit'] = $amount_arr['deposit'];
		$data['payment_option']= 'deposit';
		$data['customer_ip']= $_SERVER['REMOTE_ADDR'];
	
		if (isset($_POST['payment_method']) && $_POST['payment_method'] == 'creditcard')
		{
			$data['cc_exp'] = $_POST['cc_exp_year'] . '-' . $_POST['cc_exp_month'];
		}
	
		$event_arr = $pjEventModel
			->reset()
			->select('t1.*, t2.content as ticket_detail')
			->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjEvent' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'ticket_info'", 'left')
			->find($event_id)
			->getData();
		if (count($event_arr) == 0)
		{
			$insert_id = false;
		} else {
			$insert_id = $pjBookingModel->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
		}
		if ($insert_id !== false && (int) $insert_id > 0)
		{
			$details = array();
			$tickets = array();
			$customer_people = 0;
			$ticket_number = 1;
			$details['booking_id'] = $insert_id;
			$tickets['booking_id'] = $insert_id;
				
			foreach($price_arr as $k => $v)
			{
				$price_id = $v['id'];
				if(isset($_POST['price_' . $price_id]))
				{
					if($_POST['price_' . $price_id] > 0)
					{
						$customer_people += $_POST['price_' . $price_id];
					}
				}
				$details['price_id'] = $price_id;
				$details['price'] = $_POST['price_' . $price_id] * $v['price'];
				$details['unit_price'] = $v['price'];
				$details['price_title'] = ':NULL';
				$details['cnt'] = $_POST['price_' . $price_id];
	
				for($i = 1; $i <= $details['cnt']; $i++)
				{
				$tickets['ticket_id'] = $data['unique_id'] . '-' . $ticket_number;
				$tickets['price_id'] = $price_id;
				$tickets['unit_price'] = $v['price'];
						$tickets['price_title'] = ':NULL';
								$pjBookingTicketModel->reset()->setAttributes($tickets)->insert();
									
								$ticket_number++;
				}
	
				$pjBookingDetailModel->reset()->setAttributes($details)->insert();
			}
			$pjBookingModel->reset()->where('id', $insert_id)->limit(1)->modifyAll(array('customer_people' => $customer_people));
				
			$booking_arr = $pjBookingModel
				->reset()
				->select('t1.*, t8.content as event_title, t2.event_start_ts, t2.event_end_ts, t2.o_show_start_time, t2.o_show_end_time,
						t3.content as country_title, t4.content as o_email_confirmation_subject,
						t5.content as o_email_confirmation, t6.content as o_email_payment_subject,
						t7.content as o_email_payment, t9.content as event_location,
						t10.content as o_sms_confirmation, t11.content as o_sms_payment')
				->join('pjEvent', 't1.event_id = t2.id', 'left')
				->join('pjMultiLang', "t3.foreign_id = t1.customer_country AND t3.model = 'pjCountry' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'name'", 'left')
				->join('pjMultiLang', "t4.foreign_id = t1.event_id AND t4.model = 'pjEvent' AND t4.locale = '".$this->getLocaleId()."' AND t4.field = 'o_email_confirmation_subject'", 'left')
				->join('pjMultiLang', "t5.foreign_id = t1.event_id AND t5.model = 'pjEvent' AND t5.locale = '".$this->getLocaleId()."' AND t5.field = 'o_email_confirmation'", 'left')
				->join('pjMultiLang', "t6.foreign_id = t1.event_id AND t6.model = 'pjEvent' AND t6.locale = '".$this->getLocaleId()."' AND t6.field = 'o_email_payment_subject'", 'left')
				->join('pjMultiLang', "t7.foreign_id = t1.event_id AND t7.model = 'pjEvent' AND t7.locale = '".$this->getLocaleId()."' AND t7.field = 'o_email_payment'", 'left')
				->join('pjMultiLang', "t8.foreign_id = t1.event_id AND t8.model = 'pjEvent' AND t8.locale = '".$this->getLocaleId()."' AND t8.field = 'title'", 'left')
				->join('pjMultiLang', "t9.foreign_id = t1.event_id AND t9.model = 'pjEvent' AND t9.locale = '".$this->getLocaleId()."' AND t9.field = 'location'", 'left')
				->join('pjMultiLang', "t10.foreign_id = t1.event_id AND t10.model = 'pjEvent' AND t10.locale = '".$this->getLocaleId()."' AND t10.field = 'o_sms_confirmation'", 'left')
				->join('pjMultiLang', "t11.foreign_id = t1.event_id AND t11.model = 'pjEvent' AND t11.locale = '".$this->getLocaleId()."' AND t11.field = 'o_sms_payment'", 'left')
				->find($insert_id)->getData();
	
			$ticket_arr = $pjBookingTicketModel
				->reset()
				->select('t1.*, t2.content as price_name')
				->join('pjMultiLang', "t2.foreign_id = t1.price_id AND t2.model = 'pjPrice' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->where('booking_id', $insert_id)
				->findAll()->getData();
	
			$ticket_data = array();
				
			foreach($ticket_arr as $v){
				$v['event_title'] = $booking_arr['event_title'];
				$v['event_datetime'] = pjUtil::getEventDateTime($event_arr['event_start_ts'], $event_arr['event_end_ts'], $this->option_arr['o_date_format'], $this->option_arr['o_time_format'], $event_arr['o_show_start_time'], $event_arr['o_show_end_time']);
				$v['customer_name'] = $booking_arr['customer_name'];
				$v['customer_email'] = $booking_arr['customer_email'];
				$v['ticket_detail'] = $event_arr['ticket_detail'];
				$v['ticket_img'] = $event_arr['ticket_img'];
				$v['unique_id'] = $booking_arr['unique_id'];
				$v['ticket_info'] = $this->getTicketInfo($v, $this->option_arr);
				$ticket_data[] = $v;
			}
				
			$pjTicketPdf = new pjTicketPdf();
			$pjTicketPdf->generatePdf($ticket_data);
				
			$this->bookingEmail($booking_arr, 'confirmation', $this->option_arr, $this->getLocaleId());
			$this->bookingSMS($booking_arr, 'confirmation', $this->option_arr);
				
			$json = array('code' => 200, 'text' => '', 'booking_id' => $insert_id, 'payment' => @$_POST['payment_method']);
			pjAppController::jsonResponse($json);
		}else{
			$json = array('code' => 100, 'text' => '');
			pjAppController::jsonResponse($json);
		}
	
	}
	public function pjActionConfirmAuthorize() {
		$this->setAjax ( true );
		
		if (pjObject::getPlugin ( 'pjAuthorize' ) === NULL) {
			$this->log ( 'Authorize.NET plugin not installed' );
			exit ();
		}
		$pjBookingModel = pjBookingModel::factory ();
		
		$booking_arr = $pjBookingModel->select ( 't1.*, t8.content as event_title, t2.event_start_ts, t2.event_end_ts, t2.o_show_start_time, t2.o_show_end_time,
					t3.content as country_title, t4.content as o_email_confirmation_subject,
					t5.content as o_email_confirmation, t6.content as o_email_payment_subject,
					t7.content as o_email_payment, t9.content as event_location,
					t10.content as o_sms_confirmation, t11.content as o_sms_payment' )->join ( 'pjEvent', 't1.event_id = t2.id', 'left' )->join ( 'pjMultiLang', "t3.foreign_id = t1.customer_country AND t3.model = 'pjCountry' AND t3.locale = '" . $this->getLocaleId () . "' AND t3.field = 'name'", 'left' )->join ( 'pjMultiLang', "t4.foreign_id = t1.event_id AND t4.model = 'pjEvent' AND t4.locale = '" . $this->getLocaleId () . "' AND t4.field = 'o_email_confirmation_subject'", 'left' )->join ( 'pjMultiLang', "t5.foreign_id = t1.event_id AND t5.model = 'pjEvent' AND t5.locale = '" . $this->getLocaleId () . "' AND t5.field = 'o_email_confirmation'", 'left' )->join ( 'pjMultiLang', "t6.foreign_id = t1.event_id AND t6.model = 'pjEvent' AND t6.locale = '" . $this->getLocaleId () . "' AND t6.field = 'o_email_payment_subject'", 'left' )->join ( 'pjMultiLang', "t7.foreign_id = t1.event_id AND t7.model = 'pjEvent' AND t7.locale = '" . $this->getLocaleId () . "' AND t7.field = 'o_email_payment'", 'left' )->join ( 'pjMultiLang', "t8.foreign_id = t1.event_id AND t8.model = 'pjEvent' AND t8.locale = '" . $this->getLocaleId () . "' AND t8.field = 'title'", 'left' )->join ( 'pjMultiLang', "t9.foreign_id = t1.event_id AND t9.model = 'pjEvent' AND t9.locale = '" . $this->getLocaleId () . "' AND t9.field = 'location'", 'left' )->join ( 'pjMultiLang', "t10.foreign_id = t1.event_id AND t10.model = 'pjEvent' AND t10.locale = '" . $this->getLocaleId () . "' AND t10.field = 'o_sms_confirmation'", 'left' )->join ( 'pjMultiLang', "t11.foreign_id = t1.event_id AND t11.model = 'pjEvent' AND t11.locale = '" . $this->getLocaleId () . "' AND t11.field = 'o_sms_payment'", 'left' )->find ( $_POST ['x_invoice_num'] )->getData ();
		
		if (count ( $booking_arr ) > 0) {
			$params = array (
					'transkey' => $this->option_arr ['o_authorize_transkey'],
					'x_login' => $this->option_arr ['o_authorize_merchant_id'],
					'md5_setting' => $this->option_arr ['o_authorize_md5_hash'],
					'key' => md5 ( $this->option_arr ['private_key'] . PJ_SALT ) 
			);
			
			$response = $this->requestAction ( array (
					'controller' => 'pjAuthorize',
					'action' => 'pjActionConfirm',
					'params' => $params 
			), array (
					'return' 
			) );
			if ($response !== FALSE && $response ['status'] === 'OK') {
				$pjBookingModel->reset ()->setAttributes ( array (
						'id' => $response ['transaction_id'] 
				) )->modify ( array (
						'booking_status' => $this->option_arr ['o_default_status_if_paid'] 
				) );

				$this->bookingEmail ( $booking_arr, 'payment', $this->option_arr, $this->getLocaleId() );
				$this->bookingSMS ( $booking_arr, 'payment', $this->option_arr );
			} elseif (! $response) {
				$this->log ( 'Authorization failed' );
			} else {
				$this->log ( 'Booking not confirmed. ' . $response ['response_reason_text'] );
			}
			?>
<script type="text/javascript">window.location.href="<?php echo $this->option_arr['o_thankyou_page']; ?>";</script>
<?php
			return;
		}
	}
	public function pjActionConfirmPaypal() {
		$this->setAjax ( true );
		
		if (pjObject::getPlugin ( 'pjPaypal' ) === NULL) {
			$this->log ( 'Paypal plugin not installed' );
			exit ();
		}
		$pjBookingModel = pjBookingModel::factory ();
		$booking_arr = $pjBookingModel
			->select ( 't1.*, t8.content as event_title, t2.event_start_ts, t2.event_end_ts, t2.o_show_start_time, t2.o_show_end_time,
						t3.content as country_title, t4.content as o_email_confirmation_subject, 
						t5.content as o_email_confirmation, t6.content as o_email_payment_subject, 
						t7.content as o_email_payment, t9.content as event_location,
						t10.content as o_sms_confirmation, t11.content as o_sms_payment' )
			->join ( 'pjEvent', 't1.event_id = t2.id', 'left' )
			->join ( 'pjMultiLang', "t3.foreign_id = t1.customer_country AND t3.model = 'pjCountry' AND t3.locale = '" . $this->getLocaleId () . "' AND t3.field = 'name'", 'left' )
			->join ( 'pjMultiLang', "t4.foreign_id = t1.event_id AND t4.model = 'pjEvent' AND t4.locale = '" . $this->getLocaleId () . "' AND t4.field = 'o_email_confirmation_subject'", 'left' )
			->join ( 'pjMultiLang', "t5.foreign_id = t1.event_id AND t5.model = 'pjEvent' AND t5.locale = '" . $this->getLocaleId () . "' AND t5.field = 'o_email_confirmation'", 'left' )
			->join ( 'pjMultiLang', "t6.foreign_id = t1.event_id AND t6.model = 'pjEvent' AND t6.locale = '" . $this->getLocaleId () . "' AND t6.field = 'o_email_payment_subject'", 'left' )
			->join ( 'pjMultiLang', "t7.foreign_id = t1.event_id AND t7.model = 'pjEvent' AND t7.locale = '" . $this->getLocaleId () . "' AND t7.field = 'o_email_payment'", 'left' )
			->join ( 'pjMultiLang', "t8.foreign_id = t1.event_id AND t8.model = 'pjEvent' AND t8.locale = '" . $this->getLocaleId () . "' AND t8.field = 'title'", 'left' )
			->join ( 'pjMultiLang', "t9.foreign_id = t1.event_id AND t9.model = 'pjEvent' AND t9.locale = '" . $this->getLocaleId () . "' AND t9.field = 'location'", 'left' )
			->join ( 'pjMultiLang', "t10.foreign_id = t1.event_id AND t10.model = 'pjEvent' AND t10.locale = '" . $this->getLocaleId () . "' AND t10.field = 'o_sms_confirmation'", 'left' )
			->join ( 'pjMultiLang', "t11.foreign_id = t1.event_id AND t11.model = 'pjEvent' AND t11.locale = '" . $this->getLocaleId () . "' AND t11.field = 'o_sms_payment'", 'left' )
			->find ( $_POST ['custom'] )->getData ();
		
		$params = array (
				'txn_id' => @$booking_arr ['txn_id'],
				'paypal_address' => $this->option_arr ['o_paypal_address'],
				'deposit' => @$booking_arr ['booking_deposit'],
				'currency' => $this->option_arr ['o_currency'],
				'key' => md5 ( $this->option_arr ['private_key'] . PJ_SALT ) 
		);
		$response = $this->requestAction ( array (
				'controller' => 'pjPaypal',
				'action' => 'pjActionConfirm',
				'params' => $params 
		), array (
				'return' 
		) );
		
		if ($response !== FALSE && $response ['status'] === 'OK') {
			$this->log ( 'Booking confirmed' );
			$pjBookingModel->reset ()->setAttributes ( array (
					'id' => $booking_arr ['id'] 
			) )->modify ( array (
					'booking_status' => $this->option_arr ['o_default_status_if_paid'],
					'txn_id' => $response ['transaction_id'],
					'processed_on' => ':NOW()' 
			) );
			$this->bookingEmail ( $booking_arr, 'payment', $this->option_arr, $this->getLocaleId());
			$this->bookingSMS ( $booking_arr, 'payment', $this->option_arr );
		} elseif (! $response) {
			$this->log ( 'Authorization failed' );
		} else {
			$this->log ( 'Booking not confirmed' );
		}
		exit ();
	}
	
	public function bookingEmail($booking_arr, $opt, $option_arr, $locale_id) {
		if (! in_array ( $opt, array (
				'confirmation',
				'payment' 
		) )) {
			return false;
		}
		if (empty ( $booking_arr ['o_email_' . $opt . '_subject'] ) || empty ( $booking_arr ['o_email_' . $opt] )) {
			return false;
		}

		$event_date = pjUtil::getEventDateTime ( $booking_arr ['event_start_ts'], $booking_arr ['event_end_ts'], $option_arr ['o_date_format'], $option_arr ['o_time_format'], $booking_arr ['o_show_start_time'], $booking_arr ['o_show_end_time'] );
		
		$cancelURL = PJ_INSTALL_URL . 'index.php?controller=pjFrontPublic&action=pjActionCancel&id=' . $booking_arr ['id'] . '&hash=' . md5 ( $booking_arr ['id'] . $booking_arr ['created'] . PJ_SALT );
		$cancelURL = '<a href="'.$cancelURL.'">'.$cancelURL.'</a>';
		
		$pdf_tickets = PJ_INSTALL_URL . PJ_UPLOAD_PATH . 'tickets/pdfs/p_' . $booking_arr ['unique_id'] . '.pdf';
		
		$event = $booking_arr ['event_title'] . ' | ' . $event_date;
		
		$booking_detail_arr = pjBookingDetailModel::factory ()->select ( 't1.*, t2.content as price_name' )->join ( 'pjMultiLang', "t2.foreign_id = t1.price_id AND t2.model = 'pjPrice' AND t2.locale = '" . $locale_id . "' AND t2.field = 'name'", 'left' )->where ( 't1.booking_id', $booking_arr ['id'] )->findAll ()->getData ();
		
		$tickets = "\n";
		foreach ( $booking_detail_arr as $v ) {
			$tickets .= $v ['price_name'] . ': ' . $v ['cnt'] . " x " . $v ['unit_price'] . ' ' . $option_arr ['o_currency'] . "\n";
		}
		$total = $booking_arr ['booking_total'] . ' ' . $option_arr ['o_currency'];
		$tax = $booking_arr ['booking_tax'] . ' ' . $option_arr ['o_currency'];
		$deposit = $booking_arr ['booking_deposit'] . ' ' . $option_arr ['o_currency'];
		$balance = ($booking_arr ['booking_total'] - $booking_arr ['booking_deposit']) . ' ' . $option_arr ['o_currency'];
		
		$search = array (
				'{Name}',
				'{Email}',
				'{Phone}',
				'{Country}',
				'{City}',
				'{State}',
				'{Zip}',
				'{Address}',
				'{Tickets}',
				'{PDF_Tickets}',
				'{Notes}',
				'{CCType}',
				'{CCNum}',
				'{CCExp}',
				'{CCSec}',
				'{PaymentMethod}',
				'{Event}',
				'{EventTitle}',
				'{EventDateTime}',
				'{EventLocation}',
				'{Total}',
				'{Tax}',
				'{Deposit}',
				'{Balance}',
				'{BookingID}',
				'{CancelURL}' 
		);
		$replace = array (
				$booking_arr ['customer_name'],
				$booking_arr ['customer_email'],
				$booking_arr ['customer_phone'],
				$booking_arr ['country_title'],
				$booking_arr ['customer_city'],
				$booking_arr ['customer_state'],
				$booking_arr ['customer_zip'],
				$booking_arr ['customer_address'],
				$tickets,
				$pdf_tickets,
				$booking_arr ['customer_notes'],
				$booking_arr ['cc_type'],
				$booking_arr ['cc_num'],
				($booking_arr ['payment_method'] == 'creditcard' ? $booking_arr ['cc_exp'] : NULL),
				$booking_arr ['cc_code'],
				$booking_arr ['payment_method'],
				$event,
				$booking_arr ['event_title'],
				$event_date,
				$booking_arr ['event_location'],
				$total,
				$tax,
				$deposit,
				$balance,
				$booking_arr ['unique_id'],
				$cancelURL 
		);
		
		$pjEmail = new pjEmail ();
		
		if ($option_arr ['o_send_email'] == 'smtp') {
			$pjEmail
				->setTransport('smtp')
				->setSmtpHost($option_arr['o_smtp_host'])
				->setSmtpPort($option_arr['o_smtp_port'])
				->setSmtpUser($option_arr['o_smtp_user'])
				->setSmtpPass($option_arr['o_smtp_pass'])
				->setSender($option_arr['o_smtp_user']);
		}
		$pjAppController = new pjAppController();
		$from = $pjAppController->getFromEmail ();
		$pjEmail->setContentType ( 'text/html' );
		$pjEmail->setFrom ( $from );
		
		$subject = str_replace ( $search, $replace, $booking_arr ['o_email_' . $opt . '_subject'] );
		$message = str_replace ( $search, $replace, $booking_arr ['o_email_' . $opt] );
		
		$pjEmail->setSubject ( $subject );
		
		$admin_arr = pjUserModel::factory ()->where ( 'role_id', 1 )->findAll ()->getData ();
		
		foreach ( $admin_arr as $admin ) {
			$to = $admin ['email'];
			$pjEmail->setTo ( $to );
			$pjEmail->send ( $message );
		}
		
		$to = $booking_arr ['customer_email'];
		$pjEmail->setTo ( $to );
		$pjEmail->send ( $message );
	}
	public function bookingSMS($booking_arr, $opt, $option_arr) {
		if (! in_array ( $opt, array (
				'confirmation',
				'payment' 
		) )) {
			return false;
		}
		if (empty ( $booking_arr ['o_sms_' . $opt] )) {
			return false;
		}
		if (empty ( $booking_arr ['customer_phone'] )) {
			return false;
		}
		
		$event_date = pjUtil::getEventDateTime ( $booking_arr ['event_start_ts'], $booking_arr ['event_end_ts'], $option_arr ['o_date_format'], $option_arr ['o_time_format'], $booking_arr ['o_show_start_time'], $booking_arr ['o_show_end_time'] );
		
		$total = $booking_arr ['booking_total'] . ' ' . $option_arr ['o_currency'];
		$tax = $booking_arr ['booking_tax'] . ' ' . $option_arr ['o_currency'];
		$deposit = $booking_arr ['booking_deposit'] . ' ' . $option_arr ['o_currency'];
		
		$search = array (
				'{Name}',
				'{Email}',
				'{Phone}',
				'{BookingID}',
				'{EventTitle}',
				'{EventDateTime}',
				'{Total}',
				'{Tax}',
				'{Deposit}' 
		);
		$replace = array (
				$booking_arr ['customer_name'],
				$booking_arr ['customer_email'],
				$booking_arr ['customer_phone'],
				$booking_arr ['unique_id'],
				$booking_arr ['event_title'],
				$event_date,
				$total,
				$tax,
				$deposit 
		);
		
		$message = str_replace ( $search, $replace, $booking_arr ['o_sms_' . $opt] );
		$params = array (
				'text' => $message,
				'type' => 'unicode',
				'key' => md5 ( $option_arr ['private_key'] . PJ_SALT ) 
		);
		
		$phone_arr = pjUserModel::factory ()->where ( 'role_id', 1 )->findAll ()->getData ();
		foreach ( $phone_arr as $admin ) {
			$params ['number'] = $admin ['phone'];
			$this->requestAction ( array (
					'controller' => 'pjSms',
					'action' => 'pjActionSend',
					'params' => $params 
			), array (
					'return' 
			) );
		}
		
		$params ['number'] = $booking_arr ['customer_phone'];
		$this->requestAction ( array (
				'controller' => 'pjSms',
				'action' => 'pjActionSend',
				'params' => $params 
		), array (
				'return' 
		) );
	}
}
?>