<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);
	if(isset($_GET['id']))
	{
		$start_date_time = pjUtil::formatDate(date('Y-m-d', $tpl['arr']['event_start_ts']), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', $tpl['arr']['event_start_ts']), 'H:i:s', $tpl['option_arr']['o_time_format']);
		$end_date_time = pjUtil::formatDate(date('Y-m-d', $tpl['arr']['event_end_ts']), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', $tpl['arr']['event_end_ts']), 'H:i:s', $tpl['option_arr']['o_time_format']);
	}
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionCreate" method="post" id="frmCreateEvent" class="pj-form form" enctype="multipart/form-data">
		<input type="hidden" name="event_create" value="1" />
		<input type="hidden" id="time_flag" name="time_flag" value="0" />
		<input type="hidden" id="num_prices" name="num_prices" value="1" />
		<input type="hidden" id="copy" name="copy" value="<?php echo isset($_GET['id']) ? $_GET['id'] : 0;?>" />
		<input type="hidden" id="copy_image" name="copy_image" value="1" />
		<input type="hidden" id="index_arr" name="index_arr" value="" />
		<input type="hidden" id="remove_arr" name="remove_arr" value="" />
		<?php
		pjUtil::printNotice(__('infoEventTimeTitle', true), __('infoEventTimeDesc', true)); 
		?>
		<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
		<div class="multilang"></div>
		<?php endif; ?>
		
		<div class="clear_both">
			<p>
				<label class="title"><?php __('lblStartDateTime'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="event_start_ts" id="start" class="pj-form-field pointer w120 required datetimepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					<input type="checkbox" id="o_show_start_time" name="o_show_start_time" class="l20 t10"  value="F"/>
					<label for="o_show_start_time"><?php __('lblHideTime');?></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblEndDateTime'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="event_end_ts" id="end" class="pj-form-field pointer w120 required datetimepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					<input type="checkbox" id="o_show_end_time" name="o_show_end_time" class="l20 t10" value="F"/>
					<label for="o_show_end_time"><?php __('lblHideTime');?></label>
				</span>
			</p>
			<?php
			foreach ($tpl['lp_arr'] as $v)
			{
				?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblEventTitle'); ?></label>
					<span class="inline_block">
						<input type="text" id="i18n_title_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][title]" class="pj-form-field w400<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" value="<?php echo isset($tpl['arr']) ? htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['title'])) : NULL; ?>" data-msg-required="<?php __('lblFieldRequired');?>"/>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			}
			if(!empty($tpl['category_arr']))
			{ 
				?>
				<p>
					<label class="title"><?php __('lblCategory'); ?></label>
					<span class="inline_block">
						<select name="category_id" id="category_id" class="pj-form-field w250">
							<option value="">-- <?php __('lblChoose');?> --</option>
							<?php
							foreach($tpl['category_arr'] as $v)
							{
								?><option value="<?php echo $v['id']?>"<?php echo isset($tpl['arr']) ? ($tpl['arr']['category_id'] == $v['id'] ? ' selected="selected"' : null) : null?>><?php echo $v['name']?></option><?php
							} 
							?>
						</select>
					</span>
				</p>
				<?php
			}
			foreach ($tpl['lp_arr'] as $v)
			{
				?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblLocation'); ?></label>
					<span class="inline_block">
						<input type="text" id="i18n_location_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][location]" class="pj-form-field w400" lang="<?php echo $v['id']; ?>" value="<?php echo isset($tpl['arr']) ? htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['location'])) : NULL; ?>"/>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			} 
			
			foreach ($tpl['lp_arr'] as $v)
			{
				?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblDescription'); ?></label>
					<span class="inline_block">
						<textarea id="i18n_description_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][description]"  class="pj-form-field w450 h100"><?php echo isset($tpl['arr']) ? htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['description'])) : NULL; ?></textarea>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			} 
			?>
			<p>
				<label class="title"><?php __('lblImage'); ?></label>
				<span class="inline_block">
					<input type="file" name="event_img" id="event_img" class="pj-form-field w300" />
				</span>
			</p>
			<?php
			if(!empty($tpl['arr']['event_thumb']))
			{
				if(is_file(PJ_INSTALL_PATH . $tpl['arr']['event_thumb']))
				{
					$img_url = PJ_INSTALL_URL . $tpl['arr']['event_thumb'];
					$large_url = PJ_INSTALL_URL . $tpl['arr']['event_img'];
					$img_name = basename($tpl['arr']['event_thumb']);
					?>
					<p id="image_container">
						<label class="title">&nbsp;</label>
						<span class="block float_left r10">
							<a target="_blank" href="<?php echo $large_url;?>"><img class="event_thumb" src="<?php echo $img_url; ?>" /></a>
						</span>
						<span class="block float_left">
							<a href="javascript:void(0);" class="delete-image"><?php echo strtolower(__('lnkDelete', true)); ?></a>
						</span>
					</p>
					<?php
				}
			} 
			?>
			<?php
			pjUtil::printNotice(__('infoEventPriceTitle', true), __('infoEventPriceDesc', true)); 
			?>
			<div id="price_container">
				<?php
				if(isset($tpl['price_arr']) && count($tpl['price_arr']) > 0)
				{
					foreach($tpl['price_arr'] as $k => $price)
					{
						$index = 'ebc_' . rand(1, 999999);
						?>
						<p id="price_box_<?php echo $index;?>" class="price-box" data-index="<?php echo $index;?>">
							<label class="title"><?php echo $k == 0 ? __('lblPrice', true) : '&nbsp;'; ?></label>
							<span class="block overflow">
								<?php
								foreach ($tpl['lp_arr'] as $v)
								{
									?>
									<span class="pj-multilang-wrap block float_left r10" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
										<input type="text" name="i18n[<?php echo $v['id']; ?>][name][<?php echo $index;?>]" value="<?php echo htmlspecialchars(stripslashes(@$price['i18n'][$v['id']]['name']));?>" class="pj-form-field w120<?php echo (int) $v['is_default'] === 0 ? NULL : ' ebcRequired'; ?>" lang="<?php echo $v['id']; ?>" data-msg-required="<?php __('lblFieldRequired');?>"/>
										<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
										<span class="pj-multilang-input t2"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
										<?php endif;?>
									</span>
									<?php
								} 
								?>
								<span class="block float_left r5 w130">
									<span class="pj-form-field-custom pj-form-field-custom-before">
										<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
										<input type="text" name="price[<?php echo $index;?>]" value="<?php echo $price['price']; ?>" class="pj-form-field pj-positive-number w60" />
									</span>
								</span>
								<label class="block t10 float_left r5 content"><?php __('lblAvailable'); ?></label>
								<span class="block float_left r10">
									<input type="text" name="available[<?php echo $index;?>]" value="<?php echo $price['available']; ?>" class="pj-form-field field-int w60" />
								</span>
								<?php
								if($k > 0)
								{ 
									?>
									<input type="button" value="<?php __('btnRemove'); ?>" class="pj-button btn-remove-price" id="ebc_remove_price_<?php echo $index;?>" lang="<?php echo $index;?>" />
									<?php 
								} 
								?>
							</span>
						</p>
						<?php 
					}
				}else{
					$index = 'ebc_' . rand(1, 999999);
					?>
					<p class="price-box" data-index="<?php echo $index;?>">
						<label class="title"><?php __('lblPrice'); ?></label>
						<span class="block overflow">
							<?php
							foreach ($tpl['lp_arr'] as $v)
							{
								?>
								<span class="pj-multilang-wrap block float_left r10" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
									<input type="text" name="i18n[<?php echo $v['id']; ?>][name][<?php echo $index;?>]" value="<?php __('lblRegular');?>" class="pj-form-field w120<?php echo (int) $v['is_default'] === 0 ? NULL : ' ebcRequired'; ?>" lang="<?php echo $v['id']; ?>" data-msg-required="<?php __('lblFieldRequired');?>"/>
									<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
									<span class="pj-multilang-input t2"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
									<?php endif;?>
								</span>
								<?php
							} 
							?>
							<span class="block float_left r5 w130">
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" name="price[<?php echo $index;?>]" class="pj-form-field pj-positive-number w60" />
								</span>
							</span>
							<label class="block t10 float_left r5 content"><?php __('lblAvailable'); ?></label>
							<span class="block float_left r10">
								<input type="text" name="available[<?php echo $index;?>]" value="5" class="pj-form-field field-int w60" />
							</span>
						</span>
					</p>
					<?php
				} 
				?>
			</div>
			<p>
				<label class="title">&nbsp;</label>
				<input type="button" value="<?php __('btnAdd'); ?>" class="pj-button" id="ebc_add_price" />
			</p>
			<p>
				<label class="title"><?php __('lblRepeat'); ?></label>
				<?php
				$repeat_arr = __('repeatarr', true); 
				?>
				<select name="repeat" id="repeat" class="pj-form-field">
					<option value="none">-- <?php echo $repeat_arr['none'];?> --</option>
					<option value="daily"><?php echo $repeat_arr['daily'];?></option>
					<option value="weekly"><?php echo $repeat_arr['weekly'];?></option>
					<option value="monthly"><?php echo $repeat_arr['monthly'];?></option>
					<option value="quarterly"><?php echo $repeat_arr['quarterly'];?></option>
					<option value="yearly"><?php echo $repeat_arr['yearly'];?></option>
					<option value="custom"><?php echo $repeat_arr['custom'];?></option>
				</select>
			</p>
			<div id="repeat_box" style="display:none;">
				<p id="repeat_daily" style="display:none;">
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<?php __('lblRepeatEveryDay');?>
					</span>
				</p>
				<p id="repeat_weekly" style="display:none;">
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<?php __('lblRepeatEveryWeek');?>
					</span>
				</p>
				<div id="repeat_monthly" style="display:none;">
					<p>
						<label class="title"><?php __('lblOn');?></label>
						<span class="inline_block">
							<select id="repeat-monthly-date" name="repeat-monthly-date" class="pj-form-field">
								<?php
								$monthly_date = __('monthly_date', true); 
								ksort($monthly_date);
								foreach($monthly_date as $k => $v){
									?><option value="<?php echo $k;?>"><?php echo $v;?></option><?php
								}
								?>
							</select>
						</span>
						<span class="inline_block">
							<?php __('lblOfTheMonth');?>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblOrEach');?></label>
						<span class="inline_block">
							<select id="repeat-monthly-each" name="repeat-monthly-each" class="pj-form-field">
								<?php
								$monthly_each = __('monthly_each', true); 
								?>
								<option value="first"><?php echo $monthly_each['first'];?></option>
								<option value="second"><?php echo $monthly_each['second'];?></option>
								<option value="third"><?php echo $monthly_each['third'];?></option>
								<option value="fourth"><?php echo $monthly_each['fourth'];?></option>
							</select>
						</span>
						<span class="inline_block">
							<select id="repeat-monthly-day" name="repeat-monthly-day" class="pj-form-field">
								<?php
								$day_names = __('days', true); 
								ksort($day_names);
								foreach($day_names as $k => $v){
									?><option value="<?php echo $v;?>"><?php echo substr($v, 0, 3);?></option><?php
								}
								?>
							</select>
						</span>
						<span class="inline_block">
							<?php __('lblOfTheMonth');?>
						</span>
					</p>
				</div>
				<p id="repeat_quarterly" style="display:none;">
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<?php __('lblRepeatEveryQuarter');?>
					</span>
				</p>
				<p id="repeat_yearly" style="display:none;">
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<?php __('lblRepeatEveryYear');?>
					</span>
				</p>
				<p id="repeat_custom" style="display:none;">
					<label class="title"><?php __('lblEach');?></label>
					<span class="inline_block">
						<input type="text" name="repeat-custom-days" id="repeat-custom-days" class="pj-form-field w50 block float_left r10" /><span class="block float_left t5"><?php __('lblDays');?></span>
					</span>
					
				</p>
				<p>
					<label class="title"><?php __('lblEndRecurringOn'); ?></label>
					<span class="inline_block">
						<span class="pj-form-field-custom pj-form-field-custom-after float_left r10">
							<input type="text" name="end_repeat_date" id="end_repeat_date" class="pj-form-field pointer w80 datepick" value="" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
						<label class="content r10"><?php echo strtolower(__('lblOrRepeat', true)); ?></label>
						<span class="inline_block float_left r10">
							<input type="text" name="end_repeat_times" id="end_repeat_times" class="pj-form-field w50" />
						</span>
						<label class="content r10"><?php __('lblTimes');?></label>
						<input type="hidden" name="hidden_recurring_on" id="hidden_recurring_on" class="" data-msg-required="<?php __('lblAtLeastTheseTwo');?>"/>
					</span>
				</p>
			</div>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEvents&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<div id="clone_container" style="display:none;">
		<p id="price_box_{index}" class="price-box" data-index="{index}">
			<label class="title">&nbsp;</label>
			<span class="block overflow">
				<?php
				foreach ($tpl['lp_arr'] as $v)
				{
					?>
					<span class="pj-multilang-wrap block float_left r10" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
						<input type="text" name="i18n[<?php echo $v['id']; ?>][name][{index}]" class="pj-form-field w120<?php echo (int) $v['is_default'] === 0 ? NULL : ' ebcRequired'; ?>" lang="<?php echo $v['id']; ?>" data-msg-required="<?php __('lblFieldRequired');?>"/>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input t2"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif;?>
					</span>
					<?php
				} 
				?>
				<span class="block float_left r5 w130">
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" name="price[{index}]" class="pj-form-field pj-positive-number w60" />
					</span>
				</span>
				<label class="block t10 float_left r5 content"><?php __('lblAvailable'); ?></label>
				<span class="block float_left r10">
					<input type="text" name="available[{index}]" value="5" class="pj-form-field {fieldint} w60" />
				</span>
				<input type="button" value="<?php __('btnRemove'); ?>" class="pj-button btn-remove-price" id="ebc_remove_price_{index}" lang="{index}" />
			</span>
		</p>
	</div>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.lblInvalidPrice = "<?php __('lblInvalidPrice'); ?>";
	myLabel.lblFieldRequired = "<?php __('lblFieldRequired'); ?>";
	myLabel.localeId = "<?php echo $controller->getLocaleId(); ?>";
	var locale_array = new Array(); 
	<?php
	foreach ($tpl['lp_arr'] as $v)
	{
		?>locale_array.push(<?php echo $v['id'];?>);<?php
	} 
	?>
	myLabel.locale_array = locale_array;
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: <?php echo $tpl['locale_str']; ?>,
				flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
				select: function (event, ui) {
					
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	<?php
}
?>