<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);
	
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		$bodies_text = str_replace("{MAXSIZE}", ini_get('upload_max_filesize'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	
	$start_date_time = pjUtil::formatDate(date('Y-m-d', $tpl['arr']['event_start_ts']), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', $tpl['arr']['event_start_ts']), 'H:i:s', $tpl['option_arr']['o_time_format']);
	$end_date_time = pjUtil::formatDate(date('Y-m-d', $tpl['arr']['event_end_ts']), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', $tpl['arr']['event_end_ts']), 'H:i:s', $tpl['option_arr']['o_time_format']); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionUpdate" method="post" id="frmUpdateEvent" class="form pj-form" enctype="multipart/form-data">
		<input type="hidden" name="event_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<input type="hidden" name="recurring_id" value="<?php echo $tpl['arr']['recurring_id']; ?>" />
		<input type="hidden" id="num_prices" name="num_prices" value="<?php echo count($tpl['price_arr']) == 0 ? 1 : count($tpl['price_arr']);?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		<input type="hidden" name="sub_tab_id" value="<?php echo isset($_GET['sub_tab_id']) && !empty($_GET['sub_tab_id']) ? $_GET['sub_tab_id'] : 'tabs-1'; ?>" />
		<input type="hidden" id="index_arr" name="index_arr" value="" />
		<input type="hidden" id="remove_arr" name="remove_arr" value="" />
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('tabDetails'); ?></a></li>
				<li><a href="#tabs-2"><?php __('tabConfirmation'); ?></a></li>
				<li><a href="#tabs-3"><?php __('tabTerms'); ?></a></li>
				<li><a href="#tabs-4"><?php __('tabTicket'); ?></a></li>
				<li><a href="#tabs-5"><?php __('tabBookings'); ?></a></li>
				<li><a href="#tabs-6"><?php __('tabUsedTickets'); ?></a></li>
				<li><a href="#tabs-7"><?php __('tabInstall'); ?></a></li>
			</ul>
			<div id="tabs-1">
				<?php
				pjUtil::printNotice(__('infoEventTimeTitle', true), __('infoEventTimeDesc', true)); 
				?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang"></div>
				<?php endif; ?>	
				<div class="clear_both">
					<p>
						<label class="title"><?php __('lblStartDateTime'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="event_start_ts" id="start" class="pj-form-field pointer w120 required datetimepick" value="<?php echo $start_date_time;?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
							<input type="checkbox" id="o_show_start_time" name="o_show_start_time" class="l20 t10" value="F" <?php echo $tpl['arr']['o_show_start_time'] == 'F' ? 'checked="checked"' : null; ?>/>
							<label for="o_show_start_time"><?php __('lblHideTime');?></label>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblEndDateTime'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="event_end_ts" id="end" class="pj-form-field pointer w120 required datetimepick" value="<?php echo $end_date_time;?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
							<input type="checkbox" id="o_show_end_time" name="o_show_end_time" class="l20 t10" value="F" <?php echo $tpl['arr']['o_show_end_time'] == 'F' ? 'checked="checked"' : null; ?>/>
							<label for="o_show_end_time"><?php __('lblHideTime');?></label>
						</span>
					</p>
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
					?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblEventTitle'); ?></label>
							<span class="inline_block">
								<input type="text" id="i18n_title_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][title]" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['title'])); ?>" data-msg-required="<?php __('lblFieldRequired');?>"/>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					if(!empty($tpl['category_arr']))
					{
						?>
						<p>
							<label class="title"><?php __('lblCategory'); ?></label>
							<span class="inline_block">
								<select name="category_id" id="category_id" class="pj-form-field w250">
									<option value="">-- <?php __('lblChoose');?> --</option>
									<?php
									foreach($tpl['category_arr'] as $v){
										?><option value="<?php echo $v['id']?>" <?php echo $v['id'] == $tpl['arr']['category_id'] ? 'selected="selected"' : null; ?>><?php echo $v['name']?></option><?php
									} 
									?>
								</select>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
					?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblLocation'); ?></label>
							<span class="inline_block">
								<input type="text" id="i18n_location_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][location]" class="pj-form-field w300" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['location'])); ?>" data-msg-required="<?php __('lblFieldRequired');?>"/>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblDescription'); ?></label>
							<span class="inline_block">
								<textarea id="i18n_description_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][description]"  class="pj-form-field w450 h100"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['description'])); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title"><?php __('lblImage'); ?></label>
						<span class="inline_block">
							<input type="file" name="event_img" id="event_img" class="pj-form-field w300" />
						</span>
					</p>
					<?php
					if(!empty($tpl['arr']['event_thumb']))
					{
						if(is_file(PJ_INSTALL_PATH . $tpl['arr']['event_thumb']))
						{
							$img_url = PJ_INSTALL_URL . $tpl['arr']['event_thumb'];
							$large_url = PJ_INSTALL_URL . $tpl['arr']['event_img'];
							$img_name = basename($tpl['arr']['event_thumb']);
							?>
							<p id="image_container">
								<label class="title">&nbsp;</label>
								<span class="block float_left r10">
									<a target="_blank" href="<?php echo $large_url;?>"><img class="event_thumb" src="<?php echo $img_url; ?>" /></a>
								</span>
								<span class="block float_left">
									<a href="javascript:void(0);" class="delete-image" rev="<?php echo $tpl['arr']['id']?>" data-recurring="<?php echo $tpl['number_of_events'] > 1 ? 'yes' : 'no';?>"><?php echo strtolower(__('lnkDelete', true)); ?></a>
								</span>
							</p>
							<?php
						}
					} 
					
					pjUtil::printNotice(__('infoEventPriceTitle', true), __('infoEventPriceDesc', true)); 
					?>
					<div id="price_container">
						<?php
						if(count($tpl['price_arr']) > 0)
						{
							$has_bookings = 0;
							if(count($tpl['booking_arr']) > 0)
							{
								$has_bookings = 1;
							}
							foreach($tpl['price_arr'] as $k => $price)
							{
								?>
								<p id="price_box_<?php echo $price['id'];?>" class="price-box" data-index="<?php echo $price['id'];?>">
									<label class="title"><?php echo $k == 0 ? __('lblPrice', true) : '&nbsp;'; ?></label>
									<span class="block overflow">
										<?php
										foreach ($tpl['lp_arr'] as $v)
										{
											?>
											<span class="pj-multilang-wrap block float_left r10" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
												<input type="text" name="i18n[<?php echo $v['id']; ?>][name][<?php echo $price['id'];?>]" value="<?php echo htmlspecialchars(stripslashes(@$price['i18n'][$v['id']]['name']));?>" class="pj-form-field w120<?php echo (int) $v['is_default'] === 0 ? NULL : ' ebcRequired'; ?>" lang="<?php echo $v['id']; ?>" data-msg-required="<?php __('lblFieldRequired');?>"/>
												<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
												<span class="pj-multilang-input t2"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
												<?php endif;?>
											</span>
											<?php
										} 
										?>
										<span class="block float_left r5 w130">
											<span class="pj-form-field-custom pj-form-field-custom-before">
												<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
												<input type="text" name="price[<?php echo $price['id'];?>]" value="<?php echo $price['price']; ?>" class="pj-form-field pj-positive-number w60" />
											</span>
										</span>
										<label class="block t10 float_left r5 content"><?php __('lblAvailable'); ?></label>
										<span class="block float_left r10">
											<input type="text" name="available[<?php echo $price['id'];?>]" value="<?php echo $price['available']; ?>" class="pj-form-field field-int w60" />
										</span>
										<?php
										if($has_bookings == 0 && $k > 0)
										{ 
											?>
											<input type="button" value="<?php __('btnRemove'); ?>" class="pj-button btn-remove-price" id="ebc_remove_price_<?php echo $price['id'];?>" lang="<?php echo $price['id'];?>" />
											<?php 
										} 
										?>
									</span>
								</p>
								<?php 
							} 
						}else{
							$index = 'ebc_' . rand(1, 999999);
							?>
							<p class="price-box" data-index="<?php echo $index;?>">
								<label class="title"><?php __('lblPrice'); ?></label>
								<span class="block overflow">
									<?php
									foreach ($tpl['lp_arr'] as $v)
									{
										?>
										<span class="pj-multilang-wrap block float_left r10" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
											<input type="text" name="i18n[<?php echo $v['id']; ?>][name][<?php echo $index;?>]" value="<?php __('lblRegular');?>" class="pj-form-field w120<?php echo (int) $v['is_default'] === 0 ? NULL : ' ebcRequired'; ?>" lang="<?php echo $v['id']; ?>" data-msg-required="<?php __('lblFieldRequired');?>"/>
											<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
											<span class="pj-multilang-input t2"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
											<?php endif;?>
										</span>
										<?php
									} 
									?>
									<span class="block float_left r5 w130">
										<span class="pj-form-field-custom pj-form-field-custom-before">
											<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
											<input type="text" name="price[<?php echo $index;?>]" class="pj-form-field pj-positive-number w60" />
										</span>
									</span>
									<label class="block t10 float_left r5 content"><?php __('lblAvailable'); ?></label>
									<span class="block float_left r10">
										<input type="text" name="available[<?php echo $index;?>]" value="5" class="pj-form-field field-int w60" />
									</span>
								</span>
							</p>
							<?php
						}
						?>
					</div>
					<p>
						<label class="title">&nbsp;</label>
						<input type="button" value="<?php __('btnAdd'); ?>" class="pj-button" id="ebc_add_price" />
					</p>
				</div>
			</div><!-- tab-1 -->
			<div id="tabs-2">
				<div id="sub_tabs">
					<ul>
						<li><a href="#sub_tabs-1"><?php __('tabEmail'); ?></a></li>
						<li><a href="#sub_tabs-2"><?php __('tabSMS'); ?></a></li>
					</ul>
					<div id="sub_tabs-1">
						<?php
						pjUtil::printNotice(__('infoConfirmationTitle', true), __('infoConfirmationBody', true) . '<br/><br/>'. __('lblEmailAvailableTokens', true), false); 
						?>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<div class="multilang"></div>
						<?php endif; ?>	
						<div class="clear_both">
							<fieldset>
								<legend>
									<span class="inline_block pt5"><?php __('lblConfirmationEmail'); ?></span>
									<a class="pj-form-langbar-tip listing-tip" href="#" title="<?php echo nl2br(__('lblConfirmationEmailTip', true)); ?>"></a>
								</legend>
								<?php
								foreach ($tpl['lp_arr'] as $v)
								{
									?>
									<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
										<label class="title bold"><?php __('lblSubject'); ?></label>
										<span class="inline_block">
											<input type="text" name="i18n[<?php echo $v['id']; ?>][o_email_confirmation_subject]" class="pj-form-field w400" lang="<?php echo $v['id']; ?>" value="<?php echo isset($tpl['arr']) ? htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['o_email_confirmation_subject'])) : NULL; ?>"/>
											<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
											<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
											<?php endif; ?>
										</span>
									</p>
									<?php
								}
								foreach ($tpl['lp_arr'] as $v)
								{
									?>
									<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
										<label class="title">
											<span class="bold"><?php __('lblMessage'); ?></span>
										</label>
										<span class="inline_block">
											<textarea name="i18n[<?php echo $v['id']; ?>][o_email_confirmation]" class="pj-form-field h400 mceEditor" lang="<?php echo $v['id']; ?>" style="height: 380px;"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['o_email_confirmation'])); ?></textarea>
											<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
											<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
											<?php endif; ?>
										</span>
									</p>
									<?php
								}
								?>
							</fieldset>
							<br/>
							<fieldset>
								<legend>
									<span class="inline_block pt5"><?php __('lblPaymentEmail'); ?></span>
									<a class="pj-form-langbar-tip listing-tip" href="#" title="<?php echo nl2br(__('lblPaymentEmailTip', true)); ?>"></a>
								</legend>
								<?php
								foreach ($tpl['lp_arr'] as $v)
								{
									?>
									<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
										<label class="title bold"><?php __('lblSubject'); ?></label>
										<span class="inline_block">
											<input type="text" name="i18n[<?php echo $v['id']; ?>][o_email_payment_subject]" class="pj-form-field w400" lang="<?php echo $v['id']; ?>" value="<?php echo isset($tpl['arr']) ? htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['o_email_payment_subject'])) : NULL; ?>"/>
											<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
											<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
											<?php endif; ?>
										</span>
									</p>
									<?php
								}
								foreach ($tpl['lp_arr'] as $v)
								{
									?>
									<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
										<label class="title">
											<span class="bold"><?php __('lblMessage'); ?></span>
										</label>
										<span class="inline_block">
											<textarea name="i18n[<?php echo $v['id']; ?>][o_email_payment]" class="pj-form-field h400 mceEditor" lang="<?php echo $v['id']; ?>" style="height: 380px;"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['o_email_payment'])); ?></textarea>
											<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
											<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
											<?php endif; ?>
										</span>
									</p>
									<?php
								}
								?>
							</fieldset>
						</div>
					</div>
					<div id="sub_tabs-2">
						<?php
						pjUtil::printNotice(__('infoSMSConfirmationTitle', true), __('infoSMSConfirmationBody', true) . '<br/><br/>'. __('lblSMSAvailableTokens', true), false); 
						?>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<div class="multilang"></div>
						<?php endif; ?>	
						<div class="clear_both">
							<fieldset>
								<legend>
									<span class="inline_block pt5"><?php __('lblConfirmationSMS'); ?></span>
									<a class="pj-form-langbar-tip listing-tip" href="#" title="<?php echo nl2br(__('lblConfirmationSMSTip', true)); ?>"></a>
								</legend>
								<?php
								foreach ($tpl['lp_arr'] as $v)
								{
									?>
									<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
										<label class="title">
											<span class="bold"><?php __('lblMessage'); ?></span>
										</label>
										<span class="inline_block">
											<textarea name="i18n[<?php echo $v['id']; ?>][o_sms_confirmation]" class="pj-form-field h200 w500" lang="<?php echo $v['id']; ?>"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['o_sms_confirmation'])); ?></textarea>
											<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
											<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
											<?php endif; ?>
										</span>
									</p>
									<?php
								}
								?>
							</fieldset>
							<br/>
							<fieldset>
								<legend>
									<span class="inline_block pt5"><?php __('lblPaymentSMS'); ?></span>
									<a class="pj-form-langbar-tip listing-tip" href="#" title="<?php echo nl2br(__('lblPaymentSMSTip', true)); ?>"></a>
								</legend>
								<?php
								foreach ($tpl['lp_arr'] as $v)
								{
									?>
									<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
										<label class="title">
											<span class="bold"><?php __('lblMessage'); ?></span>
										</label>
										<span class="inline_block">
											<textarea name="i18n[<?php echo $v['id']; ?>][o_sms_payment]" class="pj-form-field h200 w500" lang="<?php echo $v['id']; ?>"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['o_sms_payment'])); ?></textarea>
											<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
											<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
											<?php endif; ?>
										</span>
									</p>
									<?php
								}
								?>
							</fieldset>
						</div>
					</div>	
				</div>
			</div><!-- tab-2 -->
			<div id="tabs-3">
				<?php
				pjUtil::printNotice(__('infoTermsTitle', true), __('infoTermsBody', true)); 
				?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang"></div>
				<?php endif; ?>	
				<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][terms]" class="pj-form-field b5" style="width: 720px; height: 200px;" lang="<?php echo $v['id']; ?>"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['terms'])); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					} 
					?>
				</div>	
			</div><!-- tab-3 -->
			<div id="tabs-4">
				<?php
				$info_body = __('infoTicketsImageBody', true);
				$info_body = str_replace("[STARTTAG]", "<a href='".PJ_INSTALL_URL."sample-ticket.jpg' target='_blank'>", $info_body);
				$info_body = str_replace("[ENDTAG]", "</a>", $info_body);
				pjUtil::printNotice(__('infoTicketsImageTitle', true), $info_body, false); 
				$ticket_info = "{Name}\n{Email}\n{Ticket}\n";
				if(!empty($tpl['arr']['ticket_info']))
				{
					$ticket_info = htmlspecialchars(stripslashes($tpl['arr']['ticket_info']));
				}
				?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang"></div>
				<?php endif; ?>
				<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title">
								<?php __('lblTicketDetails'); ?>
								<br/><br/>
								<span class="tokens">
									<?php __('lblImageTokens');?>
								</span>
							</label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][ticket_info]" class="pj-form-field b5" style="width: 540px; height: 200px;" lang="<?php echo $v['id']; ?>"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['ticket_info'])); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					} 
					?>	
					<p>
						<label class="title"><?php __('lblTicketImage'); ?></label>
						<span class="inline_block">
							<input type="file" name="ticket_img" id="ticket_img" class="pj-form-field" />
						</span>
					</p>
					<?php
					if (!empty($tpl['arr']['ticket_img']) && is_file(PJ_INSTALL_PATH . $tpl['arr']['ticket_img']))
					{
						 ?>
						 <p>
							<label class="title">&nbsp;</label>
							<span class="inline_block">
								<a href="<?php echo PJ_INSTALL_URL . $tpl['arr']['ticket_img']; ?>?<?php echo rand(9999,99999); ?>" target="_blank"><img class="ticket-img" src="<?php echo PJ_INSTALL_URL . $tpl['arr']['ticket_img'];?>" /></a>
							</span>
						</p>
						 <?php
					}
					?>
				</div>
			</div><!-- tab-4 -->
			<div id="tabs-5">
				<?php
				pjUtil::printNotice(__('infoBookingsTitle', true), __('infoBookingsBody', true)); 
				
				if(count($tpl['booking_arr']) > 0)
				{
					$bk_statuses = __('booking_statuses', true);
					?>
					<table class="tbl-booking">
						<thead>
							<tr>
								<th width="100"><?php __('lblID');?></th>
								<th width="140"><?php __('lblBookingName');?></th>
								<th><?php __('lblBookingEmail');?></th>
								<th width="100"><?php __('lblTickets');?></th>
								<th width="80"><?php __('lblStatus');?></th>
							</tr>
						</thead>
						<tbody>
							<?php
							$i = 0;
							foreach($tpl['booking_arr'] as $v)
							{
								?>
								<tr class="<?php echo $i % 2 == 0 ? 'even' : 'odd'; ?>">
									<?php
									if($v['booking_status'] == 'pending')
									{ 
										?><td><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionUpdate&id=<?php echo $v['id'];?>"><?php echo $v['unique_id'];?></a></td><?php
									}else{
										?><td><?php echo $v['unique_id'];?></td><?php
									} 
									?>
									<td><?php echo stripslashes($v['customer_name']);?></td>
									<td><?php echo stripslashes($v['customer_email']);?></td>
									<td>
										<?php
										$temp_arr = $tpl['detail_arr'][$v['id']];
										if(count($temp_arr) > 0)
										{
											foreach($temp_arr as $d)
											{
												echo $d['cnt'] . ' x ' . $d['price_title'] . '<br/>';
											}
										}else{
											?>&nbsp;<?php
										}	
										?>
									</td>
									<td><?php echo stripslashes($bk_statuses[$v['booking_status']]);?></td>
								</tr>
								<?php
								$i++;
							} 
							?>
						</tbody>
					</table>
					<?php
				} 
				?>
				<div class="form pj-form t20">
					
					<p class="pj-short">
						<label class="title"><?php __('lblCurrentDateTime');?>:</label>
						<span class="inline_block">
							<label class="content"><?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s'), 'H:i:s', $tpl['option_arr']['o_time_format']);?></label>
						</span>
					</p>
					<p  class="pj-short">
						<label class="title"><?php __('lblTotalBookings');?>:</label>
						<span class="inline_block">
							<label class="content"><?php echo count($tpl['booking_arr']);?></label>
						</span>
					</p>
					<p  class="pj-short">
						<label class="title"><?php __('lblTotalTickets');?>:</label>
						<span class="inline_block">
							<label class="content"><?php echo $tpl['total_tickets'];?></label>
						</span>
					</p>
					<?php
					if(isset($tpl['print_file']))
					{ 
						?>
						<p class="pj-short">
							<label class="title">&nbsp;</label>
							<span class="inline_block">
								<label class="content"><a target="_blank" href="<?php echo $tpl['print_file'];?>" class="pj-button pj-button-link"><?php __('btnPrint'); ?></a></label>
							</span>
						</p>
						<?php
					} 
					?>
				</div>
			</div><!-- tab-5 -->
			<div id="tabs-6">
				<?php
				pjUtil::printNotice(__('infoUsedTicketsTitle', true), __('infoUsedTicketsBody', true)); 
				
				if(count($tpl['tickets_arr']) > 0)
				{
					?>
					<table class="tbl-booking">
						<thead>
							<tr>
								<th width="140"><?php __('lblBookingName');?></th>
								<th><?php __('lblBookingEmail');?></th>
								<th width="120"><?php __('lblTicketType');?></th>
								<th width="100"><?php __('lblUsedTickets');?></th>
							</tr>
						</thead>
						<tbody>
							<?php
							$i = 0;
							foreach($tpl['tickets_arr'] as $v)
							{
								?>
								<tr class="<?php echo $i % 2 == 0 ? 'even' : 'odd'; ?>">
									<td><?php echo stripslashes($v['customer_name']);?></td>
									<td><?php echo stripslashes($v['customer_email']);?></td>
									<td><?php echo $v['price_title'];?></td>
									<td><?php echo stripslashes($v['ticket_id']);?></td>
								</tr>
								<?php
								$i++;
							} 
							?>
						</tbody>
					</table>
					<?php
				} 
				?>
				<div class="form pj-form t20">
					
					<p class="pj-short">
						<label class="title"><?php __('lblCurrentDateTime');?>:</label>
						<span class="inline_block">
							<label class="content"><?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s'), 'H:i:s', $tpl['option_arr']['o_time_format']);?></label>
						</span>
					</p>
					<p  class="pj-short">
						<label class="title"><?php __('lblTotalAvailable');?>:</label>
						<span class="inline_block">
							<label class="content"><?php echo $tpl['arr']['total_avail'];?></label>
						</span>
					</p>
					<p class="pj-short">
						<label class="title"><?php __('lblBookedTickets');?>:</label>
						<span class="inline_block">
							<label class="content"><?php echo $tpl['total_tickets'];?></label>
						</span>
					</p>
					<p class="pj-short">
						<label class="title"><?php __('lblUsedTickets');?>:</label>
						<span class="inline_block">
							<label class="content"><?php echo $tpl['used_tickets'];?></label>
						</span>
					</p>
					<?php
					if(isset($tpl['print_tickets_file']))
					{ 
						?>
						<p class="pj-short">
							<label class="title">&nbsp;</label>
							<span class="inline_block">
								<label class="content"><a target="_blank" href="<?php echo $tpl['print_tickets_file'];?>" class="pj-button pj-button-link"><?php __('btnPrint'); ?></a></label>
							</span>
						</p>
						<?php
					} 
					?>
				</div>
			</div><!-- tab-6 -->
			<div id="tabs-7">
				<?php pjUtil::printNotice(NULL, __('lblInstallPhp1Title', true), false, false); ?>
				<input type="checkbox" id="install_hide" name="install_hide" value="1" class="block float_left r5 b10"/><label for="install_hide"><?php __('lblHideLanguageSelector'); ?></label>
				
				<textarea id="install_step_1" class="pj-form-field textarea_install" style="overflow: auto; height:120px; width: 729px;"></textarea>

<textarea id="install_step_clone" class="pj-form-field textarea_install" style="overflow: auto; height:120px; width: 729px;display: none;">&lt;link href="<?php echo PJ_INSTALL_URL.PJ_FRAMEWORK_LIBS_PATH . 'pj/css/'; ?>pj.bootstrap.min.css" type="text/css" rel="stylesheet" /&gt;
&lt;link href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFrontEnd&amp;action=pjActionLoadCss&theme=<?php echo str_replace("theme", "", $tpl['option_arr']['o_theme']);?>" type="text/css" rel="stylesheet" /&gt;
&lt;script type="text/javascript" src="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFrontEnd&amp;action=pjActionLoad&amp;theme=<?php echo str_replace("theme", "", $tpl['option_arr']['o_theme']);?>&amp;view=list&amp;icons=T&amp;event_id=<?php echo $tpl['arr']['id'];?>{HIDE}"&gt;&lt;/script&gt;</textarea>
			</div><!-- tab-6 -->
			
			<div id="button_container">
				<?php
				if($tpl['number_of_events'] > 1)
				{ 
					$text_apply = str_replace('{numevents}', $tpl['number_of_events'], __('lblApplyRecurring', true));
					?>
					<p>
						<label class="title">&nbsp;</label>
						<span class="inline_block">
							<input type="checkbox" class="float_left t5 r10" value="1" id="apply_recurring" name="apply_recurring">
							<label for="apply_recurring" class="apply-recurring"><?php echo $text_apply;?></label>
						</span>
					</p>
					<?php
				} 
				?>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEvents&action=pjActionIndex';" />
				</p>
			</div>
		</div><!-- Tabs -->
	</form>
	
	<div id="dialogDeleteImage" title="<?php __('lblDeleteImageTitle'); ?>" style="display:none">
		<p id="pjEbcDeleteSingle" class="pjEbcDeleteImage"><?php __('lblDeleteImageBody'); ?></p>
		<p id="pjEbcDeleteAll" class="pjEbcDeleteImage"><?php __('lblDeleteAllImagesBody'); ?></p>
	</div>
	
	
	<div id="clone_container" style="display:none;">
		<p id="price_box_{index}" class="price-box" data-index="{index}">
			<label class="title">&nbsp;</label>
			<span class="block overflow">
				<?php
				foreach ($tpl['lp_arr'] as $v)
				{
					?>
					<span class="pj-multilang-wrap block float_left r10" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
						<input type="text" name="i18n[<?php echo $v['id']; ?>][name][{index}]" class="pj-form-field w120<?php echo (int) $v['is_default'] === 0 ? NULL : ' ebcRequired'; ?>" lang="<?php echo $v['id']; ?>" data-msg-required="<?php __('lblFieldRequired');?>"/>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input t2"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif;?>
					</span>
					<?php
				} 
				?>
				<span class="block float_left r5 w130">
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" name="price[{index}]" class="pj-form-field pj-positive-number w60" />
					</span>
				</span>
				<label class="block t10 float_left r5 content"><?php __('lblAvailable'); ?></label>
				<span class="block float_left r10">
					<input type="text" name="available[{index}]" value="5" class="pj-form-field {fieldint} w60" />
				</span>
				<input type="button" value="<?php __('btnRemove'); ?>" class="pj-button btn-remove-price" id="ebc_remove_price_{index}" lang="{index}" />
			</span>
		</p>
	</div>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.lblInvalidPrice = "<?php __('lblInvalidPrice'); ?>";
	myLabel.lblFieldRequired = "<?php __('lblFieldRequired'); ?>";
	myLabel.localeId = "<?php echo $controller->getLocaleId(); ?>";
	var locale_array = new Array(); 
	<?php
	foreach ($tpl['lp_arr'] as $v)
	{
		?>locale_array.push(<?php echo $v['id'];?>);<?php
	} 
	?>
	myLabel.locale_array = locale_array;
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: <?php echo $tpl['locale_str']; ?>,
				flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
				select: function (event, ui) {
					
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
		$tab_id = explode("-", $_GET['tab_id']);
		$tab_id = (int) $tab_id[1] - 1;
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "active", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
	if (isset($_GET['sub_tab_id']) && !empty($_GET['sub_tab_id']))
	{
		$tab_id = explode("-", $_GET['sub_tab_id']);
		$tab_id = (int) $tab_id[1] - 1;
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#sub_tabs").tabs("option", "active", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>