<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	pjUtil::printNotice(__('infoInstallPreviewTitle', true), __('infoInstallPreviewDesc', true), false, false);
	
	$install_view = __('install_view', true);
	$yesno_arr = __('_yesno', true);
	$theme_arr = __('option_themes', true);
	ksort($theme_arr);
	$selected_theme = str_replace("theme", "", $tpl['option_arr']['o_theme']);
	if(isset($_GET['theme']))
	{
		$selected_theme = 'theme' . $_GET['theme'];
	}
	?>
	<div id="pjTbsInstallPreview">
		<fieldset class="fieldset white">
			<legend><?php __('lblFrontEndOptions'); ?></legend>
			<br/>
			<form action="" method="get" class="pj-form form">
				<p>
					<label class="title"><?php __('lblView'); ?></label>
					<span class="inline_block">
						<select name="install_view" id="install_view" class="pj-form-field w150">
							<option value="list"><?php echo $install_view['list'];?></option>
							<option value="calendar"><?php echo $install_view['calendar'];?></option>
							<option value="monthly" selected="selected"><?php echo $install_view['monthly'];?></option>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblHideSwitchIcons'); ?></label>
					<span class="inline_block">
						<select name="hide_icons" id="hide_icons" class="pj-form-field w100">
							<option value="F"><?php echo $yesno_arr['F'];?></option>
							<option value="T"><?php echo $yesno_arr['T'];?></option>
						</select>
					</span>
				</p>
				<?php
				if(count($tpl['category_arr']) > 0)
				{ 
					?>
					<p>
						<label class="title"><?php __('lblShowSpecificCategory'); ?></label>
						<span class="inline_block">
							<select name="category_id" id="category_id" class="pj-form-field w300">
								<option value="0">-- <?php __('lblChoose');?> --</option>
								<?php
								foreach($tpl['category_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['category_name']);?></option><?php
								} 
								?>
							</select>
						</span>
					</p>
					<?php
				}
				if(count($tpl['locale_arr']) > 1)
				{ 
					?>
					<p>
						<label class="title"><?php __('lblInstallLanguage'); ?></label>
						<select class="pj-form-field w200 r20 float_left" id="install_locale" name="install_locale">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach ($tpl['locale_arr'] as $locale)
							{
								?><option value="<?php echo $locale['id']; ?>"><?php echo pjSanitize::html($locale['title']); ?></option><?php
							}
							?>
						</select>
						<span class="inline_block t8">
							<input type="checkbox" id="install_hide" name="install_hide" value="1" class="block float_left r5"/><label for="install_hide"><?php __('lblHideLanguageSelector'); ?></label>
						</span>
					</p>
					<?php
				}else if(count($tpl['locale_arr']) == 1){
					?><input type="hidden" id="hidden_locale" name="hidden_locale" value="<?php echo $tpl['locale_arr'][0]['id'];?>"/><?php
				} 
				?>
			</form>
		</fieldset>
		<fieldset class="fieldset white pjTbsPreview">
			<legend><?php __('lblChooseTheme'); ?></legend>
			<div class="theme-holder pj-loader-outer">
				<?php include PJ_VIEWS_PATH . 'pjAdminOptions/elements/theme.php'; ?>
			</div>
		</fieldset>
		<?php
		pjUtil::printNotice(__('infoInstalCodeTitle', true), __('infoInstalCodeDesc', true), false, false);
		?>
		<form action="" method="get" class="pj-form form">
			<textarea id="install_step_1" class="pj-form-field textarea_install" style="overflow: auto; height:120px; width: 726px;"></textarea>
			</form>
			<div id="clone_step_1" style="display:none;">&lt;link href="<?php echo PJ_INSTALL_URL.PJ_FRAMEWORK_LIBS_PATH . 'pj/css/'; ?>pj.bootstrap.min.css" type="text/css" rel="stylesheet" /&gt;
&lt;link href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFrontEnd&amp;action=pjActionLoadCss{CSSFile}" type="text/css" rel="stylesheet" /&gt;
&lt;script type="text/javascript" src="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFrontEnd&amp;action=pjActionLoad&amp;theme={THEME}&amp;view={VIEW}&amp;icons={ICONS}&amp;cid={CID}{LOCALE}{HIDE}"&gt;&lt;/script&gt;</div>
	</div>
	<?php
}
?>