<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjTicketModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'tickets';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'event_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'available_tickets', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'maximum_purchase', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'sale_start', 'type' => 'datetime', 'default' => ':NULL'),
		array('name' => 'sale_end', 'type' => 'datetime', 'default' => ':NULL'),
		array('name' => 'show_sale_start', 'type' => 'enum', 'default' => 'T'),
		array('name' => 'show_sale_end', 'type' => 'enum', 'default' => 'T'),
		array('name' => 'type', 'type' => 'enum', 'default' => 'paid'),
		array('name' => 'price', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'tickets_sold', 'type' => 'enum', 'default' => 'sold'),
		array('name' => 'show_remain', 'type' => 'enum', 'default' => 'yes'),
		array('name' => 'attendee_name', 'type' => 'enum', 'default' => 'yes')
	);
	
	public $i18n = array('title', 'description');
	
	public static function factory($attr=array())
	{
		return new pjTicketModel($attr);
	}
}
?>