<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat events">
				<div class="info">
					<abbr><?php echo $tpl['cnt_events'];?></abbr>
					<label><?php echo $tpl['cnt_events'] != 1 ? __('dash_events') : __('dash_event');?></label>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat bookings">
				<div class="info">
					<abbr><?php echo $tpl['cnt_bookings'];?></abbr>
					<label><?php echo $tpl['cnt_bookings'] != 1 ? __('dash_bookings') : __('dash_booking');?></label>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat tickets">
				<div class="info">
					<abbr><?php echo $tpl['cnt_tickets_sold'];?></abbr>
					<label><?php echo $tpl['cnt_tickets_sold'] != 1 ? __('dash_tickets_sold') : __('dash_ticket_sold');?></label>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('dash_upcoming_events');?></div>
			<div class="dashboard_column_top"><?php __('dash_latest_bookings');?></div>
			<div class="dashboard_column_top"><?php __('dash_quick_links');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['upcoming_events']) > 0)
					{
						foreach($tpl['upcoming_events'] as $v)
						{
							$available = (int) $v['cnt_tickets'] - (int) $v['tickets_sold'];
							?>
							<div class="dashboard_row">
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionUpdate&amp;event_id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['title'])?></a></label>
								<label><?php echo $available;?> <?php $available != 1 ? __('dash_tickets_available') : __('dash_ticket_available');?></label>
								<label><?php echo $v['tickets_sold'];?> <?php $v['tickets_sold'] != 1 ? __('dash_tickets_sold') : __('dash_ticket_sold');?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row">
							<label><span><?php __('dash_no_events_found');?></span></label>
						</div>
						<?php
					} 
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['latest_bookings']) > 0)
					{
						foreach($tpl['latest_bookings'] as $v)
						{
							?>
							<div class="dashboard_row">
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['c_name'])?></a></label>
								<label><?php echo pjSanitize::html($v['event_title']);?></label>
								<label><?php echo $v['cnt_tickets'];?> <?php $v['cnt_tickets'] != 1 ? __('dash_tickets') : __('dash_ticket');?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row">
							<label><span><?php __('dash_no_bookings_found');?></span></label>
						</div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="quick_links">
					<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionBarcode"><?php __('dash_ticket_barcode_reader');?></a></label>
					<label>&nbsp;</label>
					<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionCreate"><?php __('dash_add_event');?></a></label>
					<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionCreate"><?php __('dash_add_booking');?></a></label>
					<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOptions&amp;action=pjActionBookingForm"><?php __('dash_custom_booking_form');?></a></label>
					<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOptions&amp;action=pjActionNotification"><?php __('dash_setup_email_notify');?></a></label>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $other) = explode("_", date("H:i_l_F d, Y"));
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format'], time()); ?></div>
		</div>
	</div>
	<?php
}
?>