<?php
if(isset($tpl['ticket_arr']) && !empty($tpl['ticket_arr']))
{ 
	$number_of_tickets = 0;
	?>
	<div class="p">
		<label class="title"><?php __('lblTickets'); ?></label>
		<div class="inline_block">
			<table id="pjTbsTicketTable" class="pj-table" cellspacing="0" cellpadding="0" style="width: 100%;">
				<thead>
					<tr>
						<th><?php __('lblTitle');?></th>
						<th><?php __('lblType');?></th>
						<th><?php __('lblPrice');?></th>
						<th><?php __('lblAvailable');?></th>
						<th><?php __('lblQty');?></th>
						<?php
						if(!empty($tpl['event']['map']))
						{ 
							?>
							<th><?php __('lblSeats');?></th>
							<?php
						} 
						?>
					</tr>
				</thead>
				<tbody>
					<?php
					$ticket_types['free'] = __('lblFree', true);
					$ticket_types['donation'] = __('lblDonation', true);
					$ticket_types['paid'] = __('lblPaid', true);
					
					foreach($tpl['ticket_arr'] as $k => $v)
					{
						$available = (int) $v['available_tickets'] - (int) $v['cnt_booked'];
						$ticket_sold = 'shown';
						if($available <= 0 && $v['tickets_sold'] == 'hide')
						{
							$ticket_sold = 'hide';
						}else if($available <= 0 && $v['tickets_sold'] == 'sold'){
							$ticket_sold = 'sold';
						}else if($available <= 0 && $v['tickets_sold'] == 'join'){
							$ticket_sold = 'join';
						}
						
						if($ticket_sold == 'shown' || $ticket_sold == 'sold' || $ticket_sold == 'join')
						{
							$selected_ticket_count = 0;
							$donation_amount = '';
							$unit_price = '';
							$paid_price = $v['price'];
							if(isset($tpl['booking_ticket_arr'][$v['id']]) && count($tpl['booking_ticket_arr'][$v['id']]) > 0)
							{
								$selected_ticket_count = count($tpl['booking_ticket_arr'][$v['id']]);
								$donation_amount =  $tpl['booking_ticket_arr'][$v['id']][0]['donation'];
								$unit_price =  $tpl['booking_ticket_arr'][$v['id']][0]['unit_price'];
								$paid_price = $unit_price;
								$number_of_tickets += $selected_ticket_count;
							}
							?>
							<tr>
								<td><?php echo pjSanitize::html($v['title']);?></td>
								<td><?php echo $ticket_types[$v['type']];?></td>
								<td id="pjTbsCellPrice_<?php echo $v['id'];?>">
									<?php
									if($v['type'] == 'paid' && !empty($v['price']))
									{
										echo pjUtil::formatCurrencySign($paid_price, $tpl['option_arr']['o_currency']);
									}else{
										echo '--';
									} 
									?>
								</td>
								<td><?php echo $available;?></td>
								<td>
									<?php
									if($ticket_sold == 'sold')
									{
										__('lblSoldOut');
									}else if($ticket_sold == 'join'){
										?><a href="#" class="pjTbsJoinWaitlist" data-event_id="<?php echo $v['event_id'];?>" data-ticket_id="<?php echo $v['id'];?>"><?php __('lblJoinWaitList');?></a><?php
									}else{
										
										if($v['type'] == 'donation')
										{
											?>
											<span class="block float_left r5">
												<span class="pj-form-field-custom pj-form-field-custom-before">
													<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
													<input type="text" id="pjTbsDonation_<?php echo $v['id'];?>" name="donation[<?php echo $v['id'];?>]" value="<?php echo $donation_amount;?>" class="pj-form-field number w50 pjTbsDonation"/>
												</span>
											</span>
											<?php
										}else if($v['type'] == 'paid'){
											?><input type="hidden" id="pjTbsUnitPrice_<?php echo $v['id'];?>" name="unit_price[<?php echo $v['id'];?>]" value="<?php echo $paid_price;?>" class="pj-form-field number w50 pjTbsDonation"/><?php
										}
										if($available > (int) $v['maximum_purchase'])
										{
											$available = (int) $v['maximum_purchase'];
										}
										
										?>
										<span class="inline_block">
											<select id="pjTbsTicketQty_<?php echo $v['id'];?>" 
													name="count[<?php echo $v['id'];?>]" class="pj-form-field w70 pjTbsTicketQty" 
													data-type="<?php echo $v['type'];?>" 
													data-attendee="<?php echo $v['attendee_name'];?>" 
													data-map="<?php echo !empty($tpl['event']['map']) ? 'T' : 'F'; ?>" 
													data-id="<?php echo $v['id'];?>" 
													data-price="<?php echo $v['type'] == 'paid' && !empty($v['price']) ? $paid_price : 0;?>" 
													data-count="<?php echo $available + 1;?>"  
													data-original_price="<?php echo $v['type'] == 'paid' && !empty($v['price']) ? $v['price'] : 0;?>" 
													data-original_price_format="<?php echo $v['type'] == 'paid' && !empty($v['price']) ? pjUtil::formatCurrencySign($v['price'], $tpl['option_arr']['o_currency']) : 0;?>" >
												<option vlaue="0">0</option>
												<?php
												for($i = 1; $i <= $available; $i++)
												{
													?><option vlaue="<?php echo $i;?>"<?php echo $i==$selected_ticket_count ? ' selected="selected"' : NULL;?>><?php echo $i;?></option><?php
												} 
												?>
											</select>
										</span>
										<?php
									}
									?>
								</td>
								<?php
								if(!empty($tpl['event']['map']))
								{ 
									$booking_seat_name_arr = array();
									if(isset($tpl['booking_seat_name_arr']) && !empty($tpl['booking_seat_name_arr']) && isset($tpl['booking_seat_name_arr'][$v['id']]))
									{
										$booking_seat_name_arr = $tpl['booking_seat_name_arr'][$v['id']];
									}
									?>
									<td id="pjTbsHiddenSeats_<?php echo $v['id']?>">
										<span id="pjTbsSeatNames_<?php echo $v['id']?>" class="block" style="display:<?php echo !empty($booking_seat_name_arr) ? 'block' : 'none';?>;"><?php echo implode("; ", $booking_seat_name_arr);?></span>
										<a href="#" id="pjTbsSelectSeatsLabel_<?php echo $v['id']?>" style="display: <?php echo $selected_ticket_count > 0 ? 'block' : 'none';?>;" class="pjTbsSelectSeatsLabel" data-event_id="<?php echo $v['event_id'];?>" data-ticket_id="<?php echo $v['id'];?>"><?php __('lblSelectSeats');?></a>
										<span id="pjTbsNoneLabel_<?php echo $v['id']?>" style="display: <?php echo $selected_ticket_count > 0 ? 'none' : 'block';?>;">--</span>
										<?php
										if(isset($tpl['booking_seat_arr']) && !empty($tpl['booking_seat_arr']) && isset($tpl['booking_seat_arr'][$v['id']]))
										{
											foreach($tpl['booking_seat_arr'][$v['id']] as $index => $seat_id)
											{
												?><input type="hidden" id="seat_id_<?php echo $v['id'];?>_<?php echo $seat_id;?>" name="seat_id[<?php echo $v['id']?>][<?php echo $seat_id?>]" data-name="<?php echo $booking_seat_name_arr[$index];?>" class="pjTbsHiddenSeat tbHiddenSeat_<?php echo $seat_id;?>" value="<?php echo $seat_id;?>"/><?php
											}
										}
										?>
									</td>
									<?php
								} 
								?>
							</tr>	
							<?php
						}
					} 
					?>
				</tbody>
			</table>
			<input type="hidden" id="pjTbsTotalTickets" name="total_tickets" class="required" value="<?php echo $number_of_tickets == 0 ? '' : $number_of_tickets;?>" data-msg-required="<?php __('lblTicketRequired');?>"/>
		</div>
		<em class="pjTbsSeatErrorMsg" style="display: none;"><label><?php __('lblNotEnoughSeats');?></label></em>
	</div>
	<?php
} 
?>