<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);
	
	$yes_no = __('_yesno', true);
	?>
	<div class="b10"><?php __('lblEvent');?>: <span class="bold"><?php echo pjSanitize::html($tpl['event_arr']['title']);?></span></div>
	<?php
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/eventmenu.php';
	
	pjUtil::printNotice(__('infoEventDiscountTitle', true, false), __('infoEventDiscountDesc', true, false)); ?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionDiscount" method="post" id="frmUpdateDiscount" class="form pj-form" autocomplete="off" enctype="multipart/form-data" style="display: <?php echo isset($tpl['arr']) ? 'block': 'none';?>">
		<input type="hidden" name="discount_update" value="1" />
		<input type="hidden" name="event_id" value="<?php echo $tpl['event_arr']['id']; ?>" />
		<?php
		if(isset($tpl['arr']))
		{
			?><input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" /><?php
		} 
		?>
		
		<div class="clear_both">
			
			<p>
				<label class="title"><?php __('lblDiscountCode'); ?></label>
				<span class="inline_block">
					<input type="text" name="code" id="code" value="<?php echo isset($tpl['arr']) ? $tpl['arr']['code'] : NULL;?>" class="pj-form-field w150 required" data-msg-required="<?php __('pj_field_required');?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblType'); ?></label>
				<span class="inline_block">
					<select name="type" id="type" class="pj-form-field w150 required">
						<?php
						foreach (__('discount_types', true, false) as $k => $v)
						{
							?><option value="<?php echo $k; ?>"<?php echo isset($tpl['arr']) ? ($tpl['arr']['type'] == $k ? ' selected="selected"' : NULL) : NULL;?> data-sign="<?php echo $k == 'amount' ? pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], "") : '%'; ?>"><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblDiscount'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr id="icon_type" class="pj-form-field-icon-text"><?php echo isset($tpl['arr']) ? ($tpl['arr']['type'] == 'amount' ? pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], "") : '%') : pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], "");?></abbr></span>
					<input type="text" id="discount" name="discount" value="<?php echo isset($tpl['arr']) ? $tpl['arr']['discount'] : NULL;?>" class="pj-form-field number required w80" data-msg-required="<?php __('pj_field_required');?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblTicketTypes'); ?></label>
				<span class="inline_block">
					<select name="ticket_id[]" id="ticket_id" multiple="multiple" size="5" class="pj-form-field w200 required" data-msg-required="<?php __('pj_field_required');?>">
						<?php
						foreach($tpl['ticket_arr'] as $k => $v)
						{
							?><option value="<?php echo $v['id'];?>"<?php echo isset($tpl['ticket_id_arr']) ? (in_array($v['id'], $tpl['ticket_id_arr']) ? ' selected="selected"' : NULL) : NULL;?>><?php echo pjSanitize::html($v['title']);?></option><?php
						} 
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblCount', false, true); ?></label>
				<input type="text" name="count" id="count" value="<?php echo isset($tpl['arr']) ? $tpl['arr']['count'] : NULL;?>" class="pj-form-field field-int required digits w80" data-msg-digits="<?php __('pj_digits_validation');?>" data-msg-required="<?php __('pj_field_required');?>"/>
			</p>
			<p>
				<label class="title"><?php __('lblValidFrom'); ?></label>
				<span class="inline_block">
					<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
						<input type="text" name="valid_from" id="valid_from" value="<?php echo isset($tpl['arr']) ? date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['valid_from'])) . ' ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['valid_from'])) : NULL;?>" class="pj-form-field pointer w140 datetimepick required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblValidTo'); ?></label>
				<span class="inline_block">
					<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
						<input type="text" name="valid_to" id="valid_to" value="<?php echo isset($tpl['arr']) ? date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['valid_to'])) . ' ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['valid_to'])) : NULL;?>" class="pj-form-field pointer w140 datetimepick required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<span class="inline_block">
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEvents&action=pjActionDiscount&event_id=<?php echo $tpl['event_arr']['id'];?>';" />
				</span>
			</p>
		</div>
	</form>
	
	<input type="button" class="pj-button b10 pjTbsAddDiscount" value="<?php __('btnAddDiscountCode'); ?>" style="display:<?php echo isset($tpl['arr']) ? 'none' : 'block';?>"/>
	
	<?php
	if(!isset($tpl['arr']))
	{ 
		?>
		<div id="discount_grid"></div>
		<?php
	} 
	?>
		
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.queryString = "";
	<?php
	if (isset($_GET['event_id']) && (int) $_GET['event_id'] > 0)
	{
		?>pjGrid.queryString += "&event_id=<?php echo (int) $_GET['event_id']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.choose = "-- <?php __('lblChoose'); ?> --";
	myLabel.field_required = "<?php __('pj_field_required'); ?>";
	myLabel.code = "<?php __('lblDiscountCode'); ?>";
	myLabel.discount = "<?php __('lblDiscount'); ?>";
	myLabel.valid_from = "<?php __('lblValidFrom'); ?>";
	myLabel.valid_to = "<?php __('lblValidTo'); ?>";

	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
	</script>
	<?php
}
?>