<section class="pjTbFormSection">
	<p class="pjTbFormSectionTitle"><?php __('front_your_tickets');?></p><!-- /.pjTbFormSectionTitle -->
	<?php
	if(isset($tpl['price_arr']['ticket_arr']))
	{ 
		foreach($tpl['price_arr']['ticket_arr'] as $k => $ticket)
		{
			$selected_seat_arr = array();
			if(isset($tpl['price_arr']['seat_arr']) && isset($tpl['price_arr']['seat_arr'][$ticket['id']]))
			{
				foreach($tpl['price_arr']['seat_arr'][$ticket['id']] as $seat)
				{
					$selected_seat_arr[] = $seat['name'];
				}
			}
			?>
			<div class="row pjTbFormSummary">
				<div class="col-lg-7 col-md-7 col-sm-7 col-xs-12">
					<p><?php echo pjSanitize::html($ticket['title']);?></p>
					<?php
					if(!empty($selected_seat_arr))
					{ 
						?>
						<p><small><?php __('front_seats');?>: <?php echo implode(", ", $selected_seat_arr);?></small></p>
						<?php
					} 
					?>
				</div><!-- /.col-lg-7 col-md-7 col-sm-7 col-xs-12 -->

				<div class="col-lg-3 col-md-3 col-sm-3 col-xs-7">
					<p><?php echo $ticket['qty'];?> <?php $ticket['qty'] == 1 ? __('front_singular_ticket') : __('front_plural_ticket');?></p>
				</div><!-- /.col-lg-3 col-md-3 col-sm-3 col-xs-7 -->

				<div class="pjTbFormPrice">
					<p><strong><?php echo pjUtil::formatCurrencySign(number_format($ticket['total'], 2), $tpl['option_arr']['o_currency']);?></strong></p>
				</div><!-- /.pjTbFormPrice -->
			</div><!-- /.row pjTbFormSummary -->
			<?php
		}
	} 
	?>
	<div class="row pjTbFormSummary">
		<div class="col-lg-5 col-lg-offset-7 col-md-5 col-md-offset-7 col-sm-5 col-sm-offset-7 col-sx-12">
			<div class="row">
				<div class="col-lg-7 col-md-7 col-sm-7 col-xs-7">
					<p class="pjTbFormSummaryPrice"><strong><?php __('front_subtotal');?>:</strong></p>
				</div><!-- /.col-lg-7 col-md-7 col-sm-7 col-xs-7 -->

				<div class="pjTbFormPrice pjTbFormPriceSum">
					<p class="pjTbFormSummaryPrice"><?php echo pjUtil::formatCurrencySign(number_format($tpl['price_arr']['subtotal'], 2), $tpl['option_arr']['o_currency']);?></p>
				</div><!-- /.pjTbFormPrice pjTbFormPriceSum -->
			</div><!-- /.row -->
			<div class="row">
				<div class="col-lg-7 col-md-7 col-sm-7 col-xs-7">
					<p class="pjTbFormSummaryPrice"><strong><?php __('front_tax');?>:</strong></p>
				</div><!-- /.col-lg-7 col-md-7 col-sm-7 col-xs-7 -->

				<div class="pjTbFormPrice pjTbFormPriceSum">
					<p class="pjTbFormSummaryPrice"><?php echo pjUtil::formatCurrencySign(number_format($tpl['price_arr']['tax'], 2), $tpl['option_arr']['o_currency']);?></p>
				</div><!-- /.pjTbFormPrice pjTbFormPriceSum -->
			</div><!-- /.row -->
			<div class="row">
				<div class="col-lg-7 col-md-7 col-sm-7 col-xs-7">
					<p class="pjTbFormSummaryPrice"><strong><?php __('front_total');?>:</strong></p>
				</div><!-- /.col-lg-7 col-md-7 col-sm-7 col-xs-7 -->

				<div class="pjTbFormPrice pjTbFormPriceSum">
					<p class="pjTbFormSummaryPrice"><?php echo pjUtil::formatCurrencySign(number_format($tpl['price_arr']['total'], 2), $tpl['option_arr']['o_currency']);?></p>
				</div><!-- /.pjTbFormPrice pjTbFormPriceSum -->
			</div><!-- /.row -->
			<div class="row">
				<div class="col-lg-7 col-md-7 col-sm-7 col-xs-7">
					<p class="pjTbFormSummaryPrice"><strong><?php __('front_deposit');?>:</strong></p>
				</div><!-- /.col-lg-7 col-md-7 col-sm-7 col-xs-7 -->

				<div class="pjTbFormPrice pjTbFormPriceSum">
					<p class="pjTbFormSummaryPrice"><?php echo pjUtil::formatCurrencySign(number_format($tpl['price_arr']['deposit'], 2), $tpl['option_arr']['o_currency']);?></p>
				</div><!-- /.pjTbFormPrice pjTbFormPriceSum -->
			</div><!-- /.row -->
		</div><!-- /.col-lg-5 col-lg-offset-7 col-md-5 col-md-offset-7 col-sm-5 col-sm-offset-7 col-sx-12 -->
	</div><!-- /.row pjTbFormSummary -->
</section><!-- /.pjTbFormSection -->