<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFrontEnd extends pjFront
{
	public function __construct()
	{
		parent::__construct();
		$this->setAjax(true);
		$this->setLayout('pjActionEmpty');
	}

	public function pjActionLoad()
	{
		$this->setAjax(false);
		$this->setLayout('pjActionFront');
		
		$_terms_conditions = pjMultiLangModel::factory()->select('t1.*')
			->where('t1.model','pjOption')
			->where('t1.locale', $this->getLocaleId())
			->where('t1.field', 'o_terms')
			->limit(0, 1)
			->findAll()->getData();
		$terms_conditions = '';
		if(!empty($_terms_conditions))
		{
			$terms_conditions = $_terms_conditions[0]['content'];
		}
		$this->set('terms_conditions', $terms_conditions);
		
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
	}
	
	public function pjActionLoadCss()
	{
		$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
	
		$theme = $this->option_arr['o_theme'];
		$fonts = $this->option_arr['o_theme'];
		if(isset($_GET['theme']) && in_array($_GET['theme'], array('theme1', 'theme2', 'theme3', 'theme4', 'theme5', 'theme6', 'theme7', 'theme8', 'theme9', 'theme10')))
		{
			$theme = $_GET['theme'];
			$fonts = $_GET['theme'];
		}
		$arr = array(
				array('file' => 'bootstrap-datetimepicker.min.css', 'path' => $dm->getPath('pj_bootstrap_datetimepicker')),
				array('file' => "$fonts.css", 'path' => PJ_CSS_PATH . "fonts/"),
				array('file' => 'style.css', 'path' => PJ_CSS_PATH),
				array('file' => "$theme.css", 'path' => PJ_CSS_PATH . "themes/",
				array('file' => 'transitions.css', 'path' => PJ_CSS_PATH))
		);
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			ob_start();
			@readfile($item['path'] . $item['file']);
			$string = ob_get_contents();
			ob_end_clean();
				
			if ($string !== FALSE)
			{
				echo str_replace(
						array('../fonts/glyphicons', "pjWrapper"),
						array(
								PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/fonts/glyphicons',
								"pjWrapperLimoBooking_" . $theme
						),
						$string
				) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$Captcha = new pjCaptcha(PJ_WEB_PATH.'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH.'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}

	public function pjActionCheckCaptcha()
	{
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	
	public function pjActionSetService()
	{
		if($this->isXHR())
		{
			if($this->_is('fleet_id'))
			{
				$this->_unset('fleet_id');
			}
			if($this->_is('service_id'))
			{
				$this->_unset('service_id');
			}
			if(isset($_POST['fleet_id']) && (int) $_POST['fleet_id'] > 0)
			{
				$this->_set('fleet_id', $_POST['fleet_id']);
			}
			if(isset($_POST['service_id']) && (int) $_POST['service_id'] > 0)
			{
				$this->_set('service_id', $_POST['service_id']);
			}
			pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => ''));
		}
	}
	public function pjActionCheckLogin()
	{
		if($this->isXHR())
		{
			if(isset($_POST['lbs_login']))
			{
				$pjClientModel = pjClientModel::factory();
				
				$client = $pjClientModel
					->where('t1.email', $_POST['login_email'])
					->where(sprintf("t1.password = AES_ENCRYPT('%s', '%s')", pjObject::escapeString($_POST['login_password']), PJ_SALT))
					->limit(1)
					->findAll()
					->getData();
				
				if (count($client) != 1)
				{
					$client = $pjClientModel
						->reset()
						->where('t1.email', $_POST['login_email'])
						->limit(1)
						->findAll()
						->getData();
					if (count($client) != 1)
					{
						pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => __('front_email_does_not_exist', true)));
					}else{
						pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 102, 'text' => __('front_incorrect_password', true)));
					}
				}else{
					if ($client[0]['status'] != 'T')
					{
						pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 101, 'text' => __('front_your_account_disabled', true)));
					}else{
						$last_login = date("Y-m-d H:i:s");
							
						$client = $pjClientModel->reset()->find($client[0]['id'])->getData();
						
						$_SESSION[$this->defaultFrontClient] = $client;
				
						$_SESSION[$this->defaultForm]['c_email'] = $client['email'];
						$_SESSION[$this->defaultForm]['c_password'] = $client['password'];
						$_SESSION[$this->defaultForm]['c_fname'] = $client['fname'];
						$_SESSION[$this->defaultForm]['c_lname'] = $client['lname'];
						$_SESSION[$this->defaultForm]['c_phone'] = $client['phone'];
						
						$_SESSION[$this->defaultForm]['c_company'] = $client['company'];
						$_SESSION[$this->defaultForm]['c_lname'] = $client['address'];
						$_SESSION[$this->defaultForm]['c_city'] = $client['city'];
						$_SESSION[$this->defaultForm]['c_state'] = $client['state'];
						$_SESSION[$this->defaultForm]['c_zip'] = $client['zip'];
						$_SESSION[$this->defaultForm]['c_country'] = $client['country_id'];
							
						$data = array();
						$data['last_login'] = $last_login;
						$pjClientModel->reset()->setAttributes(array('id' => $client[0]['id']))->modify($data);
						pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => ''));
					}
				}
				
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 103, 'text' => ''));
			}
		}
	}
	public function pjActionSendPassword()
	{
		if($this->isXHR())
		{
			$forgot_err = __('forgot_err', true);
			if(isset($_POST['lbs_forgot']))
			{
				$pjClientModel = pjClientModel::factory();
				$client = $pjClientModel
					->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`")
					->where('t1.email', $_POST['email'])
					->limit(1)
					->findAll()
					->getData();
	
				if (count($client) != 1)
				{
					pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => $forgot_err[100]));
				} else {
					$client = $client[0];
					if ($client['status'] != 'T')
					{
						pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 101, 'text' => $forgot_err[101]));
					}
						
					pjAppController::pjActionForgotSend($this->option_arr, $client['id'], PJ_SALT, 'forgot');
						
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => $forgot_err[200]));
				}
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 102, 'text' => $forgot_err[102]));
			}
		}
	}
	public function pjActionLogout()
	{
		if($this->isXHR())
		{
			if(isset($_SESSION[$this->defaultFrontClient]))
			{
				unset($_SESSION[$this->defaultFrontClient]);
			}
			pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => ''));
		}
	}
	
	public function pjActionSaveBooking()
	{
		if ($this->isXHR())
		{
			if (!isset($_POST['lbs_preview']) || !isset($_SESSION[$this->defaultForm]) || empty($_SESSION[$this->defaultForm]) || !isset($_SESSION[$this->defaultStore]) || empty($_SESSION[$this->defaultStore]))
			{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 109));
			}
			if ((int) $this->option_arr['o_bf_include_captcha'] === 3 && (!isset($_SESSION[$this->defaultForm]['captcha']) ||
					!pjCaptcha::validate($_SESSION[$this->defaultForm]['captcha'], $_SESSION[$this->defaultCaptcha]) ))
			{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 110));
			}
	
			$STORE = @$_SESSION[$this->defaultStore];
			$FORM = @$_SESSION[$this->defaultForm];
	
			$data = array();
			$client_data = array();
			$pjClientModel = pjClientModel::factory();
				
			$data['client_id'] = ':NULL';
				
			$client_data['email'] = isset($FORM['c_email']) ? $FORM['c_email'] : ':NULL';
			$client_data['password'] = isset($FORM['c_password']) ? $FORM['c_password'] : 'pass';
			$client_data['email'] = isset($FORM['c_email']) ? $FORM['c_email'] : ':NULL';
			$client_data['title'] = isset($FORM['c_title']) ? $FORM['c_title'] : ':NULL';
			$client_data['fname'] = isset($FORM['c_fname']) ? $FORM['c_fname'] : ':NULL';
			$client_data['lname'] = isset($FORM['c_lname']) ? $FORM['c_lname'] : ':NULL';
			$client_data['phone'] = isset($FORM['c_phone']) ? $FORM['c_phone'] : ':NULL';
			$client_data['company'] = isset($FORM['c_company']) ? $FORM['c_company'] : ':NULL';
			$client_data['address'] = isset($FORM['c_address']) ? $FORM['c_address'] : ':NULL';
			$client_data['city'] = isset($FORM['c_city']) ? $FORM['c_city'] : ':NULL';
			$client_data['state'] = isset($FORM['c_state']) ? $FORM['c_state'] : ':NULL';
			$client_data['zip'] = isset($FORM['c_zip']) ? $FORM['c_zip'] : ':NULL';
			$client_data['country_id'] = isset($FORM['c_country']) ? $FORM['c_country'] : ':NULL';
				
			if($this->isFrontLogged())
			{
				$data['client_id'] = $_SESSION[$this->defaultFrontClient]['id'];
				$pjClientModel->reset()->where('id', $data['client_id'])->limit(1)->modifyAll($client_data);
			}else{
				if(isset($FORM['c_email']))
				{
					$client_arr = $pjClientModel->where('email', $FORM['c_email'])->limit(1)->findAll()->getData();
					if(count($client_arr) == 1)
					{
						$data['client_id'] = $client_arr[0]['id'];
						$pjClientModel->reset()->where('id', $client_arr[0]['id'])->limit(1)->modifyAll($client_data);
					}
				}
	
				if($data['client_id'] == ':NULL')
				{
					$client_data['status'] = 'T';
					$client_data['created'] = date('Y-m-d H:i:s');
	
					$client_id = $pjClientModel->reset()->setAttributes($client_data)->insert()->getInsertId();
					if ($client_id !== false && (int) $client_id > 0)
					{
						$data['client_id'] = $client_id;
						pjAppController::pjActionAccountSend($this->option_arr, $client_id, PJ_SALT, $this->getLocaleId());
					}
				}
			}
				
			$data['uuid'] = pjUtil::uuid();
			$data['fleet_id'] = $STORE['fleet_id'];
			$data['service_id'] = $STORE['service_id'];
			$data['ip'] = pjUtil::getClientIp();
			$data['status'] = $this->option_arr['o_booking_status'];
			$data['created'] = date('Y-m-d H:i:s');
			
			$passengers = isset($FORM['passengers']) ? $FORM['passengers'] : 1;
			$extra_id_arr = isset($FORM['extra_id']) && is_array($FORM['extra_id']) ? array_keys($FORM['extra_id']) : array();
			$price_arr = pjAppController::calPrice($STORE['fleet_id'], $STORE['service_id'], $extra_id_arr, $passengers, $this->option_arr);
			
			$data['sub_total'] = $price_arr['subtotal'];
			$data['tax'] = $price_arr['tax'];
			$data['total'] = $price_arr['total'];
			$data['deposit'] = $price_arr['deposit'];
			$data['booking_date'] = pjUtil::formatDate($FORM['booking_date'], $this->option_arr['o_date_format']) . ' ' . date("H:i:s", strtotime($FORM['booking_time']));
			if($FORM['is_single'] == 'F')
			{
				$data['return_address'] = ':NULL';
			}
			$data['c_flight_time'] = isset($FORM['c_flight_time']) ? date("H:i:s", strtotime($FORM['c_flight_time'])) : ':NULL';
			
			$payment = ':NULL';
			if(isset($FORM['payment_method']))
			{
				if (isset($FORM['payment_method'])){
					$payment = $FORM['payment_method'];
				}
			}
				
			$pjBookingModel = pjBookingModel::factory();
			$id = $pjBookingModel->setAttributes(array_merge($FORM, $data))->insert()->getInsertId();
			if ($id !== false && (int) $id > 0)
			{
				$arr = $pjBookingModel
					->reset()
					->select("t1.*, t2.content as fleet, t3.content as reason, t4.content as service, t5.fname, t5.lname, t5.email, t5.phone,
                                AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,
								AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
								AES_DECRYPT(t1.cc_exp_month, '".PJ_SALT."') AS `cc_exp_month`,
								AES_DECRYPT(t1.cc_exp_year, '".PJ_SALT."') AS `cc_exp_year`,
								AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
					->join('pjMultiLang', "t2.model='pjFleet' AND t2.foreign_id=t1.fleet_id AND t2.field='fleet' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->join('pjMultiLang', "t3.model='pjReason' AND t3.foreign_id=t1.reason_id AND t3.field='name' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
					->join('pjMultiLang', "t4.model='pjService' AND t4.foreign_id=t1.service_id AND t4.field='name' AND t4.locale='".$this->getLocaleId()."'", 'left outer')
					->join('pjClient', "t5.id=t1.client_id", 'left outer')
					->find($id)
					->getData();
	
				$pjBookingExtraModel = pjBookingExtraModel::factory();
				if (isset($FORM['extra_id']) && is_array($FORM['extra_id']) && count($FORM['extra_id']) > 0)
				{
					$pjBookingExtraModel->begin();
					foreach ($FORM['extra_id'] as $extra_id => $price)
					{
						$pjBookingExtraModel
						->reset()
						->set('booking_id', $id)
						->set('extra_id', $extra_id)
						->insert();
					}
					$pjBookingExtraModel->commit();
				}
				
				$pdata = array();
				$pdata['booking_id'] = $id;
				$pdata['payment_method'] = $payment;
				$pdata['payment_type'] = 'online';
				$pdata['amount'] = $arr['deposit'];
				$pdata['status'] = 'notpaid';
				pjBookingPaymentModel::factory()->setAttributes($pdata)->insert();
	
				pjAppController::pjActionConfirmSend($this->option_arr, $arr, PJ_SALT, 'confirm', $this->getLocaleId());
	
				unset($_SESSION[$this->defaultStore]);
				unset($_SESSION[$this->defaultForm]);
					
				$json = array('code' => 200, 'text' => '', 'booking_id' => $id, 'payment' => $payment);
				pjAppController::jsonResponse($json);
			}else {
				pjAppController::jsonResponse(array('code' => 'ERR', 'code' => 119));
			}
		}
	}
	
	public function pjActionConfirmAuthorize()
	{
		if (pjObject::getPlugin('pjAuthorize') === NULL)
		{
			$this->log('Authorize.NET plugin not installed');
			exit;
		}
		$pjBookingModel = pjBookingModel::factory();
	
		$booking_arr = $pjBookingModel
			->select("t1.*, t2.content as fleet, t3.content as reason, t4.content as service, t5.fname, t5.lname, t5.email, t5.phone")
			->join('pjMultiLang', "t2.model='pjFleet' AND t2.foreign_id=t1.fleet_id AND t2.field='fleet' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
			->join('pjMultiLang', "t3.model='pjReason' AND t3.foreign_id=t1.reason_id AND t3.field='name' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
			->join('pjMultiLang', "t4.model='pjService' AND t4.foreign_id=t1.service_id AND t4.field='name' AND t4.locale='".$this->getLocaleId()."'", 'left outer')
			->join('pjClient', "t5.id=t1.client_id", 'left outer')
			->find($_POST['x_invoice_num'])->getData();
		if (count($booking_arr) == 0)
		{
			$this->log('No such booking');
			pjUtil::redirect($this->option_arr['o_thankyou_page']);
		}
	
		if (count($booking_arr) > 0)
		{
			$params = array(
					'transkey' => $this->option_arr['o_authorize_transkey'],
					'x_login' => $this->option_arr['o_authorize_merchant_id'],
					'md5_setting' => $this->option_arr['o_authorize_md5_hash'],
					'key' => md5($this->option_arr['private_key'] . PJ_SALT)
			);
	
			$response = $this->requestAction(array('controller' => 'pjAuthorize', 'action' => 'pjActionConfirm', 'params' => $params), array('return'));
			if ($response !== FALSE && $response['status'] === 'OK')
			{
				$pjBookingModel->reset()
					->setAttributes(array('id' => $response['transaction_id']))
					->modify(array('status' => $this->option_arr['o_payment_status'], 'processed_on' => ':NOW()'));
	
				pjBookingPaymentModel::factory()
					->setAttributes(array('booking_id' => $response['transaction_id'], 'payment_type' => 'online'))
					->modify(array('status' => 'paid'));

				pjAppController::pjActionConfirmSend($this->option_arr, $booking_arr, PJ_SALT, 'payment', $this->getLocaleId());
				
			} elseif (!$response) {
				$this->log('Authorization failed');
			} else {
				$this->log('Booking not confirmed. ' . $response['response_reason_text']);
			}
			?>
				<script type="text/javascript">window.location.href="<?php echo $this->option_arr['o_thankyou_page']; ?>";</script>
			<?php
			return;
		}
	}
		
	public function pjActionConfirmPaypal()
	{
		if (pjObject::getPlugin('pjPaypal') === NULL)
		{
			$this->log('Paypal plugin not installed');
			exit;
		}
		$pjBookingModel = pjBookingModel::factory();
	
		$booking_arr = $pjBookingModel
			->select("t1.*, t2.content as fleet, t3.content as reason, t4.content as service, t5.fname, t5.lname, t5.email, t5.phone")
			->join('pjMultiLang', "t2.model='pjFleet' AND t2.foreign_id=t1.fleet_id AND t2.field='fleet' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
			->join('pjMultiLang', "t3.model='pjReason' AND t3.foreign_id=t1.reason_id AND t3.field='name' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
			->join('pjMultiLang', "t4.model='pjService' AND t4.foreign_id=t1.service_id AND t4.field='name' AND t4.locale='".$this->getLocaleId()."'", 'left outer')
			->join('pjClient', "t5.id=t1.client_id", 'left outer')
			->find($_POST['custom'])->getData();
		if (count($booking_arr) == 0)
		{
			$this->log('No such booking');
			pjUtil::redirect($this->option_arr['o_thankyou_page']);
		}
	
		$params = array(
				'txn_id' => @$booking_arr['txn_id'],
				'paypal_address' => $this->option_arr['o_paypal_address'],
				'deposit' => @$booking_arr['deposit'],
				'currency' => $this->option_arr['o_currency'],
				'key' => md5($this->option_arr['private_key'] . PJ_SALT)
		);
		$response = $this->requestAction(array('controller' => 'pjPaypal', 'action' => 'pjActionConfirm', 'params' => $params), array('return'));
	
		if ($response !== FALSE && $response['status'] === 'OK')
		{
			$this->log('Booking confirmed');
			$pjBookingModel->reset()->setAttributes(array('id' => $booking_arr['id']))->modify(array(
					'status' => $this->option_arr['o_payment_status'],
					'txn_id' => $response['transaction_id'],
					'processed_on' => ':NOW()'
			));
			pjBookingPaymentModel::factory()
				->setAttributes(array('booking_id' => $booking_arr['id'], 'payment_type' => 'online'))
				->modify(array('status' => 'paid'));

			pjAppController::pjActionConfirmSend($this->option_arr, $booking_arr, PJ_SALT, 'payment', $this->getLocaleId());
				
		} elseif (!$response) {
			$this->log('Authorization failed');
		} else {
			$this->log('Booking not confirmed');
		}
		pjUtil::redirect($this->option_arr['o_thankyou_page']);
	}
		
	public function pjActionCancel()
	{
		$this->setAjax(false);
		$this->setLayout('pjActionCancel');
	
		$pjBookingModel = pjBookingModel::factory();
	
		if (isset($_POST['booking_cancel']))
		{
			$booking_arr = $pjBookingModel
			->select("t1.*, t2.content as fleet, t3.content as reason, t4.content as service, t5.fname, t5.lname, t5.email, t5.phone")
			->join('pjMultiLang', "t2.model='pjFleet' AND t2.foreign_id=t1.fleet_id AND t2.field='fleet' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
			->join('pjMultiLang', "t3.model='pjReason' AND t3.foreign_id=t1.reason_id AND t3.field='name' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
			->join('pjMultiLang', "t4.model='pjService' AND t4.foreign_id=t1.service_id AND t4.field='name' AND t4.locale='".$this->getLocaleId()."'", 'left outer')
			->join('pjClient', "t5.id=t1.client_id", 'left outer')
			->find($_POST['id'])->getData();
			if (count($booking_arr) > 0)
			{
				$sql = "UPDATE `".$pjBookingModel->getTable()."` SET status = 'cancelled' WHERE SHA1(CONCAT(`id`, `created`, '".PJ_SALT."')) = '" . $_POST['hash'] . "'";
	
				$pjBookingModel->reset()->execute($sql);
	
				$arr = $pjBookingModel->reset()->find($_POST['id'])->getData();
				pjAppController::pjActionConfirmSend($this->option_arr, $booking_arr, PJ_SALT, 'cancel', $this->getLocaleId());
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjFrontEnd&action=pjActionCancel&err=200');
			}
		}else{
			if (isset($_GET['hash']) && isset($_GET['id']))
			{
				$arr = $pjBookingModel
					->reset()
					->select("t1.*, t2.content as fleet, t3.content as reason, t4.content as service, t5.fname, t5.lname, t5.email, t5.phone, AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,
								AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
								AES_DECRYPT(t1.cc_exp_month, '".PJ_SALT."') AS `cc_exp_month`,
								AES_DECRYPT(t1.cc_exp_year, '".PJ_SALT."') AS `cc_exp_year`,
								AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
					->join('pjMultiLang', "t2.model='pjFleet' AND t2.foreign_id=t1.fleet_id AND t2.field='fleet' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->join('pjMultiLang', "t3.model='pjReason' AND t3.foreign_id=t1.reason_id AND t3.field='name' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
					->join('pjMultiLang', "t4.model='pjService' AND t4.foreign_id=t1.service_id AND t4.field='name' AND t4.locale='".$this->getLocaleId()."'", 'left outer')
					->join('pjClient', "t5.id=t1.client_id", 'left outer')
					->find($_GET['id'])
					->getData();
				if (count($arr) == 0)
				{
					$this->set('status', 2);
				}else{
					if ($arr['status'] == 'cancelled')
					{
						$this->set('status', 4);
					}else{
						$hash = sha1($arr['id'] . $arr['created'] . PJ_SALT);
						if ($_GET['hash'] != $hash)
						{
							$this->set('status', 3);
						}else{
							$client = pjClientModel::factory()
								->select("t1.*, t2.content as country_title")
								->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.country_id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
								->find($arr['client_id'])->getData();
							
							$this->set('arr', $arr);
							$this->set('client', $client);
						}
					}
				}
			}else if (!isset($_GET['err'])) {
				$this->set('status', 1);
			}
		}
	}

}
?>