<?php
include_once dirname(__FILE__) . '/elements/header.php';
?>
<div class="pjLbs-body">
	
	<?php
	if(!empty($tpl['fleet_arr']))
	{ 
		$STORE = @$_SESSION[$controller->defaultStore];
		foreach($tpl['fleet_arr'] as $k => $v)
		{
			$image = PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/250x130.png';
			if(isset($v['thumb_path']) && !empty($v['thumb_path']) && file_exists(PJ_INSTALL_PATH . $v['thumb_path']))
			{
				$image = PJ_INSTALL_URL . $v['thumb_path'];
			}
			?>
			<div class="pjLbs-car pjLbs-box">
				<div class="row">
					<div class="col-sm-3 col-xs-12">
						<div class="pjLbs-car-image">
							<img src="<?php echo $image;?>" alt="" class="img-responsive">
						</div><!-- /.pjLbs-car-image -->
		
						<ul class="pjLbs-car-meta">
							<li><span class="glyphicon glyphicon-user"></span> <strong><?php echo pjSanitize::clean($v['passengers']);?></strong></li>
							<li><span class="glyphicon glyphicon-briefcase"></span> <strong><?php echo pjSanitize::clean($v['luggage']);?></strong></li>
						</ul><!-- /.pjLbs-car-meta -->		
					</div><!-- /.col-md-3 -->
		
					<div class="col-sm-6 col-xs-12">
						<div class="pjLbs-car-desc">
							<div class="pjLbs-car-title"><?php echo pjSanitize::html($v['fleet']);?></div><!-- /.pjLbs-car-title -->
		
							<div class="pjLbs-car-info"><?php echo nl2br(pjSanitize::clean($v['description']));?></div><!-- /.pjLbs-car-info -->
						</div><!-- /.pjLbs-car-desc -->		
					</div><!-- /.col-md-3 -->
		
					<?php
					if(isset($tpl['service_arr'][$v['id']]))
					{
						$service_arr = $tpl['service_arr'][$v['id']];
						?>
						<div class="col-sm-3 col-xs-12">
							<div class="pjLbs-car-actions">
								<form action="#" method="post">
									<input type="hidden" name="fleet_id" value="<?php echo $v['id'];?>"/>
									<div class="form-group">
										<label class="control-label"><?php __('front_service');?>:</label>
			
										<select name="service_id" class="form-control pjLbsServiceSelector" data-fleet_id="<?php echo $v['id'];?>">
											<option value="">--- <?php __('front_choose');?> ---</option>
											<?php
											foreach($service_arr as $service)
											{ 
												?>
												<option value="<?php echo $service['id'];?>"<?php echo isset($STORE['fleet_id']) && isset($STORE['service_id']) ? ( $STORE['fleet_id'] == $v['id'] && $STORE['service_id'] == $service['id'] ? ' selected="selected"' : NULL) : NULL;?>><?php echo pjSanitize::html($service['name']);?></option>
												<?php
											} 
											?>
										</select>
									</div><!-- /.form-group -->
			
									<?php
									foreach($service_arr as $service)
									{ 
										?>
										<div id="pjLbsPriceLabel_<?php echo $service['id'];?>" class="pjLbs-price pjLbs-price-<?php echo $v['id'];?>" style="display:none;"><?php __('front_price');?>: <strong><?php echo pjUtil::formatCurrencySign($service['price'], $tpl['option_arr']['o_currency']);?></strong></div><!-- /.pjLbs-price -->
										<?php
									} 
									?>
			
									<input type="submit" id="pjLbsBtnReserve_<?php echo $v['id'];?>" value="<?php __('front_btn_reserve');?>"<?php echo isset($STORE['fleet_id']) && isset($STORE['service_id']) ? ( $STORE['fleet_id'] == $v['id'] ? '' : ' disabled="disabled"') : ' disabled="disabled"';?> class="btn btn-primary btn-block pjLbsBtnReserve">
								</form>
							</div><!-- /.pjLbs-car-actions -->	
						</div><!-- /.col-md-3 -->
						<?php
					} 
					?>
				</div><!-- /.row -->
			</div><!-- /.pjLbs-car -->
			<?php
		}
	} 
	?>
</div><!-- /.pjLbs-body -->