DROP TABLE IF EXISTS `ncbs_reservations`;
CREATE TABLE IF NOT EXISTS `ncbs_reservations` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uuid` varchar(255) default NULL,
  `booth_id` int(10) unsigned DEFAULT NULL,
  `cnt` int(10) unsigned DEFAULT NULL,
  `date` date DEFAULT NULL,
  `subtotal` decimal(9,2) unsigned default NULL,
  `tax` decimal(9,2) unsigned default NULL,
  `total` decimal(9,2) unsigned default NULL,
  `deposit` decimal(9,2) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') default NULL,
  `status` enum('confirmed','cancelled','pending') default 'pending',
  `txn_id` varchar(255) default NULL,
  `processed_on` datetime default NULL,
  `created` datetime default NULL,
  `modified` datetime default NULL,
  `ip` varchar(255) default NULL,
  `c_title` varchar(255) default NULL,
  `c_name` varchar(255) default NULL,
  `c_phone` varchar(255) default NULL,
  `c_email` varchar(255) default NULL,
  `c_company` varchar(255) default NULL,
  `c_notes` text default NULL,
  `c_address` varchar(255) default NULL,
  `c_city` varchar(255) default NULL,
  `c_state` varchar(255) default NULL,
  `c_zip` varchar(255) default NULL,
  `c_country` int(10) unsigned default NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `booth_id` (`booth_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_reservations_extras`;
CREATE TABLE IF NOT EXISTS `ncbs_reservations_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reservation_id` int(10) unsigned DEFAULT NULL,
  `extra_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `cnt` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reservation_id` (`reservation_id`,`extra_id`,category_id)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_reservations_payments`;
CREATE TABLE IF NOT EXISTS `ncbs_reservations_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `reservation_id` int(10) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `reservation_id` (`reservation_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_booths`;
CREATE TABLE IF NOT EXISTS `ncbs_booths` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `capacity` int(10) DEFAULT NULL,
  `price` decimal(9,2) DEFAULT NULL,
  `count` int(10) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `thumb` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_prices`;
CREATE TABLE IF NOT EXISTS `ncbs_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booth_id` int(10) unsigned NOT NULL,
  `date` date DEFAULT NULL,
  `price` decimal(9,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `booth_id` (`booth_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_extras`;
CREATE TABLE IF NOT EXISTS `ncbs_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `price` decimal(9,2) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_categories_extras`;
CREATE TABLE IF NOT EXISTS `ncbs_categories_extras` (
  `category_id` int(10) unsigned NOT NULL,
  `extra_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`category_id`,`extra_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_categories`;
CREATE TABLE IF NOT EXISTS `ncbs_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_dates`;
CREATE TABLE IF NOT EXISTS `ncbs_dates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_fields`;
CREATE TABLE IF NOT EXISTS `ncbs_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_multi_lang`;
CREATE TABLE IF NOT EXISTS `ncbs_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_options`;
CREATE TABLE IF NOT EXISTS `ncbs_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_roles`;
CREATE TABLE IF NOT EXISTS `ncbs_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ncbs_users`;
CREATE TABLE IF NOT EXISTS `ncbs_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `ncbs_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'backend', 'backend', 'Backend titles', 'script', NULL),
(4, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(5, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(6, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(7, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(8, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(9, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(10, 'btnLogin', 'backend', 'Login', 'script', NULL),
(11, 'btnReset', 'backend', 'Reset', 'script', NULL),
(12, 'btnSave', 'backend', 'Save', 'script', NULL),
(13, 'btnSearch', 'backend', 'Search', 'script', NULL),
(14, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(15, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(16, 'created', 'backend', 'Created', 'script', NULL),
(17, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(18, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(19, 'email', 'backend', 'E-Mail', 'script', NULL),
(20, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(21, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(22, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(23, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(24, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(25, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(26, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(27, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(28, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(29, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(30, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(31, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(32, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(33, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(34, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(35, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(36, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(37, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(38, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(39, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(40, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(41, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(42, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(43, 'lblDays', 'backend', 'Days', 'script', NULL),
(44, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(45, 'lblError', 'backend', 'Error', 'script', NULL),
(46, 'lblExport', 'backend', 'Export', 'script', NULL),
(47, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(48, 'lblIp', 'backend', 'IP address', 'script', NULL),
(49, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(50, 'lblName', 'backend', 'Name', 'script', NULL),
(51, 'lblNo', 'backend', 'No', 'script', NULL),
(52, 'lblOption', 'backend', 'Option', 'script', NULL),
(53, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(54, 'lblRole', 'backend', 'Role', 'script', NULL),
(55, 'lblStatus', 'backend', 'Status', 'script', NULL),
(56, 'lblType', 'backend', 'Type', 'script', NULL),
(57, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(58, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(59, 'lblValue', 'backend', 'Value', 'script', NULL),
(60, 'lblYes', 'backend', 'Yes', 'script', NULL),
(61, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(62, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(63, 'locales', 'backend', 'Languages', 'script', NULL),
(64, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(65, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(66, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(67, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(68, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(69, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(70, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(71, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(72, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(73, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(74, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(75, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(76, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(77, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(78, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(79, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(80, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(81, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(82, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(83, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(84, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(85, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(86, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(87, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(88, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(89, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(90, 'pass', 'backend', 'Password', 'script', NULL),
(91, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(95, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(96, 'url', 'backend', 'URL', 'script', NULL),
(97, 'user', 'backend', 'Username', 'script', NULL),
(98, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(99, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(100, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(101, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(102, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(103, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(104, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(105, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(106, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(107, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(108, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(109, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(110, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(111, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(112, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(113, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(114, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(115, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(116, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(117, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(118, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(119, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(120, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(121, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(122, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(123, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(124, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(125, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(126, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(127, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(128, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(129, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(130, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(131, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(132, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(133, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(134, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(135, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(136, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(137, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(138, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(139, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(140, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(141, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(142, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(143, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(144, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(145, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(146, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(147, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(148, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(149, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(150, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(151, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(152, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(153, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(154, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(155, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(156, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(157, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(158, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(159, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(160, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(161, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(162, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(163, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(164, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(165, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(166, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(167, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(168, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(169, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(170, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(171, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(172, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(173, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(174, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(175, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(176, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(177, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(178, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(179, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(180, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(181, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(182, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(183, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(184, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(185, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(186, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(187, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(188, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(189, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(190, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(191, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(192, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(193, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(194, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(195, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(196, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(197, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(198, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(199, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(200, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(201, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(202, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(203, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(204, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(205, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(206, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(207, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(208, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(209, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(210, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(211, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(212, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(213, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(214, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(215, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(216, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(217, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(218, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(219, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(220, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(221, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(222, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(223, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(224, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(385, 'menuReservations', 'backend', 'Menu / Reservations', 'script', NULL),
(386, 'menuBooths', 'backend', 'Menu / Booths', 'script', NULL),
(387, 'menuExtras', 'backend', 'Menu / Extras', 'script', NULL),
(388, 'menuWorkingTime', 'backend', 'Menu / Working time', 'script', NULL),
(389, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(390, 'tabReservations', 'backend', 'Tab / Reservations', 'script', NULL),
(391, 'tabNotifications', 'backend', 'Tab / Notifications', 'script', NULL),
(392, 'tabReservationForm', 'backend', 'Tab / Reservation form', 'script', NULL),
(393, 'tabTerms', 'backend', 'Tab / Terms', 'script', NULL),
(394, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(395, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(396, 'infoReservationsTitle', 'backend', 'Infobox / Reservation options', 'script', NULL),
(397, 'infoReservationsDesc', 'backend', 'Infobox / Reservation options', 'script', NULL),
(398, 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', NULL),
(399, 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', NULL),
(400, 'enum_arr_ARRAY_Day', 'arrays', 'enum_arr_ARRAY_Day', 'script', NULL),
(401, 'enum_arr_ARRAY_Night', 'arrays', 'enum_arr_ARRAY_Night', 'script', NULL),
(402, 'enum_arr_ARRAY_24Hour', 'arrays', 'enum_arr_ARRAY_24Hour', 'script', NULL),
(403, 'enum_arr_ARRAY_confirmed', 'arrays', 'enum_arr_ARRAY_confirmed', 'script', NULL),
(404, 'enum_arr_ARRAY_pending', 'arrays', 'enum_arr_ARRAY_pending', 'script', NULL),
(405, 'enum_arr_ARRAY_cancelled', 'arrays', 'enum_arr_ARRAY_cancelled', 'script', NULL),
(406, 'enum_arr_ARRAY_Yes', 'arrays', 'enum_arr_ARRAY_Yes', 'script', NULL),
(407, 'enum_arr_ARRAY_No', 'arrays', 'enum_arr_ARRAY_No', 'script', NULL),
(408, 'enum_arr_ARRAY_0', 'arrays', 'enum_arr_ARRAY_0', 'script', NULL),
(409, 'enum_arr_ARRAY_1', 'arrays', 'enum_arr_ARRAY_1', 'script', NULL),
(410, 'enum_arr_ARRAY_2', 'arrays', 'enum_arr_ARRAY_2', 'script', NULL),
(411, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(412, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(413, 'opt_o_booking_status', 'backend', 'Options / All reservations which are only made but NOT paid will be set with the following status', 'script', NULL),
(414, 'opt_o_payment_status', 'backend', 'Options / All reservations which are made and paid will be set with the following status', 'script', NULL),
(415, 'opt_o_thankyou_page', 'backend', 'Options / URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script', NULL),
(416, 'opt_o_payment_disable', 'backend', 'Options / Select "Yes" if you want to disable payments and only collect reservation details ', 'script', NULL),
(417, 'opt_o_allow_paypal', 'backend', 'Options / Allow payments with PayPal', 'script', NULL),
(418, 'opt_o_paypal_address', 'backend', 'Options / PayPal business email address', 'script', NULL),
(419, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net ', 'script', NULL),
(420, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(421, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(422, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL),
(423, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL),
(424, 'opt_o_allow_cash', 'backend', 'Options / Allow cash payments', 'script', NULL),
(425, 'opt_o_allow_creditcard', 'backend', 'Options / Collect Credit Card details for offline processing', 'script', NULL),
(426, 'opt_o_allow_bank', 'backend', 'Options / Provide Bank account details for wire transfers', 'script', NULL),
(427, 'opt_o_bank_account', 'backend', 'Options / Bank Account', 'script', NULL),
(428, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(429, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(430, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(431, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(432, 'tabToCustomers', 'backend', 'Tab / To customers', 'script', NULL),
(433, 'tabToAdministrators', 'backend', 'Tab / To administrators', 'script', NULL),
(434, 'infoToCustomersTitle', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(435, 'infoToCustomersDesc', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(436, 'lblAvailableTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(437, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(438, 'opt_o_email_confirmation', 'backend', 'Options / New reservation received email', 'script', NULL),
(439, 'opt_o_email_confirmation_text', 'backend', 'Options / New reservation received email', 'script', NULL),
(440, 'opt_o_email_confirmation_subject', 'backend', 'Options / New reservation confirmation subject', 'script', NULL),
(441, 'opt_o_email_confirmation_message', 'backend', 'Options / New reservation confirmation message', 'script', NULL),
(442, 'opt_o_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(443, 'opt_o_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(444, 'opt_o_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(445, 'opt_o_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(446, 'opt_o_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(447, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(448, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(449, 'opt_o_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(450, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(451, 'opt_o_sms_confirmation_message', 'backend', 'Options / Reservation reminder SMS', 'script', NULL),
(452, 'opt_o_sms_payment_message', 'backend', 'Options / Payment reminder SMS', 'script', NULL),
(453, 'client_email_ARRAY_confirmation', 'arrays', 'client_email_arr_ARRAY_confirmation', 'script', NULL),
(454, 'client_email_ARRAY_payment', 'arrays', 'client_email_arr_ARRAY_payment', 'script', NULL),
(455, 'client_email_ARRAY_cancel', 'arrays', 'client_email_arr_ARRAY_cancel', 'script', NULL),
(456, 'lblNotifications', 'backend', 'Label / Notifications', 'script', NULL),
(457, 'client_sms_ARRAY_confirmation', 'arrays', 'client_sms_arr_ARRAY_confirmation', 'script', NULL),
(458, 'client_sms_ARRAY_payment', 'arrays', 'client_sms_arr_ARRAY_payment', 'script', NULL),
(459, 'infoToAdministratorsTitle', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(460, 'infoToAdministratorsDesc', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(461, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / New reservation confirmation message', 'script', NULL),
(462, 'opt_o_admin_email_payment_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(463, 'opt_o_admin_email_cancel_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(464, 'admin_sms_ARRAY_confirmation', 'arrays', 'admin_sms_arr_ARRAY_confirmation', 'script', NULL),
(465, 'admin_sms_ARRAY_payment', 'arrays', 'admin_sms_arr_ARRAY_payment', 'script', NULL),
(466, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / Reservation reminder SMS', 'script', NULL),
(467, 'opt_o_admin_sms_payment_message', 'backend', 'Options / Payment reminder SMS', 'script', NULL),
(468, 'infoReservationFormTitle', 'backend', 'Infobox / Reservation form', 'script', NULL),
(469, 'infoReservationFormDesc', 'backend', 'Infobox / Reservation form', 'script', NULL),
(470, 'opt_o_bf_include_title', 'backend', 'Options / Title', 'script', NULL),
(471, 'opt_o_bf_include_name', 'backend', 'Options / Name', 'script', NULL),
(472, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(473, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(474, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(475, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(476, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(477, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(478, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(479, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(480, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(481, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(482, 'infoTermsTitle', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(483, 'infoTermsDesc', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(484, 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL),
(485, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(486, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(487, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(488, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(489, 'tabDaysOff', 'backend', 'Tab / Days off', 'script', NULL),
(490, 'error_titles_ARRAY_AD01', 'arrays', 'error_titles_ARRAY_AD01', 'script', NULL),
(491, 'error_bodies_ARRAY_AD01', 'arrays', 'error_bodies_ARRAY_AD01', 'script', NULL),
(492, 'error_titles_ARRAY_AD03', 'arrays', 'error_titles_ARRAY_AD03', 'script', NULL),
(493, 'error_bodies_ARRAY_AD03', 'arrays', 'error_bodies_ARRAY_AD03', 'script', NULL),
(494, 'error_titles_ARRAY_AD04', 'arrays', 'error_titles_ARRAY_AD04', 'script', NULL),
(495, 'error_bodies_ARRAY_AD04', 'arrays', 'error_bodies_ARRAY_AD04', 'script', NULL),
(496, 'error_titles_ARRAY_AD08', 'arrays', 'error_titles_ARRAY_AD08', 'script', NULL),
(497, 'error_bodies_ARRAY_AD08', 'arrays', 'error_bodies_ARRAY_AD08', 'script', NULL),
(499, 'infoDatesTitle', 'backend', 'Infobox / Days off', 'script', NULL),
(500, 'infoDatesDesc', 'backend', 'Infobox / Days off', 'script', NULL),
(501, 'lblStartDate', 'backend', 'Label / Start date', 'script', NULL),
(502, 'lblEndDate', 'backend', 'Label / End date', 'script', NULL),
(503, 'infoAddDaysOffTitle', 'backend', 'Infobox / Add days off', 'script', NULL),
(504, 'infoAddDaysOffDesc', 'backend', 'Infobox / Add days off', 'script', NULL),
(505, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(506, 'infoUpdateDaysOffTitle', 'backend', 'Infobox / Update days off', 'script', NULL),
(507, 'infoUpdateDaysOffDesc', 'backend', 'Infobox / Update days off', 'script', NULL),
(508, 'tabExtras', 'backend', 'Tab / Extras', 'script', NULL),
(509, 'tabCategories', 'backend', 'Tab / Categories', 'script', NULL),
(510, 'infoCategoriesTitle', 'backend', 'Infobox / Categories List', 'script', NULL),
(511, 'infoCategoriesDesc', 'backend', 'Infobox / Categories List', 'script', NULL),
(512, 'btnAddCategory', 'backend', 'Button / + Add category', 'script', NULL),
(513, 'lblCategoryName', 'backend', 'Label / Category name', 'script', NULL),
(514, 'error_titles_ARRAY_ACT01', 'arrays', 'error_titles_ARRAY_ACT01', 'script', NULL),
(515, 'error_bodies_ARRAY_ACT01', 'arrays', 'error_bodies_ARRAY_ACT01', 'script', NULL),
(516, 'error_titles_ARRAY_ACT03', 'arrays', 'error_titles_ARRAY_ACT03', 'script', NULL),
(517, 'error_bodies_ARRAY_ACT03', 'arrays', 'error_bodies_ARRAY_ACT03', 'script', NULL),
(518, 'error_titles_ARRAY_ACT04', 'arrays', 'error_titles_ARRAY_ACT04', 'script', NULL),
(519, 'error_bodies_ARRAY_ACT04', 'arrays', 'error_bodies_ARRAY_ACT04', 'script', NULL),
(520, 'error_titles_ARRAY_ACT08', 'arrays', 'error_titles_ARRAY_ACT08', 'script', NULL),
(521, 'error_bodies_ARRAY_ACT08', 'arrays', 'error_bodies_ARRAY_ACT08', 'script', NULL),
(522, 'lblExtras', 'backend', 'Label / Extras', 'script', NULL),
(523, 'infoAddCategoryTitle', 'backend', 'Infobox / Add Category', 'script', NULL),
(524, 'infoAddCategoryDesc', 'backend', 'Infobox / Add Category', 'script', NULL),
(525, 'infoUpdateCategoryTitle', 'backend', 'Infobox/ Update Category', 'script', NULL),
(526, 'infoUpdateCategoryDesc', 'backend', 'Infobox/ Update Category', 'script', NULL),
(527, 'pj_same_category', 'backend', 'Label / Category name is already used.', 'script', NULL),
(528, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(529, 'gridEmptyBody', 'backend', 'Grid / No records selected', 'script', NULL),
(530, 'btnAddExtra', 'backend', 'Button / + Add extra', 'script', NULL),
(531, 'lblExtraTitle', 'backend', 'Label / Title', 'script', NULL),
(532, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(533, 'infoExtrasTitle', 'backend', 'Menu / Extras', 'script', NULL),
(534, 'infoExtrasDesc', 'backend', 'Infobox / Extras', 'script', NULL),
(535, 'infoAddExtraTitle', 'backend', 'Infobox / Add Extra', 'script', NULL),
(536, 'infoAddExtraDesc', 'backend', 'Infobox / Add Extra', 'script', NULL),
(537, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(538, 'lblCategory', 'backend', 'Label / Category', 'script', NULL),
(539, 'lblNoCategoriesMessage', 'backend', 'Label / No categories added.', 'script', NULL),
(540, 'pj_number_validation', 'backend', 'Label / Please enter a valid number.', 'script', NULL),
(541, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(542, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(543, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(544, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(545, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(546, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(547, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
(548, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(549, 'infoUpdateExtraTitle', 'backend', 'Infobox / Update Extra', 'script', NULL),
(550, 'infoUpdateExtraDesc', 'backend', 'Infobox / Update Extra', 'script', NULL),
(551, 'error_titles_ARRAY_ABT01', 'arrays', 'error_titles_ARRAY_ABT01', 'script', NULL),
(552, 'error_bodies_ARRAY_ABT01', 'arrays', 'error_bodies_ARRAY_ABT01', 'script', NULL),
(553, 'error_titles_ARRAY_ABT03', 'arrays', 'error_titles_ARRAY_ABT03', 'script', NULL),
(554, 'error_bodies_ARRAY_ABT03', 'arrays', 'error_bodies_ARRAY_ABT03', 'script', NULL),
(555, 'error_titles_ARRAY_ABT04', 'arrays', 'error_titles_ARRAY_ABT04', 'script', NULL),
(556, 'error_bodies_ARRAY_ABT04', 'arrays', 'error_bodies_ARRAY_ABT04', 'script', NULL),
(557, 'error_titles_ARRAY_ABT08', 'arrays', 'error_titles_ARRAY_ABT08', 'script', NULL),
(558, 'error_bodies_ARRAY_ABT08', 'arrays', 'error_bodies_ARRAY_ABT08', 'script', NULL),
(559, 'error_titles_ARRAY_ABT05', 'arrays', 'error_titles_ARRAY_ABT05', 'script', NULL),
(560, 'error_bodies_ARRAY_ABT05', 'arrays', 'error_bodies_ARRAY_ABT05', 'script', NULL),
(561, 'error_titles_ARRAY_ABT06', 'arrays', 'error_titles_ARRAY_ABT06', 'script', NULL),
(562, 'error_bodies_ARRAY_ABT06', 'arrays', 'error_bodies_ARRAY_ABT06', 'script', NULL),
(563, 'error_titles_ARRAY_ABT09', 'arrays', 'error_titles_ARRAY_ABT09', 'script', NULL),
(564, 'error_bodies_ARRAY_ABT09', 'arrays', 'error_bodies_ARRAY_ABT09', 'script', NULL),
(565, 'error_titles_ARRAY_ABT10', 'arrays', 'error_titles_ARRAY_ABT10', 'script', NULL),
(566, 'error_bodies_ARRAY_ABT10', 'arrays', 'error_bodies_ARRAY_ABT10', 'script', NULL),
(567, 'infoBoothsTitle', 'backend', 'Label / Booth types', 'script', NULL),
(568, 'infoBoothsDesc', 'backend', 'Infobox / Booth types', 'script', NULL),
(569, 'btnAddBoothType', 'backend', 'button / + Add booth type', 'script', NULL),
(570, 'lblThumb', 'backend', 'Label / Thumb', 'script', NULL),
(571, 'lblBoothType', 'backend', 'Label / Booth type', 'script', NULL),
(572, 'lblBoothCapacity', 'backend', 'Label / Booth capacity', 'script', NULL),
(573, 'lblBoothCount', 'backend', 'Label / Booth count', 'script', NULL),
(574, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(575, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(576, 'infoAddBoothTypeTitle', 'backend', 'Infobox / Add booth type', 'script', NULL),
(577, 'infoAddBoothTypeDesc', 'backend', 'Infobox / Add booth type', 'script', NULL),
(578, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(579, 'pj_digits_validation', 'backend', 'Label / Please enter only digits.', 'script', NULL),
(580, 'tabDetails', 'backend', 'Tab / Details', 'script', NULL),
(581, 'tabCustomPrice', 'backend', 'Tab / Custom price', 'script', NULL),
(582, 'lblDeleteImage', 'backend', 'Label / Delete image', 'script', NULL),
(583, 'lblDeleteImageConfirm', 'backend', 'Label / Delete image', 'script', NULL),
(584, 'infoBoothTypeDetailsTitle', 'backend', 'Infobox / Booth type details', 'script', NULL),
(585, 'infoBoothTypeDetailsDesc', 'backend', 'Infobox / Booth type details', 'script', NULL),
(586, 'infoCustomPriceTitle', 'backend', 'Infobox / Custom price', 'script', NULL),
(587, 'infoCustomPriceDesc', 'backend', 'Infobox / Custom price', 'script', NULL),
(588, 'lblDate', 'backend', 'Label / Date', 'script', NULL),
(589, 'infoInstallCodeTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(590, 'infoInstallCodeDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(591, 'infoPreviewTitle', 'backend', 'Infobox / Preview front end', 'script', NULL),
(592, 'infoPreviewDesc', 'backend', 'Infobox / Preview front end', 'script', NULL),
(593, 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(594, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(595, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(596, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(597, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(598, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(599, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(600, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(601, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(602, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(603, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(604, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(605, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(606, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(607, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', NULL),
(608, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', NULL),
(609, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(610, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(611, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(612, 'role_arr_ARRAY_1', 'arrays', 'role_arr_ARRAY_1', 'script', NULL),
(613, 'role_arr_ARRAY_2', 'arrays', 'role_arr_ARRAY_2', 'script', NULL),
(614, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(615, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(617, 'btnAddReservation', 'backend', 'Button / + Add reservation', 'script', NULL),
(618, 'reservation_statuses_ARRAY_confirmed', 'arrays', 'reservation_statuses_ARRAY_confirmed', 'script', NULL),
(619, 'reservation_statuses_ARRAY_pending', 'arrays', 'reservation_statuses_ARRAY_pending', 'script', NULL),
(620, 'reservation_statuses_ARRAY_cancelled', 'arrays', 'reservation_statuses_ARRAY_cancelled', 'script', NULL),
(621, 'infoReservationsListTitle', 'backend', 'Infobox / List of reservations', 'script', NULL),
(622, 'infoReservationsListDesc', 'backend', 'Infobox / List of reservations', 'script', NULL),
(623, 'tabReservationDetails', 'backend', 'Tab / Reservation Details', 'script', NULL),
(624, 'tabClientDetails', 'backend', 'Tab / Client Details', 'script', NULL),
(625, 'infoReservationDetailsTitle', 'backend', 'Infobox / Reservation details', 'script', NULL),
(626, 'infoReservationDetailsDesc', 'backend', 'Infobox / Reservation details', 'script', NULL),
(627, 'infoClientDetailsTitle', 'backend', 'Infobox / Client details', 'script', NULL),
(628, 'infoClientDetailsDesc', 'backend', 'Infobox / Client details', 'script', NULL),
(629, 'legendDateAndBooth', 'backend', 'Legend / Date & booth', 'script', NULL),
(630, 'legendPaymentsOtherDetails', 'backend', 'Legend / Payments and other details', 'script', NULL),
(631, 'legendExtras', 'backend', 'Legend / Extras', 'script', NULL),
(632, 'lblExtra', 'backend', 'Label / Extra', 'script', NULL),
(633, 'lblQty', 'backend', 'Label / Qty', 'script', NULL),
(634, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(635, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(636, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(637, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(638, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(639, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(640, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(641, 'lblCCType', 'backend', 'Label / CC type', 'script', NULL),
(642, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(643, 'lblCCExp', 'backend', 'Label / CC expiration date', 'script', NULL),
(644, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(645, 'lblSubTotal', 'backend', 'Label / Sub-total', 'script', NULL),
(646, 'lblTax', 'backend', 'Label / Tax', 'script', NULL),
(647, 'lblDeposit', 'backend', 'Label / Deposit', 'script', NULL),
(648, 'btnCalculateTotal', 'backend', 'Button / Calculate Total', 'script', NULL),
(649, 'lblResvTitle', 'backend', 'Label / Title', 'script', NULL),
(650, 'lblResvName', 'backend', 'Label / Name', 'script', NULL),
(651, 'lblResvEmail', 'backend', 'Label / Email', 'script', NULL),
(652, 'lblResvPhone', 'backend', 'Label / Phone', 'script', NULL),
(653, 'lblResvNotes', 'backend', 'Label / Notes', 'script', NULL),
(654, 'lblResvCompany', 'backend', 'Label / Company', 'script', NULL),
(655, 'lblResvAddress', 'backend', 'Label / Address', 'script', NULL),
(656, 'lblResvCity', 'backend', 'Label / City', 'script', NULL),
(657, 'lblResvState', 'backend', 'Label / State', 'script', NULL),
(658, 'lblResvZip', 'backend', 'Label / Zip', 'script', NULL),
(659, 'lblResvCountry', 'backend', 'Label / Country', 'script', NULL),
(660, 'lblCount', 'backend', 'Label / Count', 'script', NULL),
(661, 'lblCapacity', 'backend', 'Label / Capacity', 'script', NULL),
(662, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(663, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(664, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(665, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(666, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(667, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(668, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(669, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(670, 'pj_dayoff_validation', 'backend', 'Label / The club is closed on this date.', 'script', NULL),
(671, 'pj_email_validation', 'backend', 'Label / Please enter a valid email address.', 'script', NULL),
(672, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(673, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(674, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(675, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(676, 'front_menu_date_booth', 'frontend', 'Menu / Date and booth', 'script', NULL),
(677, 'front_menu_your_booth', 'frontend', 'Menu / Your booth', 'script', NULL),
(678, 'front_menu_drinks', 'frontend', 'Menu / 3. Drinks', 'script', NULL),
(679, 'front_menu_checkout', 'frontend', 'Menu / 4. Checkout', 'script', NULL),
(680, 'front_menu_confirmation', 'frontend', 'Menu / 5. Confirmation', 'script', NULL),
(681, 'front_date', 'frontend', 'Label / Date', 'script', NULL),
(682, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(683, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(684, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(685, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(686, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(687, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(688, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(689, 'front_club_closed', 'frontend', 'Label / The club is closed on the selected date.', 'script', NULL),
(690, 'front_no_booths_found', 'frontend', 'Label / No booths found.', 'script', NULL),
(691, 'front_available_booths', 'frontend', 'Label / Available Booths', 'script', NULL),
(692, 'front_per_person', 'frontend', 'Label / per person', 'script', NULL),
(693, 'front_based_on', 'frontend', 'Label / Based on', 'script', NULL),
(694, 'front_people', 'frontend', 'Label / people', 'script', NULL),
(695, 'front_person', 'frontend', 'Label / person', 'script', NULL),
(696, 'front_total_booth_cost', 'frontend', 'Label / Total booth cost', 'script', NULL),
(697, 'front_btn_select_booth', 'frontend', 'Button / Select Booth', 'script', NULL),
(699, 'front_booth', 'frontend', 'Label / Booth', 'script', NULL),
(700, 'front_booth_capacity', 'frontend', 'Label / Booth capacity', 'script', NULL),
(701, 'front_booth_info', 'frontend', 'Label / Booth information', 'script', NULL),
(702, 'front_price', 'frontend', 'Label / Price', 'script', NULL),
(703, 'front_btn_next', 'frontend', 'Button / Next &gt;', 'script', NULL),
(704, 'front_btn_na', 'frontend', 'Button / N/A', 'script', NULL),
(705, 'front_number', 'frontend', 'Button / Number', 'script', NULL),
(706, 'error_titles_ARRAY_AE09', 'arrays', 'error_titles_ARRAY_AE09', 'script', NULL),
(707, 'error_bodies_ARRAY_AE09', 'arrays', 'error_bodies_ARRAY_AE09', 'script', NULL),
(708, 'error_titles_ARRAY_AE10', 'arrays', 'error_titles_ARRAY_AE10', 'script', NULL),
(709, 'error_bodies_ARRAY_AE10', 'arrays', 'error_bodies_ARRAY_AE10', 'script', NULL),
(710, 'front_booking_details', 'frontend', 'Label / Reservation Details', 'script', NULL),
(711, 'front_booth_type', 'frontend', 'Label / Booth type', 'script', NULL),
(712, 'front_extra_price', 'frontend', 'Label / Extra price', 'script', NULL),
(713, 'front_subtotal', 'frontend', 'Label / Sub-total', 'script', NULL),
(714, 'front_tax', 'frontend', 'Label / Tax', 'script', NULL),
(715, 'front_total', 'frontend', 'Label / Total', 'script', NULL),
(716, 'front_deposit', 'frontend', 'Label / Deposit', 'script', NULL),
(717, 'front_your_details', 'frontend', 'Label / Your Details', 'script', NULL),
(718, 'front_title', 'frontend', 'Label / Title', 'script', NULL),
(719, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(720, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(721, 'front_company', 'frontend', 'Label / Company', 'script', NULL),
(722, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(723, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(724, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(725, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(726, 'front_zip', 'frontend', 'Label / Zip', 'script', NULL),
(727, 'front_notes', 'frontend', 'Label / Notes', 'script', NULL),
(728, 'front_payment_method', 'frontend', 'Label / Payment method', 'script', NULL),
(729, 'front_bank_account', 'frontend', 'Label / Bank account', 'script', NULL),
(730, 'front_cc_type', 'frontend', 'Label / CC type', 'script', NULL),
(731, 'front_cc_num', 'frontend', 'Label / CC number', 'script', NULL),
(732, 'front_cc_code', 'frontend', 'Label / CC code', 'script', NULL),
(733, 'front_cc_exp', 'frontend', 'Label / CC expiration', 'script', NULL),
(734, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(735, 'front_agree_with_terms', 'frontend', 'Label / I agrees with terms and conditions', 'script', NULL),
(736, 'front_terms_title', 'frontend', 'Label / Terms and conditions', 'script', NULL),
(737, 'front_btn_close', 'frontend', 'Button / Close', 'script', NULL),
(738, 'front_incorrect_captcha', 'frontend', 'Label / Captcha is not correct.', 'script', NULL),
(739, 'front_btn_continue', 'backend', 'Button / Continue', 'script', NULL),
(740, 'front_btn_cancel', 'backend', 'Button / Cancel', 'script', NULL),
(741, 'front_choose', 'backend', 'Button / Choose', 'script', NULL),
(742, 'front_email', 'backend', 'Button / Email', 'script', NULL),
(743, 'front_booking_statuses_ARRAY_1', 'arrays', 'front_booking_statuses_ARRAY_1', 'script', NULL),
(744, 'front_booking_statuses_ARRAY_0', 'arrays', 'front_booking_statuses_ARRAY_0', 'script', NULL),
(745, 'front_btn_start_over', 'frontend', 'Label / Start over', 'script', NULL),
(746, 'front_reservation_completed', 'frontend', 'Label / Reservation completed', 'script', NULL),
(747, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(748, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(749, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(750, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(751, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(752, 'front_cancel_booking_id', 'frontend', 'label / Reservation ID', 'script', NULL),
(753, 'front_label_txn_id', 'frontend', 'label / Transaction ID', 'script', NULL),
(754, 'front_processed_on', 'frontend', 'label / Processed on', 'script', NULL),
(755, 'front_btn_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(916, 'dash_reservations_made', 'backend', 'Dash / new reservations made today', 'script', NULL),
(917, 'dash_reservation_made', 'backend', 'Dash / new reservation made today', 'script', NULL),
(918, 'dash_today_reservations', 'backend', 'Dash / today''s reservations', 'script', NULL),
(919, 'dash_today_reservation', 'backend', 'Dash / today''s reservation', 'script', NULL),
(920, 'dash_count_reservations', 'backend', 'Dash / reservations', 'script', NULL),
(921, 'dash_count_reservation', 'backend', 'Dash / reservation', 'script', NULL),
(922, 'dash_latest_reservations', 'backend', 'Dashboard / Latest reservations', 'script', NULL),
(923, 'dash_heading_today_reservations', 'backend', 'Dashboard / Today''s reservations', 'script', NULL),
(924, 'dash_loyal_clients', 'backend', 'Dash / Loyal clients', 'script', NULL),
(925, 'dash_no_reservations_found', 'backend', 'Dash / No reservations found.', 'script', NULL),
(926, 'dash_reservations', 'backend', 'Dashboard / reservations', 'script', NULL),
(927, 'dash_reservation', 'backend', 'Dashboard / reservation', 'script', NULL),
(928, 'menuInstallPreview', 'backend', 'Menu / Install & Preview', 'script', NULL),
(929, 'infoPreviewInstallTitle', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(930, 'infoPreviewInstallDesc', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(931, 'lblInstallCode', 'backend', 'Label / Install code', 'script', NULL),
(932, 'dash_print', 'backend', 'Dash / Print', 'script', NULL),
(933, 'lblBooths', 'backend', 'Label / Booth(s)', 'script', NULL),
(934, 'lblTotalDeposit', 'backend', 'Labe / Total / Deposit', 'script', NULL),
(935, 'menuMassEmail', 'backend', 'Menu / Mass Email', 'script', NULL),
(936, 'infoMassEmailTitle', 'backend', 'Infobox / Mass Email', 'script', NULL),
(937, 'infoMassEmailDesc', 'backend', 'Infobox / Mass Email', 'script', NULL),
(938, 'lblSendTo', 'backend', 'Send to', 'script', NULL),
(939, 'lblClientsConfirmed', 'backend', 'Label / All clients with Confirmed reservations', 'script', NULL),
(940, 'lblClientsPending', 'backend', 'Label / All clients with Pending reservations', 'script', NULL),
(941, 'lblClientsCancelled', 'backend', 'Label / All clients with Cancelled reservations', 'script', NULL),
(942, 'lblAdministrator', 'backend', 'Label / Administrator', 'script', NULL),
(943, 'lblTotalClients', 'backend', 'Label / Total clients', 'script', NULL),
(944, 'lblValueGreaterThan0', 'backend', 'Label / Total clients must be greater than 0.', 'script', NULL),
(945, 'lblEmailSubject', 'backend', 'Label / Email subject', 'script', NULL),
(946, 'lblEmailMessage', 'backend', 'Label / Email message', 'script', NULL),
(947, 'error_titles_ARRAY_AM01', 'arrays', 'error_titles_ARRAY_AM01', 'script', NULL),
(948, 'error_bodies_ARRAY_AM01', 'arrays', 'error_bodies_ARRAY_AM01', 'script', NULL),
(949, 'front_btn_back', 'frontend', 'Button / &lt; Back', 'script', NULL),
(950, 'lblIpAddress', 'backend', 'Label / IP address', 'script', NULL),
(951, 'lblDateTimeMade', 'backend', 'Label / Date/time made', 'script', NULL),
(952, 'front_booths', 'frontend', 'Label / booths', 'script', NULL),
(953, 'front_for', 'frontend', 'Label / for', 'script', NULL),
(954, 'error_titles_ARRAY_AM02', 'arrays', 'error_titles_ARRAY_AM02', 'script', NULL),
(955, 'error_bodies_ARRAY_AM02', 'arrays', 'error_bodies_ARRAY_AM02', 'script', NULL),
(956, 'front_menu2_checkout', 'frontend', 'Menu / 3. Checkout', 'script', NULL),
(957, 'front_menu2_confirmation', 'frontend', 'Menu / 4. Confirmation', 'script', NULL);

INSERT INTO `ncbs_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 1, 'title', '+ Add days off', 'script'),
(NULL, 5, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 6, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 36, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'All the changes made to General Options have been saved.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Booths', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Working time', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Reservation form', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Configure the general settings for your Night Club Booking Software.', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Reservation options', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Here you can choose your payment methods, set payment gateway accounts and preferences.', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'PHP mail()', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'SMTP', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Night', 'script'),
(NULL, 402, 'pjField', 1, 'title', '24 Hour', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Yes (required)', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'All reservations which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'All reservations which are made and paid will be set with the following status', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.Net payment', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Select "Yes" if you want to disable payments and only collect reservation details ', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'PayPal business email address', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Allow payments with Authorize.Net', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Authorize.Net transaction key', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Authorize.Net merchant ID', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Authorize.Net time zone', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Authorize.Net MD5 hash', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Allow cash payments', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Reservation options updated!', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'All changes made to the Reservation options have been saved successfully.', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'To customers', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'To administrators', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Notifications sent to customers', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Below you can create different types of auto-responders triggered by different events, such as new reservation, new payment received, and cancellation. Please, note that if you wish to activate the SMS notification feature, you need to request a valid API Key and enter it in the designated SMS menu (see above).', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Use the tokens below to personalize your email messages. <br/><br/><label>{Date}</label><label>{Booths}</label><label>{Extras}</label><label>{UniqueID}</label><label>{Deposit}</label><label>{Total}</label><label>{Tax}</label><label>{PaymentMethod}</label><label>{CCType}</label><label>{CCNum}</label><label>{CCExp}</label><label>{CCSec}</label><label>{Title}</label><label>{Name}</label><label>{Email}</label><label>{Phone}</label><label>{Country}</label><label>{City}</label><label>{State}</label><label>{Zip}</label><label>{Address}</label><label>{Company}</label><label>{CancelURL}</label>', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'New reservation received email', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to let your customers know that you received their reservations. ', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'New reservation confirmation subject', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'New reservation confirmation message', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for receiving their payment.', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Payment confirmation subject', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Payment confirmation message', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Cancel confirmation message', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for cancelling their reservations.', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Reservation reminder SMS', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Payment reminder SMS', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'New reservation received email', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Reservation reminder SMS', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Payment reminder SMS', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Notifications sent to script administrators', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Set the automated email notifications sent to script admins. Please, note that if you wish to activate the SMS notification feature, you need to request a valid API Key and enter it in the designated SMS menu (see above).', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new reservation made. ', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new payment made. ', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a reservation cancelled. ', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Reservation reminder SMS', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Payment reminder SMS', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Reservation reminder SMS', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Payment reminder SMS', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Reservation form', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the reservation form, otherwise select ''No''.', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Terms & Conditions', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Enter your booking Terms and Conditions and click “Save”.', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Reservation form updated!', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'All changes made to reservation form have been saved successfully.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Terms and conditions updated', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'All changes made to Terms and Conditions have been saved successfully.', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Days off', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Days off updated!', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'The period of days off has been updated.', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Days off added!', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'The period of days off has been added.', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Days off not added!', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'The period of days off could not be added. Please try again.', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Days off not found!', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'The period of days off you are looking for is missing.', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Days off', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Add days off using the button below, and show them on the front-end.', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'Start date', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'End date', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Select days off', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Use the fields below to choose Start and End dates.', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Update days off', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Use the form below to change the start date and end date and click "Save" button to update the period of days off.', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Category list', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Extras are organized in categories. Below is a list of all categories that have been added to the system. You can add a new category or edit one by clicking on the pencil icon in each row.', 'script'),
(NULL, 512, 'pjField', 1, 'title', '+ Add category', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Category name', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Category updated!', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Category added', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'New category has been added into the system.', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Category failed to add', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'The category could not be added successfully. Please try again.', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Category not found', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'The category you are looking for is missing.', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'Add new category', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Use the form below to add a new category to the system.', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'Update Category', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'You can make any change on the form below and click "Save" button to update category information.', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Category name is already used.', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 530, 'pjField', 1, 'title', '+ Add extra', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'Booth price', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'List of extras', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Below is a list of all extras. Extra is an additional supplement to booths which can be added to the reservation as per client preference. You can add a new extra, edit extras details, show and hide extras etc.', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Add new extra', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Use the form below to add a new extra. Change the status in order to show or hide this extra.', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'No categories added. Click {STAG}here{ETAG} to add.', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Please enter a valid number.', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Extra updated!', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'All changes made to the extra have been saved.', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Extra added!', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'New extra has been added into the system.', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Extra failed to add!', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'The extra could not bee added successfully. Please try again.', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Extra not found', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'The extra you are looking for is missing.', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Update Extra', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'If you need to make any change to this extra, edit the details below and “Save”.', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Booth updated!', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'All changes to the booth have been saved.', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Booth added!', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'New booth has been added to the system.', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Booth failed to add!', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'The booth could not be added successfully. Please try again.', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Booth not found!', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'The booth you are looking for is missing.', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'New booth could not be added because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'The booth could not be updated successfully because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'New booth has been added, but image could not be uploaded successfully.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'The booth has been updated, but image could not be uploaded successfully.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Booth types', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Below is a list of all booths. You can add a new booth type, edit booth details, change status etc.', 'script'),
(NULL, 569, 'pjField', 1, 'title', '+ Add booth type', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Thumb', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Booth type', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Booth capacity', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Booth count', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Add booth type', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Please, fill in the form below and “save” to add a new booth type.', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Please enter only digits', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Custom price', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Booth type details', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'You can see below the booth type detail. You can make any changes on this form and click "Save" button to update booth type information.', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Custom price', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'You can set custom price for each booth type for different dates if needed.', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Please copy the install code below and put it on your web page.', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Preview front end', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use.', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Choose color theme', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 606, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Below is a list of all users. You can add new users, edit user details and change user status. ', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Fill in the form below and "save" to add a new user.', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Editor', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update the user information.', 'script'),
(NULL, 617, 'pjField', 1, 'title', '+ Add reservation', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'List of reservations', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Review a list of all reservations. Using the quick buttons below, you can manually add a new reservation, change its status, edit reservation details, browse and delete reservations. ', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Reservation Details', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Client Details', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Reservation details', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Select the date and booth type that you want to reserve. You can also choose extras (alcoholic drinks, beverages etc.), change reservation status and set payment terms.', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Please, fill in the client information before saving the reservation.', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Date & booth', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Payments and other details', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Extra', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Qty', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'Authorize.Net', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Wire transfer', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Calculate Total', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Count', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Capacity', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Reservation updated!', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'All changes made to the reservation have been updated.', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Reservation added!', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'New reservation has been added into the system.', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Reservation not added!', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'We are sorry that new reservation could not be added successfully. Please try again.', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Reservation not found!', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'We are sorry that reservation you are looking for is missing.', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'The club is closed on this date.', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 676, 'pjField', 1, 'title', '1. Date and Booth', 'script'),
(NULL, 677, 'pjField', 1, 'title', '2. Your Booth', 'script'),
(NULL, 678, 'pjField', 1, 'title', '3. Drinks & Extras', 'script'),
(NULL, 679, 'pjField', 1, 'title', '4. Checkout', 'script'),
(NULL, 680, 'pjField', 1, 'title', '5. Confirmation', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'The club is closed on the selected date.', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'No booths found.', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Available Booths', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'per person', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'Based on', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'people', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'person', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Total booth cost', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'Select Booth', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Booth', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Capacity', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'Booth information', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'Next &gt;', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'N/A', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Booth(s)', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'New extra has been added, but image could not be uploaded successfully.', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'Upload error!', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'The extra has been updated, but image could not be uploaded successfully.', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'Reservation Details', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'Booth type', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'Extra price', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'Your Details', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'I agree with {STAG}terms of reservation{ETAG}', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'Terms and conditions', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'Thank you! Your reservation has been made. Please click on the "Start over" button to make new reservation.', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'Start over', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'Reservation completed', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'The reservation has been cancelled successfully.', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'Reservation with such ID does not exist.', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'Reservation is already cancelled.', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'Reservation ID', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'Transaction ID', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 916, 'pjField', 1, 'title', 'Latest reservations', 'script'),
(NULL, 917, 'pjField', 1, 'title', 'Latest reservations', 'script'),
(NULL, 918, 'pjField', 1, 'title', 'Today''s reservations', 'script'),
(NULL, 919, 'pjField', 1, 'title', 'today''s reservation', 'script'),
(NULL, 920, 'pjField', 1, 'title', 'Total reservations', 'script'),
(NULL, 921, 'pjField', 1, 'title', 'reservation', 'script'),
(NULL, 922, 'pjField', 1, 'title', 'Latest reservations', 'script'),
(NULL, 923, 'pjField', 1, 'title', 'Today''s reservations', 'script'),
(NULL, 924, 'pjField', 1, 'title', 'Regular clients', 'script'),
(NULL, 925, 'pjField', 1, 'title', 'No reservations found.', 'script'),
(NULL, 926, 'pjField', 1, 'title', 'reservations', 'script'),
(NULL, 927, 'pjField', 1, 'title', 'reservation', 'script'),
(NULL, 928, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 929, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 930, 'pjField', 1, 'title', 'There are multiple color schemes available for the front-end. Click on each of the thumbnails below to preview themes. Press "Use this theme" button to enable it. Then scroll down and copy/paste the Install code on your web page.', 'script'),
(NULL, 931, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 932, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 933, 'pjField', 1, 'title', 'Booth(s)', 'script'),
(NULL, 934, 'pjField', 1, 'title', 'Total / Deposit', 'script'),
(NULL, 935, 'pjField', 1, 'title', 'Mass Email', 'script'),
(NULL, 936, 'pjField', 1, 'title', 'Mass Email', 'script'),
(NULL, 937, 'pjField', 1, 'title', 'Use the text editor below and the two predefined {tokens} to personalize your email to people who have previously made reservations. ', 'script'),
(NULL, 938, 'pjField', 1, 'title', 'Send to', 'script'),
(NULL, 939, 'pjField', 1, 'title', 'All clients with Confirmed reservations', 'script'),
(NULL, 940, 'pjField', 1, 'title', 'All clients with Pending reservations', 'script'),
(NULL, 941, 'pjField', 1, 'title', 'All clients with Cancelled reservations', 'script'),
(NULL, 942, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 943, 'pjField', 1, 'title', 'Total clients', 'script'),
(NULL, 944, 'pjField', 1, 'title', 'Total clients must be greater than 0.', 'script'),
(NULL, 945, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 946, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 947, 'pjField', 1, 'title', 'Email sent!', 'script'),
(NULL, 948, 'pjField', 1, 'title', 'The email has been sent successfully to all clients.', 'script'),
(NULL, 949, 'pjField', 1, 'title', '&lt; Back', 'script'),
(NULL, 950, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 951, 'pjField', 1, 'title', 'Date/time made', 'script'),
(NULL, 952, 'pjField', 1, 'title', 'booths', 'script'),
(NULL, 953, 'pjField', 1, 'title', 'for', 'script'),
(NULL, 954, 'pjField', 1, 'title', 'Email not sent!', 'script'),
(NULL, 955, 'pjField', 1, 'title', 'The email could not be sent because there are no clients'' emails selected.', 'script'),
(NULL, 956, 'pjField', 1, 'title', '3. Checkout', 'script'),
(NULL, 957, 'pjField', 1, 'title', '4. Confirmation', 'script'),
(NULL, 1, 'pjOption', 1, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed non convallis sapien, non pulvinar sem. Aenean interdum aliquam vehicula. In aliquet sollicitudin orci vitae commodo. Cras gravida, tellus eget tempus faucibus, tellus enim commodo risus, sed pulvinar dolor lorem ac est. Integer quis pellentesque nulla, vitae placerat eros. Quisque id sem non ante pulvinar consectetur. Vivamus et venenatis ex. Nam tellus ipsum, fermentum non sapien quis, efficitur euismod mauris. Morbi et felis sapien. Fusce est felis, semper non ante id, feugiat accumsan leo. Nulla laoreet tincidunt tellus eu dignissim. Nam a leo ut augue dignissim ultrices quis vel libero. Duis tempor turpis quam, vel scelerisque sem feugiat ut. Pellentesque velit ex, commodo a facilisis tincidunt, porttitor nec elit. Proin elit arcu, iaculis eget aliquet eu, fringilla sed sem. Suspendisse malesuada aliquam est, a blandit tellus eleifend at.\r\n\r\nDonec mi sem, ultrices quis sagittis quis, venenatis at nibh. Pellentesque porta sem eget nibh sodales, eget dictum metus tempor. Vivamus ullamcorper sit amet arcu ut finibus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Quisque ac pulvinar urna. Etiam mattis, est id egestas bibendum, libero dui bibendum orci, vitae pharetra eros augue a nunc. Nam in diam id nunc tristique faucibus elementum nec magna. Mauris a ipsum vel quam tristique blandit suscipit placerat risus. Vestibulum dictum massa dui, vel ullamcorper nunc varius quis. Nullam vitae nisl ultricies, tempor massa at, viverra erat.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', 'New Reservation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', '<p>Dear&nbsp;{Name},</p>\r\n<p>your reservation has been received.</p>\r\n<p>&nbsp;</p>\r\n<p>ID:&nbsp;{UniqueID}</p>\r\n<p>Date: {Date}</p>\r\n<p>Booth(s): {Booths}</p>\r\n<p>&nbsp;</p>\r\n<p>THANK YOU!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', '<p>Dear&nbsp;{Name},</p>\r\n<p>we''ve received the payment for your reservation.</p>\r\n<p>&nbsp;</p>\r\n<p>ID:&nbsp;{UniqueID}</p>\r\n<p>Date: {Date}</p>\r\n<p>Booth(s): {Booths}</p>\r\n<p>&nbsp;</p>\r\n<p>THANK YOU!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', 'Reservation Cancelled', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', '<p>Dear&nbsp;{Name},</p>\r\n<p>your reservation has been cancelled.</p>\r\n<p>&nbsp;</p>\r\n<p>ID:&nbsp;{UniqueID}</p>\r\n<p>Date: {Date}</p>\r\n<p>Booth(s): {Booths}</p>\r\n<p>&nbsp;</p>\r\n<p>THANK YOU!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', 'New reservation ID: {UniqueID}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_payment_message', 'Payment reminder for reservation ID: {UniqueID}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', 'New Reservation received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', '<p>New reservation has been received.</p>\r\n<p>&nbsp;</p>\r\n<p>ID:&nbsp;{UniqueID}</p>\r\n<p>Date: {Date}</p>\r\n<p>Booth(s): {Booths}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', 'New payment received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', '<p>New payment&nbsp;has been received.</p>\r\n<p>&nbsp;</p>\r\n<p>ID:&nbsp;{UniqueID}</p>\r\n<p>Date: {Date}</p>\r\n<p>Booth(s): {Booths}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', 'Reservation cancelled', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', '<p>Reservation has been cancelled.</p>\r\n<p>&nbsp;</p>\r\n<p>ID:&nbsp;{UniqueID}</p>\r\n<p>Date: {Date}</p>\r\n<p>Booth(s): {Booths}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_payment_message', NULL, 'data');

INSERT INTO `ncbs_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_layout', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 13, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_deposit_payment', 2, '10', NULL, 'int', 2, 1, NULL),
(1, 'o_tax_payment', 2, '10.00', NULL, 'int', 4, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_thankyou_page', 2, 'https://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 9, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 20, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 7, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 9, 1, NULL),

(1, 'o_admin_email_confirmation', 4, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 4, '', NULL, 'string', 8, 1, NULL),
(1, 'o_admin_email_confirmation_message', 4, '', NULL, 'text', 9, 1, NULL),
(1, 'o_admin_email_payment', 4, '0|1::1', 'No|Yes', 'enum', 10, 1, NULL),
(1, 'o_admin_email_payment_subject', 4, '', NULL, 'string', 11, 1, NULL),
(1, 'o_admin_email_payment_message', 4, '', NULL, 'text', 12, 1, NULL),
(1, 'o_admin_email_cancel', 4, '0|1::1', 'No|Yes',  'enum', 13, 1, NULL),
(1, 'o_admin_email_cancel_subject', 4, '', NULL, 'string', 14, 1, NULL),
(1, 'o_admin_email_cancel_message', 4, '', NULL, 'text', 15, 1, NULL),

(1, 'o_sms_confirmation_message', 5, '', NULL, 'text', 2, 1, NULL),
(1, 'o_sms_payment_message', 5, '', NULL, 'text', 3, 1, NULL),

(1, 'o_admin_sms_confirmation_message', 6, '', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_sms_payment_message', 6, '', NULL, 'text', 5, 1, NULL),

(1, 'o_bf_include_title', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_name', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_email', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_company', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_address', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_country', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_state', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_city', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
(1, 'o_bf_include_zip', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_notes', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_captcha', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 15, 1, NULL),

(1, 'o_terms', 8, '', NULL, 'text', 1, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `ncbs_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');