<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat reservations">
				<div class="info">
					<abbr><?php echo $tpl['cnt_resevations_made_today'];?></abbr>
					<label><?php echo $tpl['cnt_resevations_made_today'] != 1 ? __('dash_reservations_made') : __('dash_reservation_made');?></label>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat reservations">
				<div class="info">
					<abbr><?php echo $tpl['cnt_resevations_today'];?></abbr>
					<label><?php echo $tpl['cnt_resevations_today'] != 1 ? __('dash_today_reservations') : __('dash_today_reservation');?></label>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat reservations">
				<div class="info">
					<abbr><?php echo $tpl['cnt_resevations'];?></abbr>
					<label><?php echo $tpl['cnt_resevations'] != 1 ? __('dash_count_reservations') : __('dash_count_reservation');?></label>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('dash_latest_reservations');?></div>
			<div class="dashboard_column_top"><?php __('dash_heading_today_reservations');?> (<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminReservations&amp;action=pjActionPrint" target="_blank"><?php __('dash_print');?></a>)</div>
			<div class="dashboard_column_top"><?php __('dash_loyal_clients');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['latest_arr']) > 0)
					{
						foreach($tpl['latest_arr'] as $v)
						{
							?>
							<div class="dashboard_row">
								<?php
								if($controller->isAdmin())
								{ 
									?>
									<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBooths&amp;action=pjActionUpdate&amp;id=<?php echo $v['booth_id'];?>"><?php echo pjSanitize::html($v['type']);?></a> x <?php echo $v['cnt'];?></label>
									<?php
								}else{
									?>
									<label><?php echo pjSanitize::html($v['type']);?> x <?php echo $v['cnt'];?></label>
									<?php
								} 
								?>
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminReservations&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['c_name']);?></a></label>
								<?php
								if(!empty($v['c_email']))
								{
									?><label><?php echo pjSanitize::html($v['c_email']);?></label><?php
								} 
								?>
								<label><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['date']));?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_reservations_found');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['today_arr']) > 0)
					{
						foreach($tpl['today_arr'] as $v)
						{
							?>
							<div class="dashboard_row">
								<?php
								if($controller->isAdmin())
								{ 
									?>
									<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBooths&amp;action=pjActionUpdate&amp;id=<?php echo $v['booth_id'];?>"><?php echo pjSanitize::html($v['type']);?></a> x <?php echo $v['cnt'];?></label>
									<?php
								}else{
									?>
									<label><?php echo pjSanitize::html($v['type']);?> x <?php echo $v['cnt'];?></label>
									<?php
								} 
								?>
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminReservations&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['c_name']);?></a></label>
								<?php
								if(!empty($v['c_email']))
								{
									?><label><?php echo pjSanitize::html($v['c_email']);?></label><?php
								} 
								?>
								<label><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['date']));?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_reservations_found');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['loyal_arr']) > 0)
					{
						foreach($tpl['loyal_arr'] as $v)
						{
							?>
							<div class="dashboard_row">
								<label><?php echo $v['cnt_reservations'];?> <?php $v['cnt_reservations'] != 1 ? __('dash_reservations') : __('dash_reservation');?></label>
								<label><?php echo pjSanitize::html($v['c_name']);?></label>
								<?php
								if(!empty($v['c_email']))
								{
									?><label><?php echo pjSanitize::html($v['c_email']);?></label><?php
								}
								if(!empty($v['c_phone']))
								{
									?><label><?php echo pjSanitize::html($v['c_phone']);?></label><?php
								} 
								?>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_reservations_found');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $other) = explode("_", date("H:i_l_F d, Y"));
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format'], time()); ?></div>
		</div>
	</div>
	<?php
}
?>