<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	
	?>
	<div id="tabs">
		<ul>
			<li><a href="#tabs-1"><?php __('tabDetails'); ?></a></li>
			<li><a href="#tabs-2"><?php __('tabCustomPrice'); ?></a></li>
		</ul>
		<div id="tabs-1">
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBooths&amp;action=pjActionUpdate" method="post" id="frmUpdateBooth" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
				<input type="hidden" name="booth_update" value="1" />
				<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
				<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
				<?php $locale = isset($_GET['locale']) && (int) $_GET['locale'] > 0 ? (int) $_GET['locale'] : $controller->getLocaleId(); ?>
				<input type="hidden" name="locale" value="<?php echo $locale; ?>" />
				
				<?php pjUtil::printNotice(__('infoBoothTypeDetailsTitle', true, false), __('infoBoothTypeDetailsDesc', true, false)); ?>
	
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang"></div>
				<?php endif; ?>
				
				<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblBoothType'); ?></label>
							<span class="inline_block">
								<input type="text" id="i18n_type_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][type]" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['type'])); ?>"/>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title"><?php __('lblBoothCapacity', false, true); ?></label>
						<input type="text" name="capacity" id="capacity" value="<?php echo pjSanitize::html($tpl['arr']['capacity']);?>" class="pj-form-field field-int required digits w80" data-msg-digits="<?php __('pj_digits_validation');?>"/>
					</p>
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
					?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblDescription'); ?></label>
							<span class="inline_block">
								<textarea id="i18n_description_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][description]" class="pj-form-field w500 h150<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['description'])); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title"><?php __('lblPrice'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" id="price" name="price" class="pj-form-field number w108 required" value="<?php echo pjSanitize::html($tpl['arr']['price']);?>" data-msg-number="<?php __('pj_number_validation');?>"/>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblBoothCount', false, true); ?></label>
						<input type="text" name="count" id="count" value="<?php echo pjSanitize::html($tpl['arr']['count']);?>" class="pj-form-field field-int required digits w80" data-msg-digits="<?php __('pj_digits_validation');?>"/>
					</p>
					<p>
						<label class="title"><?php __('lblImage', false, true); ?></label>
						<span class="inline_block">
							<input type="file" name="image" id="image" class="pj-form-field w400"/>
						</span>
					</p>
					<?php
					if(!empty($tpl['arr']['thumb']))
					{
						$image_url = PJ_INSTALL_URL . $tpl['arr']['thumb'];
						?>
						<p id="image_container">
							<label class="title">&nbsp;</label>
							<span class="inline_block">
								<img class="ncbs-image" src="<?php echo $image_url; ?>" />
								<a href="javascript:void(0);" class="pj-delete-image" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBooths&amp;action=pjActionDeleteImage&id=<?php echo $tpl['arr']['id'];?>"><?php __('btnDelete');?></a>
							</span>
						</p>
						<?php
					} 
					?>
					<p>
						<label class="title"><?php __('lblStatus'); ?></label>
						<span class="inline_block">
							<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('pj_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach (__('u_statarr', true) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : null;?>><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<p>
						<label class="title">&nbsp;</label>
						<span class="inline_block">
							<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
							<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBooths&action=pjActionIndex';" />
						</span>
					</p>
				</div>
			</form>
		</div><!-- #tabs-1 -->
		
		<div id="tabs-2">
			<?php 
			pjUtil::printNotice(__('infoCustomPriceTitle', true, false), __('infoCustomPriceDesc', true, false));

			$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
			$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
			?>
			
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBooths&amp;action=pjActionPrice" method="post" id="frmCustomPrice" class="form pj-form" autocomplete="off">
				<input type="hidden" name="id" value=""/>
				<input type="hidden" name="booth_id" value="<?php echo $tpl['arr']['id'];?>"/>
				
				<p>
					<label class="title"><?php __('lblDate'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" id="custom_date" name="date" class="pj-form-field pointer w100 required datepicker" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>"/>
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblPrice'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" id="custom_price" name="price" class="pj-form-field number w108 required" data-msg-number="<?php __('pj_number_validation');?>"/>
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<input type="submit" name="save" value="<?php __('btnSave'); ?>" class="pj-button" />
					</span>
				</p>
			</form>
			
			<div id="pjNcBPriceContainer">
				<div id="price_grid"></div>
			</div>
		</div><!-- #tabs-2 -->
	</div>
	
	<div id="dialogDeleteImage" style="display: none" title="<?php __('lblDeleteImage');?>"><?php __('lblDeleteImageConfirm');?></div>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.field_required = "<?php __('pj_field_required'); ?>";
	myLabel.date = "<?php __('lblDate'); ?>";
	myLabel.price = "<?php __('lblPrice'); ?>";
	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
	var pjGrid = pjGrid || {};
	pjGrid.queryString = "";
	pjGrid.queryString += "&booth_id=<?php echo (int) $tpl['arr']['id']; ?>";
	var pjLocale = pjLocale || {};
	var locale_array = new Array(); 
	pjLocale.langs = <?php echo $tpl['locale_str']; ?>;
	pjLocale.flagPath = "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/";
	<?php
	foreach ($tpl['lp_arr'] as $v)
	{
		?>locale_array.push(<?php echo $v['id'];?>);<?php
	} 
	?>
	myLabel.locale_array = locale_array;
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: pjLocale.langs,
				flagPath: pjLocale.flagPath,
				select: function (event, ui) {
					
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
		$tab_id = explode("-", $_GET['tab_id']);
		$tab_id = (int) $tab_id[1] - 1;
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "active", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>