<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	
	$date = date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['date']));
	
	$text_capacity = null;
	$text_price = null;
	$cnt = 0;
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminReservations&amp;action=pjActionUpdate" method="post" class="form pj-form" id="frmUpdateReservation">
		<input type="hidden" name="reservation_update" value="1"/>
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>"/>
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('tabReservationDetails');?></a></li>
				<li><a href="#tabs-2"><?php __('tabClientDetails');?></a></li>
			</ul>
			<div id="tabs-1">
				<?php pjUtil::printNotice(__('infoReservationDetailsTitle', true, false), __('infoReservationDetailsDesc', true, false)); ?>
				<fieldset class="fieldset white">
					<legend><?php __('legendDateAndBooth'); ?></legend>
					<div class="float_left w50p overflow">
						<p>
							<label class="title"><?php __('lblIpAddress'); ?></label>
							<span class="inline_block t5">
								<span id="textCapacity"><?php echo $tpl['arr']['ip'];?></span>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblDateTimeMade'); ?></label>
							<span class="inline_block t5">
								<span id="textPrice"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created']));?></span>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblDate'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-after">
								<input type="text" name="date" id="date" class="pj-form-field pointer w100 datepicker" value="<?php echo $date;?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>"/>
								<input type="hidden" name="validate_date" value="<?php echo mt_rand(0, 999999);?>" class="required" data-msg-required="<?php __('pj_field_required');?>" data-msg-remote="<?php __('pj_dayoff_validation');?>"/>
								<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
							</span>
						</p>
						<p id="boxBoothType">
							<label class="title"><?php __('lblBoothType'); ?></label>
							<span class="inline_block">
								<select name="booth_id" id="booth_id" class="pj-form-field w150 required" data-msg-required="<?php __('pj_field_required');?>">
									<option value="">-- <?php __('lblChoose'); ?> --</option>
									<?php
									if(isset($tpl['booth_arr']))
									{
										foreach($tpl['booth_arr'] as $k => $v)
										{
											if((int) $v['count'] > (int) $v['cnt_booked'])
											{
												$cnt = (int) $v['count'] - (int) $v['cnt_booked'];
												$price = $v['price'];
												if(!empty($v['custom_price']))
												{
													$price = $v['custom_price'];
												}
												if($v['id'] == $tpl['arr']['booth_id'])
												{
													$text_capacity = $v['capacity'];
													$text_price = pjUtil::formatCurrencySign($price, $tpl['option_arr']['o_currency']);
													?><option value="<?php echo $v['id'];?>" selected="selected" data-cnt="<?php echo $cnt;?>" data-capacity="<?php echo $v['capacity'];?>" data-price="<?php echo $price;?>" data-price_format="<?php echo pjUtil::formatCurrencySign($price, $tpl['option_arr']['o_currency']);?>"><?php echo pjSanitize::html($v['type']); ?></option><?php
												}else{
													?><option value="<?php echo $v['id'];?>" data-cnt="<?php echo $cnt;?>" data-capacity="<?php echo $v['capacity'];?>" data-price="<?php echo $price;?>" data-price_format="<?php echo pjUtil::formatCurrencySign($price, $tpl['option_arr']['o_currency']);?>"><?php echo pjSanitize::html($v['type']); ?></option><?php
												}
											}
										}
									} 
									?>
								</select>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblCapacity'); ?></label>
							<span class="inline_block t5">
								<span id="textCapacity"><?php echo $text_capacity;?></span>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblPrice'); ?></label>
							<span class="inline_block t5">
								<span id="textPrice"><?php echo $text_price;?></span>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblCount'); ?></label>
							<span class="inline_block">
								<select name="cnt" id="cnt" class="pj-form-field w120 required" data-msg-required="<?php __('pj_field_required');?>">
									<option value="">-- <?php __('lblChoose'); ?> --</option>
									<?php
									for($i = 1; $i <= $cnt; $i++)
									{
										?><option value="<?php echo $i;?>"<?php echo $i == $tpl['arr']['cnt'] ? ' selected="selected"' : NULL;?>><?php echo $i;?></option><?php
									} 
									?>
								</select>
							</span>
						</p>
						<p>
							<label class="title">&nbsp;</label>
							<span class="inline_block">
								<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
								<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminReservations&action=pjActionIndex';" />
							</span>
						</p>
					</div>
					<div class="float_left w50p overflow">
						<p>
							<label class="title"><?php __('lblStatus'); ?></label>
							<span class="inline_block">
								<select name="status" id="status" class="pj-form-field w150 required" data-msg-required="<?php __('pj_field_required');?>">
									<option value="">-- <?php __('lblChoose'); ?> --</option>
									<?php
									foreach (__('reservation_statuses', true) as $k => $v)
									{
										?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL;?>><?php echo stripslashes($v); ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblPaymentMethod');?></label>
							<span class="inline-block">
								<select name="payment_method" id="payment_method" class="pj-form-field w150 required" data-msg-required="<?php __('pj_field_required');?>">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach (__('payment_methods', true, false) as $k => $v)
									{
										?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['payment_method'] ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<?php $isCC = $tpl['arr']['payment_method'] == 'creditcard'; ?>
						<p class="boxCC" style="display: <?php echo !$isCC ? 'none' : NULL; ?>;">
							<label class="title"><?php __('lblCCType'); ?></label>
							<span class="inline-block">
								<select name="cc_type" class="pj-form-field w150" data-msg-required="<?php __('pj_field_required');?>">
									<option value="">---</option>
									<?php
									foreach (__('cc_types', true, false) as $k => $v)
									{
										?><option value="<?php echo $k; ?>"<?php echo $tpl['arr']['cc_type'] == $k ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<p class="boxCC" style="display: <?php echo !$isCC ? 'none' : NULL; ?>;">
							<label class="title"><?php __('lblCCNum'); ?></label>
							<span class="inline-block">
								<input type="text" name="cc_num" id="cc_num" class="pj-form-field w136" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['cc_num'])); ?>" data-msg-required="<?php __('pj_field_required');?>"/>
							</span>
						</p>
						<p class="boxCC" style="display: <?php echo !$isCC ? 'none' : NULL; ?>;">
							<label class="title"><?php __('lblCCExp'); ?></label>
							<span class="inline-block">
								<select name="cc_exp_month" class="pj-form-field" data-msg-required="<?php __('pj_field_required');?>">
									<?php
									$month_arr = __('months', true, false);
									ksort($month_arr);
									foreach ($month_arr as $key => $val)
									{
										?><option value="<?php echo $key;?>"<?php echo $tpl['arr']['cc_exp_month'] == $key ? ' selected="selected"' : NULL;?>><?php echo $val;?></option><?php
									}
									?>
								</select>
								<select name="cc_exp_year" class="pj-form-field" data-msg-required="<?php __('pj_field_required');?>">
									<?php
									$y = (int) date('Y');
									for ($i = $y; $i <= $y + 10; $i++)
									{
										?><option value="<?php echo $i; ?>" <?php echo $tpl['arr']['cc_exp_year'] == $i ? ' selected="selected"' : NULL;?>><?php echo $i; ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<p class="boxCC" style="display: <?php echo !$isCC ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblCCCode'); ?></label>
							<span class="inline-block">
								<input type="text" name="cc_code" id="cc_code" class="pj-form-field w100" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['cc_code'])); ?>" data-msg-required="<?php __('pj_field_required');?>"/>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblSubTotal'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" id="subtotal" name="subtotal" class="pj-form-field number w80" value="<?php echo $tpl['arr']['subtotal']; ?>" readonly="readonly"/>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblTax'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" id="tax" name="tax" class="pj-form-field number w80" value="<?php echo $tpl['arr']['tax']; ?>" data-tax="<?php echo $tpl['option_arr']['o_tax_payment'];?>" readonly="readonly"/>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblTotal'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" id="total" name="total" class="pj-form-field number w80" value="<?php echo $tpl['arr']['total']; ?>" readonly="readonly"/>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblDeposit'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" id="deposit" name="deposit" class="pj-form-field number w80" value="<?php echo $tpl['arr']['deposit']; ?>" data-deposit="<?php echo $tpl['option_arr']['o_deposit_payment'];?>" readonly="readonly"/>
							</span>
						</p>
					</div>
				</fieldset>
				<fieldset class="fieldset white">
					<legend><?php __('legendExtras'); ?></legend>
					
					<table class="fdOrderList" id="fdOrderList">
						<thead>
							<tr class="fdLine">
								<th width="275" class="splitter"><?php __('lblCategory');?></th>
								<th width="220" class="fdPL5"><?php __('lblExtra');?></th>
								<th width="70"><?php __('lblQty');?></th>
								<th width="30" class="splitter">&nbsp;</th>
								<th width="80" class="fdPL5 splitter"><?php __('lblTotal');?></th>
								<th width="30">&nbsp;</th>
							</tr>
						</thead>
						<tbody class="main-body">
							<?php
							if(count($tpl['reserved_extra_arr']) > 0)
							{
								foreach($tpl['reserved_extra_arr'] as $category_id => $_extra_arr)
								{
									$index = "new_" . mt_rand(0, 999999);
									?>
									<tr class="fdLine" data-index="<?php echo $index;?>">
										<td width="220" class="splitter">
											<select id="fdProduct_<?php echo $index;?>" data-index="<?php echo $index;?>" name="category_id[<?php echo $index;?>]" class="pj-form-field fdProduct w250">
												<option value="">-- <?php __('lblChoose'); ?>--</option>
												<?php
												foreach ($tpl['category_arr'] as $category)
												{
													?><option value="<?php echo $category['id']; ?>"<?php echo $category['id']==$category_id ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($category['name']); ?></option><?php
												}
												?>
											</select>
										</td>
										<td  width="220" colspan="3" class="splitter fdPL5">
											<div class="business-<?php echo $index;?>">
												<table id="fdExtraTable_<?php echo $index;?>" class="pj-extra-table" cellpadding="0" cellspacing="0" style="width: auto">							
													<tbody>
														<?php
														foreach($_extra_arr as $k => $extra)
														{
															mt_srand();
															$x_index = 'x_' . mt_rand();
															?>
															<tr>
																<td width="220">
																	<select name="extra_id[<?php echo $index; ?>][<?php echo $x_index; ?>]" data-index="<?php echo $index; ?>_<?php echo $x_index; ?>" class="fdExtra fdExtra_<?php echo $index; ?> pj-form-field w200">
																		<option value="">-- <?php __('lblChoose'); ?>--</option>
																		<?php
																		if (isset($tpl['extra_arr']) && count($tpl['extra_arr']) > 0)
																		{
																			if (isset($tpl['extra_arr'][$category_id]) && count($tpl['extra_arr'][$category_id]) > 0)
																			{
																				foreach ($tpl['extra_arr'][$category_id] as $e)
																				{
																					?><option value="<?php echo $e['extra_id']; ?>"<?php echo $e['extra_id'] == $extra['extra_id'] ? ' selected="selected"' : NULL; ?> data-price="<?php echo $e['price'];?>"><?php echo stripslashes($e['title']); ?>: <?php echo pjUtil::formatCurrencySign($e['price'], $tpl['option_arr']['o_currency'])?></option><?php
																				}
																			}
																		}
																		?>
																	</select>
																</td>
																<td class="w70"><input type="text" id="fdExtraQty_<?php echo $index; ?>_<?php echo $x_index; ?>" name="extra_cnt[<?php echo $index; ?>][<?php echo $x_index; ?>]" class="pj-form-field w50 float_left pj-field-count" value="<?php echo $extra['cnt'];?>" /></td>
																<td class="w30"><a href="#" class="pj-remove-extra"></a></td>
															</tr>
															<?php
														} 
														?>
													</tbody>
												</table>
												<input type="button" value="<?php __('btnAddExtra');?>" data-index="<?php echo $index;?>" class="pj-button float_left pj-add-extra fdExtraBusiness_<?php echo $index;?> fdExtraButton_<?php echo $index;?>" />
											</div>
										</td>
										<td width="80" class="fdPL5 splitter">
											<span id="fdTotalPrice_<?php echo $index;?>" class="fdPriceLabel"><?php echo pjUtil::formatCurrencySign(number_format(0, 2), $tpl['option_arr']['o_currency']);?></span>
										</td>
										<td width="30" class="fdPL5">
											<a href="#" class="pj-remove-extra"></a>
										</td>
									</tr>
									<?php
								}
							}else{
								$index = "new_" . mt_rand(0, 999999);
								?>
								<tr class="fdLine" data-index="<?php echo $index;?>">
									<td width="220" class="splitter">
										<select id="fdProduct_<?php echo $index;?>" data-index="<?php echo $index;?>" name="category_id[<?php echo $index;?>]" class="pj-form-field fdProduct w250">
											<option value="">-- <?php __('lblChoose'); ?>--</option>
											<?php
											foreach ($tpl['category_arr'] as $category)
											{
												?><option value="<?php echo $category['id']; ?>"><?php echo stripslashes($category['name']); ?></option><?php
											}
											?>
										</select>
									</td>
									<td  width="220" colspan="3" class="splitter fdPL5">
										<div class="business-<?php echo $index;?>" style="display: none;">
											<table id="fdExtraTable_<?php echo $index;?>" class="pj-extra-table" cellpadding="0" cellspacing="0" style="width: auto">							
												<tbody>
												</tbody>
											</table>
											<input type="button" value="<?php __('btnAddExtra');?>" data-index="<?php echo $index;?>" class="pj-button float_left pj-add-extra fdExtraBusiness_<?php echo $index;?> fdExtraButton_<?php echo $index;?>" />
										</div>
									</td>
									<td width="80" class="fdPL5 splitter">
										<span id="fdTotalPrice_<?php echo $index;?>" class="fdPriceLabel"><?php echo pjUtil::formatCurrencySign(number_format(0, 2), $tpl['option_arr']['o_currency']);?></span>
									</td>
									<td width="30">
										&nbsp;
									</td>
								</tr>
								<?php
							} 
							?>
						</tbody>
					</table>
					
					<div class="overflow">
						<input type="button" id="btnAddProduct" value="<?php __('btnAddCategory');?>" class="pj-button" />
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					</div>
				</fieldset>
							
			</div><!-- #tabs-1 -->
			<div id="tabs-2">
				<?php pjUtil::printNotice(__('infoClientDetailsTitle', true, false), __('infoClientDetailsDesc', true, false)); ?>
				
				<?php
				if (in_array((int) $tpl['option_arr']['o_bf_include_title'], array(2,3)))
				{
					?>
					<p>
						<label class="title"><?php __('lblResvTitle'); ?></label>
						<span class="inline-block">
							<select name="c_title" id="c_title" class="pj-form-field w150<?php echo $tpl['option_arr']['o_bf_include_title'] == 3 ? ' required' : NULL; ?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ( __('personal_titles', true, false) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['c_title'] ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_name'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvName'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_name" id="c_name" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_name'])); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_name'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_email'], array(2,3)))
				{
					?>
					<p>
						<label class="title"><?php __('lblResvEmail'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_email" id="c_email" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_email'])); ?>" class="pj-form-field email w400<?php echo $tpl['option_arr']['o_bf_include_email'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>" data-msg-email="<?php __('pj_email_validation');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_phone'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvPhone'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_phone" id="c_phone" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_phone'])); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_phone'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_notes'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvNotes'); ?></label>
						<span class="inline-block">
							<textarea name="c_notes" id="c_notes" class="pj-form-field w500 h120<?php echo $tpl['option_arr']['o_bf_include_notes'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"><?php echo htmlspecialchars(stripslashes($tpl['arr']['c_notes'])); ?></textarea>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_company'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvCompany'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_company" id="c_company" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_company'])); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_company'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_address'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvAddress'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_address" id="c_address" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_address'])); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_address'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_city'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvCity'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_city" id="c_city" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_city'])); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_city'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_state'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvState'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_state" id="c_state" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_state'])); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_state'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_zip'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvZip'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_zip" id="c_zip" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_zip'])); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_zip'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_country'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvCountry'); ?></label>
						<span class="inline-block">
							<select name="c_country" id="c_country" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_country'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ($tpl['country_arr'] as $v)
								{
									?><option value="<?php echo $v['id']; ?>"<?php echo $v['id'] == $tpl['arr']['c_country'] ? ' selected="selected"' : NULL;?>><?php echo stripslashes($v['country_title']); ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<?php
				}
				?>
				
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBookings&action=pjActionIndex';" />
				</p>
			</div><!-- #tabs-2 -->
		</div>
		
	</form>
	
	<table style="display: none" id="boxProductClone">
		<tbody>
		<?php
		include PJ_VIEWS_PATH . 'pjAdminReservations/elements/clone.php'; 
		?>
		</tbody>
	</table>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.currency = "<?php echo $tpl['option_arr']['o_currency'];?>";
	myLabel.choose = "-- <?php echo __('lblChoose', true);?> --";
	</script>
	<?php
}
?>