<?php
include_once dirname(__FILE__) . '/elements/header.php';

$STORE = $_SESSION[$controller->defaultStore]; 
?>
<div class="pjNcb-booths pjNcb-booth-detail">
	<h2><?php echo pjSanitize::html($tpl['arr']['type']);?></h2>
</div>
<div class="row pjNcb-yourbooth">
	<div class="col-sm-8">
		<div class="pjNcb-yourbooth-content">
			<ul>
				<li>
					<span><?php __('front_date');?>:</span>

					<p><strong><?php echo date($tpl['option_arr']['o_date_format'], strtotime($STORE['date_iso']));?></strong></p>
				</li>

				<li>
					<span><?php __('front_booth_capacity');?>:</span>

					<p><strong><?php echo pjSanitize::html($tpl['arr']['capacity']);?> <?php $tpl['arr']['capacity'] != 1 ? __('front_people') : __('front_person');?></strong></p>
				</li>
				<?php
				$price = $tpl['arr']['price'];
				if(!empty($tpl['arr']['custom_price']))
				{
					$price = $tpl['arr']['custom_price'];
				}
				$cnt = (int) $tpl['arr']['count'] - (int) $tpl['arr']['cnt_booked'];
				if($cnt > 0)
				{
					?>
					<li>
						<span><?php __('front_number');?>:</span>
	
						<p>
							<select id="pjNcbCnt_<?php echo $_GET['index'];?>" name="cnt" class="form-control" data-price="<?php echo $price;?>">
								<?php
								for($i = 1; $i <= $cnt; $i++)
								{
									$option_text = $i . ' ' . ($i == 1 ? mb_strtolower(__('front_booth', true), 'UTF-8') : __('front_booths', true)) . ' ' . __('front_for', true) . ' ' . ($tpl['arr']['capacity'] * $i) . ' ' . __('front_people', true);
									if(isset($STORE['cnt']) && $STORE['cnt'] == $i)
									{
										$price = $price * $i;
										?><option value="<?php echo $i;?>" selected="selected"><?php echo $option_text;?></option><?php
									}else{
										?><option value="<?php echo $i;?>"><?php echo $option_text;?></option><?php
									}
								} 
								?>
							</select>
						</p>
					</li>
					<?php
				} 
				?>
				<li>
					<span><?php __('front_booth_info');?>:</span>

					<p><?php echo nl2br(stripslashes($tpl['arr']['description']));?></p>
				</li>
				<li class="price-row">
					<span><?php __('front_price');?>:</span>

					<p id="pjNcbPrice_<?php echo $_GET['index'];?>" class="pjNcb-price"><?php echo pjUtil::formatCurrencySign(number_format($price, 2), $tpl['option_arr']['o_currency']);?></p>
				</li>

				<li>
					<span class="btn-holder"><button type="button" class="btn btn-default pjNcbBtnBack pjNcbMenuItem" data-item="loadSearch"><?php __('front_btn_back');?></button></span>
					<p class="btn-holder"><a href="#" class="btn btn-primary pjNcbMenuItem" data-item="loadExtras"><?php __('front_btn_next');?></a></p>
				</li>
			</ul>
		</div><!-- /.pjNcb-yourbooth-content -->
	</div><!-- /.col-sm-8 -->

	<div class="col-sm-4">
		<div class="pjNcb-yourbooth-images">
			<?php
			if(!empty($tpl['arr']['image']) && file_exists(PJ_INSTALL_PATH . $tpl['arr']['image']))
			{
				?><img src="<?php echo PJ_INSTALL_URL . $tpl['arr']['image'];?>" alt=""><?php
			} 
			?>
		</div><!-- /.pjNcb-yourbooth-images -->				
	</div><!-- /.col-md-4 -->

	
</div><!-- /.pjNcb-yourbooth -->