<?php
include_once dirname(__FILE__) . '/elements/header.php';

$STORE = @$_SESSION[$controller->defaultStore];
$FORM = @$_SESSION[$controller->defaultForm];
?>
<div class="pjNcb-details">
	<div class="pjNcb-booking-details">
		<h2><?php __('front_booking_details');?></h2>

		<div class="pjNcb-booking-detail">
			<div class="row">
				<div class="col-sm-3">
					<p><span><?php __('front_date');?></span></p>
				</div><!-- /.col-sm-3 -->

				<div class="col-sm-4">
					<p><strong><?php echo date($tpl['option_arr']['o_date_format'], strtotime($STORE['date_iso']));?></strong></p>
				</div><!-- /.col-sm-3 -->
			</div><!-- /.row -->
		</div><!-- /.pjNcb-booking-detail -->
		<?php
		$unit_price = $tpl['arr']['price'];
		if(!empty($tpl['arr']['custom_price']))
		{
			$unit_price = $tpl['arr']['custom_price'];
		}
		?>
		<div class="pjNcb-booking-detail">
			<div class="row">
				<div class="col-sm-3">
					<p><span><?php __('front_booth_type');?></span></p>
				</div><!-- /.col-sm-3 -->

				<div class="col-sm-4">
					<p><strong><?php echo pjSanitize::html($tpl['arr']['type']);?></strong></p>
				</div><!-- /.col-sm-3 -->
				<div class="col-sm-2">
					<p class="text-center"><?php echo $STORE['cnt'];?></p>
				</div><!-- /.col-sm-2 -->
				<div class="col-sm-1">
					<p>x</p>
				</div><!-- /.col-sm-1 -->
				<div class="col-sm-2">
					<p><strong><?php echo pjUtil::formatCurrencySign(number_format($unit_price, 2), $tpl['option_arr']['o_currency']);?></strong></p>
				</div><!-- /.col-sm-2 -->
			</div><!-- /.row -->
		</div><!-- /.pjNcb-booking-detail -->
		
		<?php
		if(isset($STORE['extras']) && count($STORE['extras']) > 0)
		{ 
			$trace_id = 0;
			foreach($STORE['extras'] as $cid => $extra_arr)
			{
				if(isset($tpl['category_arr'][$cid]))
				{
					?>
					<div class="pjNcb-booking-detail">
						<?php
						foreach($extra_arr as $eid => $extra)
						{
							if(isset($tpl['extra_arr'][$eid]) && $extra['cnt'] > 0)
							{
								?>
								<div class="row<?php echo $trace_id == $cid ? ' rowspan' : NULL; ?>">
									<div class="col-sm-3">
										<?php
										if($trace_id != $cid)
										{ 
											?>
											<p><span><?php echo pjSanitize::html($tpl['category_arr'][$cid]);?></span></p>
											<?php
											$trace_id = $cid;
										}else{
											?>
											<p><span>&nbsp;</span></p>
											<?php
										} 
										?>
									</div><!-- /.col-sm-3 -->
					
									<div class="col-sm-4">
										<p><strong><?php echo pjSanitize::html($tpl['extra_arr'][$eid]);?></strong></p>
									</div><!-- /.col-sm-3 -->
					
									<div class="col-sm-2">
										<div class="btn-group pjNcb-spinner" role="group" aria-label="...">
					            			<button type="button" class="btn pjNcbSpinner pjNcb-spinner-down" data-id="<?php echo $eid;?>" data-cid="<?php echo $cid;?>">-</button>
					
											<input type="text" class="pjNcb-spinner-result" maxlength="3" value="<?php echo $extra['cnt'];?>">
					
											<button type="button" class="btn pjNcbSpinner pjNcb-spinner-up" data-id="<?php echo $eid;?>" data-cid="<?php echo $cid;?>">+</button>
										</div>
									</div><!-- /.col-sm-3 -->
									<div class="col-sm-1">
										<p>x</p>
									</div><!-- /.col-sm-1 -->
									<div class="col-sm-2">
										<p><strong><?php echo pjUtil::formatCurrencySign(number_format($extra['price'], 2), $tpl['option_arr']['o_currency']);?></strong></p>
									</div><!-- /.col-sm-3 -->
					
								</div><!-- /.row -->
								<?php
							}
						}
						?>
					</div><!-- /.pjNcb-booking-detail -->
					<?php
				}
			}
		} 
		?>

		<div class="pjNcb-booking-detail">
			<div class="row">
				<div class="col-sm-3">
					<p><span><?php __('front_subtotal');?></span></p>
				</div><!-- /.col-sm-3 -->

				<div class="col-sm-4">
					<p><strong><?php echo pjUtil::formatCurrencySign(number_format($tpl['prices']['subtotal'], 2), $tpl['option_arr']['o_currency']);?></strong></p>
				</div><!-- /.col-sm-3 -->
			</div><!-- /.row -->
		</div><!-- /.pjNcb-booking-detail -->

		<div class="pjNcb-booking-detail">
			<div class="row">
				<div class="col-sm-3">
					<p><span><?php __('front_tax');?> (<?php echo number_format($tpl['option_arr']['o_tax_payment'], 2)?>%)</span></p>
				</div><!-- /.col-sm-3 -->

				<div class="col-sm-4">
					<p><strong><?php echo pjUtil::formatCurrencySign(number_format($tpl['prices']['tax'], 2), $tpl['option_arr']['o_currency']);?></strong></p>
				</div><!-- /.col-sm-3 -->
			</div><!-- /.row -->
		</div><!-- /.pjNcb-booking-detail -->
		<div class="pjNcb-booking-detail">
			<div class="row">
				<div class="col-sm-3">
					<p><span><?php __('front_total');?></span></p>
				</div><!-- /.col-sm-3 -->

				<div class="col-sm-4">
					<p><strong><?php echo pjUtil::formatCurrencySign(number_format($tpl['prices']['total'], 2), $tpl['option_arr']['o_currency']);?></strong></p>
				</div><!-- /.col-sm-3 -->
			</div><!-- /.row -->
		</div><!-- /.pjNcb-booking-detail -->
		<div class="pjNcb-booking-detail">
			<div class="row">
				<div class="col-sm-3">
					<p><span><?php __('front_deposit');?>  (<?php echo number_format($tpl['option_arr']['o_deposit_payment'],2);?>%)</span></p>
				</div><!-- /.col-sm-3 -->

				<div class="col-sm-4">
					<p><strong><?php echo pjUtil::formatCurrencySign(number_format($tpl['prices']['deposit'], 2), $tpl['option_arr']['o_currency']);?></strong></p>
				</div><!-- /.col-sm-3 -->
			</div><!-- /.row -->
		</div><!-- /.pjNcb-booking-detail -->
	</div><!-- /.pjNcb-booking-details -->
	
	<div class="pjNcb-form">
		<div class="row">
			<div class="col-sm-10">
				<h2><?php __('front_your_details');?></h2>

				<form id="pjNcbCheckoutForm_<?php echo $_GET['index'];?>" name="pjNcbCheckoutForm" action="#" method="post" class="form-horizontal">
					<input type="hidden" name="ncb_checkout" value="1" />
					<input type="hidden" name="subtotal" value="<?php echo $tpl['prices']['subtotal'];?>" />
					<input type="hidden" name="tax" value="<?php echo $tpl['prices']['tax'];?>" />
					<input type="hidden" name="total" value="<?php echo $tpl['prices']['total'];?>" />
					<input type="hidden" name="deposit" value="<?php echo $tpl['prices']['deposit'];?>" />
					<?php
					if (in_array((int) $tpl['option_arr']['o_bf_include_title'], array(2,3)))
					{ 
						?>
						<div class="form-group">
							<label for="c_title" class="col-sm-3 control-label"><?php __('front_title'); ?></label>
							
							<div class="col-sm-9">
								<select id="c_title" name="c_title" class="form-control<?php echo (int) $tpl['option_arr']['o_bf_include_title'] === 3 ? ' required' : null;?>" data-msg-required="<?php __('pj_field_required'); ?>">
									<option value=""></option>
									<?php
									foreach(__('personal_titles', true) as $k => $v) 
									{
										?><option value="<?php echo $k;?>"<?php echo isset($FORM['c_title']) ? ($FORM['c_title'] == $k ? ' selected="selected"' : null) : null;?>><?php  echo $v;?></option><?php
									}
									?>
								</select>
								<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_name'], array(2,3)))
					{ 
						?>
						<div class="form-group">
							<label for="c_name" class="col-sm-3 control-label"><?php __('front_name'); ?></label>
							
							<div class="col-sm-9">
								<input type="text" id="c_name" name="c_name" class="form-control<?php echo (int) $tpl['option_arr']['o_bf_include_name'] === 3 ? ' required' : NULL; ?>" value="<?php echo pjSanitize::html(@$FORM['c_name']); ?>" data-msg-required="<?php __('pj_field_required'); ?>">
						    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_email'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_email" class="col-sm-3 control-label"><?php __('front_email'); ?></label>
							
							<div class="col-sm-9">
								<input type="text" id="c_email" name="c_email" class="form-control email<?php echo (int) $tpl['option_arr']['o_bf_include_email'] === 3 ? ' required' : NULL; ?>" value="<?php echo pjSanitize::html(@$FORM['c_email']); ?>" data-msg-required="<?php __('pj_field_required'); ?>" data-msg-email="<?php __('pj_email_validation'); ?>">
						    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_phone'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_phone" class="col-sm-3 control-label"><?php __('front_phone'); ?></label>
							
							<div class="col-sm-9">
								<input type="text" id="c_phone" name="c_phone" class="form-control<?php echo (int) $tpl['option_arr']['o_bf_include_phone'] === 3 ? ' required' : NULL; ?>" value="<?php echo pjSanitize::html(@$FORM['c_phone']); ?>" data-msg-required="<?php __('pj_field_required'); ?>">
						    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_company'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_company" class="col-sm-3 control-label"><?php __('front_company'); ?></label>
							
							<div class="col-sm-9">
								<input type="text" id="c_company" name="c_company" class="form-control<?php echo (int) $tpl['option_arr']['o_bf_include_company'] === 3 ? ' required' : NULL; ?>" value="<?php echo pjSanitize::html(@$FORM['c_company']); ?>" data-msg-required="<?php __('pj_field_required'); ?>">
						    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_address'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_address" class="col-sm-3 control-label"><?php __('front_address'); ?></label>
							
							<div class="col-sm-9">
								<input type="text" id="c_address" name="c_address" class="form-control<?php echo (int) $tpl['option_arr']['o_bf_include_address'] === 3 ? ' required' : NULL; ?>" value="<?php echo pjSanitize::html(@$FORM['c_address']); ?>" data-msg-required="<?php __('pj_field_required'); ?>">
						    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_country'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_country" class="col-sm-3 control-label"><?php __('front_country'); ?></label>
							
							<div class="col-sm-9">
								<select id="c_country" name="c_country" class="form-control<?php echo (int) $tpl['option_arr']['o_bf_include_country'] === 3 ? ' required' : null;?>" data-msg-required="<?php __('pj_field_required'); ?>">
									<option value="">-- <?php __('front_choose');?> --</option>
									<?php
									foreach($tpl['country_arr'] as $k => $v) 
									{
										?><option value="<?php echo $v['id'];?>"<?php echo isset($FORM['c_country']) ? ($FORM['c_country'] == $v['id'] ? ' selected="selected"' : null) : null;?>><?php  echo $v['country_title'];?></option><?php
									}
									?>
								</select>
								<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_state'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_state" class="col-sm-3 control-label"><?php __('front_state'); ?></label>
							
							<div class="col-sm-9">
								<input type="text" id="c_state" name="c_state" class="form-control<?php echo (int) $tpl['option_arr']['o_bf_include_state'] === 3 ? ' required' : NULL; ?>" value="<?php echo pjSanitize::html(@$FORM['c_state']); ?>" data-msg-required="<?php __('pj_field_required'); ?>">
						    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_city'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_city" class="col-sm-3 control-label"><?php __('front_city'); ?></label>
							
							<div class="col-sm-9">
								<input type="text" id="c_city" name="c_city" class="form-control<?php echo (int) $tpl['option_arr']['o_bf_include_city'] === 3 ? ' required' : NULL; ?>" value="<?php echo pjSanitize::html(@$FORM['c_city']); ?>" data-msg-required="<?php __('pj_field_required'); ?>">
						    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_zip'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_zip" class="col-sm-3 control-label"><?php __('front_zip'); ?></label>
							
							<div class="col-sm-9">
								<input type="text" id="c_zip" name="c_zip" class="form-control<?php echo (int) $tpl['option_arr']['o_bf_include_zip'] === 3 ? ' required' : NULL; ?>" value="<?php echo pjSanitize::html(@$FORM['c_zip']); ?>" data-msg-required="<?php __('pj_field_required'); ?>">
						    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_notes'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_notes" class="col-sm-3 control-label"><?php __('front_notes'); ?></label>
							
							<div class="col-sm-9">
								<textarea id="c_notes" name="c_notes" class="form-control<?php echo (int) $tpl['option_arr']['o_bf_include_notes'] === 3 ? ' required' : NULL; ?>" style="height: 150px;" data-msg-required="<?php __('pj_field_required'); ?>"><?php echo pjSanitize::html(@$FORM['c_notes']); ?></textarea>
						    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<?php
					} 
					if ($tpl['option_arr']['o_payment_disable'] == 'No')
					{
						?>
						<div class="form-group">
							<label class="col-sm-3 control-label"><?php __('front_payment_method')?></label>
							
							<div class="col-sm-9">
								<select name="payment_method" class="form-control required" data-msg-required="<?php __('pj_field_required'); ?>">
									<option value="">-- <?php __('front_choose');?> --</option>
									<?php
									foreach (__('payment_methods', true) as $k => $v)
									{
										if ($tpl['option_arr']['o_allow_' . $k] === "Yes")
										{
											?><option value="<?php echo $k; ?>"<?php echo @$FORM['payment_method'] != $k ? NULL : ' selected="selected"'; ?>><?php echo $v; ?></option><?php
										}
									}
									?>
								</select>
								<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<div class="form-group pjNcbBankWrap" style="display: <?php echo @$FORM['payment_method'] != 'bank' ? 'none' : NULL; ?>">
							<label class="col-sm-3 control-label"><?php __('front_bank_account')?></label>
							
							<div class="col-sm-9">
								<label class="text-muted"><strong><?php echo nl2br(pjSanitize::html($tpl['option_arr']['o_bank_account'])); ?></strong></label>
							</div>
						</div>
						<div class="form-group pjNcbCcWrap" style="display: <?php echo @$FORM['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
							<label class="col-sm-3 control-label"><?php __('front_cc_type')?></label>
							
							<div class="col-sm-9">
								<select name="cc_type" class="form-control required" data-msg-required="<?php __('pj_field_required'); ?>">
						    		<option value="">---</option>
						    		<?php
									foreach (__('cc_types', true) as $k => $v)
									{
										?><option value="<?php echo $k; ?>"<?php echo @$FORM['cc_type'] != $k ? NULL : ' selected="selected"'; ?>><?php echo $v; ?></option><?php
									}
									?>
						    	</select>
						    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<div class="form-group pjNcbCcWrap" style="display: <?php echo @$FORM['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
							<label class="col-sm-3 control-label"><?php __('front_cc_num')?></label>
							
							<div class="col-sm-9">
								<input type="text" name="cc_num" class="form-control required" value="<?php echo pjSanitize::html(@$FORM['cc_num']); ?>"  autocomplete="off" data-msg-required="<?php __('pj_field_required'); ?>"/>
						    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<div class="form-group pjNcbCcWrap" style="display: <?php echo @$FORM['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
							<label class="col-sm-3 control-label"><?php __('front_cc_code')?></label>
							
							<div class="col-sm-9">
								<input type="text" name="cc_code" class="form-control required" value="<?php echo pjSanitize::html(@$FORM['cc_code']); ?>"  autocomplete="off" data-msg-required="<?php __('pj_field_required'); ?>"/>
						    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div>
						</div>
						<div class="form-group pjNcbCcWrap" style="display: <?php echo @$FORM['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
							<label class="col-sm-3 control-label"><?php __('front_cc_exp')?></label>
							
							<div class="col-sm-5">
								<?php
								$rand = rand(1, 99999);
								$time = pjTime::factory()
									->attr('name', 'cc_exp_month')
									->attr('id', 'cc_exp_month_' . $rand)
									->attr('class', 'form-control required')
									->prop('format', 'F');
								if (isset($FORM['cc_exp_month']) && !is_null($FORM['cc_exp_month']))
								{
									$time->prop('selected', $FORM['cc_exp_month']);
								}
								echo $time->month();
								?>
							</div>
							<div class="col-sm-4">
								<?php
								$time = pjTime::factory()
									->attr('name', 'cc_exp_year')
									->attr('id', 'cc_exp_year_' . $rand)
									->attr('class', 'form-control required')
									->prop('left', 0)
									->prop('right', 10);
								if (isset($FORM['cc_exp_year']) && !is_null($FORM['cc_exp_year']))
								{
									$time->prop('selected', $FORM['cc_exp_year']);
								}
								echo $time->year();
								?>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_captcha'], array(3)))
					{ 
						?>
						<div class="form-group">
							<label class="col-sm-3 control-label"><?php __('front_captcha'); ?></label>
							
							<div class="col-sm-9">
								<div class="row">
									<div class="col-sm-3">
										<img src="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&amp;action=pjActionCaptcha&amp;rand=<?php echo rand(1, 99999); ?><?php echo isset($_GET['session_id']) ? '&session_id=' . $_GET['session_id'] : NULL;?>" alt="Captcha" style="vertical-align: middle" />
									</div><!-- /.col-sm-4 -->
	
									<div class="col-sm-6">
										<input type="text" name="captcha" class="form-control<?php echo (int) $tpl['option_arr']['o_bf_include_captcha'] === 3 ? ' required' : NULL; ?>" maxlength="6" autocomplete="off" data-msg-required="<?php __('pj_field_required'); ?>" data-msg-remote="<?php __('front_incorrect_captcha');?>">
  								    	<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
									</div><!-- /.col-sm-4 -->
								</div><!-- /.row -->
							</div>
						</div>
						<?php
					}
					$terms = __('front_agree_with_terms', true);
					if(!empty($tpl['terms_conditions']))
					{ 
						$terms = str_replace("{STAG}", '<a href="#" class="pjTbModalTrigger" data-toggle="modal" data-target="#pjNcbTermModal" data-title="'.__('front_terms_title', true).'">', $terms);
						$terms = str_replace("{ETAG}", '</a>', $terms);
					}else{
						$terms = str_replace("{STAG}", '', $terms);
						$terms = str_replace("{ETAG}", '', $terms);
					}
					?>
					<div class="form-group">
						<div class="col-sm-offset-3 col-sm-9">
							<div class="checkbox">
								<label>
									<input type="checkbox" name="terms" value="1" class="required" data-msg-required="<?php __('pj_field_required'); ?>">
							      	<?php echo $terms;?>
									<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
								</label>
								
							</div>
						</div>
					</div>
					<?php
					$hash = 'loadExtras';
					if($tpl['cnt_extras'] == 0)
					{
						$hash = 'loadBooth';
					} 
					?>
					<div class="form-group">
						<div class="col-sm-offset-3 col-sm-9">
							<button type="submit" class="btn btn-primary"><?php __('front_btn_continue');?></button>

							<button type="button" class="btn btn-default pjNcbMenuItem" data-item="<?php echo $hash;?>"><?php __('front_btn_cancel');?></button>
						</div>
					</div>
				</form>
				
				<div class="modal fade pjTbModal" id="pjNcbTermModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
				  	<div class="modal-dialog">
				    	<div class="modal-content">
				      		<div class="modal-header">
				        		<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only"><?php __('front_btn_close');?></span></button>
				        		<h4 class="modal-title pjTbModalTitle" id="myModalLabel"><?php __('front_terms_title', false, true); ?></h4>
				      		</div>
						    <div class="modal-body">
						    	<?php echo nl2br(stripslashes($tpl['terms_conditions'])); ?>
						    </div>
					      	<div class="modal-footer">
					        	<button type="button" class="btn btn-default" data-dismiss="modal"><?php __('front_btn_close');?></button>
					      	</div>
				    	</div>
				  	</div>
				</div>
			</div><!-- /.pjNcb-form -->
		</div><!-- /.col-sm-10 -->
	</div><!-- /.row -->
</div><!-- /.pjNcb-details -->