<?php
include_once dirname(__FILE__) . '/elements/header.php';

$STORE = @$_SESSION[$controller->defaultStore];
$FORM = @$_SESSION[$controller->defaultForm];
?>
<div class="pjNcb-details">
	<div class="pjNcb-booking-details">
		<h2><?php __('front_booking_details');?></h2>

		<div class="pjNcb-booking-detail">
			<div class="row">
				<div class="col-sm-3">
					<p><span><?php __('front_date');?></span></p>
				</div><!-- /.col-sm-3 -->

				<div class="col-sm-4">
					<p><strong><?php echo date($tpl['option_arr']['o_date_format'], strtotime($STORE['date_iso']));?></strong></p>
				</div><!-- /.col-sm-3 -->
			</div><!-- /.row -->
		</div><!-- /.pjNcb-booking-detail -->

		<?php
		$unit_price = $tpl['arr']['price'];
		if(!empty($tpl['arr']['custom_price']))
		{
			$unit_price = $tpl['arr']['custom_price'];
		}
		?>
		<div class="pjNcb-booking-detail">
			<div class="row">
				<div class="col-sm-3">
					<p><span><?php __('front_booth_type');?></span></p>
				</div><!-- /.col-sm-3 -->

				<div class="col-sm-4">
					<p><strong><?php echo pjSanitize::html($tpl['arr']['type']);?></strong></p>
				</div><!-- /.col-sm-3 -->
				<div class="col-sm-2">
					<p class="text-center"><?php echo $STORE['cnt'];?></p>
				</div><!-- /.col-sm-2 -->
				<div class="col-sm-1">
					<p>x</p>
				</div><!-- /.col-sm-1 -->
				<div class="col-sm-2">
					<p><strong><?php echo pjUtil::formatCurrencySign(number_format($unit_price, 2), $tpl['option_arr']['o_currency']);?></strong></p>
				</div><!-- /.col-sm-2 -->
			</div><!-- /.row -->
		</div><!-- /.pjNcb-booking-detail -->
		
		<?php
		if(isset($STORE['extras']) && count($STORE['extras']) > 0)
		{ 
			$trace_id = 0;
			foreach($STORE['extras'] as $cid => $extra_arr)
			{
				if(isset($tpl['category_arr'][$cid]))
				{
					?>
					<div class="pjNcb-booking-detail">
						<?php
						foreach($extra_arr as $eid => $extra)
						{
							if(isset($tpl['extra_arr'][$eid]) && $extra['cnt'] > 0)
							{
								?>
								<div class="row<?php echo $trace_id == $cid ? ' rowspan' : NULL; ?>">
									<div class="col-sm-3">
										<?php
										if($trace_id != $cid)
										{ 
											?>
											<p><span><?php echo pjSanitize::html($tpl['category_arr'][$cid]);?></span></p>
											<?php
											$trace_id = $cid;
										}else{
											?>
											<p><span>&nbsp;</span></p>
											<?php
										} 
										?>
									</div><!-- /.col-sm-3 -->
					
									<div class="col-sm-4">
										<p><strong><?php echo pjSanitize::html($tpl['extra_arr'][$eid]);?></strong></p>
									</div><!-- /.col-sm-3 -->
					
									<div class="col-sm-2">
										<p class="text-center"><?php echo $extra['cnt'];?></p>
									</div><!-- /.col-sm-3 -->
									<div class="col-sm-1">
										<p>x</p>
									</div><!-- /.col-sm-1 -->
									<div class="col-sm-2">
										<p><strong><?php echo pjUtil::formatCurrencySign(number_format($extra['price'], 2), $tpl['option_arr']['o_currency']);?></strong></p>
									</div><!-- /.col-sm-3 -->
					
								</div><!-- /.row -->
								<?php
							}
						}
						?>
					</div><!-- /.pjNcb-booking-detail -->
					<?php
				}
			}
		} 
		?>
		<div class="pjNcb-booking-detail">
			<div class="row">
				<div class="col-sm-3">
					<p><span><?php __('front_subtotal');?></span></p>
				</div><!-- /.col-sm-3 -->

				<div class="col-sm-4">
					<p><strong><?php echo pjUtil::formatCurrencySign(number_format($tpl['prices']['subtotal'], 2), $tpl['option_arr']['o_currency']);?></strong></p>
				</div><!-- /.col-sm-3 -->
			</div><!-- /.row -->
		</div><!-- /.pjNcb-booking-detail -->

		<div class="pjNcb-booking-detail">
			<div class="row">
				<div class="col-sm-3">
					<p><span><?php __('front_tax');?> (<?php echo number_format($tpl['option_arr']['o_tax_payment'], 2)?>%)</span></p>
				</div><!-- /.col-sm-3 -->

				<div class="col-sm-4">
					<p><strong><?php echo pjUtil::formatCurrencySign(number_format($tpl['prices']['tax'], 2), $tpl['option_arr']['o_currency']);?></strong></p>
				</div><!-- /.col-sm-3 -->
			</div><!-- /.row -->
		</div><!-- /.pjNcb-booking-detail -->
		<div class="pjNcb-booking-detail">
			<div class="row">
				<div class="col-sm-3">
					<p><span><?php __('front_total');?></span></p>
				</div><!-- /.col-sm-3 -->

				<div class="col-sm-4">
					<p><strong><?php echo pjUtil::formatCurrencySign(number_format($tpl['prices']['total'], 2), $tpl['option_arr']['o_currency']);?></strong></p>
				</div><!-- /.col-sm-3 -->
			</div><!-- /.row -->
		</div><!-- /.pjNcb-booking-detail -->
		<div class="pjNcb-booking-detail">
			<div class="row">
				<div class="col-sm-3">
					<p><span><?php __('front_deposit');?>  (<?php echo number_format($tpl['option_arr']['o_deposit_payment'],2);?>%)</span></p>
				</div><!-- /.col-sm-3 -->

				<div class="col-sm-4">
					<p><strong><?php echo pjUtil::formatCurrencySign(number_format($tpl['prices']['deposit'], 2), $tpl['option_arr']['o_currency']);?></strong></p>
				</div><!-- /.col-sm-3 -->
			</div><!-- /.row -->
		</div><!-- /.pjNcb-booking-detail -->
	</div><!-- /.pjNcb-booking-details -->
	
	<div class="pjNcb-form">
		<div class="row">
			<div class="col-sm-10">
				<h2><?php __('front_your_details');?></h2>

				<form id="pjNcbPreviewForm_<?php echo $_GET['index'];?>" name="pjNcbPreviewForm" action="#" method="post" class="form-horizontal">
					<input type="hidden" name="ncb_preview" value="1" />
					<?php
					if (in_array((int) $tpl['option_arr']['o_bf_include_title'], array(2,3)))
					{ 
						$personal_titles = __('personal_titles', true);
						?>
						<div class="form-group">
							<label for="c_title" class="col-sm-3 control-label"><?php __('front_title'); ?></label>
							
							<div class="col-sm-9">
								<label><?php echo $personal_titles[$FORM['c_title']];?></label>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_name'], array(2,3)))
					{ 
						?>
						<div class="form-group">
							<label for="c_name" class="col-sm-3 control-label"><?php __('front_name'); ?></label>
							
							<div class="col-sm-9">
								<label><?php echo pjSanitize::html(@$FORM['c_name']); ?></label>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_email'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_email" class="col-sm-3 control-label"><?php __('front_email'); ?></label>
							
							<div class="col-sm-9">
								<label><?php echo pjSanitize::html(@$FORM['c_email']); ?></label>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_phone'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_phone" class="col-sm-3 control-label"><?php __('front_phone'); ?></label>
							
							<div class="col-sm-9">
								<label><?php echo pjSanitize::html(@$FORM['c_phone']); ?></label>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_company'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_company" class="col-sm-3 control-label"><?php __('front_company'); ?></label>
							
							<div class="col-sm-9">
								<label><?php echo pjSanitize::html(@$FORM['c_company']); ?></label>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_address'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_address" class="col-sm-3 control-label"><?php __('front_address'); ?></label>
							
							<div class="col-sm-9">
								<label><?php echo pjSanitize::html(@$FORM['c_address']); ?></label>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_country'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_country" class="col-sm-3 control-label"><?php __('front_country'); ?></label>
							
							<div class="col-sm-9">
								<?php
								if(isset($tpl['country_arr']['country_title']))
								{ 
									?><label><?php echo pjSanitize::html($tpl['country_arr']['country_title']); ?></label><?php
								}else{
									?><label>&nbsp;</label><?php
								} 
								?>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_state'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_state" class="col-sm-3 control-label"><?php __('front_state'); ?></label>
							
							<div class="col-sm-9">
								<label><?php echo pjSanitize::html(@$FORM['c_state']); ?></label>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_city'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_city" class="col-sm-3 control-label"><?php __('front_city'); ?></label>
							
							<div class="col-sm-9">
								<label><?php echo pjSanitize::html(@$FORM['c_city']); ?></label>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_zip'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_zip" class="col-sm-3 control-label"><?php __('front_zip'); ?></label>
							
							<div class="col-sm-9">
								<label><?php echo pjSanitize::html(@$FORM['c_zip']); ?></label>
							</div>
						</div>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_notes'], array(2,3)))
					{
						?>
						<div class="form-group">
							<label for="c_notes" class="col-sm-3 control-label"><?php __('front_notes'); ?></label>
							
							<div class="col-sm-9">
								<label><?php echo nl2br(pjSanitize::html(@$FORM['c_notes'])); ?></label>
							</div>
						</div>
						<?php
					} 
					if ($tpl['option_arr']['o_payment_disable'] == 'No')
					{
						$payment_methods = __('payment_methods', true);
						$cc_types = __('cc_types', true);
						?>
						<div class="form-group">
							<label class="col-sm-3 control-label"><?php __('front_payment_method')?></label>
							
							<div class="col-sm-9">
								<label><?php echo $payment_methods[$FORM['payment_method']]; ?></label>
							</div>
						</div>
						<div class="form-group pjNcbBankWrap" style="display: <?php echo @$FORM['payment_method'] != 'bank' ? 'none' : NULL; ?>">
							<label class="col-sm-3 control-label"><?php __('front_bank_account')?></label>
							
							<div class="col-sm-9">
								<label class="text-muted"><strong><?php echo nl2br(pjSanitize::html($tpl['option_arr']['o_bank_account'])); ?></strong></label>
							</div>
						</div>
						<div class="form-group pjNcbCcWrap" style="display: <?php echo @$FORM['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
							<label class="col-sm-3 control-label"><?php __('front_cc_type')?></label>
							
							<div class="col-sm-9">
								<label><?php echo $cc_types[$FORM['cc_type']]; ?></label>
							</div>
						</div>
						<div class="form-group pjNcbCcWrap" style="display: <?php echo @$FORM['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
							<label class="col-sm-3 control-label"><?php __('front_cc_num')?></label>
							
							<div class="col-sm-9">
								<label><?php echo pjSanitize::html(@$FORM['cc_num']); ?></label>
							</div>
						</div>
						<div class="form-group pjNcbCcWrap" style="display: <?php echo @$FORM['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
							<label class="col-sm-3 control-label"><?php __('front_cc_code')?></label>
							
							<div class="col-sm-9">
								<label><?php echo pjSanitize::html(@$FORM['cc_code']); ?></label>
							</div>
						</div>
						<div class="form-group pjNcbCcWrap" style="display: <?php echo @$FORM['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
							<label class="col-sm-3 control-label"><?php __('front_cc_exp')?></label>
							
							<div class="col-sm-5">
								<label><?php echo pjSanitize::html(@$FORM['cc_exp_month']); ?></label>
							</div>
							<div class="col-sm-4">
								<label><?php echo pjSanitize::html(@$FORM['cc_exp_year']); ?></label>
							</div>
						</div>
						<?php
					}
					?>
					<div class="form-group">
						<div class="col-sm-offset-3 col-sm-9">
							<button type="submit" class="btn btn-primary"><?php __('front_btn_continue');?></button>

							<button type="button" class="btn btn-default pjNcbMenuItem" data-item="loadCheckout"><?php __('front_btn_cancel');?></button>
						</div>
					</div>
				</form>
				
			</div><!-- /.pjNcb-form -->
		</div><!-- /.col-sm-10 -->
	</div><!-- /.row -->
</div><!-- /.pjNcb-details -->