<?php 
include_once dirname(__FILE__) . '/elements/header.php';

$months = __('months', true);
$short_months = __('short_months', true);
ksort($months);
ksort($short_months);
$days = __('days', true);
$short_days = __('short_days', true);
?>

<div id="pjNcbCalendarLocale" style="display: none;" data-months="<?php echo implode("_", $months);?>" data-days="<?php echo implode("_", $short_days);?>"></div>

<div class="pjNcb-datepick">
	<label><?php __('front_date');?>:</label>

	<div class="input-group pjNcbDate">
		<input type="text" id="pjNcbDate_<?php echo $_GET['index'];?>" name="date" value="<?php echo $tpl['date'];?>" class="form-control"/>
	
		<span class="input-group-addon">
			<span class="glyphicon glyphicon-calendar" aria-hidden="true"></span>
		</span>
	</div><!-- /.input-group pjNcbDate -->
</div><!-- /.pjNcb-datepick -->

<div class="pjNcb-booths">

	<?php
	if(isset($tpl['booth_arr']))
	{ 
		if(!empty($tpl['booth_arr']))
		{
			?>
			<h2><?php __('front_available_booths');?></h2>
		
			<div class="row">
				<?php
				foreach($tpl['booth_arr'] as $k => $v)
				{ 
					$image = PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/257x170.png';
					if(!empty($v['thumb']) && file_exists(PJ_INSTALL_PATH . $v['thumb']))
					{
						$image = PJ_INSTALL_URL . $v['thumb'];
					}
					
					$price = $v['price'];
					if(!empty($v['custom_price']))
					{
						$price = $v['custom_price'];
					}
					$price_per_person = null;
					if($v['capacity'] > 0)
					{
						$price_per_person = pjUtil::formatCurrencySign(number_format($price / $v['capacity'], 2), $tpl['option_arr']['o_currency']);
					}
					?>
					<div class="col-md-4 col-sm-6">
						<div class="pjNcb-booth">
							<div class="pjNcb-booth-image">
								<img src="<?php echo $image;?>" alt="">
								<?php
								if($price_per_person != null)
								{ 
									?>
									<p><strong><?php echo $price_per_person;?></strong> <?php __('front_per_person');?></p>
									<?php
								} 
								?>
							</div><!-- /.booth-image -->
			
							<div class="pjNcb-booth-content">
								<div class="pjNcb-booth-title"><?php echo pjSanitize::html($v['type']);?></div><!-- /.booth-title -->
			
								<ul>
									<li><?php __('front_based_on');?>: <strong><?php echo $v['capacity'];?> <?php $v['capacity'] != 1 ? __('front_people') : __('front_person');?></strong></li>
									<li><?php __('front_total_booth_cost');?>: <strong><?php echo pjUtil::formatCurrencySign($price, $tpl['option_arr']['o_currency']);?></strong></li>
								</ul>
								<?php
								if((int) $v['count'] > (int) $v['cnt_booked'])
								{ 
									?>
									<div class="pjNcb-booth-actions">
										<a href="#" class="btn btn-primary pjNcbSelectBooth" data-id="<?php echo $v['id'];?>"><?php __('front_btn_select_booth');?></a>
									</div><!-- /.booth-actions -->
									<?php
								}else{
									?>
									<div class="pjNcb-booth-actions">
										<button class="btn btn-primary" disabled="disabled"><?php __('front_btn_na');?></button>
									</div><!-- /.booth-actions -->
									<?php
								} 
								?>
							</div><!-- /.booth-content -->
						</div><!-- /.booth -->
					</div>
					<?php
				} 
				?>
			</div><!-- /.row -->
			<?php
		}else{
			?><h3><?php __('front_no_booths_found');?></h3><?php
		}
	}else{
		?><h3><?php __('front_club_closed');?></h3><?php
	} 
	?>
</div><!-- /.booths -->