var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var datepicker = ($.fn.datepicker !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			qs = "",
			$frmCreateDate = $('#frmCreateDate'),
			$frmUpdateDate = $("#frmUpdateDate");
		
		if ($frmCreateDate.length > 0 && validate) {
			$frmCreateDate.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent().parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		if ($frmUpdateDate.length > 0 && validate) {
			$frmUpdateDate.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent().parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminDates&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminDates&action=pjActionDeleteDate&id={:id}"}
				          ],
				columns: [{text: myLabel.start_date, type: "text", sortable: true, editable: false, width: 300},
				          {text: myLabel.end_date, type: "text", sortable: true, editable: false, width: 300}],
				dataUrl: "index.php?controller=pjAdminDates&action=pjActionGetDate" + pjGrid.queryString,
				dataType: "json",
				fields: ['start_date', 'end_date'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminDates&action=pjActionDeleteDateBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminDates&action=pjActionSaveDate&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("focusin", ".datepicker", function (e) {
			var minDate, maxDate,
				$this = $(this),
				custom = {},
				o = {
					monthNames: myLabel.monthNames,
					dayNamesMin: myLabel.dayNamesMin,
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev")
				};
			switch ($this.attr("name")) {
			case "start_date":
				if($(".datepicker[name='end_date']").val() != '')
				{
					maxDate = $(".datepicker[name='end_date']").datepicker({
						firstDay: $this.attr("rel"),
						dateFormat: $this.attr("rev")
					}).datepicker("getDate");
					$(".datepicker[name='end_date']").datepicker("destroy").removeAttr("id");
					if (maxDate !== null) {
						custom.maxDate = maxDate;
					}
				}
				break;
			case "end_date":
				if($(".datepicker[name='start_date']").val() != '')
				{
					minDate = $(".datepicker[name='start_date']").datepicker({
						firstDay: $this.attr("rel"),
						dateFormat: $this.attr("rev")
					}).datepicker("getDate");
					$(".datepicker[name='start_date']").datepicker("destroy").removeAttr("id");
					if (minDate !== null) {
						custom.minDate = minDate;
					}
				}
				break;
			}
			$(this).datepicker($.extend(o, custom));
			
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
		});
	});
})(jQuery_1_8_2);