var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var datepicker = ($.fn.datepicker !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			$frmSendEmail = $('#frmSendEmail');
		
		if ($frmSendEmail.length > 0 && validate) {
			$frmSendEmail.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
			
			tinymce.init({
		    	selector: "#message",
		    	theme: "modern",
		    	width: 550,
			    plugins: [
			              "advlist autolink link image lists charmap print preview hr anchor pagebreak",
			              "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
			              "save table contextmenu directionality emoticons template paste textcolor"
			         ],
	         	toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",
	         	setup: function (editor) {
	                editor.on('change', function () {
	                    tinymce.triggerSave();
	                });
	            }
			 });
		}
		
		$(document).on("change", ".pjNcbSendTo", function (e) {
			$.post("index.php?controller=pjAdminEmails&action=pjActionGetClients", $('.pjNcbSendTo').serialize()).done(function (data) {
				if(data.cnt != '0')
				{
					$frmSendEmail.find('input[name="total_clients"]').val(data.cnt).valid();
				}else{
					$frmSendEmail.find('input[name="total_clients"]').val("");
				}
				$('#pjNcbTotalClients').html(data.cnt);
			});
		});
	});
})(jQuery_1_8_2);