DROP TABLE IF EXISTS `rpbcalendar_discounts`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('amount','percent') DEFAULT NULL,
  `discount` decimal(9,2) unsigned DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `condition` enum('period','made','both') DEFAULT NULL,
  `options` enum('early','persons','family','duration') DEFAULT NULL,
  `early_days` int(10) unsigned DEFAULT NULL,
  `min_persons` int(10) unsigned DEFAULT NULL,
  `max_persons` int(10) unsigned DEFAULT NULL,
  `min_duration` int(10) unsigned DEFAULT NULL,
  `max_duration` int(10) unsigned DEFAULT NULL,
  `apply_on` enum('room','extra','both') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_calendars_discounts`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_calendars_discounts` (
  `calendar_id` int(10) unsigned NOT NULL,
  `discount_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`calendar_id`, `discount_id`),
  KEY `calendar_id` (`calendar_id`),
  KEY `discount_id` (`discount_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_vouchers`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_vouchers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(100) DEFAULT NULL,
  `used_count` int(10) unsigned DEFAULT NULL,
  `type` enum('amount','percent') DEFAULT NULL,
  `discount` decimal(9,2) unsigned DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `condition` enum('period','made','both') DEFAULT NULL,
  `apply_on` enum('room','extra','both') DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_calendars_vouchers`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_calendars_vouchers` (
  `calendar_id` int(10) unsigned NOT NULL,
  `voucher_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`calendar_id`, `voucher_id`),
  KEY `calendar_id` (`calendar_id`),
  KEY `voucher_id` (`voucher_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_extras`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `price` decimal(9,2) DEFAULT NULL,
  `price_type` enum('person','night','person_night', 'count','count_night', 'one_time') DEFAULT NULL,
  `required` enum('T','F') DEFAULT NULL,
  `multi` enum('T','F') DEFAULT NULL,
  `max_count` int(10) DEFAULT NULL,
  `status` enum('T','F') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_calendars_extras`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_calendars_extras` (
  `calendar_id` int(10) unsigned NOT NULL,
  `extra_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`calendar_id`, `extra_id`),
  KEY `calendar_id` (`calendar_id`),
  KEY `extra_id` (`extra_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `rpbcalendar_reservations_extras`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_reservations_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reservation_id` int(10) unsigned DEFAULT NULL,
  `extra_id` int(10) DEFAULT NULL,
  `qty` tinyint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservation_id` (`reservation_id`),
  KEY `extra_id` (`extra_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_calendars`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_calendars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_limits`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_limits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `min_nights` tinyint(3) unsigned DEFAULT NULL,
  `max_nights` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_options`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool','color') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_reservations`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_reservations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned NOT NULL,
  `uuid` varchar(12) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `price_based_on` enum('nights','days') DEFAULT NULL,
  `c_name` varchar(255) DEFAULT NULL,
  `c_email` varchar(255) DEFAULT NULL,
  `c_phone` varchar(255) DEFAULT NULL,
  `c_adults` smallint(5) unsigned DEFAULT NULL,
  `c_children` smallint(5) unsigned DEFAULT NULL,
  `c_notes` text,
  `c_address` varchar(255) DEFAULT NULL,
  `c_city` varchar(255) DEFAULT NULL,
  `c_country` int(10) unsigned DEFAULT NULL,
  `c_state` varchar(255) DEFAULT NULL,
  `c_zip` varchar(255) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `extra_price` decimal(9,2) unsigned DEFAULT NULL,
  `deposit` decimal(9,2) unsigned DEFAULT NULL,
  `tax` decimal(7,2) unsigned DEFAULT NULL,
  `tourist_tax` decimal(7,2) unsigned DEFAULT NULL,
  `security` decimal(7,2) unsigned DEFAULT NULL,
  `promo_amount` decimal(7,2) unsigned DEFAULT NULL,
  `promo_code` varchar(255) DEFAULT NULL,
  `promo_type` enum('amount','percent') DEFAULT NULL,
  `discount_amount` decimal(7,2) unsigned DEFAULT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `cc_type` varchar(255) DEFAULT NULL,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `status` enum('Confirmed','Pending','Cancelled') DEFAULT NULL,
  `locale_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_password`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_password` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `format` enum('ical','xml', 'csv') NOT NULL DEFAULT 'ical',
  `password` varchar(255) DEFAULT NULL,
  `type` enum('next','last') NOT NULL DEFAULT 'next',
  `period` enum('1','2','3','4','5','6') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_roles`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `rpbcalendar_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T'),
(3, 'owner', 'T');

DROP TABLE IF EXISTS `rpbcalendar_users`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_users_notifications`;
CREATE TABLE IF NOT EXISTS `rpbcalendar_users_notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `notification_id` tinyint(3) unsigned DEFAULT NULL,
  `type` enum('email','sms') DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`notification_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rpbcalendar_fields`;
CREATE TABLE `rpbcalendar_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `rpbcalendar_fields` VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'bf_tourist_tax', 'backend', 'Label / Tourist tax', 'script', NULL),
(4, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(5, 'btnAddCalendar', 'backend', 'Button / + Add calendar', 'script', NULL),
(6, 'btnAddCoupon', 'backend', 'Button / + Add coupon', 'script', NULL),
(7, 'btnAddDiscount', 'backend', 'Button / + Add discount', 'script', NULL),
(8, 'btnAddExtra', 'backend', 'Button / + Add extra', 'script', NULL),
(9, 'btnAddReservation', 'backend', 'Button / + Add reservation', 'script', NULL),
(10, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(11, 'btnCalculate', 'backend', 'Button Calculate', 'script', NULL),
(12, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(13, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(14, 'btnCopy', 'backend', 'Button Copy', 'script', NULL),
(15, 'btnExport', 'backend', 'Button / Export', 'script', NULL),
(16, 'btnGetFeedURL', 'backend', 'Button / Get Feed URL', 'script', NULL),
(17, 'btnLogin', 'backend', 'Login', 'script', NULL),
(18, 'btnSave', 'backend', 'Save', 'script', NULL),
(19, 'btnSearch', 'backend', 'Search', 'script', NULL),
(20, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(21, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(22, 'btnYes', 'backend', 'Button / Yes', 'script', NULL),
(23, 'dashboard_cancelled_reservations', 'backend', 'Dashboard / Cancelled reservations', 'script', NULL),
(24, 'dashboard_last_7days_reservations', 'backend', 'Dashboard / Last 7 days', 'script', NULL),
(25, 'dashboard_new_calendar', 'backend', 'Dashboard / Create New Calendar', 'script', NULL),
(26, 'dashboard_new_reservation', 'backend', 'Dashboard / Add New Reservation', 'script', NULL),
(27, 'dashboard_new_user', 'backend', 'Dashboard / Add New User', 'script', NULL),
(28, 'dashboard_pending_reservations', 'backend', 'Dashboard / Pending reservations', 'script', NULL),
(29, 'dashboard_quick_links', 'backend', 'Dashboard / Quick links', 'script', NULL),
(30, 'dashboard_this_week_reservations', 'backend', 'Dashboard / This week reservations', 'script', NULL),
(31, 'dashboard_view_availability', 'backend', 'Dashboard / View availability', 'script', NULL),
(32, 'dash_current_reservations', 'backend', 'Dash / Current reservations', 'script', NULL),
(33, 'dash_export_reservations', 'backend', 'Dash / Export reservations', 'script', NULL),
(34, 'dash_make_backup', 'backend', 'Dash / Make back-up', 'script', NULL),
(35, 'dash_manage_coupons', 'backend', 'Dash / Manage Coupons', 'script', NULL),
(36, 'dash_manage_discounts', 'backend', 'Dash / Manage Discounts', 'script', NULL),
(37, 'dash_manage_extras', 'backend', 'Dash / Manage Extras', 'script', NULL),
(38, 'dash_manage_properties', 'backend', 'Dash / Manage properties', 'script', NULL),
(39, 'dash_preview_all_calendars', 'backend', 'Dash / Preview All Calendars', 'script', NULL),
(40, 'dash_reservations_confirmed_today', 'backend', 'Infobox / reservations confirmed today', 'script', NULL),
(41, 'dash_reservations_made_today', 'backend', 'Infobox / new reservations made today', 'script', NULL),
(42, 'dash_reservation_confirmed_today', 'backend', 'Infobox / reservation confirmed today', 'script', NULL),
(43, 'dash_reservation_made_today', 'backend', 'Infobox / new reservation made today', 'script', NULL),
(44, 'dash_set_confirmation_messages', 'backend', 'Dash / Set Confirmation Messages', 'script', NULL),
(45, 'email', 'backend', 'E-Mail', 'script', NULL),
(46, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(47, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(48, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(49, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(50, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(51, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(52, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(53, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(54, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(55, 'gridEmptyDate', 'backend', 'Grid / Empty date', 'script', NULL),
(56, 'gridEmptyDatetime', 'backend', 'Grid / Empty datetime', 'script', NULL),
(57, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(58, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(59, 'gridInvalidDate', 'backend', 'Grid / Invalid date', 'script', NULL),
(60, 'gridInvalidDatetime', 'backend', 'Grid / Invalid datetime', 'script', NULL),
(61, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(62, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(63, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(64, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(65, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(66, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(67, 'infoAddDiscountDesc', 'backend', 'Infobox / Add discount', 'script', NULL),
(68, 'infoAddDiscountTitle', 'backend', 'Infobox / Add discount', 'script', NULL),
(69, 'infoAddExtraDesc', 'backend', 'Infobox / Add extra', 'script', NULL),
(70, 'infoAddExtraTitle', 'backend', 'Infobox / Add extra', 'script', NULL),
(71, 'infoAddVoucherDesc', 'backend', 'Infobox / Add coupon', 'script', NULL),
(72, 'infoAddVoucherTitle', 'backend', 'Infobox / Add coupon', 'script', NULL),
(73, 'infoAvailabilityDesc', 'backend', 'Infobox / Availability', 'script', NULL),
(74, 'infoAvailabilityTitle', 'backend', 'Infobox / Availability', 'script', NULL),
(75, 'infoDiscountListDesc', 'backend', 'Infobox / List of discounts', 'script', NULL),
(76, 'infoDiscountListTitle', 'backend', 'Infobox / List of discounts', 'script', NULL),
(77, 'infoExtrasDesc', 'backend', 'Infobox / List of extras', 'script', NULL),
(78, 'infoExtrasTitle', 'backend', 'Infobox / List of extras', 'script', NULL),
(79, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(80, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(81, 'infoNotificationsEmailBody', 'backend', 'Infobox / Email notifications body', 'script', NULL),
(82, 'infoNotificationsEmailTitle', 'backend', 'Infobox / Email notifications title', 'script', NULL),
(83, 'infoNotificationsSmsBody', 'backend', 'Infobox / Sms notifications body', 'script', NULL),
(84, 'infoNotificationsSmsTitle', 'backend', 'Infobox / Sms notifications title', 'script', NULL),
(85, 'infoReservationFeedDesc', 'backend', 'Infobox / Reservations Feed URL', 'script', NULL),
(86, 'infoReservationFeedTitle', 'backend', 'Infobox / Reservations Feed URL', 'script', NULL),
(87, 'infoUpdateDiscountDesc', 'backend', 'Infobox / Update discount', 'script', NULL),
(88, 'infoUpdateDiscountTitle', 'backend', 'Infobox / Update discount', 'script', NULL),
(89, 'infoUpdateExtraDesc', 'backend', 'Infobox / Update extra', 'script', NULL),
(90, 'infoUpdateExtraTitle', 'backend', 'Infobox / Update extra', 'script', NULL),
(91, 'infoUpdateReservationDesc', 'backend', 'Infobox / Update reservation', 'script', NULL),
(92, 'infoUpdateReservationTitle', 'backend', 'Infobox / Update reservation', 'script', NULL),
(93, 'infoUpdateVoucherDesc', 'backend', 'Infobox / Update coupon code', 'script', NULL),
(94, 'infoUpdateVoucherTitle', 'backend', 'Infobox / Update coupon code', 'script', NULL),
(95, 'infoVoucherListDesc', 'backend', 'Infobox / List of coupons', 'script', NULL),
(96, 'infoVoucherListTitle', 'backend', 'Infobox / List of coupons', 'script', NULL),
(97, 'lblAddCalendar', 'backend', 'Calendars / Add calendar', 'script', NULL),
(98, 'lblAddReservation', 'backend', 'Add reservation', 'script', NULL),
(99, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(100, 'lblAdults', 'backend', 'Label / adults', 'script', NULL),
(101, 'lblAll', 'backend', 'All', 'script', NULL),
(102, 'lblApplyDiscountOn', 'backend', 'Labe / Apply discount on', 'script', NULL),
(103, 'lblAvailableFor', 'backend', 'Label / Available for', 'script', NULL),
(104, 'lblAvailableTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(105, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(106, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(107, 'lblCalendar', 'backend', 'Label / Calendar', 'script', NULL),
(108, 'lblCalendarHasReservation', 'backend', 'Label / There are X reservations for this property which will be deleted too. Do you want to delete it?', 'script', NULL),
(109, 'lblCalendarHasReservations', 'backend', 'Label / There are X reservations for this property which will be deleted too. Do you want to delete it?', 'script', NULL),
(110, 'lblCalendarName', 'backend', 'Calendars / Name', 'script', NULL),
(111, 'lblCalendarNewReserv', 'backend', 'Calendars / New Reservation', 'script', NULL),
(112, 'lblCalendars', 'backend', 'Label / Calendars', 'script', NULL),
(113, 'lblChildren', 'backend', 'Label / chidren', 'script', NULL),
(114, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(115, 'lblComingReservations', 'backend', 'Label / coming reservations ', 'script', NULL),
(116, 'lblDashCalendar', 'backend', 'Dashboard / Calendar', 'script', NULL),
(117, 'lblDashCalendars', 'backend', 'Dashboard / Calendars', 'script', NULL),
(118, 'lblDashLastLogin', 'backend', 'Dashboard / Last login', 'script', NULL),
(119, 'lblDashLatestReservations', 'backend', 'Dashboard / Latest Reservations', 'script', NULL),
(120, 'lblDashMostPopular', 'backend', 'Dashboard / Most Popular', 'script', NULL),
(121, 'lblDashNight', 'backend', 'Dashboard / Night', 'script', NULL),
(122, 'lblDashNights', 'backend', 'Dashboard / Nights', 'script', NULL),
(123, 'lblDashReservation', 'backend', 'Dashboard / Reservation', 'script', NULL),
(124, 'lblDashReservations', 'backend', 'Dashboard / Reservations', 'script', NULL),
(125, 'lblDashTopUsers', 'backend', 'Dashboard / Top Users', 'script', NULL),
(126, 'lblDashUser', 'backend', 'Dashboard / User', 'script', NULL),
(127, 'lblDashUsers', 'backend', 'Dashboard / Users', 'script', NULL),
(128, 'lblDateFrom', 'backend', 'Label / Date from', 'script', NULL),
(129, 'lblDateTo', 'backend', 'Label / Date to', 'script', NULL),
(130, 'lblDaysPrice', 'backend', 'Label / Days price', 'script', NULL),
(131, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(132, 'lblDeleteConfirmation', 'backend', 'Delete confirmation', 'script', NULL),
(133, 'lblDeleteSelected', 'backend', 'Delete selected', 'script', NULL),
(134, 'lblDiscount', 'backend', 'Label / Discount', 'script', NULL),
(135, 'lblDiscountName', 'backend', 'Label / Discount name', 'script', NULL),
(136, 'lblDiscountOptions', 'backend', 'Label / Options', 'script', NULL),
(137, 'lblDuplicatedUniqueID', 'backend', 'Label / There is another reservation with such ID.', 'script', NULL),
(138, 'lblEdit', 'backend', 'Label / Edit', 'script', NULL),
(139, 'lblEmailValidationUnique', 'backend', 'Email address validation', 'script', NULL),
(140, 'lblEnterPassword', 'backend', 'Label / Enter password', 'script', NULL),
(141, 'lblExportSelected', 'backend', 'Export selected', 'script', NULL),
(142, 'lblExtraName', 'backend', 'Label / Extra name', 'script', NULL),
(143, 'lblExtraRequiredMessage', 'backend', 'Label / This extra is required.', 'script', NULL),
(144, 'lblExtras', 'backend', 'Label / Extras', 'script', NULL),
(145, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(146, 'lblFormat', 'backend', 'Label / Format', 'script', NULL),
(147, 'lblFrom', 'backend', 'Label / from', 'script', NULL),
(148, 'lblID', 'backend', 'ID', 'script', NULL),
(149, 'lblInstallConfig', 'backend', 'Install / Config', 'script', NULL),
(150, 'lblInstallConfigAllCalendars', 'backend', 'Install / All Calendars', 'script', NULL),
(151, 'lblInstallConfigCalendar', 'backend', 'Install / Calendar', 'script', NULL),
(152, 'lblInstallConfigLang', 'backend', 'Install / Language icons', 'script', NULL),
(153, 'lblInstallConfigLocale', 'backend', 'Install / Language', 'script', NULL),
(154, 'lblInstallConfigMonths', 'backend', 'Install / Months', 'script', NULL),
(155, 'lblInstallInfoDesc', 'backend', 'Install / Info description', 'script', NULL),
(156, 'lblInstallInfoTitle', 'backend', 'Install / Info title', 'script', NULL),
(157, 'lblInstallNoteDesc', 'backend', 'Install / Note description', 'script', NULL),
(158, 'lblInstallNoteTitle', 'backend', 'Install / Note title', 'script', NULL),
(159, 'lblInstallPreview', 'backend', 'Install / Preview', 'script', NULL),
(160, 'lblIp', 'backend', 'IP address', 'script', NULL),
(161, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(162, 'lblListingConfirmEmail', 'backend', 'Listing / Confirm email', 'script', NULL),
(163, 'lblListingConfirmTokens', 'backend', 'Listing / Confirm Tokens', 'script', NULL),
(164, 'lblListingNotFound', 'backend', 'Listing / No properties found', 'script', NULL),
(165, 'lblListingPaymentEmail', 'backend', 'Listing / Payment email', 'script', NULL),
(166, 'lblListingPaymentTokens', 'backend', 'Listing / Payment Tokens', 'script', NULL),
(167, 'lblMaximum', 'backend', 'Label / maximum', 'script', NULL),
(168, 'lblMaximumCount', 'backend', 'Label / maximum count', 'script', NULL),
(169, 'lblMaxPeopleMsg', 'backend', 'Label / Maximum people per reservation', 'script', NULL),
(170, 'lblMaxValue', 'backend', 'Options / Max value', 'script', NULL),
(171, 'lblMinimum', 'backend', 'Label / minimum', 'script', NULL),
(172, 'lblMinPeopleMsg', 'backend', 'Label / Minimum people per reservation', 'script', NULL),
(173, 'lblMore', 'backend', 'More', 'script', NULL),
(174, 'lblMultiQuantity', 'backend', 'Label / Multi quantity', 'script', NULL),
(175, 'lblNA', 'backend', 'Reservation / n/a', 'script', NULL),
(176, 'lblName', 'backend', 'Name', 'script', NULL),
(177, 'lblNightsPrice', 'backend', 'Label / Nights price', 'script', NULL),
(178, 'lblNoAccessToFeed', 'backend', 'Label / No access to feed', 'script', NULL),
(179, 'lblNotifyEmail', 'backend', 'User / Email notifications', 'script', NULL),
(180, 'lblNotifySms', 'backend', 'User / Sms notifications', 'script', NULL),
(181, 'lblOption', 'backend', 'Option', 'script', NULL),
(182, 'lblOptionCopy', 'backend', 'Option', 'script', NULL),
(183, 'lblOptionCopyDesc', 'backend', 'Option / Copy dialog description', 'script', NULL),
(184, 'lblOptionCopyTip', 'backend', 'Option / Copy tooltip', 'script', NULL),
(185, 'lblOptionCopyTitle', 'backend', 'Option / Copy dialog title', 'script', NULL),
(186, 'lblOptionsTermsContent', 'backend', 'Options / Booking terms content', 'script', NULL),
(187, 'lblOptionsTermsURL', 'backend', 'Options / Booking terms URL', 'script', NULL),
(188, 'lblPeriod', 'backend', 'Label / Period', 'script', NULL),
(189, 'lblPhone', 'backend', 'Phone', 'script', NULL),
(190, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(191, 'lblQty', 'backend', 'label / Qty', 'script', NULL),
(192, 'lblRemoveFilter', 'backend', 'Label / Remove filter', 'script', NULL),
(193, 'lblRequired', 'backend', 'Label / Required', 'script', NULL),
(194, 'lblReservationAddress', 'backend', 'Reservation / Address', 'script', NULL),
(195, 'lblReservationAdults', 'backend', 'Reservation / Adults', 'script', NULL),
(196, 'lblReservationAmount', 'backend', 'Reservation / Amount', 'script', NULL),
(197, 'lblReservationCalendar', 'backend', 'Reservation / Calendar', 'script', NULL),
(198, 'lblReservationCancel', 'backend', 'Label / Send Cancellation Email', 'script', NULL),
(199, 'lblReservationCCCode', 'backend', 'Reservation / CC Code', 'script', NULL),
(200, 'lblReservationCCExp', 'backend', 'Reservation / CC Expiration date', 'script', NULL),
(201, 'lblReservationCCNum', 'backend', 'Reservation / CC Number', 'script', NULL),
(202, 'lblReservationCCType', 'backend', 'Reservation / CC Type', 'script', NULL),
(203, 'lblReservationChildren', 'backend', 'Reservation / Children', 'script', NULL),
(204, 'lblReservationCity', 'backend', 'Reservation / City', 'script', NULL),
(205, 'lblReservationClientInfo', 'backend', 'Reservation / Client details', 'script', NULL),
(206, 'lblReservationCountry', 'backend', 'Reservation / Country', 'script', NULL),
(207, 'lblReservationCreated', 'backend', 'Reservation / Date&Time made', 'script', NULL),
(208, 'lblReservationCreateInvoice', 'backend', 'Create Invoice', 'script', NULL),
(209, 'lblReservationDateRangeValidation', 'backend', 'Reservation / Date range validation', 'script', NULL),
(210, 'lblReservationDeposit', 'backend', 'Reservation / Deposit', 'script', NULL),
(211, 'lblReservationDetails', 'backend', 'Reservation / Details', 'script', NULL),
(212, 'lblReservationDiscountAmount', 'backend', 'Label / Discount amount', 'script', NULL),
(213, 'lblReservationEmail', 'backend', 'Reservation / Email', 'script', NULL),
(214, 'lblReservationExtraPrice', 'backend', 'Label / Extra price', 'script', NULL),
(215, 'lblReservationFilterDates', 'backend', 'Reservation / Reserved dates', 'script', NULL),
(216, 'lblReservationFindInvoices', 'backend', 'Find Invoices', 'script', NULL),
(217, 'lblReservationFrom', 'backend', 'Reservation / From', 'script', NULL),
(218, 'lblReservationInfo', 'backend', 'Reservation / Details', 'script', NULL),
(219, 'lblReservationInvoice', 'backend', 'Reservations / Invoice', 'script', NULL),
(220, 'lblReservationInvoiceDetails', 'backend', 'Invoice Details', 'script', NULL),
(221, 'lblReservationInvoices', 'backend', 'Reservation / Invoices', 'script', NULL),
(222, 'lblReservationName', 'backend', 'Reservation / Name', 'script', NULL),
(223, 'lblReservationNext30', 'backend', 'Reservation / Next 30 days', 'script', NULL),
(224, 'lblReservationNextMonth', 'backend', 'Reservation / Next Month', 'script', NULL),
(225, 'lblReservationNotes', 'backend', 'Reservation / Notes', 'script', NULL),
(226, 'lblReservationNotFound', 'backend', 'Reservation / No reservations found', 'script', NULL),
(227, 'lblReservationPayment', 'backend', 'Reservation / Payment', 'script', NULL),
(228, 'lblReservationPhone', 'backend', 'Reservation / Phone', 'script', NULL),
(229, 'lblReservationPlaceholderSearch', 'backend', 'Reservations / Enter name or email', 'script', NULL),
(230, 'lblReservationPrev30', 'backend', 'Reservation / Previous 30 days', 'script', NULL),
(231, 'lblReservationPrevMonth', 'backend', 'Reservation / Previous month', 'script', NULL),
(232, 'lblReservationPrice', 'backend', 'Label / Price', 'script', NULL),
(233, 'lblReservationPromoAmount', 'backend', 'Label / Promo amount', 'script', NULL),
(234, 'lblReservationPromoCode', 'backend', 'Label / Promo code', 'script', NULL),
(235, 'lblReservationResend', 'backend', 'Reservation / Resend', 'script', NULL),
(236, 'lblReservations', 'backend', 'Label / Reservations', 'script', NULL),
(237, 'lblReservationSecurity', 'backend', 'Reservation / Security', 'script', NULL),
(238, 'lblReservationsFeedURL', 'backend', 'Label / Reservations Feed URL', 'script', NULL),
(239, 'lblReservationsMade', 'backend', 'Label / reservations made', 'script', NULL),
(240, 'lblReservationState', 'backend', 'Reservation / State', 'script', NULL),
(241, 'lblReservationStatus', 'backend', 'Reservation / Status', 'script', NULL),
(242, 'lblReservationTax', 'backend', 'Reservation / Tax', 'script', NULL),
(243, 'lblReservationTo', 'backend', 'Reservation / To', 'script', NULL),
(244, 'lblReservationTotal', 'backend', 'Label / Total', 'script', NULL),
(245, 'lblReservationTouristTax', 'backend', 'Label / Tourist tax', 'script', NULL),
(246, 'lblReservationUuid', 'backend', 'Reservation / Unique ID', 'script', NULL),
(247, 'lblReservationZip', 'backend', 'Reservation / Zip', 'script', NULL),
(248, 'lblRevertStatus', 'backend', 'Revert status', 'script', NULL),
(249, 'lblRole', 'backend', 'Role', 'script', NULL),
(250, 'lblStatus', 'backend', 'Status', 'script', NULL),
(251, 'lblTo', 'backend', 'Label / to', 'script', NULL),
(252, 'lblToBePaid', 'backend', 'Label / to be paid', 'script', NULL),
(253, 'lblToBeUsedIn', 'backend', 'Label / To be used in', 'script', NULL),
(254, 'lblToday', 'backend', 'Today', 'script', NULL),
(255, 'lblTotalReservations', 'backend', 'Label / Total reservations', 'script', NULL),
(256, 'lblTouristTaxPerDay', 'backend', 'Label / Tourist tax per person per day', 'script', NULL),
(257, 'lblTouristTaxPerNight', 'backend', 'Label / Tourist tax per person per night', 'script', NULL),
(258, 'lblType', 'backend', 'Label / Type', 'script', NULL),
(259, 'lblUpdateCalendar', 'backend', 'Calendars / Update calendar', 'script', NULL),
(260, 'lblUpdateReservation', 'backend', 'Update reservation', 'script', NULL),
(261, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(262, 'lblUser', 'backend', 'User', 'script', NULL),
(263, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(264, 'lblUserEmailTip', 'backend', 'User / Email notifications tip', 'script', NULL),
(265, 'lblUserRoleTip', 'backend', 'User / Role tip', 'script', NULL),
(266, 'lblUserSmsTip', 'backend', 'User / Sms notifications tip', 'script', NULL),
(267, 'lblValid', 'backend', 'Label / Valid', 'script', NULL),
(268, 'lblValue', 'backend', 'Value', 'script', NULL),
(269, 'lblViewCalendar', 'backend', 'Calendars / View calendar', 'script', NULL),
(270, 'lblViewReservations', 'backend', 'Reservation / View reservations', 'script', NULL),
(271, 'lblVoucherCode', 'backend', 'Label / Coupon code', 'script', NULL),
(272, 'lblVoucherCodeExist', 'backend', 'label / Coupon code is already used.', 'script', NULL),
(273, 'lblWeekTitle', 'backend', 'week', 'script', NULL),
(274, 'limit_add', 'backend', 'Limits / Add a limit', 'script', NULL),
(275, 'limit_days', 'backend', 'Limit / Days', 'script', NULL),
(276, 'limit_from', 'backend', 'Limits / From', 'script', NULL),
(277, 'limit_max', 'backend', 'Limits / Max length', 'script', NULL),
(278, 'limit_min', 'backend', 'Limits / Min length', 'script', NULL),
(279, 'limit_nights', 'backend', 'Limit / Nights', 'script', NULL),
(280, 'limit_to', 'backend', 'Limits / To', 'script', NULL),
(281, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(282, 'menuAppearance', 'backend', 'Menu Appearance', 'script', NULL),
(283, 'menuAvailability', 'backend', 'Menu Availability', 'script', NULL),
(284, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(285, 'menuBookingForm', 'backend', 'Menu Booking Form', 'script', NULL),
(286, 'menuBookings', 'backend', 'Menu Bookings', 'script', NULL),
(287, 'menuCalendar', 'backend', 'Menu Calendar', 'script', NULL),
(288, 'menuCalendars', 'backend', 'Menu Calendars', 'script', NULL),
(289, 'menuConfirmation', 'backend', 'Menu Confirmation', 'script', NULL),
(290, 'menuCouponsDiscounts', 'backend', 'Menu / Coupons & Discounts', 'script', NULL),
(291, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(292, 'menuExtras', 'backend', 'Menu / Extras', 'script', NULL),
(293, 'menuGeneral', 'backend', 'Menu General', 'script', NULL),
(294, 'menuInstall', 'backend', 'Menu Install', 'script', NULL),
(295, 'menuInstallPreview', 'backend', 'Menu Install & Preview', 'script', NULL),
(296, 'menuLimits', 'backend', 'Menu Limits', 'script', NULL),
(297, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(298, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(299, 'menuNotifications', 'backend', 'Menu Notifications', 'script', NULL),
(300, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(301, 'menuPayments', 'backend', 'Menu Payments', 'script', NULL),
(302, 'menuPreview', 'backend', 'Menu Preview', 'script', NULL),
(303, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(304, 'menuReservations', 'backend', 'Menu Reservations', 'script', NULL),
(305, 'menuSettings', 'backend', 'Menu Settings', 'script', NULL),
(306, 'menuTerms', 'backend', 'Menu Terms', 'script', NULL),
(307, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(308, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(309, 'opt_body_forgot_password', 'backend', 'Notifications / Body', 'script', NULL),
(310, 'opt_body_new_reservation', 'backend', 'Notifications / Body', 'script', NULL),
(311, 'opt_o_accept_bookings', 'backend', 'Options / Accept Bookings', 'script', NULL),
(312, 'opt_o_allow_add_property', 'backend', 'Options / Allow users to add properties', 'script', NULL),
(313, 'opt_o_allow_authorize', 'backend', 'Options / Allow Authorize.net', 'script', NULL),
(314, 'opt_o_allow_bank', 'backend', 'Options / Allow Bank', 'script', NULL),
(315, 'opt_o_allow_cash', 'backend', 'Options / Allow payment with cash', 'script', NULL),
(316, 'opt_o_allow_creditcard', 'backend', 'Options / Allow Credit Card', 'script', NULL),
(317, 'opt_o_allow_paypal', 'backend', 'Options / Allow Paypal', 'script', NULL),
(318, 'opt_o_authorize_hash', 'backend', 'Options / Authorize.net hash value', 'script', NULL),
(319, 'opt_o_authorize_key', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(320, 'opt_o_authorize_mid', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(321, 'opt_o_authorize_tz', 'backend', 'Options / Authorize.net Time zone', 'script', NULL),
(322, 'opt_o_background_available', 'backend', 'Options / Available dates', 'script', NULL),
(323, 'opt_o_background_booked', 'backend', 'Options / Booked dates', 'script', NULL),
(324, 'opt_o_background_empty', 'backend', 'Options / Empty slots', 'script', NULL),
(325, 'opt_o_background_month', 'backend', 'Options / Month Background', 'script', NULL),
(326, 'opt_o_background_nav', 'backend', 'Options / Month Nav Background', 'script', NULL),
(327, 'opt_o_background_nav_hover', 'backend', 'Options / Month Nav Hover Background', 'script', NULL),
(328, 'opt_o_background_past', 'backend', 'Options / Past dates color', 'script', NULL),
(329, 'opt_o_background_pending', 'backend', 'Options / Pending reservation dates', 'script', NULL),
(330, 'opt_o_background_select', 'backend', 'Options / Current reservation selected dates', 'script', NULL),
(331, 'opt_o_background_weekday', 'backend', 'Options / Week Days background', 'script', NULL),
(332, 'opt_o_bank_account', 'backend', 'Options / Bank account', 'script', NULL),
(333, 'opt_o_bf_address', 'backend', 'Options / Address', 'script', NULL),
(334, 'opt_o_bf_adults', 'backend', 'Options / Adults', 'script', NULL),
(335, 'opt_o_bf_adults_max', 'backend', 'Options / People per reservation', 'script', NULL),
(336, 'opt_o_bf_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(337, 'opt_o_bf_children', 'backend', 'Options / Children', 'script', NULL),
(338, 'opt_o_bf_city', 'backend', 'Options / City', 'script', NULL),
(339, 'opt_o_bf_country', 'backend', 'Options / Country', 'script', NULL),
(340, 'opt_o_bf_email', 'backend', 'Options / Email', 'script', NULL),
(341, 'opt_o_bf_name', 'backend', 'Options / Name', 'script', NULL),
(342, 'opt_o_bf_notes', 'backend', 'Options / Notes', 'script', NULL),
(343, 'opt_o_bf_phone', 'backend', 'Options / Phone', 'script', NULL),
(344, 'opt_o_bf_state', 'backend', 'Options / State', 'script', NULL),
(345, 'opt_o_bf_terms', 'backend', 'Options / Terms', 'script', NULL),
(346, 'opt_o_bf_zip', 'backend', 'Options / Zip', 'script', NULL),
(347, 'opt_o_bookings_per_day', 'backend', 'Bookings per day', 'script', NULL),
(348, 'opt_o_booking_behavior', 'backend', 'Options / Booking behavior', 'script', NULL),
(349, 'opt_o_border_inner', 'backend', 'Options / Inner border color', 'script', NULL),
(350, 'opt_o_border_inner_size', 'backend', 'Options / Inner border size', 'script', NULL),
(351, 'opt_o_border_outer', 'backend', 'Options / Outer border color', 'script', NULL),
(352, 'opt_o_border_outer_size', 'backend', 'Options / Outer border size', 'script', NULL),
(353, 'opt_o_cancel_url', 'backend', 'Options / Cancel booking page', 'script', NULL),
(354, 'opt_o_color_available', 'backend', 'Options / Available dates color', 'script', NULL),
(355, 'opt_o_color_booked', 'backend', 'Options / Booked dates color', 'script', NULL),
(356, 'opt_o_color_legend', 'backend', 'Options / Legend color', 'script', NULL),
(357, 'opt_o_color_month', 'backend', 'Options / Month color', 'script', NULL),
(358, 'opt_o_color_past', 'backend', 'Options / Past dates color', 'script', NULL),
(359, 'opt_o_color_pending', 'backend', 'Options / Pending Days color', 'script', NULL),
(360, 'opt_o_color_weekday', 'backend', 'Options / Week Days color', 'script', NULL),
(361, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(362, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(363, 'opt_o_deposit', 'backend', 'Options / Deposit', 'script', NULL),
(364, 'opt_o_disable_payments', 'backend', 'Options / Disable payments', 'script', NULL),
(365, 'opt_o_email_new_reservation', 'backend', 'Options / New reservation received', 'script', NULL),
(366, 'opt_o_email_password_reminder', 'backend', 'Notifications / Password reminder', 'script', NULL),
(367, 'opt_o_email_reservation_cancelled', 'backend', 'Options / Reservation cancelled', 'script', NULL),
(368, 'opt_o_floor', 'backend', 'Options / Floor metrics', 'script', NULL),
(369, 'opt_o_font_family', 'backend', 'Options / Font family', 'script', NULL),
(370, 'opt_o_font_family_legend', 'backend', 'Options / Font family Legend', 'script', NULL),
(371, 'opt_o_font_size_available', 'backend', 'Options / Available dates font size', 'script', NULL),
(372, 'opt_o_font_size_booked', 'backend', 'Options / Booked dates font size', 'script', NULL),
(373, 'opt_o_font_size_legend', 'backend', 'Options / Legend font size', 'script', NULL),
(374, 'opt_o_font_size_month', 'backend', 'Options / Month font size', 'script', NULL),
(375, 'opt_o_font_size_past', 'backend', 'Options / Past dates font size', 'script', NULL),
(376, 'opt_o_font_size_pending', 'backend', 'Options / Pending days font size', 'script', NULL),
(377, 'opt_o_font_size_weekday', 'backend', 'Options / Weekdays font size', 'script', NULL),
(378, 'opt_o_font_style_available', 'backend', 'Options / Available dates font style', 'script', NULL),
(379, 'opt_o_font_style_booked', 'backend', 'Options / Booked dates font style', 'script', NULL),
(380, 'opt_o_font_style_legend', 'backend', 'Options / Legend font style', 'script', NULL),
(381, 'opt_o_font_style_month', 'backend', 'Options / Month font style', 'script', NULL),
(382, 'opt_o_font_style_past', 'backend', 'Options / Past dates font style', 'script', NULL),
(383, 'opt_o_font_style_pending', 'backend', 'Options / Pending days font style', 'script', NULL),
(384, 'opt_o_font_style_weekday', 'backend', 'Options / Weekdays font style', 'script', NULL),
(385, 'opt_o_is_active_owner', 'backend', 'Options / User account confirmed by default', 'script', NULL),
(386, 'opt_o_layout', 'backend', 'Options / Select layout', 'script', NULL),
(387, 'opt_o_limit_featured_results', 'backend', 'Options / Featured properties', 'script', NULL),
(388, 'opt_o_max_people', 'backend', 'Options / Maximum people per reservation', 'script', NULL),
(389, 'opt_o_max_tax', 'backend', 'Options / maximum total tax per reservation', 'script', NULL),
(390, 'opt_o_min_people', 'backend', 'Options / Minimum people per reservation', 'script', NULL),
(391, 'opt_o_month_year_format', 'backend', 'Options / Month / Year format', 'script', NULL),
(392, 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
(393, 'opt_o_per_page', 'backend', 'Options / Items per page', 'script', NULL),
(394, 'opt_o_price_based_on', 'backend', 'Options / Reservations and price basedon days or nights', 'script', NULL),
(395, 'opt_o_price_plugin', 'backend', 'Options / Set prices based on Day/Night OR Periods', 'script', NULL),
(396, 'opt_o_require_all_within', 'backend', 'Options / Require 100% if the reservations is within X days', 'script', NULL),
(397, 'opt_o_security', 'backend', 'Options / Security deposit payment', 'script', NULL),
(398, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(399, 'opt_o_show_legend', 'backend', 'Options / Show color legend', 'script', NULL),
(400, 'opt_o_show_prices', 'backend', 'Options / show prices', 'script', NULL),
(401, 'opt_o_show_week_numbers', 'backend', 'Options / Show week numbers', 'script', NULL),
(402, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(403, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(404, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(405, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(406, 'opt_o_status_if_not_paid', 'backend', 'Options / Default status for booked dates if not paid', 'script', NULL),
(407, 'opt_o_status_if_paid', 'backend', 'Options / Default status for booked dates if paid', 'script', NULL),
(408, 'opt_o_tax', 'backend', 'Options / Tax payment', 'script', NULL),
(409, 'opt_o_thankyou_page', 'backend', 'Options / "Thank you" page location', 'script', NULL),
(410, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(411, 'opt_o_tourist_tax', 'backend', 'Options / Tourist tax per person per night', 'script', NULL),
(412, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(413, 'opt_subject', 'backend', 'Notifications / Subject', 'script', NULL),
(414, 'pass', 'backend', 'Password', 'script', NULL),
(415, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(416, 'pj_number_validation', 'backend', 'Label / Please enter a valid number.', 'script', NULL),
(417, 'ResConfirmationText', 'backend', 'Reservation / Confirmation re-send', 'script', NULL),
(418, 'ResConfirmationTitle', 'backend', 'Reservation / Confirmation Title', 'script', NULL),
(419, 'reservations', 'backend', 'Label / reservations', 'script', NULL),
(420, 'reservation_balance_payment', 'backend', 'Reservations / Balance payment', 'script', NULL),
(421, 'reservation_calc_body', 'backend', 'Reservations / Calculate dialog - Content', 'script', NULL),
(422, 'reservation_calc_tip', 'backend', 'Reservations / Calculate tooltip', 'script', NULL),
(423, 'reservation_calc_title', 'backend', 'Reservations / Calculate dialog - Title', 'script', NULL),
(424, 'tabCoupons', 'backend', 'Tab / Coupons', 'script', NULL),
(425, 'tabDiscounts', 'backend', 'Tab / Discounts', 'script', NULL),
(426, 'tabEmails', 'backend', 'Tab / Emails', 'script', NULL),
(427, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(428, 'tabOneMonth', 'backend', 'Tab / 1 Month', 'script', NULL),
(429, 'tabSixMonth', 'backend', 'Tab / 6 Months', 'script', NULL),
(430, 'tabSms', 'backend', 'Tab / Sms', 'script', NULL),
(431, 'tabThreeMonth', 'backend', 'Tab / 3 Months', 'script', NULL),
(432, 'tabTwelveMonth', 'backend', 'Tab / 12 Months', 'script', NULL),
(433, 'bf_address', 'frontend', 'Booking form / Address', 'script', NULL),
(434, 'bf_adults', 'frontend', 'Booking form / Adults', 'script', NULL),
(435, 'bf_amount', 'frontend', 'Booking form / Amount', 'script', NULL),
(436, 'bf_bank_account', 'frontend', 'Booking form / Bank account', 'script', NULL),
(437, 'bf_booking', 'frontend', 'Booking form / Booking', 'script', NULL),
(438, 'bf_cancel', 'frontend', 'Booking form / Cancel', 'script', NULL),
(439, 'bf_captcha', 'frontend', 'Booking form / Captcha', 'script', NULL),
(440, 'bf_cc_exp', 'frontend', 'Booking form / CC Exp.date', 'script', NULL),
(441, 'bf_cc_num', 'frontend', 'Booking form / CC Number', 'script', NULL),
(442, 'bf_cc_sec', 'frontend', 'Booking form / CC Sec.code', 'script', NULL),
(443, 'bf_cc_type', 'frontend', 'Booking form / CC Type', 'script', NULL),
(444, 'bf_children', 'frontend', 'Booking form / Children', 'script', NULL),
(445, 'bf_city', 'frontend', 'Booking form / City', 'script', NULL),
(446, 'bf_continue', 'frontend', 'Booking form / Continue', 'script', NULL),
(447, 'bf_country', 'frontend', 'Booking form / Country', 'script', NULL),
(448, 'bf_day', 'frontend', 'Booking form / day', 'script', NULL),
(449, 'bf_days', 'frontend', 'Booking form / days', 'script', NULL),
(450, 'bf_deposit', 'frontend', 'Booking form / Deposit', 'script', NULL),
(451, 'bf_discount_amount', 'frontend', 'Label / Discount amount', 'script', NULL),
(452, 'bf_email', 'frontend', 'Booking form / Email', 'script', NULL),
(453, 'bf_end_date', 'frontend', 'Booking form / Departure', 'script', NULL),
(454, 'bf_extra_price', 'frontend', 'Label / Extra price', 'script', NULL),
(455, 'bf_name', 'frontend', 'Booking form / Name', 'script', NULL),
(456, 'bf_night', 'frontend', 'Booking form / night', 'script', NULL),
(457, 'bf_nights', 'frontend', 'Booking form / nights', 'script', NULL),
(458, 'bf_notes', 'frontend', 'Booking form / Notes', 'script', NULL),
(459, 'bf_payment', 'frontend', 'Booking form / Payment method', 'script', NULL),
(460, 'bf_payment_required', 'frontend', 'Booking form / Payment required', 'script', NULL),
(461, 'bf_phone', 'frontend', 'Booking form / Phone', 'script', NULL),
(462, 'bf_price', 'frontend', 'Booking form / Price', 'script', NULL),
(463, 'bf_price_after_promo', 'frontend', 'Label / Price after promo', 'script', NULL),
(464, 'bf_promo_amount', 'frontend', 'Label / Promo amount', 'script', NULL),
(465, 'bf_security', 'frontend', 'Booking form / Security deposit', 'script', NULL),
(466, 'bf_start_date', 'frontend', 'Booking form / Arrival', 'script', NULL),
(467, 'bf_state', 'frontend', 'Booking form / State', 'script', NULL),
(468, 'bf_subtotal', 'frontend', 'Label / Sub-total', 'script', NULL),
(469, 'bf_tax', 'frontend', 'Booking form / Tax', 'script', NULL),
(470, 'bf_terms', 'frontend', 'Booking form / Terms', 'script', NULL),
(471, 'bf_total', 'frontend', 'Booking form / Total price', 'script', NULL),
(472, 'bf_zip', 'frontend', 'Booking form / Zip', 'script', NULL),
(473, 'front_apply_promo_code', 'frontend', 'Label / Apply', 'script', NULL),
(474, 'front_availability_note', 'frontend', 'Frontend / Click on calendar', 'script', NULL),
(475, 'front_discount', 'frontend', 'Label / discount', 'script', NULL),
(476, 'front_enter_promo_code', 'frontend', 'Label / Enter promo code', 'script', NULL),
(477, 'front_extras', 'frontend', 'Label / Extras', 'script', NULL),
(478, 'front_extra_hint', 'frontend', 'Label / Extra hint', 'script', NULL),
(479, 'front_extra_name', 'frontend', 'Label / Extra name', 'script', NULL),
(480, 'front_extra_required_msg', 'frontend', 'Label / You need to select this extra.', 'script', NULL),
(481, 'front_for_1_day', 'frontend', 'Label / for 1 day', 'script', NULL),
(482, 'front_for_1_nights', 'frontend', 'Label / for 1 night', 'script', NULL),
(483, 'front_for_days', 'frontend', 'Label / for days', 'script', NULL),
(484, 'front_for_nights', 'frontend', 'Label / for nights', 'script', NULL),
(485, 'front_from_total_price', 'frontend', 'Label / from total price', 'script', NULL),
(486, 'front_invalid_promo_code', 'frontend', 'Label / Invalid promo code', 'script', NULL),
(487, 'front_max_people_msg', 'frontend', 'Label / Maximum people per reservation', 'script', NULL),
(488, 'front_min_people_msg', 'frontend', 'Label / Minimum people per reservation', 'script', NULL),
(489, 'front_paid_on_arrival', 'frontend', 'Label / to be paid on arrival', 'script', NULL),
(490, 'front_paid_when_booking', 'frontend', 'Label / to be paid when booking', 'script', NULL),
(491, 'front_payment_authorize_title', 'frontend', 'front_payment_authorize_title', 'script', NULL),
(492, 'front_payment_paypal_title', 'frontend', 'front_payment_paypal_title', 'script', NULL),
(493, 'front_per_person_per_day', 'frontend', 'Label / per person, per day', 'script', NULL),
(494, 'front_per_person_per_night', 'frontend', 'Label / per person, per night', 'script', NULL),
(495, 'front_price_for_selected_extras', 'frontend', 'Label / total price for selected extras', 'script', NULL),
(496, 'front_promo_code_used', 'frontend', 'Label / Promo code used', 'script', NULL),
(497, 'front_qty', 'frontend', 'Label / Qty', 'script', NULL),
(498, 'front_recalcualte_prices', 'frontend', 'Label / Re-calculate prices', 'script', NULL),
(499, 'front_start_over', 'frontend', 'Label / Start over', 'script', NULL),
(500, 'lblBackToCalendar', 'frontend', 'Back to calendar', 'script', NULL),
(501, 'lblBackToCalendars', 'frontend', 'Back to calendars', 'script', NULL),
(502, 'lblCalendarMessage', 'frontend', 'Calendar message', 'script', NULL),
(503, 'lblChangeDates', 'frontend', 'change dates', 'script', NULL),
(504, 'lblExport', 'frontend', 'Label / Export', 'script', NULL),
(505, 'lblPriceFrom', 'frontend', 'Price from', 'script', NULL),
(506, 'lblSecurityDeposit', 'frontend', 'Booking form / Security deposit', 'script', NULL),
(507, 'legend_available', 'frontend', 'Legend / Available', 'script', NULL),
(508, 'legend_booked', 'frontend', 'Legend / Booked', 'script', NULL),
(509, 'legend_past', 'frontend', 'Legend / Past', 'script', NULL),
(510, 'legend_pending', 'frontend', 'Legend / Pending', 'script', NULL),
(511, 'apply_conditions_ARRAY_both', 'arrays', 'apply_conditions_ARRAY_both', 'script', NULL),
(512, 'apply_conditions_ARRAY_made', 'arrays', 'apply_conditions_ARRAY_made', 'script', NULL),
(513, 'apply_conditions_ARRAY_period', 'arrays', 'apply_conditions_ARRAY_period', 'script', NULL),
(514, 'apply_on_ARRAY_both', 'arrays', 'apply_on_ARRAY_both', 'script', NULL),
(515, 'apply_on_ARRAY_extra', 'arrays', 'apply_on_ARRAY_extra', 'script', NULL),
(516, 'apply_on_ARRAY_room', 'arrays', 'apply_on_ARRAY_room', 'script', NULL),
(517, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(518, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(519, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(520, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(521, 'coming_arr_ARRAY_1', 'arrays', 'coming_arr_ARRAY_1', 'script', NULL),
(522, 'coming_arr_ARRAY_2', 'arrays', 'coming_arr_ARRAY_2', 'script', NULL),
(523, 'coming_arr_ARRAY_3', 'arrays', 'coming_arr_ARRAY_3', 'script', NULL),
(524, 'coming_arr_ARRAY_4', 'arrays', 'coming_arr_ARRAY_4', 'script', NULL),
(525, 'coming_arr_ARRAY_5', 'arrays', 'coming_arr_ARRAY_5', 'script', NULL),
(526, 'coming_arr_ARRAY_6', 'arrays', 'coming_arr_ARRAY_6', 'script', NULL),
(527, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(528, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(529, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(530, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(531, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(532, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(533, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(534, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_sun', 'script', NULL),
(535, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_mon', 'script', NULL),
(536, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_tue', 'script', NULL),
(537, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_wed', 'script', NULL),
(538, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_thu', 'script', NULL),
(539, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_fri', 'script', NULL),
(540, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_sat', 'script', NULL),
(541, 'day_price_types_ARRAY_count', 'arrays', 'day_price_types_ARRAY_count', 'script', NULL),
(542, 'day_price_types_ARRAY_count_night', 'arrays', 'day_price_types_ARRAY_count_night', 'script', NULL),
(543, 'day_price_types_ARRAY_night', 'arrays', 'day_price_types_ARRAY_night', 'script', NULL),
(544, 'day_price_types_ARRAY_one_time', 'arrays', 'day_price_types_ARRAY_one_time', 'script', NULL),
(545, 'day_price_types_ARRAY_person', 'arrays', 'day_price_types_ARRAY_person', 'script', NULL),
(546, 'day_price_types_ARRAY_person_night', 'arrays', 'day_price_types_ARRAY_person_night', 'script', NULL),
(547, 'discount_options_ARRAY_duration', 'arrays', 'discount_options_ARRAY_duration', 'script', NULL),
(548, 'discount_options_ARRAY_early', 'arrays', 'discount_options_ARRAY_early', 'script', NULL),
(549, 'discount_options_ARRAY_family', 'arrays', 'discount_options_ARRAY_family', 'script', NULL),
(550, 'discount_options_ARRAY_persons', 'arrays', 'discount_options_ARRAY_persons', 'script', NULL),
(551, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(552, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(553, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(554, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(555, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(556, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(557, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(558, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(559, 'error_bodies_ARRAY_ACR01', 'arrays', 'error_bodies_ARRAY_ACR01', 'script', NULL),
(560, 'error_bodies_ARRAY_ACR03', 'arrays', 'error_bodies_ARRAY_ACR03', 'script', NULL),
(561, 'error_bodies_ARRAY_ACR04', 'arrays', 'error_bodies_ARRAY_ACR04', 'script', NULL),
(562, 'error_bodies_ARRAY_ACR08', 'arrays', 'error_bodies_ARRAY_ACR08', 'script', NULL),
(563, 'error_bodies_ARRAY_ACR10', 'arrays', 'error_bodies_ARRAY_ACR10', 'script', NULL),
(564, 'error_bodies_ARRAY_ACR11', 'arrays', 'error_bodies_ARRAY_ACR11', 'script', NULL),
(565, 'error_bodies_ARRAY_ACR12', 'arrays', 'error_bodies_ARRAY_ACR12', 'script', NULL),
(566, 'error_bodies_ARRAY_AD01', 'arrays', 'error_bodies_ARRAY_AD01', 'script', NULL),
(567, 'error_bodies_ARRAY_AD03', 'arrays', 'error_bodies_ARRAY_AD03', 'script', NULL),
(568, 'error_bodies_ARRAY_AD04', 'arrays', 'error_bodies_ARRAY_AD04', 'script', NULL),
(569, 'error_bodies_ARRAY_AD08', 'arrays', 'error_bodies_ARRAY_AD08', 'script', NULL),
(570, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(571, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(572, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(573, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(574, 'error_bodies_ARRAY_AL01', 'arrays', 'error_bodies_ARRAY_AL01', 'script', NULL),
(575, 'error_bodies_ARRAY_AL08', 'arrays', 'error_bodies_ARRAY_AL08', 'script', NULL),
(576, 'error_bodies_ARRAY_AL09', 'arrays', 'error_bodies_ARRAY_AL09', 'script', NULL),
(577, 'error_bodies_ARRAY_AL10', 'arrays', 'error_bodies_ARRAY_AL10', 'script', NULL),
(578, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(579, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(580, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(581, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(582, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(583, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(584, 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', NULL),
(585, 'error_bodies_ARRAY_AO07', 'arrays', 'error_bodies_ARRAY_AO07', 'script', NULL),
(586, 'error_bodies_ARRAY_AO08', 'arrays', 'error_bodies_ARRAY_AO08', 'script', NULL),
(587, 'error_bodies_ARRAY_AO10', 'arrays', 'error_bodies_ARRAY_AO10', 'script', NULL),
(588, 'error_bodies_ARRAY_AO11', 'arrays', 'error_bodies_ARRAY_AO11', 'script', NULL),
(589, 'error_bodies_ARRAY_AO22', 'arrays', 'error_bodies_ARRAY_AO22', 'script', NULL),
(590, 'error_bodies_ARRAY_AO23', 'arrays', 'error_bodies_ARRAY_AO23', 'script', NULL),
(591, 'error_bodies_ARRAY_AO24', 'arrays', 'error_bodies_ARRAY_AO24', 'script', NULL),
(592, 'error_bodies_ARRAY_AO25', 'arrays', 'error_bodies_ARRAY_AO25', 'script', NULL),
(593, 'error_bodies_ARRAY_AO26', 'arrays', 'error_bodies_ARRAY_AO26', 'script', NULL),
(594, 'error_bodies_ARRAY_AO27', 'arrays', 'error_bodies_ARRAY_AO27', 'script', NULL),
(595, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(596, 'error_bodies_ARRAY_AR02', 'arrays', 'error_bodies_ARRAY_AR02', 'script', NULL),
(597, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(598, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(599, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(600, 'error_bodies_ARRAY_AR09', 'arrays', 'error_bodies_ARRAY_AR09', 'script', NULL),
(601, 'error_bodies_ARRAY_AR10', 'arrays', 'error_bodies_ARRAY_AR10', 'script', NULL),
(602, 'error_bodies_ARRAY_AR11', 'arrays', 'error_bodies_ARRAY_AR11', 'script', NULL),
(603, 'error_bodies_ARRAY_AR12', 'arrays', 'error_bodies_ARRAY_AR12', 'script', NULL),
(604, 'error_bodies_ARRAY_AR13', 'arrays', 'error_bodies_ARRAY_AR13', 'script', NULL),
(605, 'error_bodies_ARRAY_AR14', 'arrays', 'error_bodies_ARRAY_AR14', 'script', NULL),
(606, 'error_bodies_ARRAY_AR15', 'arrays', 'error_bodies_ARRAY_AR15', 'script', NULL),
(607, 'error_bodies_ARRAY_AR16', 'arrays', 'error_bodies_ARRAY_AR16', 'script', NULL),
(608, 'error_bodies_ARRAY_AR17', 'arrays', 'error_bodies_ARRAY_AR17', 'script', NULL),
(609, 'error_bodies_ARRAY_AR18', 'arrays', 'error_bodies_ARRAY_AR18', 'script', NULL),
(610, 'error_bodies_ARRAY_AR19', 'arrays', 'error_bodies_ARRAY_AR19', 'script', NULL),
(611, 'error_bodies_ARRAY_AR20', 'arrays', 'error_bodies_ARRAY_AR20', 'script', NULL),
(612, 'error_bodies_ARRAY_AR21', 'arrays', 'error_bodies_ARRAY_AR21', 'script', NULL),
(613, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(614, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(615, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(616, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(617, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(618, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(619, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(620, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(621, 'error_bodies_ARRAY_AU10', 'arrays', 'error_bodies_ARRAY_AU10', 'script', NULL),
(622, 'error_bodies_ARRAY_AU11', 'arrays', 'error_bodies_ARRAY_AU11', 'script', NULL),
(623, 'error_bodies_ARRAY_AU20', 'arrays', 'error_bodies_ARRAY_AU20', 'script', NULL),
(624, 'error_bodies_ARRAY_AV01', 'arrays', 'error_bodies_ARRAY_AV01', 'script', NULL),
(625, 'error_bodies_ARRAY_AV03', 'arrays', 'error_bodies_ARRAY_AV03', 'script', NULL),
(626, 'error_bodies_ARRAY_AV04', 'arrays', 'error_bodies_ARRAY_AV04', 'script', NULL),
(627, 'error_bodies_ARRAY_AV08', 'arrays', 'error_bodies_ARRAY_AV08', 'script', NULL),
(628, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(629, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(630, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(631, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(632, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(633, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(634, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(635, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(636, 'error_titles_ARRAY_ACR01', 'arrays', 'error_titles_ARRAY_ACR01', 'script', NULL),
(637, 'error_titles_ARRAY_ACR03', 'arrays', 'error_titles_ARRAY_ACR03', 'script', NULL),
(638, 'error_titles_ARRAY_ACR04', 'arrays', 'error_titles_ARRAY_ACR04', 'script', NULL),
(639, 'error_titles_ARRAY_ACR08', 'arrays', 'error_titles_ARRAY_ACR08', 'script', NULL),
(640, 'error_titles_ARRAY_ACR10', 'arrays', 'error_titles_ARRAY_ACR10', 'script', NULL),
(641, 'error_titles_ARRAY_ACR11', 'arrays', 'error_titles_ARRAY_ACR11', 'script', NULL),
(642, 'error_titles_ARRAY_ACR12', 'arrays', 'error_titles_ARRAY_ACR12', 'script', NULL),
(643, 'error_titles_ARRAY_AD01', 'arrays', 'error_titles_ARRAY_AD01', 'script', NULL),
(644, 'error_titles_ARRAY_AD03', 'arrays', 'error_titles_ARRAY_AD03', 'script', NULL),
(645, 'error_titles_ARRAY_AD04', 'arrays', 'error_titles_ARRAY_AD04', 'script', NULL),
(646, 'error_titles_ARRAY_AD08', 'arrays', 'error_titles_ARRAY_AD08', 'script', NULL),
(647, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(648, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(649, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(650, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
(651, 'error_titles_ARRAY_AL01', 'arrays', 'error_titles_ARRAY_AL01', 'script', NULL),
(652, 'error_titles_ARRAY_AL08', 'arrays', 'error_titles_ARRAY_AL08', 'script', NULL),
(653, 'error_titles_ARRAY_AL09', 'arrays', 'error_titles_ARRAY_AL09', 'script', NULL),
(654, 'error_titles_ARRAY_AL10', 'arrays', 'error_titles_ARRAY_AL10', 'script', NULL),
(655, 'error_titles_ARRAY_ALC01', 'arrays', 'error_titles_ARRAY_ALC01', 'script', NULL),
(656, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(657, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(658, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(659, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(660, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(661, 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', NULL),
(662, 'error_titles_ARRAY_AO07', 'arrays', 'error_titles_ARRAY_AO07', 'script', NULL),
(663, 'error_titles_ARRAY_AO08', 'arrays', 'error_titles_ARRAY_AO08', 'script', NULL),
(664, 'error_titles_ARRAY_AO10', 'arrays', 'error_titles_ARRAY_AO10', 'script', NULL),
(665, 'error_titles_ARRAY_AO11', 'arrays', 'error_titles_ARRAY_AO11', 'script', NULL),
(666, 'error_titles_ARRAY_AO22', 'arrays', 'error_titles_ARRAY_AO22', 'script', NULL),
(667, 'error_titles_ARRAY_AO23', 'arrays', 'error_titles_ARRAY_AO23', 'script', NULL),
(668, 'error_titles_ARRAY_AO24', 'arrays', 'error_titles_ARRAY_AO24', 'script', NULL),
(669, 'error_titles_ARRAY_AO25', 'arrays', 'error_titles_ARRAY_AO25', 'script', NULL),
(670, 'error_titles_ARRAY_AO26', 'arrays', 'error_titles_ARRAY_AO26', 'script', NULL),
(671, 'error_titles_ARRAY_AO27', 'arrays', 'error_titles_ARRAY_AO27', 'script', NULL),
(672, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(673, 'error_titles_ARRAY_AR02', 'arrays', 'error_titles_ARRAY_AR02', 'script', NULL),
(674, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(675, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(676, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(677, 'error_titles_ARRAY_AR09', 'arrays', 'error_titles_ARRAY_AR09', 'script', NULL),
(678, 'error_titles_ARRAY_AR10', 'arrays', 'error_titles_ARRAY_AR10', 'script', NULL),
(679, 'error_titles_ARRAY_AR11', 'arrays', 'error_titles_ARRAY_AR11', 'script', NULL),
(680, 'error_titles_ARRAY_AR12', 'arrays', 'error_titles_ARRAY_AR12', 'script', NULL),
(681, 'error_titles_ARRAY_AR13', 'arrays', 'error_titles_ARRAY_AR13', 'script', NULL),
(682, 'error_titles_ARRAY_AR14', 'arrays', 'error_titles_ARRAY_AR14', 'script', NULL),
(683, 'error_titles_ARRAY_AR15', 'arrays', 'error_titles_ARRAY_AR15', 'script', NULL),
(684, 'error_titles_ARRAY_AR16', 'arrays', 'error_titles_ARRAY_AR16', 'script', NULL),
(685, 'error_titles_ARRAY_AR17', 'arrays', 'error_titles_ARRAY_AR17', 'script', NULL),
(686, 'error_titles_ARRAY_AR18', 'arrays', 'error_titles_ARRAY_AR18', 'script', NULL),
(687, 'error_titles_ARRAY_AR19', 'arrays', 'error_titles_ARRAY_AR19', 'script', NULL),
(688, 'error_titles_ARRAY_AR20', 'arrays', 'error_titles_ARRAY_AR20', 'script', NULL),
(689, 'error_titles_ARRAY_AR21', 'arrays', 'error_titles_ARRAY_AR21', 'script', NULL),
(690, 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
(691, 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
(692, 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
(693, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(694, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(695, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(696, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(697, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(698, 'error_titles_ARRAY_AU10', 'arrays', 'error_titles_ARRAY_AU10', 'script', NULL),
(699, 'error_titles_ARRAY_AU11', 'arrays', 'error_titles_ARRAY_AU11', 'script', NULL),
(700, 'error_titles_ARRAY_AU20', 'arrays', 'error_titles_ARRAY_AU20', 'script', NULL),
(701, 'error_titles_ARRAY_AV01', 'arrays', 'error_titles_ARRAY_AV01', 'script', NULL),
(702, 'error_titles_ARRAY_AV03', 'arrays', 'error_titles_ARRAY_AV03', 'script', NULL),
(703, 'error_titles_ARRAY_AV04', 'arrays', 'error_titles_ARRAY_AV04', 'script', NULL),
(704, 'error_titles_ARRAY_AV08', 'arrays', 'error_titles_ARRAY_AV08', 'script', NULL),
(705, 'export_formats_ARRAY_csv', 'arrays', 'export_formats_ARRAY_csv', 'script', NULL),
(706, 'export_formats_ARRAY_ical', 'arrays', 'export_formats_ARRAY_ical', 'script', NULL),
(707, 'export_formats_ARRAY_xml', 'arrays', 'export_formats_ARRAY_xml', 'script', NULL),
(708, 'export_periods_ARRAY_all', 'arrays', 'export_periods_ARRAY_all', 'script', NULL),
(709, 'export_periods_ARRAY_last', 'arrays', 'export_periods_ARRAY_last', 'script', NULL),
(710, 'export_periods_ARRAY_next', 'arrays', 'export_periods_ARRAY_next', 'script', NULL),
(711, 'export_periods_ARRAY_range', 'arrays', 'export_periods_ARRAY_range', 'script', NULL),
(712, 'export_types_ARRAY_feed', 'arrays', 'export_types_ARRAY_feed', 'script', NULL),
(713, 'export_types_ARRAY_file', 'arrays', 'export_types_ARRAY_file', 'script', NULL),
(714, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(715, 'filter_ARRAY_featured', 'arrays', 'filter_ARRAY_featured', 'script', NULL),
(716, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(717, 'filter_ARRAY_non_featured', 'arrays', 'filter_ARRAY_non_featured', 'script', NULL),
(718, 'front_booking_status_ARRAY_1', 'arrays', 'front_booking_status_ARRAY_1', 'script', NULL),
(719, 'front_booking_status_ARRAY_10', 'arrays', 'front_booking_status_ARRAY_10', 'script', NULL),
(720, 'front_booking_status_ARRAY_11', 'arrays', 'front_booking_status_ARRAY_11', 'script', NULL),
(721, 'front_booking_status_ARRAY_2', 'arrays', 'front_booking_status_ARRAY_2', 'script', NULL),
(722, 'front_booking_status_ARRAY_3', 'arrays', 'front_booking_status_ARRAY_3', 'script', NULL),
(723, 'front_booking_status_ARRAY_4', 'arrays', 'front_booking_status_ARRAY_4', 'script', NULL),
(724, 'front_booking_status_ARRAY_5', 'arrays', 'front_booking_status_ARRAY_5', 'script', NULL),
(725, 'front_booking_status_ARRAY_6', 'arrays', 'front_booking_status_ARRAY_6', 'script', NULL),
(726, 'front_booking_status_ARRAY_8', 'arrays', 'front_booking_status_ARRAY_8', 'script', NULL),
(727, 'front_booking_status_ARRAY_9', 'arrays', 'front_booking_status_ARRAY_9', 'script', NULL),
(728, 'front_err_ARRAY_authorize', 'arrays', 'Calendar / Redirecting to Authorize.net ...', 'script', NULL),
(729, 'front_err_ARRAY_calendar', 'arrays', 'Calendar / Loading calendar ...', 'script', NULL),
(730, 'front_err_ARRAY_calendars', 'arrays', 'Calendar / Loading calendars ...', 'script', NULL),
(731, 'front_err_ARRAY_captcha', 'arrays', 'Calendar / Captcha is not correct', 'script', NULL),
(732, 'front_err_ARRAY_daily_na', 'arrays', 'Calendar / Daily bookings are disabled', 'script', NULL),
(733, 'front_err_ARRAY_form', 'arrays', 'Calendar / Loading booking form ...', 'script', NULL),
(734, 'front_err_ARRAY_fully_booked', 'arrays', 'Calendar / Fully booked', 'script', NULL),
(735, 'front_err_ARRAY_limit', 'arrays', 'Calendar / Limit not match', 'script', NULL),
(736, 'front_err_ARRAY_limits', 'arrays', 'Calendar / Limits not match', 'script', NULL),
(737, 'front_err_ARRAY_loading', 'arrays', 'Calendar / Loading', 'script', NULL),
(738, 'front_err_ARRAY_or', 'arrays', 'Calendar / Or', 'script', NULL),
(739, 'front_err_ARRAY_paypal', 'arrays', 'Calendar / Redirecting to PayPal.com ...', 'script', NULL),
(740, 'front_err_ARRAY_period_na', 'arrays', 'Calendar / Period not available', 'script', NULL),
(741, 'front_err_ARRAY_range_na', 'arrays', 'Calendar / Selected date range not allowed', 'script', NULL),
(742, 'front_err_ARRAY_range_out', 'arrays', 'Calendar / Out of range', 'script', NULL),
(743, 'front_err_ARRAY_save', 'arrays', 'Calendar / Saving reservation ...', 'script', NULL),
(744, 'front_err_ARRAY_should_click', 'arrays', 'Calendar / You should click on', 'script', NULL),
(745, 'front_err_ARRAY_single_na', 'arrays', 'Calendar / Single date booking is disabled', 'script', NULL),
(746, 'front_err_ARRAY_summary', 'arrays', 'Calendar / Loading confirmation ...', 'script', NULL),
(747, 'front_err_ARRAY_till', 'arrays', 'Calendar / Till', 'script', NULL),
(748, 'front_err_ARRAY_valid_plural', 'arrays', 'Calendar / Valid periods are', 'script', NULL),
(749, 'front_err_ARRAY_valid_singular', 'arrays', 'Calendar / Valid period is', 'script', NULL),
(750, 'jquery_validation_ARRAY_email', 'arrays', 'jquery_validation_ARRAY_email', 'script', NULL),
(751, 'jquery_validation_ARRAY_required', 'arrays', 'jquery_validation_ARRAY_required', 'script', NULL),
(752, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(753, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(754, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(755, 'login_err_ARRAY_4', 'arrays', 'login_err_ARRAY_4', 'script', NULL),
(756, 'made_arr_ARRAY_1', 'arrays', 'made_arr_ARRAY_1', 'script', NULL),
(757, 'made_arr_ARRAY_2', 'arrays', 'made_arr_ARRAY_2', 'script', NULL),
(758, 'made_arr_ARRAY_3', 'arrays', 'made_arr_ARRAY_3', 'script', NULL),
(759, 'made_arr_ARRAY_4', 'arrays', 'made_arr_ARRAY_4', 'script', NULL),
(760, 'made_arr_ARRAY_5', 'arrays', 'made_arr_ARRAY_5', 'script', NULL),
(761, 'made_arr_ARRAY_6', 'arrays', 'made_arr_ARRAY_6', 'script', NULL),
(762, 'months_ARRAY_1', 'arrays', 'months_ARRAY_jan', 'script', NULL),
(763, 'months_ARRAY_10', 'arrays', 'months_ARRAY_oct', 'script', NULL),
(764, 'months_ARRAY_11', 'arrays', 'months_ARRAY_nov', 'script', NULL),
(765, 'months_ARRAY_12', 'arrays', 'months_ARRAY_dec', 'script', NULL),
(766, 'months_ARRAY_2', 'arrays', 'months_ARRAY_feb', 'script', NULL),
(767, 'months_ARRAY_3', 'arrays', 'months_ARRAY_mar', 'script', NULL),
(768, 'months_ARRAY_4', 'arrays', 'months_ARRAY_apr', 'script', NULL),
(769, 'months_ARRAY_5', 'arrays', 'months_ARRAY_may', 'script', NULL),
(770, 'months_ARRAY_6', 'arrays', 'months_ARRAY_jun', 'script', NULL),
(771, 'months_ARRAY_7', 'arrays', 'months_ARRAY_jul', 'script', NULL),
(772, 'months_ARRAY_8', 'arrays', 'months_ARRAY_aug', 'script', NULL),
(773, 'months_ARRAY_9', 'arrays', 'months_ARRAY_sep', 'script', NULL),
(774, 'notify_email_ARRAY_3', 'arrays', 'notify_email_ARRAY_3', 'script', NULL),
(775, 'notify_email_ARRAY_4', 'arrays', 'notify_email_ARRAY_4', 'script', NULL),
(776, 'notify_email_ARRAY_5', 'arrays', 'notify_email_ARRAY_5', 'script', NULL),
(777, 'notify_email_ARRAY_6', 'arrays', 'notify_email_ARRAY_6', 'script', NULL),
(778, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(779, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(780, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(781, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(782, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(783, 'price_types_ARRAY_count', 'arrays', 'price_types_ARRAY_count', 'script', NULL),
(784, 'price_types_ARRAY_count_night', 'arrays', 'price_types_ARRAY_count_night', 'script', NULL),
(785, 'price_types_ARRAY_night', 'arrays', 'price_types_ARRAY_night', 'script', NULL),
(786, 'price_types_ARRAY_one_time', 'arrays', 'price_types_ARRAY_one_time', 'script', NULL),
(787, 'price_types_ARRAY_person', 'arrays', 'price_types_ARRAY_person', 'script', NULL),
(788, 'price_types_ARRAY_person_night', 'arrays', 'price_types_ARRAY_person_night', 'script', NULL),
(789, 'reservation_statuses_ARRAY_Cancelled', 'arrays', 'reservation_statuses_ARRAY_Cancelled', 'script', NULL),
(790, 'reservation_statuses_ARRAY_Confirmed', 'arrays', 'reservation_statuses_ARRAY_Confirmed', 'script', NULL),
(791, 'reservation_statuses_ARRAY_Pending', 'arrays', 'reservation_statuses_ARRAY_Pending', 'script', NULL),
(792, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(793, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(794, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(795, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(796, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(797, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(798, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(799, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(800, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(801, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(802, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(803, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(804, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(805, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(806, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(807, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(808, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(809, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(810, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(811, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(812, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(813, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(814, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(815, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(816, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(817, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(818, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(819, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(820, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(821, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(822, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(823, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(824, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(825, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(826, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(827, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(828, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(829, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(830, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(831, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(832, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(833, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(834, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(835, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(836, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(837, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(838, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(839, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(840, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(841, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(842, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(843, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(844, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(845, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(846, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(847, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(848, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(849, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(850, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(851, 'voucher_types_ARRAY_amount', 'arrays', 'voucher_types_ARRAY_amount', 'script', NULL),
(852, 'voucher_types_ARRAY_percent', 'arrays', 'voucher_types_ARRAY_percent', 'script', NULL);

DROP TABLE IF EXISTS `rpbcalendar_multi_lang`;
CREATE TABLE `rpbcalendar_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(40) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(40) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `rpbcalendar_multi_lang` VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Tourist tax', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 1, 'title', '+ Add property', 'script'),
(NULL, 6, 'pjField', 1, 'title', '+ Add coupon', 'script'),
(NULL, 7, 'pjField', 1, 'title', '+ Add discount', 'script'),
(NULL, 8, 'pjField', 1, 'title', '+ Add extra', 'script'),
(NULL, 9, 'pjField', 1, 'title', '+ Add reservation', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Calculate', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Copy', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Get Feed URL', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancelled reservations', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Reservations made in last 7 days', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Add New Property', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Add New Reservation', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Add New User', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Pending reservations', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'Quick Links', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'This week reservations', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'View availability', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Current Reservations', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Export reservations', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Make back-up', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Manage Coupons', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Manage Discounts', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Manage Extras', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Manage properties', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Preview All Calendars', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'confirmed reservations today', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'reservations made today', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'reservation confirmed today', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'new reservation made today', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Set Confirmation Messages', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Are you sure you want to delete this entry?', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 55, 'pjField', 1, 'title', '(empty date)', 'script'),
(NULL, 56, 'pjField', 1, 'title', '(empty date/time)', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 59, 'pjField', 1, 'title', '(invalid date)', 'script'),
(NULL, 60, 'pjField', 1, 'title', '(invalid date/time)', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 64, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Add discount details and click "Save" to create the new discount.', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Add discount', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Use the form below to add a new extra. Extras are additional services which clients can request as per their needs.', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Add extra', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Fill in the form below and click "Save" to add the new coupon.', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Add coupon', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Check the monthly availability of all your properties. Click on each reservation to see details.', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Availability calendars', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Below is a list of all discounts added into the system. If you want to add a new discount, click on the button below.', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Manage discounts', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Below is a list of all extras added to the system. To add a new extra, just click on the button below. To edit an extra, click on the pencil icon in the corresponding line. After adding extras, you can assign them to properties.', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Configure the general settings for your Rental Property Booking Calendar.', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Customize the email notifications which will be sent to system users. You can configure the notification types each user will receive from the Users menu.', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Customize the SMS alerts which system users will receive upon a new reservation or cancellation. You can select the SMS types each user will receive from the Users menu. Please, go to the SMS menu above for further details.', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'SMS notifications', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Use the URL below to have access to all reservations. Please, note that if you change the password the URL will change too as password is used in the URL itself so no one else can open it.', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Reservations Feed URL', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Make the necessary changes and click "Save" to update the discount details.', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Update discount', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Make the necessary changes and click "Save" to update the extra details.', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Update extra', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'You can make any changes to this reservation. Just click "Save" to update the booking details.', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Update reservation', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" to update coupon code information.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Update coupon code', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Below is a list of all coupons. You can add new coupons and edit them any time. ', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Manage coupons', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Add property', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Add reservation', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'adults', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Apply discount on', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Properties', 'script'),
(NULL, 104, 'pjField', 1, 'title', '<table width="100%" border="0" cellspacing="0" cellpadding="0"><tbody><tr><td width="50%" valign="top">{Name} - The customer''s name;<br/> {Email} - The customer''s e-mail;<br/> {Phone} - The provided phone number;<br/> {Adults} - Number of adults;<br/> {Children} - Number of children;<br/> {Notes} - Any additional notes;<br/> {Address} - The provided address;<br/> {City} - The provided city;<br/> {Country} - The provided country;<br/> {State} - The provided state;<br/> {Zip} - The provided zip code;<br/> {CCType} - The provided CC type;<br/> {CCNum} - The provided CC number;<br/>{CCExpMonth} - The provided CC exp.month;<br/> {CCExpYear} - The provided CC exp.year;<br/> {CCSec} - The provided CC sec. code;<br/> {PaymentMethod} - The payment method;</td><td width="50%" valign="top">{StartDate} - Reservation''s start date;<br/> {EndDate} - Reservation''s end date;<br/> {Deposit} - Deposit;<br/> {Security} - Security amount;<br/> {Tax} - Tax;<br/> {TouristTax} - Tourist Tax;<br/> {Price} - Price;<br/> {TotalPrice} - Total Price;<br/>  {CalendarID} - Property ID;<br/> {ReservationID} - Reservation''s ID;<br/> {ReservationUUID} - Reservation''s UUID;<br/> {CancelURL} - Cancel URL</td></tr></tbody></table>', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Property', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'There is {COUNT} reservation for this property which will be deleted too. Do you want to delete it?', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'There are {COUNT} reservations for this property which will be deleted too. Do you want to delete it?', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Property', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'New Reservation', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Properties', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'children', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'coming reservations ', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'property', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'properties', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'last login', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Latest Reservations', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Most Booked', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Night', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Nights', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'reservation', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'reservations', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Top Users', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'user', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'users', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Date from', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Date to', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Days price', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Are you sure you want to delete selected records?', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Discount', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Discount name', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'There is another reservation with such ID.', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Calendar', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Email address is already in use', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Enter password', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Export selected', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Extra name', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'This extra is required.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Format', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'from', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Install config', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'All properties', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Property', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Language icons', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Language', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Months', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Copy the code below and paste it on your web page. It will display the front-end calendar for the selected property.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'The code below will place an availability view for all your properties'' calendars like you have it here under the "Availability" tab.', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Copy the code below and paste it on your web page where you want the calendar to appear.', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Confirmation email', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Supported tokens are:{Name} - The customer''s name{Email} - The customer''s e-mail{Phone} - The provided phone number{Adults} - Number of adults{Children} - Number of children{Notes} - Any additional notes{Address} - The provided address{City} - The provided city{Country} - The provided country{State} - The provided state{Zip} - The provided zip code{CCType} - The provided CC type{CCNum} - The provided CC number{CCExpMonth} - The provided CC exp.month{CCExpYear} - The provided CC exp.year{CCSec} - The provided CC sec. code{PaymentMethod} - The payment method{StartDate} - Reservation''s start date{EndDate} - Reservation''s end date{Deposit} - Deposit{Security} - Security amount{Tax} - Tax{Amount} - Total amount{CalendarID} - Property ID{ReservationID} - Reservation''s ID{ReservationUUID} - Reservation''s UUID{CancelURL} - Cancel URL', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'No properties found', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Payment email', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Supported tokens are:{Name} - The customer''s name{Email} - The customer''s e-mail{Phone} - The provided phone number{Adults} - Number of adults{Children} - Number of children{Notes} - Any additional notes{Address} - The provided address{City} - The provided city{Country} - The provided country{State} - The provided state{Zip} - The provided zip code{CCType} - The provided CC type{CCNum} - The provided CC number{CCExpMonth} - The provided CC exp.month{CCExpYear} - The provided CC exp.year{CCSec} - The provided CC sec. code{PaymentMethod} - The payment method{StartDate} - Reservation''s start date{EndDate} - Reservation''s end date{Deposit} - Deposit{Security} - Security amount{Tax} - Tax{Amount} - Total amount{CalendarID} - Property ID{ReservationID} - Reservation''s ID{ReservationUUID} - Reservation''s UUID', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'maximum', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Max. count', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Maximum guests per reservation should be {MAX}.', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Max value', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'minimum', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Minimum guests per reservation should be {MIN}.', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'More', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Multi quantity', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'N/A', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Nights price', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'No access to feed', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'SMS notifications', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Copy options from', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Are you sure you want to copy selected options?', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'You can copy all the options below from any of your other properties.', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Copy options confirmation', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Booking terms content', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Booking terms URL', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Period', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Qty', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Remove filter', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Required', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Adults', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Property', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'CC Code', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'CC Expiration date', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'CC Number', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'CC Type', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Children', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Reservation time', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Create Invoice', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Date range is not available', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Reservation deposit', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Discount amount', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Extras price', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Reserved dates', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Find Invoices', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Reservation details', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Invoice', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Invoice Details', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Invoices', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Next 30 days', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Next Month', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'No reservations found', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Enter name or email', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Previous 30 days', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Prev Month', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Promo amount', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Promo code', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Resend confirmation email', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'Security deposit', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'Reservations Feed URL', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'reservations made', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Tourist tax', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Unique ID', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'ZIP', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'to', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'to be paid', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'To be used in', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Total reservations', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Tourist tax per person per day', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Tourist tax per person per night', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Update Property', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Update reservation', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Owner:', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Select the email notifications to be sent to this user.', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Select the user''s role.', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Select the SMS notifications to be sent to this user.', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Validity', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'View Property', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'View reservations', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Coupon code', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Coupon code is already used.', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'week', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'Add a limit', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Days', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Max length', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Min length', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Nights', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Appearance', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Availability', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Booking Form', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Calendar', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Properties', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Confirmations', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Coupons & Discounts', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Install & Preview', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Limits', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Payments', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Settings', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Select a language by clicking on the corresponding flag and input the correct text.', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Body<br /><br />Available tokens:<br />{Name}<br />{Password}', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Body', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Check if you want to accept reservations or uncheck to show availability only', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Allow users to add properties', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Allow Authorize.Net payments', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Allow cash payments', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Allow PayPal payments', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Authorize.net hash value', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Authorize.net time zone', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Available dates', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Booked dates', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Empty slots', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Month background', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Month nav background', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Month nav hover background', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Past dates color', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Pending reservation dates', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Current reservation selected dates', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Weekdays background', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Adults', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Maximum adults and children per reservation', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Children', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'ZIP', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Set number of reservations to be accepted per day/night', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Accept single or multi date reservations', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Inner border color', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Inner border size', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Outer border color', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Outer border size', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'URL of the web page where your clients will be redirected to after they cancel a reservation', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Available dates color', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Booked dates color', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Legend color', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Month color', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Past dates color', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Pending days color', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Weekdays color', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Set deposit amount to be collected for each reservation', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Check if you want to disable payments and only collect reservation details', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'New reservation received', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Reservation cancelled', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Floor metrics', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Font family', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Font family legend', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Available dates font size', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Booked dates font size', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Legend font size', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Month font size', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Past dates font size', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Pending days font size', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Weekdays font size', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Available dates font style', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Booked dates font style', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Legend font style', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Month font style', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Past dates font style', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Pending days font style', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Weekdays font style', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'User account confirmed by default', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Select layout', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Featured properties', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Maximum guests per reservation', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'maximum total tax per reservation', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Minimum guests per reservation', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Month / Year format', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Paypal address', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Reservations and prices will be based on', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Prices can also be based on', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Require 100% payment if reservation is made less than ... days in advance ', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Set a security deposit payment to be collected with each reservation', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Select email sending method', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Check if you want to show color legend below the front end calendar', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Check if you want to show prices on the front end calendar', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Check if you want to show weekly number on the front end calendar', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Set the status for new reservations when the reservation form has been saved', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Set the status for new reservations if payment has been made', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Tax amount to be collected for each reservation', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'URL of the web page where your clients will be redirected to after their PayPal or Authorize.Net payment', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Tourist tax per person per night/day', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Set first day of week ', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Please enter a valid number.', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'I would like to re-send a confirmation message too', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Update confirmation', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'reservations', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Balance payment', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Are you sure you want to recalculate the price? Current price will be lost!', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'You can change dates and number of adults/children and then click the ''Calculate'' button. The price will be calculated based on the new selection.', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Calculate confirmation', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Coupons', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Discounts', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Emails to admins', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 428, 'pjField', 1, 'title', '1 Month', 'script'),
(NULL, 429, 'pjField', 1, 'title', '6 Months', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'SMS to admins', 'script'),
(NULL, 431, 'pjField', 1, 'title', '3 Months', 'script'),
(NULL, 432, 'pjField', 1, 'title', '12 Months', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Adults', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Booking', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'CC Exp.date', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'CC Number', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'CC Sec.code', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'CC Type', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Children', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'day', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Discount amount', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Departure', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Extras price', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'night', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'nights', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Payment required', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Price after promo', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Promo amount', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Refundable security deposit', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Arrival', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Subtotal', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'I agree to %sterms of booking%s', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Total price', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'ZIP', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Apply', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Click on a property to make a reservation.', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'discount', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Enter promo code', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'After selecting extras, please click on the link "Re-calculate prices" to update prices.', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Extra name', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'You need to select this extra.', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'for 1 day', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'for 1 night', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'for {DAYS} days', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'for {NIGHTS} nights', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'from total price', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Invalid promo code', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Maximum guests per reservation should be {MAX}.', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Minimum guests per reservation should be {MIN}.', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'to be paid on arrival', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'to be paid when booking', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'AB Calendar', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'AB Calendar', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'per person, per day', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'per person, per night', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'total price for selected extras', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Promo code used', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Qty', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Re-calculate prices', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Start over', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Back to calendar', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'Back to calendars', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Select an available start and end date to make a reservation.', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'change dates', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'Price from', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Security deposit', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Available', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Booked', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Past', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Both', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'When reservations are made within these dates', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'When reservations are within these dates', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Room(s) & Extras price', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Extras price', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Room(s) price', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Tomorrow', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'This week', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Next week', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'This month', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Next month', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'sun', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'mon', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'tue', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'wed', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'thu', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'fri', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'sat', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'per count', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'per count / per day', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'per day', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'one time fee', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'per person', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'per person / per day', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Booking duration', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Early bird (X days before arrival)', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Family discount', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Number of guests', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'All the changes made to this calendar have been saved.', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'All the changes made to this calendar have been saved.', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'We are sorry, but the calendar has not been added.', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Calendar your looking for is missing.', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Review and manage all property calendars. Configure settings, update prices, add and delete properties.', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Create the new property by adding a title and selecting the owner who can manage the property calendar.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'View availability and click on a date to see reservation details.', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'All changes made to the discount have been saved.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'New discount has been added to the list.', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'We are sorry that new discount could not bee added successfully.', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'We are sorry that discount you are looking for is missing.', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'All the changes made to this extra have been saved.', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'All the changes made to this extra have been saved.', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'We are sorry, but the extra has not been added.', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Extra your looking for is missing.', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'All the changes made to this property have been saved.', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Property not found', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Your plan has been extended.', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'All the changes made to general options have been saved.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'All the changes made to appearance options have been saved.', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'All the changes made to booking options have been saved.', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'All the changes made to booking form options have been saved.', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'All the changes made to confirmation options have been saved.', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'All the changes made to terms options have been saved.', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'All the changes made to payment options have been saved.', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'All the changes made to notification options have been saved.', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'All the changes made to limits have been saved.', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Some of submitted periods have overlapping dates.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Set custom booking options for this property calendar.', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Set custom payment options for this property calendar. ', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Select the standard and required fields that will be visible on the booking form.', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Personalize the email notifications which will be sent to guests upon a new reservation or payment. Please, note that you have to add a subject. Otherwise, the email will not be sent.', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Enter your booking terms and conditions. You can also add a link to an external web page.', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Define different periods throughout the year and set custom booking limits. For example, you may want to allow only bookings of minimum 3 nights during the high season.', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'All the changes made to this reservation have been saved.', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'We are sorry, but the reservation has not been updated.', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'All the changes made to this reservation have been saved.', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'We are sorry, but the reservation has not been added.', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Reservation your looking for is missing.', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'The property for this reservation not found.', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'The property for this reservation belongs to somebody else but not you.', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'The period is already booked and reservation cannot be proceeded. Please change the date range.', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Check all invoices generated for this reservation. You can review, print out or send the invoice to your customer’s email. You can also issue additional invoices for balance payments, if necessary.', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Reservation has been cancelled successfully.', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Here you can cancel your reservation.', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'It seems there are missing, empty or not valid parameters.', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Sorry, but the reservation you''re looking for was not found.', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'You''ve already canceled the booking. Here is your details.', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Use form below to add reservation details.', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'You can not add new reservation, because there are not calendars assigned to you.', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Sorry, but there are not availability calendars to show.', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'You can export reservations in different formats. Either download a file with all reservation details or use a link for a feed which will load all reservations.', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'All the changes made to this type have been saved.', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'All the changes made to this type have been saved.', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'We are sorry, but the type has not been added.', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Type your looking for is missing.', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Use the form below to add a new system user.', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Use form below to update an existing user of the system.', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'You can add three types of users: Administrators - who have full access rights, Editors - who can access calendars and reservations, and Owners - who can access their own calendars only.', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'All changes made to the coupon code have been saved.', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'New coupon code has been added to the list.', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'We are sorry that new coupon code could not bee added successfully.', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'We are sorry that coupon code you are looking for is missing.', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'Calendar updated!', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'Calendar added!', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'Calendar failed to add.', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Calendar not found.', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Properties', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Add property', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Property Calendar', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Discount updated', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Discount added', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'Discount failed to add', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Discount not found', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'Extra updated!', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Extra added!', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Extra failed to add.', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Extra not found.', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Property updates!', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Error occured', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Error occured', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'System notice', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Titles updated!', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'General options updated!', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Appearance options updated!', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Booking options updated!', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Booking form options updated!', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Confirmation options updated!', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Terms options updated!', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Payment options updated!', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'Notification options updated!', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Limits updated!', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Overlapping dates!', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Payments', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Confirmations', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'Booking limits', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'Reservation updated!', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'Reservation failed to update.', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Reservation added!', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Reservation failed to add.', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'Reservation not found.', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Associate property not found.', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Associate property forbidden.', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Reservation not updated!', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'Invoices', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Reservation cancelled', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'Cancel reservation', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'Reservation not found', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'Reservation cancelled', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'Add reservation', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Availability not found', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'Export reservations', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'Type updated!', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Type added!', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'Type failed to add.', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'Type not found.', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'Coupon code updated', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Coupon code added', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'Coupon code failed to add', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'Coupon code not found', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'CSV', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'iCal', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'XML', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'Created or Modified', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'Coming', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'Specific period', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'Feed', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'File', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'Featured', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'Not featured', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'Your reservation has been received.', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'Max booking length is %u %s', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Your request has not been sent successfully. Please try again.', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'Selected period is not available.', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'Verification code is invalid. Please try again.', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'Invalid dates. Please try again.', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'Invalid date range. Please check your dates.', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'Date ranges in past is not allowed.', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'Min booking length is %u %s', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'Saving reservation and redirecting to Authorize.net ...', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'Loading calendar ...', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'Loading calendars ...', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'Captcha is not correct', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'Daily bookings are disabled', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'Loading booking form ...', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'You can not select fully booked days', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'Limits not match. Min: {MIN}, Max: {MAX}, Your choise: {YOUR}', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'For the selected dates you can book between {MIN} and {MAX} nights. You tried to book {YOUR} nights.', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'Please wait while content is loading...', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'or', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'Saving reservation and redirecting to PayPal.com ...', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'Period not allowed', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'Selected date range not allowed', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'Out of range', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'Saving reservation ...', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'You should click on:', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'Single date booking is disabled', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'Loading confirmation ...', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'till', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'Valid periods are:', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'Valid period is:', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'Please enter a valid email.', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'Email is not valid.', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'Yesterday', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'This week', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'Last week', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'This month', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'Last month', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'New reservation - all calendars', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'New reservation - my calendars', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'Reservation cancelled - all calendars', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'Reservation cancelled - my calendars', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'Authorize.NET', 'script'),
(NULL, 779, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 780, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 781, 'pjField', 1, 'title', 'Credit Card', 'script'),
(NULL, 782, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 783, 'pjField', 1, 'title', 'per count', 'script'),
(NULL, 784, 'pjField', 1, 'title', 'per count / per night', 'script'),
(NULL, 785, 'pjField', 1, 'title', 'per night', 'script'),
(NULL, 786, 'pjField', 1, 'title', 'one time fee', 'script'),
(NULL, 787, 'pjField', 1, 'title', 'per person', 'script'),
(NULL, 788, 'pjField', 1, 'title', 'per person / per night', 'script'),
(NULL, 789, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 790, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 791, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 792, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 793, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 794, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 795, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 796, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 797, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 798, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 799, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 800, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 801, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 802, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 803, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 804, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 805, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 806, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 807, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 808, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 809, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 810, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 811, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 812, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 813, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 814, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 815, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 816, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 817, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 818, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 819, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 820, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 821, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 822, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 823, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 824, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 825, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 826, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 827, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 828, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 829, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 830, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 831, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 837, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 838, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 839, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 840, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 841, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 842, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 843, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 844, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 845, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 846, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 847, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 848, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 849, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 850, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 851, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 852, 'pjField', 1, 'title', 'Percent', 'script');

INSERT INTO `rpbcalendar_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(0, 'o_week_start', 0, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 1, 1, NULL),
(0, 'o_date_format', 0, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 2, 1, NULL),
(0, 'o_timezone', 0, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(0, 'o_month_year_format', 0, 'Month Year|Month, Year|Year Month|Year, Month::Month Year', NULL, 'enum', 6, 1, NULL),
(0, 'o_send_email', 0, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(0, 'o_smtp_host', 0, NULL, NULL, 'string', 9, 1, NULL),
(0, 'o_smtp_pass', 0, NULL, NULL, 'string', 10, 1, NULL),
(0, 'o_smtp_port', 0, '25', NULL, 'int', 11, 1, NULL),
(0, 'o_smtp_user', 0, NULL, NULL, 'string', 12, 1, NULL),
(0, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);
