<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminVouchers extends pjAdmin
{
	public function pjActionCheckCode()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['code']) || empty($_GET['code']))
			{
				echo 'false';
				exit;
			}
			$pjVoucherModel = pjVoucherModel::factory()->where('t1.code', $_GET['code']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjVoucherModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjVoucherModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['voucher_create']))
			{
				$data = array();
			
				$data['code'] = $_POST['code'];
				$data['used_count'] = $_POST['used_count'];
				$data['discount'] = $_POST['type'] == 'amount' ? pjUtil::convertToMySQLNumber($_POST['discount'], $this->option_arr) : $_POST['discount'];
				$data['type'] = $_POST['type'];
				$data['condition'] = $_POST['condition'];
				$data['apply_on'] = $_POST['apply_on'];
				$data['date_from'] = pjUtil::formatDate($_POST['date_from'], $this->option_arr['o_date_format']);
				$data['date_to'] = pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']);
				$id = pjVoucherModel::factory($data)->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$pjCalendarVoucherModel = pjCalendarVoucherModel::factory();
					if (isset($_POST['calendar_id']) && is_array($_POST['calendar_id']) && count($_POST['calendar_id']) > 0)
					{
						$pjCalendarVoucherModel->begin();
						foreach ($_POST['calendar_id'] as $calendar_id)
						{
							$pjCalendarVoucherModel
								->reset()
								->set('voucher_id', $id)
								->set('calendar_id', $calendar_id)
								->insert();
						}
						$pjCalendarVoucherModel->commit();
					}
					$err = 'AV03';
				} else {
					$err = 'AV04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminVouchers&action=pjActionIndex&err=$err");
			} else {
				
				$this->set('calendar_arr', pjCalendarModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjCalendar' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('name ASC')
					->findAll()
					->getData());
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendJs('pjAdminVouchers.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteVoucher()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			
			if (pjVoucherModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjCalendarVoucherModel::factory()->where('voucher_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteVoucherBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjVoucherModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjCalendarVoucherModel::factory()->whereIn('voucher_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionExportVoucher()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjVoucherModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Vouchers-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetVoucher()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjVoucherModel = pjVoucherModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjVoucherModel->where('t1.code LIKE', "%$q%");
			}
	
			$column = 'code';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjVoucherModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = array();
			
			$data = $pjVoucherModel->select('t1.*')
				->orderBy("$column $direction")->limit($rowCount, $offset)->findAll()->getData();
			foreach($data as $k => $v)
			{
				if($v['type'] == 'percent')
				{
					$v['discount'] = $v['discount'] . '%';
				}else{
					$v['discount'] = pjUtil::formatCurrencySign(pjUtil::converToCurrencyFormat($v['discount'], $this->option_arr), $this->option_arr['o_currency']);
				}
				$v['valid'] = '';
				$v['valid'] = __('lblFrom', true) . ' ' . date($this->option_arr['o_date_format'], strtotime($v['date_from'])) . ' ' . __('lblTo', true) . ' ' . date($this->option_arr['o_date_format'], strtotime($v['date_to']));
				$data[$k] = $v;
			}	
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminVouchers.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveVoucher()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			pjVoucherModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['voucher_update']))
			{
				$data = array();
				$data['code'] = $_POST['code'];
				$data['used_count'] = $_POST['used_count'];
				$data['discount'] = $_POST['type'] == 'amount' ? pjUtil::convertToMySQLNumber($_POST['discount'], $this->option_arr) : $_POST['discount'];
				$data['type'] = $_POST['type'];
				$data['condition'] = $_POST['condition'];
				$data['apply_on'] = $_POST['apply_on'];
				$data['date_from'] = pjUtil::formatDate($_POST['date_from'], $this->option_arr['o_date_format']);
				$data['date_to'] = pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']);
				
				pjVoucherModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($data);
				
				$pjCalendarVoucherModel = pjCalendarVoucherModel::factory();
				$pjCalendarVoucherModel->where('voucher_id', $_POST['id'])->eraseAll();
				if (isset($_POST['calendar_id']) && is_array($_POST['calendar_id']) && count($_POST['calendar_id']) > 0)
				{
					$pjCalendarVoucherModel->begin();
					foreach ($_POST['calendar_id'] as $calendar_id)
					{
						$pjCalendarVoucherModel
						->reset()
						->set('voucher_id', $_POST['id'])
						->set('calendar_id', $calendar_id)
						->insert();
					}
					$pjCalendarVoucherModel->commit();
				}
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminVouchers&action=pjActionIndex&err=AV01");
				
			} else {
				$arr = pjVoucherModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminVouchers&action=pjActionIndex&err=AV08");
				}
				$this->set('arr', $arr);
				
				$this->set('calendar_arr', pjCalendarModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjCalendar' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('name ASC')
					->findAll()
					->getData());
			
				$this->set('calendar_id_arr', pjCalendarVoucherModel::factory()
					->where("voucher_id", $_GET['id'])
					->findAll()
					->getDataPair("calendar_id", "calendar_id"));
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendJs('pjAdminVouchers.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
}
?>