<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	?>
	<div class="dashboard_header">
		<div class="dashboard_header_item">
			<div class="dashboard_icon dashboard_reservations"></div>
			<div class="dashboard_info">
				<abbr><?php echo (int) @$tpl['info_arr'][0]['made_reservations'];?></abbr>
				<label><?php (int) @$tpl['info_arr'][0]['made_reservations'] !== 1 ? __('dash_reservations_made_today') : __('dash_reservation_made_today'); ?></label>
			</div>
		</div>
		<div class="dashboard_header_item">
			<div class="dashboard_icon dashboard_reservations"></div>
			<div class="dashboard_info">
				<abbr><?php echo (int) @$tpl['info_arr'][0]['confirmed_reservations'];?></abbr>
				<label><?php (int) @$tpl['info_arr'][0]['confirmed_reservations'] !== 1 ? __('dash_reservations_confirmed_today') : __('dash_reservation_confirmed_today'); ?></label>
			</div>
		</div>
		<div class="dashboard_header_item dashboard_header_item_last">
			<div class="dashboard_icon dashboard_users"></div>
			<div class="dashboard_info"><abbr><?php echo (int) @$tpl['info_arr'][0]['users']; ?></abbr><?php (int) @$tpl['info_arr'][0]['users'] !== 1 ? __('lblDashUsers') : __('lblDashUser'); ?></div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			
			<div class="dashboard_column_top"><?php __('lblDashLatestReservations'); ?></div>
			<div class="dashboard_column_top"><?php __('dash_current_reservations'); ?></div>
			<div class="dashboard_column_top"><?php __('dashboard_quick_links'); ?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<?php
				$cnt = count($tpl['reservation_arr']);
				if ($cnt === 0)
				{
					?><p class="m10"><?php __('lblReservationNotFound'); ?></p><?php
				}
				foreach ($tpl['reservation_arr'] as $k => $item)
				{
					$nights = (strtotime($item['date_to']) - strtotime($item['date_from'])) / 86400;
					?>
					<div class="dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
						<div class="dashboard_resr_left">
							<div class="bold fs13 lh19 verdana"><?php echo pjSanitize::clean($item['c_name']); ?></div>
							<div class="italic"><?php echo pjSanitize::html($item['calendar_name']); ?></div>
							<table>
								<tr>
									<td style="padding: 5px 10px 5px 0"><?php __('lblReservationFrom'); ?></td>
									<td style="padding: 5px 0"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($item['date_from'])); ?></td>
								</tr>
								<tr>
									<td style="padding: 5px 10px 5px 0"><?php __('lblReservationTo'); ?></td>
									<td style="padding: 5px 0"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($item['date_to'])); ?></td>
								</tr>
							</table>
							<div class=""><a class="bold fs13" href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminReservations&amp;action=pjActionUpdate&amp;id=<?php echo $item['id']; ?>"><?php echo $item['status']; ?></a></div>
						</div>
						<div class="dashboard_resr_right"><abbr><?php echo $nights; ?></abbr><?php (int) $nights !== 1 ? __('lblDashNights') : __('lblDashNight'); ?></div>
					</div>
					<?php
				}
				?>
			</div>
			
			<div class="dashboard_column dashboard_column_last">
				<?php
				$cnt = count($tpl['current_arr']);
				if ($cnt === 0)
				{
					?><p class="m10"><?php __('lblReservationNotFound'); ?></p><?php
				}
				foreach ($tpl['current_arr'] as $k => $item)
				{
					$nights = (strtotime($item['date_to']) - strtotime($item['date_from'])) / 86400;
					?>
					<div class="dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
						<div class="dashboard_resr_left">
							<div class="bold fs13 lh19 verdana"><?php echo pjSanitize::clean($item['c_name']); ?></div>
							<div class="italic"><?php echo pjSanitize::html($item['calendar_name']); ?></div>
							<table>
								<tr>
									<td style="padding: 5px 10px 5px 0"><?php __('lblReservationFrom'); ?></td>
									<td style="padding: 5px 0"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($item['date_from'])); ?></td>
								</tr>
								<tr>
									<td style="padding: 5px 10px 5px 0"><?php __('lblReservationTo'); ?></td>
									<td style="padding: 5px 0"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($item['date_to'])); ?></td>
								</tr>
							</table>
							<div class=""><a class="bold fs13" href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminReservations&amp;action=pjActionUpdate&amp;id=<?php echo $item['id']; ?>"><?php echo $item['status']; ?></a></div>
						</div>
						<div class="dashboard_resr_right"><abbr><?php echo $nights; ?></abbr><?php (int) $nights !== 1 ? __('lblDashNights') : __('lblDashNight'); ?></div>
					</div>
					<?php
				}
				?>
			</div>
			<div class="dashboard_column _quick">
				
				<?php
				if($controller->isAdmin())
				{ 
					?>
					<p><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminCalendars&amp;action=pjActionIndex"><?php __('dash_manage_properties'); ?></a></p>
					<?php
				} 
				?>
				<p><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminReservations&amp;action=pjActionCreate"><?php __('dashboard_new_reservation'); ?></a></p>
				<p><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminReservations&amp;action=pjActionExport"><?php __('dash_export_reservations'); ?></a></p>
				
				<p>&nbsp;</p>
				
				<?php
				if($controller->isAdmin())
				{ 
					?>
					<p><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminExtras&amp;action=pjActionIndex"><?php __('dash_manage_extras'); ?></a></p>
					<p><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminVouchers&amp;action=pjActionIndex"><?php __('dash_manage_coupons'); ?></a></p>
					<p><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminDiscounts&amp;action=pjActionIndex"><?php __('dash_manage_discounts'); ?></a></p>
					
					<p>&nbsp;</p>
					
					
					<p><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminOptions&action=pjActionNotifications"><?php __('dash_set_confirmation_messages'); ?></a></p>
					<p><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjBackup&action=pjActionIndex"><?php __('dash_make_backup'); ?></a></p>
					
					<p>&nbsp;</p>
					<p><a target="_blank" href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminOptions&action=pjActionPreview&cid=all&locale="><?php __('dash_preview_all_calendars'); ?></a></p>
					<?php
				} 
				?>
			
			</div>
			
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	<?php
	$months = __('months', true);
	$days = __('days', true);
	?>
	<div class="clear_left t20 overflow">
		<div class="float_left black pt15">
			<span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span>
			<?php
			list($month_index, $other) = explode("_", date("n_d, Y H:i", strtotime($_SESSION[$controller->defaultUser]['last_login'])));
			printf("%s %s", $months[$month_index], $other);
			?>
		</div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $month_index, $other) = explode("_", date("H:i_w_n_d, Y"));
		?>
			<div class="dashboard_date">
				<abbr><?php echo @$days[$day]; ?></abbr>
				<?php printf("%s %s", $months[$month_index], $other); ?>
			</div>
			<div class="dashboard_hour"><?php echo $hour; ?></div>
		</div>
	</div>
	<?php
}
?>