<?php
$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
$days = __('days', true);
$days = pjUtil::sortArrayByArray($days, array('1','2','3','4','5','6','0'));
?>
<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOptions&amp;action=pjActionUpdate" method="post" class="form pj-form clear_both">
	<input type="hidden" name="options_update" value="1" />
	<input type="hidden" name="next_action" value="pjActionIndex" />
	<input type="hidden" name="tab" value="<?php echo @$_GET['tab']; ?>" />

	<table class="pj-table b10" cellpadding="0" cellspacing="0" style="width: 100%">
		<thead>
			<tr>
				<th><?php __('limit_from'); ?></th>
				<th><?php __('limit_to'); ?></th>
				<th style="width:120px;"><?php __('limit_block_dates'); ?></th>
				<th><?php __('limit_min'); ?></th>
				<th><?php __('limit_max'); ?></th>
				<th style="width: 4%">&nbsp;</th>
			</tr>
		</thead>
		<tbody>
		<?php
		foreach ($tpl['arr'] as $limit)
		{
			$diff = abs(strtotime($limit['date_to']) - strtotime($limit['date_from'])) / 86400;
			?>
			<tr>
				<td>
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" name="date_from[<?php echo $limit['id'];?>]" class="pj-form-field pointer w80 datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo pjUtil::formatDate($limit['date_from'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" />
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</td>
				<td>
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" name="date_to[<?php echo $limit['id'];?>]" class="pj-form-field pointer w80 datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo pjUtil::formatDate($limit['date_to'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" />
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</td>
				<td>
					<input type="checkbox" name="block_dates[<?php echo $limit['id'];?>]" class="blockDates block float_left t5 r5" value="T"<?php echo $limit['blocked'] == 'T' ? ' checked="checked"' : NULL;?>/>
					<div class="pjBlockedDays block float_left" style="display:<?php echo $limit['blocked'] == 'T' ? 'block' : 'none';?>;">
						<select name="blocked_days[<?php echo $limit['id'];?>][]" multiple="multiple" size="5" class="pj-form-field w60 pjMultiSelect">
							<?php
							$blocked_days = $limit['blocked_days'] != '' ? explode("|", $limit['blocked_days']) : array();
							foreach ($days as $k => $v)
							{
								?><option value="<?php echo $k; ?>"<?php echo in_array($k, $blocked_days) ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</div>
				</td>
				<td><div class="nightRange"><input type="text" name="min_nights[<?php echo $limit['id'];?>]" class="pj-form-field w50 r5 pjSpinner" value="<?php echo $limit['min_nights']; ?>" data-max="<?php echo $diff; ?>" /> <?php $tpl['option_arr']['o_price_based_on'] == 'nights' ? __('limit_nights') : __('limit_days'); ?></div></td>
				<td><div class="nightRange"><input type="text" name="max_nights[<?php echo $limit['id'];?>]" class="pj-form-field w50 r5 pjSpinner" value="<?php echo $limit['max_nights']; ?>" data-max="<?php echo $diff; ?>" /> <?php $tpl['option_arr']['o_price_based_on'] == 'nights' ? __('limit_nights') : __('limit_days'); ?></div></td>
				<td><a class="pj-table-icon-delete lnkRemoveRow" href="#"></a></td>
			</tr>
			<?php
		}
		?>
		</tbody>
		<tfoot>
			<tr>
				<td colspan="6" class="p10"><input type="button" class="pj-button btnAddLimit" value="<?php __('limit_add'); ?>" /></td>
			</tr>
		</tfoot>
	</table>
	
	<input type="submit" class="pj-button" value="<?php __('btnSave'); ?>" />
</form>

<table style="display: none" id="tblClone">
	<tbody>
		<tr>
			<td>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="date_from[{INDEX}]" class="pj-form-field pointer w80 datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</td>
			<td>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="date_to[{INDEX}]" class="pj-form-field pointer w80 datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</td>
			<td>
				<input type="checkbox" name="block_dates[{INDEX}]" class="blockDates block float_left t5 r5" value="T"/>
				<div class="pjBlockedDays block float_left" style="display:none;">
					<select name="blocked_days[{INDEX}][]" multiple="multiple" size="5" class="pj-form-field w60 pjMultiSelect">
						<?php
						foreach ($days as $k => $v)
						{
							?><option value="<?php echo $k; ?>" selected="selected"><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</div>
			</td>
			<td><div class="nightRange"><input name="min_nights[{INDEX}]" type="text" class="pj-form-field w50 r5 pjSpinner" /> <?php $tpl['option_arr']['o_price_based_on'] == 'nights' ? __('limit_nights') : __('limit_days'); ?></div></td>
			<td><div class="nightRange"><input name="max_nights[{INDEX}]" type="text" class="pj-form-field w50 r5 pjSpinner" /> <?php $tpl['option_arr']['o_price_based_on'] == 'nights' ? __('limit_nights') : __('limit_days'); ?></div></td>
			<td><a href="#" class="pj-table-icon-delete lnkRemoveRow"></a></td>
		</tr>
	</tbody>
</table>

<script type="text/javascript">
var myLabel = myLabel || {};
myLabel.choose = "-- <?php __('lblChoose'); ?> --";
</script>