<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$months = __('months', true);
	$short_months = __('short_months', true);
	ksort($months);
	ksort($short_months);
	$days = __('days', true);
	$short_days = __('short_days', true);
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminVouchers&amp;action=pjActionIndex"><?php __('tabCoupons'); ?></a></li>
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminDiscounts&amp;action=pjActionIndex"><?php __('tabDiscounts'); ?></a></li>
		</ul>
	</div>
	<?php
	pjUtil::printNotice(__('infoAddVoucherTitle', true, false), __('infoAddVoucherDesc', true, false)); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminVouchers&amp;action=pjActionCreate" method="post" id="frmCreateVoucher" class="form pj-form" autocomplete="off">
		<input type="hidden" name="voucher_create" value="1" />
		<p>
			<label class="title"><?php __('lblCalendars'); ?></label>
			<span class="inline_block">
				<?php
				if(!empty($tpl['calendar_arr']))
				{ 
					?>
					<select name="calendar_id[]" id="calendar_id" multiple="multiple" size="5" class="pj-form-field required w300">
						<?php
						foreach ($tpl['calendar_arr'] as $v)
						{
							?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
						}
						?>
					</select>
					<?php
				}
				?>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblVoucherCode'); ?></label>
			<span class="inline_block">
				<input type="text" name="code" id="code" class="pj-form-field w150 required" />
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblToBeUsedIn'); ?></label>
			<span class="inline_block">
				<input type="text" name="used_count" id="used_count" class="pj-form-field w80 field-int digits required"/>
				<?php __('reservations');?>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblDiscount'); ?></label>
			<span class="inline_block">
				<span class="block float_left r10">
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr id="icon_type" class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" id="discount" name="discount" class="pj-form-field w80 required<?php echo isset($tpl['option_arr']['o_currency_format']) ? ' pjNumber' : ' number';?>" data-currency_format="<?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>" data-msg-number="<?php __('pj_number_validation');?>" data-msg-pjNumber="<?php __('lblValidNumberMessage');?>"/>
					</span>
				</span>
				
				<select name="type" id="type" class="pj-form-field w150 required">
					<?php
					foreach (__('voucher_types', true, false) as $k => $v)
					{
						?><option value="<?php echo $k; ?>" data-sign="<?php echo $k == 'amount' ? pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], "") : '%'; ?>"><?php echo $v; ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<?php
		$apply_on = pjUtil::sortArrayByArray(__('apply_on'), array('room','extra','both'));
		?>
		<p>
			<label class="title"><?php __('lblApplyDiscountOn');?></label>
			<span class="inline_block">
				<select name="apply_on" id="apply_on" class="pj-form-field w200">
					<?php
					foreach($apply_on as $k => $v)
					{
						?>
						<option value="<?php echo $k?>"><?php echo $v;?></option>
						<?php
					} 
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblDateFrom'); ?></label>
			<span class="inline_block">
				<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
					<input type="text" name="date_from" id="date_from" class="pj-form-field pointer w80 datepick required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblDateTo'); ?></label>
			<span class="inline_block">
				<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
					<input type="text" name="date_to" id="date_to" class="pj-form-field pointer w80 datepick required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</span>
		</p>
		<?php
		$apply_conditions = pjUtil::sortArrayByArray(__('apply_conditions'), array('period','made','both'));
		?>
		<p>
			<label class="title">&nbsp;</label>
			<span class="block overflow float_left">
				<?php
				foreach($apply_conditions as $k => $v)
				{
					?>
					<span class="block overflow b5"><input type="radio" name="condition" id="condition_<?php echo $k;?>"<?php echo $k=='period' ? ' checked="checked"' : null;?> value="<?php echo $k;?>" class="block float_left r5"/><label for="condition_<?php echo $k;?>"><?php echo $v;?></label></span>
					<?php
				} 
				?>
			</span>
		</p>
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
			<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminVouchers&action=pjActionIndex';" />
		</p>
	</form>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.code_exist = "<?php __('lblVoucherCodeExist', false, true); ?>";
	myLabel.field_required = "<?php __('pj_field_required', false, true); ?>";
	</script>
	<?php
}
?>