var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	"use strict";
	$(function () {
		var $dialogDelete = $("#dialogDelete"),
			datagrid = ($.fn.datagrid !== undefined),
			dialog = ($.fn.dialog !== undefined),
			validate = ($.fn.validate !== undefined),
			$frmCreateCalendar = $("#frmCreateCalendar");

		if ($frmCreateCalendar.length > 0 && validate) {
			$frmCreateCalendar.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				errorClass: "err",
				wrapper: "em",
				onkeyup: false,
				ignore: ".ignore",
				invalidHandler: function (event, validator) {
					$(".pj-multilang-wrap").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).css('display','block');
						}else{
							$(this).css('display','none');
						}
					});
					$(".pj-form-langbar-item").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).addClass('pj-form-langbar-item-active');
						}else{
							$(this).removeClass('pj-form-langbar-item-active');
						}
					});
				}
			});
		}
		
		$("#content").on("click", ".pj-checkbox", function () {
			var $this = $(this);
			if ($this.find("input[type='checkbox']").is(":checked")) {
				$this.addClass("pj-checkbox-checked");
			} else {
				$this.removeClass("pj-checkbox-checked");
			}
		}).on("click", ".listing-tip", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			return false;
		}).on("click", ".abCalendarLinkMonth", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this);
			$.get("index.php?controller=pjAdminCalendars&action=pjActionGetCal", {
				"cid": $this.data("cid"),
				"year": $this.data("year"),
				"month": $this.data("month")
			}).done(function (data) {
				$("#abCalendar_" + $this.data("cid")).html(data);
			});
			return false;
		}).on("click", ".pj-table-icon-custom-delete", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $tr = $(this).closest('tr');
			var id = $tr.attr('data-id');
			id = id.replace("id_", "");
			$dialogDelete.data('id', id).data('tr', $tr).dialog('open');
			return false;
		});
		
		if ($dialogDelete.length > 0 && dialog) {
			$dialogDelete.dialog({
				autoOpen: false,
				resizable: false,
				draggable: false,
				modal: true,
				width: 450,					
				open: function () {
					$dialogDelete.html("");
					$.get("index.php?controller=pjAdminCalendars&action=pjActionGetMessage&id=" + $dialogDelete.data("id")).done(function (data) {
						$dialogDelete.html(data.text);
					});
				},
				buttons: (function () {
					var btn = {};
					btn[myLabel.btnYes] = function() {
						var $tr = $dialogDelete.data('tr');
						$.get("index.php?controller=pjAdminCalendars&action=pjActionDeleteCalendar&id=" + $dialogDelete.data("id")).done(function (data) {
							$tr.css("backgroundColor", "#FFB4B4").fadeOut("slow", function () {
								var content = $grid.datagrid("option", "content"),
									cache = $grid.datagrid("option", "cache");
								$grid.datagrid("option", "cache", cache);
								$grid.datagrid("load", "index.php?controller=pjAdminCalendars&action=pjActionGetCalendar", "id", "ASC", content.page, content.rowCount);
								$dialogDelete.dialog("close");
							});
						});
					};
					btn[myLabel.btnCancel] = function() {
						$dialogDelete.dialog('close');
					};
					return btn;
				})()
			});
		}
			
		function formatOwner(val, obj) {
			return ['<a href="index.php?controller=pjAdminUsers&action=pjActionUpdate&id=', obj.user_id, '">', obj.user_name, '</a>'].join("");
		}
		
		function formatName(val, obj) {
			return ['<a href="index.php?controller=pjAdmin&action=pjActionRedirect&nextController=pjAdminCalendars&nextAction=pjActionView&calendar_id=', obj.id, '&nextParams=', encodeURIComponent("id=" + obj.id), '">', val, '</a>'].join("");
		}
		
		function onBeforeShow (obj) {
			if (parseInt(obj.id, 10) === pjGrid.currentCalendarId) {
				return false;
			}
			return true;
		}
		function formatReservations(val, obj) {
			if(parseInt(val, 10) > 0)
			{
				return ['<a href="index.php?controller=pjAdminReservations&action=pjActionIndex&calendar_id=', obj.id, '">', val, '</a>'].join("");
			}else{
				return 0;
			}
		}
		if ($("#grid").length > 0 && datagrid) {
			
			var gridOpts = {
				buttons: [{type: "btn-edit pj-button", url: "index.php?controller=pjAdmin&action=pjActionRedirect&nextController=pjAdminCalendars&nextAction=pjActionView&calendar_id={:id}&nextParams=id%3D{:id}"},
				          {type: "btn-settings pj-button", url: "index.php?controller=pjAdmin&action=pjActionRedirect&nextController=pjAdminOptions&nextAction=pjActionIndex&nextParams=tab%3D1&calendar_id={:id}"},
				          {type: "btn-prices pj-button", url: "index.php?controller=pjAdmin&action=pjActionRedirect&nextController=pjAdminCalendars&nextAction=pjActionPrices&calendar_id={:id}"},
				          {type: "custom-delete", title: myLabel.delete, url: "index.php?controller=pjAdminCalendars&action=pjActionDeleteCalendar&id={:id}", beforeShow: onBeforeShow}],
				columns: [{text: myLabel.id, type: "text", sortable: true, editable: false},
				          {text: myLabel.calendar, type: "text", sortable: true, width: 250, renderer: formatName},
				          {text: myLabel.reservations, type: "text", sortable: true, editable: false, width: 100, align: "center", renderer: formatReservations}
				],
				dataUrl: "index.php?controller=pjAdminCalendars&action=pjActionGetCalendar" + pjGrid.queryString,
				dataType: "json",
				fields: ['id', 'name', 'cnt_reservations'],
				paginator: {
					actions: [
						{text: myLabel.deleteSelected, url: "index.php?controller=pjAdminCalendars&action=pjActionDeleteCalendarBulk", render: true, confirmation: myLabel.deleteConfirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminCalendars&action=pjActionSaveCalendar&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				},
				onRender: function () {
					$("#grid").find('.pj-table-icon-btn-settings').text(myLabel.settings);
					$("#grid").find('.pj-table-icon-btn-prices').text(myLabel.prices);
					$("#grid").find('.pj-table-icon-btn-edit').text(myLabel.edit);
				}
			};
			
			if(pjGrid.isAdmin == false)
			{
				gridOpts = {
					buttons: [{type: "btn-edit pj-button", url: "index.php?controller=pjAdmin&action=pjActionRedirect&nextController=pjAdminCalendars&nextAction=pjActionView&calendar_id={:id}&nextParams=id%3D{:id}"},
					          {type: "btn-prices pj-button", url: "index.php?controller=pjAdmin&action=pjActionRedirect&nextController=pjAdminCalendars&nextAction=pjActionPrices&calendar_id={:id}"}],
					columns: [{text: myLabel.id, type: "text", sortable: true, editable: false},
					          {text: myLabel.calendar, type: "text", sortable: true, width: 350, renderer: formatName},
					          {text: myLabel.reservations, type: "text", sortable: true, editable: false, width: 110, align: "center", renderer: formatReservations}
					],
					dataUrl: "index.php?controller=pjAdminCalendars&action=pjActionGetCalendar" + pjGrid.queryString,
					dataType: "json",
					fields: ['id', 'name', 'cnt_reservations'],
					paginator: {
						gotoPage: true,
						paginate: true,
						total: true,
						rowCount: true
					},
					saveUrl: "index.php?controller=pjAdminCalendars&action=pjActionSaveCalendar&id={:id}",
					select: {
						field: "id",
						name: "record[]"
					},
					onRender: function () {
						$("#grid").find('.pj-table-icon-btn-settings').text(myLabel.settings);
						$("#grid").find('.pj-table-icon-btn-prices').text(myLabel.prices);
						$("#grid").find('.pj-table-icon-btn-edit').text(myLabel.edit);
					}
				};
			}
			
			var $grid = $("#grid").datagrid(gridOpts);
			
			$(document).on("submit", ".frm-filter", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = $(this),
					content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					q: $this.find("input[name='q']").val()
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminCalendars&action=pjActionGetCalendar", "id", "ASC", content.page, content.rowCount);
				return false;
			});
			
		}
		
		function formatCurrency(val) {
			if(val == null)
			{
				return pjGrid.currencySign.replace('99', '0.00');
			}else{
				return pjGrid.currencySign.replace('99', val);
			}
		}
		
		function formatData(val, obj) {
			return ['<div style="line-height: 22px"><span class="w60 bold inline_block">', myLabel.status, ':</span><span class="pj-table-cell-label pj-status pj-status-', obj.status, '" style="display: inline-block">', obj.status, '</span>',
			        '<br><span class="w60 bold inline_block">', myLabel.id, ':</span>', obj.uuid,
			        '<br><span class="w60 bold inline_block">', myLabel.name, ':</span>', obj.c_name,
			        '<br><span class="w60 bold inline_block">', myLabel.email, ':</span>', obj.c_email,
			        '<br><span class="w60 bold inline_block">', myLabel.from, ':</span>', $.datagrid._formatDate(obj.date_from, pjGrid.jsDateFormat),
			        '<br><span class="w60 bold inline_block">', myLabel.to, ':</span>', $.datagrid._formatDate(obj.date_to, pjGrid.jsDateFormat),
			        '<br><span class="w60 bold inline_block">', myLabel.amount, ':</span>', formatCurrency(obj.amount),
			        '</div>'
			        ].join("");
		}
		
		if ($("#gridReservations").length > 0 && datagrid) {
			
			var $gridReservations = $("#gridReservations").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminReservations&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminReservations&action=pjActionDeleteReservation&id={:id}"}
				          ],
				columns: [{text: myLabel.today, type: "text", sortable: false, editable: false, width: 270, renderer: formatData}],
				dataUrl: "index.php?controller=pjAdminReservations&action=pjActionGetReservation&calendar_id="+view_calendar_id + pjGrid.queryString,
				dataType: "json",
				fields: ['uuid'],
				paginator: false,
				saveUrl: "index.php?controller=pjAdminReservations&action=pjActionSaveReservation&id={:id}",
				select: false,
				onRender: function () {
					var $a = $(".newReserv"),
						href = $a.attr("href"),
						cache = $gridReservations.datagrid("option", "cache");
					if (cache.time !== undefined && cache.time !== null) {
						var dt = new Date(cache.time * 1000),
							iso = [dt.getFullYear(), dt.getMonth()+1, dt.getDate()].join("-");
						$a.attr("href", href.replace(/&date_from=\d{4}\-\d{2}\-\d{2}/, '&date_from=' + iso));
						$gridReservations.find("th:first").html($.datagrid._formatDate(iso, pjGrid.jsDateFormat));
					}
				}
			});
			
			$("#content").on("click", ".abCalendarLinkDate", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = $(this).parent(),
					content = $gridReservations.datagrid("option", "content"),
					cache = $gridReservations.datagrid("option", "cache");
				content.rowCount = 100;//fix
				if($this.hasClass('abCalendarCellInner'))
				{
					$this = $(this).parent().parent();
				}
				$.extend(cache, {
					"time": $this.data("time")
				});
				$gridReservations.datagrid("option", "cache", cache);
				$gridReservations.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation&calendar_id="+view_calendar_id, "id", "DESC", content.page, content.rowCount);
				return false;
			});
			
			var m = window.location.search.match(/&time=(\d{10})/);
			if (m !== null) {
				var content = $gridReservations.datagrid("option", "content"),
					cache = $gridReservations.datagrid("option", "cache");
				content.rowCount = 100;//fix
				$.extend(cache, {
					"time": m[1]
				});
				$gridReservations.datagrid("option", "cache", cache);
				$gridReservations.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation", "id", "DESC", content.page, content.rowCount);
			}
			
		}
	});
})(jQuery_1_8_2);