var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	"use strict";
	$(function () {
		var $frmCreateReservation = $("#frmCreateReservation"),
			$frmUpdateReservation = $("#frmUpdateReservation"),
			$frmExportReservations = $("#frmExportReservations"),
			$dialogMessage = $("#dialogMessage"),
			$dialogCalculate = $("#dialogCalculate"),
			$dialogResend = $("#dialogResend"),
			$dialogSendCancel = $("#dialogSendCancel"),
			$dialogSaveConfirm = $("#dialogSaveConfirm"),
			$tabs = $("#tabs"),
			tipsy = ($.fn.tipsy !== undefined),
			spinner = ($.fn.spinner !== undefined),
			tabs = ($.fn.tabs !== undefined),
			validate = ($.fn.validate !== undefined),
			datepicker = ($.fn.datepicker !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			dialog = ($.fn.dialog !== undefined);

		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		
		if (tipsy) {
			$(".listing-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				gravity: "nw",
				className: "tipsy-listing"
			});
		}
		if (spinner) {
			$(".field-int").spinner({
				min: 1
			});
		}
		function editUrl()
		{
			var $cal = $("#calendar_id");
			var cal = $cal.find("option:selected").val();
			if (cal == '') 
			{
				$('.pj-icon-edit').hide();
			}else{
				var href = $('.pj-icon-edit').attr('data-href');
				href = href.replace(/{ID}/g, cal);
				$('.pj-icon-edit').attr('href', href).show();
			}
		}
		function attachTinyMce(options) {
			if (window.tinymce !== undefined) {
				tinymce.EditorManager.editors = [];
				var defaults = {
					selector: "textarea.mceEditor",
					theme: "modern",
					width: 610,
					height: 330,
					plugins: [
				         "advlist autolink link image lists charmap print preview hr anchor pagebreak",
				         "searchreplace visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
				         "save table contextmenu directionality emoticons template paste textcolor"
				    ],
				    toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullpage | forecolor backcolor emoticons"
				};
				
				var settings = $.extend({}, defaults, options);
				
				tinymce.init(settings);
			}
		}
		
		function getDashboard() {
			$.get("index.php?controller=pjAdminReservations&action=pjActionGetDashboard", {
				year: arguments[0],
				month: arguments[1]
			}).done(function (data) {
				$("#boxDashboard").html(data);
			});
		}
		
		function calcPrices(callback) {
			$.post("index.php?controller=pjAdminReservations&action=pjActionCalcPrice", $(this).closest("form").serialize()).done(function (data) {
				if (data.status === "OK") {
					$("#amount").val(data.amount);
					$("#extra_price").val(data.extra_price);
					$("#discount_amount").val(data.discount_amount);
					$("#promo_amount").val(data.promo_amount);
					$("#promo_code").val(data.promo_code);
					$("#promo_type").val(data.promo_type);
					$("#deposit").val(data.deposit);
					$("#security").val(data.security);
					$("#tax").val(data.tax);
					$("#tourist_tax").val(data.tourist_tax);
					$("#total").val(data.total);
					
					if($('#pjInvoiceMessage').length > 0)
					{
						if(data.message != '')
						{
							$('#pjInvoiceMessage').html(data.message).show();
						}else{
							$('#pjInvoiceMessage').html("").hide();
						}
					}
					$('#frmAddInvoice').find('input[name="subtotal"]').val(data.diff_amount);
					$('#frmAddInvoice').find('input[name="total"]').val(data.diff_amount);
					$('#frmAddInvoice').find('input[name="paid_deposit"]').val(data.diff_amount);
					$('#invoice_item_unit_price').val(data.diff_amount);
					$('#invoice_item_amount').val(data.diff_amount);
				}

				if (callback !== undefined && typeof callback === "function") {
					callback();
				}
			});
		}
		
		function handleBalance(invoice_total, amount) {
			if (invoice_total < amount) {
				$(".btnBalancePayment").show();
				$(".btnAddInvoice").hide();
			} else {
				$(".btnBalancePayment").hide();
				$(".btnAddInvoice").show();
			}
		}

		function validateMaxPeople()
		{
			var number_of_adults = 0;
			var number_of_chidlren = 0;
			var max_people = parseInt($('#boxMaxPeopleMsg').attr('data-max'));
			if($("select[name='c_adults']").length > 0)
			{
				if($("select[name='c_adults']").val() != '')
				{
					number_of_adults = parseInt($("select[name='c_adults']").val(), 10);
				}
			}
			if($("select[name='c_children']").length > 0)
			{
				number_of_chidlren = parseInt($("select[name='c_children']").val(), 10);
			}
			if(max_people < (number_of_adults + number_of_chidlren) )
			{
				$('#boxMaxPeopleMsg').show();
				$('#boxMinPeopleMsg').hide();
				return false;
			}else{
				$('#boxMaxPeopleMsg').hide();
				return true;
			}
		}
		function validateMinPeople()
		{
			var number_of_adults = 0;
			var number_of_chidlren = 0;
			var min_people = parseInt($('#boxMinPeopleMsg').attr('data-min'));
			if($("select[name='c_adults']").length > 0)
			{
				if($("select[name='c_adults']").val() != '')
				{
					number_of_adults = parseInt($("select[name='c_adults']").val(), 10);
				}
			}
			if($("select[name='c_children']").length > 0)
			{
				number_of_chidlren = parseInt($("select[name='c_children']").val(), 10);
			}
			if(min_people > (number_of_adults + number_of_chidlren) )
			{
				$('#boxMinPeopleMsg').show();
				$('#boxMaxPeopleMsg').hide();
				return false;
			}else{
				$('#boxMinPeopleMsg').hide();
				return true;
			}
		}
		function hasChanges()
		{
			if($('#status').attr('data-old') != $('#status').val())
			{
				return 100;
			}
			if($('#date_from').attr('data-old') != $('#date_from').val())
			{
				return 101;
			}
			if($('#date_to').attr('data-old') != $('#date_to').val())
			{
				return 102;
			}
			if($('#c_adults').attr('data-old') != $('#c_adults').val())
			{
				return 102;
			}
			if($('#c_children').attr('data-old') != $('#c_children').val())
			{
				return 103;
			}
			if($('#payment_method').attr('data-old') != $('#payment_method').val())
			{
				return 104;
			}
			if($('#amount').attr('data-old') != $('#amount').val())
			{
				return 105;
			}
			if($('#extra_price').attr('data-old') != $('#extra_price').val())
			{
				return 106;
			}
			if($('#deposit').attr('data-old') != $('#deposit').val())
			{
				return 107;
			}
			if($('#tax').attr('data-old') != $('#tax').val())
			{
				return 108;
			}
			if($('#tourist_tax').attr('data-old') != $('#tourist_tax').val())
			{
				return 109;
			}
			if($('#security').attr('data-old') != $('#security').val())
			{
				return 110;
			}
			if($('#promo_amount').attr('data-old') != $('#promo_amount').val())
			{
				return 111;
			}
			if($('#discount_amount').attr('data-old') != $('#discount_amount').val())
			{
				return 112;
			}
			if($('#c_notes').val() != $('#hidden_c_notes').val())
			{
				return 113;
			}
			if($('#c_address').attr('data-old') != $('#c_address').val())
			{
				return 114;
			}
			if($('#c_city').attr('data-old') != $('#c_city').val())
			{
				return 115;
			}
			if($('#c_country').attr('data-old') != $('#c_country').val())
			{
				return 116;
			}
			if($('#c_state').attr('data-old') != $('#c_state').val())
			{
				return 117;
			}
			if($('#c_zip').attr('data-old') != $('#c_zip').val())
			{
				return 118;
			}
			if($('#c_name').attr('data-old') != $('#c_name').val())
			{
				return 119;
			}
			if($('#c_email').attr('data-old') != $('#c_email').val())
			{
				return 120;
			}
			if($('#c_phone').attr('data-old') != $('#c_phone').val())
			{
				return 121;
			}
			return 200;
		}
		$("#content").on("click", ".btnCalculate", function () {
			if ($dialogCalculate.length > 0 && dialog) {
				$dialogCalculate.data("btn", this).dialog("open");
			} else {
				calcPrices.call(this);
			}
		}).on("focusin", ".datepick", function (e) {
			var minDateTime, maxDateTime,
				$this = $(this),
				custom = {},
				o = {
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev"),
					
				};
			switch ($this.attr("name")) {
			case "date_from":
				if($(".datepick[name='date_to']").val() != '')
				{
					var maxDate = $(".datepick[name='date_to']").datepicker({
						firstDay: $this.attr("rel"),
						dateFormat: $this.attr("rev"),
					}).datepicker("getDate");
					$(".datepick[name='date_to']").datepicker("destroy").removeAttr("id");
					if (maxDate !== null) {
						custom.maxDate = maxDate;
					}
				}
				break;
			case "date_to":
				if($(".datepick[name='date_from']").val() != '')
				{
					var minDate = $(".datepick[name='date_from']").datepicker({
						firstDay: $this.attr("rel"),
						dateFormat: $this.attr("rev")
					}).datepicker("getDate");
					console.log('test');
					$(".datepick[name='date_from']").datepicker("destroy").removeAttr("id");
					if (minDate !== null) {
						custom.minDate = minDate;
					}
				}
				break;
			}
			$(this).datepicker($.extend(o, custom));
		}).delegate(".cal-prev, .cal-next", "click", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this);
			getDashboard.apply(null, [$this.data("year"), $this.data("month")]);
			return false;
		}).on("click", ".btnCreateInvoice", function (e) {
			if(hasChanges.call(null) == 200)
			{
				$('#frmAddInvoice').trigger("submit");
			}else{
				$dialogSaveConfirm.dialog('open');
			}
		}).on("click", ".btnAddInvoice", function (e) {
			$('#frmAddInvoice').trigger("submit");
		}).on("click", ".btnBalancePayment", function () {
			$("#frmBalancePayment").trigger("submit");
		}).on("click", ".btnResend", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if (dialog && $dialogResend.length > 0) {
				$dialogResend.dialog("open");
			}
			return false;
		}).on("click", ".btnSendCancel", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if (dialog && $dialogSendCancel.length > 0) {
				$dialogSendCancel.dialog("open");
			}
			return false;
		});
		if ($dialogSaveConfirm.length > 0 && dialog) {
			$dialogSaveConfirm.dialog({
				autoOpen: false,
				resizable: false,
				draggable: false,
				modal: true,
				width: 350,					
				buttons: (function () {
					var btn = {};
					btn[myLabel.btnYes] = function() {
						$dialogSaveConfirm.dialog('close');
						$frmUpdateReservation.submit();
					};
					btn[myLabel.btnNo] = function() {
						$("#frmAddInvoice").trigger("submit");
						$dialogSaveConfirm.dialog('close');
					};
					return btn;
				})()
			});
		}
		if ($dialogResend.length > 0 && dialog) {
			$dialogResend.dialog({
				autoOpen: false,
				resizable: false,
				draggable: false,
				modal: true,
				width: 645,					
				open: function () {
					$.post("index.php?controller=pjAdminReservations&action=pjActionGetMessage&locale_id=" + $dialogResend.find("select[name='locale_id']").val(), $frmUpdateReservation.serialize()).done(function (data) {
						$('#abResendContent').html(data);
						attachTinyMce.call(null);
					});
				},
				close: function () {
					$dialogResend.find("textarea").text("").end().find("input[type='text']").val("");
				},
				buttons: (function () {
					var btn = {};
					btn[myLabel.btnSend] = function() {
						var c_email = null;
						var calendar_id = null;
						if($('#c_email').length > 0)
						{
							c_email = $('#c_email').val();
						}
						if($frmUpdateReservation.find("input[name='calendar_id']").length > 0)
						{
							calendar_id = $frmUpdateReservation.find("input[name='calendar_id']").val();
						}
						var message = tinymce.activeEditor.getContent();
						var post_data = {
							message: message,
							subject: $dialogResend.find("input[type='text']").eq(0).val(),
							c_email: c_email,
							calendar_id: calendar_id
						};
						$("#dialogResend").next(".ui-dialog-buttonpane").find(".ui-button").attr("disabled", true).addClass("ui-state-disabled");
						$.post("index.php?controller=pjAdminReservations&action=pjActionSendMessage", post_data).done(function (data) {
							$("#dialogResend").next(".ui-dialog-buttonpane").find(".ui-button").removeAttr("disabled").removeClass("ui-state-disabled");
							$dialogResend.dialog('close');
						});
					};
					btn[myLabel.btnCancel] = function() {
						$(this).dialog('close');
					};
					return btn;
				})()
			});
		}
		
		if ($dialogSendCancel.length > 0 && dialog) {
			$dialogSendCancel.dialog({
				autoOpen: false,
				resizable: false,
				draggable: false,
				modal: true,
				width: 645,					
				open: function () {
					$.post("index.php?controller=pjAdminReservations&action=pjActionGetCancelMessage&locale_id=" + $dialogSendCancel.find("select[name='locale_id']").val(), $frmUpdateReservation.serialize()).done(function (data) {
						$('#abSendCancelContent').html(data);
						attachTinyMce.call(null);
					});
				},
				close: function () {
					$dialogSendCancel.find("textarea").text("").end().find("input[type='text']").val("");
				},
				buttons: (function () {
					var btn = {};
					btn[myLabel.btnSend] = function() {
						var c_email = null;
						var calendar_id = null;
						if($('#c_email').length > 0)
						{
							c_email = $('#c_email').val();
						}
						if($frmUpdateReservation.find("input[name='calendar_id']").length > 0)
						{
							calendar_id = $frmUpdateReservation.find("input[name='calendar_id']").val();
						}
						var message = tinymce.activeEditor.getContent();
						var post_data = {
							message: message,
							subject: $dialogSendCancel.find("input[type='text']").eq(0).val(),
							c_email: c_email,
							calendar_id: calendar_id
						};
						$("#dialogSendCancel").next(".ui-dialog-buttonpane").find(".ui-button").attr("disabled", true).addClass("ui-state-disabled");
						$.post("index.php?controller=pjAdminReservations&action=pjActionSendCancelMessage", post_data).done(function (data) {
							$("#dialogSendCancel").next(".ui-dialog-buttonpane").find(".ui-button").removeAttr("disabled").removeClass("ui-state-disabled");
							$dialogSendCancel.dialog('close');
						});
					};
					btn[myLabel.btnCancel] = function() {
						$dialogSendCancel.dialog('close');
					};
					return btn;
				})()
			});
		}
		
		if (validate) {
			$.validator.addMethod("validDates", function (value, element) {
				return parseInt(value, 10) === 1; 
			}, myLabel.dateRangeValidation);
		}
		if ($frmCreateReservation.length > 0 && validate) {
			$frmCreateReservation.validate({
				rules: {
					"dates": "validDates",
					"uuid": {
						required: true,
						remote: "index.php?controller=pjAdminReservations&action=pjActionCheckUnique"
					}
				},
				messages:{
					"uuid":{
						remote: myLabel.duplicatedUniqueID
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ".ignore",
				submitHandler: function(form)
				{
					if(validateMaxPeople.call(null) == true && validateMinPeople.call(null) == true)
					{
						form.submit()
					}
					return false;
				}
			});
		}
		if ($frmUpdateReservation.length > 0 && validate) {
			
			$frmUpdateReservation.validate({
				rules: {
					"dates": "validDates",
					"uuid": {
						required: true,
						remote: "index.php?controller=pjAdminReservations&action=pjActionCheckUnique&id=" + $frmUpdateReservation.find("input[name='id']").val()
					}
				},
				messages:{
					"uuid":{
						remote: myLabel.duplicatedUniqueID
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ".ignore",
				submitHandler: function(form)
				{
					if(validateMaxPeople.call(null) == true && validateMinPeople.call(null) == true)
					{
						form.submit()
					}
					return false;
				}
			});
			
			$frmUpdateReservation.on("keyup", "#amount", function () {
				handleBalance.call(null, myLabel.invoice_total, parseFloat($(this).val()));
			});
			
			if ($dialogMessage.length > 0) {
				var buttons = {};
				buttons[myLabel.btnContinue] = function() {
					var $this = $(this);
					if ($this.find("#dialog_confirm").is(":checked")) {
						var qs = ["&message=", $this.find("textarea").eq(0).val(), "&subject=", $this.find("input[type='text']").eq(0).val()].join("");
						$.post("index.php?controller=pjAdminReservations&action=pjActionSendMessage", $frmUpdateReservation.serialize() + qs).done(function (data) {
							$frmUpdateReservation.unbind(".custom").submit();
							$this.dialog('close');
						});
					} else {
						$frmUpdateReservation.unbind(".custom").submit();
						$this.dialog('close');
					}
				};
				buttons[myLabel.btnCancel] = function() {
					$(this).dialog('close');
				};
				$dialogMessage.dialog({
					autoOpen: false,
					resizable: false,
					draggable: false,
					modal: true,
					width: 510,					
					open: function () {
						$.post("index.php?controller=pjAdminReservations&action=pjActionGetMessage", $frmUpdateReservation.serialize()).done(function (data) {
							$dialogMessage
								.find("textarea").text(data.body)
								.end()
								.find("input[type='text']").val(data.subject);
							
						});
					},
					close: function () {
						$dialogMessage.find("textarea").text("").end().find("input[type='text']").val("");
					},
					buttons: buttons
				});
			}
		}

		function checkDates(date_from, date_to, calendar_id, id) {
			$.get("index.php?controller=pjAdminReservations&action=pjActionCheckDates", {
				"date_from": date_from,
				"date_to": date_to,
				"calendar_id": calendar_id,
				"id": id
			}).done(function (data) {
				if (data.code === undefined) {
					return;
				}
				switch (data.code) {
				case 200:
					$("input#dates").val('1');
					break;
				case 100:
					$("input#dates").val('0');
					break;
				}
			});
		}
		
		if ($frmCreateReservation.length > 0 || $frmUpdateReservation.length > 0) {
			jQuery.validator.addMethod("pjNumber", function(value, element) {
				
				var currency_format = parseInt($(element).attr('data-currency_format'), 10);
				var regex = /^((\d+)|(\d{1,3})(\,\d{3}|)*)(\.\d{1,2}|)$/;
				if(currency_format == 1)
				{
					regex = /^((\d+)|(\d{1,3})(\,\d{3}|)*)(\.\d{1,2}|)$/;
				}else if(currency_format == 2){
					regex = /^((\d+)|(\d{1,3})(\ \d{3}|)*)(\.\d{1,2}|)$/;
				}else if(currency_format == 3){
					regex = /^((\d+)|(\d{1,3})(\.\d{3}|)*)(\,\d{1,2}|)$/;
				}else if(currency_format == 4){
					regex = /^((\d+)|(\d{1,3})(\ \d{3}|)*)(\,\d{1,2}|)$/;
				}
				if(regex.test(value))
				{
					return true;
				}else{
					if(currency_format == 3 || currency_format == 4)
					{
						regex = /^((\d+)|(\d{1,3})(\\d{3}|)*)(\.\d{1,2}|)$/;
						if(regex.test(value))
						{
							return true;
						}else{
							return false;
						}
					}else{
						return false;
					}
				}
			});
			var $date_from = $("#date_from");
			$date_from.datepicker({
				firstDay: $date_from.attr("rel"),
				dateFormat: $date_from.attr("rev"),
				minDate: new Date(),
				onSelect: function (dateText, inst) {
					var to, $form, cal_id, res_id, 
						$dt = $("#date_to"),
						d = $dt.datepicker("getDate");
					
					$dt.datepicker("option", "minDate", dateText);
					
					if (d !== null) {
						to = [d.getFullYear(), d.getMonth() + 1, d.getDate()].join("-");
						$form = $(this).closest("form");
						
						res_id = $form.find("input[name='id']").val();  
						if(res_id>0) cal_id = $form.find("input[name='calendar_id']").val();
						else  cal_id = $form.find("select[name='calendar_id']").val();
						
						checkDates.call(null, 
							[inst.selectedYear, inst.selectedMonth + 1, inst.selectedDay].join("-"), 
							to, 
							cal_id,
							res_id
						);
					}
				}
			});
			
			var $date_to = $("#date_to");
			var minDateTo = new Date();
			if($date_from.val() != '')
			{
				minDateTo = $date_from.val();
			}
			$date_to.datepicker({
				firstDay: $date_to.attr("rel"),
				dateFormat: $date_to.attr("rev"),
				minDate: minDateTo,
				onSelect: function (dateText, inst) {
					var from, $form, cal_id, res_id, 
						d = $("#date_from").datepicker("getDate");
					
					if (d !== null) {
						from = [d.getFullYear(), d.getMonth() + 1, d.getDate()].join("-");
						$form = $(this).closest("form");
						
						res_id = $form.find("input[name='id']").val();
						if(res_id>0) cal_id = $form.find("input[name='calendar_id']").val();
						else  cal_id = $form.find("select[name='calendar_id']").val();
						
						checkDates.call(null, 
							from, 
							[inst.selectedYear, inst.selectedMonth + 1, inst.selectedDay].join("-"), 
							cal_id,
							res_id
						);
					}
				}
			});
		}

		var $PM = $("#payment_method");
		if ($PM.length > 0) {
			$PM.bind("change", function () {
				if ($("option:selected", this).val() == 'creditcard') {
					$(".vrCC").show();
				} else {
					$(".vrCC").hide();
				}
			});	
		}
		
		function formatDefault (str) {
			return myLabel[str] || str;
		}
		
		function formatId (str, obj) {
			return ['<a href="index.php?controller=pjInvoice&action=pjActionUpdate&id=', obj.id, '">#', str, '</a>'].join("");
		}
		
		function formatTotal (str, obj) {
			return obj.total_formated;
		}
		
		function formatCreated(str) {
			if (str === null || str.length === 0) {
				return myLabel.empty_datetime;
			}
			
			if (str === '0000-00-00 00:00:00') {
				return myLabel.invalid_datetime;
			}
			
			if (str.match(/\d{4}-\d{2}-\d{2}\s\d{2}:\d{2}:\d{2}/) !== null) {
				var x = str.split(" "),
					date = x[0],
					time = x[1],
					dx = date.split("-"),
					tx = time.split(":"),
					y = dx[0],
					m = parseInt(dx[1], 10) - 1,
					d = dx[2],
					hh = tx[0],
					mm = tx[1],
					ss = tx[2];
				return $.datagrid.formatDate(new Date(y, m, d, hh, mm, ss), pjGrid.jsDateFormat + ", hh:mm:ss");
			}
		}
		
		if ($("#grid_invoices").length > 0 && datagrid) {
			var $grid_invoices = $("#grid_invoices").datagrid({
				buttons: [{type: "edit", title: 'Edit', url: "index.php?controller=pjInvoice&action=pjActionUpdate&id={:id}"},
				          {type: "delete", title: 'Delete', url: "index.php?controller=pjInvoice&action=pjActionDelete&id={:id}"}],
				columns: [
				    {text: myLabel.num, type: "text", sortable: true, editable: false, renderer: formatId},
				    {text: myLabel.order_id, type: "text", sortable: true, editable: false},
				    {text: myLabel.issue_date, type: "date", sortable: true, editable: false, renderer: $.datagrid._formatDate, dateFormat: pjGrid.jsDateFormat},
				    {text: myLabel.due_date, type: "date", sortable: true, editable: false, renderer: $.datagrid._formatDate, dateFormat: pjGrid.jsDateFormat},
				    {text: myLabel.created, type: "text", sortable: true, editable: false, renderer: formatCreated},
				    {text: myLabel.status, type: "text", sortable: true, editable: false, renderer: formatDefault},	
				    {text: myLabel.amount_paid, type: "text", sortable: true, editable: false, align: "right"}
				],
				dataUrl: "index.php?controller=pjInvoice&action=pjActionGetInvoices&q=" + $frmUpdateReservation.find("input[name='uuid']").val(),
				dataType: "json",
				fields: ['uuid', 'order_id', 'issue_date', 'due_date', 'created', 'status', 'paid_deposit'],
				paginator: {
					actions: [
					   {text: myLabel.delete_title, url: "index.php?controller=pjInvoice&action=pjActionDeleteBulk", render: true, confirmation: myLabel.delete_body}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		function formatCalendar(val, obj) {
			if (pjGrid.isAdmin === 0) {
				return val + '<br/>' + obj.uuid;
			}
			return ['<a href="index.php?controller=pjAdmin&action=pjActionRedirect&nextController=pjAdminCalendars&nextAction=pjActionView&calendar_id=', obj.calendar_id, '&nextParams=', encodeURIComponent("id=" + obj.calendar_id), '">', val, '</a>', '<br/>', obj.uuid].join("");
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", title: myLabel.edit, url: "index.php?controller=pjAdminReservations&action=pjActionUpdate&id={:id}"},
				          {type: "delete", title: myLabel.delete, url: "index.php?controller=pjAdminReservations&action=pjActionDeleteReservation&id={:id}"}
				          ],
				columns: [{text: myLabel.client_name, type: "text", sortable: true, editable: false},
				          {text: myLabel.calendar, type: "text", sortable: true, editable: false, renderer: formatCalendar},
				          {text: myLabel.from, type: "date", sortable: true, editable: true,
								jqDateFormat: pjGrid.jqDateFormat,
								width: 100,
								editableWidth: 80, 
								renderer: $.datagrid._formatDate, 
								editableRenderer: $.datagrid._formatDate,
								dateFormat: pjGrid.jsDateFormat},
				          {text: myLabel.to, type: "date", sortable: true, editable: true, 
								jqDateFormat: pjGrid.jqDateFormat,
								width: 100,
								editableWidth: 80,
								renderer: $.datagrid._formatDate, 
								editableRenderer: $.datagrid._formatDate,
								dateFormat: pjGrid.jsDateFormat},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 90, options: [
				                                                                                     {label: myLabel.pending, value: "Pending"}, 
				                                                                                     {label: myLabel.confirmed, value: "Confirmed"},
				                                                                                     {label: myLabel.cancelled, value: "Cancelled"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminReservations&action=pjActionGetReservation" + pjGrid.queryString,
				dataType: "json",
				fields: ['c_name', 'calendar', 'date_from', 'date_to', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.exportSelected, url: "index.php?controller=pjAdminReservations&action=pjActionExportReservation", ajax: false},
					   {text: myLabel.deleteSelected, url: "index.php?controller=pjAdminReservations&action=pjActionDeleteReservationBulk", render: true, confirmation: myLabel.deleteConfirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminReservations&action=pjActionSaveReservation&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
			
			$(document).on("click", ".btn-all", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
				var content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					q: "",
					uuid: "",
					status: "",
					calendar_id: "",
					c_name: "",
					c_email: "",
					date: "",
					date_from: "",
					date_to: "",
					amount_from: "",
					amount_to: "",
					current_week: "",
					last_7days: ""
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation", "id", "DESC", content.page, content.rowCount);
				return false;
			}).on("click", ".btn-today", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
				var content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache"),
					today = new Date();
				$.extend(cache, {
					date: [today.getFullYear(), today.getMonth() + 1, today.getDate()].join("-")
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation", "id", "DESC", content.page, content.rowCount);
				return false;
			}).on("click", ".btn-confirmed", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
				var content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					date: "",
					status: "Confirmed"
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation", "id", "DESC", content.page, content.rowCount);
				return false;
			}).on("click", ".btn-pending", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
				var content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					date: "",
					status: "Pending"
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation", "id", "DESC", content.page, content.rowCount);
				return false;
			}).on("click", ".btn-cancelled", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
				var content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					date: "",
					status: "Cancelled"
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation", "id", "DESC", content.page, content.rowCount);
				return false;
			}).on("submit", ".frm-filter", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = $(this),
					content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					q: $this.find("input[name='q']").val(),
					uuid: "",
					status: "",
					calendar_id: "",
					c_name: "",
					c_email: "",
					date: "",
					date_from: "",
					date_to: "",
					amount_from: "",
					amount_to: "",
					current_week: "",
					last_7days: ""
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation", "id", "ASC", content.page, content.rowCount);
				return false;
			}).on("click", ".pj-button-detailed, .pj-button-detailed-arrow", function (e) {
				e.stopPropagation();
				var $advForm = $(".pj-form-filter-advanced");
				if ($advForm.is(":visible")) {
					$advForm.hide().find("input[type='text'], select").val("");
				} else {
					$advForm.show();
				}
			}).on("submit", ".frm-filter-advanced", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var obj = {q: ""},
					$this = $(this),
					arr = $this.serializeArray(),
					content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				for (var i = 0, iCnt = arr.length; i < iCnt; i++) {
					obj[arr[i].name] = arr[i].value;
				}
				$.extend(cache, obj);
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation", "id", "ASC", content.page, content.rowCount);
				return false;
			}).on("reset", ".frm-filter-advanced", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$(".pj-button-detailed").trigger("click");
				return false;
			});
			
		}
		
		if ($dialogCalculate.length > 0 && dialog) {
			var btn = {};
			btn[myLabel.btnContinue] = function () {
				calcPrices.call($dialogCalculate.data("btn"), function () {
					$dialogCalculate.dialog("close");
				});
			};
			btn[myLabel.btnCancel] = function () {
				$(this).dialog("close");
			};
			$dialogCalculate.dialog({
				modal: true,
				autoOpen: false,
				resizable: false,
				draggable: false,
				buttons: btn
			});
		}

		if ($frmExportReservations.length > 0 && validate) {
			$frmExportReservations.validate({
				rules: {
					"password": {
						required: function(){
							if($('#feed').is(':checked'))
							{
								return true;
							}else{
								return false;
							}
						}
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ".ignore"
			});
			
			if($("#format").val() == 'csv')
			{
				$('#delimiterContainer').show();
			}else{
				$('#delimiterContainer').hide();
			}
		}
		
		$(document).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
		}).on("click change", "#dialog_confirm", function (e) {
			if ($(this).is(":checked")) {
				$dialogMessage.find("textarea, input[type='text']").removeAttr("readonly").removeClass("pj-form-field-readonly");
			} else {
				$dialogMessage.find("textarea, input[type='text']").attr("readonly", "readonly").addClass("pj-form-field-readonly");
			}
		}).on("change", "#calendar_id", function (e) {
			var $form = $(this).closest("form"),
				d,
				s,
				from = '',
				to = '';
				
				d = $("#date_from").datepicker("getDate");
				if(d !== null) from = [d.getFullYear(), d.getMonth() + 1, d.getDate()].join("-");
	
				s = $("#date_to").datepicker("getDate");
				if(s !== null) to = [s.getFullYear(), s.getMonth() + 1, s.getDate()].join("-");  
	
			if($(this).val() != '' && from != '' && to)
			{
				checkDates.call(null, 
						from, 
						to, 
						$(this).val(),
						$form.find("input[name='id']").val()
					);
			}
			
			$.get("index.php?controller=pjAdminReservations&action=pjActionGetAdults", {
				"id": $(this).val()
			}).done(function (data) {
				$('#boxAdults').html(data);
				validateMaxPeople.call(null);
				validateMinPeople.call(null);
			});
			
			$.get("index.php?controller=pjAdminReservations&action=pjActionGetChildren", {
				"id": $(this).val()
			}).done(function (data) {
				$('#boxChildren').html(data);
			});
			
			$.get("index.php?controller=pjAdminReservations&action=pjActionGetExtras", {
				"id": $(this).val()
			}).done(function (data) {
				
				if (data.code != undefined && data.status == 'ERR') {
					$('#boxExtras').html('').hide();
				}else{
					$('#boxExtras').html(data).show();
					if (spinner) {
						$('#boxExtras').find(".field-int").spinner({
							min: 1
						});
					}
				}
				
			});
			editUrl.call(null);
		}).on("change", "#export_period", function (e) {
			var period = $(this).val();
			if(period == 'last')
			{
				$('#last_label').show();
				$('#next_label').hide();
				$('#range_label').hide();
			}else if(period == 'all'){
				$('#last_label').hide();
				$('#next_label').hide();
				$('#range_label').hide();
			}else if(period == 'range'){
				$('#last_label').hide();
				$('#next_label').hide();
				$('#range_label').show();
			}else{
				$('#last_label').hide();
				$('#next_label').show();
				$('#range_label').hide();
			}
		}).on("click", "#file", function (e) {
			$('#abSubmitButton').val(myLabel.btn_export);
			$('.abFeedContainer').hide();
			$('.abPassowrdContainer').hide();
			$("#export_period option[value='all']").show();
			$("#export_period option[value='range']").show();
		}).on("click", "#feed", function (e) {
			$('.abPassowrdContainer').show();
			$('#abSubmitButton').val(myLabel.btn_get_url);
			if($('#export_period').val() == 'all' || $('#export_period').val() == 'range')
			{
				$('#export_period').val('next');
				$('#last_label').hide();
				$('#range_label').hide();
				$('#next_label').show();
			}
			/*$("#export_period option[value='all']").hide();*/
			$("#export_period option[value='range']").hide();
		}).on("click", "#format", function (e) {
			if($(this).val() == 'csv')
			{
				$('#delimiterContainer').show();
			}else{
				$('#delimiterContainer').hide();
			}
		}).on("focus", "#reservations_feed", function (e) {
			$(this).select();
		}).on("change", "#resend_language", function (e) {
			$.post("index.php?controller=pjAdminReservations&action=pjActionGetMessage&locale_id=" + $dialogResend.find("select[name='locale_id']").val(), $frmUpdateReservation.serialize()).done(function (data) {
				$('#abResendContent').html(data);
				attachTinyMce.call(null);
			});
		}).on("change", "#c_adults, #c_children", function (e) {
			validateMaxPeople.call(null);
			validateMinPeople.call(null);
		}).on("keydown", ".abTextQty", function (e) {
			if (e.shiftKey == true) {
                e.preventDefault();
            }
			if ((e.keyCode >= 48 && e.keyCode <= 57) || (e.keyCode >= 96 && e.keyCode <= 105) || e.keyCode == 8 || e.keyCode == 9 || e.keyCode == 37 || e.keyCode == 39 || e.keyCode == 46) {
				
            } else {
            	e.preventDefault();
            } 
		}).on("click", ".pj-button-save-close", function (e) {
			$frmUpdateReservation.append('<input type="hidden" name="close" value="1" />');
			$frmUpdateReservation.submit();
			if (e && e.preventDefault) {
				e.preventDefault();
			}
		});
		
		if ($("#export_grid").length > 0 && datagrid) 
		{
			if($('input[name="type"]:checked').val() == 'feed')
			{
				/*$("#export_period option[value='all']").hide();*/
				$("#export_period option[value='range']").hide();
			}
			var $grid = $("#export_grid").datagrid({
				buttons: [{type: "view", url: "index.php?controller=pjAdminReservations&action=pjActionExportFeed{:params}", 'target' : "_blank"},
				          {type: "delete", url: "index.php?controller=pjAdminReservations&action=pjActionDeletePassword&id={:id}"}
				          ],
				columns: [{text: myLabel.calendar, type: "text", sortable: false, editable: false},
				          {text: myLabel.format, type: "text", sortable: false, editable: false},
				          {text: myLabel.delimiter, type: "text", sortable: false, editable: false},
				          {text: myLabel.reservations, type: "text", sortable: false, editable: false},
				          {text: myLabel.period, type: "text", sortable: false, editable: false}
				          ],
				dataUrl: "index.php?controller=pjAdminReservations&action=pjActionGetPassword",
				dataType: "json",
				fields: ['calendar_name', 'format', 'delimiter', 'type', 'period'],
				paginator: {
					actions: [
					   {text: myLabel.deleteSelected, url: "index.php?controller=pjAdminReservations&action=pjActionDeletePasswordBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminReservations&action=pjActionSavePassword&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
	});
})(jQuery_1_8_2);