<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminReservations extends pjAdmin
{
	public function pjActionCheckAvail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$from_arr = pjUtil::convertDateTime($_POST['dt_from'], $this->option_arr['o_date_format'], $this->option_arr['o_time_format']);
			$to_arr = pjUtil::convertDateTime($_POST['dt_to'], $this->option_arr['o_date_format'], $this->option_arr['o_time_format']);
			
			$pjReservationModel = pjReservationModel::factory();
			if(isset($_POST['id']))
			{
				$pjReservationModel->where('t1.id <>', $_POST['id']);
			}
			$start_date = $from_arr['iso_date'];
			$end_date = $to_arr['iso_date'];
			$from_datetime_iso = $from_arr['iso_date_time'];
			$to_datetime_iso = $to_arr['iso_date_time'];
			$cnt_reservations = $pjReservationModel
				->where('t1.resource_id', $_POST['resource_id'])
				->where("( (`dt_from` BETWEEN '$from_datetime_iso' AND '$to_datetime_iso') OR (`dt_to` BETWEEN '$from_datetime_iso' AND '$to_datetime_iso') OR ('$from_datetime_iso' BETWEEN `dt_from` AND `dt_to`)  OR ('$to_datetime_iso' BETWEEN `dt_from` AND `dt_to`) )")
				->where("t1.status", 'confirmed')
				->findCount()
				->getData();
			if($cnt_reservations > 0)
			{
				pjAppController::jsonResponse(array('status' => 'ERR', 'text' => __('lblDoubleReservation', true)));
			}
			
			$seconds = abs($from_arr['ts'] - $to_arr['ts']);
			$hours = ceil($seconds / 3600);
			$arr = pjResourceModel::factory()->find($_POST['resource_id'])->getData();
			if((int) $arr['min_reservation_length'] > 0)
			{
				$min_hours = $arr['min_reservation_length'];
				$min_text = __('front_min_reservation_length_hours', true);
					
				switch ($arr['min_reservation_length_unit'])
				{
					case 'day':
						$min_hours = $arr['min_reservation_length'] * 24;
						$min_text = __('front_min_reservation_length_days', true);
						break;
					case 'week':
						$min_hours = $arr['min_reservation_length'] * 24 * 7;
						$min_text = __('front_min_reservation_length_weeks', true);
						break;
					case 'month':
						$min_hours = $arr['min_reservation_length'] * 24 * 30;
						$min_text = __('front_min_reservation_length_months', true);
						break;
				}
				if($hours < $min_hours)
				{
					$min_text = str_replace("{NUM}", $arr['min_reservation_length'], $min_text);
					pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 104, 'text' => $min_text));
				}
			}
			
			if((int) $arr['max_reservation_length'] > 0)
			{
				$max_hours = $arr['max_reservation_length'];
				$max_text = __('front_max_reservation_length_hours', true);
				switch ($arr['max_reservation_length_unit'])
				{
					case 'day':
						$max_hours = $arr['max_reservation_length'] * 24;
						$max_text = __('front_max_reservation_length_days', true);
						break;
					case 'week':
						$max_hours = $arr['max_reservation_length'] * 24 * 7;
						$max_text = __('front_max_reservation_length_weeks', true);
						break;
					case 'month':
						$max_hours = $arr['max_reservation_length'] * 24 * 30;
						$max_text = __('front_max_reservation_length_months', true);
						break;
				}
				if($hours > $max_hours)
				{
					$max_text = str_replace("{NUM}", $arr['max_reservation_length'], $max_text);
					pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 105, 'text' => $max_text));
				}
			}
			if((int) $arr['reservation_length_limit'] > 0)
			{
				$from_iso = $from_arr['iso_date'];
				$to_iso = $to_arr['iso_date'];
				$from_ts = $from_arr['ts'];
				$start_date = $from_arr['iso_date'];
				$end_date = $to_arr['iso_date'];
					
				switch ($arr['reservation_length_limit_per']) {
					case 'hour':
						$start_date = $from_iso;
						$end_date = $to_iso;
						break;
					case 'day':
						$start_date = $from_iso;
						$end_date = $to_iso;
						break;
					case 'week':
						list($start_date, $end_date) = pjUtil::getWeekRange($from_iso, $this->option_arr['o_week_start']);
						break;
					case 'month':
						$start_date = date('Y-m-d', mktime(0, 0, 0, date('m', $from_ts), 1, date('Y', $from_ts)));
						$end_date = date('Y-m-t', mktime(0, 0, 0, date('m', $from_ts), 1, date('Y', $from_ts)));
						break;
					case 'year':
						$start_date = date('Y-m-d', mktime(0, 0, 0, 1, 1, date('Y', $from_ts)));
						$end_date = date('Y-m-d', mktime(0, 0, 0, 12, 31, date('Y', $from_ts)));
						break;
				}

				$pjReservationModel->reset();
				if(isset($_POST['id']))
				{
					$pjReservationModel->where('t1.id <>', $_POST['id']);
				}
				$reservation_arr = $pjReservationModel
					->where('t1.resource_id', $_POST['resource_id'])
					->where("( (DATE(dt_from) BETWEEN '$start_date' AND '$end_date') OR (DATE(dt_to) BETWEEN '$start_date' AND '$end_date') OR ('$start_date' BETWEEN DATE(dt_from) AND DATE(dt_to))  OR ('$end_date' BETWEEN DATE(dt_from) AND DATE(dt_to)) )")
					->where("t1.status", 'confirmed')
					->orderBy("created DESC")
					->findAll()
					->getData();
					
				$total_hours = $hours;
					
				foreach($reservation_arr as $resv)
				{
					$seconds = abs(strtotime($resv['dt_to']) - strtotime($resv['dt_from']));
					$total_hours += ceil($seconds / 3600);
				}
					
				$limit_hours = $arr['reservation_length_limit'];
				switch ($arr['reservation_length_limit_unit']) {
					case 'day':
						$limit_hours = $arr['reservation_length_limit'] * 24;
						break;
					case 'week':
						$limit_hours = $arr['reservation_length_limit'] * 24 * 7;
						break;
					case 'month':
						$limit_hours = $arr['reservation_length_limit'] * 24 * 30;
						break;
				}
				if($total_hours > $limit_hours)
				{
					$limit_msg = __('limit_msg', true);
					$text = $limit_msg[$arr['reservation_length_limit_unit'] . '_' . $arr['reservation_length_limit_per']];
					$text = str_replace("{NUMBER}", $arr['reservation_length_limit'], $text);
					pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 106, 'text' => $text));
				}
			}
			
			pjAppController::jsonResponse(array('status' => 'OK', 'text' => ''));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$user_arr = pjUserModel::factory()
				->where('t1.status', 'T')
				->orderBy("t1.name ASC")
				->findAll()
				->getData();
			
			$pjResourceModel = pjResourceModel::factory();
			if($this->isOwner())
			{
				$pjResourceModel->where("(t1.id IN(SELECT TRU.resource_id FROM `".pjResourceUserModel::factory()->getTable()."` AS `TRU` WHERE `TRU`.user_id='".$this->getUserId()."') )");
				$user_arr = array();
			}
			$resource_arr = pjResourceModel::factory()	
				->select('t1.*, t2.content as title')
				->join('pjMultiLang', "t2.model='pjResource' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
				->orderBy("t2.content ASC")
				->findAll()
				->getData();
			
			$this->set('user_arr', $user_arr);
			$this->set('resource_arr', $resource_arr);
			
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminReservations.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetReservation()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjReservationModel = pjReservationModel::factory()
				->join('pjUser', "t2.id=t1.user_id", 'left outer')
				->join('pjMultiLang', "t3.model='pjResource' AND t3.foreign_id=t1.resource_id AND t3.field='title' AND t3.locale='".$this->getLocaleId()."'", 'left outer');
				
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjReservationModel->where("(t1.id = '$q' OR t1.uuid = '$q' OR t2.name LIKE '%$q%' OR t3.content LIKE '%$q%')");
			}
			
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('confirmed','cancelled','pending','archive')))
			{
				$pjReservationModel->where('t1.status', $_GET['status']);
			}
			if (isset($_GET['user_id']) && (int) $_GET['user_id'] > 0)
			{
				$pjReservationModel->where('t1.user_id', $_GET['user_id']);
			}
			if (isset($_GET['resource_id']) && (int) $_GET['resource_id'] > 0)
			{
				$pjReservationModel->where('t1.resource_id', $_GET['resource_id']);
			}
			if($this->isOwner())
			{
				$pjReservationModel->where("(t1.resource_id IN(SELECT TRU.resource_id FROM `".pjResourceUserModel::factory()->getTable()."` AS `TRU` WHERE `TRU`.user_id='".$this->getUserId()."') )");
			}
			if (isset($_GET['dt_from']) && !empty($_GET['dt_from']) && isset($_GET['dt_to']) && !empty($_GET['dt_to']))
			{
				$dt_from = pjUtil::formatDate($_GET['dt_from'], $this->option_arr['o_date_format']);
				$dt_to = pjUtil::formatDate($_GET['dt_to'], $this->option_arr['o_date_format']);
				$pjReservationModel->where("( ('$dt_from' BETWEEN `dt_from` AND `dt_to`) OR ('$dt_to' BETWEEN `dt_from` AND `dt_to`) OR (`dt_from` BETWEEN '$dt_from' AND '$dt_to') OR (`dt_to` BETWEEN '$dt_from' AND '$dt_to'))");
			}elseif(isset($_GET['dt_from']) && !empty($_GET['dt_from']) && isset($_GET['dt_to']) && empty($_GET['dt_to'])){
				$dt_from = pjUtil::formatDate($_GET['dt_from'], $this->option_arr['o_date_format']);
				$pjReservationModel->where("( (`dt_from` >= '$dt_from') OR (`dt_to` >= '$dt_from'))");
			}elseif(isset($_GET['dt_from']) && empty($_GET['dt_from']) && isset($_GET['dt_to']) && !empty($_GET['dt_to'])){
				$dt_to = pjUtil::formatDate($_GET['dt_to'], $this->option_arr['o_date_format']);
				$pjReservationModel->where("( (`dt_from` <= '$dt_to') OR (`dt_to` <= '$dt_to'))");
			}
			
			$column = 'created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjReservationModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = array();
			
			$data = $pjReservationModel
				->select('t1.*, t2.name, t3.content AS resource')
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			
			foreach($data as $k => $v)
			{
				$v['dt_from'] = date($this->option_arr['o_date_format'], strtotime($v['dt_from'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['dt_from']));
				$v['dt_to'] = date($this->option_arr['o_date_format'], strtotime($v['dt_to'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['dt_to']));
				
				$seconds = abs(strtotime($v['dt_to']) - strtotime($v['dt_from']));
				$duration_arr = pjUtil::calDuration($seconds);
				$duration_str = array();
				if($duration_arr['months'] > 0)
				{
					$duration_str[] = $duration_arr['months'] . ' ' . ($duration_arr['months'] != 1 ? __('front_months', true) : __('front_month', true));
				}
				if($duration_arr['weeks'] > 0)
				{
					$duration_str[] = $duration_arr['weeks'] . ' ' . ($duration_arr['weeks'] != 1 ? __('front_weeks', true) : __('front_week', true));
				}else if(!empty($duration_str)){
					$duration_str[] = '0 ' . __('front_weeks', true);
				}
				if($duration_arr['days'] > 0)
				{
					$duration_str[] = $duration_arr['days'] . ' ' . ($duration_arr['days'] != 1 ? __('front_days', true) : __('front_day', true));
				}else if(!empty($duration_str)){
					$duration_str[] = '0 ' . __('front_days', true);
				}
				if($duration_arr['hours'] > 0)
				{
					$duration_str[] = $duration_arr['hours'] . ' ' . ($duration_arr['hours'] != 1 ? __('front_hours', true) : __('front_hour', true));
				}
				$v['duration'] = implode(" ", $duration_str);
				
				$data[$k] = $v;
			}
			
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionSaveReservation()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			pjReservationModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
		}
		exit;
	}
	
	public function pjActionExportReservation()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjReservationModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Reservations-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionDeleteReservation()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjReservationModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteReservationBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjReservationModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['reservation_create']))
			{
				$from_arr = pjUtil::convertDateTime($_POST['dt_from'], $this->option_arr['o_date_format'], $this->option_arr['o_time_format']);
				$to_arr = pjUtil::convertDateTime($_POST['dt_to'], $this->option_arr['o_date_format'], $this->option_arr['o_time_format']);
				
				$seconds = abs($to_arr['ts'] - $from_arr['ts']);
				$hours = ceil($seconds / 3600);
				
				$data = array();
				$data['uuid'] = time();
				$data['ip'] = pjUtil::getClientIp();
				$data['created'] = date('Y-m-d H:i:s');
				$data['dt_from'] = $from_arr['iso_date_time'];
				$data['dt_to'] = $to_arr['iso_date_time'];
				$data['hours'] = $hours;
				
				$id = pjReservationModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				
				if ($id !== false && (int) $id > 0)
				{
					$err = 'ARS03';
				}else{
					$err = 'ARS04';
				}
				
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminReservations&action=pjActionIndex&err=$err");
			}else{
				
				$pjResourceModel = pjResourceModel::factory();
				if($this->isOwner())
				{
					$pjResourceModel->where("(t1.id IN(SELECT TRU.resource_id FROM `".pjResourceUserModel::factory()->getTable()."` AS `TRU` WHERE `TRU`.user_id='".$this->getUserId()."') )");
				}
				
				$resource_arr = $pjResourceModel
					->select('t1.id, t2.content AS title')
					->join('pjMultiLang', "t2.model='pjResource' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`title` ASC')
					->findAll()
					->getData();
						
				$this->set('resource_arr', $resource_arr);
				
				$this->appendJs('jquery-ui-sliderAccess.js', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendJs('jquery-ui-timepicker-addon.js', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendCss('jquery-ui-timepicker-addon.css', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminReservations.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['reservation_update']))
			{
				$pjReservationModel = pjReservationModel::factory();
				
				$arr = $pjReservationModel->find($_POST['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminReservations&action=pjActionIndex&err=ARS08");
				}
							
				$data = array();
				$data['ip'] = pjUtil::getClientIp();
				$data['modified'] = date('Y-m-d H:i:s');
				
				$from_arr = pjUtil::convertDateTime($_POST['dt_from'], $this->option_arr['o_date_format'], $this->option_arr['o_time_format']);
				$to_arr = pjUtil::convertDateTime($_POST['dt_to'], $this->option_arr['o_date_format'], $this->option_arr['o_time_format']);
				$seconds = abs($to_arr['ts'] - $from_arr['ts']);
				$hours = ceil($seconds / 3600);
				$data['dt_from'] = $from_arr['iso_date_time'];
				$data['dt_to'] = $to_arr['iso_date_time'];
				$data['hours'] = $hours;
				
				$pjReservationModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				
				$err = 'ARS01';
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminReservations&action=pjActionIndex&err=$err");
			}else{
				
				$arr = pjReservationModel::factory()
					->join('pjUser', "t2.id=t1.user_id", 'left outer')
					->select('t1.*,t2.name')
					->find($_GET['id'])
					->getData();

				if(count($arr) <= 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminReservations&action=pjActionIndex&err=ARS08");
				}
				$this->set('arr', $arr);
				
				$pjResourceModel = pjResourceModel::factory();
				if($this->isOwner())
				{
					$pjResourceModel->where("(t1.id IN(SELECT TRU.resource_id FROM `".pjResourceUserModel::factory()->getTable()."` AS `TRU` WHERE `TRU`.user_id='".$this->getUserId()."') )");
				}
				$resource_arr = $pjResourceModel
					->select('t1.id, t2.content AS title')
					->join('pjMultiLang', "t2.model='pjResource' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`title` ASC')
					->findAll()
					->getData();
						
				$this->set('resource_arr', $resource_arr);
				
				$user_arr = pjResourceUserModel::factory()
					->select('t1.*, t2.name')
					->join('pjUser', "t2.id=t1.user_id", 'left outer')
					->where('resource_id', $arr['resource_id'])
					->orderBy('t2.name ASC')
					->findAll()
					->getData();
				
				$this->set('user_arr', $user_arr);
				
				$this->appendJs('jquery-ui-sliderAccess.js', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendJs('jquery-ui-timepicker-addon.js', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendCss('jquery-ui-timepicker-addon.css', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminReservations.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetUsers()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['resource_id']) && (int)$_GET['resource_id'] > 0)
			{
				$user_arr = pjResourceUserModel::factory()
					->select('t1.*, t2.name')
					->join('pjUser', "t2.id=t1.user_id", 'left outer')
					->where('resource_id', $_GET['resource_id'])
					->orderBy('t2.name ASC')
					->findAll()
					->getData();
				$this->set('user_arr', $user_arr);
			}
		}
	}
	
	public function pjActionPrint()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$this->setLayout('pjActionPrint');
			
			$id_arr = explode("|", $_POST['id']);
			if(!empty($id_arr))
			{
				$data = pjReservationModel::factory()
					->select('t1.*, t2.name, t3.content AS resource')
					->join('pjUser', "t2.id=t1.user_id", 'left outer')
					->join('pjMultiLang', "t3.model='pjResource' AND t3.foreign_id=t1.resource_id AND t3.field='title' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
					->select('t1.*, t2.name, t3.content AS resource')
					->whereIn('t1.id', $id_arr)
					->orderBy("created DESC")
					->findAll()
					->getData();
				
				foreach($data as $k => $v)
				{
					$v['dt_from'] = date($this->option_arr['o_date_format'], strtotime($v['dt_from'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['dt_from']));
					$v['dt_to'] = date($this->option_arr['o_date_format'], strtotime($v['dt_to'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['dt_to']));
				
					$seconds = abs(strtotime($v['dt_to']) - strtotime($v['dt_from']));
					$duration_arr = pjUtil::calDuration($seconds);
					$duration_str = array();
					if($duration_arr['months'] > 0)
					{
						$duration_str[] = $duration_arr['months'] . ' ' . ($duration_arr['months'] != 1 ? __('front_months', true) : __('front_month', true));
					}
					if($duration_arr['weeks'] > 0)
					{
						$duration_str[] = $duration_arr['weeks'] . ' ' . ($duration_arr['weeks'] != 1 ? __('front_weeks', true) : __('front_week', true));
					}else if(!empty($duration_str)){
						$duration_str[] = '0 ' . __('front_weeks', true);
					}
					if($duration_arr['days'] > 0)
					{
						$duration_str[] = $duration_arr['days'] . ' ' . ($duration_arr['days'] != 1 ? __('front_days', true) : __('front_day', true));
					}else if(!empty($duration_str)){
						$duration_str[] = '0 ' . __('front_days', true);
					}
					if($duration_arr['hours'] > 0)
					{
						$duration_str[] = $duration_arr['hours'] . ' ' . ($duration_arr['hours'] != 1 ? __('front_hours', true) : __('front_hour', true));
					}
					$v['duration'] = implode(" ", $duration_str);
				
					$data[$k] = $v;
				}
				
				$this->set('data', $data);
			}
		}else{
			$this->set('status', 2);
		}
	}
}
?>