<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminResources extends pjAdmin
{
	public function pjActionCheckLength()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$min_hours = $_POST['min_reservation_length'];
			switch ($_POST['min_reservation_length_unit'])
			{
				case 'day':
					$min_hours = $_POST['min_reservation_length'] * 24;
					break;
				case 'week':
					$min_hours = $_POST['min_reservation_length'] * 24 * 7;
					break;
				case 'month':
					$min_hours = $_POST['min_reservation_length'] * 24 * 30;
					break;
			}
			$max_hours = $_POST['max_reservation_length'];
			switch ($_POST['max_reservation_length_unit'])
			{
				case 'day':
					$max_hours = $_POST['max_reservation_length'] * 24;
					break;
				case 'week':
					$max_hours = $_POST['max_reservation_length'] * 24 * 7;
					break;
				case 'month':
					$max_hours = $_POST['max_reservation_length'] * 24 * 30;
					break;
			}
			if($max_hours == 0 && $min_hours == 0)
			{
				echo 'true';
				exit;
			}
			if($max_hours <= $min_hours)
			{
				echo 'false';
			}else{
				echo 'true';
			}
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isOwner())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminResources&action=pjActionIndex&err=AR05");
			}
			if (isset($_POST['resource_create']))
			{
				$pjResourceModel = pjResourceModel::factory();
				
				$data = array();
				
				$id = $pjResourceModel->setAttributes(array_merge($_POST,$data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AR03';
					
					$pjMultiLangModel = pjMultiLangModel::factory();
					$pjMultiLangModel->saveMultiLang($_POST['i18n'], $id, 'pjResource', 'data');
					
					if (isset($_FILES['image']))
					{
						if($_FILES['image']['error'] == 0)
						{
							if(getimagesize($_FILES['image']["tmp_name"]) != false)
							{
								$Image = new pjImage();
								if ($Image->getErrorCode() !== 200)
								{
									$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
									if ($Image->load($_FILES['image']))
									{
										$resp = $Image->isConvertPossible();
										if ($resp['status'] === true)
										{
											$hash = md5(uniqid(rand(), true));
											$image_path = PJ_UPLOAD_PATH . 'resources/' . $id . '_' . $hash . '.' . $Image->getExtension();
											$thumb_path = PJ_UPLOAD_PATH . 'resources/thumb/' . $id . '_' . $hash . '.' . $Image->getExtension();
											
											$data = array();
											
											$data['image'] = $image_path;
											$data['thumb'] = $thumb_path;
											
											$Image->loadImage($_FILES['image']["tmp_name"]);
											$Image->saveImage($image_path);
												
											$Image->loadImage($_FILES['image']["tmp_name"]);
											$Image->resizeSmart(150, 100);
											$Image->saveImage($thumb_path);
												
											$pjResourceModel->reset()->where('id', $id)->limit(1)->modifyAll($data);
										}
									}
								}
							}else{
								$err = 'AR09';
							}
						}else if($_FILES['image']['error'] != 4){
							$err = 'AR09';
						}
					}
					if($err != 'AR03')
					{
						pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminResources&action=pjActionUpdate&id=$id&err=AR09");
					}
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminResources&action=pjActionUpdate&id=$id&err=$err");
				} else {
					$err = 'AR04';
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminResources&action=pjActionIndex&err=$err");
				}
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
		
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminResources.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteResource()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$pjResourceModel = pjResourceModel::factory();
			$arr = $pjResourceModel->find($_GET['id'])->getData();
			
			if ($pjResourceModel->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				if (file_exists(PJ_INSTALL_PATH . $arr['image'])) 
				{
					@unlink(PJ_INSTALL_PATH . $arr['image']);
				}
				if (file_exists(PJ_INSTALL_PATH . $arr['thumb']))
				{
					@unlink(PJ_INSTALL_PATH . $arr['thumb']);
				}
				
				pjMultiLangModel::factory()->where('model', 'pjResource')->where('foreign_id', $_GET['id'])->eraseAll();
				pjResourceUserModel::factory()->where('resource_id', $_GET['id'])->eraseAll();
								
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteResourceBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$pjResourceModel = pjResourceModel::factory();
				$arr = $pjResourceModel->whereIn('id', $_POST['record'])->findAll()->getData();
				foreach($arr as $v)
				{
					if (file_exists(PJ_INSTALL_PATH . $v['image'])) {
						@unlink(PJ_INSTALL_PATH . $v['image']);
					}
					if (file_exists(PJ_INSTALL_PATH . $v['thumb'])) {
						@unlink(PJ_INSTALL_PATH . $v['thumb']);
					}
				}
				
				$pjResourceModel->reset()->whereIn('id', $_POST['record'])->eraseAll();
				pjMultiLangModel::factory()->where('model', 'pjResource')->whereIn('foreign_id', $_POST['record'])->eraseAll();
				
				pjResourceUserModel::factory()->whereIn('resource_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetResource()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjResourceModel = pjResourceModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjResource' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left');
			
			if (isset($_GET['status']) && !empty($_GET['status']))
			{
				$pjResourceModel->where('t1.status', $_GET['status']);
			}
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjResourceModel->where("(t2.content LIKE '%$q%')");
			}
			if($this->isOwner())
			{
				$pjResourceModel->where("(t1.id IN(SELECT `TRU`.resource_id FROM `".pjResourceUserModel::factory()->getTable()."` AS `TRU` WHERE `TRU`.user_id='".$this->getUserId()."') )");
			}
			
			$column = 'id';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjResourceModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjResourceModel
				->select("t1.*, t2.content AS title, 
							(SELECT COUNT(`TU`.user_id) FROM `".pjResourceUserModel::factory()->getTable()."` AS `TU` WHERE `TU`.resource_id=t1.id) AS cnt_users,
							(SELECT COUNT(`TR`.id) FROM `".pjReservationModel::factory()->getTable()."` AS `TR` WHERE `TR`.resource_id=t1.id) AS cnt_reservations")
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isOwner())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminResources.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveResource()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjResourceModel = pjResourceModel::factory();
			if (!in_array($_POST['column'], $pjResourceModel->i18n))
			{
				$value = $_POST['value'];
				
				$pjResourceModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $value));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjResource', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isOwner())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminResources&action=pjActionIndex&err=AR06");
			}
			if (isset($_POST['resource_update']))
			{
				$pjResourceModel = pjResourceModel::factory();
				
				$err = 'AR01';
				
				$arr = $pjResourceModel->find($_POST['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminResources&action=pjActionIndex&err=AR08");
				}
				
				$data = array();
				$data['make_reservations_public'] = isset($_POST['make_reservations_public']) ? "T" : "F";
				
				if (isset($_FILES['image']))
				{
					if($_FILES['image']['error'] == 0)
					{
						if(getimagesize($_FILES['image']["tmp_name"]) != false)
						{
							$Image = new pjImage();
							if ($Image->getErrorCode() !== 200)
							{
								$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
								if ($Image->load($_FILES['image']))
								{
									$resp = $Image->isConvertPossible();
									if ($resp['status'] === true)
									{
										if(!empty($arr['image']))
										{
											@unlink(PJ_INSTALL_PATH . $arr['image']);
										}
										if(!empty($arr['thumb']))
										{
											@unlink(PJ_INSTALL_PATH . $arr['thumb']);
										}
										
										$hash = md5(uniqid(rand(), true));
										$image_path = PJ_UPLOAD_PATH . 'resources/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
										$thumb_path = PJ_UPLOAD_PATH . 'resources/thumb/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
										
										$Image->loadImage($_FILES['image']["tmp_name"]);
										$Image->saveImage($image_path);
										
										$Image->loadImage($_FILES['image']["tmp_name"]);
										$Image->resizeSmart(150, 100);
										$Image->saveImage($thumb_path);
										
										$data['image'] = $image_path;
										$data['thumb'] = $thumb_path;
									}
								}
							}
						}else{
							$err = 'AR10';
						}
					}else if($_FILES['image']['error'] != 4){
						$err = 'AR10';
					}
				}
				
				$pjResourceModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjResource', 'data');
				}
				
				$pjResourceUserModel = pjResourceUserModel::factory();
				$pjResourceUserModel->where('resource_id', $_POST['id'])->eraseAll();
				if (isset($_POST['user_id']) && is_array($_POST['user_id']) && count($_POST['user_id']) > 0)
				{
					$pjResourceUserModel->reset()->begin();
					foreach ($_POST['user_id'] as $user_id)
					{
						$pjResourceUserModel
							->reset()
							->set('resource_id', $_POST['id'])
							->set('user_id', $user_id)
							->insert();
					}
					$pjResourceUserModel->commit();
				}
				if($err == 'AR01')
				{
					pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminResources&action=pjActionUpdate&id=".$_POST['id']."&tab_id=".$_POST['tab_id']."&err=AR01");
				}else{
					pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminResources&action=pjActionUpdate&id=".$_POST['id']."&err=AR10");
				}
			} else {
				$pjMultiLangModel = pjMultiLangModel::factory();
				
				$arr = pjResourceModel::factory()
					->select("t1.*, (SELECT COUNT(`TR`.id) FROM `".pjReservationModel::factory()->getTable()."` AS `TR` WHERE `TR`.resource_id=t1.id) AS cnt_reservations")
					->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminResources&action=pjActionIndex&err=AR08");
				}
				$arr['i18n'] = $pjMultiLangModel->getMultiLang($arr['id'], 'pjResource');
				$this->set('arr', $arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$this->set('user_arr', pjUserModel::factory()
					->where('t1.status', 'T')
					->where('role_id', 2)
					->orderBy('`name` ASC')
					->findAll()
					->getData());
	
				$this->set('user_id_arr', pjResourceUserModel::factory()
					->where("resource_id", $_GET['id'])
					->findAll()
					->getDataPair(null, "user_id"));
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendJs('pjAdminResources.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteImage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			
			$pjResourceModel = pjResourceModel::factory();
			$arr = $pjResourceModel->find($_GET['id'])->getData(); 
			
			if(!empty($arr))
			{
				if(!empty($arr['image']))
				{					
					@unlink(PJ_INSTALL_PATH . $arr['image']);
				}
				if(!empty($arr['thumb']))
				{
					@unlink(PJ_INSTALL_PATH . $arr['thumb']);
				}
				
				$data = array();
				$data['image'] = ':NULL';
				$data['thumb'] = ':NULL';
				$pjResourceModel->reset()->where(array('id' => $_GET['id']))->limit(1)->modifyAll($data);
				
				$response['code'] = 200;
			}else{
				$response['code'] = 100;
			}
			
			pjAppController::jsonResponse($response);
		}
	}
}
?>