<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	$_yesno = __('_yesno', true);
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminResources&amp;action=pjActionUpdate" method="post" id="frmUpdateResource" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="resource_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		<?php $locale = isset($_GET['locale']) && (int) $_GET['locale'] > 0 ? (int) $_GET['locale'] : $controller->getLocaleId(); ?>
		<input type="hidden" name="locale" value="<?php echo $locale; ?>" />
		
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('tabDetails'); ?></a></li>
				<li><a href="#tabs-2"><?php __('tabOptions'); ?></a></li>
			</ul>
			<div id="tabs-1">
			
				<?php pjUtil::printNotice(__('infoAssetDetailsTitle', true, false), __('infoAssetDetailsDesc', true, false)); ?>
	
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang"></div>
				<?php endif; ?>
				
				<div class="clear_both">
					<p>
						<label class="title"><?php __('lblTotalReservations', false, true); ?></label>
						<span class="inline_block t5">
							<?php
							if((int) $tpl['arr']['cnt_reservations'] != 0)
							{
								?><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminReservations&amp;action=pjActionIndex&resource_id=<?php echo $tpl['arr']['id']; ?>"><?php echo $tpl['arr']['cnt_reservations'];?></a><?php
							}else{
								echo '0';
							} 
							?>
						</span>
					</p>
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblTitle'); ?></label>
							<span class="inline_block">
								<input type="text" id="i18n_title_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][title]" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['title'])); ?>"/>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
					?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblDescription'); ?></label>
							<span class="inline_block">
								<textarea id="i18n_description_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][description]" class="pj-form-field w500 h150<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['description'])); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title"><?php __('lblImage', false, true); ?></label>
						<span class="inline_block">
							<input type="file" name="image" id="image" class="pj-form-field w300"/>
						</span>
					</p>
					<?php
					if(!empty($tpl['arr']['thumb']))
					{
						$image_url = PJ_INSTALL_URL . $tpl['arr']['thumb'];
						?>
						<p id="image_container">
							<label class="title">&nbsp;</label>
							<span class="inline_block">
								<img class="sabs-image" src="<?php echo $image_url; ?>" />
								<a href="javascript:void(0);" class="pj-delete-image" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminResources&amp;action=pjActionDeleteImage&id=<?php echo $tpl['arr']['id'];?>"><?php __('btnDelete');?></a>
							</span>
						</p>
						<?php
					} 
					?>
					<p>
						<label class="title">&nbsp;</label>
						<span class="inline_block">
							<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
							<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminResources&action=pjActionIndex';" />
						</span>
					</p>
				</div>
			</div><!-- #tabs-1 -->
			
			<div id="tabs-2">
				<?php pjUtil::printNotice(__('infoAssetOptionsTitle', true, false), __('infoAssetOptionsDesc', true, false)); ?>
				<?php
				$reservation_length = __('reservation_length', true); 
				$key_arr = array('hour','day','week','month');
				$reservation_length = pjUtil::sortArrayByArray($reservation_length, $key_arr);
				?>
				<p class="p170">
					<label class="title"><?php __('lblMinReservationLength', false, true); ?></label>
					<span class="inline_block">
						<span class="block float_left r10">
							<input type="input" name="min_reservation_length" id="min_reservation_length" value="<?php echo pjSanitize::html($tpl['arr']['min_reservation_length']);?>" class="pj-form-field field-int w100 required pj-length"/>
						</span>
						<select id="min_reservation_length_unit" name="min_reservation_length_unit" class="pj-form-field float_left w100 pj-length">
							<?php
							foreach($reservation_length as $k => $v)
							{
								?><option value="<?php echo $k;?>"<?php echo $k == $tpl['arr']['min_reservation_length_unit'] ? ' selected="selected"' : NULL;?>><?php echo $v;?></option><?php
							} 
							?>
						</select>
					</span>
				</p>
				<p class="p170">
					<label class="title"><?php __('lblMaxReservationLength', false, true); ?></label>
					<span class="inline_block">
						<span class="block float_left r10">
							<input type="input" name="max_reservation_length" id="max_reservation_length" value="<?php echo pjSanitize::html($tpl['arr']['max_reservation_length']);?>" class="pj-form-field field-int w100 pj-length" data-msg-remote="<?php __('lblMaxLengthValidation');?>"/>
							<input type="hidden" id="validate_max" name="validate_max" value="<?php echo pjSanitize::html($tpl['arr']['max_reservation_length']);?>" class="required" data-msg-remote="<?php __('lblMaxLengthValidation');?>"/>
						</span>
						<select id="max_reservation_length_unit" name="max_reservation_length_unit" class="pj-form-field float_left w100 pj-length">
							<?php
							foreach($reservation_length as $k => $v)
							{
								?><option value="<?php echo $k;?>"<?php echo $k == $tpl['arr']['max_reservation_length_unit'] ? ' selected="selected"' : NULL;?>><?php echo $v;?></option><?php
							} 
							?>
						</select>
					</span>
				</p>
				<p class="p170">
					<label class="title"><?php __('lblReservationLengthLimit', false, true); ?></label>
					<span class="inline_block">
						<span class="block float_left r10">
							<input type="input" name="reservation_length_limit" id="reservation_length_limit" value="<?php echo pjSanitize::html($tpl['arr']['reservation_length_limit']);?>" class="pj-form-field field-int w100"/>
						</span>
						<select id="reservation_length_limit_unit" name="reservation_length_limit_unit" class="pj-form-field float_left r10 w100">
							<?php
							foreach($reservation_length as $k => $v)
							{
								?><option value="<?php echo $k;?>"<?php echo $k == $tpl['arr']['reservation_length_limit_unit'] ? ' selected="selected"' : NULL;?>><?php echo $v;?></option><?php
							} 
							?>
						</select>
						<span class="block float_left t5 r10">
							<?php __('lblPer');?>
						</span>
						<?php
						$limit_per = __('limit_per', true);
						$key_arr = array('hour','day','week','month','year');
						$temp_limit_per = pjUtil::sortArrayByArray($limit_per, $key_arr);
						$limit_per = pjUtil::sortArrayByArray($limit_per, $key_arr);
						
						if(!empty($tpl['arr']['reservation_length_limit_unit']))
						{
							switch ($tpl['arr']['reservation_length_limit_unit']) {
								case 'hour':
									unset($limit_per['hour']);
								break;
								case 'day':
									unset($limit_per['hour']);
									unset($limit_per['day']);
								break;
								case 'week':
									unset($limit_per['hour']);
									unset($limit_per['day']);
									unset($limit_per['week']);
								break;
								case 'month':
									unset($limit_per['hour']);
									unset($limit_per['day']);
									unset($limit_per['week']);
									unset($limit_per['month']);
								break;
							}
						}else{
							unset($limit_per['hour']);
						}
						?>
						<span id="pjShbLimitationPer">
							<select name="reservation_length_limit_per" class="pj-form-field float_left r10 w100">
								<?php
								foreach($limit_per as $k => $v)
								{
									?><option value="<?php echo $k;?>"<?php echo $k == $tpl['arr']['reservation_length_limit_per'] ? ' selected="selected"' : NULL;?>><?php echo $v;?></option><?php
								} 
								?>
							</select>
						</span>
					</span>
				</p>
				<p class="p170">
					<label class="title"><?php __('lblUsers', false, true); ?></label>
					<span class="inline_block">
						<?php
						if(!empty($tpl['user_arr']))
						{
							?>
							<select name="user_id[]" id="user_id" multiple="multiple" size="5" class="pj-form-field w300">
								<?php
								foreach($tpl['user_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id'];?>"<?php echo in_array($v['id'], $tpl['user_id_arr']) ? ' selected="selected"' : NULL;?>><?php echo pjSanitize::html($v['name']);?></option><?php
								} 
								?>
							</select>
							<?php
						}else{
							$message = __('lblNoOwnersMessage', true);
							$message = str_replace("{STAG}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminUsers&action=pjActionCreate">', $message);
							$message = str_replace("{ETAG}", "</a>", $message);
							?>
							<span class="block t5"><?php echo $message;?></span>
							<?php 
						} 
						?>
					</span>
				</p>
				<p class="p170">
					<label class="title"><?php __('lblUserCanCancel', false, true); ?></label>
					<span class="inline_block">
						<span class="block float_left r10">
							<input type="input" name="cancel_before" id="cancel_before" value="<?php echo pjSanitize::html($tpl['arr']['cancel_before']);?>" class="pj-form-field field-int w100"/>
						</span>
						<select name="cancel_before_per" class="pj-form-field float_left r10 w100">
							<?php
							foreach($reservation_length as $k => $v)
							{
								?><option value="<?php echo $k;?>"<?php echo $k == $tpl['arr']['cancel_before_per'] ? ' selected="selected"' : NULL;?>><?php echo $v;?></option><?php
							} 
							?>
						</select>
						<span class="block float_left t5 r10">
							<?php __('lblBeforeReservationStart');?>
						</span>
					</span>
				</p>
				<p class="p170">
					<label class="title"><?php __('lblMakeReservationPublic', false, true); ?></label>
					<span class="inline_block t5">
						<input type="checkbox" name="make_reservations_public"<?php echo $tpl['arr']['make_reservations_public'] == 'T' ? ' checked="checked"': NULL;?>/>
					</span>
				</p>
				<p class="p170">
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminResources&action=pjActionIndex';" />
					</span>
				</p>
			</div><!-- #tabs-2 -->
		</div>
	</form>
	
	<div id="dialogDeleteImage" style="display: none" title="<?php __('lblDeleteImage');?>"><?php __('lblDeleteImageConfirm');?></div>
	
	<?php include PJ_VIEWS_PATH . 'pjAdminResources/elements/clone.php'; ?>
		
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.choose = "-- <?php __('lblChoose'); ?> --";
	myLabel.field_required = "<?php __('pj_field_required'); ?>";
	
	var pjLocale = pjLocale || {};
	
	var locale_array = new Array(); 
	pjLocale.langs = <?php echo $tpl['locale_str']; ?>;
	pjLocale.flagPath = "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/";
	<?php
	foreach ($tpl['lp_arr'] as $v)
	{
		?>locale_array.push(<?php echo $v['id'];?>);<?php
	} 
	?>
	myLabel.locale_array = locale_array;
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: pjLocale.langs,
				flagPath: pjLocale.flagPath,
				select: function (event, ui) {
					
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
		$tab_id = explode("-", $_GET['tab_id']);
		$tab_id = (int) $tab_id[1] - 1;
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "active", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>