<?php include_once dirname(__FILE__) . '/elements/header.php';?>
<div class="pjShBBody">
	<div class="form-inline pjShBForm pjShBFormFilters">
		<div class="form-group">
			<label for=""><?php __('front_filter_by');?>:</label>
			<select name="resource_id" class="form-control pjShBFilterBy" data-type="resource">
				<option>-- <?php __('front_select_asset');?> --</option>
				<?php
				foreach($tpl['resource_arr'] as $k => $v)
				{
					?><option value="<?php echo $v['id']?>"<?php echo isset($_GET['resource_id']) ? ($_GET['resource_id'] == $v['id'] ? ' selected="selected"' : NULL) : NULL;?>><?php echo pjSanitize::html($v['title']);?></option><?php
				} 
				?>
			</select>
		</div><!-- /.form-group -->

		<div class="form-group">
			<select name="user_id" class="form-control pjShBFilterBy" data-type="user">
				<option>-- <?php __('front_select_user');?> --</option>
				<?php
				foreach($tpl['user_arr'] as $k => $v)
				{
					?><option value="<?php echo $v['id']?>"<?php echo isset($_GET['user_id']) ? ($_GET['user_id'] == $v['id'] ? ' selected="selected"' : NULL) : NULL;?>><?php echo pjSanitize::html($v['name']);?></option><?php
				} 
				?>
			</select>
		</div><!-- /.form-group -->

		<div class="form-group">
			<label for=""><?php __('front_order_by');?>:</label>

			<?php
			$order_by = __('order_arr', true);
			$key_arr = array('dt_from_SORT_desc','dt_from_SORT_asc','hours_SORT_desc','hours_SORT_asc','status_SORT_desc','status_SORT_asc');
			$order_by = pjUtil::sortArrayByArray($order_by, $key_arr);
			?>
			<select name="order_by" class="form-control  pjShBOrderBy">
				<?php
				foreach($order_by as $k => $v)
				{
					$pair = NULL;
					if(isset($_GET['column']) && isset($_GET['direction']))
					{
						$pair = $_GET['column'] . '_SORT_' . $_GET['direction'];
					}
					?><option value="<?php echo $k;?>"<?php echo $k == $pair ? ' selected="selected"' : NULL?>><?php echo pjSanitize::html($v);?></option><?php
				} 
				?>
			</select>
		</div><!-- /.form-group -->
	</div>
</div>
<?php
$has_paging = 0;
if(!isset($tpl['ERR']))
{
	if(!empty($tpl['arr']))
	{ 
		$has_paging = 1;
		?>
		<div class="pjShBBody">
			<div class="panel panel-default pjShBMyReservations">
				<header class="panel-heading">
					<div class="row">
						<div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
							<p class="panel-title"><?php __('front_asset');?></p><!-- /.panel-title -->
						</div><!-- /.col-lg-4 col-md-4 col-sm-12 col-xs-12 -->
						
						<div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
							<p class="panel-title"><?php __('front_user');?></p><!-- /.panel-title -->
						</div><!-- /.col-lg-4 col-md-4 col-sm-12 col-xs-12 -->
						
						<div class="col-lg-2 col-md-2 col-sm-6 hidden-sm col-xs-6 hidden-xs">
							<p class="panel-title"><?php __('front_from');?></p><!-- /.panel-title -->
						</div><!-- /.col-lg-2 col-md-2 col-sm-6 col-xs-6 -->

						<div class="col-lg-2 col-md-2 col-sm-6 hidden-sm col-xs-6 hidden-xs">
							<p class="panel-title"><?php __('front_to');?></p><!-- /.panel-title -->
						</div><!-- /.col-lg-2 col-md-2 col-sm-6 col-xs-6 -->

						<div class="col-lg-2 col-md-2 col-sm-6 hidden-sm col-xs-6 hidden-xs">
							<p class="panel-title"><?php __('front_duration');?></p><!-- /.panel-title -->
						</div><!-- /.col-lg-2 col-md-2 col-sm-6 col-xs-6 -->

						<div class="col-lg-2 col-md-2 col-sm-6 hidden-sm col-xs-6 hidden-xs">
							<p class="panel-title"><?php __('front_status');?></p><!-- /.panel-title -->
						</div><!-- /.col-lg-2 col-md-2 col-sm-6 col-xs-6 -->
					</div><!-- /.row -->
				</header><!-- /.panel-heading -->
				
				<ul class="list-group">
					<?php
					foreach($tpl['arr'] as $v)
					{ 
						$dt_from = date($tpl['option_arr']['o_date_format'], strtotime($v['dt_from'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['dt_from']));
						$dt_to = date($tpl['option_arr']['o_date_format'], strtotime($v['dt_to'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['dt_to']));
						
						$seconds = abs(strtotime($v['dt_to']) - strtotime($v['dt_from']));
						
						$statuses = __('reservation_statuses', true);
						
						$duration_arr = pjUtil::calDuration($seconds);
						$duration_str = array();
						if($duration_arr['months'] > 0)
						{
							$duration_str[] = $duration_arr['months'] . ' ' . ($duration_arr['months'] != 1 ? __('front_months', true) : __('front_month', true));
						}
						if($duration_arr['weeks'] > 0)
						{
							$duration_str[] = $duration_arr['weeks'] . ' ' . ($duration_arr['weeks'] != 1 ? __('front_weeks', true) : __('front_week', true));
						}else if(!empty($duration_str)){
							$duration_str[] = '0 ' . __('front_weeks', true);
						}
						if($duration_arr['days'] > 0)
						{
							$duration_str[] = $duration_arr['days'] . ' ' . ($duration_arr['days'] != 1 ? __('front_days', true) : __('front_day', true));
						}else if(!empty($duration_str)){
							$duration_str[] = '0 ' . __('front_days', true);
						}
						if($duration_arr['hours'] > 0)
						{
							$duration_str[] = $duration_arr['hours'] . ' ' . ($duration_arr['hours'] != 1 ? __('front_hours', true) : __('front_hour', true));
						}
						$can_cancel = false;
						if($controller->getFrontUserId() == $v['user_id'])
						{
							$seconds = strtotime($v['dt_from']) - time();
							if($seconds > 0)
							{
								$number_of_hours = ceil($seconds / 3600);
								$cancel_hours = $v['cancel_before'];
								switch ($v['cancel_before_per']) {
									case 'day':
										$cancel_hours = $v['cancel_before'] * 24;
										break;
									case 'week':
										$cancel_hours = $v['cancel_before'] * 24 * 7;
										break;
									case 'month':
										$cancel_hours = $v['cancel_before'] * 24 * 30;
										break;
								}
								if($number_of_hours >= $cancel_hours && $v['status'] != 'cancelled')
								{
									$can_cancel = true;
								}
							}
						}
						?>
						<li class="list-group-item pjShBMyReservation">
							<div class="row">
								<div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
									<p class="pjShBMyReservationTitle">
										<a href="#" class="pjShBNewReservation" data-id="<?php echo $v['resource_id'];?>"><?php echo pjSanitize::html($v['resource']);?></a>
									</p><!-- /.pjShBMyReservationTitle -->
								</div><!-- /.col-lg-4 col-md-4 col-sm-12 col-xs-12 -->
								
								<div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
									<p><?php echo pjSanitize::html($v['name']);?></p>
								</div><!-- /.col-lg-4 col-md-4 col-sm-12 col-xs-12 -->
								
								<div class="col-lg-2 col-md-2 col-sm-6 col-xs-6">
									<p><?php echo $dt_from;?></p>
								</div><!-- /.col-lg-2 col-md-2 col-sm-6 col-xs-6 -->

								<div class="col-lg-2 col-md-2 col-sm-6 col-xs-6">
									<p><?php echo $dt_to;?></p>
								</div><!-- /.col-lg-2 col-md-2 col-sm-6 col-xs-6 -->

								<div class="col-lg-2 col-md-2 col-sm-6 col-xs-6">
									<p><?php echo implode(" ", $duration_str);?></p>
								</div><!-- /.col-lg-2 col-md-2 col-sm-6 col-xs-6 -->

								<div class="col-lg-2 col-md-2 col-sm-6 col-xs-6">
									<p class="pjShBstatus pjShBstatus<?php echo ucfirst($v['status']);?>"><?php echo $statuses[$v['status']];?></p>
									<?php
									if($can_cancel == true)
									{ 
										$hash = sha1($v['id'].$v['created'].PJ_SALT);
										?>
										<p class="pjShBstatus"><a href="#" data-toggle="modal" class="pjShBCancelModal btn btn-link" data-id="<?php echo $v['id'];?>" data-hash="<?php echo $hash;?>"><?php __('front_lnk_cancel');?></a></p>
										<?php
									} 
									?>
								</div><!-- /.col-lg-2 col-md-2 col-sm-6 col-xs-6 -->
							</div><!-- /.row -->
						</li><!-- /.list-group-item pjShBMyReservation -->
						<?php
					} 
					?>
				</ul><!-- /.list-group -->
			</div><!-- /.panel panel-default pjShBMyReservations -->
		</div><!-- /.pjShBBody -->
		
		<div class="modal fade pjShBModal" id="pjShBCancelModal_<?php echo $_GET['index'];?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
		  	<div class="modal-dialog">
		    	<div class="modal-content">
				    <div class="modal-body">
				    	<p><?php __('front_cancel_confirmation');?></p>
				    </div>
			      	<div class="modal-footer">
			        	<button type="button" id="pjShBCancelReservation_<?php echo $_GET['index'];?>" class="btn btn-primary"><?php __('front_btn_yes');?></button>
			        	<button type="button" class="btn btn-link" data-dismiss="modal"><?php __('front_btn_no');?></button>
			      	</div>
		    	</div>
		  	</div>
		</div>
		<?php
	}else{
		?>
		<div class="pjShBBody"><?php __('front_no_reservations_found');?></div>
		<?php
		
	}
}else{
	switch ($tpl['ERR']) {
		case 100:
			?><div class="pjShBBody"><div id="pjShBNoPermission_<?php echo $_GET['index'];?>"><?php __('front_no_permissions');?></div></div><?php 
		break;
	}
} 
?>
	
<?php
if($has_paging == 1)
{
	include_once dirname(__FILE__) . '/elements/res_pagination.php';
} 
?>