var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmCreateResource = $("#frmCreateResource"),
			$frmUpdateResource = $("#frmUpdateResource"),
			$dialogDelete = $("#dialogDeleteImage"),
			tabs = ($.fn.tabs !== undefined),
			dialog = ($.fn.dialog !== undefined),
			multiselect = ($.fn.multiselect !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				activate: function (event, ui) {
					$(":input[name='tab_id']").val($(ui.newPanel).prop('id'));
				}
			};
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		if (multiselect) {
			$("#user_id").multiselect({noneSelectedText: myLabel.choose});
		}
		$(".field-int").spinner({
			min: 0,
			stop: function( event, ui ) {
				if($(this).attr('name') == 'min_reservation_length' || $(this).attr('name') == 'max_reservation_length')
				{
					 $('#validate_max').val(Math.ceil(Math.random() * 999999));
				}
			}
		});
		if ($frmCreateResource.length > 0 && validate) {
			$frmCreateResource.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				}
			});
		}
		if ($frmUpdateResource.length > 0 && validate) {
			$frmUpdateResource.validate({
				rules: {
					"validate_max": {
						remote: {
							url: "index.php?controller=pjAdminResources&action=pjActionCheckLength",
							type: 'post',
							data: {
			                    min_reservation_length: function(){ return $('#min_reservation_length').val(); },
			                    min_reservation_length_unit: function(){ return $('#min_reservation_length_unit').val(); },
			                    max_reservation_length: function(){ return $('#max_reservation_length').val(); },
			                    max_reservation_length_unit: function(){ return $('#max_reservation_length_unit').val(); }
			                }
						}
					}
				},
				errorPlacement: function (error, element) {
					if(element.attr('name') == 'min_reservation_length' || element.attr('name') == 'max_reservation_length')
					{
						error.insertAfter(element.parent().parent().parent());
					}else{
						if(element.attr('name') == 'validate_max')
						{
							error.insertAfter(element.parent().parent());
						}else{
							error.insertAfter(element.parent());
						}
					}
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					if (validator.numberOfInvalids()) {
				    	var index = $(validator.errorList[0].element, this).closest("div[id^='tabs-']").index();
				    	if ($tabs.length > 0 && tabs && index !== -1) {
				    		$tabs.tabs(tOpt).tabs("option", "active", index-1);
				    	}
				    };
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				}
			});
		}
		if ($frmCreateResource.length > 0 || $frmUpdateResource.length > 0) 
		{
			if(myLabel.locale_array.length > 0)
			{
				var locale_array = myLabel.locale_array;
				for(var i = 0; i < locale_array.length; i++)
				{
					var name = $("#i18n_title_" + locale_array[i]),
						description = $("#i18n_description_" + locale_array[i]);
					name.rules('add', {
						messages: {
					    	required: myLabel.field_required
					    }
					});
					description.rules('add', {
						messages: {
					    	required: myLabel.field_required
					    }
					});
				}
			}
		}
		if ($dialogDelete.length > 0 && dialog) 
		{
			$dialogDelete.dialog({
				modal: true,
				autoOpen: false,
				resizable: false,
				draggable: false,
				width: 400,
				buttons: (function () {
					var buttons = {};
					buttons[sabsApp.locale.button.delete] = function () {
						$.ajax({
							type: "GET",
							dataType: "json",
							url: $dialogDelete.data('href'),
							success: function (res) {
								if(res.code == 200){
									$('#image_container').remove();
									$dialogDelete.dialog('close');
								}
							}
						});
					};
					buttons[sabsApp.locale.button.cancel] = function () {
						$dialogDelete.dialog("close");
					};
					
					return buttons;
				})()
			});
		}
		function formatImage(val, obj) {
			var src = val ? val : 'app/web/img/backend/90x60.png';
			return ['<a href="index.php?controller=pjAdminResources&action=pjActionUpdate&id=', obj.id ,'"><img src="', src, '" style="width: 84px" /></a>'].join("");
		}
		function formatUsers(val, obj) {
			if(val != 0 || val != '0')
			{
				return '<a href="index.php?controller=pjAdminUsers&action=pjActionIndex&resource_id='+obj.id+'">'+val+'</a>';
			}else{
				return 0;
			}
		}
		function formatReservations(val, obj) {
			if(val != 0 || val != '0')
			{
				return '<a href="index.php?controller=pjAdminReservations&action=pjActionIndex&resource_id='+obj.id+'">'+val+'</a>';
			}else{
				return 0;
			}
		}
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "reservations", url: "index.php?controller=pjAdminReservations&action=pjActionIndex&resource_id={:id}"},
				          {type: "options", url: "index.php?controller=pjAdminResources&action=pjActionUpdate&id={:id}&tab_id=tabs-2"},
				          {type: "edit", url: "index.php?controller=pjAdminResources&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminResources&action=pjActionDeleteResource&id={:id}"}
				          ],
				columns: [{text: myLabel.thumb, type: "text", sortable: false, editable: false, renderer: formatImage, width: 90, align: "center"},
				          {text: myLabel.title, type: "text", sortable: true, editable: true, width: 290, editableWidth: 250},
				          {text: myLabel.users, type: "text", sortable: true, editable: false, width: 60, align: "center", renderer: formatUsers},
				          {text: myLabel.reservations, type: "text", sortable: true, editable: false, width: 100, align: "center", renderer: formatReservations}],
				dataUrl: "index.php?controller=pjAdminResources&action=pjActionGetResource" + pjGrid.queryString,
				dataType: "json",
				fields: ['thumb', 'title', 'cnt_users', 'cnt_reservations'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminResources&action=pjActionDeleteResourceBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminResources&action=pjActionSaveResource&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminResources&action=pjActionGetResource", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminResources&action=pjActionGetResource", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminResources&action=pjActionGetResource", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-delete-image", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$dialogDelete.data('href', $(this).data('href')).dialog("open");
		}).on("change", ".pj-length", function (e) {
			if($('#max_reservation_length').val() == '')
			{
				$('#validate_max').val('');
			}else{
				$('#validate_max').val(Math.ceil(Math.random() * 999999));
			}
		}).on("change", "#reservation_length_limit_unit", function (e) {
			var unit = $(this).val();
			var clone = $('#' + unit + 'Clone').html();
			$('#pjShbLimitationPer').html(clone);
		});
	});
})(jQuery_1_8_2);