(function (window, undefined){
	"use strict";
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	var document = window.document,
		routes = [
		          	{pattern: /^#!\/loadResources$/, eventName: "loadResources"},
		          	{pattern: /^#!\/loadResources\/page:(\d+)?$/, eventName: "loadResources"},
		          	{pattern: /^#!\/loadResource\/id:(\d+)?$/, eventName: "loadResource"},
		          	{pattern: /^#!\/loadReservations$/, eventName: "loadReservations"},
		          	{pattern: /^#!\/loadProfile$/, eventName: "loadProfile"},
		          	{pattern: /^#!\/loadForgot$/, eventName: "loadForgot"},
		          	{pattern: /^#!\/loadLogin$/, eventName: "loadLogin"},
		          	{pattern: /^#!\/loadLogout$/, eventName: "loadLogout"},
		         ];
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnProperty(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function hashBang(value) {
		if (value !== undefined && value.match(/^#!\//) !== null) {
			if (window.location.hash == value) {
				return false;
			}
			window.location.hash = value;
			return true;
		}
		
		return false;
	}
	
	function onHashChange() {
		var i, iCnt, m;
		for (i = 0, iCnt = routes.length; i < iCnt; i++) {
			m = window.location.hash.match(routes[i].pattern);
			if (m !== null) {
				pjQ.$(window).trigger(routes[i].eventName, m.slice(1));
				break;
			}
		}
		if (m === null) {
			pjQ.$(window).trigger("loadResources");
		}
	}
	pjQ.$(window).on("hashchange", function (e) {
    	onHashChange.call(null);
    });
	
	function SharedBooking(opts) {
		if (!(this instanceof SharedBooking)) {
			return new SharedBooking(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	SharedBooking.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	SharedBooking.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	SharedBooking.prototype = {
		reset: function () {
			this.$container = null;			
			this.container = null;
			this.page = 1;
			this.resource_id = null;
			
			this.res_page = 1;
			this.res_resource_id = null;
			this.res_user_id = null;
			this.res_column = null;
			this.res_direction = null;
			this.opts = {};
			
			return this;
		},
		
		disableButtons: function () {
			this.$container.find(".btn").each(function (i, el) {
				pjQ.$(el).attr("disabled", "disabled");
			});
		},
		enableButtons: function () {
			this.$container.find(".btn").removeAttr("disabled");
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjShBContainer_" + self.opts.index);
						
			self.$container = pjQ.$(self.container);
			
			this.$container.on("click.shb", ".fdSelectorLocale", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var locale = pjQ.$(this).data("id");
				self.opts.locale = locale;
				pjQ.$(this).addClass("fdLocaleFocus").parent().parent().find("a.fdSelectorLocale").not(this).removeClass("pcLocaleFocus");
				
				pjQ.$.get([self.opts.folder, "index.php?controller=pjFront&action=pjActionLocale"].join(""), {
					"session_id": self.opts.session_id,
					"locale_id": locale
				}).done(function (data) {
					if (!hashBang("#!/loadResources")) 
					{
						pjQ.$(window).trigger("loadResources");
					}
				}).fail(function () {
					log("Deferred is rejected");
				});
				return false;
			}).on("click.shb", ".pjShBMenuItem", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var hash = pjQ.$(this).data("hash");
				if(hash == 'Logout')
				{
					pjQ.$.get([self.opts.folder, "index.php?controller=pjFront&action=pjActionLogout"].join("")).done(function (data) {
						if(!hashBang("#!/loadLogin"))
						{
							self.loadLogin.call(self);
						}
					}).fail(function () {
						log("Deferred is rejected");
					});
				}else{
					if (!hashBang("#!/" + hash)) 
					{
						pjQ.$(window).trigger(hash);
					}
				}
				return false;
			}).on("click.shb", ".pjShBNewReservation", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var resource_id = pjQ.$(this).data("id");
				if(!hashBang("#!/loadResource/id:" + resource_id))
				{
					self.resource_id = resource_id
					self.loadResource.call(self);
				}
				return false;
			}).on("click.shb", ".pjShBPaging", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var page = pjQ.$(this).data("page");
				if(!hashBang("#!/loadResources/page:" + page))
				{
					self.page = page
					self.loadResources.call(self);
				}
				return false;
			}).on("click.shb", ".pjShBBack", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if(!hashBang("#!/loadResources/page:" + self.page))
				{
					self.loadResources.call(self);
				}
				return false;
			}).on("click.shb", ".pjShBForgotPassword", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if(!hashBang("#!/loadForgot"))
				{
					self.loadForgot.call(self);
				}
				return false;
			}).on("click.shb", ".pjShBLogin", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if(!hashBang("#!/loadLogin"))
				{
					self.loadLogin.call(self);
				}
				return false;
			}).on("click.shb", ".pjShBCancelModal", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var id = pjQ.$(this).attr('data-id');
				var hash = pjQ.$(this).attr('data-hash');
				pjQ.$('#pjShBCancelReservation_' + self.opts.index).attr('data-id', id).attr('data-hash', hash);
				pjQ.$('#pjShBCancelModal_' + self.opts.index).modal('show');
				return false;
			}).on("click.shb", "#pjShBCancelReservation_" + self.opts.index, function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.disableButtons();
				pjQ.$.get([self.opts.folder, "index.php?controller=pjFront&action=pjActionCancelReservation", "&session_id=", self.opts.session_id, "&id=", pjQ.$(this).attr('data-id'), "&hash=", pjQ.$(this).attr('data-hash')].join("")).done(function (data) {
					self.enableButtons();
					if(data.code == '200')
					{
						pjQ.$('#pjShBCancelModal_' + self.opts.index).modal('hide');
						if(!hashBang("#!/loadReservations"))
						{
							self.loadReservations.call(self);
						}
					}
				}).fail(function () {
					
				});
				return false;
			}).on("click.shb", ".pjShBReservationPaging", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var page = pjQ.$(this).data("page");
				if(!hashBang("#!/loadReservations"))
				{
					self.res_page = page;
					self.loadReservations.call(self);
				}
				return false;
			}).on("change.shb", ".pjShBFilterBy", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var value = pjQ.$(this).val();
				var type = pjQ.$(this).attr('data-type');
				if(type == 'resource')
				{
					self.res_resource_id = value;
				}else{
					self.res_user_id = value;
				}
				self.res_page = 1;
				if(!hashBang("#!/loadReservations"))
				{
					self.loadReservations.call(self);
				}
				return false;
			}).on("change.shb", ".pjShBOrderBy", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var value = pjQ.$(this).val();
				var sort_arr = value.split("_SORT_");
				
				self.res_column = sort_arr[0];
				self.res_direction = sort_arr[1];
				if(!hashBang("#!/loadReservations"))
				{
					self.loadReservations.call(self);
				}
				return false;
			}).on("click.shb", ".pjShBSeeAllReservations", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.res_resource_id =  pjQ.$(this).attr("data-id");
				if(!hashBang("#!/loadReservations"))
				{
					self.loadReservations.call(self);
				}
				return false;
			}).on("click.as", ".pjSaCalendarLinkMonth", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = pjQ.$(this);
				var resource_id = pjQ.$('#pjShBReserveForm_' + self.opts.index).find('input[name="id"]').val();
				self.disableButtons();
				pjQ.$.get([self.opts.folder, "index.php?controller=pjFront&action=pjActionCalendar"].join(""), {
					"locale": self.opts.locale,
					"index": self.opts.index,
					"resource_id": resource_id,
					"year": $this.data("year"),
					"month":  $this.data("month")
				}).done(function (data) {
					pjQ.$('#pjShBCalendar_' + self.opts.index).html(data);
					self.enableButtons();
				});
				return false;
			}).on("click.as", ".pjSaCalendarClickable", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = pjQ.$(this);
				var resource_id = pjQ.$('#pjShBReserveForm_' + self.opts.index).find('input[name="id"]').val();
				self.disableButtons();
				pjQ.$('.pjSaCalendarClickable').removeClass('focus');
				$this.addClass('focus');
				pjQ.$.get([self.opts.folder, "index.php?controller=pjFront&action=pjActionGetReservations"].join(""), {
					"locale": self.opts.locale,
					"index": self.opts.index,
					"resource_id": resource_id,
					"date": $this.data("iso")
				}).done(function (data) {
					pjQ.$('#pjShBReservationList_' + self.opts.index).html(data);
					self.enableButtons();
				});
				return false;
			}).on("click.as", ".pjShBStartOver", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				pjQ.$('#pjShBFormFields_' + self.opts.index).show();
				pjQ.$('#pjShBReserveMessage_' + self.opts.index).hide();
				return false;
			});
			
			pjQ.$(window).on("loadResources", this.$container, function (e) {
				switch (arguments.length) {
					case 1:
						self.page = 1;
						break;
					case 2:
						self.page = arguments[1];
						break;
				}
				self.loadResources.call(self);
			}).on("loadResource", this.$container, function (e) {
				switch (arguments.length) {
					case 1:
						if (!hashBang("#!/loadResources")) 
						{
							pjQ.$(window).trigger("loadResources");
						}
						break;
					case 2:
						self.resource_id = arguments[1];
						break;
				}
				self.loadResource.call(self);
			}).on("loadReservations", this.$container, function (e) {
				self.loadReservations.call(self);
			}).on("loadProfile", this.$container, function (e) {
				self.loadProfile.call(self);
			}).on("loadLogout", this.$container, function (e) {
				self.loadLogout.call(self);
			}).on("loadLogin", this.$container, function (e) {
				self.loadLogin.call(self);
			}).on("loadForgot", this.$container, function (e) {
				self.loadForgot.call(self);
			});
			
			if (window.location.hash.length === 0) {
				this.loadResources.call(this);
			} else {
				onHashChange.call(null);
			}
		},
		
		loadResources: function () {
			var self = this,
				index = this.opts.index,
				params = { 
							"locale": this.opts.locale,
							"index": this.opts.index,
							"pjPage": self.page
						 };
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionResources", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
				if (data.code != undefined && data.code == 100) {
					if (!hashBang("#!/loadLogin")) 
					{
						pjQ.$(window).trigger("loadLogin");
					}
				}else{
					self.$container.html(data);
				}
			}).fail(function () {
				
			});
		},
		loadResource: function () {
			var self = this,
				index = this.opts.index,
				params = { 
							"locale": this.opts.locale,
							"index": this.opts.index,
							"id": self.resource_id
						 };
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionResource", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
				if (data.code != undefined && data.code == 100) {
					if (!hashBang("#!/loadLogin")) 
					{
						pjQ.$(window).trigger("loadLogin");
					}
				}else{
					self.$container.html(data);
					self.bindResource();
				}
			}).fail(function () {
				
			});
		},
		bindResource: function(){
			var self = this,
				index = this.opts.index,
				params = { 
							"locale": this.opts.locale,
							"index": this.opts.index
				 		};
			
			var $form = pjQ.$('#pjShBReserveForm_' + index);
			
			if (pjQ.$('.pjShBDate').length) {
				
				moment.locale('en', {
					week: { dow: self.opts.week_start }
				});
				moment.updateLocale('en', {
					months : pjQ.$('#pjShBCalendarLocale').data('months').split("_"),
			        weekdaysMin : pjQ.$('#pjShBCalendarLocale').data('days').split("_")
				});
				
				if(pjQ.$('.pjShBDateFrom').length > 0)
				{
					var currentDate = new Date();
					pjQ.$('.pjShBDateFrom').datetimepicker({
						format: self.opts.momentDateFormat.toUpperCase(),
						locale: moment.locale('en'),
						allowInputToggle: true,
						minDate: new Date(currentDate.getFullYear(), currentDate.getMonth(), currentDate.getDate()),
						ignoreReadonly: true
					});
					pjQ.$('.pjShBDateFrom').on('dp.change', function (e) {
						pjQ.$('.pjShBDateTo').data('DateTimePicker').minDate(e.date);
					});
				}
				if(pjQ.$('.pjShBDateTo').length > 0)
				{
					pjQ.$('.pjShBDateTo').datetimepicker({
						format: self.opts.momentDateFormat.toUpperCase(),
						locale: moment.locale('en'),
						allowInputToggle: true,
						ignoreReadonly: true,
						minDate: new Date(currentDate.getFullYear(), currentDate.getMonth(), currentDate.getDate()),
						useCurrent: false
					});
					pjQ.$('.pjShBDateTo').on('dp.change', function(e) {
						pjQ.$('.pjShBDateFrom').data('DateTimePicker').maxDate(e.date);
					});
				}
				
				pjQ.$('.pjShBTime').on('dp.change', function (e) {
					switch (pjQ.$(this).data('rel')) {
						case 'from':
							pjQ.$('#pjShBHourFrom_' + index).val(e.date.hour());
							pjQ.$('#pjShBMinuteFrom_' + index).val(e.date.minute());
							break;
						case 'to':
							pjQ.$('#pjShBHourTo_' + index).val(e.date.hour());
							pjQ.$('#pjShBMinuteTo_' + index).val(e.date.minute());
							break;
					}
				}).datetimepicker({
					format: self.opts.time_format,
					ignoreReadonly: true,
					allowInputToggle: true
				});
			};
			
			if($form.length > 0)
			{
				$form.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						element.parent().parent().addClass('has-error');
					},
					highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function(form){
		            	self.disableButtons();
		            	pjQ.$.post([self.opts.folder, "index.php?controller=pjFront&action=pjActionReservationSave", "&session_id=", self.opts.session_id].join(""), $form.serialize()).done(function (data) {
							var $pjShBMessage = pjQ.$('#pjShBReserveMessage_' + index);
							var $pjShBErrorMsg = pjQ.$('#pjShBReserveError_' + index);
		            		if(data.status == 'ERR')
							{
		            			$pjShBErrorMsg.html(data.text).css('display', 'inline-block');
		            			setTimeout(function() {
		            				$pjShBErrorMsg.fadeOut();
		            			}, 5000 );
							}else{
								$form.find("input").each(function(e){
									var $element = pjQ.$(this);
									var element_name = pjQ.$(this).attr('name');
									if(element_name == 'date_from')
									{
										$element.val(data.start_date);
									}else if(element_name == 'time_from'){
										$element.val(data.start_time);
									}else if(element_name == 'hour_from'){
										$element.val(data.start_hour);
									}else if(element_name == 'minute_from'){
										$element.val(data.start_minute);
									}else if(element_name == 'id'){
										
									}else{
										$element.val("");
									}
								});
								pjQ.$('#pjShBFormFields_' + self.opts.index).hide();
								$pjShBMessage.show();
							}
		            		self.enableButtons();
						});
						return false;
				    }
				});
			}
		},
		loadReservations: function () {
			var self = this,
				index = this.opts.index,
				params = { 
							"locale": this.opts.locale,
							"index": this.opts.index,
							"pjPage": this.res_page,
							"user_id": this.res_user_id,
							"resource_id": this.res_resource_id,
							"column": this.res_column,
							"direction": this.res_direction
						 };
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionReservations", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
				if (data.code != undefined && data.code == 100) {
					if (!hashBang("#!/loadLogin")) 
					{
						pjQ.$(window).trigger("loadLogin");
					}
				}else{
					self.$container.html(data);
					pjQ.$('.modal-dialog').css("z-index", "9999"); 
				}
			}).fail(function () {
				
			});
		},
		loadProfile: function () {
			var self = this,
				index = this.opts.index,
				params = { 
							"locale": this.opts.locale,
							"index": this.opts.index
						 };
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionProfile", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
				if (data.code != undefined && data.code == 100) {
					if (!hashBang("#!/loadLogin")) 
					{
						pjQ.$(window).trigger("loadLogin");
					}
				}else{
					self.$container.html(data);
					self.bindProfile();
				}
			}).fail(function () {
				
			});
		},
		bindProfile: function(){
			var self = this,
				index = this.opts.index,
				params = { 
						"locale": this.opts.locale,
						"index": this.opts.index
			 		};
		
			var $form = pjQ.$('#pjShBProfile_' + index);
		
			if($form.length > 0)
			{
				$form.validate({
					rules: {
						"email": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckEmail&session_id=" + self.opts.session_id + "&id=" + $form.find("input[name='id']").val()
						}
					},
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						element.parent().parent().addClass('has-error');
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().parent().removeClass('has-success').addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function(form){
		            	self.disableButtons();
		            	pjQ.$.post([self.opts.folder, "index.php?controller=pjFront&action=pjActionProfile", "&session_id=", self.opts.session_id].join(""), $form.serialize()).done(function (data) {
							var $pjShBMessage = pjQ.$('#pjShBProfileMsg_' + index);
		            		if(data.status == 'OK')
							{
		            			$pjShBMessage.html(data.text).parent().show();
							}
		            		self.enableButtons();
		            		setTimeout(function() {
		            			$pjShBMessage.parent().fadeOut();
	            			}, 2000 );
						});
						return false;
				    }
				});
			}
		},
		loadLogout: function () {
			var self = this,
				index = this.opts.index,
				params = { 
							"locale": this.opts.locale,
							"index": this.opts.index
						 };
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionLogout", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
				if (!hashBang("#!/" + data.hash)) 
				{
					pjQ.$(window).trigger("loadLogin");
				}
			}).fail(function () {
				
			});
		},
		loadLogin: function () {
			var self = this,
				index = this.opts.index,
				params = { 
							"locale": this.opts.locale,
							"index": this.opts.index
						 };
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionLogin", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindLogin();
				self.bindRegister();
			}).fail(function () {
				
			});
		},
		bindLogin: function(){
			var self = this,
				index = this.opts.index,
				params = { 
						"locale": this.opts.locale,
						"index": this.opts.index
			 		};
		
			var $form = pjQ.$('#pjShBLoginForm_' + index);
		
			if($form.length > 0)
			{
				$form.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						element.parent().addClass('has-error');
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().removeClass('has-success').addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function(form){
		            	self.disableButtons();
		            	pjQ.$.post([self.opts.folder, "index.php?controller=pjFront&action=pjActionLogin", "&session_id=", self.opts.session_id].join(""), $form.serialize()).done(function (data) {
		            		var $pjShBMessage = pjQ.$('#pjShBLoginMsg_' + index);
		            		if(data.status == 'ERR')
							{
		            			$pjShBMessage.html(data.text).show();
		            			self.enableButtons();
			            		setTimeout(function() {
			            			$pjShBMessage.fadeOut();
		            			}, 3000 );
							}else{
								if (!hashBang("#!/loadResources")) 
								{
									pjQ.$(window).trigger("loadResources");
								}
							}
						});
						return false;
				    }
				});
			}
		},
		bindRegister: function(){
			var self = this,
				index = this.opts.index,
				params = { 
						"locale": this.opts.locale,
						"index": this.opts.index
			 		};
		
			var $form = pjQ.$('#pjShBRegisterForm_' + index);
		
			if($form.length > 0)
			{
				$form.validate({
					rules: {
						"email": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckEmail&session_id=" + self.opts.session_id
						},
					    "repeat_password": {
					    	equalTo: "#pjShBPassword_" + index
					    }
					},
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						element.parent().addClass('has-error');
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().removeClass('has-success').addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function(form){
		            	self.disableButtons();
		            	pjQ.$.post([self.opts.folder, "index.php?controller=pjFront&action=pjActionRegister", "&session_id=", self.opts.session_id].join(""), $form.serialize()).done(function (data) {
		            		var $pjShBMessage = pjQ.$('#pjShBRegisterMsg_' + index);
		            		$pjShBMessage.removeClass('text-danger').removeClass('text-success');
		            		if(data.status == 'ERR')
							{
		            			$pjShBMessage.html(data.text).addClass('text-danger').show();
		            			
							}else{
								$form.find("input").each(function(e){
									if(pjQ.$(this).attr('name') != 'register')
									{
										pjQ.$(this).val("");
									}
								});
								$pjShBMessage.html(data.text).addClass('text-success').show();
							}
		            		self.enableButtons();
		            		setTimeout(function() {
		            			$pjShBMessage.fadeOut();
	            			}, 3000 );
						});
						return false;
				    }
				});
			}
		},
		loadForgot: function () {
			var self = this,
				index = this.opts.index,
				params = { 
							"locale": this.opts.locale,
							"index": this.opts.index
						 };
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionForgot", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindForgot();
			}).fail(function () {
				
			});
		},
		bindForgot: function(){
			var self = this,
				index = this.opts.index,
				params = { 
						"locale": this.opts.locale,
						"index": this.opts.index
			 		};
		
			var $form = pjQ.$('#pjShBForgotForm_' + index);
		
			if($form.length > 0)
			{
				$form.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						element.parent().addClass('has-error');
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().removeClass('has-success').addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function(form){
		            	self.disableButtons();
		            	pjQ.$.post([self.opts.folder, "index.php?controller=pjFront&action=pjActionForgot", "&session_id=", self.opts.session_id].join(""), $form.serialize()).done(function (data) {
		            		var $pjShBMessage = pjQ.$('#pjShBForgotMsg_' + index);
		            		$pjShBMessage.removeClass('text-danger').removeClass('text-success');
		            		if(data.status == 'ERR')
							{
		            			$pjShBMessage.html(data.text).addClass('text-danger').show();
		            			
							}else{
								$form.find("input").each(function(e){
									if(pjQ.$(this).attr('name') != 'forgot')
									{
										pjQ.$(this).val("");
									}
								});
								$pjShBMessage.html(data.text).addClass('text-success').show();
							}
		            		self.enableButtons();
		            		setTimeout(function() {
		            			$pjShBMessage.fadeOut();
	            			}, 3000 );
						});
						return false;
				    }
				});
			}
		}
	};
	
	window.SharedBooking = SharedBooking;	
})(window);