<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjUtil extends pjToolkit
{
	static public function uuid()
	{
		return chr(rand(65,90)) . chr(rand(65,90)) . time();
	}
	static public function getReferer()
	{
		if (isset($_GET['_escaped_fragment_']))
		{
			if (isset($_SERVER['REDIRECT_URL']))
			{
				return $_SERVER['REDIRECT_URL'];
			}
		}
		
		if (isset($_SERVER['HTTP_REFERER']))
		{
			$pos = strpos($_SERVER['HTTP_REFERER'], "#");
			if ($pos !== FALSE)
			{
				return substr($_SERVER['HTTP_REFERER'], 0, $pos);
			}
			return $_SERVER['HTTP_REFERER'];
		}
	}
	
	static public function getClientIp()
	{
		if (isset($_SERVER['HTTP_CLIENT_IP']))
		{
			return $_SERVER['HTTP_CLIENT_IP'];
		} else if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			return $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else if(isset($_SERVER['HTTP_X_FORWARDED'])) {
			return $_SERVER['HTTP_X_FORWARDED'];
		} else if(isset($_SERVER['HTTP_FORWARDED_FOR'])) {
			return $_SERVER['HTTP_FORWARDED_FOR'];
		} else if(isset($_SERVER['HTTP_FORWARDED'])) {
			return $_SERVER['HTTP_FORWARDED'];
		} else if(isset($_SERVER['REMOTE_ADDR'])) {
			return $_SERVER['REMOTE_ADDR'];
		}

		return 'UNKNOWN';
	}
	
	static public function textToHtml($content)
	{
		$content = preg_replace('/\r\n|\n/', '<br />', $content);
		return '<html><head><title></title></head><body>'.$content.'</body></html>';
	}
	static public function toMomemtJS($format)
	{
		$f = str_replace(
				array('Y', 'm', 'n', 'd', 'j'),
				array('yyyy', 'mm', 'm', 'dd', 'd'),
				$format
		);
	
		return $f;
	}
	static public function getTitles(){
		$arr = array();
		$arr[] = 'mr';
		$arr[] = 'mrs';
		$arr[] = 'ms';
		$arr[] = 'dr';
		$arr[] = 'prof';
		$arr[] = 'rev';
		$arr[] = 'other';
		return $arr;
	}
	
	static public function getPostMaxSize()
	{
		$post_max_size = ini_get('post_max_size');
		switch (substr($post_max_size, -1))
		{
			case 'G':
				$post_max_size = (int) $post_max_size * 1024 * 1024 * 1024;
				break;
			case 'M':
				$post_max_size = (int) $post_max_size * 1024 * 1024;
				break;
			case 'K':
				$post_max_size = (int) $post_max_size * 1024;
				break;
		}
		return $post_max_size;
	}
	
	static public function calPrice($price, $return, $option_arr)
	{
		$sub_total = 0;
		$tax = 0;
		$total = 0;
		$deposit = 0;
		
		$sub_total = !empty($price) ? $price : 0;
		if($return)
		{
			$sub_total = !empty($price) ? $price * 2 : 0;
		}
		$tax = ($sub_total * $option_arr['o_tax_payment']) / 100;
		$total = $sub_total + $tax;
		$deposit = 	($total * $option_arr['o_deposit_payment']) / 100;
		
		return compact('sub_total', 'tax', 'total', 'deposit');
	}
	
	static public function arrayMergeDistinct ( array &$array1, array &$array2 )
	{
	  	$merged = $array1;
	
	  	foreach ( $array2 as $key => &$value )
	  	{
	    	if ( is_array ( $value ) && isset ( $merged [$key] ) && is_array ( $merged [$key] ) )
	    	{
	      		$merged [$key] = pjUtil::arrayMergeDistinct ( $merged [$key], $value );
	    	}
	    	else
	    	{
	      		$merged [$key] = $value;
	    	}
	  	}
	
	  	return $merged;
	}
	
	static public function convertToMySQLNumber($number, $option_arr)
	{
		$currency_format = isset($option_arr['o_currency_format']) ? (int) $option_arr['o_currency_format'] : 0;
	
		if($currency_format == 1 || $currency_format == 2)
		{
			if(strpos($number, ".") === false)
			{
				$number = preg_replace('/\s+/', '', $number);
				$number = preg_replace('/[,]/', '', $number);
				$number = (float) $number;
			}else{
				$number = preg_replace('/\s+/', '', $number);
				$number = preg_replace('/[,]/', '', $number);
				$number = (float) $number;
			}
		}else if($currency_format == 3 || $currency_format == 4){
			if(strpos($number, ",") === false)
			{
				if(strpos($number, ".") !== false)
				{
					$number = (float) $number;
				}else{
					$number = preg_replace('/\s+/', '', $number);
					$number = preg_replace('/[.]/', '', $number);
					$number = (float) $number;
				}
			}else{
				$number = preg_replace('/\s+/', '', $number);
				$number = preg_replace('/[.]/', '', $number);
				$number = preg_replace('/[,]/', '.', $number);
				$number = (float) $number;
			}
		}
		return $number;
	}
	
	static public function convertToCurrencyFormat($number, $option_arr)
	{
		$currency_format = isset($option_arr['o_currency_format']) ? (int) $option_arr['o_currency_format'] : 0;
	
		switch ($currency_format) {
			case 1:
				$number = number_format($number, 2, '.', ',');
				break;
			case 2:
				$number = number_format($number, 2, '.', ' ');
				break;
			case 3:
				$number = number_format($number, 2, ',', '.');
				break;
			case 4:
				$number = number_format($number, 2, ',', ' ');
				break;
		}
		return $number;
	}
}
?>