<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminTimetable extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			if (isset($_POST['timetable_create']))
			{
				$data = array();
				if(isset($_POST['every']) && is_array($_POST['every']))
				{
					$data['every'] = implode("|", $_POST['every']);
				}
				if(isset($_POST['time']) && is_array($_POST['time']))
				{
					$temp_arr = array();
					foreach($_POST['time'] as $time)
					{
						$temp_arr[] = date('H:i', strtotime($time));
					}
					sort($temp_arr);
					$data['time'] = implode("|", $temp_arr);
				}
				$id = pjTimetableModel::factory()->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'ATB03';
				}else{
					$err = 'ATB04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminTimetable&action=pjActionIndex&err=$err");
			} else {
	
				$pjLocationModel = pjLocationModel::factory();
				$da_arr = $pjLocationModel
					->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->select("t1.*, t2.content as title")
					->where('t1.type', 'DA')
					->where('t1.status', 'T')
					->orderBy("title ASC")
					->findAll()->getData();
				$this->set('da_arr', $da_arr);
	
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.ui.timepicker.js', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendCss('jquery.ui.timepicker.css', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendJs('pjAdminTimetable.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	public function pjActionGetTimetable()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjTimetableModel = pjTimetableModel::factory();
				
			$pjTimetableModel
				->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.location_id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
				->join('pjMultiLang', "t3.model='pjLine' AND t3.foreign_id=t1.line_id AND t3.field='title' AND t3.locale='".$this->getLocaleId()."'", 'left outer');
				
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjTimetableModel->where("(t2.content LIKE '%$q%' OR t3.content LIKE '%$q%')");
			}
	
			$column = 'location';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}
	
			$total = $pjTimetableModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			$data = $pjTimetableModel
				->select('t1.*, t2.content as location, t3.content as line')
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()->getData();
			foreach($data as $k => $v)
			{
				$v['direction'] = ($v['direction'] == 'arriving' ? __('lblArrivingAt', true) : __('lblDepartingFrom', true)) . ' ' . pjSanitize::html($v['location']);
				$data[$k] = $v;
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	public function pjActionGetLines()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if(isset($_GET['location_id']) && (int) $_GET['location_id'] > 0)
			{
				$line_arr = pjLineModel::factory()
					->select("t1.*, t2.content as title")
					->join('pjMultiLang', "t2.model='pjLine' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('t1.location_id', $_GET['location_id'])
					->orderBy('title ASC')
					->findAll()->getData();
				$this->set('line_arr', $line_arr);
			}
		}
	}
	public function pjActionIndex()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminTimetable.js');
		} else {
			$this->set('status', 2);
		}
	}
	public function pjActionDeleteTimetable()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
				
			if (pjTimetableModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
				
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteTimetableBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjTimetableModel::factory()->reset()->whereIn('id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	public function pjActionSaveTimetable()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjTimetableModel = pjTimetableModel::factory();
				
			$pjTimetableModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
		}
		exit;
	}
	public function pjActionUpdate()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			if (isset($_POST['timetable_update']))
			{
				$data = array();
				if(isset($_POST['every']) && is_array($_POST['every']))
				{
					$data['every'] = implode("|", $_POST['every']);
				}
				if(isset($_POST['time']) && is_array($_POST['time']))
				{
					$temp_arr = array();
					foreach($_POST['time'] as $time)
					{
						$temp_arr[] = date('H:i', strtotime($time));
					}
					sort($temp_arr);
					$data['time'] = implode("|", $temp_arr);
				}
				pjTimetableModel::factory()->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminTimetable&action=pjActionIndex&err=ATB01");
	
			} else {
				$pjMultiLangModel = pjMultiLangModel::factory();
	
				$arr = pjTimetableModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminTimetable&action=pjActionIndex&err=ATB08");
				}
				
				$this->set('arr', $arr);
				
				$pjLocationModel = pjLocationModel::factory();
				$da_arr = $pjLocationModel
					->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->select("t1.*, t2.content as title")
					->where('t1.type', 'DA')
					->where('t1.status', 'T')
					->orderBy("title ASC")
					->findAll()->getData();
				$this->set('da_arr', $da_arr);
	
				$line_arr = pjLineModel::factory()
					->select("t1.*, t2.content as title")
					->join('pjMultiLang', "t2.model='pjLine' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('t1.location_id', $arr['location_id'])
					->orderBy('title ASC')
					->findAll()->getData();
				$this->set('line_arr', $line_arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.ui.timepicker.js', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendCss('jquery.ui.timepicker.css', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendJs('pjAdminTimetable.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	public function pjActionSchedule()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			$pjMultiLangModel = pjMultiLangModel::factory();
	
			$arr = pjTimetableModel::factory()
				->select("t1.*, t2.content as title")
				->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.location_id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
				->find($_GET['id'])->getData();
			if (count($arr) === 0)
			{
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminTimetable&action=pjActionIndex&err=ATB08");
			}

			$this->set('arr', $arr);

			
			$this->appendJs('pjAdminTimetable.js');
		} else {
			$this->set('status', 2);
		}
	}
	public function pjActionGetSchedule()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['line_id']) && (int) $_GET['line_id'] > 0)
			{
				$line_detail_arr = pjLineDetailModel::factory()
					->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.location_id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->select("t1.*, t2.content as title")
					->where('t1.line_id', $_GET['line_id'])
					->orderBy("title ASC")
					->findAll()->getData();
				$this->set('line_detail_arr', $line_detail_arr);
			}
		}
	}
}
?>