<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat today-reservations">
				<div class="info">
					<abbr><?php echo $tpl['cnt_new_reservations'];?></abbr>
					<?php
					if($tpl['cnt_new_reservations'] != 1)
					{
						__('lblNewReservationsToday');
					}else{
						__('lblNewReservationToday');
					} 
					?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat today-transfers">
				<div class="info">
					<abbr><?php echo $tpl['cnt_today_transfers'];?></abbr>
					<?php
					if($tpl['cnt_today_transfers'] != 1)
					{
						__('lblTransfersToday');
					}else{
						echo strtolower(__('lblTransferToday', true, false));
					} 
					?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblLatestReservations');?> (<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionIndex"><?php __('lblDashViewAll'); ?></a>)</div>
			<div class="dashboard_column_top"><?php __('lblTransfersToday');?> (<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionIndex&amp;date=<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']);?>"><?php __('lblDashViewAll'); ?></a>)&nbsp;&nbsp;&nbsp;<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionPrint&amp;today=yes" target="_blank"><?php __('lblPrint'); ?></a></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list">
					<?php
					$statuses = __('booking_statuses', true, false);
					if(!empty($tpl['latest_arr']))
					{
						foreach($tpl['latest_arr'] as $v)
						{
							$client_name_arr = array();
							if(!empty($v['c_fname']) || !empty($v['fname']))
							{
								$client_name_arr[] = !empty($v['client_id']) ? pjSanitize::clean($v['fname']) : pjSanitize::clean($v['c_fname']);
							}
							if(!empty($v['c_lname']) || !empty($v['lname']))
							{
								$client_name_arr[] = !empty($v['client_id']) ? pjSanitize::clean($v['lname']) : pjSanitize::clean($v['c_lname']);
							}
							?>
							<div class="dashboard_row">
								<label><span><?php __('lblID')?>: </span><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo $v['uuid'];?></a></label>
								<label><span><?php __('lblCustomer')?>: </span><?php echo join(' ', $client_name_arr);?></label>
								<label>
									<span><?php __('lblPickup')?>: </span><?php echo date($tpl['option_arr']['o_date_format'] . ', ' . $tpl['option_arr']['o_time_format'], strtotime($v['booking_date'] . ', ' . $v['booking_time']));?>
									&nbsp;&nbsp;|&nbsp;&nbsp;
									<span><?php __('lblDuration')?>: </span><?php echo $v['traveling'] == 'from' ? (int) $v['duration_dropoff'] : (int) $v['duration_pickup'];?> <?php echo strtolower(__('lblMinutes',true, false));?>
								</label>
								<?php
								if($v['has_return'] == 'T')
								{ 
									?>
									<label>
										<span><?php __('lblReturn')?>: </span><?php echo date($tpl['option_arr']['o_date_format'] . ', ' . $tpl['option_arr']['o_time_format'], strtotime($v['return_date'] . ', ' . $v['return_time']));?>
										&nbsp;&nbsp;|&nbsp;&nbsp;
										<span><?php __('lblDuration')?>: </span><?php echo $v['traveling'] == 'from' ? (int) $v['duration_pickup'] : (int) $v['duration_droppoff'];?> <?php echo strtolower(__('lblMinutes',true, false));?>
									</label>
									<?php
								}
								if($v['traveling'] == 'from')
								{ 
									?>
									<label><span><?php __('lblFrom')?>: </span><?php echo $v['from_location'];?></label>
									<label><span><?php __('lblTo')?>: </span><?php echo $v['to_location'];?></label>
									<?php
								}else{
									?>
									<label><span><?php __('lblFrom')?>: </span><?php echo $v['to_location'];?></label>
									<label><span><?php __('lblTo')?>: </span><?php echo $v['from_location'];?></label>
									<?php
								} 
								?>
								<label><span><?php __('lblLine')?>: </span><?php echo $v['line'];?></label>
								<?php
								if($v['has_return'] == 'T')
								{ 
									?><label><span><?php __('lblReturnLine')?>: </span><?php echo $v['return_line'];?></label><?php
								} 
								?>
							</div>	
							<?php
						}
					}else{
						?>
						<div class="dashboard_row">
							<label><span><?php __('lblReservationsNotFound');?></span></label>
						</div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list">
					<?php
					if(!empty($tpl['today_arr']))
					{
						foreach($tpl['today_arr'] as $v)
						{
							$client_name_arr = array();
							if(!empty($v['c_fname']) || !empty($v['fname']))
							{
								$client_name_arr[] = !empty($v['client_id']) ? pjSanitize::clean($v['fname']) : pjSanitize::clean($v['c_fname']);
							}
							if(!empty($v['c_lname']) || !empty($v['lname']))
							{
								$client_name_arr[] = !empty($v['client_id']) ? pjSanitize::clean($v['lname']) : pjSanitize::clean($v['c_lname']);
							}
							?>
							<div class="dashboard_row">
								<label><span><?php __('lblID')?>: </span><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo $v['uuid'];?></a></label>
								<label><span><?php __('lblCustomer')?>: </span><?php echo join(' ', $client_name_arr);?></label>
								<label>
									<span><?php __('lblPickup')?>: </span><?php echo date($tpl['option_arr']['o_date_format'] . ', ' . $tpl['option_arr']['o_time_format'], strtotime($v['booking_date'] . ', ' . $v['booking_time']));?>
									&nbsp;&nbsp;|&nbsp;&nbsp;
									<span><?php __('lblDuration')?>: </span><?php echo $v['traveling'] == 'from' ? (int) $v['duration_dropoff'] : (int) $v['duration_pickup'];?> <?php echo strtolower(__('lblMinutes',true, false));?>
								</label>
								<?php
								if($v['has_return'] == 'T')
								{ 
									?>
									<label>
										<span><?php __('lblReturn')?>: </span><?php echo date($tpl['option_arr']['o_date_format'] . ', ' . $tpl['option_arr']['o_time_format'], strtotime($v['return_date'] . ', ' . $v['return_time']));?>
										&nbsp;&nbsp;|&nbsp;&nbsp;
										<span><?php __('lblDuration')?>: </span><?php echo $v['traveling'] == 'from' ? (int) $v['duration_pickup'] : (int) $v['duration_droppoff'];?> <?php echo strtolower(__('lblMinutes',true, false));?>
									</label>
									<?php
								} 
								if($v['traveling'] == 'from')
								{ 
									?>
									<label><span><?php __('lblFrom')?>: </span><?php echo $v['from_location'];?></label>
									<label><span><?php __('lblTo')?>: </span><?php echo $v['to_location'];?></label>
									<?php
								}else{
									?>
									<label><span><?php __('lblFrom')?>: </span><?php echo $v['to_location'];?></label>
									<label><span><?php __('lblTo')?>: </span><?php echo $v['from_location'];?></label>
									<?php
								}
								?>
								<label><span><?php __('lblLine')?>: </span><?php echo $v['line'];?></label>
								<?php
								if($v['has_return'] == 'T')
								{ 
									?><label><span><?php __('lblReturnLine')?>: </span><?php echo $v['return_line'];?></label><?php
								} 
								?>
								<label class="status <?php echo $v['status'];?>"><?php echo $statuses[$v['status']];?></label>
								<div style="clear:both;"></div>
							</div>	
							<?php
						}
					}else{
						?>
						<div class="dashboard_row">
							<label><span><?php __('lblReservationsNotFound');?></span></label>
						</div>
						<?php
					} 
					?>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $other) = explode("_", date("H:i_l_F d, Y"));
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo $hour; ?></div>
		</div>
	</div>
	<?php
}
?>