<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);
	
	pjUtil::printNotice(__('infoUpdateBookingTitle', true, false), __('infoUpdateBookingDesc', true, false)); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionUpdate" method="post" class="form pj-form" id="frmUpdateBooking">
		<input type="hidden" name="booking_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('lblBookingDetails');?></a></li>
				<li><a href="#tabs-2"><?php __('lblClientDetails');?></a></li>
			</ul>
		
			<div id="tabs-1" class="bs-loader-outer">
				<div class="bs-loader"></div>
				
				<div class="float_left w400">
					<p>
						<label class="title"><?php __('lblUniqueID');?></label>
						<span class="inline-block">
							<input type="text" id="uuid" name="uuid" value="<?php echo pjSanitize::clean($tpl['arr']['uuid']); ?>" class="pj-form-field w136"/>
						</span>
					</p>
					<p>
						<label class="title">&nbsp;</label>
						<span class="inline_block">
							<span class="block float_left t5 r20">
								<input type="radio" name="traveling" id="traveling_from" value="from"<?php echo $tpl['arr']['traveling'] == 'from' ? ' checked="checked"' : NULL;?> class="block float_left r3"/>
								<label for="traveling_from" class="block float_left"><?php __('lblTravelingFrom');?></label>
							</span>
							<span class="block float_left t5">
								<input type="radio" name="traveling" id="traveling_to" value="to"<?php echo $tpl['arr']['traveling'] == 'to' ? ' checked="checked"' : NULL;?> class="block float_left r3"/>
								<label for="traveling_to" class="block float_left"><?php __('lblTravelingTo');?></label>
							</span>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblLocation'); ?></label>
						<span class="inline_block">
							<select name="location_id" id="location_id" class="pj-form-field w200 required" data-msg-required="<?php __('tr_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach($tpl['da_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id'];?>"<?php echo $tpl['arr']['location_id'] == $v['id'] ? ' selected="selected"' : NULL;?>><?php echo pjSanitize::html($v['title']);?></option><?php
								} 
								?>
							</select>
						</span>
					</p>
					<p>
						<label class="title"><span class="trLocationLabel trLocation-from" style="display:<?php echo $tpl['arr']['traveling'] == 'to' ? 'none' : NULL;?>;"><?php __('lblDropoffLocation'); ?></span><span class="trLocationLabel trLocation-to" style="display:<?php echo $tpl['arr']['traveling'] == 'from' ? 'none' : NULL;?>;"><?php __('lblPickupLocation');?></span></label>
						<span id="trDropoffContainer" class="inline_block">
							<select name="dropoff_id" id="dropoff_id" class="pj-form-field w200 required" data-msg-required="<?php __('tr_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								if(isset($tpl['pd_arr']))
								{
									foreach($tpl['pd_arr'] as $v)
									{
										?><option value="<?php echo $v['id'];?>"<?php echo $tpl['arr']['dropoff_id'] == $v['id'] ? ' selected="selected"' : NULL;?>><?php echo pjSanitize::html($v['title']);?></option><?php
									}
								} 
								?>
							</select>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblDeparture'); ?></label>
						<span class="block overflow">
							<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
								<input type="text" name="booking_date" id="booking_date" value="<?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['booking_date']));?>" class="pj-form-field pointer w100 datepick required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>" data-msg-required="<?php __('tr_field_required');?>"/>
								<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
							</span>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblLine'); ?></label>
						<span id="trLineWrapper" class="inline_block">
							<select name="line_id" id="line_id" class="pj-form-field w200 required" data-msg-required="<?php __('tr_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								$capacity = 0;
								if(isset($tpl['line_arr']))
								{
									foreach($tpl['line_arr'] as $v)
									{
										if($tpl['arr']['line_id'] == $v['id'])
										{
											?><option value="<?php echo $v['id'];?>" selected="selected"><?php echo pjSanitize::html($v['title']);?></option><?php
											$capacity = (int) $v['seats'];
										}else{
											?><option value="<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['title']);?></option><?php
										}
									}
								} 
								?>
							</select>
						</span>
					</p>
					<?php
					$duration = 0;
					$duration_text = '';
					$price_per_person = 0;
					$price_per_person_format = '';
					if(!empty($tpl['line_detail_arr']))
					{
						$line_arr = $tpl['line_detail_arr'];
						if($tpl['arr']['traveling'] == 'from')
						{
							$duration = (int) $line_arr['duration_dropoff'];
							$price_per_person = $line_arr['price_dropoff'];
							$duration_text = (int) $line_arr['duration_dropoff'] . ' ' . __('lblMinutes', true);
							$price_per_person_format = pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($line_arr['price_dropoff'], $tpl['option_arr']), $tpl['option_arr']['o_currency']) . ' ' . __('lblPerPerson', true);
						}else{
							$duration = (int) $line_arr['duration_pickup'];
							$price_per_person = $line_arr['price_pickup'];
							$duration_text = (int) $line_arr['duration_pickup'] . ' ' . __('lblMinutes', true);
							$price_per_person_format = pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($line_arr['price_pickup'], $tpl['option_arr']), $tpl['option_arr']['o_currency']) . ' ' . __('lblPerPerson', true);
						}
					} 
					?>
					<p style="display:;">
						<label class="title">&nbsp;</label>
						<span class="inline_block">
							<span id="tr_duration" class="inline_block t5"><?php echo $duration_text;?></span> / <span id="tr_price_per_person" class="inline_block t5"><?php echo $price_per_person_format;?></span>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblAvailableTime'); ?></label>
						<span id="trTimeWrapper" class="inline_block">
							<select name="booking_time" id="booking_time" class="pj-form-field w150 required" data-msg-required="<?php __('tr_field_required');?>">
								<?php
								if(isset($tpl['timetable_arr']))
								{
									if(!empty($tpl['timetable_arr']))
									{
										?>
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										$time_arr = explode("|", $tpl['timetable_arr']['time']);
										foreach($time_arr as $time)
										{
											$time_ts = strtotime($time);
											if($tpl['arr']['traveling'] == 'to')
											{
												$time_ts = $time_ts - ($duration * 60);
											}
											$iso_time = date('H:i', $time_ts);
											$disabled = '';
											if(array_key_exists($iso_time, $tpl['booked_time_arr']) && $tpl['booked_time_arr'][$iso_time] + $tpl['arr']['passengers'] > $capacity )
											{
												$disabled = ' disabled';
											}
											?><option value="<?php echo $iso_time;?>"<?php echo $iso_time == date('H:i', strtotime($tpl['arr']['booking_time'])) ? ' selected="selected"' : NULL;?><?php echo $disabled;?>><?php echo date($tpl['option_arr']['o_time_format'], $time_ts);?></option><?php
										}
									}else{
										?><option value="">-- <?php __('lblNoAvailableTime'); ?>--</option><?php
									}
								} else {
									?><option value="">-- <?php __('lblChoose'); ?>--</option><?php
								}
								?>
							</select>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblReturnTrip'); ?></label>
						<span class="inline_block">
							<span class="block t6 b5">
								<input type="checkbox" id="has_return" name="has_return"<?php echo $tpl['arr']['has_return'] == 'T' ? ' checked="checked"' : NULL;?>/>
							</span>
						</span>
					</p>
					<div id="trReturnWrapper" style="display:<?php echo $tpl['arr']['has_return'] == 'T' ? '' : 'none';?>;">
						<p>
							<label class="title"><?php __('lblReturnDateTime'); ?></label>
							<span class="inline_block">
								<span class="pj-form-field-custom pj-form-field-custom-after r5">
									<input type="text" id="return_date" name="return_date" value="<?php echo $tpl['arr']['has_return'] == 'T' ? date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['return_date'])) : NULL;?>" class="pj-form-field pointer w100 datepick<?php echo $tpl['arr']['has_return'] == 'T' ? ' required' : NULL;?>" data-msg-required="<?php __('tr_field_required');?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
									<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
								</span>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblReturnLine'); ?></label>
							<span id="trReturnLineWrapper" class="inline_block">
								<select name="return_line_id" id="return_line_id" class="pj-form-field w200<?php echo $tpl['arr']['has_return'] == 'T' ? ' required' : NULL;?>" data-msg-required="<?php __('tr_field_required');?>">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									$return_capacity = 0;
									if(isset($tpl['line_arr']))
									{
										foreach($tpl['line_arr'] as $v)
										{
											if($tpl['arr']['return_line_id'] == $v['id'])
											{
												?><option value="<?php echo $v['id'];?>" selected="selected"><?php echo pjSanitize::html($v['title']);?></option><?php
												$return_capacity = (int) $v['seats'];
											}else{
												?><option value="<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['title']);?></option><?php
											}
										}
									} 
									?>
								</select>
							</span>
						</p>
						<?php
						$return_duration = 0;
						$return_duration_text = '';
						$return_price_per_person = 0;
						$return_price_per_person_format = '';
						if(!empty($tpl['return_line_detail_arr']))
						{
							$line_arr = $tpl['return_line_detail_arr'];
							if($tpl['arr']['traveling'] == 'from')
							{
								$return_duration = (int) $line_arr['duration_pickup'] ;
								$return_price_per_person = $line_arr['price_pickup'];
								$return_duration_text = (int) $line_arr['duration_pickup'] . ' ' . __('lblMinutes', true);
								$return_price_per_person_format = pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($line_arr['price_pickup'], $tpl['option_arr']), $tpl['option_arr']['o_currency']) . ' ' . __('lblPerPerson', true);
							}else{
								$return_duration = (int) $line_arr['duration_dropoff'] ;
								$return_price_per_person = $line_arr['price_dropoff'];
								$return_duration_text = (int) $line_arr['duration_dropoff'] . ' ' . __('lblMinutes', true);
								$return_price_per_person_format = pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($line_arr['price_dropoff'], $tpl['option_arr']), $tpl['option_arr']['o_currency']) . ' ' . __('lblPerPerson', true);
							}
						} 
						?>
						<p style="display:;">
							<label class="title"><?php __('lblReturnDuration'); ?></label>
							<span class="inline-block">
								<span id="tr_return_duration" class="inline_block t5"><?php echo $return_duration_text;?></span> / <span id="tr_return_price_per_person" class="inline_block t5"><?php echo $return_price_per_person_format;?></span>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblReturnAvailableTime'); ?></label>
							<span id="trReturnTimeWrapper" class="inline_block">
								<select name="return_time" id="return_time" class="pj-form-field w150<?php echo $tpl['arr']['has_return'] == 'T' ? ' required' : NULL;?>" data-msg-required="<?php __('tr_field_required');?>">
									<?php
									if(isset($tpl['return_timetable_arr']))
									{
										if(!empty($tpl['return_timetable_arr']))
										{
											?>
											<option value="">-- <?php __('lblChoose'); ?>--</option>
											<?php
											$time_arr = explode("|", $tpl['return_timetable_arr']['time']);
											$traveling = $tpl['arr']['traveling'] == 'from' ? 'to' : 'from';
											foreach($time_arr as $time)
											{
												$time_ts = strtotime($time);
												if($traveling == 'to')
												{
													$time_ts = $time_ts - ($return_duration * 60);
												}
												$iso_time = date('H:i', $time_ts);
												$disabled = '';
												if(array_key_exists($iso_time, $tpl['return_booked_time_arr']) && $tpl['return_booked_time_arr'][$iso_time] + $tpl['arr']['passengers'] > $return_capacity )
												{
													$disabled = ' disabled';
												}
												?><option value="<?php echo date('H:i', $time_ts);?>"<?php echo date('H:i', $time_ts) == date('H:i', strtotime($tpl['arr']['return_time'])) ? ' selected="selected"' : NULL;?><?php echo $disabled;?>><?php echo date($tpl['option_arr']['o_time_format'], $time_ts);?></option><?php
											}
										}else{
											?><option value="">-- <?php __('lblNoAvailableTime'); ?>--</option><?php
										}
									} else {
										?><option value="">-- <?php __('lblChoose'); ?>--</option><?php
									}
									?>
								</select>
							</span>
						</p>
					</div>
					<p>
						<label class="title"><?php __('lblPassengers'); ?></label>
						<span class="inline-block">
							<input type="text" id="passengers" name="passengers" class="pj-form-field field-int w80 required" value="<?php echo $tpl['arr']['passengers'];?>" data-msg-required="<?php __('tr_field_required');?>"/>
						</span>
					</p>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBookings&action=pjActionIndex';" />
					</p>
				</div>
				<div class="float_right w340">
					
					<p>
						<label class="title"><?php __('lblIpAddress'); ?></label>
						<label class="content"><?php echo $tpl['arr']['ip']; ?></label>
					</p>
					<p>
						<label class="title"><?php __('lblCreatedOn'); ?></label>
						<label class="content"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['created'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['created'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></label>
					</p>
					<p>
						<label class="title"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionResend&amp;id=<?php echo $tpl['arr']['id']; ?>"><?php __('lblResendConfirmation'); ?></a></label>
						<?php
						if(isset($tpl['client']) && !empty($tpl['client']['phone']))
						{ 
							?><label class="content"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionSendSms&amp;id=<?php echo $tpl['arr']['id']; ?>"><?php __('lblSendSMSNotification'); ?></a></label><?php
						} 
						?>
					</p>
					<p>
						<label class="title"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionPrint&amp;id=<?php echo $tpl['arr']['id']; ?>" target="_blank"><?php __('lblPrintReservation'); ?></a></label>
					</p>
					<div class="p">
						<label class="title"><?php __('lblStatus'); ?></label>
						<span class="inline-block">
							<select name="status" id="status" class="pj-form-field w150 required" data-msg-required="<?php __('tr_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach (__('booking_statuses', true, false) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</span>
					</div>
					
					<p>
						<label class="title"><?php __('lblSubTotal'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" id="sub_total" name="sub_total" class="pj-form-field w108<?php echo isset($tpl['option_arr']['o_currency_format']) ? ' pjNumber' : ' number';?>" data-price="<?php echo $price_per_person;?>" data-return_price="<?php echo $return_price_per_person;?>" value="<?php echo pjUtil::convertToCurrencyFormat($tpl['arr']['sub_total'], $tpl['option_arr']); ?>" readonly="readonly" data-currency_format="<?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>" data-msg-number="<?php __('pj_number_validation');?>" data-msg-pjNumber="<?php __('lblValidNumberMessage');?>"/>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblTax'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" id="tax" name="tax" class="pj-form-field w108<?php echo isset($tpl['option_arr']['o_currency_format']) ? ' pjNumber' : ' number';?>" readonly="readonly" value="<?php echo pjUtil::convertToCurrencyFormat($tpl['arr']['tax'], $tpl['option_arr']); ?>" data-tax="<?php echo $tpl['option_arr']['o_tax_payment'];?>" data-currency_format="<?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>" data-msg-number="<?php __('pj_number_validation');?>" data-msg-pjNumber="<?php __('lblValidNumberMessage');?>"/>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblTotal'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" id="total" name="total" class="pj-form-field w108<?php echo isset($tpl['option_arr']['o_currency_format']) ? ' pjNumber' : ' number';?>" value="<?php echo pjUtil::convertToCurrencyFormat($tpl['arr']['total'], $tpl['option_arr']); ?>" data-currency_format="<?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>" data-msg-number="<?php __('pj_number_validation');?>" data-msg-pjNumber="<?php __('lblValidNumberMessage');?>"/>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblDeposit'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" id="deposit" name="deposit" class="pj-form-field w108<?php echo isset($tpl['option_arr']['o_currency_format']) ? ' pjNumber' : ' number';?>" value="<?php echo pjUtil::convertToCurrencyFormat($tpl['arr']['deposit'], $tpl['option_arr']); ?>" data-deposit="<?php echo $tpl['option_arr']['o_deposit_payment'];?>" data-currency_format="<?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>" data-msg-number="<?php __('pj_number_validation');?>" data-msg-pjNumber="<?php __('lblValidNumberMessage');?>"/>
						</span>
					</p>
					
					<p>
						<label class="title"><?php __('lblPaymentMethod');?></label>
						<span class="inline-block">
							<select name="payment_method" id="payment_method" class="pj-form-field w150 required" data-msg-required="<?php __('tr_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach (__('payment_methods', true, false) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['payment_method'] ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<p class="boxCC" style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : 'block'; ?>">
						<label class="title"><?php __('lblCCType'); ?></label>
						<span class="inline-block">
							<select name="cc_type" class="pj-form-field w150">
								<option value="">---</option>
								<?php
								foreach (__('cc_types', true, false) as $k => $v)
								{
									if (isset($tpl['arr']['cc_type']) && $tpl['arr']['cc_type'] == $k)
									{
										?><option value="<?php echo $k; ?>" selected="selected"><?php echo $v; ?></option><?php
									} else {
										?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
									}
								}
								?>
							</select>
						</span>
					</p>
					<p class="boxCC" style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : 'block'; ?>">
						<label class="title"><?php __('lblCCNum'); ?></label>
						<span class="inline-block">
							<input type="text" name="cc_num" id="cc_num" value="<?php echo pjSanitize::clean($tpl['arr']['cc_num']); ?>" class="pj-form-field w136"/>
						</span>
					</p>
					<p class="boxCC" style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : 'block'; ?>">
						<label class="title"><?php __('lblCCExp'); ?></label>
						<span class="inline-block">
							<select name="cc_exp_month" class="pj-form-field w100">
								<option value="">---</option>
								<?php
								$month_arr = __('months', true, false);
								ksort($month_arr);
								foreach ($month_arr as $key => $val)
								{
									?><option value="<?php echo $key;?>"<?php echo $tpl['arr']['cc_exp_month'] == $key ? ' selected="selected"' : NULL; ?>><?php echo $val;?></option><?php
								}
								?>
							</select>
							<select name="cc_exp_year" class="pj-form-field">
								<option value="">---</option>
								<?php
								$y = (int) date('Y');
								for ($i = $y; $i <= $y + 10; $i++)
								{
									?><option value="<?php echo $i; ?>"<?php echo $tpl['arr']['cc_exp_year'] == $i ? ' selected="selected"' : NULL; ?>><?php echo $i; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<p class="boxCC" style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : 'block'; ?>">
						<label class="title"><?php __('lblCCCode'); ?></label>
						<span class="inline-block">
							<input type="text" name="cc_code" id="cc_code" value="<?php echo pjSanitize::clean($tpl['arr']['cc_code']); ?>" class="pj-form-field w100" />
						</span>
					</p>
					
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBookings&action=pjActionIndex';" />
					</p>
				</div>
			</div>
			
			<div id="tabs-2">
				<?php
				if(!empty($tpl['client_arr']))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblClient'); ?></label>
						<span class="inline-block">
							<span class="block float_left r5">
								<select name="client_id" id="client_id" class="pj-form-field w500" data-msg-required="<?php __('tr_field_required');?>">
									<option value="">-- <?php __('lblNewClient'); ?>--</option>
									<?php
									foreach ($tpl['client_arr'] as $v)
									{
										$name_arr = array();
										if(!empty($v['fname']))
										{
											$name_arr[] = pjSanitize::clean($v['fname']);
										}
										if(!empty($v['lname']))
										{
											$name_arr[] = pjSanitize::clean($v['lname']);
										}
										$email_phone = array();
										if(!empty($v['email']))
										{
											$email_phone[] = pjSanitize::clean($v['email']);
										}
										if(!empty($v['phone']))
										{
											$email_phone[] = pjSanitize::clean($v['phone']);
										}
										?><option value="<?php echo $v['id']; ?>"<?php echo $tpl['arr']['client_id'] == $v['id'] ? ' selected="selected"' : NULL;?>><?php echo join(" ", $name_arr); ?> (<?php echo join(" | ", $email_phone); ?>)</option><?php
									}
									?>
								</select>
							</span>
							<a id="pjFdEditClient" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate&id=<?php echo $tpl['arr']['client_id'];?>" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate&id={ID}" class="pj-edit-client"></a>
						</span>
					</p>
					<?php
				} 
				?>
				<div id="pjSbNewClientWrapper" style="display: <?php echo !empty($tpl['arr']['client_id']) ? 'none' : 'block';?>">
					<?php
					if (in_array($tpl['option_arr']['o_bf_include_title'], array(2, 3)))
					{  
						?>
						<p>
							<label class="title"><?php __('lblBookingTitle'); ?></label>
							<span class="inline-block">
								<select name="c_title" id="c_title" class="pj-form-field w150<?php echo $tpl['option_arr']['o_bf_include_title'] == 3 ? ' clientRequired' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									$title_arr = pjUtil::getTitles();
									$name_titles = __('personal_titles', true, false);
									foreach ($title_arr as $v)
									{
										?><option value="<?php echo $v; ?>"<?php echo $tpl['arr']['c_title'] == $v ? ' selected="selected"' : NULL; ?>><?php echo $name_titles[$v]; ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<?php
					}
					if (in_array($tpl['option_arr']['o_bf_include_fname'], array(2, 3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingFname'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_fname" id="c_fname" class="pj-form-field w250<?php echo $tpl['option_arr']['o_bf_include_fname'] == 3 ? ' clientRequired' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_fname'])); ?>" />
							</span>
						</p>
						<?php
					}
					if (in_array($tpl['option_arr']['o_bf_include_lname'], array(2, 3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingLname'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_lname" id="c_lname" class="pj-form-field w250<?php echo $tpl['option_arr']['o_bf_include_lname'] == 3 ? ' clientRequired' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_lname'])); ?>" />
							</span>
						</p>
						<?php
					}
					if (in_array($tpl['option_arr']['o_bf_include_phone'], array(2, 3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingPhone'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_phone" id="c_phone" class="pj-form-field w250<?php echo $tpl['option_arr']['o_bf_include_phone'] == 3 ? ' clientRequired' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_phone'])); ?>" />
							</span>
						</p>
						<?php
					}
					if (in_array($tpl['option_arr']['o_bf_include_email'], array(2, 3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingEmail'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_email" id="c_email" class="pj-form-field w250<?php echo $tpl['option_arr']['o_bf_include_email'] == 3 ? ' clientRequired' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_email'])); ?>" />
							</span>
						</p>
						<?php
					}
					
					if (in_array($tpl['option_arr']['o_bf_include_company'], array(2, 3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingCompany'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_company" id="c_company" class="pj-form-field w300<?php echo $tpl['option_arr']['o_bf_include_company'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_company'])); ?>" />
							</span>
						</p>
						<?php
					}
					if (in_array($tpl['option_arr']['o_bf_include_address'], array(2, 3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingAddress'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_address" id="c_address" class="pj-form-field w300<?php echo $tpl['option_arr']['o_bf_include_address'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_address'])); ?>" />
							</span>
						</p>
						<?php
					}
					if (in_array($tpl['option_arr']['o_bf_include_city'], array(2, 3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingCity'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_city" id="c_city" class="pj-form-field w300<?php echo $tpl['option_arr']['o_bf_include_city'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_city'])); ?>" />
							</span>
						</p>
						<?php
					}
					if (in_array($tpl['option_arr']['o_bf_include_state'], array(2, 3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingState'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_state" id="c_state" class="pj-form-field w300<?php echo $tpl['option_arr']['o_bf_include_state'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_state'])); ?>" />
							</span>
						</p>
						<?php
					}
					if (in_array($tpl['option_arr']['o_bf_include_zip'], array(2, 3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingZip'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_zip" id="c_zip" class="pj-form-field w300<?php echo $tpl['option_arr']['o_bf_include_zip'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_zip'])); ?>" />
							</span>
						</p>
						<?php
					}
					if (in_array($tpl['option_arr']['o_bf_include_country'], array(2, 3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingCountry'); ?></label>
							<span class="inline-block">
								<select name="c_country" id="c_country" class="pj-form-field w300<?php echo $tpl['option_arr']['o_bf_include_country'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" >
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach ($tpl['country_arr'] as $v)
									{
										?><option value="<?php echo $v['id']; ?>"<?php echo $tpl['arr']['c_country'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['country_title']); ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<?php
					}
					?>
				</div>
				<?php
				if (in_array($tpl['option_arr']['o_bf_include_notes'], array(2, 3)))
				{
					?>
					<p>
						<label class="title"><?php __('lblBookingNotes'); ?></label>
						<span class="inline-block">
							<textarea name="c_notes" id="c_notes" class="pj-form-field w500 h120<?php echo $tpl['option_arr']['o_bf_include_notes'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" ><?php echo stripslashes($tpl['arr']['c_notes']); ?></textarea>
						</span>
					</p>
					<?php
				}
				if (in_array($tpl['option_arr']['o_bf_include_airline_company'], array(2, 3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblBookingAirlineCompany'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_airline_company" id="c_airline_company" class="pj-form-field w300<?php echo $tpl['option_arr']['o_bf_include_airline_company'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_airline_company'])); ?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array($tpl['option_arr']['o_bf_include_flight_number'], array(2, 3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblArrivalFlightNumber'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_flight_number" id="c_flight_number" class="pj-form-field w300<?php echo $tpl['option_arr']['o_bf_include_flight_number'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_flight_number'])); ?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array($tpl['option_arr']['o_bf_include_flight_time'], array(2, 3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblFlightArrivalTime'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_flight_time" id="c_flight_time" class="pj-form-field w300 timepick<?php echo $tpl['option_arr']['o_bf_include_flight_time'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo !empty($tpl['arr']['c_flight_time']) ? date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['c_flight_time'])) : NULL; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array($tpl['option_arr']['o_bf_include_terminal'], array(2, 3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblBookingTerminal'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_terminal" id="c_terminal" class="pj-form-field w300<?php echo $tpl['option_arr']['o_bf_include_terminal'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('tr_field_required');?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_terminal'])); ?>"/>
						</span>
					</p>
					<?php
				} 
				?>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBookings&action=pjActionIndex';" />
				</p>
			</div>
		</div>
	</form>
	<?php
	$show_period = 'false';
	if((strpos($tpl['option_arr']['o_time_format'], 'a') > -1 || strpos($tpl['option_arr']['o_time_format'], 'A') > -1))
	{
		$show_period = 'true';
	} 
	?>
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.maximum = '<?php echo __('lblMaximum', true, false)?>';
	myLabel.positive_number = "<?php __('lblPositiveNumber'); ?>";
	myLabel.max_number = "<?php __('lblMaxNumber'); ?>";
	myLabel.duplicated_id = "<?php __('lblDuplicatedUniqueID');?>",
	myLabel.loader = '<img src="<?php echo PJ_IMG_PATH;?>backend/pj-preloader.gif" />';
	myLabel.showperiod = <?php echo $show_period; ?>;
	myLabel.currency_format = <?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>;
	</script>
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{		
		$tab_id = $_GET['tab_id'];
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "selected", <?php echo $tab_id; ?>);
			});
		})(jQuery);
		</script>
		<?php
	}
}
?>