<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	
	pjUtil::printNotice(__('infoUpdateLineTitle', true, false), __('infoUpdateLineDesc', true, false));
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminLines&amp;action=pjActionUpdate" method="post" id="frmUpdateLine" class="pj-form form" enctype="multipart/form-data">
		<input type="hidden" name="line_update" value="1" />
		<input type="hidden" name="id" value="<?php echo pjSanitize::html($tpl['arr']['id']);?>" />
		<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
		<div class="multilang"></div>
		<?php endif;?>
		<div class="clear_both">
			<p>
				<label class="title"><?php __('lblDepartureArrivalLocation'); ?></label>
				<span class="inline-block">
					<select name="location_id" id="location_id" class="pj-form-field w300 required" data-msg-required="<?php __('tr_field_required'); ?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach($tpl['da_arr'] as $k => $v)
						{
							?><option value="<?php echo $v['id'];?>"<?php echo $v['id'] == $tpl['arr']['location_id'] ? ' selected="selected"' : NULL;?>><?php echo $v['title'];?></option><?php
						} 
						?>
					</select>
				</span>
			</p>
			<?php
			foreach ($tpl['lp_arr'] as $v)
			{
			?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblTitle'); ?></label>
					<span class="inline_block">
						<input type="text" name="i18n[<?php echo $v['id']; ?>][title]" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['title'])); ?>" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" data-msg-required="<?php __('tr_field_required'); ?>"/>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif;?>
					</span>
				</p>
				<?php
			}
			?>
			<div class="p">
				<table id="pjSbsLineTable" class="pj-table pjSbsLineTable" cellpadding="0" cellspacing="0" style="width: 100%">
					<thead>
						<tr>
							<th style="width: 250px;"><?php __('lblLocation'); ?></th>
							<th style="width: 190px;"><?php __('lblDuration'); ?></th>
							<th style="width: 190px;"><?php __('lblPricePerPerson'); ?></th>
							<th style="width: 22px;">&nbsp;</th>
						</tr>
					</thead>
					<tbody>
						<?php
						if(!empty($tpl['line_detail_arr']))
						{
							foreach($tpl['line_detail_arr'] as $k => $item)
							{
								$index = (int) $item['id'];
								?>
								<tr id="trLocation_<?php echo $index;?>">
									<td>
										<span class="inline-block">
											<select id="pd_id_<?php echo $index;?>" name="pd_id[<?php echo $index;?>]" class="pj-form-field w250 required" data-index="<?php echo $index;?>">
												<option value="">-- <?php __('lblChoose'); ?>--</option>
												<?php
												foreach($tpl['pd_arr'] as $v)
												{
													?><option value="<?php echo $v['id']?>"<?php echo $v['id'] == $item['location_id'] ? ' selected="selected"' : NULL;?>><?php echo pjSanitize::html($v['title']);?></option><?php
												} 
												?>
											</select>
										</span>
									</td>
									<td>
										<span class="block overflow b5">
											<span class="block float_left w80 t5"><?php __('lblIfPickup');?></span>
											<input name="duration_pickup[<?php echo $index;?>]" value="<?php echo pjSanitize::clean($item['duration_pickup'])?>" class="pj-form-field w60 field-int float_left required digits" />
											<?php __('lblMins');?>
										</span>
										<span class="block overflow">
											<span class="block float_left w80 t5"><?php __('lblIfDropoff');?></span>
											<input name="duration_dropoff[<?php echo $index;?>]" value="<?php echo pjSanitize::clean($item['duration_dropoff'])?>" class="pj-form-field w60  field-int float_left required digits" />
											<?php __('lblMins');?>
										</span>
									</td>
									<td>
										<span class="block overflow b5">
											<span class="block float_left w80 t5"><?php __('lblIfPickup');?></span>
											<span class="pj-form-field-custom pj-form-field-custom-before float_left">
												<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
												<input type="text" name="price_pickup[<?php echo $index?>]" value="<?php echo pjUtil::convertToCurrencyFormat($item['price_pickup'], $tpl['option_arr']);?>"class="pj-form-field w50 required<?php echo isset($tpl['option_arr']['o_currency_format']) ? ' pjNumber' : ' number';?>" data-currency_format="<?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>"/>
											</span>
										</span>
										<span class="block overflow">
											<span class="block float_left w80 t5"><?php __('lblIfDropoff');?></span>
											<span class="pj-form-field-custom pj-form-field-custom-before float_left">
												<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
												<input type="text" name="price_dropoff[<?php echo $index?>]" value="<?php echo pjUtil::convertToCurrencyFormat($item['price_dropoff'], $tpl['option_arr']);?>" class="pj-form-field w50 required<?php echo isset($tpl['option_arr']['o_currency_format']) ? ' pjNumber' : ' number';?>" data-currency_format="<?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>"/>
											</span>
										</span>
									</td>
									<?php
									if($k == 0)
									{ 
										?><td>&nbsp;</td><?php
									}else{
										?><td><a href="#" class="linkRemoveRow"></a></td><?php
									} 
									?>
								</tr>
								<?php
							}
						}else{
							$index = 'new_' . rand(1, 999999);
							?>
							<tr id="trLocation_<?php echo $index;?>">
								<td>
									<span class="inline-block">
										<select id="pd_id_<?php echo $index;?>" name="pd_id[<?php echo $index;?>]" class="pj-form-field w250 required" data-index="<?php echo $index;?>">
											<option value="">-- <?php __('lblChoose'); ?>--</option>
											<?php
											foreach($tpl['pd_arr'] as $v)
											{
												?><option value="<?php echo $v['id']?>"><?php echo pjSanitize::html($v['title']);?></option><?php
											} 
											?>
										</select>
									</span>
								</td>
								<td>
									<span class="block overflow b5">
										<span class="block float_left w80 t5"><?php __('lblIfPickup');?></span>
										<input name="duration_pickup[<?php echo $index;?>]" class="pj-form-field w60 field-int float_left required digits" />
										<?php __('lblMins');?>
									</span>
									<span class="block overflow">
										<span class="block float_left w80 t5"><?php __('lblIfDropoff');?></span>
										<input name="duration_dropoff[<?php echo $index;?>]" class="pj-form-field w60  field-int float_left required digits" />
										<?php __('lblMins');?>
									</span>
								</td>
								<td>
									<span class="block overflow b5">
										<span class="block float_left w80 t5"><?php __('lblIfPickup');?></span>
										<span class="pj-form-field-custom pj-form-field-custom-before float_left">
											<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
											<input type="text" name="price_pickup[<?php echo $index?>]" class="pj-form-field w50 required<?php echo isset($tpl['option_arr']['o_currency_format']) ? ' pjNumber' : ' number';?>" data-currency_format="<?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>"/>
										</span>
									</span>
									<span class="block overflow">
										<span class="block float_left w80 t5"><?php __('lblIfDropoff');?></span>
										<span class="pj-form-field-custom pj-form-field-custom-before float_left">
											<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
											<input type="text" name="price_dropoff[<?php echo $index?>]" class="pj-form-field w50 required<?php echo isset($tpl['option_arr']['o_currency_format']) ? ' pjNumber' : ' number';?>" data-currency_format="<?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>"/>
										</span>
									</span>
								</td>
								<td>&nbsp;</td>
							</tr>
							<?php
						} 
						?>
					</tbody>
				</table>
			</div>
			<p>
				<label class="title">&nbsp;</label>
				<input type="button" value="<?php __('btnAddDropoffLocation'); ?>" class="pj-button btnAddLocation"/>
			</p>
			<p>
				<label class="title"><?php __('lblSeats'); ?></label>
				<span class="inline-block">
					<input type="text" name="seats" id="seats" value="<?php echo pjSanitize::clean($tpl['arr']['seats'])?>" class="pj-form-field field-int w80 required" data-msg-required="<?php __('tr_field_required'); ?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblImage'); ?></label>
				<span class="inline_block">
					<input type="file" name="image" id="image" class="pj-form-field w300"/>
				</span>
			</p>
			<?php
			if(!empty($tpl['arr']['source_path']))
			{
				$thumb_url = PJ_INSTALL_URL . $tpl['arr']['thumb_path'];
				?>
				<p id="image_container">
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<img class="tr-image" src="<?php echo $thumb_url; ?>" />
						<a href="javascript:void(0);" class="pj-delete-image" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminLines&amp;action=pjActionDeleteImage&id=<?php echo $tpl['arr']['id'];?>"><?php __('lblDelete');?></a>
					</span>
				</p>
				<?php
			} 
			foreach ($tpl['lp_arr'] as $v)
			{
			?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblDescription'); ?></label>
					<span class="inline_block">
						<textarea name="i18n[<?php echo $v['id']; ?>][description]" class="pj-form-field w500 h150" lang="<?php echo $v['id']; ?>" ><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['description'])); ?></textarea>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif;?>
					</span>
				</p>
				<?php
			}
			?>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminLines&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<table id="pjSbsLineTableClone" style="display: none">
		<tr id="trLocation_{INDEX}">
			<td>
				<span class="inline-block">
					<select id="pd_id_<?php echo $index;?>" name="pd_id[{INDEX}]" class="pj-form-field w250 required" data-index="{INDEX}">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach($tpl['pd_arr'] as $v)
						{
							?><option value="<?php echo $v['id']?>"><?php echo pjSanitize::html($v['title']);?></option><?php
						} 
						?>
					</select>
				</span>
			</td>
			<td>
				<span class="block overflow b5">
					<span class="block float_left w80 t5"><?php __('lblIfPickup');?></span>
					<input name="duration_pickup[{INDEX}]" class="pj-form-field w60 {SPINNER} float_left required digits" />
					<?php __('lblMins');?>
				</span>
				<span class="block overflow">
					<span class="block float_left w80 t5"><?php __('lblIfDropoff');?></span>
					<input name="duration_dropoff[{INDEX}]" class="pj-form-field w60 {SPINNER} float_left required digits" />
					<?php __('lblMins');?>
				</span>
			</td>
			<td>
				<span class="block overflow b5">
					<span class="block float_left w80 t5"><?php __('lblIfPickup');?></span>
					<span class="pj-form-field-custom pj-form-field-custom-before float_left">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" name="price_pickup[{INDEX}]" class="pj-form-field w50 required<?php echo isset($tpl['option_arr']['o_currency_format']) ? ' pjNumber' : ' number';?>" data-currency_format="<?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>"/>
					</span>
				</span>
				<span class="block overflow">
					<span class="block float_left w80 t5"><?php __('lblIfDropoff');?></span>
					<span class="pj-form-field-custom pj-form-field-custom-before float_left">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" name="price_dropoff[{INDEX}]" class="pj-form-field w50 required<?php echo isset($tpl['option_arr']['o_currency_format']) ? ' pjNumber' : ' number';?>" data-currency_format="<?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>"/>
					</span>
				</span>
			</td>
			<td><a href="#" class="linkRemoveRow"></a></td>
		</tr>
	</table>
	
	<div id="dialogDeleteImage" style="display: none" title="<?php __('lblDeleteImage');?>"><?php __('lblDeleteConfirmation');?></div>
	
	<script type="text/javascript">
	var locale_array = new Array(); 
	var myLabel = myLabel || {};
	<?php
	foreach ($tpl['lp_arr'] as $v)
	{
		?>locale_array.push(<?php echo $v['id'];?>);<?php
	} 
	?>
	myLabel.locale_array = locale_array;
	myLabel.localeId = "<?php echo $controller->getLocaleId(); ?>";
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: <?php echo $tpl['locale_str']; ?>,
				flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
				select: function (event, ui) {
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	<?php
}
?>