var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmCreateTimetable = $("#frmCreateTimetable"),
			$frmUpdateTimetable = $("#frmUpdateTimetable"),
			$frmSchedule = $('#frmSchedule'),
			$dialogDelete = $("#dialogDeleteImage"),
			dialog = ($.fn.dialog !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			spinner = ($.fn.spinner !== undefined);
		
		$(".field-int").spinner({
			min: 0
		});
		
		if ($frmCreateTimetable.length > 0) {
			$frmCreateTimetable.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		if ($frmUpdateTimetable.length > 0) {
			$frmUpdateTimetable.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		if ($frmCreateTimetable.length > 0 || $frmUpdateTimetable.length > 0)
		{
			$('.pjTimePicker').timepicker({
				showPeriod: myLabel.showperiod,
				defaultTime: ''
			});
		}
		if ($frmSchedule.length > 0) {
			getSchedule();	
		}
		function getSchedule()
		{
			var opts = {
					time: $('#schedule_time').val(),
					line_id: $('#schedule_time').data('line_id'),
					direction: $('#schedule_time').data('direction'),
				};
			$.get("index.php?controller=pjAdminTimetable&action=pjActionGetSchedule", opts).done(function (data) {
				$('#pjScheduleWrapper').html(data);
			});
		}
		if ($("#grid").length > 0 && datagrid) {
			
			
			var $grid = $("#grid").datagrid({
				buttons: [{type: "view", target: '_blank', url: "index.php?controller=pjAdminTimetable&action=pjActionSchedule&id={:id}"},
				          {type: "edit", url: "index.php?controller=pjAdminTimetable&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminTimetable&action=pjActionDeleteTimetable&id={:id}"}
				          ],
				columns: [
				          {text: myLabel.line, type: "text", sortable: true, width: 230, editable: false},
				          {text: myLabel.location, type: "text", sortable: false, editable: false, width: 250},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 100, options: [
						                                                                                     {label: myLabel.active, value: "T"}, 
						                                                                                     {label: myLabel.inactive, value: "F"}
						                                                                                     ], applyClass: "pj-status"}
				         ],
				dataUrl: "index.php?controller=pjAdminTimetable&action=pjActionGetTimetable",
				dataType: "json",
				fields: ['line', 'direction', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminTimetable&action=pjActionDeleteTimetableBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminTimetable&action=pjActionSaveTimetable&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminTimetable&action=pjActionGetTimetable", "title", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminTimetable&action=pjActionGetTimetable", "title", "ASC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminTimetable&action=pjActionGetTimetable", "title", "ASC", content.page, content.rowCount);
			return false;
		}).on("change", "#location_id", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$.get(["index.php?controller=pjAdminTimetable&action=pjActionGetLines", "&location_id=", $(this).val()].join("")).done(function (data) {
				$('#pjLineWrapper').html(data);
			});
			return false;
		}).on("click", '.pjAddTime', function(e){
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var clone_text = $('#pjTimeClone').html(),
				index = 'new_' + Math.ceil(Math.random() * 999999);
			clone_text = clone_text.replace(/\{INDEX\}/g, index);
			clone_text = clone_text.replace(/\{TIMEPICKER\}/g, 'pjTimePicker');
			$('#pjTimeWrapper').append(clone_text);
			$('#time_' + index).timepicker({
				showPeriod: myLabel.showperiod,
				defaultTime: ''
			});
			$('#time_' + index).focus();
		}).on("click", ".linkRemoveRow", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $tr = $(this).closest('span');
			$tr.fadeOut("slow", function () {
				$tr.remove();
			});
		}).on("change", "input[name='direction']", function (e) {
			var direction = $("input[name='direction']:checked").val();
			$('.pjTimeLabel').hide();
			$('.pjTimeLabel-' + direction).show();
		}).on("change", "#schedule_time", function (e) {
			getSchedule();
		});
	});
})(jQuery_1_8_2);