DROP TABLE IF EXISTS `taxi_bookings`;
CREATE TABLE IF NOT EXISTS `taxi_bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) DEFAULT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `fleet_id` int(10) unsigned DEFAULT NULL,
  `price_id` int(10) unsigned DEFAULT NULL,
  `pickup_address` varchar(255) DEFAULT NULL,
  `return_address` varchar(255) DEFAULT NULL,
  `booking_date` datetime DEFAULT NULL,
  `passengers` int(5) DEFAULT NULL,
  `luggage` int(5) DEFAULT NULL,
  `distance` decimal(9,2) unsigned DEFAULT NULL,
  `sub_total` decimal(9,2) unsigned DEFAULT NULL,
  `tax` decimal(9,2) unsigned DEFAULT NULL,
  `total` decimal(9,2) unsigned DEFAULT NULL,
  `deposit` decimal(9,2) unsigned DEFAULT NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') DEFAULT NULL,
  `status` enum('confirmed','cancelled','pending') DEFAULT 'pending',
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `c_title` varchar(255) DEFAULT NULL,
  `c_fname` varchar(255) DEFAULT NULL,
  `c_lname` varchar(255) DEFAULT NULL,
  `c_phone` varchar(255) DEFAULT NULL,
  `c_email` varchar(255) DEFAULT NULL,
  `c_company` varchar(255) DEFAULT NULL,
  `c_notes` text,
  `c_address` varchar(255) DEFAULT NULL,
  `c_city` varchar(255) DEFAULT NULL,
  `c_state` varchar(255) DEFAULT NULL,
  `c_zip` varchar(255) DEFAULT NULL,
  `c_country` int(10) unsigned DEFAULT NULL,
  `c_airline_company` varchar(255) DEFAULT NULL,
  `c_departure_airline_company` varchar(255) DEFAULT NULL,
  `c_flight_number` varchar(255) DEFAULT NULL,
  `c_flight_time` varchar(255) DEFAULT NULL,
  `c_departure_flight_number` varchar(255) DEFAULT NULL,
  `c_departure_flight_time` time DEFAULT NULL,
  `c_terminal` varchar(255) DEFAULT NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `fleet_id` (`fleet_id`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `taxi_bookings_extras`;
CREATE TABLE IF NOT EXISTS `taxi_bookings_extras` (
  `booking_id` int(10) unsigned NOT NULL DEFAULT '0',
  `extra_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`booking_id`,`extra_id`),
  KEY `fleet_id` (`booking_id`),
  KEY `extra_id` (`extra_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `taxi_bookings_payments`;
CREATE TABLE IF NOT EXISTS `taxi_bookings_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) unsigned DEFAULT NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY (`id`),
  KEY `booking_id` (`booking_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `taxi_clients`;
CREATE TABLE IF NOT EXISTS `taxi_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `title` varchar(255) DEFAULT NULL,
  `fname` varchar(255) DEFAULT NULL,
  `lname` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `taxi_fleets`;
CREATE TABLE IF NOT EXISTS `taxi_fleets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `start_fee` decimal(9,2) unsigned DEFAULT NULL,
  `fee_per_person` decimal(9,2) unsigned DEFAULT NULL,
  `passengers` int(5) unsigned DEFAULT NULL,
  `luggage` int(5) unsigned DEFAULT NULL,
  `source_path` varchar(255) DEFAULT NULL,
  `thumb_path` varchar(255) DEFAULT NULL,
  `image_name` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `taxi_extras`;
CREATE TABLE IF NOT EXISTS `taxi_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `per` enum('person','total') DEFAULT 'total',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `taxi_fleets_extras`;
CREATE TABLE IF NOT EXISTS `taxi_fleets_extras` (
  `fleet_id` int(10) unsigned NOT NULL DEFAULT '0',
  `extra_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fleet_id`,`extra_id`),
  KEY `fleet_id` (`fleet_id`),
  KEY `extra_id` (`extra_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `taxi_prices`;
CREATE TABLE IF NOT EXISTS `taxi_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fleet_id` int(10) unsigned NOT NULL DEFAULT '0',
  `start` int(10) unsigned DEFAULT NULL,
  `end` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `in_range` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `taxi_fields`;
CREATE TABLE IF NOT EXISTS `taxi_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

DROP TABLE IF EXISTS `taxi_fields`;
CREATE TABLE IF NOT EXISTS `taxi_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `taxi_multi_lang`;
CREATE TABLE IF NOT EXISTS `taxi_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `taxi_options`;
CREATE TABLE IF NOT EXISTS `taxi_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `taxi_roles`;
CREATE TABLE IF NOT EXISTS `taxi_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `taxi_users`;
CREATE TABLE IF NOT EXISTS `taxi_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `taxi_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnAddClient', 'backend', 'Button / + Add client', 'script', NULL),
(7, 'btnAddEnquiry', 'backend', 'Button / + Add enquiry', 'script', NULL),
(8, 'btnAddExtra', 'backend', 'Button / + Add extra', 'script', NULL),
(9, 'btnAddReason', 'backend', 'Button / + Add reason', 'script', NULL),
(10, 'btnAddTransfer', 'backend', 'Button / + Add transfer', 'script', NULL),
(11, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(12, 'btnAddVehicle', 'backend', 'Button / + Add vehicle', 'script', NULL),
(13, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(14, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(15, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(16, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(17, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(18, 'btnEdit', 'backend', 'Button / Edit', 'script', NULL),
(19, 'btnGenerate', 'backend', 'Button / Generate', 'script', NULL),
(20, 'btnLogin', 'backend', 'Login', 'script', NULL),
(21, 'btnPreview', 'backend', 'Button / Preview', 'script', NULL),
(22, 'btnRemove', 'backend', 'Button / Remove', 'script', NULL),
(23, 'btnReset', 'backend', 'Reset', 'script', NULL),
(24, 'btnSave', 'backend', 'Save', 'script', NULL),
(25, 'btnSearch', 'backend', 'Search', 'script', NULL),
(26, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(27, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(28, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(29, 'created', 'backend', 'Created', 'script', NULL),
(30, 'dash_add_enquiry', 'backend', 'Label / Add Enquiry', 'script', NULL),
(31, 'dash_enquiries_received_today', 'backend', 'Label / enquiries received today', 'script', NULL),
(32, 'dash_enquiry_received_today', 'backend', 'Label / enquiry received today', 'script', NULL),
(33, 'dash_latest_enquiries', 'backend', 'Label / Latest enquiries', 'script', NULL),
(34, 'dash_link_reservations_today', 'backend', 'Label / Reservations today', 'script', NULL),
(35, 'dash_no_enquiries', 'backend', 'Label / No enquiries found.', 'script', NULL),
(36, 'dash_open_frontend', 'backend', 'Label / Open front-end', 'script', NULL),
(37, 'dash_quick_links', 'backend', 'Label / Quick links', 'script', NULL),
(38, 'dash_reservation', 'backend', 'Label / reservation', 'script', NULL),
(39, 'dash_reservations_today', 'backend', 'Label / reservations today', 'script', NULL),
(40, 'dash_reservation_today', 'backend', 'Label / reservation today', 'script', NULL),
(41, 'dash_title_reservations_today', 'backend', 'Label / Reservations today', 'script', NULL),
(42, 'dash_total_reservations', 'backend', 'Label / total reservations', 'script', NULL),
(43, 'dash_view_enquiries', 'backend', 'Label / View Enquiries', 'script', NULL),
(44, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(45, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(46, 'email', 'backend', 'E-Mail', 'script', NULL),
(47, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(48, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(49, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(50, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(51, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(52, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(53, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(54, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(55, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(56, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(57, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(58, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(59, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(60, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(61, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(62, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(63, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(64, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(65, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(66, 'infoAddBookingDesc', 'backend', 'Infobox / Add new reservation', 'script', NULL),
(67, 'infoAddBookingTitle', 'backend', 'Infobox / Add new reservation', 'script', NULL),
(68, 'infoAddClientDesc', 'backend', 'Infobox / Add client', 'script', NULL),
(69, 'infoAddClientTitle', 'backend', 'Infobox / Add client', 'script', NULL),
(70, 'infoAddExtraDesc', 'backend', 'Infobx / Add extra', 'script', NULL),
(71, 'infoAddExtraTitle', 'backend', 'Infobx / Add extra', 'script', NULL),
(72, 'infoAddFleetDesc', 'backend', 'Infobox / Add new fleet', 'script', NULL),
(73, 'infoAddFleetTitle', 'backend', 'Infobox / Add new fleet', 'script', NULL),
(74, 'infoAddLocationDesc', 'backend', 'Infobox / Add new location desc', 'script', NULL),
(75, 'infoAddLocationTitle', 'backend', 'Infobox / Add new location', 'script', NULL),
(76, 'infoAddReasonDesc', 'backend', 'Infbox / Add reason for hire', 'script', NULL),
(77, 'infoAddReasonTitle', 'backend', 'Infbox / Add reason for hire', 'script', NULL),
(78, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(79, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(80, 'infoBookingFormDesc', 'backend', 'Infobox / Reservation form options', 'script', NULL),
(81, 'infoBookingFormTitle', 'backend', 'Infobox / Reservation form options', 'script', NULL),
(82, 'infoCancellationEmailDesc', 'backend', 'Infobox / Send cancellation email', 'script', NULL),
(83, 'infoCancellationEmailTitle', 'backend', 'Infobox / Cancellation email', 'script', NULL),
(84, 'infoClientsDesc', 'backend', 'Infobox / List of clients', 'script', NULL),
(85, 'infoClientsTitle', 'backend', 'Infobox / List of clients', 'script', NULL),
(86, 'infoConfirmation2Desc', 'backend', 'Infobox / Notifications description', 'script', NULL),
(87, 'infoConfirmationDesc', 'backend', 'Infobox / Notifications description', 'script', NULL),
(88, 'infoExtrasDesc', 'backend', 'Infobox / Extras', 'script', NULL),
(89, 'infoExtrasTitle', 'backend', 'Infobox / Extras', 'script', NULL),
(90, 'infoFleetsDesc', 'backend', 'Infobox / Fleets description', 'script', NULL),
(91, 'infoFleetsTitle', 'backend', 'Infobox / Fleets title', 'script', NULL),
(92, 'infoGeneralDesc', 'backend', 'Infobox / General Report', 'script', NULL),
(93, 'infoGeneralTitle', 'backend', 'Infobox / General Report', 'script', NULL),
(94, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(95, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(96, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(97, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(98, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(99, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(100, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(101, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(102, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(103, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(104, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(105, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(106, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(107, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(108, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(109, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(110, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(111, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(112, 'infoLocationsDesc', 'backend', 'Infobox / Locations description', 'script', NULL),
(113, 'infoLocationsTitle', 'backend', 'Infobox / Locations title', 'script', NULL),
(114, 'infoPickupLocationDesc', 'backend', 'Infobox / Pickup Location Report', 'script', NULL),
(115, 'infoPickupLocationTitle', 'backend', 'Infobox / Pickup Location Report', 'script', NULL),
(116, 'infoPreviewInstallDesc', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(117, 'infoPreviewInstallTitle', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(118, 'infoReasonsDesc', 'backend', 'Infbox / List of reasons for hire', 'script', NULL),
(119, 'infoReasonsTitle', 'backend', 'Infbox / List of reasons for hire', 'script', NULL),
(120, 'infoResendEmailDesc', 'backend', 'Infobox / Re-send confirmation', 'script', NULL),
(121, 'infoResendEmailTitle', 'backend', 'Infobox / Re-send confirmation', 'script', NULL),
(122, 'infoReservationDesc', 'backend', 'Infobox / Reservation options', 'script', NULL),
(123, 'infoReservationListDesc', 'backend', 'Infobox / Reservations list', 'script', NULL),
(124, 'infoReservationListTitle', 'backend', 'Infobox / Reservations list', 'script', NULL),
(125, 'infoReservationTitle', 'backend', 'Infobox / Reservation options', 'script', NULL),
(126, 'infoSendSmsDesc', 'backend', 'Label / Send SMS notification', 'script', NULL),
(127, 'infoSendSmsTitle', 'backend', 'Label / Send SMS notification', 'script', NULL),
(128, 'infoTermsDesc', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(129, 'infoTermsTitle', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(130, 'infoUpdateBookingDesc', 'backend', 'Infobox / Update booking', 'script', NULL),
(131, 'infoUpdateBookingTitle', 'backend', 'Infobox / Update booking', 'script', NULL),
(132, 'infoUpdateClientDesc', 'backend', 'Infobox / Update', 'script', NULL),
(133, 'infoUpdateClientTitle', 'backend', 'Infobox / Update', 'script', NULL),
(134, 'infoUpdateExtraDesc', 'backend', 'Infobx / Update extra', 'script', NULL),
(135, 'infoUpdateExtraTitle', 'backend', 'Infobx / Update extra', 'script', NULL),
(136, 'infoUpdateFleetDesc', 'backend', 'Infobox / Update fleet', 'script', NULL),
(137, 'infoUpdateFleetTitle', 'backend', 'Infobox / Update fleet', 'script', NULL),
(138, 'infoUpdateLocationDesc', 'backend', 'Infobox / Update location description', 'script', NULL),
(139, 'infoUpdateLocationTitle', 'backend', 'Infobox / Update location title', 'script', NULL),
(140, 'infoUpdatePriceDesc', 'backend', 'Label / Prices', 'script', NULL),
(141, 'infoUpdatePriceTitle', 'backend', 'Label / Prices', 'script', NULL),
(142, 'infoUpdateReasonDesc', 'backend', 'Infbox / Update reason', 'script', NULL),
(143, 'infoUpdateReasonTitle', 'backend', 'Infbox / Update reason', 'script', NULL),
(144, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(145, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(146, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', NULL),
(147, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', NULL),
(148, 'infoVehicleDesc', 'backend', 'Infobox / Vehicle Report', 'script', NULL),
(149, 'infoVehicleTitle', 'backend', 'Infobox / Vehicle Report', 'script', NULL),
(150, 'lblAddClient', 'backend', 'Label / Add client', 'script', NULL),
(151, 'lblAddFleet', 'backend', 'Label / Add fleet', 'script', NULL),
(152, 'lblAdditionalInfo', 'backend', 'Label / Additional info', 'script', NULL),
(153, 'lblAddLocation', 'backend', 'Label / Add location', 'script', NULL),
(154, 'lblAddReservation', 'backend', 'Label / Add reservation', 'script', NULL),
(155, 'lblAddress', 'backend', 'Label / Address', 'script', NULL),
(156, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(157, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(158, 'lblArrivalFlightNumber', 'backend', 'Label / Arrival flight number', 'script', NULL),
(159, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(160, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(161, 'lblBookingAddress', 'backend', 'Label / Address', 'script', NULL),
(162, 'lblBookingAirlineCompany', 'backend', 'Label / Airline company', 'script', NULL),
(163, 'lblBookingCity', 'backend', 'Label / City', 'script', NULL),
(164, 'lblBookingCompany', 'backend', 'Label / Company', 'script', NULL),
(165, 'lblBookingCountry', 'backend', 'Label / Country', 'script', NULL),
(166, 'lblBookingCruiseShip', 'backend', 'Label / Cruise ship', 'script', NULL),
(167, 'lblBookingDestAddress', 'backend', 'Label / Complete destination address', 'script', NULL),
(168, 'lblBookingDetails', 'backend', 'Label / Reservation details', 'script', NULL),
(169, 'lblBookingEmail', 'backend', 'Label / Email', 'script', NULL),
(170, 'lblBookingFlightNumber', 'backend', 'Label / Flight number', 'script', NULL),
(171, 'lblBookingFlightTime', 'backend', 'Label / Flight Time', 'script', NULL),
(172, 'lblBookingFname', 'backend', 'Label / First name', 'script', NULL),
(173, 'lblBookingID', 'backend', 'Label / Booking ID', 'script', NULL),
(174, 'lblBookingLname', 'backend', 'Label / Last name', 'script', NULL),
(175, 'lblBookingNotes', 'backend', 'Label / Notes', 'script', NULL),
(176, 'lblBookingPhone', 'backend', 'Label / Phone', 'script', NULL),
(177, 'lblBookingState', 'backend', 'Label / State', 'script', NULL),
(178, 'lblBookingTerminal', 'backend', 'Label / Terminal / Gate', 'script', NULL),
(179, 'lblBookingTitle', 'backend', 'Label / Title', 'script', NULL),
(180, 'lblBookingZip', 'backend', 'Label / Zip', 'script', NULL),
(181, 'lblCancelledReservations', 'backend', 'Label / Cancelled Reservations', 'script', NULL),
(182, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(183, 'lblCCExp', 'backend', 'Label / CC expiration date', 'script', NULL),
(184, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(185, 'lblCCType', 'backend', 'Label / CC Type', 'script', NULL),
(186, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(187, 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(188, 'lblClient', 'backend', 'Label / Client', 'script', NULL),
(189, 'lblClientDetails', 'backend', 'Label / Client details', 'script', NULL),
(190, 'lblConfirmedReservations', 'backend', 'Label / Confirmed Reservations', 'script', NULL),
(191, 'lblCopyDropoff', 'backend', 'Label / Copy Drop-off Locations', 'script', NULL),
(192, 'lblCopyLocation', 'backend', 'Label / copy location', 'script', NULL),
(193, 'lblCount', 'backend', 'Label / Count', 'script', NULL),
(194, 'lblCreatedOn', 'backend', 'Label / Created on', 'script', NULL),
(195, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(196, 'lblCustomer', 'backend', 'Label / Customer', 'script', NULL),
(197, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(198, 'lblDashViewAll', 'backend', 'Label / view all', 'script', NULL),
(199, 'lblDate', 'backend', 'Label / Date', 'script', NULL),
(200, 'lblDateAndTime', 'backend', 'Label / Date & Time', 'script', NULL),
(201, 'lblDateFrom', 'backend', 'Label / Date from', 'script', NULL),
(202, 'lblDateTime', 'backend', 'Label / Date & time', 'script', NULL),
(203, 'lblDateTo', 'backend', 'Label / Date to', 'script', NULL),
(204, 'lblDays', 'backend', 'Days', 'script', NULL),
(205, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(206, 'lblDeleteConfirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(207, 'lblDeleteDropoff', 'backend', 'Label / Delete drop-off location', 'script', NULL),
(208, 'lblDeleteDropoffConfirm', 'backend', 'Label / Delete confirmation', 'script', NULL),
(209, 'lblDeleteImage', 'backend', 'Label / Delete image', 'script', NULL),
(210, 'lblDepartureAirlineCompany', 'backend', 'Label / Departure airline company', 'script', NULL),
(211, 'lblDepartureFlightNumber', 'backend', 'Label / Departure flight number', 'script', NULL),
(212, 'lblDeposit', 'backend', 'Label / Deposit', 'script', NULL),
(213, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(214, 'lblDestination', 'backend', 'Label / Destination', 'script', NULL),
(215, 'lblDestinationTrips', 'backend', 'Label / Destinations Trips', 'script', NULL),
(216, 'lblDetails', 'backend', 'Label / Details', 'script', NULL),
(217, 'lblDistance', 'backend', 'Label / Distance', 'script', NULL),
(218, 'lblDropoff', 'backend', 'Label / Drop-off', 'script', NULL),
(219, 'lblDropoffAddress', 'backend', 'Label / Drop-off address', 'script', NULL),
(220, 'lblDropoffLocation', 'backend', 'Label / Drop-off location', 'script', NULL),
(221, 'lblDuplicatedUniqueID', 'backend', 'Label / Duplicated Unique ID', 'script', NULL),
(222, 'lblDuration', 'backend', 'Label / Duration', 'script', NULL),
(223, 'lblEditDropoff', 'backend', 'Label / Edit drop-off', 'script', NULL),
(224, 'lblEnquiries', 'backend', 'Label / Enquiries', 'script', NULL),
(225, 'lblEnquiryDetails', 'backend', 'Label / Enquiry details', 'script', NULL),
(226, 'lblError', 'backend', 'Error', 'script', NULL),
(227, 'lblExistingClient', 'backend', 'Label / Existing client', 'script', NULL),
(228, 'lblExport', 'backend', 'Export', 'script', NULL),
(229, 'lblExtraName', 'backend', 'Label / Extra name', 'script', NULL),
(230, 'lblExtras', 'backend', 'Label / Extras', 'script', NULL),
(231, 'lblFeePerPerson', 'backend', 'Label / Fee per person', 'script', NULL),
(232, 'lblFleet', 'backend', 'Label / Fleet', 'script', NULL),
(233, 'lblFlightArrivalTime', 'backend', 'Label / Flight arrival time', 'script', NULL),
(234, 'lblFlightDepartureTime', 'backend', 'Label / Flight departure time', 'script', NULL),
(235, 'lblFlightTime', 'backend', 'Label / Flight time', 'script', NULL),
(236, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(237, 'lblFrom', 'backend', 'Label / From', 'script', NULL),
(238, 'lblFromInKm', 'backend', 'Label / From (km)', 'script', NULL),
(239, 'lblFromPickupLocation', 'backend', 'Label / From pick-up location', 'script', NULL),
(240, 'lblFromTo', 'backend', 'Label / From / To', 'script', NULL),
(241, 'lblGeneralReport', 'backend', 'Label / General Report', 'script', NULL),
(242, 'lblGeneralReservationsReport', 'backend', 'Label / General Reservations Report', 'script', NULL),
(243, 'lblHere', 'backend', 'Label / here', 'script', NULL),
(244, 'lblID', 'backend', 'Label / ID', 'script', NULL),
(245, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(246, 'lblIncluded', 'backend', 'Label / included', 'script', NULL),
(247, 'lblIncludedExtras', 'backend', 'Label / Included extras', 'script', NULL),
(248, 'lblInstallCode', 'backend', 'Lable / Install code', 'script', NULL),
(249, 'lblInstallConfig', 'backend', 'Label / Installation configuration', 'script', NULL),
(250, 'lblInstallConfigHide', 'backend', 'Button / Hide language selector ', 'script', NULL),
(251, 'lblInstallConfigLocale', 'backend', 'Label / Select language', 'script', NULL),
(252, 'lblInstallJs1_body', 'backend', 'Label / Installation', 'script', NULL),
(253, 'lblInstallJs1_title', 'backend', 'Label / Installation', 'script', NULL),
(254, 'lblIp', 'backend', 'IP address', 'script', NULL),
(255, 'lblIpAddress', 'backend', 'Label / IP address', 'script', NULL),
(256, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(257, 'lblKm', 'backend', 'Label / Km', 'script', NULL),
(258, 'lblLastEnquiry', 'backend', 'Label / Last enquiry', 'script', NULL),
(259, 'lblLatestReservations', 'backend', 'Label / Latest Reservations', 'script', NULL),
(260, 'lblLbsRoundTrip', 'backend', 'Label / Round trip', 'script', NULL),
(261, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(262, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(263, 'lblLocation', 'backend', 'Label / Location', 'script', NULL),
(264, 'lblLuggage', 'backend', 'Label / Luggage', 'script', NULL),
(265, 'lblLuggageCaried', 'backend', 'Label / Luggage Carried', 'script', NULL),
(266, 'lblManageFleet', 'backend', 'Label / Manage fleet', 'script', NULL),
(267, 'lblMaximum', 'backend', 'Label / maximum', 'script', NULL),
(268, 'lblMaxNumber', 'backend', 'Label / Maximum number', 'script', NULL),
(269, 'lblMinutes', 'backend', 'Label / Minutes', 'script', NULL),
(270, 'lblName', 'backend', 'Name', 'script', NULL),
(271, 'lblNewClient', 'backend', 'Label / New client', 'script', NULL),
(272, 'lblNewReservationsToday', 'backend', 'Label / new reservations today', 'script', NULL),
(273, 'lblNewReservationToday', 'backend', 'Label / new reservation today', 'script', NULL),
(274, 'lblNo', 'backend', 'No', 'script', NULL),
(275, 'lblNotifications', 'backend', 'Label / Notifications', 'script', NULL),
(276, 'lblOneWay', 'backend', 'Label / One way', 'script', NULL),
(277, 'lblOneWayReservations', 'backend', 'Label / One-way Reservations', 'script', NULL),
(278, 'lblOneWayRoundTrip', 'backend', 'Label / One-way vs Round-trip Reservations', 'script', NULL),
(279, 'lblOption', 'backend', 'Option', 'script', NULL),
(280, 'lblOptionAdministrator', 'backend', 'Label / Administrator', 'script', NULL),
(281, 'lblOptionClient', 'backend', 'Label / Client', 'script', NULL),
(282, 'lblOptionHours', 'backend', 'Label / hour(s)', 'script', NULL),
(283, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(284, 'lblPassenger', 'backend', 'Label / Passenger', 'script', NULL),
(285, 'lblPassengers', 'backend', 'Label / Passengers', 'script', NULL),
(286, 'lblPassengersPer', 'backend', 'Label / Passengers per reservation', 'script', NULL),
(287, 'lblPassengersServed', 'backend', 'Label / Passengers Served', 'script', NULL),
(288, 'lblPayment', 'backend', 'Label / Payment', 'script', NULL),
(289, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(290, 'lblPerPerson', 'backend', 'Label / per person', 'script', NULL),
(291, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(292, 'lblPickup', 'backend', 'Label / Pickup', 'script', NULL),
(293, 'lblPickupAddress', 'backend', 'Label / Pick-up address', 'script', NULL),
(294, 'lblPickupDate', 'backend', 'Label / Pickup date', 'script', NULL),
(295, 'lblPickupDropoff', 'backend', 'Label / Pickup / Dropoff', 'script', NULL),
(296, 'lblPickupDropofLocation', 'backend', 'Label / Pick-up and drop-off location', 'script', NULL),
(297, 'lblPickupLocation', 'backend', 'Label / Pickup location', 'script', NULL),
(298, 'lblPickupLocationReport', 'backend', 'Label / Pickup Location Report', 'script', NULL),
(299, 'lblPositiveNumber', 'backend', 'Label / Enter a positive number.', 'script', NULL),
(300, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(301, 'lblPricePerKm', 'backend', 'Label / Price per km', 'script', NULL),
(302, 'lblPricePerPerson', 'backend', 'Label / Price per person', 'script', NULL),
(303, 'lblPrices', 'backend', 'Label / Prices', 'script', NULL),
(304, 'lblPriceStatusEnd', 'backend', 'Label / Prices have been saved.', 'script', NULL),
(305, 'lblPriceStatusFail', 'backend', 'Label / Prices could not be saved.', 'script', NULL),
(306, 'lblPriceStatusStart', 'backend', 'Label / Please wait while prices are saved.', 'script', NULL),
(307, 'lblPrint', 'backend', 'Label / Print', 'script', NULL),
(308, 'lblPrintReservation', 'backend', 'Label / Print Enquiry', 'script', NULL),
(309, 'lblReasonForHire', 'backend', 'Label / Reason for hire', 'script', NULL),
(310, 'lblReasonName', 'backend', 'Label / Reason name', 'script', NULL),
(311, 'lblReminderMessage', 'backend', 'Label / Message', 'script', NULL),
(312, 'lblReminderSubject', 'backend', 'Label / Subject', 'script', NULL),
(313, 'lblReminderTo', 'backend', 'Label / To', 'script', NULL),
(314, 'lblReportPickupLocation', 'backend', 'Label / Report by Pickup Location', 'script', NULL),
(315, 'lblReportVehicle', 'backend', 'Label / Vehicle Report', 'script', NULL),
(316, 'lblResendConfirmation', 'backend', 'Label / Re-send confirmation', 'script', NULL),
(317, 'lblReservationPrint', 'backend', 'Label / Print Reservation', 'script', NULL),
(318, 'lblReservationPrintList', 'backend', 'Label / Reservations Print List', 'script', NULL),
(319, 'lblReservations', 'backend', 'Label / Reservations', 'script', NULL),
(320, 'lblReservationsNotFound', 'backend', 'Label / Reservations not found', 'script', NULL),
(321, 'lblReservationsToday', 'backend', 'Label / Reservations Today', 'script', NULL),
(322, 'lblReturn', 'backend', 'Label / Return', 'script', NULL),
(323, 'lblReturnDateTime', 'backend', 'Label / Return date & time', 'script', NULL),
(324, 'lblReturnOn', 'backend', 'Label / Return on', 'script', NULL),
(325, 'lblReturnTrip', 'backend', 'Label / Return trip', 'script', NULL),
(326, 'lblRole', 'backend', 'Role', 'script', NULL),
(327, 'lblRoundTrip', 'backend', 'Label / roundtrip', 'script', NULL),
(328, 'lblRoundTripReservations', 'backend', 'Label / Round-trip Reservations', 'script', NULL),
(329, 'lblSendCancellationEmail', 'backend', 'Label / Send cancellation email', 'script', NULL),
(330, 'lblSendSMSNotification', 'backend', 'Label / Send SMS notification', 'script', NULL),
(331, 'lblService', 'backend', 'Label / Service', 'script', NULL),
(332, 'lblServices', 'backend', 'Label / Services', 'script', NULL),
(333, 'lblSetPrices', 'backend', 'Label / Set prices', 'script', NULL),
(334, 'lblSingle', 'backend', 'Label / Single', 'script', NULL),
(335, 'lblSmsMessage', 'backend', 'Label / SMS message', 'script', NULL),
(336, 'lblStartFee', 'backend', 'Label / Start fee', 'script', NULL),
(337, 'lblStatus', 'backend', 'Status', 'script', NULL),
(338, 'lblStatusEnd', 'backend', 'Label / Locations have been saved.', 'script', NULL),
(339, 'lblStatusFail', 'backend', 'Label / Locations could not be saved.', 'script', NULL),
(340, 'lblStatusStart', 'backend', 'Label / Please wait while locations are saved.', 'script', NULL),
(341, 'lblStatusTitle', 'backend', 'Label / Status', 'script', NULL),
(342, 'lblSubTotal', 'backend', 'Label / Sub-total', 'script', NULL),
(343, 'lblTax', 'backend', 'Label / Tax', 'script', NULL),
(344, 'lblThumb', 'backend', 'Label / Thumb', 'script', NULL),
(345, 'lblTo', 'backend', 'Label / To', 'script', NULL),
(346, 'lblToCollect', 'backend', 'Label / To collect', 'script', NULL),
(347, 'lblTodayTransfers', 'backend', 'Label / Today Transfers', 'script', NULL),
(348, 'lblToDropoffLocation', 'backend', 'Label / To drop-off location', 'script', NULL),
(349, 'lblToGreaterThanFrom', 'backend', 'Label / To must be greater than From', 'script', NULL),
(350, 'lblToInKm', 'backend', 'Label / To (km)', 'script', NULL),
(351, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(352, 'lblTotalAmount', 'backend', 'Label / Total Amount', 'script', NULL),
(353, 'lblTotalEnquiries', 'backend', 'Label / Total enquiries', 'script', NULL),
(354, 'lblTotalReservations', 'backend', 'Label / Total Reservations', 'script', NULL),
(355, 'lblTransferDate', 'backend', 'Label / Transfer date', 'script', NULL),
(356, 'lblTransferDateTime', 'backend', 'Label / Transfer Date & Time', 'script', NULL),
(357, 'lblTransferDestinations', 'backend', 'Label / Transfer Destinations', 'script', NULL),
(358, 'lblTransfersToday', 'backend', 'Label / Transfers Today', 'script', NULL),
(359, 'lblTransferToday', 'backend', 'Label / Transfer Today', 'script', NULL),
(360, 'lblType', 'backend', 'Type', 'script', NULL),
(361, 'lblUniqueID', 'backend', 'Label / Unique ID', 'script', NULL),
(362, 'lblUpdateClient', 'backend', 'Label / Update client', 'script', NULL),
(363, 'lblUpdateFleet', 'backend', 'Label / Update fleet', 'script', NULL),
(364, 'lblUpdateLocation', 'backend', 'Label / Update location', 'script', NULL),
(365, 'lblUpdateReservation', 'backend', 'Label / Update reservation', 'script', NULL),
(366, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(367, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(368, 'lblValue', 'backend', 'Value', 'script', NULL),
(369, 'lblVehicle', 'backend', 'Label / Vehicle', 'script', NULL),
(370, 'lblVehicleReport', 'backend', 'Label / Vehicle Report', 'script', NULL),
(371, 'lblVehicleUsed', 'backend', 'Label / Vehicle Used', 'script', NULL),
(372, 'lblVia', 'backend', 'Label / via', 'script', NULL),
(373, 'lblYes', 'backend', 'Yes', 'script', NULL),
(374, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(375, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(376, 'locales', 'backend', 'Languages', 'script', NULL),
(377, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(378, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(379, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(380, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(381, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(382, 'menuClients', 'backend', 'Menu / Clients', 'script', NULL),
(383, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(384, 'menuExtras', 'backend', 'Menu / Extras', 'script', NULL),
(385, 'menuFleets', 'backend', 'Menu / Fleets', 'script', NULL),
(386, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(387, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(388, 'menuInstallPreview', 'backend', 'Menu / Preview & Install', 'script', NULL),
(389, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(390, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(391, 'menuLocations', 'backend', 'Menu / Locations', 'script', NULL),
(392, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(393, 'menuNews', 'backend', 'Menu / News', 'script', NULL),
(394, 'menuNotifications', 'backend', 'Menu / Notifications', 'script', NULL),
(395, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(396, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(397, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(398, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(399, 'menuReports', 'backend', 'Menu / Reports', 'script', NULL),
(400, 'menuReservation', 'backend', 'Menu / Reservation', 'script', NULL),
(401, 'menuReservationForm', 'backend', 'Menu / Checkout form', 'script', NULL),
(402, 'menuReservations', 'backend', 'Menu / Reservations', 'script', NULL),
(403, 'menuTerms', 'backend', 'Menu / Terms', 'script', NULL),
(404, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(405, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(406, 'opt_o_admin_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(407, 'opt_o_admin_email_client_account_message_text', 'backend', 'Options / Account tokens', 'script', NULL),
(408, 'opt_o_admin_email_client_account_text', 'backend', 'Options / New client account email', 'script', NULL),
(409, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / Send confirmation email', 'script', NULL),
(410, 'opt_o_admin_email_payment_text', 'backend', 'Options / Send payment email', 'script', NULL),
(411, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / New Reservation SMS', 'script', NULL),
(412, 'opt_o_admin_sms_confirmation_message_text', 'backend', 'Options / New Reservation SMS', 'script', NULL),
(413, 'opt_o_admin_sms_payment_message', 'backend', 'Options / Payment confirmation SMS', 'script', NULL),
(414, 'opt_o_admin_sms_payment_message_text', 'backend', 'Options / Payment confirmation SMS', 'script', NULL),
(415, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net ', 'script', NULL),
(416, 'opt_o_allow_bank', 'backend', 'Options / Allow bank account', 'script', NULL),
(417, 'opt_o_allow_cash', 'backend', 'Options / Allow payment with cash', 'script', NULL),
(418, 'opt_o_allow_creditcard', 'backend', 'Options / Allow credit card', 'script', NULL),
(419, 'opt_o_allow_paypal', 'backend', 'Options / Allow payment', 'script', NULL),
(420, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash ', 'script', NULL),
(421, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID  ', 'script', NULL),
(422, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone ', 'script', NULL),
(423, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key ', 'script', NULL),
(424, 'opt_o_bank_account', 'backend', 'Options / Bank account', 'script', NULL),
(425, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(426, 'opt_o_bf_include_airline_company', 'backend', 'Options / Airline company', 'script', NULL),
(427, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(428, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(429, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(430, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(431, 'opt_o_bf_include_cruise_ship', 'backend', 'Options / Cruise ship', 'script', NULL),
(432, 'opt_o_bf_include_destination_address', 'backend', 'Options / Complete destination address', 'script', NULL),
(433, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(434, 'opt_o_bf_include_flight_number', 'backend', 'Options / Flight number', 'script', NULL),
(435, 'opt_o_bf_include_flight_time', 'backend', 'Options / Flight time', 'script', NULL),
(436, 'opt_o_bf_include_fname', 'backend', 'Options / First name', 'script', NULL),
(437, 'opt_o_bf_include_lname', 'backend', 'Options / Last name', 'script', NULL),
(438, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(439, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(440, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(441, 'opt_o_bf_include_termial', 'backend', 'Label / Terminal / Gate', 'script', NULL),
(442, 'opt_o_bf_include_terminal', 'backend', 'Options / Terminal / Gate', 'script', NULL),
(443, 'opt_o_bf_include_title', 'backend', 'Options / Title', 'script', NULL),
(444, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(445, 'opt_o_booking_status', 'backend', 'Options / Booking status', 'script', NULL),
(446, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(447, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(448, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(449, 'opt_o_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(450, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(451, 'opt_o_email_cancel_message_text', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(452, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(453, 'opt_o_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(454, 'opt_o_email_client_account', 'backend', 'Options / New client account email', 'script', NULL),
(455, 'opt_o_email_client_account_message', 'backend', 'Options / Subject', 'script', NULL),
(456, 'opt_o_email_client_account_message_text', 'backend', 'Options / Account tokens', 'script', NULL),
(457, 'opt_o_email_client_account_subject', 'backend', 'Options / Subject', 'script', NULL),
(458, 'opt_o_email_client_account_text', 'backend', 'Options / New client account email', 'script', NULL),
(459, 'opt_o_email_confirmation', 'backend', 'Options / New reservation received email', 'script', NULL),
(460, 'opt_o_email_confirmation_message', 'backend', 'Options / Reservation confirmation message', 'script', NULL),
(461, 'opt_o_email_confirmation_message_text', 'backend', 'Options / Reservation confirmation message', 'script', NULL),
(462, 'opt_o_email_confirmation_subject', 'backend', 'Options / Reservation confirmation subject', 'script', NULL),
(463, 'opt_o_email_confirmation_text', 'backend', 'Options / New reservation received email', 'script', NULL),
(464, 'opt_o_email_forgot_message', 'backend', 'Options / Subject', 'script', NULL),
(465, 'opt_o_email_forgot_message_text', 'backend', 'Options / Account tokens', 'script', NULL),
(466, 'opt_o_email_forgot_subject', 'backend', 'Options / Subject', 'script', NULL),
(467, 'opt_o_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(468, 'opt_o_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(469, 'opt_o_email_payment_message_text', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(470, 'opt_o_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(471, 'opt_o_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(472, 'opt_o_google_api_key', 'backend', 'Label / Google API key', 'script', NULL),
(473, 'opt_o_hour_earlier', 'backend', 'Label / Accept enquiries X hours earlier', 'script', NULL),
(474, 'opt_o_mileage', 'backend', 'Options / Mileage', 'script', NULL),
(475, 'opt_o_payment_disable', 'backend', 'Options / Payment disable', 'script', NULL),
(476, 'opt_o_payment_status', 'backend', 'Options / Payment status', 'script', NULL),
(477, 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
(478, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(479, 'opt_o_sms_confirmation_message', 'backend', 'Options / Reservation reminder SMS', 'script', NULL),
(480, 'opt_o_sms_confirmation_message_text', 'backend', 'Options / Reservation reminder SMS', 'script', NULL),
(481, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(482, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(483, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(484, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(485, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(486, 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL),
(487, 'opt_o_thankyou_page', 'backend', 'Options / Thank you page', 'script', NULL),
(488, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(489, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(490, 'opt_o_vehicle_per_page', 'backend', 'Options / Vehicles per page', 'script', NULL),
(491, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(492, 'pass', 'backend', 'Password', 'script', NULL),
(493, 'pj_digits_validation', 'backend', 'Label / Please enter only digits', 'script', NULL),
(494, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(495, 'pj_number_validation', 'backend', 'Label / Please enter a valid number.', 'script', NULL),
(496, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(497, 'tabReasons', 'backend', 'Tab / Reasons for hide', 'script', NULL),
(498, 'tr_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(499, 'url', 'backend', 'URL', 'script', NULL),
(500, 'user', 'backend', 'Username', 'script', NULL),
(501, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(502, 'front_agree', 'frontend', 'Label / Agreement', 'script', NULL),
(503, 'front_airline', 'frontend', 'Label / Airline', 'script', NULL),
(504, 'front_airline_company', 'frontend', 'Label / Arrival airline company', 'script', NULL),
(505, 'front_all_inclusive', 'frontend', 'Label / All inclusive for only', 'script', NULL),
(506, 'front_already_logged_in', 'frontend', 'Label / You already logged in.', 'script', NULL),
(507, 'front_arrival_time', 'frontend', 'Label / Arrival time', 'script', NULL),
(508, 'front_back', 'frontend', 'Label / Back', 'script', NULL),
(509, 'front_bags', 'frontend', 'Label / Bags', 'script', NULL),
(510, 'front_bank_account', 'frontend', 'Lable / Bank account', 'script', NULL),
(511, 'front_booking_created', 'frontend', 'Label / Booking created', 'script', NULL),
(512, 'front_booking_details', 'frontend', 'Label / Booking Details', 'script', NULL),
(513, 'front_booking_id', 'frontend', 'Label / Booking ID', 'script', NULL),
(514, 'front_btn_back', 'frontend', 'Button / Back', 'script', NULL),
(515, 'front_btn_book_a_taxi', 'frontend', 'Button / Book a taxi', 'script', NULL),
(516, 'front_btn_cancel_enquiry', 'frontend', 'Button / Cancel enquiry', 'script', NULL),
(517, 'front_btn_close', 'frontend', 'Button / Close', 'script', NULL),
(518, 'front_btn_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(519, 'front_btn_login', 'frontend', 'Button / Login', 'script', NULL),
(520, 'front_btn_preview', 'frontend', 'Button / Preview', 'script', NULL),
(521, 'front_btn_reserve', 'frontend', 'Button / Reserve', 'script', NULL),
(522, 'front_btn_send', 'frontend', 'Button / Send', 'script', NULL),
(523, 'front_btn_start_over', 'frontend', 'Button / Star over', 'script', NULL),
(524, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(525, 'front_cc_code', 'frontend', 'Label / CC code', 'script', NULL),
(526, 'front_cc_exp', 'frontend', 'Label / CC expiration date', 'script', NULL),
(527, 'front_cc_num', 'frontend', 'Label / CC Number', 'script', NULL),
(528, 'front_cc_type', 'frontend', 'Label / CC Type', 'script', NULL),
(529, 'front_change', 'frontend', 'Label / Change', 'script', NULL),
(530, 'front_checkout', 'frontend', 'Label / Checkout', 'script', NULL),
(531, 'front_choose', 'frontend', 'Label / Choose', 'script', NULL),
(532, 'front_choose_airport', 'frontend', 'Lable / Choose Airport Transfer', 'script', NULL),
(533, 'front_choose_extras', 'frontend', 'Label / Choose extras', 'script', NULL),
(534, 'front_choose_provider', 'frontend', 'Label / Choose provider & service', 'script', NULL),
(535, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(536, 'front_company', 'frontend', 'Label / Company', 'script', NULL),
(537, 'front_confirm', 'frontend', 'Label / Confirm', 'script', NULL),
(538, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(539, 'front_cruise_ship', 'frontend', 'Label / Cruise ship', 'script', NULL),
(540, 'front_date_time', 'frontend', 'Label / Date and time', 'script', NULL),
(541, 'front_departure', 'frontend', 'Label / Departure', 'script', NULL),
(542, 'front_departure_airline_company', 'frontend', 'Label / Departure airline company', 'script', NULL),
(543, 'front_departure_flight_number', 'frontend', 'Label / Departure flight number', 'script', NULL),
(544, 'front_deposit_required', 'frontend', 'Label / Deposit required', 'script', NULL),
(545, 'front_destination', 'frontend', 'Label / Destination', 'script', NULL),
(546, 'front_destination_address', 'frontend', 'Label / Complete destination address', 'script', NULL),
(547, 'front_digits_validation', 'frontend', 'Lable / Please enter only digits.', 'script', NULL),
(548, 'front_distance', 'frontend', 'Label / Distance', 'script', NULL),
(549, 'front_dropoff_address', 'frontend', 'Label / Drop-off address', 'script', NULL),
(550, 'front_dropoff_location', 'frontend', 'Label / Drop-off location', 'script', NULL),
(551, 'front_email', 'frontend', 'Label / Email', 'script', NULL),
(552, 'front_email_does_not_exist', 'frontend', 'Label / Email does not exist.', 'script', NULL),
(553, 'front_email_validation', 'frontend', 'Lable / Email is invalid.', 'script', NULL),
(554, 'front_existing_client', 'frontend', 'Label / Existing client', 'script', NULL),
(555, 'front_exp_month', 'frontend', 'Label / Expiration month is required.', 'script', NULL),
(556, 'front_exp_year', 'frontend', 'Label / Expiration year is required.', 'script', NULL),
(557, 'front_extras', 'frontend', 'Label / Extras', 'script', NULL),
(558, 'front_extra_price', 'frontend', 'Label / Extra price', 'script', NULL),
(559, 'front_flight_departure_time', 'frontend', 'Label / Flight departure time', 'script', NULL),
(560, 'front_flight_details', 'frontend', 'Label / Flight Details', 'script', NULL),
(561, 'front_flight_details_desc', 'frontend', 'Label / Flight details description', 'script', NULL),
(562, 'front_flight_number', 'frontend', 'Label / Arrival flight number', 'script', NULL),
(563, 'front_flight_time', 'frontend', 'Label / Flight arrival time', 'script', NULL),
(564, 'front_fname', 'frontend', 'Label / First name', 'script', NULL),
(565, 'front_forgot_password', 'frontend', 'Label / Forgot password?', 'script', NULL),
(566, 'front_from', 'frontend', 'Label / From', 'script', NULL),
(567, 'front_hour_earlier_desc', 'frontend', 'Label / Date time for accepted enquireis', 'script', NULL),
(568, 'front_hour_earlier_title', 'frontend', 'Label / Date time for accepted enquireis', 'script', NULL),
(569, 'front_included', 'frontend', 'Label / included', 'script', NULL),
(570, 'front_incorrect_captcha', 'frontend', 'Label / Captcha is not correct.', 'script', NULL),
(571, 'front_incorrect_password', 'frontend', 'Label / Password is not correct.', 'script', NULL),
(572, 'front_invalid_date', 'frontend', 'Label / Invalid date time', 'script', NULL),
(573, 'front_invalid_email', 'frontend', 'Label / Invalid email', 'script', NULL),
(574, 'front_km', 'frontend', 'Label / km', 'script', NULL),
(575, 'front_link_forgot_password', 'frontend', 'Link / Forgot password?', 'script', NULL),
(576, 'front_link_login', 'frontend', 'Button / Login', 'script', NULL),
(577, 'front_lname', 'frontend', 'Label / Last name', 'script', NULL),
(578, 'front_login_message', 'frontend', 'Label /If you are existing client, click here to log in.', 'script', NULL),
(579, 'front_logout_message', 'frontend', 'Label / Logout message', 'script', NULL),
(580, 'front_miles', 'frontend', 'Label / miles', 'script', NULL),
(581, 'front_minutes', 'frontend', 'Label / minutes', 'script', NULL),
(582, 'front_new_client', 'frontend', 'Label / New client', 'script', NULL),
(583, 'front_notes', 'frontend', 'Label / Notes', 'script', NULL),
(584, 'front_no_fleet_found', 'frontend', 'Label / No fleet found', 'script', NULL),
(585, 'front_number_validation', 'frontend', 'Label / Please enter a valid number.', 'script', NULL),
(586, 'front_on', 'frontend', 'Label / On', 'script', NULL),
(587, 'front_one_way', 'frontend', 'Label / One way', 'script', NULL),
(588, 'front_passenger', 'frontend', 'Label / Passenger', 'script', NULL),
(589, 'front_passengers', 'frontend', 'Label / Passengers', 'script', NULL),
(590, 'front_password', 'frontend', 'Label / Password', 'script', NULL),
(591, 'front_password_sent', 'frontend', 'Label / The password has been sent to your email address.', 'script', NULL),
(592, 'front_payment_medthod', 'frontend', 'Label / Payment method', 'script', NULL),
(593, 'front_people', 'frontend', 'Label / People', 'script', NULL),
(594, 'front_personal_details', 'frontend', 'Label / Personal Details', 'script', NULL),
(595, 'front_per_person', 'frontend', 'Label / per person', 'script', NULL),
(596, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(597, 'front_pickup_address', 'frontend', 'Label / Pick-up address', 'script', NULL),
(598, 'front_pickup_dropoff_location', 'frontend', 'Label / Pick-up and drop-off location', 'script', NULL),
(599, 'front_pieces_of_luggage', 'frontend', 'Label / Pieces of luggage', 'script', NULL),
(600, 'front_piece_of_luggage', 'frontend', 'Label / Piece of luggage', 'script', NULL),
(601, 'front_plan_your_ride', 'frontend', 'Label / Plan your ride', 'script', NULL),
(602, 'front_preview', 'frontend', 'Label / Preview', 'script', NULL),
(603, 'front_price', 'frontend', 'Label / Price', 'script', NULL),
(604, 'front_processed_on', 'frontend', 'Label / Processed on', 'script', NULL),
(605, 'front_reason_for_hire', 'frontend', 'Label / Reason for hire', 'script', NULL),
(606, 'front_required_field', 'frontend', 'Label / This field is required.', 'script', NULL),
(607, 'front_return', 'frontend', 'Label / Return', 'script', NULL),
(608, 'front_return_on', 'frontend', 'Label / Return on', 'script', NULL),
(609, 'front_ride', 'frontend', 'Label / Ride', 'script', NULL),
(610, 'front_round_trip', 'frontend', 'Label / Round trip', 'script', NULL),
(611, 'front_search', 'frontend', 'Label / Search', 'script', NULL),
(612, 'front_search_again', 'frontend', 'Label / Search again', 'script', NULL),
(613, 'front_select_vehicle_type', 'frontend', 'Label / Select Vehicle Type', 'script', NULL),
(614, 'front_service', 'frontend', 'Label / Service', 'script', NULL),
(615, 'front_single', 'frontend', 'Label / Single', 'script', NULL),
(616, 'front_single_ride', 'frontend', 'Label / Single ride', 'script', NULL),
(617, 'front_start_fee', 'frontend', 'Label / Start fee', 'script', NULL),
(618, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(619, 'front_subtotal', 'frontend', 'Label / Subtotal', 'script', NULL),
(620, 'front_tax', 'frontend', 'Label / Tax', 'script', NULL),
(621, 'front_taxi_on', 'frontend', 'Lable / taxi on', 'script', NULL),
(622, 'front_taxi_on_2', 'frontend', 'Lable / taxi on', 'script', NULL),
(623, 'front_taxi_service_from', 'frontend', 'Label / Taxi service from', 'script', NULL),
(624, 'front_terminal', 'frontend', 'Label / Terminal / Gate', 'script', NULL),
(625, 'front_terms_conditions', 'frontend', 'Label / Terms and conditions', 'script', NULL),
(626, 'front_terms_title', 'frontend', 'Label / Terms and conditions', 'script', NULL),
(627, 'front_title', 'frontend', 'Label / Title', 'script', NULL),
(628, 'front_to', 'frontend', 'Label / To', 'script', NULL),
(629, 'front_total', 'frontend', 'Label / Total', 'script', NULL),
(630, 'front_total_price', 'frontend', 'Label / total price', 'script', NULL),
(631, 'front_to_lowercase', 'frontend', 'Lable / to', 'script', NULL),
(632, 'front_transfer_reservation', 'frontend', 'Label / Transfer Reservation', 'script', NULL),
(633, 'front_txn_id', 'frontend', 'Label / Paypal Transaction ID', 'script', NULL),
(634, 'front_with', 'frontend', 'Label / With', 'script', NULL),
(635, 'front_with_desc', 'frontend', 'Label / width passengers', 'script', NULL),
(636, 'front_with_desc_2', 'frontend', 'Label / width passengers', 'script', NULL),
(637, 'front_your_account_disabled', 'frontend', 'Label / Your account is disabled.', 'script', NULL),
(638, 'front_your_enquiry', 'frontend', 'Label / Your Enquiry', 'script', NULL),
(639, 'front_zip', 'frontend', 'Label / Zip', 'script', NULL),
(640, 'lblTransfer', 'frontend', 'Label / Transfer', 'script', NULL),
(641, 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(642, 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(643, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(644, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(645, 'buttons_ARRAY_copy', 'arrays', 'buttons_ARRAY_copy', 'script', NULL),
(646, 'buttons_ARRAY_no', 'arrays', 'buttons_ARRAY_no', 'script', NULL),
(647, 'buttons_ARRAY_set', 'arrays', 'buttons_ARRAY_set', 'script', NULL),
(648, 'buttons_ARRAY_yes', 'arrays', 'buttons_ARRAY_yes', 'script', NULL),
(649, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(650, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(651, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(652, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(653, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(654, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(655, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(656, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(657, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(658, 'client_email_ARRAY_account', 'arrays', 'client_email_arr_ARRAY_account', 'script', NULL),
(659, 'client_email_ARRAY_cancel', 'arrays', 'client_email_arr_ARRAY_cancel', 'script', NULL),
(660, 'client_email_ARRAY_confirmation', 'arrays', 'client_email_arr_ARRAY_confirmation', 'script', NULL),
(661, 'client_email_ARRAY_forgot', 'arrays', 'client_email_arr_ARRAY_forgot', 'script', NULL),
(662, 'client_email_ARRAY_payment', 'arrays', 'client_email_arr_ARRAY_payment', 'script', NULL),
(663, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(664, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(665, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(666, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(667, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(668, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(669, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(670, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(671, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(672, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(673, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(674, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(675, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(676, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(677, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(678, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(679, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(680, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(681, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(682, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(683, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(684, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(685, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(686, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(687, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(688, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(689, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(690, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(691, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(692, 'error_bodies_ARRAY_AB09', 'arrays', 'error_bodies_ARRAY_AB09', 'script', NULL),
(693, 'error_bodies_ARRAY_AB10', 'arrays', 'error_bodies_ARRAY_AB10', 'script', NULL),
(694, 'error_bodies_ARRAY_AB11', 'arrays', 'error_bodies_ARRAY_AB11', 'script', NULL),
(695, 'error_bodies_ARRAY_AB12', 'arrays', 'error_bodies_ARRAY_AB12', 'script', NULL),
(696, 'error_bodies_ARRAY_AB13', 'arrays', 'error_bodies_ARRAY_AB13', 'script', NULL),
(697, 'error_bodies_ARRAY_AB14', 'arrays', 'error_bodies_ARRAY_AB14', 'script', NULL),
(698, 'error_bodies_ARRAY_ABB01', 'arrays', 'error_bodies_ARRAY_ABB01', 'script', NULL),
(699, 'error_bodies_ARRAY_ABB03', 'arrays', 'error_bodies_ARRAY_ABB03', 'script', NULL),
(700, 'error_bodies_ARRAY_ABB04', 'arrays', 'error_bodies_ARRAY_ABB04', 'script', NULL),
(701, 'error_bodies_ARRAY_ABB08', 'arrays', 'error_bodies_ARRAY_ABB08', 'script', NULL),
(702, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(703, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(704, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(705, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(706, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(707, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(708, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(709, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(710, 'error_bodies_ARRAY_AF01', 'arrays', 'error_bodies_ARRAY_AF01', 'script', NULL),
(711, 'error_bodies_ARRAY_AF03', 'arrays', 'error_bodies_ARRAY_AF03', 'script', NULL),
(712, 'error_bodies_ARRAY_AF04', 'arrays', 'error_bodies_ARRAY_AF04', 'script', NULL),
(713, 'error_bodies_ARRAY_AF05', 'arrays', 'error_bodies_ARRAY_AF05', 'script', NULL),
(714, 'error_bodies_ARRAY_AF06', 'arrays', 'error_bodies_ARRAY_AF06', 'script', NULL),
(715, 'error_bodies_ARRAY_AF08', 'arrays', 'error_bodies_ARRAY_AF08', 'script', NULL),
(716, 'error_bodies_ARRAY_AF09', 'arrays', 'error_bodies_ARRAY_AF09', 'script', NULL),
(717, 'error_bodies_ARRAY_AF10', 'arrays', 'error_bodies_ARRAY_AF10', 'script', NULL),
(718, 'error_bodies_ARRAY_AF11', 'arrays', 'error_bodies_ARRAY_AF11', 'script', NULL),
(719, 'error_bodies_ARRAY_AL01', 'arrays', 'error_bodies_ARRAY_AL01', 'script', NULL),
(720, 'error_bodies_ARRAY_AL03', 'arrays', 'error_bodies_ARRAY_AL03', 'script', NULL),
(721, 'error_bodies_ARRAY_AL04', 'arrays', 'error_bodies_ARRAY_AL04', 'script', NULL),
(722, 'error_bodies_ARRAY_AL08', 'arrays', 'error_bodies_ARRAY_AL08', 'script', NULL),
(723, 'error_bodies_ARRAY_AL09', 'arrays', 'error_bodies_ARRAY_AL09', 'script', NULL),
(724, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(725, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(726, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(727, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(728, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(729, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(730, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(731, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(732, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(733, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(734, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(735, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(736, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(737, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(738, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(739, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(740, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(741, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(742, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(743, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(744, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(745, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(746, 'error_titles_ARRAY_AB09', 'arrays', 'error_titles_ARRAY_AB09', 'script', NULL),
(747, 'error_titles_ARRAY_AB10', 'arrays', 'error_titles_ARRAY_AB10', 'script', NULL),
(748, 'error_titles_ARRAY_AB11', 'arrays', 'error_titles_ARRAY_AB11', 'script', NULL),
(749, 'error_titles_ARRAY_AB12', 'arrays', 'error_titles_ARRAY_AB12', 'script', NULL),
(750, 'error_titles_ARRAY_AB13', 'arrays', 'error_titles_ARRAY_AB13', 'script', NULL),
(751, 'error_titles_ARRAY_AB14', 'arrays', 'error_titles_ARRAY_AB14', 'script', NULL),
(752, 'error_titles_ARRAY_ABB01', 'arrays', 'error_titles_ARRAY_ABB01', 'script', NULL),
(753, 'error_titles_ARRAY_ABB03', 'arrays', 'error_titles_ARRAY_ABB03', 'script', NULL),
(754, 'error_titles_ARRAY_ABB04', 'arrays', 'error_titles_ARRAY_ABB04', 'script', NULL),
(755, 'error_titles_ARRAY_ABB08', 'arrays', 'error_titles_ARRAY_ABB08', 'script', NULL),
(756, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(757, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(758, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(759, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(760, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(761, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(762, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(763, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
(764, 'error_titles_ARRAY_AF01', 'arrays', 'error_titles_ARRAY_AF01', 'script', NULL),
(765, 'error_titles_ARRAY_AF03', 'arrays', 'error_titles_ARRAY_AF03', 'script', NULL),
(766, 'error_titles_ARRAY_AF04', 'arrays', 'error_titles_ARRAY_AF04', 'script', NULL),
(767, 'error_titles_ARRAY_AF05', 'arrays', 'error_titles_ARRAY_AF05', 'script', NULL),
(768, 'error_titles_ARRAY_AF06', 'arrays', 'error_titles_ARRAY_AF06', 'script', NULL),
(769, 'error_titles_ARRAY_AF08', 'arrays', 'error_titles_ARRAY_AF08', 'script', NULL),
(770, 'error_titles_ARRAY_AF09', 'arrays', 'error_titles_ARRAY_AF09', 'script', NULL),
(771, 'error_titles_ARRAY_AF10', 'arrays', 'error_titles_ARRAY_AF10', 'script', NULL),
(772, 'error_titles_ARRAY_AF11', 'arrays', 'error_titles_ARRAY_AF11', 'script', NULL),
(773, 'error_titles_ARRAY_AL01', 'arrays', 'error_titles_ARRAY_AL01', 'script', NULL),
(774, 'error_titles_ARRAY_AL03', 'arrays', 'error_titles_ARRAY_AL03', 'script', NULL),
(775, 'error_titles_ARRAY_AL04', 'arrays', 'error_titles_ARRAY_AL04', 'script', NULL),
(776, 'error_titles_ARRAY_AL08', 'arrays', 'error_titles_ARRAY_AL08', 'script', NULL),
(777, 'error_titles_ARRAY_AL09', 'arrays', 'error_titles_ARRAY_AL09', 'script', NULL),
(778, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(779, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(780, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(781, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(782, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(783, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(784, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(785, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(786, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(787, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(788, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(789, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(790, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(791, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(792, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(793, 'forgot_err_ARRAY_100', 'arrays', 'login_err_ARRAY_100', 'script', NULL),
(794, 'forgot_err_ARRAY_101', 'arrays', 'forgot_err_ARRAY_101', 'script', NULL),
(795, 'forgot_err_ARRAY_102', 'arrays', 'forgot_err_ARRAY_102', 'script', NULL),
(796, 'forgot_err_ARRAY_200', 'arrays', 'forgot_err_ARRAY_200', 'script', NULL),
(797, 'front_messages_ARRAY_0', 'arrays', 'front_messages_ARRAY_0', 'script', NULL),
(798, 'front_messages_ARRAY_1', 'arrays', 'front_messages_ARRAY_1', 'script', NULL),
(799, 'front_messages_ARRAY_2', 'arrays', 'front_messages_ARRAY_2', 'script', NULL),
(800, 'front_messages_ARRAY_3', 'arrays', 'front_messages_ARRAY_3', 'script', NULL),
(801, 'front_messages_ARRAY_4', 'arrays', 'front_messages_ARRAY_4', 'script', NULL),
(802, 'front_messages_ARRAY_5', 'arrays', 'front_messages_ARRAY_5', 'script', NULL),
(803, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(804, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(805, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(806, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(807, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(808, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(809, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(810, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(811, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(812, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(813, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(814, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(815, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(816, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(817, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(818, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(819, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(820, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(821, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(822, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(823, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(824, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(825, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(826, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(827, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(828, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(829, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(830, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(831, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(832, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(833, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(834, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(835, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(836, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(837, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(838, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(839, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(840, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(841, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(842, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(843, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(844, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(845, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(846, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(847, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(848, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(849, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(850, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(851, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(852, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(853, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(854, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(855, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(856, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(857, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(858, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(859, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(860, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(861, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(862, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(863, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(864, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(865, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(866, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(867, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(868, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(869, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(870, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(871, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(872, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(873, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(874, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(875, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(876, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(877, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(878, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(879, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(880, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(881, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(882, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(883, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(884, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(885, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(886, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(887, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(888, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(889, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(890, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(891, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(892, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(893, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(894, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(895, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(896, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(897, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(898, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(899, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(900, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(901, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL);

INSERT INTO `taxi_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '+ Add client', 'script'),
(NULL, 7, 'pjField', 1, 'title', '+ Add enquiry', 'script'),
(NULL, 8, 'pjField', 1, 'title', '+ Add extra', 'script'),
(NULL, 9, 'pjField', 1, 'title', '+ Add reason', 'script'),
(NULL, 10, 'pjField', 1, 'title', '+ Add transfer', 'script'),
(NULL, 11, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 12, 'pjField', 1, 'title', '+ Add vehicle', 'script'),
(NULL, 13, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Edit', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Generate', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Add enquiry', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'today''s enquiries ', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'enquiry received today', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Latest enquiries', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Reservations today', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'No enquiries found.', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Open frontend', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Quick links', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'reservation', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'today''s reservations', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'reservation today', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Reservations today', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'total reservations', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'View enquiries', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Email address was already in use.', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 63, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Add a new enquiry (booking) using the form below.', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Add enquiry', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Fill in the form below and click "Save" to add a new client.', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Add client', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Fill in the form below and click "save" to add new extra.', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Add extra', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Fill the form to add a new vehicle to the system. Vehicles are important because they correspond with your services.', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'New vehicle', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Create new transfer by specifying a pick-up location and at least one drop-off below. ', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'New transfer', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Please enter the reason name and "save" to add new reason for hire.', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Add reason for hire', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Fill in the form below and "save" to add a new user.', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Use the drop-downs to set value for each of the fields below. Select ''Yes'' or ''No'' if you want a field to be displayed or not, and ''Yes (Required)'', if you''d like that field to be mandatory.', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Checkout form', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'On the form below, you can make any change on the content to be sent to client for cancelling enquiry.', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Cancellation email', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Below is a list of all clients. You can edit a specific client by clicking on the pencil icon in the corresponding entry.', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'List of clients', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'There are three types of auto-responder messages you can send to both clients and admins. The first one will be triggered after a new enquiry is submitted via the software. The second one will be sent to confirm a successful payment and the third one - after a service has been canceled. You may enable or disable all auto-responders separately as well as personalize the message using the tokens below. <br/><br/><div class="float_left w200">{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}</div><div class="float_left w250">{DateTime}<br/>{From}<br/>{To}<br/>{Vehicle}<br/>{Distance}<br/>{Passengers}<br/>{Luggage}<br/>{Extras}<br/>{UniqueID}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/>{Deposit}</div><div class="float_left w250">{Airline}<br/>{FlightNumber}<br/>{ArrivalTime}<br/>{Terminal}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}</div>', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'There are three types of auto-responder messages you can send to both clients and admins. The first one will be triggered after a new enquiry is submitted via the software. The second one will be sent to confirm a successful payment and the third one - after a service has been canceled. You may enable or disable all auto-responders separately as well as personalize the message using the tokens below. <br/><br/><div class="float_left w200">{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}</div><div class="float_left w250">{DateTime}<br/>{From}<br/>{To}<br/>{Vehicle}<br/>{Distance}<br/>{Passengers}<br/>{Luggage}<br/>{Extras}<br/>{UniqueID}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/>{Deposit}</div><div class="float_left w250">{Airline}<br/>{FlightNumber}<br/>{ArrivalTime}<br/>{Terminal}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}</div>', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Below is a list of all extras. If you want to add a new one, click on the "+ Add extra" button.', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Below is a list of all vehicles you have added to the system. All active vehicles can be booked on the front-end. To edit vehicle details, click on the pencil icon in the corresponding row. To add a new one,  click on the  "+ Add vehicle" button.', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'List of vehicles', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'The general report summarizes your data using criteria such as pick-up location and vehicles. The report shows you the total number of enquiries, passengers served, luggage carried, traveling distance, amount collected via the system, as well as create comparison between the one-way and the round-trip bookings during the selected period of time.', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Generate report', 'script'),
(NULL, 94, 'pjField', 1, 'title', '', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Below is a list of all point-to-point transfers you have added to the system. All transfers must have a pick-up location (which you see below) and at least on drop-off. To edit the predefined transfer details, click the pencil icon corresponding to the row. To add new transfer, go to the above tab “Add new”.', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'List of transfers', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'In this form, you can select a specific location to generate the report. You will find in the report all of enquiries that will be transferred within the date range for selected pick-up location.', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Pick-up Location Report', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'There are multiple color schemes available for the frontend layout. Click on each of the thumbnails below to preview it. Click on "Use this theme" to apply the theme. Then scroll down and grab the Install code and put it on your web page.', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Preview frontend and install on your site', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Use the predefined reasons for hire or add your own. If you want to add a new reason, click on the "+ Add reason" button.', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'List of reasons for hire', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'On the form below, you can make any change on the content to be sent to client for confirming the reservation.', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Re-send confirmation', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Customize your vehicle transfer enquiry system by configuring the options below. You can enable/disable payments, specify a percentage of security deposit and taxes, and more.', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'This is a list of all customer enquiries made through the vehicle booking system. You can filter enquiries by status, reorder, search by multiple criteria, export, and print the list. To see a specific enquiry and client details, click the pencil icon in the corresponding row. To add a new enquiry manually, click on the "+ Add enquiry" button.', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'List of enquiries', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Enquiry options', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'On the form below, you can make any change on the content message that will be sent to client for confirming the reservation.', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Send SMS notification', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Copy and paste your booking terms in the field below. You can translate them and add the respective text for each language you have enabled on your website. Clients will not be able to complete their reservation if they haven’t read and accepted your terms and conditions.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Add your booking terms', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'See enqiry and client details below.', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Enquiry details', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to edit client information.', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Update client', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'You can make any changes on the form below. When ready, click "Save" to update the Extra information.', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Update extra', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'You can edit all vehicle details for all languages you have activated on your website. Just make sure you have switched the language using the flag buttons before you update the information.', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Edit vehicle', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'You can make changes to the fields below for all languages you have added to the system. Make sure you have switched the languages (if any) using the flag system, before you edit the information. Please note that, all transfers must have a pick-up location with exact address but can have multiple drop-offs.', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Edit transfer', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Set transfer fees using the table below.', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Prices', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Please change the reason name and "save" to update it.', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Update reason', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update user information.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Below is a list of all users. You can add new users, edit user details and change user status. ', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'You can select which vehicle to view report. In this report, you will find all of enquiries that will be transferred within the date range for selected vehicle.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Limo Report', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Add client', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Add new', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Additional info', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Add new', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Add new', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Arrival flight number', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Airline company', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Cruise ship', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Complete destination address', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Enquiry details', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Flight number', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Flight arriving from / departure to', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Enquiry ID', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Terminal / Gate', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Cancelled Enquiries', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'CC Type', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Choose color theme', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Confirmed Enquiries', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Copy Drop-off Locations', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'or copy from another location', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Count', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Created on', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Customer', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'view all', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Date & Time', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Date from', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Date & time', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Date to', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Are you sure that you want to delete the image?', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Delete drop-off location', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Theer are enquiries made for this drop-off. Are you sure that you want to delete it?', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Departure airline company', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Departure flight number', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Destination', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Destinations Trips (confirmed reservations only)', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Distance', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Drop-off', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Drop-off address', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Drop-off location', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Unique ID was already used.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Edit drop-off', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Enquiry details', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Existing client', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Extra name', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Fee per person', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Vehicle', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Flight arrival time', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Flight departure time', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Flight time', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'From (km)', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'From pick-up location', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'From / To', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Reports', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'General Enquiries Report', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'here', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'included', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Extras included in price', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Installation configuration', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Hide language selector ', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Select language', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'To embed the software into a web page, please follow the steps below. Set the language configuration first, then copy the integration code and paste into your HTML page, whenever you want the software to appear.', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Installation', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Km', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Last enquiry', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'latest enquiries', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Round trip', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Location', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Luggage', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Luggage Carried', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Manage vehicle', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'maximum', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Number cannot be greater than maximum value.', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Minutes', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'New client', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'new enquiries today', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'new reservation today', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'One way', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'One-way', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'One-way vs Round-trip (confirmed reservations only)', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Administrators', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'hour(s)', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Passenger', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Passengers', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Passengers per reservation (confirmed reservations only)', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Passengers Served', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'per person', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Pickup', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Pick-up address', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Pickup date', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Pickup / Dropoff', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Pick-up and drop-off location', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Pick-up location', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Pick-up Location Report', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Enter a positive number.', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Price per km', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Price per person', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Prices', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Prices have been saved.', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Prices could not be saved.', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Please wait while prices are saved.', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Print Enquiry', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Reason for hire', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Reason name', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Report by Pick-up Location', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Vehicle Report', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Re-send confirmation', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Print Enquiry', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Enquiries Print List', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Not found', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'enquiries today', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Return', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Return date & time', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Returning on', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Return trip', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'roundtrip', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Round-trip', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Send SMS notification', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Service', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Services', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Set prices', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Single', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'SMS message', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Start fee', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Locations have been saved.', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Locations could not be saved.', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Please wait while locations are saved.', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Subtotal', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Thumb', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'To collect', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Today Transfers', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'To drop-off location', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'To must be greater than From', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'To (km)', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Total Amount', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Total enquiries', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Total Enquiries', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Transfer date', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Transfer Date & Time', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Transfer Destinations', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'today''s transfers', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Transfer Today', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Unique ID', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Update client', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Edit vehicle', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Edit transfer', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Edit ', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Vehicle', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Vehicle Report', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Vehicle Used', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'via', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Vehicles', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Transfers', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'News', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Reports', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Checkout form', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Select a language by clicking on the corresponding flag and update existing translation.', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Select ''Yes'' if you want to receive email notifications every time a client cancels his booking.', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Available Tokens:<br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Password}<br/>{Phone}', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Select "Yes" if you want the system to send automatic emails to administrator after new client accounts created.', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Select ''Yes'' if you want the system to send you email every time a new enquiry is submitted. ', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Select ''Yes'' if you want to receive email notifications every time a new payment has been made.', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'SMS notification upon new enquiry', 'script'),
(NULL, 412, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{DateTime}<br/>{From}<br/>{To}<br/>{Vehicle}<br/>{Passengers}<br/>{UniqueID}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/>{Deposit}<br/>', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'SMS notification upon new payment.', 'script'),
(NULL, 414, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{DateTime}<br/>{From}<br/>{To}<br/>{Vehicle}<br/>{Passengers}<br/>{UniqueID}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/>{Deposit}<br/>', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Allow payments with Authorize.Net ', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Allow cash payments', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing ', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Allow payments with PayPal ', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Authorize.Net MD5 hash ', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Authorize.Net merchant ID', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Authorize.Net time zone', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Authorize.Net transaction key ', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Airline', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Cruise ship', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Complete destination address', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Flight number', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Arrival time', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Terminal / Gate', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Terminal / Gate', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'New enquiry status if not paid ', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'Message body', 'script'),
(NULL, 451, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DateTime}<br/>{From}<br/>{To}<br/>{Vehicle}<br/>{Passengers}<br/>{UniqueID}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/>{Deposit}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Select ''Yes'' if you want the system to send automatic email to the client after a service has been canceled. ', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'New client account email', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Message body', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Available Tokens:<br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Password}<br/>{Phone}', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Select "Yes" if you want the system to send automatic emails to clients after client accounts are created', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'New enquiry is received', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Message body', 'script'),
(NULL, 461, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DateTime}<br/>{From}<br/>{To}<br/>{Vehicle}<br/>{Passengers}<br/>{UniqueID}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/>{Deposit}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Select ''Yes'' if you want an auto-responder to be sent to clients after submiting new enquiry.', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Password recovery email message', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Available Tokens:<br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Password}<br/>{Phone}', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Password recovery email subject', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Payment confirmation email', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Message body', 'script'),
(NULL, 469, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DateTime}<br/>{From}<br/>{To}<br/>{Vehicle}<br/>{Passengers}<br/>{UniqueID}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/>{Deposit}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Select ''Yes'' if you want a confirmation email to be sent to clients after successful payment is made.', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Google API key', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Accept enquiries X hours earlier', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Mileage', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Select ''Yes'' if you want to disable payments.', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'New enquiry status if paid', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'PayPal business email address ', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'SMS notifications', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'You can also send personalized SMS notifications via the each enquiry page. Available Tokens:<br/><br/>{FirstName}<br/>{LastName}<br/>{DateTime}<br/>{From}<br/>{To}<br/>{Vehicle}<br/>{Passengers}', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Terms and conditions', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.Net payment ', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Number of vehicles shown per page on the front-end.', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Please enter only digits', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Email address is already taken.', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Please enter a valid number.', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Reasons for hire', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'I have read and accept your', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Airline', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Arrival airline company', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'All inclusive for only', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'You already logged in.', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Arrival time', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Bags', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Enquiry created', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Enquiry Details', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Enquiry ID', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Book a taxi', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Cancel enquiry', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Log in', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'Reserve', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'Star over', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'CC Number', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'CC Type', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Change', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Enquiry Details', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'Choose Airport Transfer', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Choose extras', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Choose provider & service', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Cruise ship', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Date and time', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Departure', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Departure airline company', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Departure flight number', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Deposit required', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Destination', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Complete destination address', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Please enter only digits.', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Distance', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Drop-off address', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Drop-off location', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Email does not exist.', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Existing client', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Expiration month is required.', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Expiration year is required.', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Extra price', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Flight departure time', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Flight Details', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'If you choose airport transfer service, please enter your flight details below.', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Arrival flight number', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Flight arrival time', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Select pick-up', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Your enquiry can be accepted with {HOURS} hour(s) earlier.', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Date time for accepted enquiries', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'included', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Password is not correct.', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'The return date time cannot be less than pick-up date time.', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Invalid email', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'km', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'If you have an account, click {STAG}here{ETAG} to log in.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'You already logged in, click {STAG}here{ETAG} to logout.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'miles', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'minutes', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'New client', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'There are no vehicles found.', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Please enter a valid number.', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Returning on', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'One way', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Passenger', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Passengers', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'The password has been sent to your email address.', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'People', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Personal Details', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'per person', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Pick-up address', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Pick-up and drop-off location', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Pieces of luggage', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Piece of luggage', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Choose Airport Transfer', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Confirmation', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Reason for hire', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Return', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Returning on', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Ride', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Round trip', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Get a quote', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Search again', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Select Vehicle', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'Service', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Single', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Single ride', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Start fee', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Subtotal', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'on {DATE} at {TIME} for {PASSENGERS} passenger(s) travelling with {LUGGAGES} piece(s) of luggage', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'on {DATE} at {TIME} for {PASSENGERS} passenger(s)', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Taxi service from', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Terminal / Gate', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Terms and conditions.', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Terms and conditions', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Select drop-off', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'total price', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'to', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Transfer Reservation', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Paypal Transaction ID', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'With', 'script'),
(NULL, 635, 'pjField', 1, 'title', '{PASSENGERS} Passenger(s); {LUGGAGE} Piece(s) of luggage', 'script'),
(NULL, 636, 'pjField', 1, 'title', '{PASSENGERS} Passenger(s)', 'script'),
(NULL, 637, 'pjField', 1, 'title', ' Your account is disabled.', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'Your Enquiry', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Transfer', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'Copy', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'Set', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Reservation with such ID does not exist.', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Reservation has been cancelled successfully.', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Your reservation was already cancelled.', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'American Express', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'New client account email', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'New enquiry is received', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Password recovery email', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Payment confirmation email', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'Reservation confirmation has been sent successfully to the client.', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'We are sorry that the confirmation email could not be sent successfully.', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'SMS has been sent to client.', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'We are sorry that the SMS could not be sent to client successfully.', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Cancellation email has been sent successfully to the client.', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'We are sorry that the cancellation email could not be sent!', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'All changes made to the enquiry have been saved.', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'New enquiry has been added to the list.', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'We are sorry that the enquiry could not bee added successfully.', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'We are sorry that the enquiry you are looking is missing.', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'We are sorry, but the client has not been added.', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Client your looking for is missing.', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'All changes made to the extra have been saved.', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'New extra has been added into the list.', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'We are sorry that new extra could not bee added successfully.', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'We are sorry that the extra you are looking for is missing.', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'All changes made to the vehicle have been saved successfully.', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'A new vehicle has been added to the list.', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'We are sorry that the new vehicle has not been added successfully.', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'New vehicle could not be added because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'The vehicle could not be updated because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'We are sorry that the vehicle you are looking for is missing.', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'New vehicle has been added, but uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'Uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'The uploaded file actually is not a image file. Please upload another image.', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'All changes you made to the location have been saved.', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'Transfer has been added successfully. Please add transfer fees by visiting the Prices tab under the corresponding Transfer page.', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Entry wasn''t saved. Please try again!', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'We are sorry that location you are looking is missing.', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'All changes made to the prices have been saved successfully.', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'All changes made to the options page have been saved.', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'All changes made have been saved successfully.', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'All changes made to the reservation form settings have been saved successfully.', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'All changes made to the notifications have been saved.', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'All changes to the Terms have been saved.', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'All changes made to the reason have been saved.', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'New reason has been added into the list.', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'We are sorry that new reason could not bee added successfully.', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'We are sorry that the reason you are looking for is missing.', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'Confirmation sent', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'Confirmation not sent', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'SMS sent', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'SMS not sent', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'Cancellation email sent!', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'Cancellation email not sent!', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'Enquiry updated', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'Enquiry added', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'Enqiry failed to add', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'Enquiry not found', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'Client updated!', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'Client added!', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'Client failed to add.', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'Client not found.', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'Extra updated', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'Extra added', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'Extra failed to add', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Extra not found', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'Vehicle updated', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Vehicle added', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'Vehicle failed to add', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'Vehicle not found', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'Wrong file type', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'Changes have been saved.', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'New transfer was added.', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'Error!', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'Location not found', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'Prices updated', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'Options saved.', 'script'),
(NULL, 779, 'pjField', 1, 'title', 'Enquiry options have been changed.', 'script'),
(NULL, 780, 'pjField', 1, 'title', 'Reservation form settings updated', 'script'),
(NULL, 781, 'pjField', 1, 'title', 'Notifications updated', 'script'),
(NULL, 782, 'pjField', 1, 'title', 'Changes saved.', 'script'),
(NULL, 783, 'pjField', 1, 'title', 'Reason updated', 'script'),
(NULL, 784, 'pjField', 1, 'title', 'Reason added', 'script'),
(NULL, 785, 'pjField', 1, 'title', 'Reason failed to add', 'script'),
(NULL, 786, 'pjField', 1, 'title', 'Reason not found', 'script'),
(NULL, 787, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 788, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 789, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 790, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 791, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 792, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 793, 'pjField', 1, 'title', 'Email does not exist in the system.', 'script'),
(NULL, 794, 'pjField', 1, 'title', 'Your account is disabled.', 'script'),
(NULL, 795, 'pjField', 1, 'title', 'Missing parameters.', 'script'),
(NULL, 796, 'pjField', 1, 'title', 'The password was already sent to your mail box.', 'script'),
(NULL, 797, 'pjField', 1, 'title', 'Your enquiry is being processed...', 'script'),
(NULL, 798, 'pjField', 1, 'title', 'Your enquiry is saved. Redirecting to PayPal...', 'script'),
(NULL, 799, 'pjField', 1, 'title', 'Your reservation is saved. Redirecting to Authorize.Net...', 'script'),
(NULL, 800, 'pjField', 1, 'title', 'Your enquiry is saved. Redirecting to Authorize.Net...', 'script'),
(NULL, 801, 'pjField', 1, 'title', 'Your enquiry has been sent successfully!', 'script'),
(NULL, 802, 'pjField', 1, 'title', 'Your enquiry failed to save.', 'script'),
(NULL, 803, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 804, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 805, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 806, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 807, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 808, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 809, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 810, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 811, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 812, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 813, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 814, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 815, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 816, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 817, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 818, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 819, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 820, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 821, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 822, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 823, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 824, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 825, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 826, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 827, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 828, 'pjField', 1, 'title', 'Authorize.Net', 'script'),
(NULL, 829, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 830, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 831, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 837, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 838, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 839, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 840, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 841, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 842, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 843, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 844, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 845, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 846, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 847, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 848, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 849, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 850, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 851, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 852, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 853, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 854, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 855, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 856, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 857, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 858, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 859, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 860, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 861, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 862, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 863, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 864, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 865, 'pjField', 1, 'title', 'No property for the enquiry found', 'script'),
(NULL, 866, 'pjField', 1, 'title', 'No enquiry  found', 'script'),
(NULL, 867, 'pjField', 1, 'title', 'No permisions to edit the enquiry.', 'script'),
(NULL, 868, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 869, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 870, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 871, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 872, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 873, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 874, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 875, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 876, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 877, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 878, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 879, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 880, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 881, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 882, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 883, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 884, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 885, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 886, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 887, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 888, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 889, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 890, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 891, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 892, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 893, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 894, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 895, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 896, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 897, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 898, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 899, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 900, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 901, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1, 'pjOption', 1, 'o_email_forgot_subject', 'Password recovery', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_forgot_message', 'Hi {FirstName},<br/><br/>Password: {Password}<br/><br/>Thanks!', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_client_account_subject', 'Client account', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_client_account_message', 'You have just made an enquiry and a new account is also created for you. Here is the details information:<br/><br/>First name: {FirstName}<br/>Last name: {LastName}<br/>Email: {Email}<br/>Password: {Password}<br/>Phone: {Phone}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ante leo, ultricies quis gravida id, vestibulum nec risus. Mauris adipiscing vestibulum nibh non ullamcorper. Suspendisse justo turpis, mattis a cursus ac, vulputate quis metus. Fusce vestibulum faucibus dignissim. Aliquam fermentum mauris felis, a ultrices sem.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', 'Your enquiry has been received.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', 'Your enquiry has been received. Details are below:<br/><br/>Personal details:<br/>Title: {Title}<br/>First Name: {FirstName}<br/>Last Name: {LastName}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Notes: {Notes}<br/>Country: {Country}<br/>City: {City}<br/>State: {State}<br/>Zip: {Zip}<br/>Address: {Address}<br/>Company: {Company}<br/><br/>Reservation details:<br/>Date time: {DateTime}<br/>From: {From}<br/>To: {To}<br/>Vehicle: {Vehicle}<br/>Passengers: {Passengers}<br/>Unique ID: {UniqueID}<br/>Total: {Total}<br/><br/>If you want to cancel your reservation follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', 'Payment has been received.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', 'Payment has been received.<br/><br/>Personal details:<br/>Title: {Title}<br/>First Name: {FirstName}<br/>Last Name: {LastName}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Notes: {Notes}<br/>Country: {Country}<br/>City: {City}<br/>State: {State}<br/>Zip: {Zip}<br/>Address: {Address}<br/>Company: {Company}<br/><br/>Reservation details:<br/>Date time: {DateTime}<br/>From: {From}<br/>To: {To}<br/>Vehicle: {Vehicle}<br/>Passengers: {Passengers}<br/>Unique ID: {UniqueID}<br/>Total: {Total}<br/><br/>If you want to cancel your reservation follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', 'Service has been canceled.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_client_account_subject', 'Client account created', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', 'You''ve just cancelled the service.<br/><br/>Personal details:<br/>Title: {Title}<br/>First Name: {FirstName}<br/>Last Name: {LastName}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Notes: {Notes}<br/>Country: {Country}<br/>City: {City}<br/>State: {State}<br/>Zip: {Zip}<br/>Address: {Address}<br/>Company: {Company}<br/><br/>Reservation details:<br/>Date time: {DateTime}<br/>From: {From}<br/>To: {To}<br/>Vehicle: {Vehicle}<br/>Passengers: {Passengers}<br/>Unique ID: {UniqueID}<br/>Total: {Total}<br/><br/>If you want to cancel your reservation follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_client_account_message', 'A new client account has been created:<br/><br/>First name: {FirstName}<br/>Last name: {LastName}<br/>Email: {Email}<br/>Password: {Password}<br/>Phone: {Phone}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', 'New enquiry has been received.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', 'New enquiry has been received:<br/><br/>Personal details:<br/>Title: {Title}<br/>First Name: {FirstName}<br/>Last Name: {LastName}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Notes: {Notes}<br/>Country: {Country}<br/>City: {City}<br/>State: {State}<br/>Zip: {Zip}<br/>Address: {Address}<br/>Company: {Company}<br/><br/>Reservation details:<br/>Date time: {DateTime}<br/>From: {From}<br/>To: {To}<br/>Vehicle: {Vehicle}<br/>Passengers: {Passengers}<br/>Unique ID: {UniqueID}<br/>Total: {Total}<br/><br/>If you want to cancel your reservation follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', 'New payment has been made.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', 'New payment has been made:<br/><br/>Personal details:<br/>Title: {Title}<br/>First Name: {FirstName}<br/>Last Name: {LastName}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Notes: {Notes}<br/>Country: {Country}<br/>City: {City}<br/>State: {State}<br/>Zip: {Zip}<br/>Address: {Address}<br/>Company: {Company}<br/><br/>Reservation details:<br/>Date time: {DateTime}<br/>From: {From}<br/>To: {To}<br/>Vehicle: {Vehicle}<br/>Passengers: {Passengers}<br/>Unique ID: {UniqueID}<br/>Total: {Total}<br/><br/>If you want to cancel your reservation follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', 'Service has been canceled.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', 'The following service has been canceled:<br/><br/>Personal details:<br/>Title: {Title}<br/>First Name: {FirstName}<br/>Last Name: {LastName}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Notes: {Notes}<br/>Country: {Country}<br/>City: {City}<br/>State: {State}<br/>Zip: {Zip}<br/>Address: {Address}<br/>Company: {Company}<br/><br/>Reservation details:<br/>Date time: {DateTime}<br/>From: {From}<br/>To: {To}<br/>Vehicle: {Vehicle}<br/>Passengers: {Passengers}<br/>Unique ID: {UniqueID}<br/>Total: {Total}<br/><br/>If you want to cancel your reservation follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_payment_message', NULL, 'data');

INSERT INTO `taxi_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 4, 1, NULL),
(1, 'o_mileage', 1, 'miles|km::km', 'Miles|Km', 'enum', 5, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),
(1, 'o_google_api_key', 1, NULL, NULL, 'string', 14, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_deposit_payment', 2, '10.00', NULL, 'int', 2, 1, NULL),
(1, 'o_tax_payment', 2, '10.00', NULL, 'int', 4, 1, NULL),
(1, 'o_hour_earlier', 2, '2', NULL, 'int', 5, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 7, 1, NULL),
(1, 'o_thankyou_page', 2, 'http://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_vehicle_per_page', 2, '5', NULL, 'int', 9, 0, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 11, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 12, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 13, 1, NULL),
(1, 'o_authorize_transkey', 2, NULL, NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_merchant_id', 2, NULL, NULL, 'string', 15, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 16, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 17, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 19, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::Yes', NULL, 'enum', 20, 1, NULL),
(1, 'o_bank_account', 2, '', NULL, 'text', 21, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_admin_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_sms_confirmation_message', 3, '', NULL, 'text', 2, 1, NULL),
(1, 'o_admin_sms_confirmation_message', 3, '', NULL, 'text', 2, 1, NULL),
(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
(1, 'o_admin_sms_payment_message', 3, '', NULL, 'text', 4, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
(1, 'o_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 5, 1, NULL),
(1, 'o_admin_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 5, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
(1, 'o_admin_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
(1, 'o_admin_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
(1, 'o_email_cancel', 3, '0|1::1', 'No|Yes', 'enum', 8, 1, NULL),
(1, 'o_admin_email_cancel', 3, '0|1::1', 'No|Yes', 'enum', 8, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 12, 1, NULL),
(1, 'o_admin_email_cancel_subject', 3, '', NULL, 'string', 12, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 13, 1, NULL),
(1, 'o_admin_email_cancel_message', 3, '', NULL, 'text', 13, 1, NULL),
(1, 'o_email_client_account', 3, '0|1::1', 'No|Yes', 'enum', 14, 1, NULL),
(1, 'o_admin_email_client_account', 3, '0|1::1', 'No|Yes', 'enum', 14, 1, NULL),
(1, 'o_email_client_account_subject', 3, '', NULL, 'string', 15, 1, NULL),
(1, 'o_admin_email_client_account_subject', 3, '', NULL, 'string', 15, 1, NULL),
(1, 'o_email_client_account_message', 3, '', NULL, 'text', 16, 1, NULL),
(1, 'o_admin_email_client_account_message', 3, '', NULL, 'text', 16, 1, NULL),
(1, 'o_email_forgot_subject', 3, 'Password recovery', NULL, 'string', 17, 1, NULL),
(1, 'o_email_forgot_message', 3, 'Hi {FirstName},\r\n\r\nHere is your password: {Password}\r\n\r\nThanks!', NULL, 'text', 18, 1, NULL),

(1, 'o_bf_include_title', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_fname', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_lname', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_email', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_company', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_address', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_notes', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_promo', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 0, NULL),
(1, 'o_bf_include_city', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_state', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_zip', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 12, 1, NULL),
(1, 'o_bf_include_country', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 13, 1, NULL),
(1, 'o_bf_include_airline_company', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 14, 1, NULL),
(1, 'o_bf_include_flight_number', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 15, 1, NULL),
(1, 'o_bf_include_flight_time', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 16, 1, NULL),
(1, 'o_bf_include_terminal', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 18, 1, NULL),
(1, 'o_bf_include_captcha', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 19, 1, NULL),

(1, 'o_terms', 5, '', NULL, 'text', 1, 1, NULL),

(1, 'o_theme', 99, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', NULL, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, '76e46b610cc307af7953461769a1c183', NULL, 'string', NULL, 0, NULL);

INSERT INTO `taxi_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');