BEGIN;

DROP TABLE IF EXISTS `petlisting_extras`;
CREATE TABLE IF NOT EXISTS `petlisting_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `petlisting_extras` (`id`, `status`) VALUES
(1, 'T'),
(2, 'T'),
(3, 'T'),
(4, 'T'),
(5, 'T'),
(6, 'T'),
(7, 'T');

DROP TABLE IF EXISTS `petlisting_features`;
CREATE TABLE IF NOT EXISTS `petlisting_features` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('age','color','sex','size') NOT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `petlisting_features` (`id`, `type`, `status`) VALUES
(1, 'sex', 'T'),
(2, 'sex', 'T'),
(3, 'age', 'T'),
(4, 'age', 'T'),
(5, 'age', 'T'),
(6, 'age', 'T'),
(7, 'size', 'T'),
(8, 'size', 'T'),
(9, 'size', 'T'),
(10, 'color', 'T'),
(11, 'color', 'T'),
(12, 'color', 'T'),
(13, 'color', 'T'),
(14, 'color', 'T'),
(15, 'color', 'T'),
(16, 'color', 'T'),
(17, 'color', 'T'),
(18, 'color', 'T'),
(19, 'color', 'T'),
(20, 'color', 'T'),
(21, 'color', 'T'),
(22, 'color', 'T'),
(23, 'color', 'T');

DROP TABLE IF EXISTS `petlisting_listings`;
CREATE TABLE IF NOT EXISTS `petlisting_listings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` int(10) unsigned NOT NULL,
  `breed_id` int(10) unsigned NOT NULL,
  `feature_age_id` int(10) unsigned DEFAULT NULL,
  `feature_size_id` int(10) unsigned DEFAULT NULL,
  `feature_sex_id` int(10) unsigned DEFAULT NULL,
  `feature_color_id` int(10) unsigned DEFAULT NULL,
  `listing_refid` varchar(255) DEFAULT NULL,
  `listing_price` decimal(15,2) unsigned DEFAULT NULL,
  `listing_year` year(4) DEFAULT NULL,
  `contact_email` varchar(255) DEFAULT NULL,
  `contact_phone` varchar(255) DEFAULT NULL,
  `contact_fax` varchar(255) DEFAULT NULL,
  `contact_url` varchar(255) DEFAULT NULL,
  `personal_title` enum('mr','mrs','miss','ms','dr','prof','rev','other') DEFAULT NULL,
  `personal_name` varchar(255) DEFAULT NULL,
  `address_content` varchar(255) DEFAULT NULL,
  `address_city` varchar(255) DEFAULT NULL,
  `address_state` varchar(255) DEFAULT NULL,
  `address_postcode` varchar(255) DEFAULT NULL,
  `address_country` int(10) unsigned DEFAULT NULL,
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `modified` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'F',
  PRIMARY KEY (`id`),
  KEY `type_id` (`type_id`),
  KEY `breed_id` (`breed_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `petlisting_listings_extras`;
CREATE TABLE IF NOT EXISTS `petlisting_listings_extras` (
  `listing_id` int(10) unsigned NOT NULL,
  `extra_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`listing_id`,`extra_id`),
  KEY `listing_id` (`listing_id`),
  KEY `extra_id` (`extra_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `petlisting_types`;
CREATE TABLE IF NOT EXISTS `petlisting_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `petlisting_types` (`id`, `status`) VALUES
(1, 'T'),
(2, 'T'),
(3, 'T'),
(4, 'T'),
(5, 'T'),
(6, 'T');

DROP TABLE IF EXISTS `petlisting_breeds`;
CREATE TABLE IF NOT EXISTS `petlisting_breeds` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` int(10) unsigned NOT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `type_id` (`type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `petlisting_breeds` (`id`, `type_id`, `status`) VALUES
(1, 1, 'T'),
(2, 1, 'T'),
(3, 1, 'T'),
(4, 1, 'T'),
(5, 1, 'T'),
(6, 1, 'T'),
(7, 1, 'T'),
(8, 1, 'T'),
(9, 1, 'T'),
(10, 1, 'T'),
(11, 1, 'T'),
(12, 1, 'T'),
(13, 1, 'T'),
(14, 1, 'T'),
(15, 1, 'T'),
(16, 2, 'T'),
(17, 2, 'T'),
(18, 3, 'T'),
(19, 3, 'T'),
(20, 4, 'T'),
(21, 4, 'T'),
(22, 5, 'T'),
(23, 5, 'T'),
(24, 5, 'T'),
(25, 5, 'T'),
(26, 5, 'T'),
(27, 6, 'T'),
(28, 6, 'T'),
(29, 6, 'T'),
(30, 6, 'T'),
(31, 6, 'T');

DROP TABLE IF EXISTS `petlisting_fields`;
CREATE TABLE IF NOT EXISTS `petlisting_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `petlisting_multi_lang`;
CREATE TABLE IF NOT EXISTS `petlisting_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `petlisting_options`;
CREATE TABLE IF NOT EXISTS `petlisting_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `petlisting_roles`;
CREATE TABLE IF NOT EXISTS `petlisting_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `petlisting_users`;
CREATE TABLE IF NOT EXISTS `petlisting_users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) default NULL,
  `password` blob,
  `name` varchar(255) default NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime default NULL,
  `status` enum('T','F') NOT NULL default 'T',
  `is_active` enum('T','F') NOT NULL default 'F',
  `ip` varchar(15) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `petlisting_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(360, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(361, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(480, 'infoUsersTitle', 'backend', 'Infobox / List of users', 'script', NULL),
(481, 'infoUsersDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(482, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(483, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(484, 'gridEmptyBody', 'backend', 'Grid / You need to select at least a single record.', 'script', NULL),
(485, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(486, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(487, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(488, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(489, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(490, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(491, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(492, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(493, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(584, 'menuPets', 'backend', 'Menu / Pets', 'script', NULL),
(585, 'opt_o_per_page', 'backend', 'Options / Items per page', 'script', NULL),
(586, 'role_arr_ARRAY_admin', 'arrays', 'role_arr_ARRAY_admin', 'script', NULL),
(587, 'role_arr_ARRAY_editor', 'arrays', 'role_arr_ARRAY_editor', 'script', NULL),
(678, 'tabInstallListing', 'backend', 'Tab / Listing', 'script', NULL),
(679, 'tabInstallSEO', 'backend', 'Tab / SEO', 'script', NULL),
(680, 'infoInstallTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(681, 'infoInstallDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(682, 'opt_o_listing_page', 'backend', 'Options /  Enter web address for the web page where listing is put', 'script', NULL),
(683, 'lblInstallPhp1_1', 'backend', 'Install / Step 1', 'script', NULL),
(684, 'lblInstallPhp1_2', 'backend', 'Install / Step 2', 'script', NULL),
(685, 'lblInstallPhp1_2a', 'backend', 'Install / Step 2a', 'script', NULL),
(686, 'lblInstallPhp1_3', 'backend', 'Install / Step 3', 'script', NULL),
(687, 'infoInstallSEODESC', 'backend', 'Infobox / Install SEO description', 'script', NULL),
(688, 'opt_o_seo_url', 'backend', 'Options /  Use SEO Friendly URLs', 'script', NULL),
(689, 'lblInstallPhpHtaccess', 'backend', 'Label / Install htaccess', 'script', NULL),
(690, 'lblInstallPhpHtaccess2', 'backend', 'Label / Install htaccess', 'script', NULL),
(691, 'infoThemeTitle', 'backend', 'Infobox / Preview front end', 'script', NULL),
(692, 'infoThemeDesc', 'backend', 'Infobox / Preview front end', 'script', NULL),
(693, 'lblInstallTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(694, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(695, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(696, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(697, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(698, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(699, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(700, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(701, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(702, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(703, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(704, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(705, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(706, 'infoTypesTitle', 'backend', 'Infobox / List of pet types', 'script', NULL),
(707, 'infoTypesDesc', 'backend', 'Infobox / List of pet types', 'script', NULL),
(708, 'btnAddPetType', 'backend', 'Button / + Add pet type', 'script', NULL),
(709, 'lblPetType', 'backend', 'Label / Pet type', 'script', NULL),
(710, 'menuPetTypes', 'backend', 'Menu / Pet types', 'script', NULL),
(711, 'menuPetBreeds', 'backend', 'Menu / Pet breeds', 'script', NULL),
(712, 'menuPetDetails', 'backend', 'Menu / Pet details', 'script', NULL),
(713, 'menuFeatures', 'backend', 'Menu / Features', 'script', NULL),
(714, 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
(715, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(716, 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
(717, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(718, 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
(719, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(720, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(721, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(722, 'infoAddTypeTitle', 'backend', 'Infobox / Add pet type', 'script', NULL),
(723, 'infoAddTypeDesc', 'backend', 'Infobox / Add pet type', 'script', NULL),
(724, 'lblFieldRequired', 'backend', 'Label / This field is required.', 'script', NULL),
(725, 'lblEmailInvalid', 'backend', 'Label / Email is invalid.', 'script', NULL),
(726, 'lblPetTypeUsed', 'backend', 'Label / Pet type name is already used.', 'script', NULL),
(727, 'infoUpdateTypeTitle', 'backend', 'Infobox / Update pet type', 'script', NULL),
(728, 'infoUpdateTypeDesc', 'backend', 'Infobox / Update pet type', 'script', NULL),
(729, 'infoPetBreedsTitle', 'backend', 'Infobox / Pet breeds list', 'script', NULL),
(730, 'infoPetBreedsDesc', 'backend', 'Infobox / Pet breeds list', 'script', NULL),
(731, 'btnAddPetBreed', 'backend', 'Button / + Add pet breed', 'script', NULL),
(732, 'lblBreed', 'backend', 'Label / Breed', 'script', NULL),
(733, 'lblType', 'backend', 'Label / Type', 'script', NULL),
(734, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(735, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(736, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(737, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(738, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(739, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(740, 'error_titles_ARRAY_AB08', 'arrays', 'error_titles_ARRAY_AB08', 'script', NULL),
(741, 'error_bodies_ARRAY_AB08', 'arrays', 'error_bodies_ARRAY_AB08', 'script', NULL),
(742, 'lblPetBreedDuplicated', 'backend', 'Label / Pet breed name was already used.', 'script', NULL),
(743, 'lblPetBreed', 'backend', 'Label / Pet breed', 'script', NULL),
(744, 'infoAddBreedTitle', 'backend', 'Infobox / Add pet breed', 'script', NULL),
(745, 'infoAddBreedDesc', 'backend', 'Infobox / Add pet breed', 'script', NULL),
(746, 'infoUpdateBreedTitle', 'backend', 'Infobox / Update pet breed', 'script', NULL),
(747, 'infoUpdateBreedDesc', 'backend', 'Infobox / Update pet breed', 'script', NULL),
(748, 'infoPetExtrasTitle', 'backend', 'Infobox / Pet details list', 'script', NULL),
(749, 'infoPetExtrasDesc', 'backend', 'Infobox / Pet details list', 'script', NULL),
(750, 'btnAddPetDetail', 'backend', 'Label / + Add pet detail', 'script', NULL),
(751, 'lblPetDetail', 'backend', 'Label / Pet detail', 'script', NULL),
(752, 'lblPetDetailDuplicated', 'backend', 'Label / Pet detail was already used.', 'script', NULL),
(753, 'infoAddPetExtraTitle', 'backend', 'Infobox / Add pet detail', 'script', NULL),
(754, 'infoAddPetExtraDesc', 'backend', 'Infobox / Add pet detail', 'script', NULL),
(755, 'infoUpdatePetExtraTitle', 'backend', 'Infobox / Update pet detail', 'script', NULL),
(756, 'infoUpdatePetExtraDesc', 'backend', 'Infobox / Update pet detail', 'script', NULL),
(757, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(758, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(759, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(760, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(761, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(762, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(763, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
(764, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(765, 'feature_types_ARRAY_age', 'arrays', 'feature_types_ARRAY_age', 'script', NULL),
(766, 'feature_types_ARRAY_color', 'arrays', 'feature_types_ARRAY_color', 'script', NULL),
(767, 'feature_types_ARRAY_sex', 'arrays', 'feature_types_ARRAY_sex', 'script', NULL),
(768, 'feature_types_ARRAY_size', 'arrays', 'feature_types_ARRAY_size', 'script', NULL),
(769, 'error_titles_ARRAY_AF01', 'arrays', 'error_titles_ARRAY_AF01', 'script', NULL),
(770, 'error_bodies_ARRAY_AF01', 'arrays', 'error_bodies_ARRAY_AF01', 'script', NULL),
(771, 'error_titles_ARRAY_AF03', 'arrays', 'error_titles_ARRAY_AF03', 'script', NULL),
(772, 'error_bodies_ARRAY_AF03', 'arrays', 'error_bodies_ARRAY_AF03', 'script', NULL),
(773, 'error_titles_ARRAY_AF04', 'arrays', 'error_titles_ARRAY_AF04', 'script', NULL),
(774, 'error_bodies_ARRAY_AF04', 'arrays', 'error_bodies_ARRAY_AF04', 'script', NULL),
(775, 'error_titles_ARRAY_AF08', 'arrays', 'error_titles_ARRAY_AF08', 'script', NULL),
(776, 'error_bodies_ARRAY_AF08', 'arrays', 'error_bodies_ARRAY_AF08', 'script', NULL),
(777, 'infoFeaturesTitle', 'backend', 'Infobox / Features list', 'script', NULL),
(778, 'infoFeaturesDesc', 'backend', 'Infobox / Features list', 'script', NULL),
(779, 'btnAddFeature', 'backend', 'Button / + Add feature', 'script', NULL),
(780, 'lblFeature', 'backend', 'Label / Feature', 'script', NULL),
(781, 'infoAddFeatureTitle', 'backend', 'Infobox / Add feature', 'script', NULL),
(782, 'infoAddFeatureDesc', 'backend', 'Infobox / Add feature', 'script', NULL),
(783, 'infoUpdateFeatureTitle', 'backend', 'Infobox / Update feature', 'script', NULL),
(784, 'infoUpdateFeatureDesc', 'backend', 'Infobox / Update feature', 'script', NULL),
(785, 'lblFeatureDuplicated', 'backend', 'Label / Feature name was already used.', 'script', NULL),
(948, 'infoPetsDesc', 'backend', 'Infobox / Pets list', 'script', NULL),
(949, 'btnAddPet', 'backend', 'Button / + Add pet', 'script', NULL),
(950, 'lblRefID', 'backend', 'Label / Ref ID', 'script', NULL),
(951, 'lblReferenceID', 'backend', 'Label / Reference ID', 'script', NULL),
(952, 'lblReferenceIdDuplicated', 'backend', 'Label / Reference ID was already used.', 'script', NULL),
(953, 'infoAddPetTitle', 'backend', 'Infobox / Add pet', 'script', NULL),
(954, 'infoAddPetDesc', 'backend', 'Infobox / Add pet', 'script', NULL),
(955, 'error_titles_ARRAY_AL01', 'arrays', 'error_titles_ARRAY_AL01', 'script', NULL),
(956, 'error_bodies_ARRAY_AL01', 'arrays', 'error_bodies_ARRAY_AL01', 'script', NULL),
(957, 'error_titles_ARRAY_AL03', 'arrays', 'error_titles_ARRAY_AL03', 'script', NULL),
(958, 'error_bodies_ARRAY_AL03', 'arrays', 'error_bodies_ARRAY_AL03', 'script', NULL),
(959, 'error_titles_ARRAY_AL04', 'arrays', 'error_titles_ARRAY_AL04', 'script', NULL),
(960, 'error_bodies_ARRAY_AL04', 'arrays', 'error_bodies_ARRAY_AL04', 'script', NULL),
(961, 'error_titles_ARRAY_AL08', 'arrays', 'error_titles_ARRAY_AL08', 'script', NULL),
(962, 'error_bodies_ARRAY_AL08', 'arrays', 'error_bodies_ARRAY_AL08', 'script', NULL),
(963, 'lblPet', 'backend', 'Label / Pet', 'script', NULL),
(964, 'lblNotYet', 'backend', 'Label / N/A', 'script', NULL),
(965, 'tabSummary', 'backend', 'Tab / Summary', 'script', NULL),
(966, 'tabDetails', 'backend', 'Tab / Details', 'script', NULL),
(967, 'tabPetDetails', 'backend', 'Tab / Pet details', 'script', NULL),
(968, 'tabPhotos', 'backend', 'Tab / Photos', 'script', NULL),
(969, 'tabOwner', 'backend', 'Tab / Owner', 'script', NULL),
(970, 'tabAddress', 'backend', 'Tab / Address', 'script', NULL),
(971, 'lblCreatedOn', 'backend', 'Label / Created on', 'script', NULL),
(972, 'lblModifiedOn', 'backend', 'Label / Modified on', 'script', NULL),
(973, 'lblViews', 'backend', 'Label / Views', 'script', NULL),
(974, 'error_titles_ARRAY_AL41', 'arrays', 'error_titles_ARRAY_AL41', 'script', NULL),
(975, 'error_bodies_ARRAY_AL41', 'arrays', 'error_bodies_ARRAY_AL41', 'script', NULL),
(976, 'infoListingDetailsTitle', 'backend', 'Infobox / Details', 'script', NULL),
(977, 'infoListingDetailsDesc', 'backend', 'Infobox / Details', 'script', NULL),
(978, 'lblListingTitle', 'backend', 'Lable / Title', 'script', NULL),
(979, 'lblDescription', 'backend', 'Lable / Description', 'script', NULL),
(980, 'infoListingExtrasTitle', 'backend', 'Infobox / Pet details', 'script', NULL),
(981, 'infoListingExtrasDesc', 'backend', 'Infobox / Please check any following details below to describe more about the pet.', 'script', NULL),
(982, 'lblYearOfBirth', 'backend', 'Lable / Year of birth', 'script', NULL),
(983, 'lblPrice', 'backend', 'Lable / Price', 'script', NULL),
(984, 'infoListingOwnerTitle', 'backend', 'Infobox / Owner contact', 'script', NULL),
(985, 'infoListingOwnerDesc', 'backend', 'Infobox / Owner contact', 'script', NULL),
(986, 'infoListingAddressTitle', 'backend', 'Infobox / Address', 'script', NULL),
(987, 'infoListingAddressDesc', 'backend', 'Infobox / Address', 'script', NULL),
(988, 'lblListingName', 'backend', 'Lable / Name', 'script', NULL),
(989, 'lblListingEmail', 'backend', 'Lable / Email', 'script', NULL),
(990, 'lblListingPhone', 'backend', 'Lable / Phone', 'script', NULL),
(991, 'lblListingFax', 'backend', 'Lable / Fax', 'script', NULL),
(992, 'lblListingUrl', 'backend', 'Lable / URL', 'script', NULL),
(993, 'lblListingAddress', 'backend', 'Lable / Address', 'script', NULL),
(994, 'lblListingCity', 'backend', 'Lable / City', 'script', NULL),
(995, 'lblListingState', 'backend', 'Lable / State', 'script', NULL),
(996, 'lblListingZip', 'backend', 'Lable / Zip', 'script', NULL),
(997, 'lblListingCountry', 'backend', 'Lable / Country', 'script', NULL),
(998, 'infoPetsTitle', 'backend', 'Infobox / Pets list', 'script', NULL),
(999, 'front_menu_home', 'frontend', 'Menu / Home', 'script', NULL),
(1000, 'front_menu_search', 'frontend', 'Menu / Search', 'script', NULL),
(1001, 'front_no_pets_found', 'frontend', 'Label / No pets found.', 'script', NULL),
(1002, 'front_prev', 'frontend', 'Label / Prev', 'script', NULL),
(1003, 'front_next', 'frontend', 'Label / Next', 'script', NULL),
(1004, 'front_type', 'frontend', 'Label / Type', 'script', NULL),
(1005, 'front_all', 'frontend', 'Label / All', 'script', NULL),
(1006, 'front_breed', 'frontend', 'Label / Breed', 'script', NULL),
(1007, 'front_age', 'frontend', 'Label / Age', 'script', NULL),
(1008, 'front_reference_id', 'frontend', 'Label / Reference ID', 'script', NULL),
(1009, 'front_year_of_birth', 'frontend', 'Label / Year of birth', 'script', NULL),
(1010, 'front_to', 'frontend', 'Label / to', 'script', NULL),
(1011, 'front_btn_search', 'frontend', 'Button / Search', 'script', NULL),
(1012, 'front_menu_back', 'frontend', 'Menu / Back', 'script', NULL),
(1013, 'front_pet_disabled', 'frontend', 'Label / The pet was disabled.', 'script', NULL),
(1014, 'front_pet_not_exist', 'frontend', 'Label / Pet with such ID does not exist.', 'script', NULL),
(1015, 'front_price', 'frontend', 'Label / Price', 'script', NULL),
(1016, 'front_feature_set', 'frontend', 'Label / Feature set', 'script', NULL),
(1017, 'front_pet_description', 'frontend', 'Label / Pet Description', 'script', NULL),
(1018, 'front_contact_details', 'frontend', 'Label / Contact Details', 'script', NULL),
(1019, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(1020, 'front_email', 'frontend', 'Label / Email', 'script', NULL),
(1021, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(1022, 'front_fax', 'frontend', 'Label / Fax', 'script', NULL),
(1023, 'front_website', 'frontend', 'Label / Website', 'script', NULL),
(1024, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(1025, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(1026, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(1027, 'front_postcode', 'frontend', 'Label / Post code', 'script', NULL),
(1028, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(1029, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(1030, 'lblFrom', 'backend', 'Label / From', 'script', NULL),
(1031, 'lblTo', 'backend', 'Label / To', 'script', NULL);

INSERT INTO `petlisting_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjBreed', 1, 'name', 'Pit Bull', 'data'),
(NULL, 2, 'pjBreed', 1, 'name', 'Jack Russell Terrier', 'data'),
(NULL, 3, 'pjBreed', 1, 'name', 'Beagle', 'data'),
(NULL, 4, 'pjBreed', 1, 'name', 'Bulldog', 'data'),
(NULL, 5, 'pjBreed', 1, 'name', 'Dalmatian', 'data'),
(NULL, 6, 'pjBreed', 1, 'name', 'Pinscher', 'data'),
(NULL, 7, 'pjBreed', 1, 'name', 'Setter', 'data'),
(NULL, 8, 'pjBreed', 1, 'name', 'Retriever', 'data'),
(NULL, 9, 'pjBreed', 1, 'name', 'Chihuahua', 'data'),
(NULL, 10, 'pjBreed', 1, 'name', 'Laika', 'data'),
(NULL, 11, 'pjBreed', 1, 'name', 'Mastiff', 'data'),
(NULL, 12, 'pjBreed', 1, 'name', 'Rottweiler', 'data'),
(NULL, 13, 'pjBreed', 1, 'name', 'Newfoundland', 'data'),
(NULL, 14, 'pjBreed', 1, 'name', 'Farm collie', 'data'),
(NULL, 15, 'pjBreed', 1, 'name', 'German Spitz', 'data'),
(NULL, 16, 'pjBreed', 1, 'name', 'Persian', 'data'),
(NULL, 17, 'pjBreed', 1, 'name', 'Singapura', 'data'),
(NULL, 18, 'pjBreed', 1, 'name', 'British Giant', 'data'),
(NULL, 19, 'pjBreed', 1, 'name', 'Cashmere', 'data'),
(NULL, 20, 'pjBreed', 1, 'name', 'Gouldian Finch', 'data'),
(NULL, 21, 'pjBreed', 1, 'name', 'Orange Cheeked Waxbill', 'data'),
(NULL, 22, 'pjBreed', 1, 'name', 'American Cream Draft', 'data'),
(NULL, 23, 'pjBreed', 1, 'name', 'American Paint Horse', 'data'),
(NULL, 24, 'pjBreed', 1, 'name', 'Australian Draught Horse', 'data'),
(NULL, 25, 'pjBreed', 1, 'name', 'Byelorussian Harness', 'data'),
(NULL, 26, 'pjBreed', 1, 'name', 'Arabian horse', 'data'),
(NULL, 27, 'pjBreed', 1, 'name', 'Python', 'data'),
(NULL, 28, 'pjBreed', 1, 'name', 'Boa', 'data'),
(NULL, 29, 'pjBreed', 1, 'name', 'Turtle', 'data'),
(NULL, 30, 'pjBreed', 1, 'name', 'Lizard', 'data'),
(NULL, 31, 'pjBreed', 1, 'name', 'Frog', 'data'),
(NULL, 1, 'pjExtra', 1, 'name', 'Companion dogs', 'data'),
(NULL, 2, 'pjExtra', 1, 'name', 'Guard dogs', 'data'),
(NULL, 3, 'pjExtra', 1, 'name', 'Hunting dogs', 'data'),
(NULL, 4, 'pjExtra', 1, 'name', 'Working dogs', 'data'),
(NULL, 5, 'pjExtra', 1, 'name', 'Pastoral dogs', 'data'),
(NULL, 6, 'pjExtra', 1, 'name', 'Pariah dogs', 'data'),
(NULL, 7, 'pjExtra', 1, 'name', 'Sled dogs', 'data'),
(NULL, 1, 'pjFeature', 1, 'name', 'Male', 'data'),
(NULL, 2, 'pjFeature', 1, 'name', 'Female', 'data'),
(NULL, 3, 'pjFeature', 1, 'name', 'Baby', 'data'),
(NULL, 4, 'pjFeature', 1, 'name', 'Young', 'data'),
(NULL, 5, 'pjFeature', 1, 'name', 'Adult', 'data'),
(NULL, 6, 'pjFeature', 1, 'name', 'Senior', 'data'),
(NULL, 7, 'pjFeature', 1, 'name', 'Small', 'data'),
(NULL, 8, 'pjFeature', 1, 'name', 'Medium', 'data'),
(NULL, 9, 'pjFeature', 1, 'name', 'Large', 'data'),
(NULL, 10, 'pjFeature', 1, 'name', 'Black', 'data'),
(NULL, 11, 'pjFeature', 1, 'name', 'White', 'data'),
(NULL, 12, 'pjFeature', 1, 'name', 'Brown', 'data'),
(NULL, 13, 'pjFeature', 1, 'name', 'Gold', 'data'),
(NULL, 14, 'pjFeature', 1, 'name', 'Grey', 'data'),
(NULL, 15, 'pjFeature', 1, 'name', 'Green', 'data'),
(NULL, 16, 'pjFeature', 1, 'name', 'Blue', 'data'),
(NULL, 17, 'pjFeature', 1, 'name', 'Red', 'data'),
(NULL, 18, 'pjFeature', 1, 'name', 'Yellow', 'data'),
(NULL, 19, 'pjFeature', 1, 'name', 'Magenta', 'data'),
(NULL, 20, 'pjFeature', 1, 'name', 'Cyan', 'data'),
(NULL, 21, 'pjFeature', 1, 'name', 'Navy', 'data'),
(NULL, 22, 'pjFeature', 1, 'name', 'Olive', 'data'),
(NULL, 23, 'pjFeature', 1, 'name', 'Purple', 'data'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next ', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Below you can see all users who have access to the Pet Listing admin panel. There are two types of users - Administrators and Editors. Click on "+ Add user" to add a new user.', 'script'),
(NULL, 482, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'You can add a new Administrator who has full access to the back-end system and can add other users; or an Editor who will only be able to access the Floor plans.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'You can make any change to the form below. Just click "Save" to update the user information.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Here you can set the General options for the Pet Listing system.', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Pets', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Editor', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Listing', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'SEO', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Follow these steps to put Pet Listing on your .php web page using PHP include code:', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'Enter web address for the web page where listing is put', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'Step 2. Copy and paste the code below into your html code, where the listing will be displayed.', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your pets.', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'Create a file named ".htaccess" in the same directory where your .php page with listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 690, 'pjField', 1, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Preview front end', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use.', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'Choose theme', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'List of pet types', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'Below is the list of pet types defined. If you want to add more pet type, click on the button "+ Add pet type".', 'script'),
(NULL, 708, 'pjField', 1, 'title', '+ Add pet type', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'Pet type', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'Pet types', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'Pet breeds', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'Pet details', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'Features', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'Pet type updated!', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'Pet type name has been updated.', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'Pet type added!', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'Pet type has been added into the system.', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'Pet type not added!', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'Pet type could not be added. Please try again.', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'Pet type not found!', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Pet type you are looking for is missing.', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'Add pet type', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'Fill in the pet type name and click "Save" button to add new pet type.', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'Pet type name is already used.', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'Update pet type', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'You can change the pet type name as you want and click "Save" button to update it.', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'Pet breeds list', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'Below is the list of pet breeds defined. If you want to add new pet breed, click on the button "+ Add pet breed".', 'script'),
(NULL, 731, 'pjField', 1, 'title', '+ Add pet breed', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'Breed', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'Pet breed updated!', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'Changes made on the pet breed have been saved.', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'Pet breed added!', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'Pet breed has been added into the system.', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'Pet breed not added!', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'Pet breed could not be added. Please try again.', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'Pet breed not found!', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'Pet breed you are looking for is missing.', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'Pet breed name was already used.', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'Pet breed', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'Add pet breed', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'Enter pet breed name and the type it belongs to and then click "Save" button to add new pet breed.', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'Update pet breed', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'You can make any changes on the form below and click on "Save" button to update pet breed information.', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'Pet details list', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'Below is the list of pet details defined. If you want to add new pet detail, click on the button "+ Add pet detail".', 'script'),
(NULL, 750, 'pjField', 1, 'title', '+ Add pet detail', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'Pet detail', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'Pet detail was already used.', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'Add pet detail', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'Please enter pet detail name and click "Save" button to add new pet detail.', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'Update pet detail', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'You can change the pet detail on the form below and click "Save" button.', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'Pet detail updated!', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'Changes made on pet details have been saved.', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'Pet detail added!', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'Pet detail has been added into the system.', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'Pet detail not added!', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'Pet detail has not been added. Please try again.', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Pet detail not found!', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'Pet detail you are looking for is missing.', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Age', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'Color', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'Sex', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'Size', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'Feature updated!', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'Changes made on the feature have been saved.', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'Feature added!', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'Feature has been added into the system.', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'Feature not added!', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'Feature could not be added. Please try again.', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'Feature not found!', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'Feature you are looking for is missing.', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'Features list', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'Below is the list of features defined. If you want to add more feature, click on the button "+ Add feature".', 'script'),
(NULL, 779, 'pjField', 1, 'title', '+ Add feature', 'script'),
(NULL, 780, 'pjField', 1, 'title', 'Feature', 'script'),
(NULL, 781, 'pjField', 1, 'title', 'Add feature', 'script'),
(NULL, 782, 'pjField', 1, 'title', 'Please enter feature name and click "Save" button to add new feature.', 'script'),
(NULL, 783, 'pjField', 1, 'title', 'Update feature', 'script'),
(NULL, 784, 'pjField', 1, 'title', 'You can make changes on the form below and click "Save" button to update feature information.', 'script'),
(NULL, 785, 'pjField', 1, 'title', 'Feature name was already used.', 'script'),
(NULL, 948, 'pjField', 1, 'title', 'Below you can see all pets added to the system. You can add new pet by click on the button "+ Add pet".', 'script'),
(NULL, 949, 'pjField', 1, 'title', '+ Add pet', 'script'),
(NULL, 950, 'pjField', 1, 'title', 'Ref ID', 'script'),
(NULL, 951, 'pjField', 1, 'title', 'Reference ID', 'script'),
(NULL, 952, 'pjField', 1, 'title', 'Reference ID was already used.', 'script'),
(NULL, 953, 'pjField', 1, 'title', 'Add Pet', 'script'),
(NULL, 954, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new pet. You can edit Pet Types and Breeds under Options page.', 'script'),
(NULL, 955, 'pjField', 1, 'title', 'Pet updated!', 'script'),
(NULL, 956, 'pjField', 1, 'title', 'All changes made on the pet have been saved.', 'script'),
(NULL, 957, 'pjField', 1, 'title', 'Pet added!', 'script'),
(NULL, 958, 'pjField', 1, 'title', 'Pet has been added into the system.', 'script'),
(NULL, 959, 'pjField', 1, 'title', 'Pet not added!', 'script'),
(NULL, 960, 'pjField', 1, 'title', 'Pet could not be added. Please try again.', 'script'),
(NULL, 961, 'pjField', 1, 'title', 'Pet not found!', 'script'),
(NULL, 962, 'pjField', 1, 'title', 'Pet you are looking for is missing.', 'script'),
(NULL, 963, 'pjField', 1, 'title', 'Pet', 'script'),
(NULL, 964, 'pjField', 1, 'title', 'N/A', 'script'),
(NULL, 965, 'pjField', 1, 'title', 'Summary', 'script'),
(NULL, 966, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 967, 'pjField', 1, 'title', 'Pet details', 'script'),
(NULL, 968, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 969, 'pjField', 1, 'title', 'Owner', 'script'),
(NULL, 970, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 971, 'pjField', 1, 'title', 'Created on', 'script'),
(NULL, 972, 'pjField', 1, 'title', 'Modified on', 'script'),
(NULL, 973, 'pjField', 1, 'title', 'Views', 'script'),
(NULL, 974, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 975, 'pjField', 1, 'title', 'Upload as many images as you want for this pet. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 976, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 977, 'pjField', 1, 'title', 'Enter general pet information using the form below.', 'script'),
(NULL, 978, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 979, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 980, 'pjField', 1, 'title', 'Pet details', 'script'),
(NULL, 981, 'pjField', 1, 'title', 'Please check any following details below to describe more about the pet.', 'script'),
(NULL, 982, 'pjField', 1, 'title', 'Year of birth', 'script'),
(NULL, 983, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 984, 'pjField', 1, 'title', 'Owner contact', 'script'),
(NULL, 985, 'pjField', 1, 'title', 'Fill in the fields below to provide owner information of the pet.', 'script'),
(NULL, 986, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 987, 'pjField', 1, 'title', 'Enter the address details for the pet.', 'script'),
(NULL, 988, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 989, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 990, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 991, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 992, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 993, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 994, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 995, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 996, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 997, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 998, 'pjField', 1, 'title', 'Pets', 'script'),
(NULL, 999, 'pjField', 1, 'title', 'Home', 'script'),
(NULL, 1000, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 1001, 'pjField', 1, 'title', 'No pets found.', 'script'),
(NULL, 1002, 'pjField', 1, 'title', 'Prev', 'script'),
(NULL, 1003, 'pjField', 1, 'title', 'Next', 'script'),
(NULL, 1004, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 1005, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 1006, 'pjField', 1, 'title', 'Breed', 'script'),
(NULL, 1007, 'pjField', 1, 'title', 'Age', 'script'),
(NULL, 1008, 'pjField', 1, 'title', 'Reference ID', 'script'),
(NULL, 1009, 'pjField', 1, 'title', 'Year of birth', 'script'),
(NULL, 1010, 'pjField', 1, 'title', 'to', 'script'),
(NULL, 1011, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 1012, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 1013, 'pjField', 1, 'title', 'The pet was disabled.', 'script'),
(NULL, 1014, 'pjField', 1, 'title', 'Pet with such ID does not exist.', 'script'),
(NULL, 1015, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1016, 'pjField', 1, 'title', 'Feature set', 'script'),
(NULL, 1017, 'pjField', 1, 'title', 'Pet Description', 'script'),
(NULL, 1018, 'pjField', 1, 'title', 'Contact Details', 'script'),
(NULL, 1019, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1020, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1021, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1022, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 1023, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 1024, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1025, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1026, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 1027, 'pjField', 1, 'title', 'Post code', 'script'),
(NULL, 1028, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1029, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 1030, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 1031, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 1, 'pjType', 1, 'name', 'Dog', 'data'),
(NULL, 2, 'pjType', 1, 'name', 'Cat', 'data'),
(NULL, 3, 'pjType', 1, 'name', 'Rabbit', 'data'),
(NULL, 4, 'pjType', 1, 'name', 'Bird', 'data'),
(NULL, 5, 'pjType', 1, 'name', 'Horse', 'data'),
(NULL, 6, 'pjType', 1, 'name', 'Reptile', 'data');

INSERT INTO `petlisting_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_currency', 1, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 2, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 3, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 0, NULL),
(1, 'o_per_page', 1, '10', NULL, 'int', 6, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 7, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 8, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 10, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 11, 1, NULL),

(1, 'o_theme', 99, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', NULL, 0, NULL),
(1, 'o_listing_page', 99, 'preview.php', NULL, 'string', NULL, 0, NULL),
(1, 'o_seo_url', 99, 'Yes|No::No', NULL, 'enum', NULL, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::1', 'Yes|No', 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `petlisting_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

COMMIT;