<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	pjUtil::printNotice(__('infoPetsTitle', true), __('infoPetsDesc', true));
	?>
	<div class="b10">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
			<input type="hidden" name="controller" value="pjAdminListings" />
			<input type="hidden" name="action" value="pjActionCreate" />
			<input type="submit" class="pj-button" value="<?php __('btnAddPet'); ?>" />
		</form>
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			<button type="button" class="pj-button pj-button-detailed"><span class="pj-button-detailed-arrow"></span></button>
		</form>
		<?php
		$filter = __('filter', true);
		?>
		<div class="float_right t5">
			<a href="#" class="pj-button btn-all"><?php __('lblAll');?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="T"><?php echo $filter['active']; ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="F"><?php echo $filter['inactive']; ?></a>
		</div>
		<br class="clear_both" />
	</div>
		
	<div class="pj-form-filter-advanced" style="display: none">
		<span class="pj-menu-list-arrow"></span>
		<form action="" method="get" class="form pj-form pj-form-search frm-filter-advanced">
			<div class="overflow float_left w350">
				<p>
					<label class="title120"><?php __('lblReferenceID'); ?></label>
					<input type="text" name="listing_refid" id="listing_refid" class="pj-form-field w186" />
				</p>
				<p>
					<label class="title120"><?php __('lblType'); ?></label>
					<span class="inline_block">
						<select name="type_id" id="type_id" class="pj-form-field w200">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['type_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['name']); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title120"><?php __('lblBreed'); ?></label>
					<span id="pjPlBreedSelector" class="inline_block">
						<select name="breed_id" id="breed_id" class="pj-form-field w200">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
						</select>
					</span>
				</p>
				<p>
					<label class="title120"><?php __('lblYearOfBirth'); ?></label>
					<span class="inline_block">
						<select name="year_from" id="year_from" class="pj-form-field w100">
							<option value="">-- <?php __('lblFrom'); ?>--</option>
							<?php
							for($i = date('Y'); $i >= date('Y') - 50; $i-- )
							{
								?>
								<option value="<?php echo $i?>"><?php echo $i?></option>
								<?php
							}	 
							?>
						</select>
						<select name="year_to" id="year_to" class="pj-form-field w100">
							<option value="">-- <?php __('lblTo'); ?>--</option>
							<?php
							for($i = date('Y'); $i >= date('Y') - 50; $i-- )
							{
								?>
								<option value="<?php echo $i?>"><?php echo $i?></option>
								<?php
							}	 
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title120">&nbsp;</label>
					<input type="submit" value="<?php __('btnSearch'); ?>" class="pj-button" />
					<input type="reset" value="<?php __('btnCancel'); ?>" class="pj-button" />
				</p>
			</div>
			<div class="overflow w350">
				<?php
				foreach(__('feature_types', true) as $k => $v)
				{
					$feature_arr = $tpl['feature_arr'][$k];
					if(isset($feature_arr) && count($feature_arr))
					{
						?>
						<p>
							<label class="title120"><?php echo $v; ?></label>
							<span class="inline_block">
								<select name="feature_<?php echo $k;?>_id" id="feature_<?php echo $k;?>_id" class="pj-form-field w150" data-msg-required="<?php __('lblFieldRequired');?>">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach($feature_arr as $feature)
									{
										?>
										<option value="<?php echo $feature['id'];?>"<?php echo $tpl['arr']['feature_' . $k . '_id'] == $feature['id'] ? ' selected="selected"' : null; ?>><?php echo $feature['name'];?></option>
										<?php
									}	 
									?>
								</select>
							</span>
						</p>
						<?php
					}
				} 
				?>
			</div>
			<div class="clear_both"></div>
		</form>
	</div>

	<div id="grid"></div>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	var myLabel = myLabel || {};
	myLabel.image = "<?php __('lblImage'); ?>";
	myLabel.ref_id = "<?php __('lblRefID'); ?>";
	myLabel.breed = "<?php __('lblBreed'); ?>";
	myLabel.type = "<?php __('lblType'); ?>";
	myLabel.active = "<?php echo $filter['active']; ?>";
	myLabel.inactive = "<?php echo $filter['inactive']; ?>";
	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
	myLabel.status = "<?php __('lblStatus'); ?>";
	</script>
	<?php
}
?>