<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{
	public $defaultCaptcha = 'StivaSoftCaptcha';
	
	public $defaultTime = 'VRentals_Time';
	
	public $defaultTheme = 'front_theme_id';
	
	public $defaultBackUrl = 'front_back_url';
	
	protected $locales = array();
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
	}
	
	public function afterFilter()
	{
		$theme = $this->getTheme();
		if($theme == false)
		{
			$theme = $this->option_arr['o_theme'];
		}
		
		$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
		
		$this->appendCss('pj.bootstrap.min.css', PJ_FRAMEWORK_LIBS_PATH . 'pj/css/');
		$this->appendCss('font-awesome.min.css', PJ_TEMPLATE_PATH . PJ_TEMPLATE_SCRIPT_PATH . 'css/');
		$this->appendCss('jquery-ui.custom.min.css', PJ_INSTALL_URL . $dm->getPath('pj_jquery_ui') . 'css/smoothness/', true);
		$this->appendCss('style.css', PJ_TEMPLATE_PATH . PJ_TEMPLATE_SCRIPT_PATH . 'css/');
		$this->appendCss($theme . '.css', PJ_TEMPLATE_PATH . PJ_TEMPLATE_SCRIPT_PATH . 'css/');
	}
	
	public function beforeFilter()
	{
		if (!isset($this->defaultTime))
		{
			$this->defaultTime = time();
		}
		$force_load = false;
		$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file, t2.title')
			->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left outer')
			->where('t2.file IS NOT NULL')
			->orderBy('t1.sort ASC')->findAll()->getDataPair('id');
		
		$this->set('locale_arr', $locale_arr);
		
		foreach ($locale_arr as $locale)
		{
			$this->locales[$locale['language_iso']] = $locale['id'];
		}
		
		if (isset($_GET['params'], $_GET['params']['locale']) && in_array($_GET['params']['locale'], $this->locales))
		{
			if($_GET['params']['locale'] != $this->getLocaleId())
			{
				$force_load = true;
			}
			$this->setLocaleId($_GET['params']['locale']);
		}
		
		if (isset($_GET['language']) && array_key_exists($_GET['language'], $this->locales))
		{
			$this->setLocaleId($this->locales[$_GET['language']]);
		}
		
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();
		
		if(isset($_GET['theme']))
		{
			$this->setTheme($_GET['theme']);
		}
		
		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		
		if (!in_array($_GET['action'], array('pjActionLoadCss')))
		{
			if($force_load == true)
			{
				$this->loadSetFields(true);
			}else{
				$this->loadSetFields();
			}
		}
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		$this->setLayout('pjActionEmpty');
		
		header("Cache-Control: max-age=3600, private");
		
		$Captcha = new pjCaptcha(PJ_WEB_PATH . 'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH . 'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}
	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		if (!isset($_GET['verification']) || empty($_GET['verification']) || !pjCaptcha::validate($_GET['verification'], $_SESSION[$this->defaultCaptcha])){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	public function pjActionSetLocale()
	{
		$this->setLocaleId(@$_GET['locale']);
		$this->loadSetFields(true);
		$referer = $_SERVER['HTTP_REFERER'];
		if ($this->option_arr['o_lang_store'] == 'url')
		{
			$referer = preg_replace('/(&language=)([a-z]{2})/', '$1' . $this->getLanguage(), $referer);
		}
		
		pjUtil::redirect($referer);
	}
	
	public function getLanguage()
    {
    	$language = array_search($this->getLocaleId(), $this->locales);
    	
    	return $language !== FALSE ? $language : 'gb';
    }
}
?>