<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjDrawSearch extends pjDrawSearchAppController
{
	public function beforeFilter()
	{
		switch ($_GET['action'])
		{
			case 'pjActionConfig':
				parent::beforeFilter();
				break;
			default:
				//do nothing, just override the parent's one
				break;
		}
	}
	
	public function pjActionControl()
	{
		$this->setAjax(true);
		$this->setLayout('pjActionEmpty');
		//strokeColor
		//fillColor
		//zoom
		//lat
		//lng
		//form_id
		//field_name
		//markers (Array with indexes: lat, lng, title, content. Optional indexes: clickable, icon, shadow)
		$params = $this->getParams();
		if (!isset($params['lat']) || !isset($params['lng']) || !isset($params['zoom']))
		{
			$arr = pjDrawSearchModel::factory()->find(1)->getData();
			if (!empty($arr))
			{
				$params['lat'] = $arr['lat'];
				$params['lng'] = $arr['lng'];
				$params['zoom'] = (int) $arr['zoom'];
			}
		}
		$option_arr = pjOptionModel::factory()->getPairs($this->getForeignId());
		$api_key_str = isset($option_arr['o_google_map_api']) && !empty($option_arr['o_google_map_api']) ? 'key=' . $option_arr['o_google_map_api'] . '&' : '';
		$this->set('arr', $params);
		$this->set('api_key_str', $api_key_str);
	}
	
	public function pjActionConfig()
	{
		$this->checkLogin();
		
		if (!$this->isDrawSearchReady())
		{
			$this->set('status', 2);
			return;
		}
		
		if (isset($_POST['config_post']))
		{
			pjDrawSearchModel::factory()->set('id', 1)->modify($_POST);
			pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjDrawSearch&action=pjActionConfig&err=PDS01");
		}
		$this->set('store_data', pjDrawSearchModel::factory()->find(1)->getData());
		$option_arr = pjOptionModel::factory()->getPairs($this->getForeignId());
		$api_key_str = isset($option_arr['o_google_map_api']) && !empty($option_arr['o_google_map_api']) ? 'key=' . $option_arr['o_google_map_api'] . '&' : '';
		$this->appendJs('', '//maps.googleapis.com/maps/api/js?'.$api_key_str.'libraries=places&region=uk&language=en', true);
		$this->appendJs('pjDrawConfig.js', $this->getConst('PLUGIN_JS_PATH'));
	}
}
?>