var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		
		var map, marker,
			$form = $("#pjDrawSearchForm"),
			$lat = $form.find("input[name='lat']"),
			$lng = $form.find("input[name='lng']"),
			$zoom = $form.find("input[name='zoom']"),
			myLat = parseFloat($lat.val()),
			myLng = parseFloat($lng.val()),
			myZoom = parseInt($zoom.val(), 10),
			input = $('input[name="address"]').get(0),         
	    	autocomplete = new google.maps.places.Autocomplete(input, {
	    		types: ["geocode"]
	    	});
	    
		if ($form.length) {
			$form.on("keypress", function(e) {
				var code = e.keyCode || e.which; 
				if (code == 13) {
					var $focused = $(':focus');
					if ($focused.length && $focused.attr('name') === 'address') {
						if (e && e.preventDefault) {
							e.preventDefault();
						}
						return false;
					}
				}
			});
		}
		
	    google.maps.event.addListener(autocomplete, 'place_changed', function() {
	    	var place = autocomplete.getPlace();
	    	
	    	$lat.val(place.geometry.location.lat());
	    	$lng.val(place.geometry.location.lng());
	    	
	    	myLat = parseFloat($lat.val()),
			myLng = parseFloat($lng.val()),
			
	    	pjDrawSearchInit();
	    });
		
		function pjDrawSearchInit() {
			var mapOptions = {
				zoom: myZoom,
	            center: new google.maps.LatLng(myLat, myLng),
	            mapTypeId: google.maps.MapTypeId.ROADMAP
			};
			map = new google.maps.Map(document.getElementById("drawSearchCanvas"), mapOptions);
			
			marker = new google.maps.Marker({
				map: map,
				draggable: true,
				position: new google.maps.LatLng(myLat, myLng)
			});
			
			google.maps.event.addListener(marker, "dragend", function () {
				var point = marker.getPosition();
				map.panTo(point);
				$lat.val(point.lat().toFixed(6));
				$lng.val(point.lng().toFixed(6));
			});
			
			google.maps.event.addListener(map, "zoom_changed", function () {
				$zoom.val(map.getZoom());
			});
		}
		
		pjDrawSearchInit();
		
	});
})(jQuery_1_8_2);